/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.util.Arrays;

public class FilterTreeWrapper {
    public static final int NORMAL_TYPE = 1;
    public static final int GROUP_TYPE = 2;
    public static final int NAV_GROUP_TYPE = 2;
    private long fabricId = -1L;
    private boolean licensed = true;
    private String fabricName = null;
    private long vsanId = -1L;
    private long vid = -1L;
    private String vsanName = null;
    private String tooltip = null;
    private String vsanIndexSwitchWWN = "";
    private int fid = -1;
    private int nodeType = 1;
    private int dTreeId = 0;
    private long[] fabricIdArray;
    private long[] vsanIdArray;
    private int[] fidArr;
    private long[] vidArr;
    private String[] fabricNameArray;
    private String[] vsanNameArray;
    private String[] visWArray;
    private long groupId;
    private int groupType;
    private String groupName;
    private long navGroupId;
    private int navGroupType;
    private String navGroupName;

    public FilterTreeWrapper() {
    }

    public FilterTreeWrapper(int fabricId) {
        this.fabricId = fabricId;
    }

    public long getFabricId() {
        return this.fabricId;
    }

    public void setFabricId(long fabricId) {
        this.fabricId = fabricId;
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public long getVid() {
        return this.vid;
    }

    public void setVid(long vid) {
        this.vid = vid;
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    public void setLicensed(boolean licensed) {
        this.licensed = licensed;
    }

    public void setFabricName(String fabricName) {
        this.fabricName = fabricName;
    }

    public long getVsanId() {
        return this.vsanId;
    }

    public void setVsanId(long vsanId) {
        this.vsanId = vsanId;
    }

    public String getVsanName() {
        return this.vsanName;
    }

    public void setVsanName(String vsanName) {
        this.vsanName = vsanName;
    }

    public String getPathId() {
        if (this.vsanId != -1L) {
            return this.vsanId + "";
        }
        if (this.fabricId != -1L) {
            return this.fabricId + "";
        }
        return this.dTreeId + "";
    }

    public String getPathName() {
        return this.getPathName(true);
    }

    public String getPathName(boolean addEnd) {
        String str = "";
        if (this.fabricId != -1L) {
            str = str + (this.fabricId == -2L ? Arrays.toString(this.fabricNameArray) : (this.fabricName != null ? this.fabricName : "Fabric:" + this.fabricId) + " > ");
            if (this.groupId > 0L) {
                str = str + " Group " + ReportUtil.getGroupName(this.groupId) + " ";
            }
        } else if (this.navGroupId > 0L) {
            str = str + " Group " + NavigationUtil.getInstance().getGroupName(this.navGroupId) + " ";
        } else {
            String title;
            switch (this.dTreeId) {
                case 0: {
                    title = "Data Center";
                    break;
                }
                case 1: {
                    title = "SAN";
                    break;
                }
                case 2: {
                    title = "LAN";
                    break;
                }
                default: {
                    title = "Data Center";
                }
            }
            return addEnd ? title + " > " : title;
        }
        if (this.vsanId != -1L) {
            str = str + (this.vsanId == -2L ? Arrays.toString(this.vsanNameArray) : (this.vsanName != null ? this.vsanName : "vsanName:" + this.vsanId) + " > ");
        }
        if (!addEnd && str.lastIndexOf(">") == str.length() - 1) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public boolean isGroupNode() {
        return this.nodeType == 2;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
    }

    public String getVsanIndexSwitchWWN() {
        return this.vsanIndexSwitchWWN;
    }

    public void setVsanIndexSwitchWWN(String vsanIndexSwitchWWN) {
        this.vsanIndexSwitchWWN = vsanIndexSwitchWWN == null ? "" : vsanIndexSwitchWWN;
    }

    public int getDTreeId() {
        return this.dTreeId;
    }

    public void setDTreeId(int treeId) {
        this.dTreeId = treeId;
    }

    public long[] getFabricIdArray() {
        return this.fabricIdArray;
    }

    public void setFabricIdArray(long[] fabricIdArray) {
        this.fabricIdArray = fabricIdArray;
    }

    public long[] getVsanIdArray() {
        return this.vsanIdArray;
    }

    public void setVsanIdArray(long[] vsanIdArray) {
        this.vsanIdArray = vsanIdArray;
    }

    public String[] getFabricNameArray() {
        return this.fabricNameArray;
    }

    public void setFabricNameArray(String[] fabricNameArray) {
        this.fabricNameArray = fabricNameArray;
    }

    public String[] getVsanNameArray() {
        return this.vsanNameArray;
    }

    public void setVsanNameArray(String[] vsanNameArray) {
        this.vsanNameArray = vsanNameArray;
    }

    public int[] getFidArr() {
        return this.fidArr;
    }

    public void setFidArr(int[] idArr) {
        this.fidArr = idArr;
    }

    public long[] getVidArr() {
        return this.vidArr;
    }

    public void setVidArr(long[] idArr) {
        this.vidArr = idArr;
    }

    public String[] getVisWArray() {
        return this.visWArray;
    }

    public void setVisWArray(String[] visWArray) {
        this.visWArray = visWArray;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public long getNavGroupId() {
        return this.navGroupId;
    }

    public void setNavGroupId(long navGroupId) {
        this.navGroupId = navGroupId;
    }

    public boolean isNavGroupNode() {
        return this.navGroupType == 2;
    }

    public int getNavGroupType() {
        return this.navGroupType;
    }

    public void setNavGroupType(int navGroupType) {
        this.navGroupType = navGroupType;
    }

    public String getNavGroupName() {
        return this.navGroupName;
    }

    public void setNavGroupName(String navGroupName) {
        this.navGroupName = navGroupName;
    }
}

