/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.dto.VsanNxPort;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NxPortBase
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final int TARGET = 1;
    public static final int INITIATOR = 2;
    static final int FC4_FEATURE_TARGET = 1;
    static final int FC4_FEATURE_INIT = 2;
    static final int FC4_FEATURE_FICON_CUP = 4;
    static final int FC4_FEATURE_FICON_CU = 8;
    static final int FC4_FEATURE_FICON_CH = 16;
    static final int FC4_FEATURE_VIRT_TRAP = 32;
    static final int FC4_FEATURE_VIRT_VEP = 64;
    static final int FC4_FEATURE_VIRT_VOL = 128;
    static final int FC4_FEATURE_VIRT_IPFC = 256;
    static final int FC4_FEATURE_VIRT_INT_DPP = 512;
    static final int FC4_FEATURE_VIRT_INT_CPP = 1024;
    protected final WwnKey _pkey;
    protected Wwn _nWwn;
    protected String _nodeIpAddress;
    protected NameKey _enclosurePK;
    protected String _autoAlias;
    protected Map<Integer, VsanNxPort> _vportByVid = Collections.synchronizedMap(new HashMap(2));

    public NxPortBase(WwnKey epPK, Wwn nWwn) {
        this._pkey = epPK;
        this._nWwn = nWwn;
    }

    public void sync(NxPortBase np) {
        super.sync(np);
        this._nWwn = np._nWwn;
        this._nodeIpAddress = np._nodeIpAddress;
        this._enclosurePK = np._enclosurePK;
        this._autoAlias = np._autoAlias;
        this._vportByVid = np._vportByVid;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public WwnKey getEndPortPK() {
        return this._pkey;
    }

    public boolean isMemberOfVsan(int vsanId) {
        return this.getFcId(vsanId) != 0;
    }

    public int getFcId(int vsanId) {
        VsanNxPort vnport = this._vportByVid.get(vsanId);
        return vnport != null ? vnport.getFcId() : 0;
    }

    public VsanNxPort addVsan(VsanNxPort vnport) {
        VsanNxPort oldVnport = this._vportByVid.get(vnport._pkey._vsanPK._id);
        if (!vnport.equals(oldVnport)) {
            this._vportByVid.put(Integer.valueOf(vnport._pkey._vsanPK._id), vnport);
            return oldVnport;
        }
        return vnport;
    }

    public VsanNxPort removeVsan(int vid) {
        return this._vportByVid.remove(vid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] getVsanMembership() {
        short[] vids = new short[this._vportByVid.size()];
        int i = 0;
        Map<Integer, VsanNxPort> map = this._vportByVid;
        synchronized (map) {
            for (int vid : this._vportByVid.keySet()) {
                vids[i++] = (short)vid;
            }
        }
        return vids;
    }

    public int getNumVsans() {
        return this._vportByVid.size();
    }

    public VsanPK getVsanPK(int vsanId) {
        VsanNxPort vnport = this._vportByVid.get(vsanId);
        return vnport != null ? vnport._pkey._vsanPK : null;
    }

    public VsanNxPort getVsanNxPort(int vsanId) {
        return this._vportByVid.get(vsanId);
    }

    public VsanNxPort[] getVsanNxPorts() {
        return this._vportByVid.values().toArray(new VsanNxPort[this._vportByVid.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVsanDomains(VsanNxPort[] vnports) {
        if (vnports != null) {
            Map<Integer, VsanNxPort> map = this._vportByVid;
            synchronized (map) {
                for (VsanNxPort vnport : vnports) {
                    this._vportByVid.put(vnport.getVsanId(), vnport);
                }
            }
        }
    }

    public String getVsansAsString() {
        return this._vportByVid.size() != 0 ? StringUtil.getRangeString(this.getVsanMembership()) : "n/a";
    }

    public static String getFcIdAsString(int fcIdNum) {
        String fcId = Integer.toHexString(fcIdNum);
        return (fcId.length() < 6 ? "0x0" : "0x") + fcId;
    }

    public NameKey getEnclosurePK() {
        return this._enclosurePK;
    }

    public Wwn getPortWwn() {
        return this._pkey._wwn;
    }

    public Wwn getNodeWwn() {
        return this._nWwn;
    }

    public void setNodeWwn(Wwn wwn) {
        this._nWwn = wwn;
    }

    public String getNodeIpAddress() {
        return this._nodeIpAddress;
    }

    public String setNodeIpAddress(String ipAddr) {
        String oldIp = this._nodeIpAddress;
        this._nodeIpAddress = ipAddr;
        return oldIp;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        NxPortBase ep1 = (NxPortBase)o1;
        NxPortBase ep2 = (NxPortBase)o2;
        return ep1._pkey._wwn.compare(ep1._pkey._wwn, ep2._pkey._wwn);
    }

    public void setEnclosurePK(NameKey enclosurePK) {
        this._enclosurePK = enclosurePK;
    }

    public String getAutoAlias() {
        return this._autoAlias;
    }

    public void setAutoAlias(String alias) {
        this._autoAlias = alias;
    }

    public static short[] getVsans(VsanFcIdKey[] vsanFcIds) {
        short[] vids = new short[vsanFcIds.length];
        for (int i = 0; i < vsanFcIds.length; ++i) {
            vids[i] = vsanFcIds[i]._vsanPK._id;
        }
        return vids;
    }

    public static String getVsansAsString(VsanFcIdKey[] vsanFcIds) {
        return VsanBase.getVsansAsString(NxPortBase.getVsans(vsanFcIds), vsanFcIds.length);
    }

    public static boolean isMember(VsanFcIdKey[] fcIds, VsanFcIdKey fcId) {
        if (fcIds != null) {
            for (int i = 0; i < fcIds.length; ++i) {
                if (!fcIds[i].equals(fcId)) continue;
                return true;
            }
        }
        return false;
    }
}

