/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.Arrays;

public final class ScsiTarget
extends InventoryComponent {
    static final long serialVersionUID = 1L;
    private WwnKey _pkey;
    private int _devType;
    private String _vendorId;
    private String _productId;
    private String _revLevel;
    private byte[] _otherInfo;

    public ScsiTarget(Wwn scsiName, int devType, String vendorId, String productId, String revLevel, byte[] otherInfo) {
        this._pkey = new WwnKey(scsiName);
        this._devType = devType;
        this._vendorId = vendorId;
        this._productId = productId;
        this._revLevel = revLevel;
        this._otherInfo = otherInfo;
        this._changeFlags = (byte)(this._changeFlags | 2);
        this.updateLastScanTime();
    }

    public boolean update(int devType, String vendorId, String productId, String revLevel, byte[] otherInfo) {
        this.updateLastScanTime();
        if (devType != this._devType) {
            this._devType = devType;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (vendorId != null && vendorId.length() != 0 && !vendorId.equals(this._vendorId)) {
            this._vendorId = vendorId;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (productId != null && productId.length() != 0 && !productId.equals(this._productId)) {
            this._productId = productId;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (revLevel != null && revLevel.length() != 0 && !revLevel.equals(this._revLevel)) {
            this._revLevel = revLevel;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (otherInfo != null && otherInfo.length != 0 && !Arrays.equals(otherInfo, this._otherInfo)) {
            this._otherInfo = otherInfo;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        return (this._changeFlags & 1) != 0;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public Wwn getScsiName() {
        return this._pkey._wwn;
    }

    public int getDevType() {
        return this._devType;
    }

    public String getDevTypeName() {
        return MibVariableFormat.extScsiIntrDiscTgtDevTypeInt(this._devType);
    }

    public String getVendorId() {
        return this._vendorId;
    }

    public String getProductId() {
        return this._productId;
    }

    public String getRevLevel() {
        return this._revLevel;
    }

    public String getOtherInfo() {
        return this._otherInfo != null ? MibVariableFormat.extScsiIntrDiscTgtOtherInfo(this._otherInfo) : "";
    }

    public byte[] getOtherInfoValue() {
        return this._otherInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ScsiTarget)) {
            return false;
        }
        ScsiTarget othTgt = (ScsiTarget)obj;
        return othTgt._pkey.equals(this._pkey) && othTgt._devType == this._devType && GenUtil.equals(othTgt._vendorId, this._vendorId) && GenUtil.equals(othTgt._productId, this._productId) && GenUtil.equals(othTgt._revLevel, this._revLevel) && Arrays.equals(othTgt._otherInfo, this._otherInfo);
    }

    public int hashCode() {
        return this._pkey.hashCode() ^ this._devType ^ this._productId.hashCode();
    }

    @Override
    public int compare(Object o1, Object o2) {
        ScsiTarget t1 = (ScsiTarget)o1;
        ScsiTarget t2 = (ScsiTarget)o2;
        int c = t1._pkey.compareTo(t2._pkey);
        if (c == 0 && (c = t1._devType - t2._devType) == 0) {
            c = t1._vendorId.compareTo(t2._vendorId);
        }
        return c;
    }

    public String toString() {
        return "DevType=" + this.getDevTypeName() + ", VendorId=" + this._vendorId + ", ProductId=" + this._productId + ", RevLevel=" + this._revLevel + ", otherInfo=" + this.getOtherInfo();
    }
}

