/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.lib.util.StringUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SnmpUserOpt
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final String[] SNMP_V3_PARAMS = new String[]{"MD5", "SHA", "MD5-DES", "MD5-AES", "SHA-DES", "SHA-AES"};
    public static final int V3_SEC_MD5 = 0;
    public static final int V3_SEC_SHA = 1;
    public static final int V3_SEC_MD5_DES = 2;
    public static final int V3_SEC_MD5_AES = 3;
    public static final int V3_SEC_SHA_DES = 4;
    public static final int V3_SEC_SHA_AES = 5;
    private String _username = null;
    private String _password = null;
    private String _community = null;
    private int _authProtocol = -1;
    private int _privProtocol = -1;
    private boolean _v3 = true;
    private boolean _fwsm = false;

    public SnmpUserOpt() {
    }

    public SnmpUserOpt(String username, String password, String community, int v3Security, boolean v3) {
        this._v3 = v3;
        if (v3) {
            this._username = username;
            this._password = password;
            this.setSnmpV3Security(v3Security);
        } else {
            this._community = community;
        }
    }

    public SnmpUserOpt(String username, String password, String community, String v3Security, boolean v3) {
        this(username, password, community, SnmpUserOpt.convertSnmpV3Security(v3Security), v3);
    }

    public void setSnmpV3Security(int v3Security) {
        switch (v3Security) {
            case 0: {
                this._authProtocol = 0;
                this._privProtocol = -1;
                break;
            }
            case 1: {
                this._authProtocol = 1;
                this._privProtocol = -1;
                break;
            }
            case 2: {
                this._authProtocol = 0;
                this._privProtocol = 0;
                break;
            }
            case 3: {
                this._authProtocol = 0;
                this._privProtocol = 1;
                break;
            }
            case 4: {
                this._authProtocol = 1;
                this._privProtocol = 0;
                break;
            }
            case 5: {
                this._authProtocol = 1;
                this._privProtocol = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid SNMPv3 security options");
            }
        }
    }

    public static int getSnmpV3SecurityVal(int digest, int encryption) {
        switch (digest) {
            case 0: {
                switch (encryption) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                }
                return 0;
            }
            case 1: {
                switch (encryption) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    public void setSnmpV3Security(String v3Security) {
        this.setSnmpV3Security(SnmpUserOpt.convertSnmpV3Security(v3Security));
    }

    public int getSnmpV3Security() {
        if (this._authProtocol == 0) {
            if (this._privProtocol == 0) {
                return 2;
            }
            if (this._privProtocol == 1) {
                return 3;
            }
            return 0;
        }
        if (this._privProtocol == 0) {
            return 4;
        }
        if (this._privProtocol == 1) {
            return 5;
        }
        return 1;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username == null ? "" : username.trim();
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password != null ? password.trim() : null;
    }

    public String getCommunity() {
        return this._community;
    }

    public void setCommunity(String community) {
        this._community = community == null ? "" : community.trim();
    }

    public boolean isV3() {
        return this._v3;
    }

    public void setV3(boolean v3) {
        this._v3 = v3;
    }

    public boolean isFwsm() {
        return this._fwsm;
    }

    public void setFwsm(boolean fwsm) {
        this._fwsm = fwsm;
    }

    public String toString() {
        return "Username = " + this._username + " Password = " + StringUtil.mask(this._password) + " Community = " + StringUtil.mask(this._community) + " isV3 ? " + this._v3 + " authProtocol " + this._authProtocol + " privProtocol " + this._privProtocol;
    }

    public int getAuthProtocol() {
        return this._authProtocol;
    }

    public void setAuthProtocol(int authProtocol) {
        this._authProtocol = authProtocol;
    }

    public int getPrivProtocol() {
        return this._privProtocol;
    }

    public void setPrivProtocol(int privProtocol) {
        this._privProtocol = privProtocol;
    }

    public String getPrivPassword() {
        return this._privProtocol == -1 ? null : this._password;
    }

    public boolean isEncrypt() {
        return this._privProtocol != -1;
    }

    public Object clone() {
        SnmpUserOpt user = new SnmpUserOpt();
        user.setAuthProtocol(this.getAuthProtocol());
        user.setPrivProtocol(this.getPrivProtocol());
        user.setSnmpV3Security(this.getSnmpV3Security());
        user.setV3(this._v3);
        user.setCommunity(this.getCommunity());
        user.setPassword(this.getPassword());
        user.setSnmpV3Security(this.getSnmpV3Security());
        user.setUsername(this.getUsername());
        return user;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        try {
            String temp = this._username != null && this._username.length() != 0 ? StringEncrypter.encryptString("DESede", this._username) : this._username;
            s.writeObject(temp);
            temp = this._password != null && this._password.length() != 0 ? StringEncrypter.encryptString("DESede", this._password) : this._password;
            s.writeObject(temp);
            temp = this._community != null && this._community.length() != 0 ? StringEncrypter.encryptString("DESede", this._community) : this._community;
            s.writeObject(temp);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("encrypting credential error: " + ex.getMessage());
        }
        s.writeInt(this._authProtocol);
        s.writeInt(this._privProtocol);
        s.writeBoolean(this._v3);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            String temp = (String)s.readObject();
            this._username = temp != null && temp.length() != 0 ? StringEncrypter.decryptString("DESede", temp) : temp;
            temp = (String)s.readObject();
            this._password = temp != null && temp.length() != 0 ? StringEncrypter.decryptString("DESede", temp) : temp;
            temp = (String)s.readObject();
            this._community = temp != null && temp.length() != 0 ? StringEncrypter.decryptString("DESede", temp) : temp;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("decrypting credential error: " + ex.getMessage());
        }
        this._authProtocol = s.readInt();
        this._privProtocol = s.readInt();
        this._v3 = s.readBoolean();
    }

    public static int convertSnmpV3Security(String secString) {
        if (secString == null) {
            return -1;
        }
        for (int i = 0; i < SNMP_V3_PARAMS.length; ++i) {
            if (!secString.equals(SNMP_V3_PARAMS[i])) continue;
            return i;
        }
        return -1;
    }

    public static SnmpUserOpt convertToSnmpUserOpt(SnmpUser snmpUser) {
        if (snmpUser == null) {
            return null;
        }
        SnmpUserOpt snmpUserOpt = new SnmpUserOpt();
        if (snmpUser.getSecurityModel() == 3) {
            UsmUser user = (UsmUser)snmpUser;
            snmpUserOpt.setUsername(user.getUserName());
            snmpUserOpt.setAuthProtocol(user.getAuthProtocol());
            snmpUserOpt.setPrivProtocol(user.getPrivacyProtocol());
            snmpUserOpt.setPassword(user.getAuthPassword());
            snmpUserOpt.setV3(true);
        } else {
            CommunityUser user = (CommunityUser)snmpUser;
            snmpUserOpt.setCommunity(user.getCommunity());
            snmpUserOpt.setV3(false);
        }
        return snmpUserOpt;
    }

    public static SnmpUser convertToSnmpUser(SnmpUserOpt snmpUserOpt) {
        if (snmpUserOpt == null) {
            return null;
        }
        if (snmpUserOpt.isV3()) {
            return new UsmUser(snmpUserOpt.getUsername(), snmpUserOpt.getAuthProtocol(), snmpUserOpt.getPassword(), snmpUserOpt.getPrivProtocol(), snmpUserOpt.getPrivPassword());
        }
        return new CommunityUser(snmpUserOpt.getCommunity());
    }
}

