/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SwChassisBase
extends EnclosureBase {
    private static final long serialVersionUID = 1L;
    protected final SerialNumKey _pkey;
    protected Set<VdcPK> _vdcPKs = Collections.synchronizedSet(new HashSet());
    protected PlatformType _platformType;
    protected String _name;

    public SwChassisBase(String serialNum) {
        this(new SerialNumKey(serialNum), null);
    }

    public SwChassisBase(SerialNumKey chassisKey, String chassisIp) {
        super(chassisKey, chassisIp, false);
        this._pkey = chassisKey;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public SerialNumKey getChassisKey() {
        return this._pkey;
    }

    public PlatformType getPlatformType() {
        return this._platformType;
    }

    public void setPlatformType(PlatformType type) {
        this._platformType = type;
    }

    public Set<VdcPK> getVdcPKs() {
        return new HashSet<VdcPK>(this._vdcPKs);
    }

    public void setVdcPKs(Set<VdcPK> vdcPKs) {
        this._vdcPKs.clear();
        this._vdcPKs.addAll(vdcPKs);
    }

    public boolean addVdc(VdcPK vdcPK) {
        if (vdcPK == null || !this._pkey.equals(vdcPK._chassisKey)) {
            return false;
        }
        return this._vdcPKs.add(vdcPK);
    }

    public boolean removeVdc(VdcPK vdcPK) {
        if (vdcPK == null || !this._pkey.equals(vdcPK._chassisKey)) {
            return false;
        }
        return this._vdcPKs.remove(vdcPK);
    }

    public void clearVdcs() {
        this._vdcPKs.clear();
    }

    @Override
    public String toString() {
        if (this._name != null) {
            return this._name;
        }
        return this._pkey.toString();
    }
}

