/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VsanBase
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final short VSAN_ATTR = 768;
    public static final short ATTR_ISPRESENT = 769;
    public static final short ATTR_NAME = 770;
    public static final short ATTR_ADMINSTATE = 771;
    public static final short ATTR_OPERSTATE = 772;
    public static final short ATTR_INTEROPMODE = 773;
    public static final short ATTR_MTU = 774;
    public static final short ATTR_LBTYPE = 775;
    public static final short ATTR_IODELIVERY = 776;
    public static final short ATTR_DROPLATENCY = 777;
    public static final short ATTR_FICONSTATE = 778;
    public static final short ATTR_SEGMENTATION = 779;
    public static final short ATTR_FABRICPK = 780;
    public static final short ATTR_SEEDPK = 781;
    public static final short ATTR_FCALIASSEED = 782;
    public static final short ATTR_ENFZONESETNAME = 783;
    public static final short ATTR_ENFZONESETTIME = 784;
    public static final short ATTR_ENFZONES = 785;
    public static final short ATTR_FCALIAS = 786;
    public static final String[] _Attrs = new String[]{"isPresent", "name", "adminState", "operState", "interOperMode", "MTU", "loadBalancingType", "isInorderDelivery", "dropLatency", "ficonState", "segmented", "fabricPK", "vsanSeed", "fcAliasSeed", "enforcedZonesetName", "enforcedZonesetActivateTime", "enforcedZones", "fcAlias"};
    public static final int ISOLATED_VID = 4094;
    public static final int EVFP_ISOLATED_VID = 4079;
    public static final byte ADMIN_ACTIVE = 1;
    public static final byte OPER_UP = 1;
    public static final byte OPER_DOWN = 2;
    protected VsanPK _pkey;
    protected String _name;
    protected byte _adminState;
    protected byte _operState;
    protected byte _interOperMode;
    protected int _mtu;
    protected byte _loadBalancingType;
    protected boolean _inorderDelivery;
    protected int _networkDropLatency;
    protected byte _ficonState;
    protected boolean _segmented;
    protected FabricPK _fabricPK;
    protected WwnKey _seedSwitchPK;
    protected WwnKey _fcAliasSeedPK;
    protected String _enfZoneSetName;
    protected long _enfZoneSetActivateTime = 0L;
    protected ZoneBase[] _enfZones;
    protected Map<String, FcPortAlias> _fcAliasByName = Collections.synchronizedMap(new HashMap());
    protected Map<Wwn, FcPortAlias> _fcAliasByWwn = Collections.synchronizedMap(new HashMap());
    protected Map<Wwn, Long> _enfZoneSetActTimeByWwn = Collections.synchronizedMap(new HashMap());

    public VsanBase(FabricPK fabricPK, VsanPK pkey) {
        this._fabricPK = fabricPK;
        this._pkey = pkey;
    }

    public VsanBase(FabricPK fabricPK, VsanPK pkey, String name, byte adminState, byte operState, byte interOper, int mtu, byte lbType, boolean ioDelivery, int latency) {
        this(fabricPK, pkey);
        this._name = name;
        this._adminState = adminState;
        this._operState = operState;
        this._interOperMode = interOper;
        this._mtu = mtu;
        this._loadBalancingType = lbType;
        this._inorderDelivery = ioDelivery;
        this._networkDropLatency = latency;
    }

    public VsanBase(VsanBase vsan) {
        this._pkey = vsan._pkey;
        this.sync(vsan);
    }

    public void sync(VsanBase vsan) {
        super.sync(vsan);
        this._name = vsan._name;
        this._adminState = vsan._adminState;
        this._operState = vsan._operState;
        this._interOperMode = vsan._interOperMode;
        this._mtu = vsan._mtu;
        this._loadBalancingType = vsan._loadBalancingType;
        this._inorderDelivery = vsan._inorderDelivery;
        this._networkDropLatency = vsan._networkDropLatency;
        this._ficonState = vsan._ficonState;
        this._segmented = vsan._segmented;
        this._fabricPK = vsan._fabricPK;
        this._seedSwitchPK = vsan._seedSwitchPK;
        this._fcAliasSeedPK = vsan._fcAliasSeedPK;
        this._enfZoneSetName = vsan._enfZoneSetName;
        this._enfZoneSetActivateTime = vsan._enfZoneSetActivateTime;
        this._enfZones = vsan._enfZones;
        this._fcAliasByName = vsan._fcAliasByName;
        this._fcAliasByWwn = vsan._fcAliasByWwn;
        this._enfZoneSetActTimeByWwn = vsan._enfZoneSetActTimeByWwn;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public VsanPK getVsanPK() {
        return this._pkey;
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof VsanBase)) {
            return false;
        }
        return ((VsanBase)x)._pkey.equals(this._pkey);
    }

    public short getId() {
        return this._pkey._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String newName) {
        this._name = newName;
    }

    public byte getAdminState() {
        return this._adminState;
    }

    public void setAdminState(byte state) {
        this._adminState = state;
    }

    public boolean isActive() {
        return this._adminState == 1;
    }

    public boolean isUp() {
        return this._operState == 1;
    }

    public boolean isDown() {
        return this._operState == 2;
    }

    public byte getOperState() {
        return this._operState;
    }

    public void setOperState(byte operState) {
        this._operState = operState;
    }

    public byte getInterOperMode() {
        return this._interOperMode;
    }

    public void setInterOperMode(byte mode) {
        this._interOperMode = mode;
    }

    public int getMtu() {
        return this._mtu;
    }

    public void setMtu(int mtu) {
        this._mtu = mtu;
    }

    public byte getLoadBalancingType() {
        return this._loadBalancingType;
    }

    public void setLoadBalancingType(byte type) {
        this._loadBalancingType = type;
    }

    public boolean isInorderDelivery() {
        return this._inorderDelivery;
    }

    public void setInorderDelivery(boolean b) {
        this._inorderDelivery = b;
    }

    public int getNetworkDropLatency() {
        return this._networkDropLatency;
    }

    public void setNetworkDropLatency(int msec) {
        this._networkDropLatency = msec;
    }

    public byte getFiconState() {
        return this._ficonState;
    }

    public void setFiconState(byte state) {
        this._ficonState = state;
    }

    public boolean isFicon() {
        return this._ficonState != 0;
    }

    public boolean isSegmented() {
        return this._segmented;
    }

    public void setSegmented(boolean b) {
        this._segmented = b;
    }

    public FabricPK getFabricPK() {
        return this._fabricPK;
    }

    public void setFabricPK(FabricPK fabricPK) {
        this._fabricPK = fabricPK;
    }

    public WwnKey getSeedSwitchPK() {
        return this._seedSwitchPK;
    }

    public void setSeedSwitchPK(WwnKey swPK) {
        this._seedSwitchPK = swPK;
    }

    public WwnKey getFcAliasSeedPK() {
        return this._fcAliasSeedPK;
    }

    public void setFcAliasSeedPK(WwnKey swPK) {
        this._fcAliasSeedPK = swPK;
    }

    public String getEnforcedZoneSetName() {
        return this._enfZoneSetName;
    }

    public String setEnforcedZoneSetName(String newName) {
        String oldName = this._enfZoneSetName;
        this._enfZoneSetName = newName;
        return oldName;
    }

    public long getEnforcedZoneSetActivateTime() {
        return this._enfZoneSetActivateTime;
    }

    public long setEnforcedZoneSetActivateTime(long time) {
        long oldTime = this._enfZoneSetActivateTime;
        this._enfZoneSetActivateTime = time;
        return oldTime;
    }

    public ZoneBase[] getEnforcedZones() {
        return this._enfZones;
    }

    public void setEnforcedZones(ZoneBase[] zones) {
        this._enfZones = zones;
    }

    public FcPortAlias[] getFcAliases() {
        return this._fcAliasByName.values().toArray(new FcPortAlias[this._fcAliasByName.size()]);
    }

    public Collection<FcPortAlias> getAliasList() {
        Collection<FcPortAlias> list = this._fcAliasByName.size() == 0 ? Collections.emptyList() : Collections.unmodifiableCollection(this._fcAliasByName.values());
        return list;
    }

    public List<String> getFcAliasNames() {
        List<String> names = this._fcAliasByName.size() == 0 ? Collections.emptyList() : new ArrayList<String>(this._fcAliasByName.keySet());
        return names;
    }

    public FcPortAlias findFcAlias(String name) {
        return this._fcAliasByName.get(name);
    }

    public FcPortAlias findFcAlias(Wwn pwwn) {
        return this._fcAliasByWwn.get(pwwn);
    }

    public void addFcAlias(FcPortAlias alias) {
        this._fcAliasByName.put((String)alias.getName(), alias);
        this._fcAliasByWwn.put(alias.getWwn(), alias);
    }

    public FcPortAlias removeFcAlias(String name) {
        FcPortAlias fa = this._fcAliasByName.remove(name);
        return fa;
    }

    public FcPortAlias removeFcAlias(Wwn pwwn) {
        FcPortAlias fa = this._fcAliasByWwn.remove(pwwn);
        if (fa != null) {
            this._fcAliasByName.remove(fa.getAlias());
        }
        return fa;
    }

    public void updateFcAliasWwn(FcPortAlias fa, Wwn newWwn) {
        this._fcAliasByWwn.remove(fa.getWwn());
        fa.setWwn(newWwn);
        this._fcAliasByWwn.put(newWwn, fa);
    }

    public Long findZoneSetActivateTime(Wwn swwn) {
        return this._enfZoneSetActTimeByWwn.get(swwn);
    }

    public Long removeZoneSetActivateTime(Wwn swwn) {
        return this._enfZoneSetActTimeByWwn.remove(swwn);
    }

    public void updateZoneSetActivateTime(Wwn swwn, Long activateTime) {
        this._enfZoneSetActTimeByWwn.put(swwn, activateTime);
    }

    @Override
    public String toString() {
        return this._fabricPK.toString() + ", VSAN" + this._pkey._id;
    }

    public static String getVsansAsString(short[] vsanMembership, int numVsans) {
        if (numVsans == 0) {
            return "n/a";
        }
        if (numVsans == 1) {
            return Integer.toString(vsanMembership[0]);
        }
        Arrays.sort(vsanMembership, 0, numVsans);
        StringBuffer sb = new StringBuffer();
        sb.append(vsanMembership[0]);
        short last = vsanMembership[0];
        boolean thru = false;
        int max = numVsans;
        for (int i = 1; i < max; ++i) {
            if (vsanMembership[i] - vsanMembership[i - 1] == 1) {
                if (thru) continue;
                last = vsanMembership[i - 1];
                thru = true;
                continue;
            }
            if (thru) {
                sb.append("-").append(vsanMembership[i - 1]);
                thru = false;
            }
            sb.append(",").append(vsanMembership[i]);
        }
        if (thru) {
            sb.append("-").append(vsanMembership[numVsans - 1]);
        }
        return sb.toString();
    }

    public static String getVsansAsString(short[] vsanMembership) {
        int i;
        if (vsanMembership == null) {
            return "";
        }
        for (i = 0; i < vsanMembership.length && vsanMembership[i] != 0; ++i) {
        }
        return VsanBase.getVsansAsString(vsanMembership, i);
    }
}

