/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.ddm;

import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMDppVi;
import com.cisco.dcbu.sm.common.model.ddm.DDMSession;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import java.io.Serializable;
import java.util.Date;

public class DDMJob
implements Serializable {
    static final long serialVersionUID = 1L;
    private long _id;
    private String _name;
    private byte _type;
    private byte _method;
    private byte _rate;
    private int _status;
    private byte _jobMode;
    private Date _scheduledStartingTime;
    private String _ssmIp;
    private DDMSwitch _ssm1;
    private DDMSwitch _ssm2;
    private DDMSwitch _method3DataMoverSSM;
    private boolean isSSM1DataMoverSSM = false;
    private String _log;
    private byte _scheduleAction = 0;
    private EnclosureBase _serverHosts;
    private EndPortBase[] _serverEndPorts;
    private EnclosureBase _exisitingStorages;
    private EndPortBase[] _exisitingStoragesEndPorts;
    private EnclosureBase _newStorages;
    private EndPortBase[] _newStoragesEndPorts;
    private DDMSession[] _sessions;
    private int[] _peerIps = new int[0];
    private DDMDppVi[] _dppVis;
    private EnclosureBase[] _serverHostsForStorage;
    private String estimatedTimeToCompletion = null;
    private long estTimeToCompInSeconds = 0L;

    public DDMDppVi[] getDppVis() {
        return this._dppVis;
    }

    public void setDppVis(DDMDppVi[] dppVis) {
        this._dppVis = dppVis;
    }

    public EnclosureBase getExsitingStorages() {
        return this._exisitingStorages;
    }

    public void setExsitingStorages(EnclosureBase exsitingStorages) {
        this._exisitingStorages = exsitingStorages;
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public EnclosureBase getNewStorages() {
        return this._newStorages;
    }

    public void setNewStorages(EnclosureBase newStorages) {
        this._newStorages = newStorages;
    }

    public byte getJobMode() {
        return this._jobMode;
    }

    public void setJobMode(byte jobMode) {
        this._jobMode = jobMode;
    }

    public byte getRate() {
        return this._rate;
    }

    public void setRate(byte rate) {
        this._rate = rate;
    }

    public Date getScheduledStartingTime() {
        return this.getScheduledStartingTime(false);
    }

    public boolean isVerifyComplete() {
        if (this._sessions == null || this._sessions.length == 0) {
            return false;
        }
        for (int i = 0; i < this._sessions.length; ++i) {
            if (this._sessions[i].getVerifyStatus() == 1) continue;
            return false;
        }
        return true;
    }

    public String getStatusAsString() {
        return Mediator.DMM_JOB_STATUS_DISPLAY[this.getStatus()];
    }

    public Date getScheduledStartingTime(boolean getRaw) {
        if (getRaw) {
            return this._scheduledStartingTime;
        }
        if (this.getStatus() == 2) {
            return this._scheduledStartingTime;
        }
        return null;
    }

    public void setScheduledStartingTime(Date scheduledStartingTime) {
        this._scheduledStartingTime = scheduledStartingTime;
    }

    public EnclosureBase getServerHosts() {
        return this._serverHosts;
    }

    public void setServerHosts(EnclosureBase serverHosts) {
        this._serverHosts = serverHosts;
    }

    public DDMSession[] getSessions() {
        return this._sessions;
    }

    public void setSessions(DDMSession[] sessions) {
        this._sessions = sessions;
    }

    public void setEstimatedCompletionTimeInSeconds(long seconds) {
        this.estTimeToCompInSeconds = seconds;
        if (seconds == -1L) {
            this.setEstimagedCompletionTime("Calculating");
        } else if (seconds == -2L) {
            this.setEstimagedCompletionTime("Waiting For All Session Start");
        } else if (seconds > 0L) {
            StringBuffer ret = new StringBuffer("");
            long hour = seconds / 3600L;
            if (hour > 0L) {
                ret.append(hour + ":");
            } else {
                ret.append("0:");
            }
            long minute = (seconds -= hour * 3600L) / 60L;
            if (minute < 10L) {
                ret.append("0" + minute);
            } else {
                ret.append("" + minute);
            }
            if ((seconds -= minute * 60L) < 10L) {
                ret.append(":0");
            } else {
                ret.append(":");
            }
            ret.append(seconds);
            this.setEstimagedCompletionTime(ret.toString());
        } else {
            this.setEstimagedCompletionTime(null);
        }
    }

    public long getEstimatedCompletionTimeInSeconds() {
        return this.estTimeToCompInSeconds;
    }

    private void setEstimagedCompletionTime(String value) {
        this.estimatedTimeToCompletion = value;
    }

    public String getEstimatedCompletionTime() {
        if (this.estimatedTimeToCompletion == null) {
            return "N/A";
        }
        return this.estimatedTimeToCompletion;
    }

    public DDMSwitch getSsm1() {
        return this._ssm1;
    }

    public void setSsm1(DDMSwitch ssm1) {
        this._ssm1 = ssm1;
    }

    public DDMSwitch getSsm2() {
        return this._ssm2;
    }

    public void setSsm2(DDMSwitch ssm2) {
        this._ssm2 = ssm2;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public byte getType() {
        return this._type;
    }

    public void setType(byte type) {
        this._type = type;
    }

    public String getSsmIp() {
        return this._ssmIp;
    }

    public void setSsmIp(String ssmIp) {
        this._ssmIp = ssmIp;
    }

    public String getTypeAsString() {
        switch (this._type) {
            case -86: {
                return "server";
            }
            case -69: {
                return "storage";
            }
        }
        return "Unknown";
    }

    public String getModeAsString() {
        switch (this._jobMode) {
            case -52: {
                return "online";
            }
            case -35: {
                return "offline";
            }
        }
        return "Unknown";
    }

    public String getRateAsString() {
        switch (this._rate) {
            case -35: {
                return Mediator.DMM_JOB_Rates[0];
            }
            case -52: {
                return Mediator.DMM_JOB_Rates[1];
            }
            case -69: {
                return Mediator.DMM_JOB_Rates[2];
            }
            case -86: {
                return Mediator.DMM_JOB_Rates[3];
            }
        }
        return "Unknown";
    }

    public String getMethodAsString() {
        switch (this._method) {
            case -1: {
                return "Method 2";
            }
            case -18: {
                return "Method 1";
            }
            case -35: {
                return "Method 3";
            }
        }
        return "Unknown";
    }

    public String getLog() {
        return this._log;
    }

    public void setLog(String log) {
        this._log = log;
    }

    public byte getScheduleAction() {
        return this._scheduleAction;
    }

    public void setScheduleAction(byte action) {
        this._scheduleAction = action;
    }

    public EnclosureBase[] getServerHostsForStorage() {
        return this._serverHostsForStorage;
    }

    public void setServerHostsForStorage(EnclosureBase[] serverHostsForStorage) {
        this._serverHostsForStorage = serverHostsForStorage;
    }

    public EndPortBase[] getExisitingStoragesEndPorts() {
        return this._exisitingStoragesEndPorts;
    }

    public void setExisitingStoragesEndPorts(EndPortBase[] exsitingStoragesEndPorts) {
        this._exisitingStoragesEndPorts = exsitingStoragesEndPorts;
    }

    public EndPortBase[] getNewStoragesEndPorts() {
        return this._newStoragesEndPorts;
    }

    public void setNewStoragesEndPorts(EndPortBase[] newStoragesEndPorts) {
        this._newStoragesEndPorts = newStoragesEndPorts;
    }

    public EndPortBase[] getServerEndPorts() {
        return this._serverEndPorts;
    }

    public void setServerEndPorts(EndPortBase[] serverEndPorts) {
        this._serverEndPorts = serverEndPorts;
    }

    public int[] getPeerIps() {
        return this._peerIps;
    }

    public void setPeerIps(int[] ips) {
        this._peerIps = ips;
    }

    public byte getMethod() {
        return this._method;
    }

    public void setMethod(byte method) {
        this._method = method;
    }

    public boolean isJobAsychJob() {
        return this._method == -1 || this._method == -35;
    }

    public DDMSwitch getMethod3DataMoverSSM() {
        return this._method3DataMoverSSM;
    }

    public void setMethod3DataMoverSSM(DDMSwitch method3DataMoverSSM) {
        this._method3DataMoverSSM = method3DataMoverSSM;
    }

    public boolean isSSM1DataMoverSSM() {
        return this.isSSM1DataMoverSSM;
    }

    public void setSSM1DataMoverSSM(boolean isSSM1DataMoverSSM) {
        this.isSSM1DataMoverSSM = isSSM1DataMoverSSM;
    }

    public String toString() {
        return this._name;
    }
}

