/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.se;

import com.cisco.dcbu.sm.common.model.se.SEAlgoInfo;
import java.io.Serializable;
import java.text.DecimalFormat;

public class SELun
implements Serializable,
Comparable {
    static final long serialVersionUID = 1L;
    private long _lunNumber;
    private int _lastLBA;
    private int _blkLen;
    private long _capacity;
    private String _vendorId;
    private String _productId;
    private boolean _sessionCreate = false;
    private SEAlgoInfo _algorithm;
    public static final int BYTES_PER_LBA = 512;

    public SELun(long lunNum, int lastLba, int blkLen, String vendor, String product) {
        this._lunNumber = lunNum;
        this._lastLBA = lastLba;
        this._blkLen = blkLen;
        this._vendorId = vendor;
        this._productId = product;
        this._capacity = this._lastLBA / 1024 * this._blkLen;
    }

    public int getBlkLen() {
        return this._blkLen;
    }

    public int getLastLBA() {
        return this._lastLBA;
    }

    public long getLunNumber() {
        return this._lunNumber;
    }

    public String getProductId() {
        return this._productId;
    }

    public String getVendorId() {
        return this._vendorId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("LUN" + new Long(this._lunNumber).toString());
        buf.append("(0x");
        buf.append(Long.toHexString(this._lunNumber));
        buf.append("), ");
        buf.append(SELun.convertLunCapacity(this._capacity));
        return buf.toString();
    }

    public static String convertLunCapacity(long capacity) {
        double d = 0.0;
        String suffix = null;
        if (capacity >= 0x100000L) {
            d = (double)capacity / 1048576.0;
            suffix = "GB";
        } else if (capacity >= 1024L) {
            d = (double)capacity / 1024.0;
            suffix = "MB";
        } else {
            suffix = "KB";
        }
        if (suffix != null) {
            return new DecimalFormat("0.000").format(d) + suffix;
        }
        return Long.toString(capacity);
    }

    public boolean equals(Object other) {
        SELun compareTo = (SELun)other;
        boolean ret = false;
        return compareTo != null && compareTo._blkLen == this._blkLen && compareTo._lunNumber == this._lunNumber && compareTo._lastLBA == this._lastLBA;
    }

    public int compareTo(Object obj) {
        SELun lun = (SELun)obj;
        if (lun._lunNumber < this._lunNumber) {
            return 1;
        }
        if (lun._lunNumber == this._lunNumber) {
            return 0;
        }
        return -1;
    }

    public boolean isSessionCreate() {
        return this._sessionCreate;
    }

    public void setSessionCreate(boolean create) {
        this._sessionCreate = create;
    }

    public SEAlgoInfo getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(SEAlgoInfo _algorithm) {
        this._algorithm = _algorithm;
    }

    public long getCapacity() {
        return this._capacity;
    }
}

