/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.registry;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class ContextRegistry {
    private Logger _Logger = Logger.getLogger((String)"fms");
    private InitialContext _localContext = null;
    private Map<String, Context> _ContextHash = null;
    public static ContextRegistry _Instance = null;

    public static ContextRegistry getInstance() {
        if (_Instance == null) {
            _Instance = new ContextRegistry();
        }
        return _Instance;
    }

    public InitialContext getLocalContext() {
        if (this._localContext == null) {
            try {
                this._localContext = new InitialContext();
            }
            catch (Exception ex) {
                this._Logger.error((Object)"Unable to get local InitialContext", (Throwable)ex);
            }
        }
        return this._localContext;
    }

    public Context getContext(String ipAddr) {
        String port = System.getProperty("server.port", "4447");
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        return this.getContext(ipAddr, port, _useSsl);
    }

    public Context getContext(String ipAddr, String port) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        return this.getContext(ipAddr, port, _useSsl);
    }

    public Context getContext(String ipAddr, String port, Boolean useSsl) {
        Context ic;
        this._Logger.debug((Object)("InitialContext requested for " + ipAddr + ":" + port + " useSsl:" + useSsl));
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (Exception e) {
            this._Logger.error((Object)("ip address validation for " + ipAddr + " failed"), (Throwable)e);
            return null;
        }
        if (this.isLocalAddress(addr)) {
            return this.getLocalContext();
        }
        String key = ipAddr + ":" + port + "-" + useSsl;
        if (this._ContextHash == null) {
            this.provisionContextHash();
        }
        if ((ic = this._ContextHash.get(key)) == null) {
            Properties p = new Properties();
            p.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
            p.put("endpoint.name", "client-endpoint");
            if (useSsl.booleanValue()) {
                p.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "true");
            } else {
                p.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
            }
            p.put("remote.connections", "default");
            p.put("remote.connection.default.port", port);
            p.put("remote.connection.default.host", ipAddr);
            p.put("remote.connection.default.username", "admin");
            p.put("remote.connection.default.password", "nbv_12345");
            p.put("org.jboss.ejb.client.scoped.context", "true");
            try {
                ic = new InitialContext(p);
                Context context = (Context)ic.lookup("ejb:");
                this._ContextHash.put(key, context);
                return context;
            }
            catch (Exception e) {
                this._Logger.error((Object)("Error looking up InitialContext for " + ipAddr + ":" + port + " " + useSsl), (Throwable)e);
            }
        }
        return ic;
    }

    private boolean isLocalAddress(InetAddress addr) {
        try {
            if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (Exception e) {
            this._Logger.error((Object)("local address check for " + addr.toString() + " failed"), (Throwable)e);
            return false;
        }
    }

    private void provisionContextHash() {
        this._ContextHash = new HashMap<String, Context>();
        this._Logger.debug((Object)"ContextRegistry provisioned");
    }
}

