/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.rif;

import java.rmi.RemoteException;

public class SEException
extends RemoteException {
    static final long serialVersionUID = 1L;
    boolean m_protocolError;
    Exception m_protocolException;
    int m_ssmErrorCode;
    String m_ssmErrorReason;
    short m_reason = 0;
    String m_reasonStringFromSw = "";

    public SEException() {
    }

    public SEException(String reason) {
        super(reason);
    }

    public SEException(String reason, short code) {
        super(reason);
        this.m_reasonStringFromSw = reason;
        this.m_reason = code;
    }

    public boolean isProtocolError() {
        return this.m_protocolError;
    }

    public void setProtocolError(boolean protocolError) {
        this.m_protocolError = protocolError;
    }

    public Exception getProtocolException() {
        return this.m_protocolException;
    }

    public void setProtocolException(Exception protocolException) {
        this.m_protocolException = protocolException;
    }

    @Override
    public String getMessage() {
        if (this.m_reason != 0) {
            return "SEException: reason code:" + this.getReasonString();
        }
        if (this.m_protocolException != null) {
            return "SEException: protocol error: " + this.m_protocolException.getMessage();
        }
        if (super.getMessage() == null) {
            return "DDMException";
        }
        return super.getMessage();
    }

    public int getSsmErrorCode() {
        return this.m_ssmErrorCode;
    }

    public void setSsmErrorCode(int ssmErrorCode) {
        this.m_ssmErrorCode = ssmErrorCode;
    }

    public String getSsmErrorReason() {
        return this.m_ssmErrorReason;
    }

    public void setSsmErrorReason(String ssmErrorReason) {
        this.m_ssmErrorReason = ssmErrorReason;
    }

    public short getReason() {
        return this.m_reason;
    }

    @Override
    public String toString() {
        if (this.m_reason != 0) {
            return "SEException: reason code:" + this.getReasonString();
        }
        if (this.m_protocolException != null) {
            return "SEException: protocolException :" + this.m_protocolException.toString();
        }
        return super.toString();
    }

    private String getReasonString() {
        switch (this.m_reason) {
            case 1: {
                return "1: SE_JOB_NULL";
            }
            case 2: {
                return "2: SE_JOB_NOT_PRESENT";
            }
            case 3: {
                return "3: SE_JOB_ID_DUPLICATE";
            }
            case 4: {
                return "4: SE_JOB_ID_ZERO";
            }
            case 5: {
                return "5: SE_JOB_VSAN_MISMATCH";
            }
            case 6: {
                return "6:  SE_JOB_TYPE_MISMATCH";
            }
            case 7: {
                return "7:  SE_JOB_CREATION_ERROR";
            }
            case 8: {
                return "8:  SE_JOB_INTERNAL_ERROR";
            }
            case 9: {
                return "9:  SE_JOB_PRECONFIG";
            }
            case 10: {
                return "10:  SE_JOB_SESSION_EXEC";
            }
            case 11: {
                return "11:  SE_JOB_VALIDATE_PENDING";
            }
            case 12: {
                return "12:  SE_JOB_VALIDATING";
            }
            case 13: {
                return "13:  SE_JOB_SESSION_DECON";
            }
            case 14: {
                return "14:  SE_JOB_DECONFIGURING";
            }
            case 15: {
                return "14: SE_JOB_DPP_ALLOC_FAILURE";
            }
            case 16: {
                return "16: SE_JOB_INFRA_SETUP_ERROR";
            }
            case 17: {
                return "17: SE_JOB_INFRA_REMOTE_LMAP_ERR_TCP_DN";
            }
            case 18: {
                return "18: SE_JOB_INFRA_FC_REDIRECT_SETUP_ERR";
            }
            case 19: {
                return "19: SE_JOB_INFRA_LOCAL_LMAP_ERR";
            }
            case 20: {
                return "20: SE_JOB_INFRA_DPP_DIED";
            }
            case 21: {
                return "21: SE_JOB_INFRA_NOT_ALLOWED";
            }
            case 22: {
                return "22: SE_JOB_SRC_LUN_INFO_NOT_PRESENT";
            }
            case 23: {
                return "23: SE_JOB_DST_LUN_INFO_NOT_PRESENT";
            }
            case 24: {
                return "24: SE_VT_VSAN_DOWN";
            }
            case 25: {
                return "25: SE_VT_ISAPI_CREATION_FAILED";
            }
            case 26: {
                return "26: SE_VT_DPP_DIED";
            }
            case 27: {
                return "27: SE_VT_DELETE_ERROR";
            }
            case 28: {
                return "28: SE_VT_ACTIVATION_FAIL";
            }
            case 29: {
                return "29: SE_VT_FC_REDIRECT_ERROR";
            }
            case 30: {
                return "30: SE_FC_RDRT_NO_DNS_ENTRY";
            }
            case 31: {
                return "31: SE_FC_RDRT_NO_ZS_ENTRY";
            }
            case 32: {
                return "32: SE_FC_RDRT_INSTALL_ERROR";
            }
            case 33: {
                return "33: SE_FC_RDRT_LUXOR_ACL_ERROR";
            }
            case 34: {
                return "34: SE_SRVR_VT_LOGIN_SRVR_LOGIN_ERROR";
            }
            case 35: {
                return "35: SE_SRVR_VT_LOGIN_VI_LOGIN_ERROR";
            }
            case 36: {
                return "36: SE_SRVR_VT_NO_PRLI_SRVR";
            }
            case 37: {
                return "37: SE_PREVIOUS_REQ_INPROGRESS";
            }
            case 38: {
                return "38: SE_ITL_NOT_FOUND";
            }
            case 39: {
                return "39: SE_ITL_NOT_FOUND_IN_NON_ASL_LIST";
            }
            case 40: {
                return "40: SE_ITL_NOT_FOUND_IN_ASL_LIST";
            }
            case 41: {
                return "41: SE_ILLEGAL_REQ";
            }
            case 42: {
                return "42: SE_INIT_NOT_FOUND";
            }
            case 43: {
                return "43: SE_SRC_TGT_NOT_FOUND";
            }
            case 44: {
                return "44: SE_DST_TGT_NOT_FOUND";
            }
            case 45: {
                return "45: SE_ITL_NOT_FOUND_IN_GUI_ASL_LIST";
            }
            case 46: {
                return "46: SE_ITL_FOUND_IN_AUTO_ASL_LIST";
            }
            case 47: {
                return "47: SE_SRC_LUN_GREATER_THAN_DST";
            }
            case 48: {
                return "48: SE_TGT_NOT_REACHABLE";
            }
            case 49: {
                return "49: SE_SRC_TGT_NOT_ASL_CLASSIFIED";
            }
            case 50: {
                return "50: SE_DST_TGT_NOT_ASL_CLASSIFIED";
            }
            case 51: {
                return "51: SE_SRC_LUN_ALREADY_EXISTS";
            }
            case 52: {
                return "52: SE_DST_LUN_ALREADY_EXISTS";
            }
            case 53: {
                return "53: SE_MAX_REASON";
            }
        }
        return "Reason code:" + this.m_reason + ":" + this.m_reasonStringFromSw;
    }
}

