/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.saxman.textdiff;

import com.cisco.dcbu.sm.common.saxman.textdiff.LineBlock;
import com.cisco.dcbu.sm.common.saxman.textdiff.LineInfo;

public class FileInfo {
    private static final long serialVersionUID = 1L;
    public String[] lines;
    public LineInfo[] lineInfo;
    public int length;
    public int lineNum;
    private static final LineInfo EOF = new LineInfo(-1, -1, -1, -1);

    public FileInfo(String[] lines) {
        this.lines = lines;
        this.length = lines.length;
        this.lineInfo = new LineInfo[this.length];
    }

    public String currentLine() {
        return this.lines[this.lineNum];
    }

    public LineInfo currentLineInfo() {
        return this.lineInfoAt(this.lineNum);
    }

    public LineInfo lineInfoAt(int lineNum) {
        if (lineNum >= this.lines.length) {
            return EOF;
        }
        return this.lineInfo[lineNum];
    }

    public LineBlock nextBlock() {
        LineBlock lineBlock = this.getBlockAt(this.lineNum);
        if (null != lineBlock) {
            this.lineNum += lineBlock.lines.length;
        }
        return lineBlock;
    }

    public LineBlock nextSingleLineBlock() {
        LineBlock lBlock = new LineBlock(this.lines, this.lineNum, this.lineNum);
        ++this.lineNum;
        return lBlock;
    }

    public LineBlock getBlockAt(int lineNum) {
        if (lineNum >= this.lines.length) {
            return null;
        }
        int fromLineNum = lineNum;
        int blockNum = this.lineInfo[lineNum].blockNum;
        while (blockNum == this.lineInfoAt((int)lineNum).blockNum) {
            ++lineNum;
        }
        int thruLineNum = lineNum - 1;
        LineBlock lBlock = new LineBlock(this.lines, fromLineNum, thruLineNum);
        return lBlock;
    }

    public LineBlock getSingleLineBlockAt(int lineNum) {
        if (lineNum >= this.lines.length) {
            return null;
        }
        int fromLineNum = lineNum;
        int blockNum = this.lineInfo[lineNum].blockNum;
        int thruLineNum = ++lineNum - 1;
        LineBlock lBlock = new LineBlock(this.lines, fromLineNum, thruLineNum);
        return lBlock;
    }

    public void setBlockNumber(int lineNum, int blockNum) {
        this.lineInfo[lineNum].setBlockNumber(blockNum);
    }

    public boolean isValidLineNum(int lineNum) {
        return lineNum >= 0 && lineNum < this.lines.length;
    }
}

