/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.saxman.textdiff;

import com.cisco.dcbu.sm.common.saxman.textdiff.AppendCommand;
import com.cisco.dcbu.sm.common.saxman.textdiff.ChangeCommand;
import com.cisco.dcbu.sm.common.saxman.textdiff.DefaultReportWriter;
import com.cisco.dcbu.sm.common.saxman.textdiff.DeleteCommand;
import com.cisco.dcbu.sm.common.saxman.textdiff.EditCommand;
import com.cisco.dcbu.sm.common.saxman.textdiff.FileInfo;
import com.cisco.dcbu.sm.common.saxman.textdiff.IReportWriter;
import com.cisco.dcbu.sm.common.saxman.textdiff.InsertCommand;
import com.cisco.dcbu.sm.common.saxman.textdiff.LineInfo;
import com.cisco.dcbu.sm.common.saxman.textdiff.MatchCommand;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Report
extends ArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger Report_Logger = LogManager.getLogger((String)"FM.WebReport");

    private Report() {
    }

    public Report(FileInfo oldFileInfo, FileInfo newFileInfo) {
        while (true) {
            LineInfo oldLineInfo = oldFileInfo.currentLineInfo();
            LineInfo newLineInfo = newFileInfo.currentLineInfo();
            if (oldLineInfo.isEOF() && newLineInfo.isEOF()) break;
            if (oldLineInfo.isEOF() && newLineInfo.isNewOnly()) {
                this.add(new AppendCommand(oldFileInfo, newFileInfo));
                continue;
            }
            if (newLineInfo.isNewOnly()) {
                this.add(new InsertCommand(oldFileInfo, newFileInfo));
                continue;
            }
            if (oldLineInfo.isOldOnly()) {
                this.add(new DeleteCommand(oldFileInfo, newFileInfo));
                continue;
            }
            if (oldLineInfo.isMatch()) {
                if (oldLineInfo.isChanged() && newLineInfo.isChanged()) {
                    this.add(new ChangeCommand(oldFileInfo, newFileInfo));
                    continue;
                }
                if (!newLineInfo.isChanged() && !oldLineInfo.isChanged()) {
                    this.add(new MatchCommand(oldFileInfo, newFileInfo));
                    continue;
                }
                if (!oldLineInfo.isChanged()) {
                    this.add(new DeleteCommand(oldFileInfo, newFileInfo));
                    continue;
                }
                this.add(new InsertCommand(oldFileInfo, newFileInfo));
                continue;
            }
            if (newLineInfo.isMatch()) {
                newFileInfo.nextBlock();
                continue;
            }
            if (newLineInfo != null || oldLineInfo == null) {
                Report_Logger.error((Object)"ERROR:***Failed to get Configuration comparison data****");
                break;
            }
            if (newLineInfo == null) {
                Report_Logger.error((Object)("ERROR:Skipping line " + newFileInfo.lines[newFileInfo.lineNum] + "  state:" + newLineInfo.lineStatus));
                newFileInfo.nextBlock();
            }
            if (oldLineInfo != null) continue;
            Report_Logger.error((Object)("ERROR:Skipping line " + oldFileInfo.lines[newFileInfo.lineNum] + "  state:" + oldLineInfo.lineStatus));
            oldFileInfo.nextBlock();
        }
    }

    public void print() {
        try {
            FileOutputStream fo = new FileOutputStream("c:\\temp\\TextDiffRun.txt");
            this.print(new PrintStream(fo));
        }
        catch (Exception ex) {
            System.out.println("File not found");
        }
    }

    public void print(PrintStream stream) {
        this.write(new DefaultReportWriter(stream));
    }

    public void write(IReportWriter writer) {
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            writer.report(this.getCommand(i));
        }
    }

    public EditCommand getCommand(int lineNum) {
        return (EditCommand)super.get(lineNum);
    }
}

