/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class MacAddress
implements Serializable,
Comparable,
Comparator {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH = 6;
    protected byte[] _bytes;
    protected char _byteToken = (char)58;

    public MacAddress(String macAddressStr) {
        if (macAddressStr == null || macAddressStr.length() == 0) {
            throw new IllegalArgumentException("Invalid MAC address:" + macAddressStr);
        }
        this._bytes = this.parse(macAddressStr);
    }

    public MacAddress(byte[] bytes) {
        if (bytes == null || bytes.length != 6) {
            throw new IllegalArgumentException("Invalid MAC address:" + Arrays.toString(bytes));
        }
        this._bytes = bytes;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public byte[] getOUIBytes() {
        byte[] tbytes = new byte[3];
        System.arraycopy(this._bytes, 0, tbytes, 0, 3);
        return tbytes;
    }

    public byte[] getNICBytes() {
        byte[] tbytes = new byte[3];
        System.arraycopy(this._bytes, 3, tbytes, 3, 3);
        return tbytes;
    }

    public boolean isMulticast() {
        byte tbyte = this._bytes[0];
        return (tbyte & 1) == 1;
    }

    public boolean isLocalAdmin() {
        byte tbyte = this._bytes[0];
        return (tbyte >> 1 & 1) == 1;
    }

    public boolean isAllZeros() {
        for (byte b : this._bytes) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this._bytes.length; ++idx) {
            if ((0xFF & this._bytes[idx]) < 16) {
                sb.append('0');
            }
            if (this._byteToken == '.') {
                sb.append(Integer.toHexString(0xFF & this._bytes[idx]));
                if (idx % 2 != 1 || idx == this._bytes.length - 1) continue;
                sb.append(this._byteToken);
                continue;
            }
            sb.append(Integer.toHexString(0xFF & this._bytes[idx]));
            sb.append(this._byteToken);
        }
        if (this._byteToken == '.') {
            return sb.substring(0, sb.length()).toUpperCase();
        }
        return sb.substring(0, sb.length() - 1).toUpperCase();
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof MacAddress)) {
            return -1;
        }
        MacAddress mac1 = (MacAddress)o1;
        if (!(o2 instanceof MacAddress)) {
            return 1;
        }
        MacAddress mac2 = (MacAddress)o2;
        if (mac1 == mac2) {
            return 0;
        }
        if (mac1.getBytes() == mac2.getBytes()) {
            return 0;
        }
        if (mac1.getBytes() == null) {
            return -1;
        }
        if (mac2.getBytes() == null) {
            return 1;
        }
        byte[] thisBytes = mac1.getBytes();
        byte[] thatBytes = mac2.getBytes();
        for (int i = 0; i < 6; ++i) {
            if (thisBytes[i] > thatBytes[i]) {
                return 1;
            }
            if (thisBytes[i] >= thatBytes[i]) continue;
            return -1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    private byte[] parse(String macAddressStr) {
        byte[] bytes = new byte[6];
        try {
            boolean isOctetStr;
            String[] tokens = null;
            macAddressStr = macAddressStr.trim();
            boolean bl = isOctetStr = macAddressStr.indexOf(58) > 0;
            if (isOctetStr) {
                this._byteToken = (char)58;
                tokens = macAddressStr.split(":");
            } else {
                this._byteToken = (char)46;
                tokens = macAddressStr.split("\\.");
            }
            if (isOctetStr && tokens.length != 6 && tokens.length != 3) {
                throw new Exception();
            }
            int bidx = 0;
            for (int idx = 0; idx < tokens.length; ++idx) {
                if (isOctetStr) {
                    bytes[bidx++] = (byte)(0xFF & Integer.parseInt(tokens[idx], 16));
                    continue;
                }
                int val = 0xFFFF & Integer.parseInt(tokens[idx], 16);
                bytes[bidx++] = (byte)(val >> 8 & 0xFF);
                bytes[bidx++] = (byte)(val & 0xFF);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid MAC address format - " + macAddressStr, e);
        }
        return bytes;
    }

    public long value() {
        long l = 0L;
        for (int i = 0; i < 6; ++i) {
            l <<= 8;
            l ^= (long)this._bytes[i] & 0xFFL;
        }
        return l;
    }
}

