/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.security.CommunityUserEntry;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUserEntry;
import com.cisco.dcbu.lib.snmp.transport.SnmpTransportProviderIf;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportProvider;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.CmdHandlerIf;
import com.cisco.dcbu.sm.server.CmdTreeNode;
import com.cisco.dcbu.sm.server.ComponentManager;
import com.cisco.dcbu.sm.server.FMServer;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ServerObjectCache;
import com.cisco.dcbu.sm.server.cat.FcPingAnalysis;
import com.cisco.dcbu.sm.server.cat.HealthReportAnalysis;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.fc.FabricCheckAnalysis;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.scheduler.jobs.IndexJob;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.UserManager;
import com.cisco.dcbu.sm.server.sht.SanHealthTool;
import com.cisco.dcbu.sm.server.zone.EnclosureAnalysis;
import com.cisco.dcbu.sm.server.zone.ZoneAnalysis;
import com.cisco.dcbu.sm.server.zone.ZoneDiscrepancyAnalysis;
import com.cisco.dcbu.sm.server.zone.ZoneRoute;
import com.cisco.dcbu.tools.SimulateCallHomeTraps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public final class CliSession
implements Runnable {
    static final Logger _Logger = LogManager.getLogger((String)"fms");
    static final byte CTRL_A = 1;
    static final byte CTRL_Y = 25;
    static final byte CTRL_Z = -1;
    static final byte SPACE = 32;
    static final byte CLOSE_FABRIC = 1;
    static final byte PERSIST_FABRIC = 2;
    static final byte POLL_FABRIC = 3;
    static final byte REDISC_FABRIC = 4;
    static final byte PURGE_DOWN = 5;
    static final byte PURGE_FABRIC = 6;
    static final byte PURGE_SWITCH = 7;
    static final byte MANAGE_FABRIC = 8;
    static final byte UNMANAGE_FABRIC = 9;
    static final byte CLOSE_LAN = 11;
    static final byte PERSIST_LAN = 12;
    static final byte POLL_LAN = 13;
    static final byte REDISC_LAN = 14;
    static final byte PURGE_LANDOWNS = 15;
    static final byte PURGE_LAN = 16;
    static final byte PURGE_ETHSWITCH = 17;
    static final byte MANAGE_LAN = 18;
    static final byte UNMANAGE_LAN = 19;
    static final byte PURGE_CDPSEED = 20;
    static final byte MANAGE_CDPSEED = 21;
    static final byte UNMANAGE_CDPSEED = 22;
    static final byte DISC_CDPSEED = 23;
    static final byte SET_CDPSEED = 24;
    static final byte HOST_CDPSEED = 25;
    static final byte UNHOST_CDPSEED = 26;
    static final byte HOST_LAN = 27;
    static final byte UNHOST_LAN = 28;
    static final byte FAILOVER_FABRIC = 29;
    static final byte FAILOVER_LAN = 30;
    static final String PROP_FABRIC_SNAPSHOT = "fabric.snapshot";
    final CmdTreeNode[] _showCmdNodes = new CmdTreeNode[]{new CmdTreeNode("analysisreports", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showAnalysisReports(params);
        }
    }), new CmdTreeNode("cacheobjects", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showCacheObjects(params);
        }
    }), new CmdTreeNode("component", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showComponent(params);
        }
    }), new CmdTreeNode("enclosure", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showEnclosure(params);
        }
    }), new CmdTreeNode("endport", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showEndPort(params);
        }
    }), new CmdTreeNode("fabric", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showFabric(params);
        }
    }), new CmdTreeNode("hash", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showHash();
        }
    }), new CmdTreeNode("hba", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showHbas();
        }
    }), new CmdTreeNode("inventory", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showInventory(params);
        }
    }), new CmdTreeNode("logger", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showLogger(params);
        }
    }), new CmdTreeNode("lan", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showLan(params);
        }
    }), new CmdTreeNode("lun0", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showLun0();
        }
    }), new CmdTreeNode("peer", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showPeer();
        }
    }), new CmdTreeNode("pmconfig", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showPmConfig(params);
        }
    }), new CmdTreeNode("port", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showPort(params);
        }
    }), new CmdTreeNode("session", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showSession();
        }
    }), new CmdTreeNode("dbpool", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showDbPool();
        }
    }), new CmdTreeNode("snmp", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showSnmp();
        }
    }), new CmdTreeNode("switch", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showSwitch(params);
        }
    }), new CmdTreeNode("scheduler", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showScheduler();
        }
    }), new CmdTreeNode("tech-support", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showTech(params);
        }
    }), new CmdTreeNode("user", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.showUser(params);
        }
    })};
    final CmdTreeNode[] _setCmdNodes = new CmdTreeNode[]{new CmdTreeNode("logger", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setLogger(params);
        }
    }), new CmdTreeNode("peer", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setPeer(params);
        }
    }), new CmdTreeNode("prompt", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setPrompt(params);
        }
    }), new CmdTreeNode("search_interval", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setSearch(params);
        }
    }), new CmdTreeNode("cdpseed", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setPeer(params);
        }
    })};
    final CmdTreeNode[] _purgeCmdNodes = new CmdTreeNode[]{new CmdTreeNode("cdpseed", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeCdpSeed(params);
        }
    }), new CmdTreeNode("down", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeDown(params);
        }
    }), new CmdTreeNode("ethswitch", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeEthSwitch(params);
        }
    }), new CmdTreeNode("fabric", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeFabric(params);
        }
    }), new CmdTreeNode("lan", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeLan(params);
        }
    }), new CmdTreeNode("landowns", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeLanDowns(params);
        }
    }), new CmdTreeNode("switch", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.purgeSwitch(params);
        }
    })};
    final CmdTreeNode[] _l1nodes = new CmdTreeNode[]{new CmdTreeNode("close", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.close(params);
        }
    }), new CmdTreeNode("ech", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.ech(params);
        }
    }), new CmdTreeNode("exit", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.exit();
        }
    }), new CmdTreeNode("info", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.info();
        }
    }), new CmdTreeNode("buildindex", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.buildIndex();
        }
    }), new CmdTreeNode("healthreport", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.healthreprot(params);
        }
    }), new CmdTreeNode("intercept", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.intercept(params);
        }
    }), new CmdTreeNode("ipconfig", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.ipconfig();
        }
    }), new CmdTreeNode("manage", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.manage(params);
        }
    }), new CmdTreeNode("mem", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.mem();
        }
    }), new CmdTreeNode("notrace", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.notrace(params);
        }
    }), new CmdTreeNode("open", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.open(params);
        }
    }), new CmdTreeNode("persist", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.persist(params);
        }
    }), new CmdTreeNode("ping", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.ping(params);
        }
    }), new CmdTreeNode("poll", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.poll(params);
        }
    }), new CmdTreeNode("pmdbsync", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.pmdbsync();
        }
    }), new CmdTreeNode("purge", new NodeCmdHandler(this._purgeCmdNodes)), new CmdTreeNode("rediscover", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.rediscover(params);
        }
    }), new CmdTreeNode("reload", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.reload(params);
        }
    }), new CmdTreeNode("resetdbpool", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.resetDbPool(params);
        }
    }), new CmdTreeNode("set", new NodeCmdHandler(this._setCmdNodes)), new CmdTreeNode("setenv", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.setenv(params);
        }
    }), new CmdTreeNode("show", new NodeCmdHandler(this._showCmdNodes)), new CmdTreeNode("source", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.source(params);
        }
    }), new CmdTreeNode("threads", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.threads(params);
        }
    }), new CmdTreeNode("trace", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.trace(params);
        }
    }), new CmdTreeNode("host", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.host(params);
        }
    }), new CmdTreeNode("unhost", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.unhost(params);
        }
    }), new CmdTreeNode("unmanage", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.unmanage(params);
        }
    }), new CmdTreeNode("view", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.view(params);
        }
    }), new CmdTreeNode("snapshot", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.snapshot(params);
        }
    }), new CmdTreeNode("plmapping", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.plmapping(params);
        }
    }), new CmdTreeNode("stoptcpsession", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.stoptcpsession(params);
        }
    }), new CmdTreeNode("resetsnmp", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.resetSnmp(params);
        }
    }), new CmdTreeNode("discovercdp", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.discoverCdpSeed(params);
        }
    }), new CmdTreeNode("failover", new CmdHandlerIf(){

        @Override
        public void doCmd(String[] params) throws Exception {
            CliSession.this.failover(params);
        }
    })};
    static String LINESEP = System.getProperty("line.separator");
    private final NodeCmdHandler rootNode = new NodeCmdHandler(this._l1nodes);
    private String _prompt = LINESEP + "% ";
    private BufferedReader _inbuf;
    private PrintStream _ps;
    private boolean _isLocal;
    private PrintStream _snmpTrace;
    private Handler _fmLog;
    static final String[] _Invts = new String[]{"?", "card", "chassis", "fan", "hba", "license", "lun0", "powersupply"};
    static final String[] _Mos = new String[]{"?", "alias", "card", "chassis", "enclosure", "fan", "hardware", "hash", "help", "host", "isl", "ivr", "license", "npv", "poll", "port", "power", "seed", "software", "status", "storage", "switch", "vsan", "zone", "vlan"};

    void snapshot(String[] params) throws Exception {
        boolean dbOnly = false;
        boolean newOne = false;
        boolean isLan = false;
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t [fabric/lan] [id] [db-only|full] [new]");
            return;
        }
        if (params.length >= 1 && params[0].indexOf("lan") >= 0) {
            isLan = true;
        } else if (params.length >= 3 && params[2].indexOf("db") >= 0) {
            dbOnly = true;
        } else if (params.length >= 4 && params[3].indexOf("new") >= 0) {
            newOne = true;
        }
        if (isLan) {
            this.snapshotLan(params, dbOnly, newOne);
        } else {
            this.snapshotFabric(params, dbOnly, newOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshotFabric(String[] params, boolean dbOnly, boolean newOne) {
        try {
            FabricImpl fabImpl = this.findFabric(params[1]);
            if (fabImpl == null) {
                throw new Exception("Cannot find fabric:" + params[1]);
            }
            _Logger.info((Object)("Cmd snapshot [fabric/lan] [id] [dbonly|full] [new]: fabric " + fabImpl.getPK() + "," + dbOnly + "," + newOne));
            boolean oldValue = Boolean.getBoolean(PROP_FABRIC_SNAPSHOT);
            if (oldValue != dbOnly) {
                _Logger.info((Object)("Cmd snapshot -> set fabric load db-only:" + dbOnly));
                System.setProperty(PROP_FABRIC_SNAPSHOT, dbOnly ? "true" : "false");
            }
            if (newOne) {
                InetAddress seedIP;
                _Logger.info((Object)("Cmd snapshot ->loading new fabric:" + fabImpl));
                long seedid = fabImpl.getSeedDBID();
                if (seedid == 0L) {
                    seedid = FabricImpl.findSeedSwitchIdByPk(fabImpl.getPK());
                }
                if ((seedIP = SwitchImpl.findSwitchMgmtAddrByPK(seedid)) == null) {
                    throw new Exception("Cannot find seed:" + seedid);
                }
                UsmUserEntry.authenticate(fabImpl.getCredentials(), seedIP);
                SnmpUser user = fabImpl.getCredentials();
                if (user.getRoleName() == null) {
                    throw new Exception("Cannot get user role:" + user);
                }
                _Logger.warn((Object)("CMD>>>>>old " + fabImpl + fabImpl.getLastUpdateTime()));
                fabImpl = SanManager.getInstance().openFabric(seedIP, user, null, null);
                _Logger.warn((Object)("CMD>>>>>new " + fabImpl + fabImpl.getLastUpdateTime()));
                _Logger.warn((Object)("CMD>>>>>new " + fabImpl + fabImpl.getFarbicStatus()));
            } else if (oldValue != dbOnly) {
                _Logger.info((Object)("Cmd snapshot -> re-managing fabric:" + fabImpl));
                SanManager.getInstance().manageFabric(fabImpl.getPK());
                _Logger.warn((Object)("CMD>>>>>old " + fabImpl + fabImpl.getFarbicStatus()));
            }
            long st_time = System.currentTimeMillis();
            long max_time = 300000L;
            while ((newOne || dbOnly) && fabImpl.getFarbicStatus() != 2 && fabImpl.getFarbicStatus() != 4) {
                CliSession cliSession = this;
                synchronized (cliSession) {
                    this.wait(10000L);
                }
                this._ps.print(".");
                if (System.currentTimeMillis() - st_time < max_time) continue;
            }
            this._ps.println();
            if ((newOne || dbOnly) && fabImpl.getFarbicStatus() != 2 && fabImpl.getFarbicStatus() != 4) {
                this._ps.println("Cannot snapshot fabric:" + fabImpl);
            } else {
                String title = "Snapshot Fabric" + (dbOnly ? " (db-only)" : " (full)");
                String fname = FMServer.saveSnapshot(fabImpl, title);
                this._ps.println("snapshot saved to " + fname);
            }
            if (oldValue != dbOnly) {
                System.setProperty(PROP_FABRIC_SNAPSHOT, String.valueOf(oldValue));
                _Logger.info((Object)("Cmd snapshot -> reset fabric load db-only: " + oldValue));
            }
            if (newOne) {
                SanManager.getInstance().closeFabric(fabImpl);
                _Logger.info((Object)("Cmd snapshot ->close new fabric:" + fabImpl));
            } else if (dbOnly) {
                SanManager.getInstance().manageFabric(fabImpl.getPK());
                _Logger.info((Object)("Cmd snapshot -> re-manage fabric with old value:" + fabImpl));
            }
        }
        catch (Exception e) {
            e.printStackTrace(this._ps);
            this._ps.println("snapshot\t [fabric_id] [db-only|full][new]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshotLan(String[] params, boolean dbOnly, boolean newOne) {
        try {
            LanImpl lan = this.findLan(params[1]);
            if (lan == null) {
                throw new Exception("Cannot find LAN:" + params[1]);
            }
            _Logger.info((Object)("Cmd snapshot [fabric/lan] [id] [dbonly|full] [new]: lan " + lan.getPK() + "," + dbOnly + "," + newOne));
            boolean oldValue = Boolean.getBoolean(PROP_FABRIC_SNAPSHOT);
            if (oldValue != dbOnly) {
                _Logger.info((Object)("Cmd snapshot -> set LAN load db-only:" + dbOnly));
                System.setProperty(PROP_FABRIC_SNAPSHOT, dbOnly ? "true" : "false");
            }
            if (newOne) {
                _Logger.info((Object)("Cmd snapshot ->close old LAN and loading new LAN:" + lan));
                List<CdpSeedBase> seeds = GlobalDCManager.getInstance().getCdpSeedsByLanPK(lan.getPK());
                if (seeds != null && seeds.size() > 0) {
                    lan.close(true);
                    CdpSeedImpl task = null;
                    for (CdpSeedBase base : seeds) {
                        task = DCManager.getInstance().createTask(base);
                        if (task != null) continue;
                        System.err.println("Cannot discover the LAN because there is no task for " + base.getSeedIp());
                    }
                    DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_INITIAL);
                }
                _Logger.warn((Object)("CMD>>>>>new " + lan + lan.getLastUpdateTime() + " status: " + lan.getLanStatus()));
            } else if (oldValue != dbOnly) {
                _Logger.info((Object)("Cmd snapshot -> managing LAN:" + lan));
                DCManager.getInstance().manageLan();
                _Logger.warn((Object)("CMD>>>>>old " + lan + lan.getLanStatus()));
            }
            long st_time = System.currentTimeMillis();
            long max_time = 300000L;
            while ((newOne || dbOnly) && lan.getLanStatus() != 2 && lan.getLanStatus() != 4) {
                CliSession cliSession = this;
                synchronized (cliSession) {
                    this.wait(10000L);
                }
                this._ps.print(".");
                if (System.currentTimeMillis() - st_time < max_time) continue;
            }
            this._ps.println();
            if ((newOne || dbOnly) && lan.getLanStatus() != 2 && lan.getLanStatus() != 4) {
                this._ps.println("Cannot snapshot lan:" + lan);
            } else {
                String title = "Snapshot LAN" + (dbOnly ? " (db-only)" : " (full)");
                String fname = FMServer.saveSnapshot(lan, title);
                this._ps.println("snapshot saved to " + fname);
            }
            if (oldValue != dbOnly) {
                System.setProperty(PROP_FABRIC_SNAPSHOT, String.valueOf(oldValue));
                _Logger.info((Object)("Cmd snapshot -> reset LAN load db-only: " + oldValue));
            }
            if (dbOnly) {
                DCManager.getInstance().manageLan();
                _Logger.info((Object)("Cmd snapshot -> re-manage LAN:" + lan));
            }
        }
        catch (Exception e) {
            e.printStackTrace(this._ps);
            this._ps.println("snapshot\t [fabric/lan] [id] [db-only|full][new]");
        }
    }

    void plmapping(String[] params) throws Exception {
        ClusterMapping cluster = ClusterMapping.getInstance();
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t [-p|-d|-show] \n");
            this._ps.println("\t -p            -- Insert/update ip address/server id mapping \n ");
            this._ps.println("\t -d            -- Delete a row for ip address/server if mapping based on server id \n ");
            this._ps.println("\t -show         -- Show all the entries in ip address/server id mapping table\n ");
            this._ps.println("\t -moveserver   -- replace the exsiting server with new server, the new server need to be restarted afterwards\n ");
            return;
        }
        if (params[0].indexOf("-p") != -1) {
            if (params.length != 3) {
                this._ps.println(" <ip> <serverId> ");
            } else {
                InetAddress inetAddress = InetAddress.getByName(params[1]);
                cluster.persitPHYSICAL(inetAddress, Integer.parseInt(params[2]));
            }
        } else if (params[0].indexOf("-d") != -1) {
            if (params.length != 2) {
                this._ps.println("<serverId> ");
            } else {
                cluster.deletePHYSICAL(Integer.parseInt(params[1]));
            }
        } else if (params[0].indexOf("-show") != -1) {
            List<String> ips = cluster.qALlIPStrings();
            for (String ip : ips) {
                this._ps.println("\t" + ip + ", " + cluster.qSIdFromIP(InetAddress.getByName(ip)));
            }
        } else if (params[0].indexOf("-moveserver") != -1) {
            if (params.length != 3) {
                this._ps.println(" <oldIP> <newIP>   --  and the new server need to be restarted afterwards ");
            } else {
                InetAddress old_addr = InetAddress.getByName(params[1]);
                InetAddress new_addr = InetAddress.getByName(params[2]);
                cluster.replaceServer(old_addr, new_addr);
            }
        } else {
            this._ps.println("\t [-p|-d|-show|-moveserver] ");
        }
    }

    private CliSession(InputStream is, PrintStream ps, boolean isLocal) {
        this._inbuf = new BufferedReader(new InputStreamReader(is));
        this._ps = ps;
        this._isLocal = isLocal;
        Arrays.sort(this._l1nodes);
        Arrays.sort(this._showCmdNodes);
        Arrays.sort(this._setCmdNodes);
    }

    public static CliSession createLocal() {
        return new CliSession(System.in, System.out, true);
    }

    public static CliSession createRemote(Socket client) throws IOException {
        return new CliSession(client.getInputStream(), new PrintStream(client.getOutputStream()), false);
    }

    @Override
    public void run() {
        StringBuffer sb = new StringBuffer();
        boolean cmd = false;
        this._ps.print(LINESEP + this._prompt);
        this._ps.flush();
        while (!Thread.interrupted()) {
            int ch;
            block15: {
                try {
                    ch = this._inbuf.read();
                    if (ch == -1) {
                    }
                    break block15;
                }
                catch (SocketTimeoutException ste) {
                    LogManager.getLogger((String)"fms").info((Object)"Remote console timed out");
                }
                catch (IOException ioEx) {
                    System.err.println(ioEx);
                }
                break;
            }
            try {
                if (ch >= 32) {
                    sb.append((char)ch);
                    continue;
                }
                if (ch < 1 || ch > 25) continue;
                switch (ch) {
                    case 10: {
                        if (sb.length() != 0 || cmd) {
                            String[] args = this.parseInput(sb.toString());
                            if (!cmd) {
                                this.rootNode.doCmd(args);
                            } else {
                                cmd = false;
                            }
                            sb.setLength(0);
                        }
                        this._ps.print(this._prompt);
                        this._ps.flush();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        this._ps.println("invalid shortcut Ctrl-" + (char)(ch + 65 - 1));
                    }
                }
            }
            catch (Exception ex) {
                sb.setLength(0);
                LogManager.getLogger((String)"fms").log((Priority)Level.ERROR, (Object)"debug console error.", (Throwable)ex);
            }
        }
        this.dispose();
    }

    public void dispose() {
        if (this._snmpTrace != null) {
            this._snmpTrace = null;
        }
        if (this._fmLog != null) {
            this._fmLog = null;
        }
        try {
            this._inbuf.close();
            this._ps.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._inbuf = null;
        this._ps = null;
    }

    String[] parseInput(String cmd) throws Exception {
        StringTokenizer st = new StringTokenizer(cmd, " ");
        String[] tks = null;
        if (st.countTokens() == 0) {
            return null;
        }
        tks = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tks[i++] = st.nextToken();
        }
        return tks;
    }

    void close(String[] params) throws Exception {
        if (this.findFabric(params[0]) != null) {
            this.fabricAction(params, (byte)1);
        } else if (this.findLan(params[0]) != null) {
            this.lanAction(params, (byte)11);
        }
    }

    void exit() throws Exception {
        if (this._isLocal) {
            ComponentManager.shutdown("exit from console");
            System.exit(0);
        } else {
            Thread.currentThread().interrupt();
        }
    }

    void info() throws Exception {
        this._ps.println(ComponentManager.info());
        EventControllerService ecs = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
        if (ecs != null) {
            this._ps.println("Event Server" + LINESEP + ecs.getStatus());
        }
    }

    void healthreprot(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t[healthreprot fid]");
        } else {
            int fid = Integer.parseInt(params[0]);
            SanHealthTool.getInstance().generateReport(fid, true);
        }
    }

    void intercept(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t[snmp|fmlog|off]");
        } else if (!("snmp".startsWith(params[0].toLowerCase()) && this._snmpTrace == null || "fmlog".startsWith(params[0].toLowerCase()) && this._fmLog == null || !"off".startsWith(params[0].toLowerCase()))) {
            if (this._snmpTrace != null) {
                this._snmpTrace = null;
            }
            if (this._fmLog != null) {
                this._fmLog = null;
            }
        }
    }

    void ipconfig() throws Exception {
        this._ps.println(StringUtil.indentLines(NetUtil.getLocalIpConfig()));
        SnmpSession ss = SnmpSession.getInstance();
        if (ss.getLocalVPNAddress() != null && ss.getLocalVPNAddress().length() != 0) {
            this._ps.println("\tVPN address: " + ss.getLocalVPNAddress());
        }
    }

    void mem() throws Exception {
        this._ps.println("\t" + Runtime.getRuntime().freeMemory() + "\tbytes of free memory in the JVM" + LINESEP + "\t" + Runtime.getRuntime().maxMemory() + "\tbytes of maximum amount of memory that the JVM will attempt to use." + LINESEP + "\t" + Runtime.getRuntime().totalMemory() + "\tbytes of total amount of memory in the JVM");
    }

    void notrace(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[snmp|trap]");
        } else if ("snmp".startsWith(params[0].toLowerCase())) {
            SnmpSession.getInstance();
            SnmpSession.setTrace(false);
        } else if ("trap".startsWith(params[0].toLowerCase())) {
            SnmpTrapSession.setTrace(false);
        }
    }

    void open(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[deviceName] [userName] [authPassword] <v3> [authProtocl<MD5|SHA>] <privPassword> [privProtocl<DES|AES>] [ignoreCache<true|false>]");
        } else if (params.length > 2) {
            SnmpUser user;
            boolean v3;
            InetAddress ipAddr = InetAddress.getByName(params[0]);
            boolean bl = v3 = params.length <= 3 || params[3].equalsIgnoreCase("v3");
            if (v3) {
                int privProt = -1;
                String privPassword = null;
                if (params.length > 5) {
                    privProt = params[6].equalsIgnoreCase("DES") ? 0 : 1;
                    privPassword = params[5];
                }
                user = UsmUserEntry.authenticate(params[1], params.length > 4 && !params[4].equalsIgnoreCase("MD5") ? 1 : 0, params[2], privProt, privPassword, ipAddr);
            } else {
                user = CommunityUserEntry.authenticate(params[1], ipAddr);
            }
            SanManager.getInstance().openFabric(ipAddr, user, null, null);
        }
    }

    void manage(String[] params) throws Exception {
        FabricPK pkey = new FabricPK(Integer.parseInt(params[0]));
        String name = GlobalFabricManager.getInstance().getFabricName(pkey);
        if (name != null) {
            this.fabricAction(params, (byte)8);
        } else if (params.length > 1) {
            this.lanAction(params, (byte)21);
        } else {
            this.lanAction(params, (byte)18);
        }
    }

    void unmanage(String[] params) throws Exception {
        block4: {
            try {
                if (this.findFabric(params[0]) != null) {
                    this.fabricAction(params, (byte)9);
                }
            }
            catch (Exception e) {
                if (this.findLan(params[0]) == null) break block4;
                if (params.length > 1) {
                    this.lanAction(params, (byte)22);
                }
                this.lanAction(params, (byte)19);
            }
        }
    }

    void host(String[] params) throws Exception {
        block4: {
            try {
                if (this.findFabric(params[0]) != null) {
                    this.fabricAction(params, (byte)9);
                }
            }
            catch (Exception e) {
                if (this.findLan(params[0]) == null) break block4;
                if (params.length > 1) {
                    this.lanAction(params, (byte)25);
                }
                this.lanAction(params, (byte)27);
            }
        }
    }

    void unhost(String[] params) throws Exception {
        block4: {
            try {
                if (this.findFabric(params[0]) != null) {
                    this.fabricAction(params, (byte)9);
                }
            }
            catch (Exception e) {
                if (this.findLan(params[0]) == null) break block4;
                if (params.length > 1) {
                    this.lanAction(params, (byte)26);
                }
                this.lanAction(params, (byte)28);
            }
        }
    }

    void failover(String[] params) throws Exception {
        block3: {
            try {
                if (this.findFabric(params[0]) != null) {
                    this.fabricAction(params, (byte)29);
                }
            }
            catch (Exception e) {
                if (this.findLan(params[0]) == null) break block3;
                this.lanAction(params, (byte)30);
            }
        }
    }

    void persist(String[] params) throws Exception {
        if (this.findFabric(params[0]) != null) {
            this.fabricAction(params, (byte)2);
        } else if (this.findLan(params[0]) != null) {
            this.lanAction(params, (byte)12);
        }
    }

    void ping(String[] params) throws Exception {
        if (params.length == 1) {
            this._ps.println(params[0] + " is " + (InetAddress.getByName(params[0]).isReachable(1000) ? "reachable" : "unreachable"));
        } else {
            int timeout = params.length >= 3 ? Integer.parseInt(params[2]) : 1000;
            this._ps.println(params[0] + "/" + params[1] + " is " + (NetUtil.isReachable(InetAddress.getByName(params[0]), Integer.parseInt(params[1]), timeout) ? "reachable" : "unreachable"));
        }
    }

    void poll(String[] params) throws Exception {
        if (this.findFabric(params[0]) != null) {
            this.fabricAction(params, (byte)3);
        } else if (this.findLan(params[0]) != null) {
            this.lanAction(params, (byte)13);
        }
    }

    void purgeDown(String[] params) throws Exception {
        this.fabricAction(params, (byte)5);
    }

    void purgeFabric(String[] params) throws Exception {
        this.fabricAction(params, (byte)6);
    }

    void purgeSwitch(String[] params) throws Exception {
        this.fabricAction(params, (byte)7);
    }

    void purgeLanDowns(String[] params) throws Exception {
        this.lanAction(params, (byte)15);
    }

    void purgeLan(String[] params) throws Exception {
        this.lanAction(params, (byte)16);
    }

    void purgeCdpSeed(String[] params) throws Exception {
        this.lanAction(params, (byte)20);
    }

    void purgeEthSwitch(String[] params) throws Exception {
        this.lanAction(params, (byte)17);
    }

    void discoverCdpSeed(String[] params) throws Exception {
        if (this.findLan(params[0]) != null) {
            this.lanAction(params, (byte)23);
        }
    }

    void rediscover(String[] params) throws Exception {
        if (this.findFabric(params[0]) != null) {
            this.fabricAction(params, (byte)4);
        } else if (this.findLan(params[0]) != null) {
            this.lanAction(params, (byte)14);
        }
    }

    void resetDbPool(String[] params) throws Exception {
        ConnectionManager.closeAll();
    }

    void reload(String[] params) throws Exception {
    }

    void setenv(String[] params) throws Exception {
        String propName = null;
        String propValue = null;
        boolean showProp = false;
        boolean setProp = false;
        if (params == null || params.length == 0) {
            showProp = true;
        } else {
            int pos = params[0].indexOf("=");
            if (pos != -1) {
                propName = params[0].substring(0, pos);
                setProp = true;
                if (params[0].length() > pos + 1) {
                    propValue = params[0].substring(pos + 1);
                }
            } else {
                propName = params[0];
                if (params.length > 1 && params[1].equals("=")) {
                    setProp = true;
                    if (params.length > 2) {
                        propValue = params[2];
                    }
                } else {
                    propValue = System.getProperty(propName);
                    if (propValue != null && propValue.length() != 0) {
                        showProp = true;
                    }
                }
            }
        }
        if (setProp) {
            if (propValue != null) {
                System.setProperty(propName, propValue);
            } else {
                System.getProperties().remove(propName);
            }
        } else if (showProp) {
            if (propName != null) {
                this._ps.println('\t' + propName + " = " + propValue);
            } else {
                this._ps.println(GenUtil.dumpEnvs());
            }
        }
    }

    void setFabric(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[fabric_id] poll [poll_interval]");
        } else {
            FabricImpl fabric = this.findFabric(params[0]);
            if ("poll".startsWith(params[1].toLowerCase())) {
                DiscoveryManager.getInstance().setPollInterval(fabric, Integer.parseInt(params[2]));
                this._ps.println("new poll interval: " + fabric.getPollInterval());
            } else if ("rediscover".startsWith(params[1].toLowerCase())) {
                fabric.setRediscoverInterval(Integer.parseInt(params[2]));
                this._ps.println("new rediscover interval: " + fabric.getRediscoverInterval());
            }
        }
    }

    void setLogger(String[] params) {
        LoggerRepository lRep = LogManager.getLoggerRepository();
        if (params == null || params.length < 1 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t [logger_name][ALL|DEBUG|ERROR|FATAL|INFO|OFF|TRACE|TRACE_INT|WARN]");
        } else if (params.length > 1) {
            String logger = params[0];
            String levelString = params[1];
            if (lRep.exists(logger) == null) {
                this._ps.println("The logger: " + logger + " does not exist!");
                return;
            }
            Logger log = lRep.getLogger(logger);
            log.setLevel(Level.toLevel((String)levelString));
        }
    }

    void setSearch(String[] params) {
        if (params == null || params.length < 1 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t [No of hours (Integer) e.g 5]");
        } else if (params.length == 1) {
            String interval = params[0];
            try {
                int intervalNum = Integer.parseInt(interval);
                if (intervalNum < 1) {
                    throw new Exception("Value should be more than 0!");
                }
                System.setProperty("fmsearch.interval", interval);
            }
            catch (Exception ex) {
                this._ps.println("\t [No of hours (Integer) e.g 5]");
            }
        }
    }

    void setPeer(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t[IP_ADDRESS]");
        } else {
            InetAddress ip = InetAddress.getByName(params[0]);
            SnmpPeer peer = SnmpPeer.findPeer(ip);
            if (peer != null) {
                if (params.length == 1) {
                    this._ps.println("\ttimeout\tretries");
                } else if ("timeout".startsWith(params[1].toLowerCase())) {
                    if (params.length == 2) {
                        this._ps.println("\t[TIMEOUT]");
                    } else {
                        peer.setTimeout(Integer.parseInt(params[2]));
                    }
                } else if ("retries".startsWith(params[1].toLowerCase())) {
                    if (params.length == 2) {
                        this._ps.println("\t[RETRIES]");
                    } else {
                        peer.setRetries(Integer.parseInt(params[2]));
                    }
                } else {
                    this._ps.println("invalid keywork " + params[1]);
                }
            } else {
                this._ps.println("peer " + params[0] + " does not exist");
            }
        }
    }

    void setPrompt(String[] params) throws Exception {
        if (params.length > 0) {
            this._prompt = params[0] == null ? LINESEP + "% " : LINESEP + params[0] + ' ';
        }
    }

    void showComponent(String[] params) throws Exception {
        Enumeration en = ServiceConfig.serviceNames();
        while (en.hasMoreElements()) {
            this._ps.println((String)en.nextElement());
        }
    }

    void showEnclosure(String[] params) throws Exception {
        Object[] encls = SanManager.getInstance().getEnclosures();
        if (encls != null) {
            Arrays.sort(encls);
        }
        boolean host = false;
        boolean storage = false;
        boolean detail = false;
        if (params != null && params.length != 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equalsIgnoreCase("-host")) {
                    host = true;
                    continue;
                }
                if (params[i].equalsIgnoreCase("-storage")) {
                    storage = true;
                    continue;
                }
                if (params[i].equals("?") || "help".startsWith(params[i].toLowerCase())) {
                    this._ps.println("\t<-host> <-storage> <-d>");
                    continue;
                }
                if (params[i].equals("-d")) {
                    detail = true;
                    continue;
                }
                throw new Exception("invalid option \"" + params[0] + "\"");
            }
        }
        if (!host && !storage) {
            storage = true;
            host = true;
        }
        int count = 0;
        for (int i = 0; i < encls.length; ++i) {
            if ((!((EnclosureImpl)encls[i]).isStorage() || !storage) && (!((EnclosureImpl)encls[i]).isHost() || !host)) continue;
            this._ps.println(detail ? ((EnclosureImpl)encls[i]).dump(1) : ((AbstractModelObjectImpl)encls[i]).toString());
            ++count;
        }
        this._ps.println("total: " + count);
    }

    void showCacheObjects(String[] params) throws Exception {
        String clearType = null;
        if (params != null && (params.length == 1 || params.length == 2)) {
            if (params.length == 2 && params[0].equalsIgnoreCase("-c")) {
                clearType = params[1];
            } else if (params.length == 1 && params[0].equalsIgnoreCase("-v")) {
                this._ps.println(ServerObjectCache.getAllCachedObject().toString());
            }
        } else {
            this._ps.println("show cacheobjects <-c zoneroute or portsecurity or all><-v>");
        }
        if (clearType != null) {
            ServerObjectCache.clearObjects(clearType);
        }
    }

    void showAnalysisReports(String[] params) throws Exception {
        int reportType = 0;
        int fabric = 0;
        String vsanWWN = null;
        String swIp = null;
        String policyfile = null;
        short vsanIndex = -1;
        short vSrc = -1;
        short vDst = -1;
        String epSrc = null;
        String epDst = null;
        boolean compareZoneRoute = false;
        if (params != null && params.length != 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equals("h2s")) {
                    reportType = 2;
                    continue;
                }
                if (params[i].equals("s2h")) {
                    reportType = 3;
                    continue;
                }
                if (params[i].equals("mpath")) {
                    reportType = 1;
                    continue;
                }
                if (params[i].equals("zone-discrepancy")) {
                    reportType = 4;
                    continue;
                }
                if (params[i].equals("config")) {
                    reportType = 5;
                    continue;
                }
                if (params[i].equals("health")) {
                    reportType = 6;
                    continue;
                }
                if (params[i].equals("fcping")) {
                    reportType = 7;
                    continue;
                }
                if (params[i].equals("zoneroute")) {
                    reportType = 8;
                    continue;
                }
                if (params[i].equals("-f")) {
                    if (params.length <= ++i) continue;
                    fabric = Integer.parseInt(params[i]);
                    continue;
                }
                if (params[i].equals("-v")) {
                    if (params.length <= ++i) continue;
                    vsanIndex = (short)Integer.parseInt(params[i].trim());
                    continue;
                }
                if (params[i].equals("-p")) {
                    if (params.length <= ++i) continue;
                    swIp = params[i];
                    continue;
                }
                if (params[i].equals("?") || "help".startsWith(params[i].toLowerCase())) {
                    this._ps.println("\t{h2s,s2h,mpath,zone-discrepancy,fcping} <-f fabricId> <-v vsanId><-p vsanPrincipalSwitchIP> ");
                    this._ps.println("\t{config  <-f fabricId> <-policy policyfile>");
                    this._ps.println("\t{health  <-f fabricId>");
                    return;
                }
                if (params[i].equals("-policy")) {
                    if (params.length <= ++i) continue;
                    policyfile = params[i];
                    continue;
                }
                if (params[i].equals("-epSrc") || params[i].equals("-epDst")) {
                    if (params.length <= ++i) continue;
                    if (params[i - 1].equals("-epSrc")) {
                        epSrc = params[i];
                        continue;
                    }
                    epDst = params[i];
                    continue;
                }
                if (params[i].equals("-vSrc") || params[i].equals("-vDst")) {
                    if (params.length <= ++i) continue;
                    if (params[i - 1].equals("-vSrc")) {
                        vSrc = Short.parseShort(params[i]);
                        continue;
                    }
                    vDst = Short.parseShort(params[i]);
                    continue;
                }
                if (!params[i].equals("reversecompare")) continue;
                compareZoneRoute = true;
            }
            SwitchImpl swImpl = SanManager.getInstance().findSwitch(InetAddress.getByName(swIp), null);
            Wwn wwnVsan = null;
            if (vsanIndex != -1) {
                wwnVsan = swImpl == null ? null : swImpl.getVsan(vsanIndex).getPrincipalSwitch().getVsanWwn(vsanIndex);
                vsanWWN = Integer.toHexString(vsanIndex) + ":" + SnmpString.toHexString(wwnVsan.getValue());
            }
            ArrayList data = null;
            switch (reportType) {
                case 2: 
                case 3: {
                    data = ZoneAnalysis.getInstance().generateReportSynchronously(fabric, vsanWWN, null, reportType, -1L, -1L);
                    this.showZoneAnalysisReport(data);
                    return;
                }
                case 1: {
                    data = EnclosureAnalysis.getInstance().generateReportSynchronously(fabric, vsanWWN, null, reportType, -1L, -1L);
                    this.showEnclosureReport(data);
                    return;
                }
                case 4: {
                    data = ZoneDiscrepancyAnalysis.getInstance().generateReportSynchronously(fabric, vsanWWN, null, reportType, -1L, -1L);
                    this.showZoneDiscrepancyReport(data);
                    return;
                }
                case 5: {
                    data = FabricCheckAnalysis.getInstance().generateReportSynchronously(fabric, null, new Object[]{policyfile, null, null}, reportType, -1L, -1L);
                    this.showFabricConfigReport(data);
                    return;
                }
                case 6: {
                    data = HealthReportAnalysis.getInstance().generateReportSynchronously(fabric, null, new Object[]{Boolean.TRUE, Boolean.TRUE}, reportType, -1L, -1L);
                    this.showFabricConfigReport(data);
                    return;
                }
                case 7: {
                    data = FcPingAnalysis.getInstance().generateReportSynchronously(fabric, vsanWWN, null, reportType, -1L, -1L);
                    this.showFcPingReport(data);
                    return;
                }
                case 8: {
                    ZoneRoute zrt = ZoneRoute.newInstance();
                    if (!compareZoneRoute) {
                        ZoneRoute.runReport(epSrc, vSrc, epDst, vDst, (ReportAnalysis)zrt);
                    } else {
                        ZoneRoute.runComparisonReport(epSrc, vSrc, epDst, vDst, zrt);
                    }
                    return;
                }
            }
            this._ps.println("\t{h2s,s2h,mpath,zone-discrepancy} <-f fabricId> <-v vsanId><-p vsanPrincipalSwitchIP> ");
            this._ps.println("\t{config  <-f fabricId> <-policy policyfile>");
            this._ps.println("\t{health  <-f fabricId>");
            this._ps.print(data);
        }
    }

    private void showFabricConfigReport(ArrayList reportList) {
        for (int i = 0; i < reportList.size(); ++i) {
            Object[] eData = (Object[])reportList.get(i);
            if (eData != null) {
                for (int k = 0; k < eData.length; ++k) {
                    this._ps.print(eData[k] + "   ");
                }
                this._ps.println();
            }
            this._ps.println();
        }
    }

    private void showFcPingReport(ArrayList reportList) {
        for (Object[] obb : reportList) {
            this._ps.println(obb[0].toString());
            this._ps.println(", " + obb[1].toString());
            this._ps.println(" to " + obb[2].toString() + "\n");
            this._ps.println(obb[3].toString());
        }
    }

    private void showEnclosureReport(ArrayList reportList) {
        for (int i = 0; i < reportList.size(); ++i) {
            Object[] eData = (Object[])reportList.get(i);
            if (eData != null) {
                this._ps.print(eData[0] + " can communicate with:\n");
                this._ps.print("\t" + eData[1] + " active paths: " + eData[2] + "\n");
                this._ps.print("\t Details:" + eData[3] + " \n");
                this._ps.print("\t inactive paths: " + eData[4] + "\n");
                this._ps.print("\t Details:" + eData[5] + " \n");
            }
            this._ps.println();
        }
    }

    private void showZoneAnalysisReport(ArrayList reportList) {
        for (int i = 0; i < reportList.size(); ++i) {
            Object[] data = (Object[])reportList.get(i);
            this._ps.println(data[0].toString() + " can communicate with ");
            HashMap wwnMap = (HashMap)data[1];
            for (Map.Entry obEntry : wwnMap.entrySet()) {
                String wwn = (String)obEntry.getKey();
                StringBuffer zoneList = new StringBuffer();
                HashMap vsanZnListMap = (HashMap)obEntry.getValue();
                this._ps.println(" WWN:" + wwn + "  via ");
                for (Map.Entry obEntry1 : vsanZnListMap.entrySet()) {
                    String vsanName = (String)obEntry1.getKey();
                    ArrayList znList = (ArrayList)obEntry1.getValue();
                    for (int zn = 0; zn < znList.size(); ++zn) {
                        if (zoneList.length() > 0) {
                            zoneList.append(", ");
                        }
                        zoneList.append(znList.get(zn));
                    }
                    zoneList.append(", ");
                    this._ps.println("                for VSAN " + vsanName);
                    this._ps.println("                via zones:" + zoneList);
                }
            }
        }
    }

    private void showZoneDiscrepancyReport(ArrayList reportList) {
        String[] name = new String[]{"Status", "Empty/Single member Zone", "Unzoned", "Only Initiator", "DefaultPermit", "Distribute Flag", "PDU Errors"};
        for (int i = 0; i < reportList.size(); ++i) {
            ArrayList data = (ArrayList)reportList.get(i);
            this._ps.println(name[i] + ":");
            for (int k = 0; k < data.size(); ++k) {
                Object[] rows = (Object[])data.get(k);
                if (rows == null) continue;
                for (int j = 0; j < rows.length; ++j) {
                    this._ps.print("\t" + (rows[j] != null ? rows[j].toString() + "\n" : "\n"));
                }
                this._ps.println();
            }
        }
    }

    void showEndPort(String[] params) throws Exception {
        int i;
        Object[] eps = SanManager.getInstance().getEndPorts();
        if (eps != null) {
            Arrays.sort(eps);
        }
        boolean detail = false;
        if (params != null && params.length != 0) {
            for (i = 0; i < params.length; ++i) {
                if (!params[i].equals("-d")) continue;
                detail = true;
            }
        }
        this._ps.println(eps.length + " endports:");
        for (i = 0; i < eps.length; ++i) {
            this._ps.println("\t" + (detail ? ((EndPortImpl)eps[i]).dump(1) : ((EndPortImpl)eps[i]).getDetails()));
        }
    }

    void showHash() {
        this._ps.println(SanManager.getInstance().dumpHashes());
    }

    void showHbas() throws Exception {
        Hba[] hbas = InventoryManager.getInstance().getHbas();
        if (hbas != null) {
            for (int i = 0; i < hbas.length; ++i) {
                this._ps.println(LINESEP + hbas[i]);
            }
        }
    }

    void showInventory(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            this._ps.println(InventoryManager.getInstance().dump());
        } else {
            int index = GenUtil.searchUniqueMatch(_Invts, params[0]);
            if (index >= 0) {
                switch (index) {
                    case 0: 
                    case 1: {
                        this.showCard();
                        break;
                    }
                    case 2: {
                        this.showChassis();
                        break;
                    }
                    case 3: {
                        this.showFan();
                        break;
                    }
                    case 4: {
                        this.showHba();
                        break;
                    }
                    case 5: {
                        this.showLicense();
                        break;
                    }
                    case 6: {
                        this.showScsiTarget();
                        break;
                    }
                    case 7: {
                        this.showPowerSupply();
                        break;
                    }
                    default: {
                        index = -1;
                    }
                }
            }
            if (index < 0) {
                this._ps.println("invalid keyword \"" + params[0] + "\"");
            }
        }
    }

    void showChassis() {
        StringBuffer sb = new StringBuffer();
        InventoryManager im = InventoryManager.getInstance();
        SanManager sm = SanManager.getInstance();
        DCManager dcm = DCManager.getInstance();
        PKIf[] pks = InventoryManager.getInstance().getSwitchPKs();
        for (int i = 0; i < pks.length; ++i) {
            HwInventoryComponent comp = im.findChassis(pks[i]);
            if (comp == null) continue;
            SwitchIf sw = (SwitchIf)((Object)(pks[i] instanceof WwnKey ? sm.findSwitch((WwnKey)pks[i], null) : dcm.findEthSwitchBySwPK((SerialNumKey)pks[i])));
            sb.append("\n").append(sw.getName()).append(": chassis").append(GenUtil.dump(comp, "\t")).append("\n");
        }
        this._ps.println(sb.toString());
    }

    void showCard() {
        StringBuffer sb = new StringBuffer();
        InventoryManager im = InventoryManager.getInstance();
        SanManager sm = SanManager.getInstance();
        DCManager dcm = DCManager.getInstance();
        PKIf[] pks = InventoryManager.getInstance().getSwitchPKs();
        for (int i = 0; i < pks.length; ++i) {
            List<Card> cards = im.findCards(pks[i]);
            if (cards.size() == 0) continue;
            Collections.sort(cards);
            SwitchIf sw = (SwitchIf)((Object)(pks[i] instanceof WwnKey ? sm.findSwitch((WwnKey)pks[i], null) : dcm.findEthSwitchBySwPK(pks[i])));
            sb.append("\n").append(sw.getName()).append(": ").append(cards.size()).append(" cards");
            Iterator<Card> it = cards.iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showFan() {
        StringBuffer sb = new StringBuffer();
        InventoryManager im = InventoryManager.getInstance();
        SanManager sm = SanManager.getInstance();
        DCManager dcm = DCManager.getInstance();
        PKIf[] pks = InventoryManager.getInstance().getSwitchPKs();
        for (int i = 0; i < pks.length; ++i) {
            List<HwInventoryComponent> comps = im.findFans(pks[i]);
            if (comps.size() == 0) continue;
            SwitchIf sw = (SwitchIf)((Object)(pks[i] instanceof WwnKey ? sm.findSwitch((WwnKey)pks[i], null) : dcm.findEthSwitchBySwPK((SerialNumKey)pks[i])));
            sb.append("\n").append(sw.getName()).append(": ").append(comps.size()).append(" fans");
            Iterator it = comps.iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showPowerSupply() {
        StringBuffer sb = new StringBuffer();
        InventoryManager im = InventoryManager.getInstance();
        SanManager sm = SanManager.getInstance();
        DCManager dcm = DCManager.getInstance();
        PKIf[] pks = InventoryManager.getInstance().getSwitchPKs();
        for (int i = 0; i < pks.length; ++i) {
            List<PowerSupply> comps = im.findPowerSupplies(pks[i]);
            if (comps.size() == 0) continue;
            SwitchIf sw = (SwitchIf)((Object)(pks[i] instanceof WwnKey ? sm.findSwitch((WwnKey)pks[i], null) : dcm.findEthSwitchBySwPK((SerialNumKey)pks[i])));
            sb.append("\n").append(sw.getName()).append(": ").append(comps.size()).append(" power supplies");
            Iterator it = comps.iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showLicense() {
        StringBuffer sb = new StringBuffer();
        InventoryManager im = InventoryManager.getInstance();
        SanManager sm = SanManager.getInstance();
        PKIf[] pks = InventoryManager.getInstance().getSwitchPKs();
        for (int i = 0; i < pks.length; ++i) {
            if (!(pks[i] instanceof WwnKey)) continue;
            WwnKey swPK = (WwnKey)pks[i];
            List<LicenseInfo> comps = im.findLicenses(swPK);
            Collections.sort(comps);
            if (comps.size() == 0) continue;
            SwitchImpl sw = sm.findSwitch(swPK, null);
            sb.append("\n").append(sw.getName()).append(": ").append(comps.size()).append(" licenses");
            Iterator<LicenseInfo> it = comps.iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showHba() {
        StringBuffer sb = new StringBuffer();
        Hba[] hbas = InventoryManager.getInstance().getHbas();
        if (hbas.length != 0) {
            sb.append("\n").append(hbas.length).append(" HBAs");
            for (int i = 0; i < hbas.length; ++i) {
                sb.append(GenUtil.dump(hbas[i], "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showScsiTarget() {
        StringBuffer sb = new StringBuffer();
        ScsiTarget[] lun0s = InventoryManager.getInstance().getScsiTargets();
        if (lun0s.length != 0) {
            sb.append("\n").append(lun0s.length).append(" SCSI targets");
            for (int i = 0; i < lun0s.length; ++i) {
                sb.append(GenUtil.dump(lun0s[i], "\t")).append("\n");
            }
        }
        this._ps.println(sb.toString());
    }

    void showFabric(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            FabricPK[] fabrics = SanManager.getInstance().getFabricPKs();
            for (int i = 0; i < fabrics.length; ++i) {
                String statString = SanManager.getInstance().isOpened(fabrics[i]) ? "managed" : "unmanaged";
                this._ps.println("\t" + fabrics[i]._fid + ": " + fabrics[i].toString() + " : " + statString);
            }
        } else if (params[1].equals("?") || "help".startsWith(params[1].toLowerCase())) {
            this._ps.println("\t<Fabric ID|deviceName>");
        } else {
            FabricImpl fabric = this.findFabric(params[0]);
            boolean detail = params[params.length - 1].equals("-d");
            if (params.length == 1 || params.length == 2 && detail) {
                this._ps.println(fabric.dumpFabric(detail));
            } else {
                int index = GenUtil.searchUniqueMatch(_Mos, params[1]);
                if (index >= 0) {
                    block0 : switch (index) {
                        case 0: 
                        case 8: {
                            this._ps.println("\tenc hash host isl ivr lic poll port seed status storage switch vsan zone");
                            break;
                        }
                        case 1: {
                            this._ps.println(fabric.dumpDeviceAliases(detail, 0));
                            break;
                        }
                        case 4: {
                            this._ps.println(fabric.dumpEnclosures(detail, 0, 3));
                            break;
                        }
                        case 7: {
                            this._ps.println(fabric.dumpHashes());
                            break;
                        }
                        case 9: {
                            this._ps.println(fabric.dumpEnclosures(detail, 0, 1));
                            break;
                        }
                        case 10: {
                            this._ps.println(fabric.dumpIsls(detail, 0));
                            break;
                        }
                        case 11: {
                            this._ps.println(fabric.dumpIvr(0));
                            break;
                        }
                        case 12: {
                            SwitchImpl sw = fabric.getLicenseServer();
                            this._ps.println("License server: " + (sw != null ? sw.getIpAddress() : "none"));
                            SwitchImpl[] sws = fabric.getSwitches();
                            for (int i = 0; i < sws.length; ++i) {
                                LicenseInfo lic = InventoryManager.getInstance().findLicense(sws[i].getSwitchPK(), "FM_SERVER_PKG");
                                if (lic == null) continue;
                                this._ps.println("\tLicense at " + sws[i].getIpAddress() + " : " + lic.toString());
                            }
                            break;
                        }
                        case 13: {
                            this._ps.println(fabric.dumpNpvLinks(detail, 0));
                            break;
                        }
                        case 14: {
                            this._ps.println("poll interval: " + fabric.getPollInterval());
                            break;
                        }
                        case 15: {
                            this._ps.println(fabric.dumpEndPorts(detail, 0));
                            break;
                        }
                        case 17: {
                            this._ps.println("\tfabric seed: " + fabric.getSeed());
                            this._ps.println("\tIVR seed: " + fabric.getIvrSeed());
                            this._ps.println("\talias seed: " + fabric.getAliasSeed());
                            break;
                        }
                        case 19: {
                            if (fabric.isDiscovering() || this.isDiscoveringInventory(fabric)) {
                                this._ps.println("fabric " + params[0] + " is in discovery");
                                this._ps.println(fabric.getWorker().getStatusDescr());
                                break;
                            }
                            int status = fabric.getFarbicStatus();
                            switch (status) {
                                case 3: {
                                    this._ps.println("fabric " + params[0] + " is loading");
                                    break block0;
                                }
                                case 1: {
                                    this._ps.println("fabric " + params[0] + " is in discovery");
                                    break block0;
                                }
                                case 2: 
                                case 4: {
                                    if (fabric.getWorker().isTimedOut()) {
                                        this._ps.println("fabric " + params[0] + " is timeout");
                                        break block0;
                                    }
                                    this._ps.println("fabric " + params[0] + " is opened");
                                    break block0;
                                }
                                case 5: 
                                case 6: {
                                    this._ps.println("fabric " + params[0] + " is closing");
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 20: {
                            this._ps.println(fabric.dumpEnclosures(detail, 0, 2));
                            break;
                        }
                        case 21: {
                            this._ps.println(fabric.dumpSwitches(detail, 0));
                            break;
                        }
                        case 22: {
                            String[] nparams = null;
                            if (params.length > 2) {
                                nparams = new String[params.length - 2];
                                System.arraycopy(params, 2, nparams, 0, nparams.length);
                            }
                            this.showVsan(fabric, nparams);
                            break;
                        }
                        case 23: {
                            this._ps.println(fabric.dumpZones(detail, 0));
                            break;
                        }
                        default: {
                            index = -1;
                        }
                    }
                }
                if (index < 0) {
                    this._ps.println("invalid keyword \"" + params[1] + "\"");
                }
            }
        }
    }

    void showVsan(FabricImpl fabric, String[] params) throws Exception {
        if (params == null || params.length == 0) {
            this._ps.println(fabric.dumpVsans(false, 0));
        } else if (params[0].equals("-d")) {
            this._ps.println(fabric.dumpVsans(true, 0));
        } else if (params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t<VSAN ID");
        } else {
            VsanImpl[] vsans = fabric.findVsan(Integer.parseInt(params[0]));
            if (vsans == null || vsans.length == 0) {
                this._ps.println("VSAN " + params[0] + " does not exist.");
                return;
            }
            boolean detail = params[params.length - 1].equals("-d");
            if (params.length == 1 || params.length == 2 && detail) {
                for (int i = 0; i < vsans.length; ++i) {
                    this._ps.println(vsans[i].dump(1));
                }
            } else {
                int index = GenUtil.searchUniqueMatch(_Mos, params[1]);
                if (index >= 0) {
                    switch (index) {
                        case 0: 
                        case 8: {
                            this._ps.println("\tenc hash host isl port seed storage switch zone");
                            break;
                        }
                        case 1: {
                            for (int i = 0; i < vsans.length; ++i) {
                                for (EndPortImpl ep : vsans[i].getEndPorts()) {
                                    if (ep.getAutoAlias() == null) continue;
                                    this._ps.println("\t" + ep.getAutoAlias() + " pwwn " + ep.getPortWwn());
                                }
                            }
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 15: {
                            for (int i = 0; i < vsans.length; ++i) {
                                Iterator<EndPortImpl> it = vsans[i].getEndPorts().iterator();
                                while (it.hasNext()) {
                                    this._ps.println(it.next().dump(1));
                                }
                            }
                            break;
                        }
                        case 17: {
                            for (int i = 0; i < vsans.length; ++i) {
                                this._ps.println("\t" + vsans[i].getVsanPK() + " seed: " + vsans[i].getSeed());
                            }
                            break;
                        }
                        case 19: {
                            break;
                        }
                        case 21: {
                            for (int i = 0; i < vsans.length; ++i) {
                                Iterator<SwitchImpl> it = vsans[i].getSwitches().iterator();
                                while (it.hasNext()) {
                                    this._ps.println(it.next().dump(1));
                                }
                            }
                            break;
                        }
                        case 22: {
                            for (int i = 0; i < vsans.length; ++i) {
                                this._ps.println(vsans[i].dumpZoneset(1));
                            }
                            break;
                        }
                        default: {
                            index = -1;
                        }
                    }
                }
                if (index < 0) {
                    this._ps.println("invalid keyword \"" + params[1] + "\"");
                }
            }
        }
    }

    void showLogger(String[] params) throws Exception {
        LoggerRepository lRep = LogManager.getLoggerRepository();
        Logger root = lRep.getRootLogger();
        this._ps.println("\t" + root.getName() + "\t" + root.getLevel());
        Enumeration enu = lRep.getCurrentLoggers();
        while (enu.hasMoreElements()) {
            Logger logger = (Logger)enu.nextElement();
            if (logger.getName().indexOf("org.jboss", 0) != -1 || logger.getName().indexOf("org.hibernate", 0) != -1 || logger.getName().indexOf("org.apache", 0) != -1 || logger.getName().indexOf("jacorb", 0) != -1) continue;
            this._ps.println("\t" + logger.getName() + "\t" + logger.getLevel());
        }
    }

    void showLun0() throws Exception {
        EnclosureImpl[] encls = SanManager.getInstance().getEnclosures();
        for (int i = 0; i < encls.length; ++i) {
            this._ps.println(LINESEP + encls[i].getScsiTarget());
        }
    }

    void showPeer() throws Exception {
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<InetAddress, SnmpPeer>> it = SnmpPeer.getPeersIterator();
        int count = 0;
        while (it.hasNext()) {
            SnmpPeer peer = it.next().getValue();
            sb.append("\t").append(peer.getAddress().getHostAddress()).append(": ").append(peer.getSession() == SnmpSession.getInstance() ? "UDP" : "TCP").append(", version=").append(peer.getVersion()).append(", timeout=").append(peer.getTimeout()).append(", retries=").append(peer.getRetries()).append(", delay=").append(peer.getAverageRoundTripDelay()).append(", numOfSETs=").append(peer.getNumSets());
            if (peer.getVersion() == 3) {
                sb.append(", userName=").append(peer.getUserName()).append(", authProt=").append(peer.getAuthProtocol()).append(", privProt=").append(peer.getPrivProtocol());
            } else {
                sb.append(", community=******");
            }
            sb.append(LINESEP);
            ++count;
        }
        sb.insert(0, " peers:\n").insert(0, count);
        this._ps.print(sb.toString());
    }

    void showPort(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            this._ps.println("\t[WWN]");
        } else {
            Wwn wwn = new Wwn(params[0], true);
            EndPortImpl ep = SanManager.getInstance().findEndPortByWwn(wwn);
            if (ep != null) {
                this._ps.println(ep.dump(1));
            } else {
                this._ps.println("\tport not found");
            }
        }
    }

    void showSession() throws Exception {
        List<SessionRif> s = FMSessionManager.getInstance().getSessions();
        for (int i = 0; i < s.size(); ++i) {
            this._ps.println(s.get(i));
        }
    }

    void showDbPool() throws Exception {
        this._ps.println("active db connection: " + ConnectionManager.getNumActive());
        this._ps.println("idl db connection: " + ConnectionManager.getNumIdle());
        this._ps.println(ConnectionManager.printConnectionDetails());
    }

    void showScheduler() throws Exception {
        SchedulerSingleton.getInstance().show(this._ps);
    }

    void pmdbsync() throws Exception {
        PM.forceSyncDb(this._ps);
    }

    void buildIndex() throws Exception {
        new IndexJob().buildIndex();
    }

    void showPmConfig(String[] params) throws Exception {
        PM.printPmConfig(this._ps, params);
    }

    void showSnmp() throws Exception {
        SnmpSession ss = SnmpSession.getInstance();
        EventControllerService ecs = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
        this._ps.println("\t" + ss + LINESEP + "\tSnmpTrapSession bound to " + (ecs != null ? Integer.valueOf(ecs.getTrapPort()) : "") + LINESEP + "\tsnmp trace " + (SnmpSession.isTrace() ? "on" : "off") + LINESEP + "\ttrap trace " + (SnmpTrapSession.isTrace() ? "on" : "off"));
        this._ps.println(SnmpSession.getStatsInfo());
        this._ps.println(SnmpTrapSession.getStatsInfo());
    }

    void stoptcpsession(String[] params) throws Exception {
        if (params != null && params.length > 1) {
            this._ps.println("\tstop snmp [userName | IP]");
            return;
        }
        SnmpSession ss = SnmpSession.getInstance();
        SnmpTransportProviderIf tranportProvider = ss.getTransportProviderObject();
        if (tranportProvider != null && tranportProvider instanceof TcpTransportProvider) {
            TcpTransportProvider tcpTransportProvider = (TcpTransportProvider)tranportProvider;
            if (params == null || params.length == 0) {
                tcpTransportProvider.stopSession();
            } else if (params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
                this._ps.println("\t[userName | IP]");
                this._ps.println("*****************Importtant*****************");
                this._ps.println("\tThis command is designed for using as last source ");
                this._ps.println("\tto stop tcp sessions without restarting server,");
                this._ps.println("\tMust unmanage fabric first.");
            } else {
                tcpTransportProvider.stopSession(params[0]);
            }
        }
    }

    void resetSnmp(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            SnmpSession.resetSession("both");
        } else if (params[0].startsWith("tcp")) {
            SnmpSession.resetSession("tcp");
        } else if (params[0].startsWith("udp")) {
            SnmpSession.resetSession("udp");
        } else if (params[0].startsWith("both")) {
            SnmpSession.resetSession("both");
        } else {
            this._ps.println("\t[tcp|udp|both]");
            this._ps.println("This command is designed for reset snmp sessions \nwithout restarting DCNMS-SAN server");
        }
    }

    void showSwitch(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            SwitchImpl[] sws = SanManager.getInstance().getSwitches();
            this._ps.println(sws.length + " switches:");
            for (int i = 0; i < sws.length; ++i) {
                this._ps.println("\t" + sws[i].toString());
            }
        } else if (params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t[Switch ID]");
        } else {
            SwitchImpl sw = null;
            try {
                sw = SanManager.getInstance().findSwitch(InetAddress.getByName(params[0]), null);
            }
            catch (UnknownHostException uhex) {
                // empty catch block
            }
            if (sw == null) {
                try {
                    Wwn swwn = new Wwn(params[0], true);
                    sw = SanManager.getInstance().findSwitch(swwn, null);
                }
                catch (Exception ex) {
                    this._ps.println("\tInvalid switch ID");
                    return;
                }
            }
            if (sw == null) {
                this._ps.println("\tswitch " + params[0] + " does not exist.");
                return;
            }
            boolean detail = params[params.length - 1].equals("-d");
            if (params.length == 1) {
                this._ps.println(sw.dump(0));
            } else {
                int index = GenUtil.searchUniqueMatch(_Mos, params[1]);
                if (index >= 0) {
                    switch (index) {
                        case 0: 
                        case 8: {
                            this._ps.println("\tenc hash host isl port seed storage switch zone");
                            break;
                        }
                        case 2: {
                            Iterator<Card> it = InventoryManager.getInstance().findCards(sw.getSwitchPK()).iterator();
                            while (it.hasNext()) {
                                this._ps.println(GenUtil.dump(it.next(), "\t"));
                            }
                            break;
                        }
                        case 3: {
                            this._ps.println(GenUtil.dump(InventoryManager.getInstance().findChassis(sw.getSwitchPK()), "\t"));
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            Iterator<HwInventoryComponent> it = InventoryManager.getInstance().findFans(sw.getSwitchPK()).iterator();
                            while (it.hasNext()) {
                                this._ps.println(GenUtil.dump(it.next(), "\t"));
                            }
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 12: {
                            Iterator<LicenseInfo> it = InventoryManager.getInstance().findLicenses(sw.getSwitchPK()).iterator();
                            while (it.hasNext()) {
                                this._ps.println(GenUtil.dump(it.next(), "\t"));
                            }
                            break;
                        }
                        case 15: {
                            List l = SanManager.getInstance().findAttachedEndPorts(sw);
                            if (l != null) {
                                for (EndPortImpl ep : l) {
                                    this._ps.println("\t" + (detail ? ep.dump(1) : ep.getDetails()));
                                }
                                break;
                            }
                            this._ps.println("\tno endports attached");
                            break;
                        }
                        case 16: {
                            Iterator<PowerSupply> it = InventoryManager.getInstance().findPowerSupplies(sw.getSwitchPK()).iterator();
                            while (it.hasNext()) {
                                this._ps.println(GenUtil.dump(it.next(), "\t"));
                            }
                            break;
                        }
                        case 18: {
                            break;
                        }
                        case 20: {
                            break;
                        }
                        case 21: {
                            SwitchImpl[] sws = SanManager.getInstance().findAttachedSwitches(sw);
                            if (sws != null) {
                                for (int i = 0; i < sws.length; ++i) {
                                    this._ps.println("\t" + (detail ? sws[i].dump(1) : sws[i].getDetails()));
                                }
                                break;
                            }
                            this._ps.println("\tno switch connected");
                            break;
                        }
                        case 22: {
                            break;
                        }
                        default: {
                            index = -1;
                        }
                    }
                }
                if (index < 0) {
                    this._ps.println("invalid keyword \"" + params[1] + "\"");
                }
            }
        }
    }

    void showTech(String[] params) throws Exception {
        try {
            String fname = FMServer.showTechSupport();
            this._ps.println("dump written to " + fname);
        }
        catch (Exception ex) {
            this._ps.println("dumping error: " + ex);
        }
    }

    void showUser(String[] params) throws Exception {
        FMUser[] users = UserManager.getInstance().getUsers();
        for (int i = 0; i < users.length; ++i) {
            this._ps.println("\t" + users[i].toString());
        }
    }

    void source(String[] params) throws Exception {
        InetAddress src = NetUtil.detectSourceAddress(params[0]);
        this._ps.println("source address: " + src.getHostAddress());
    }

    void threads(String[] params) throws Exception {
        this._ps.println(GenUtil.dumpAllThreads(params != null && params.length > 0 && params[0].equals("-s")));
    }

    void trace(String[] params) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[snmp|trap]");
        } else if ("snmp".startsWith(params[0].toLowerCase())) {
            SnmpSession.getInstance();
            SnmpSession.setTrace(true);
        } else if ("trap".startsWith(params[0].toLowerCase())) {
            SnmpTrapSession.setTrace(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void view(String[] params) {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[filename]");
        } else {
            String filepath = ClientCache.getInstallLocation() + params[0];
            FileInputStream fis = null;
            try {
                File file = new File(filepath);
                if (!file.exists()) {
                    this._ps.println("cannot find file: " + params[0]);
                } else if (!file.canRead()) {
                    this._ps.println("cannot read file: " + params[0]);
                }
                if (file.length() > 200000L) {
                    this._ps.println("file is too large to be viewed: " + file.length());
                } else {
                    fis = new FileInputStream(file);
                    byte[] data = new byte[fis.available()];
                    fis.read(data);
                    this._ps.write(data);
                    this._ps.flush();
                }
            }
            catch (Exception ioe) {
                this._ps.println("loading file failed: " + ioe.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    void ech(String[] params) {
        if (params == null || params.length == 0 || params[0].equals("?") || params[0].equals("help")) {
            this._ps.println("\t[switch ip]");
        } else {
            SwitchImpl sw = null;
            try {
                sw = SanManager.getInstance().findSwitch(InetAddress.getByName(params[0]), null);
            }
            catch (UnknownHostException uhex) {
                // empty catch block
            }
            if (sw == null) {
                this._ps.println("\tswitch " + params[0] + " does not exist.");
                return;
            }
            try {
                SimulateCallHomeTraps.getInstance().sendAllEmcTraps(sw);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    FabricImpl findFabric(String id) throws Exception {
        FabricImpl fabric = null;
        try {
            FabricPK pkey = new FabricPK(Integer.parseInt(id));
            fabric = SanManager.getInstance().findFabric(pkey);
        }
        catch (NumberFormatException nfex) {
            try {
                fabric = SanManager.getInstance().findFabric(InetAddress.getByName(id));
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        if (fabric == null) {
            throw new Exception("Fabric \"" + id + "\" is an invalid ID or not opened");
        }
        return fabric;
    }

    FabricImpl acquireFabric(FabricImpl fabric) throws Exception {
        if (fabric.isDiscovering() || this.isDiscoveringInventory(fabric)) {
            this._ps.print("\nfabric is in discovery...");
            for (int count = 10; (fabric.isDiscovering() || this.isDiscoveringInventory(fabric)) && count > 0; --count) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                this._ps.print(".");
            }
        }
        return fabric;
    }

    boolean isDiscoveringInventory(FabricImpl fabric) {
        if (fabric == null) {
            return false;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        if (switches == null || switches.length == 0) {
            return false;
        }
        for (int i = 0; i < switches.length; ++i) {
            List<Card> cards;
            if (!switches[i].isMDS() || (cards = InventoryManager.getInstance().findCards(switches[i].getSwitchPK())) != null && cards.size() != 0 || !InventoryManager.getInstance().isDiscovering(switches[i].getSwitchPK())) continue;
            return true;
        }
        return false;
    }

    FabricImpl acquireFabric(String id) throws Exception {
        return this.acquireFabric(this.findFabric(id));
    }

    void fabricAction(String[] params, byte act) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t [fabric_id]");
        } else {
            FabricImpl f = this.findFabric(params[0]);
            switch (act) {
                case 1: {
                    SanManager.getInstance().closeFabric(f);
                    break;
                }
                case 2: {
                    InventoryPersistentManager.getInstance().persistFabric(f);
                    break;
                }
                case 3: {
                    DiscoveryManager.getInstance().discoverFabric(f, DiscoveryType.FABRIC_POLL);
                    break;
                }
                case 5: {
                    this.acquireFabric(f).purgeAll();
                    break;
                }
                case 8: {
                    SanManager.getInstance().manageFabric(f.getPK());
                    break;
                }
                case 9: {
                    SanManager.getInstance().unmanageFabric(f.getPK());
                    break;
                }
                case 6: {
                    SanManager.getInstance().purgeFabric(f);
                    break;
                }
                case 7: {
                    InetAddress ipAddr = InetAddress.getByName(params[0]);
                    SwitchImpl sw = SanManager.getInstance().findSwitch(ipAddr, f.getPK());
                    SanManager.getInstance().purgeSwitch(sw);
                    break;
                }
                case 4: {
                    if (params.length == 2) {
                        DiscoveryManager.getInstance().discoverFabric(f, DiscoveryType.FABRIC_ONDEMAND);
                        break;
                    }
                    if (params.length <= 3 || !params[2].startsWith("v")) break;
                    int vid = Integer.parseInt(params[3]);
                    VsanImpl[] vs = f.findVsan(vid);
                    if (vs == null) {
                        this._ps.println("VSAN " + params[3] + " not found");
                        break;
                    }
                    for (int i = 0; i < vs.length; ++i) {
                        vs[i].setDiscFlag(65535);
                        DiscoveryManager.getInstance().discoverVsan(vs[i]);
                    }
                    break;
                }
            }
        }
    }

    LanImpl findLan(String id) throws Exception {
        LanImpl lan = null;
        try {
            LanPK pkey = new LanPK(Integer.parseInt(id));
            lan = DCManager.getInstance().findLan(pkey);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (lan == null) {
            throw new Exception("LAN \"" + id + "\" is an invalid ID or not opened");
        }
        return lan;
    }

    LanImpl acquireLan(LanImpl lan) throws Exception {
        if (lan.isDiscovering() || this.isDiscoveringInventory(lan)) {
            this._ps.print("\nLAN is in discovery...");
            for (int count = 10; (lan.isDiscovering() || this.isDiscoveringInventory(lan)) && count > 0; --count) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                this._ps.print(".");
            }
        }
        return lan;
    }

    boolean isDiscoveringInventory(LanImpl lan) {
        if (lan == null) {
            return false;
        }
        List<EthSwitchImpl> switches = lan.getEthSwitches();
        if (switches == null || switches.size() == 0) {
            return false;
        }
        for (EthSwitchImpl sw : switches) {
            List<Card> cards = InventoryManager.getInstance().findCards(sw.getSwitchPK());
            if (cards != null && cards.size() != 0 || !InventoryManager.getInstance().isDiscovering(sw.getSwitchPK())) continue;
            return true;
        }
        return false;
    }

    LanImpl acquireLan(String id) throws Exception {
        return this.acquireLan(this.findLan(id));
    }

    void lanAction(String[] params, byte act) throws Exception {
        if (params == null || params.length == 0 || params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t [lan_id]");
        } else {
            LanImpl lan = this.findLan(params[0]);
            if (lan == null) {
                this._ps.println("Cannot find LAN instance for " + params[0]);
                return;
            }
            switch (act) {
                case 11: {
                    DCManager.getInstance().removeLan(lan.getPK(), false, false);
                    break;
                }
                case 12: {
                    LanPersistentManager.getInstance().persistLan(lan);
                    break;
                }
                case 13: {
                    DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_POLL);
                    break;
                }
                case 15: {
                    this.acquireLan(lan).purgeAllDowns();
                    break;
                }
                case 18: {
                    DCManager.getInstance().manageLan();
                    break;
                }
                case 19: {
                    DCManager.getInstance().unmanageLan();
                    break;
                }
                case 16: {
                    DCManager.getInstance().removeLan(lan.getPK(), true, true);
                    break;
                }
                case 17: {
                    InetAddress swIp = InetAddress.getByName(params[1]);
                    EthSwitchImpl sw = lan.findEthSwitchByIp(swIp);
                    DCManager.getInstance().removeEthSwitch(sw.getSwitchPK(), true);
                    break;
                }
                case 23: {
                    SnmpUserOpt snmpUser = new SnmpUserOpt("admin", "nbv_12345", null, 0, true);
                    boolean is_fwsm = params.length == 3 && params[2].equals("fwsm");
                    snmpUser.setFwsm(is_fwsm);
                    List<InetAddress> ipList = IpUtil.getIPListFromString(params[1], ",");
                    String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
                    DCManager.getInstance().discoverLan(ipList, snmpUser, "nbv123", -1L, dcnmUser, false);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 26: {
                    Long taskId = Long.parseLong(params[1]);
                    TaskKey taskKey = new TaskKey(taskId);
                    CdpSeedImpl seed = DCManager.getInstance().findTaskByTaskKey(taskKey);
                    switch (act) {
                        case 20: {
                            DCManager.getInstance().removeTask(seed.getTaskKey(), true);
                            break;
                        }
                        case 21: {
                            DCManager.getInstance().manageTask(seed.getTaskKey());
                            break;
                        }
                        case 22: {
                            DCManager.getInstance().unmanageTask(seed.getTaskKey());
                            break;
                        }
                        case 26: {
                            DCManager.getInstance().unhostTask(seed.getTaskKey());
                        }
                    }
                    break;
                }
                case 14: {
                    DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_ONDEMAND);
                    break;
                }
                case 30: {
                    try {
                        LanPK lanpk = new LanPK(Integer.parseInt(params[0]));
                        GlobalDCManager.getInstance().updateLanManageableByLanPK(false, lanpk);
                        List<CdpSeedBase> cdpSeeds = GlobalDCManager.getInstance().getCdpSeedsByLanPK(lanpk);
                        if (cdpSeeds == null) {
                            return;
                        }
                        for (CdpSeedBase cdpSeed : cdpSeeds) {
                            DCManager.getInstance().hostTask(lanpk, cdpSeed.getTaskKey());
                        }
                        DCManager.getInstance().rediscoverLanforTaskMove();
                        DCManager.getInstance().unhostLan(lanpk);
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("Can not move lan: " + e.getMessage());
                    }
                }
            }
        }
    }

    void showLan(String[] params) throws Exception {
        if (params == null || params.length == 0) {
            LanImpl lan = DCManager.getInstance().getLan();
            if (lan == null) {
                this._ps.println("There is no lan opened");
            } else {
                String statString = DCManager.getInstance().isLanOpened(lan.getPK()) ? "managed" : "unmanaged";
                this._ps.println("\t" + lan.getPK().getId() + ": " + lan.getPK().toString() + " : " + statString);
            }
        } else if (params[0].equals("?") || "help".startsWith(params[0].toLowerCase())) {
            this._ps.println("\t<lan_id> [options] [-d]");
        } else {
            LanImpl lan = this.findLan(params[0]);
            if (lan == null) {
                this._ps.println("There is no LAN found for " + params[0]);
            } else {
                boolean detail = params[params.length - 1].equals("-d");
                if (params.length == 1 || params.length == 2 && detail) {
                    this._ps.println(lan.dump(detail));
                } else {
                    int index = GenUtil.searchUniqueMatch(_Mos, params[1]);
                    if (index >= 0) {
                        block0 : switch (index) {
                            case 0: 
                            case 8: {
                                this._ps.println("\t hash isl poll seed status switch vlan");
                                break;
                            }
                            case 7: {
                                this._ps.println(lan.dumpHashes());
                                break;
                            }
                            case 10: {
                                this._ps.println(lan.dumpEthIsls());
                                break;
                            }
                            case 14: {
                                this._ps.println("poll interval: " + lan.getPollInterval());
                                break;
                            }
                            case 17: {
                                this._ps.println("cdp seed: " + lan.dumpCdpSeeds());
                                break;
                            }
                            case 19: {
                                if (lan.isDiscovering() || this.isDiscoveringInventory(lan)) {
                                    this._ps.println("fabric " + params[0] + " is in discovery");
                                    this._ps.println(lan.getWorker().getStatusDescr());
                                    break;
                                }
                                int status = lan.getLanStatus();
                                switch (status) {
                                    case 3: {
                                        this._ps.println("LAN " + params[0] + " is loading");
                                        break block0;
                                    }
                                    case 1: {
                                        this._ps.println("LAN " + params[0] + " is in discovery");
                                        break block0;
                                    }
                                    case 2: 
                                    case 4: {
                                        if (lan.getWorker().isTimedOut()) {
                                            this._ps.println("LAN " + params[0] + " is timeout");
                                            break block0;
                                        }
                                        this._ps.println("LAN " + params[0] + " is opened");
                                        break block0;
                                    }
                                    case 5: 
                                    case 6: {
                                        this._ps.println("LAN " + params[0] + " is closing");
                                        break block0;
                                    }
                                }
                                break;
                            }
                            case 21: {
                                this._ps.println(lan.dumpEthSwitches());
                                break;
                            }
                            case 24: {
                                this._ps.println(lan.dumpVlans());
                                break;
                            }
                            default: {
                                index = -1;
                            }
                        }
                    }
                    if (index < 0) {
                        this._ps.println("invalid keyword \"" + params[1] + "\"");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] strArgs) {
        String configFile = ClientCache.getConfDir() + "server.properties";
        Properties properties = new Properties();
        CliSession cli = null;
        try {
            GenUtil.loadServerProperties(null);
            System.out.println("Server configuration file loaded: " + configFile);
            System.getProperties().putAll((Map<?, ?>)properties);
            System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
            String logConfFile = System.getProperty("org.apache.log4j.file");
            if (logConfFile == null || logConfFile.length() == 0) {
                logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
            }
            DOMConfigurator.configure((String)logConfFile);
            System.out.println("Log4j loaded: " + logConfFile);
            cli = CliSession.createLocal();
            if (strArgs == null || strArgs.length == 0 || strArgs[0].equals("?") || strArgs[0].equals("help")) {
                System.out.println("\t ipconfig\t\n\t plmapping\t\n");
            } else {
                String[] params = new String[strArgs.length - 1];
                System.arraycopy(strArgs, 1, params, 0, strArgs.length - 1);
                if (strArgs[0].indexOf("plmapping") != -1) {
                    cli.plmapping(params);
                } else if (strArgs[0].indexOf("ipconfig") != -1) {
                    cli.ipconfig();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class NodeCmdHandler
    implements CmdHandlerIf {
        private CmdTreeNode[] _childNodes;

        NodeCmdHandler(CmdTreeNode[] childnodes) {
            this._childNodes = childnodes;
        }

        @Override
        public void doCmd(String[] args) throws Exception {
            if (args == null || args.length == 0 || args[0].equals("?") || "help".startsWith(args[0].toLowerCase())) {
                for (int i = 0; i < this._childNodes.length; ++i) {
                    CliSession.this._ps.println('\t' + this._childNodes[i]._name);
                }
                CliSession.this._ps.println("all commands are case insensitive, use \"?\" for arguments");
            } else if (args.length > 0) {
                CmdTreeNode node = CmdTreeNode.findCmdNode(this._childNodes, args[0]);
                if (node != null) {
                    String[] params = null;
                    if (args.length > 1) {
                        params = new String[args.length - 1];
                        System.arraycopy(args, 1, params, 0, params.length);
                    }
                    node._func.doCmd(params);
                } else {
                    CliSession.this._ps.println("ERROR: invalid keyword \"" + args[0] + "\"");
                }
            } else {
                CliSession.this._ps.println("ERROR: invalid command \"" + args[0] + "\"");
            }
        }
    }
}

