/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import com.cisco.dcbu.lib.serviceconf.AbstractService;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCommunity;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.proxy.ProxyTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.UdpTransportOptions;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.model.SnmpCommunityBase;
import com.cisco.dcbu.sm.server.model.SnmpCommunityImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SnmpService
extends AbstractService {
    static final String PROP_SNMP_LOCALPORT = "snmp.localport";
    static final String PROP_SNMP_TIMEOUT = "snmp.timeout";
    static final String PROP_SNMP_RETRIES = "snmp.retries";
    private String _mibFile;
    private SnmpSession _session;

    public SnmpService() {
        super("SNMP Service");
        this._log = Logger.getLogger((String)"snmp");
    }

    protected void initImpl(Object[] params) throws Exception {
        this.loadMib();
        this.loadCommunitiesFromDB();
        this.initSession();
    }

    protected void startImpl() throws Exception {
    }

    public boolean suspend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean resume() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void stopImpl() {
        if (this._state.get() != 0) {
            MibNode.clear();
            this._log.info((Object)("MIB file unloaded: " + this._mibFile));
            this._mibFile = null;
            this._session.close();
            this._session = null;
        }
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        if (this._session.getLocalVPNAddress() != null && this._session.getLocalVPNAddress().length() != 0) {
            sb.append("\tVPN address: ").append(this._session.getLocalVPNAddress());
        }
        sb.append("\n\tSnmpSession bound to ").append(this._session.getLocalPort());
        return sb.toString();
    }

    private void loadMib() throws Exception {
        this._mibFile = System.getProperty("snmp.mib.file");
        if (this._mibFile == null || this._mibFile.length() == 0) {
            this._mibFile = "com/cisco/dcbu/lib/mds/mib.dat";
        }
        try {
            MibNode.load(this._mibFile);
            this._log.info((Object)("MIB file loaded: " + this._mibFile));
        }
        catch (Exception ex) {
            this._log.fatal((Object)("Loading MIB file \"" + this._mibFile + "\" failed"), (Throwable)ex);
            throw ex;
        }
    }

    private void loadCommunitiesFromDB() {
        try {
            ArrayList al = SnmpCommunityImpl.loadFromDB();
            if (al == null || al.size() == 0) {
                return;
            }
            String[] ips = new String[al.size()];
            String[] reads = new String[al.size()];
            String[] writes = new String[al.size()];
            for (int i = 0; i < al.size(); ++i) {
                SnmpCommunityBase base = (SnmpCommunityBase)al.get(i);
                ips[i] = base.getIpAddress();
                reads[i] = base.getReadCommunityString();
                writes[i] = base.getWriteCommunityString();
            }
            SnmpCommunity.add(ips, reads, writes);
            this._log.info((Object)("SNMP communities loaded from database: " + al.size()));
        }
        catch (Exception ex) {
            this._log.log((Priority)Level.ERROR, (Object)"Loading SNMP community from database failed", (Throwable)ex);
        }
    }

    private void initSession() throws Exception {
        Integer retries;
        Integer timeout;
        ProxyTransportOptions opt = null;
        InetAddress localaddr = null;
        Integer localport = Integer.getInteger(PROP_SNMP_LOCALPORT);
        this._session = SnmpSession.getInstance();
        String value = System.getProperty("snmp.proxy");
        if (value != null && value.length() != 0) {
            InetAddress proxyAddr = null;
            int proxyPort = 9198;
            int del = value.indexOf(58);
            String proxyHost = null;
            try {
                if (del != -1) {
                    proxyHost = value.substring(0, del);
                    proxyPort = Integer.parseInt(value.substring(del + 1).trim());
                    if (proxyPort <= 0 || proxyPort > 65535) {
                        throw new NumberFormatException(String.valueOf(proxyPort));
                    }
                    proxyAddr = InetAddress.getByName(value.substring(0, del));
                } else {
                    proxyHost = value;
                    proxyAddr = InetAddress.getByName(value.substring(0));
                }
                if (proxyAddr != null && !NetUtil.isLocalHost(proxyAddr.getHostAddress())) {
                    opt = new ProxyTransportOptions(proxyAddr, proxyPort);
                }
            }
            catch (UnknownHostException uhe) {
                boolean localNic = false;
                Enumeration<NetworkInterface> nifs = null;
                try {
                    nifs = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException ex) {
                    // empty catch block
                }
                if (nifs != null) {
                    while (nifs.hasMoreElements()) {
                        NetworkInterface ni = nifs.nextElement();
                        if (!ni.getName().equals(proxyHost)) continue;
                        localNic = true;
                        break;
                    }
                }
                if (!localNic) {
                    this._log.warn((Object)("Invalid proxy server address: " + proxyHost + ". Use local IP address as proxy server address"));
                }
            }
            catch (NumberFormatException nfe) {
                this._log.warn((Object)("Invalid proxy server port: " + nfe.getMessage()));
            }
        }
        if (opt != null) {
            this._session.open("proxy", opt);
        } else {
            this._session.open(localaddr, localport == null ? 0 : localport);
            SnmpSession.getInstance("tcp").open("tcp", new TcpTransportOptions(null, 161, localport == null ? 0 : localport));
            SnmpSession.getInstance("udp").open("udp", new UdpTransportOptions(null, localport == null ? 161 : localport));
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("SnmpSession initialized on " + this._session.getLocalHostAddress() + ":" + this._session.getLocalPort() + ", remote port=" + this._session.getRemotePort()));
        }
        if ((timeout = Integer.getInteger(PROP_SNMP_TIMEOUT)) != null) {
            SnmpPeer.setClassTimeout(timeout);
        }
        if ((retries = Integer.getInteger(PROP_SNMP_RETRIES)) != null) {
            SnmpPeer.setClassRetries(retries);
        }
    }
}

