/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.sm.common.rif.IndexerRif;
import com.cisco.dcbu.sm.server.bean.IndexerMBeanMBean;
import com.cisco.dcbu.sm.server.scheduler.SchedulerManagerImpl;
import com.cisco.dcbu.sm.server.web.Indexer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

@Remote(value={IndexerRif.class})
@DependsOn(value={"user:service=QuartzService,name=QuartzService"})
@Singleton
@Startup
public class IndexerMBean
extends Indexer
implements IndexerMBeanMBean {
    static Logger _Logger = Logger.getLogger((String)"Indexer");
    public static final int SCHEDULE_SUCCESS = 0;
    public static final int SCHEDULE_DUPLICATE_NAME = -1;
    public static final int SCHEDULE_UNDEFINED_JOB_TYPE = -2;
    public static final int INDEX_JOB = 6;
    public static final int RUN_ONCE = 1;
    public static final int RUN_DAILY = 2;
    public static final int RUN_TEST = 4;
    public static final String DEFAULT_INDEX_INTERAVL = "2";
    String _JobName = null;
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;

    public IndexerMBean() {
        super(true);
    }

    public void create() throws Exception {
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        _Logger.info((Object)"Indexer service bean starting....");
        this.registerInJMX();
        try {
            JobDataMap jobStatesMap = new JobDataMap();
            this._JobName = "index_job_" + InetAddress.getLocalHost().getHostName();
            Date startDate = new Date(System.currentTimeMillis());
            String index_interval = System.getProperty("fmsearch.interval", DEFAULT_INDEX_INTERAVL);
            String cronExpression = "0 30 0/" + index_interval + " * * ?";
            SchedulerManagerImpl.getInstance().deleteJob(this._JobName);
            int scheduleResultCode = SchedulerManagerImpl.getInstance().scheduleJob(cronExpression, 6, this._JobName, jobStatesMap, startDate, null, true);
            if (scheduleResultCode != 0) {
                switch (scheduleResultCode) {
                    case -1: {
                        _Logger.warn((Object)"Duplicate job name");
                        break;
                    }
                    case -2: {
                        _Logger.warn((Object)"Error: Invalid job type");
                        break;
                    }
                    default: {
                        _Logger.warn((Object)"Error: Job scheduling failed");
                        break;
                    }
                }
            } else {
                _Logger.info((Object)"Sucessfully scheduled job.");
            }
        }
        catch (SchedulerException e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
        catch (Exception e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        _Logger.info((Object)"Indexer service bean stopping....");
        this.unregisterFromJMX();
        try {
            SchedulerManagerImpl.getInstance().deleteJob(this._JobName);
        }
        catch (Exception e) {
            _Logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void registerInJMX() {
        try {
            _Logger.warn((Object)"********* Registering dcm:service=Indexer");
            this.objectName = new ObjectName("dcm:service=Indexer");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }
}

