/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.ClusterInterfBase;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SMEPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.rif.SanServiceRif;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.dmm.DMMHelper;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;

@Remote(value={SanServiceRif.class})
@Stateless
public class SanServiceBean
implements SanServiceRif {
    private static final long serialVersionUID = 1L;
    private static SanServiceBean _Instance;
    private SanManager _sanManager = SanManager.getInstance();
    private DMMHelper _helper = DMMHelper.getInstance();

    @Override
    public SwitchBase[] findAllSwitches() throws RemoteException {
        SwitchImpl[] sws = this._sanManager.getSwitches();
        SwitchBase[] ret = new SwitchBase[sws.length];
        for (int i = 0; i < sws.length; ++i) {
            ret[i] = (SwitchBase)sws[i].getBaseObject();
        }
        return ret;
    }

    @Override
    public SwitchBase[] findSwitches(ClusterPK ckey) throws RemoteException {
        FabricImpl[] fabs = this._sanManager.getFabrics();
        ArrayList<BaseModelObject> sws = new ArrayList<BaseModelObject>();
        for (int i = 0; fabs != null && i < fabs.length; ++i) {
            ClusterImpl cl = fabs[i].findCluster(ckey);
            if (cl == null) continue;
            ClusterInterfBase[] cbs = cl.getClusterInterfs();
            for (int j = 0; cbs != null && j < cbs.length; ++j) {
                String inetAddr = cbs[j].getSwInetAddrStr();
                try {
                    InetAddress ipAddr = InetAddress.getByName(inetAddr);
                    SwitchImpl sw = this._sanManager.findSwitch(ipAddr, fabs[i].getPK());
                    if (sw == null) continue;
                    sws.add(sw.getBaseObject());
                    continue;
                }
                catch (Exception ex) {
                    throw new RemoteException(ex.getMessage(), ex);
                }
            }
        }
        if (sws.size() > 0) {
            return sws.toArray(new SwitchBase[sws.size()]);
        }
        return null;
    }

    @Override
    public EnclosureBase[] findAllEnclosures() throws RemoteException {
        EnclosureImpl[] encls = this._sanManager.getEnclosures();
        EnclosureBase[] ret = new EnclosureBase[encls.length];
        for (int i = 0; i < encls.length; ++i) {
            ret[i] = (EnclosureBase)encls[i].getBaseObject();
        }
        return ret;
    }

    @Override
    public FabricBase findFabric(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        return fabric.getFabricBase(new short[0]);
    }

    public FabricPK[] getFabricPKs() throws RemoteException {
        return this._sanManager.getFabricPKs();
    }

    @Override
    public FabricBase[] findFabrics() throws RemoteException {
        FabricImpl[] fabricList = this._sanManager.getFabrics();
        if (fabricList == null) {
            return null;
        }
        FabricBase[] fbList = new FabricBase[fabricList.length];
        for (int i = 0; i < fabricList.length; ++i) {
            fbList[i] = fabricList[i].getFabricBase(new short[0]);
        }
        return fbList;
    }

    @Override
    public VsanBase[] findVsans(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        VsanImpl[] vsanList = fabric.getVsans();
        if (vsanList == null) {
            return null;
        }
        VsanBase[] vsList = new VsanBase[vsanList.length];
        for (int i = 0; i < vsanList.length; ++i) {
            vsList[i] = (VsanBase)vsanList[i].getBaseObject();
        }
        return vsList;
    }

    @Override
    public EnclosureBase[] findHostEnclosures(VsanPK pkey) throws RemoteException {
        try {
            VsanImpl vsan = SanManager.getInstance().findVsan(pkey);
            if (vsan == null) {
                return null;
            }
            ArrayList<EnclosureImpl> encls = vsan.getHostEnclosures();
            if (encls == null) {
                return null;
            }
            EnclosureBase[] ecList = new EnclosureBase[encls.size()];
            for (int i = 0; i < encls.size(); ++i) {
                ecList[i] = (EnclosureBase)encls.get(i).getBaseObject();
            }
            return ecList;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public EnclosureBase[] findTargetEnclosures(EnclosureBase hostEnclosure) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        if (hostEnclosure == null) {
            return new EnclosureBase[0];
        }
        List<WwnKey> list = hostEnclosure.getEndPortPKs();
        if (list == null || list.size() == 0) {
            throw new RemoteException("host enclosure does not have endPoints");
        }
        WwnKey epWwn = list.get(0);
        EndPortImpl port = sanManager.findEndPortByPK(epWwn);
        if (port == null) {
            return new EnclosureBase[0];
        }
        SwitchImpl switcher = sanManager.findSwitch(port.getSwitchPK(), port.getFabricPK());
        if (switcher == null) {
            return new EnclosureBase[0];
        }
        FabricImpl fabric = sanManager.findFabricBySwitchPK(switcher.getSwitchPK(), switcher.getFabricPK());
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        EnclosureImpl[] storage = fabric.getEnclosures(2);
        for (int i = 0; i < storage.length; ++i) {
            EnclosureBase base = (EnclosureBase)storage[i].getBaseObject();
            if (!this._helper.isHostTargetInSameZoneMember(fabric, hostEnclosure, (EnclosureBase)storage[i].getBaseObject())) continue;
            ret.add(base);
        }
        Collections.sort(ret);
        if (ret.size() > 0) {
            return ret.toArray(new EnclosureBase[ret.size()]);
        }
        return new EnclosureBase[0];
    }

    @Override
    public EnclosureBase[] findTargetEnclosures(EnclosureBase hostEnclosure, VsanBase vsan, FabricBase fa) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        if (hostEnclosure == null) {
            return new EnclosureBase[0];
        }
        List<WwnKey> list = hostEnclosure.getEndPortPKs();
        if (list == null || list.size() == 0) {
            throw new RemoteException("host enclosure does not have endPoints");
        }
        WwnKey epWwn = list.get(0);
        EndPortImpl port = sanManager.findEndPort(epWwn, fa.getPK());
        if (port == null) {
            return new EnclosureBase[0];
        }
        SwitchImpl switcher = sanManager.findSwitch(port.getSwitchPK(), port.getFabricPK());
        if (switcher == null) {
            return new EnclosureBase[0];
        }
        FabricImpl fabric = sanManager.findFabricBySwitchPK(switcher.getSwitchPK(), switcher.getFabricPK());
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        ZoneBase[] zoneBases = vsan.getEnforcedZones();
        EnclosureImpl[] storage = fabric.getEnclosures(2);
        for (int i = 0; i < storage.length; ++i) {
            EnclosureBase base = (EnclosureBase)storage[i].getBaseObject();
            if (!this._helper.isHostTargetInSameZoneMember(fabric, hostEnclosure, (EnclosureBase)storage[i].getBaseObject(), vsan, fa, zoneBases)) continue;
            ret.add(base);
        }
        Collections.sort(ret);
        if (ret.size() > 0) {
            return ret.toArray(new EnclosureBase[ret.size()]);
        }
        return new EnclosureBase[0];
    }

    @Override
    public EnclosureBase[] findTargetEnclosures(EnclosureBase hostEnclosure, VsanBase vsan, FabricBase fa, String[] includeZones) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        if (hostEnclosure == null) {
            return new EnclosureBase[0];
        }
        List<WwnKey> list = hostEnclosure.getEndPortPKs();
        if (list == null || list.size() == 0) {
            throw new RemoteException("host enclosure does not have endPoints");
        }
        WwnKey epWwn = list.get(0);
        EndPortImpl port = sanManager.findEndPort(epWwn, fa.getPK());
        if (port == null) {
            return new EnclosureBase[0];
        }
        SwitchImpl switcher = sanManager.findSwitch(port.getSwitchPK(), port.getFabricPK());
        if (switcher == null) {
            return new EnclosureBase[0];
        }
        FabricImpl fabric = sanManager.findFabricBySwitchPK(switcher.getSwitchPK(), switcher.getFabricPK());
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        ZoneBase[] zoneBases = vsan.getEnforcedZones();
        ArrayList<ZoneBase> filterZones = new ArrayList<ZoneBase>();
        if (includeZones != null) {
            for (int i = 0; i < includeZones.length; ++i) {
                for (int j = 0; j < zoneBases.length; ++j) {
                    if (!zoneBases[j].getName().equals(includeZones[i])) continue;
                    filterZones.add(zoneBases[j]);
                }
            }
            zoneBases = new ZoneBase[filterZones.size()];
            zoneBases = filterZones.toArray(zoneBases);
        }
        EnclosureImpl[] storage = fabric.getEnclosures(2);
        for (int i = 0; i < storage.length; ++i) {
            EnclosureBase base = (EnclosureBase)storage[i].getBaseObject();
            List<WwnKey> storePorts = base.getEndPortPKs();
            for (WwnKey storeKey : storePorts) {
                EnclosureBase tempEnc = new EnclosureBase(base.getEnclosureName(), base.getIpAddress(), base.isVirtual());
                tempEnc.addEndPort(storeKey);
                if (!this._helper.isHostTargetInSameZoneMember(fabric, hostEnclosure, tempEnc, vsan, fa, zoneBases)) continue;
                ret.add(tempEnc);
            }
        }
        Collections.sort(ret);
        if (ret.size() > 0) {
            return ret.toArray(new EnclosureBase[ret.size()]);
        }
        return new EnclosureBase[0];
    }

    @Override
    public SMEPortBase[] findSMEInterfaces(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        SwitchImpl[] swList = fabric.getSwitches();
        if (swList == null) {
            return null;
        }
        ArrayList<SMEPortBase> smeList = new ArrayList<SMEPortBase>();
        for (int i = 0; i < swList.length; ++i) {
            smeList.addAll(swList[i].findSMEPortsWithSysName());
        }
        if (smeList.size() > 0) {
            return smeList.toArray(new SMEPortBase[smeList.size()]);
        }
        return null;
    }

    @Override
    public SMEPortBase[] findSMEInterfaces(ClusterPK pkey) throws RemoteException {
        FabricImpl[] fabList = this._sanManager.getFabrics();
        if (fabList == null) {
            return null;
        }
        ArrayList<SMEPortBase> smes = new ArrayList<SMEPortBase>();
        for (int i = 0; i < fabList.length; ++i) {
            SMEPortBase[] tmpList;
            if (fabList[i].findCluster(pkey) == null || (tmpList = this.findSMEInterfaces(fabList[i].getPK())) == null) continue;
            for (int j = 0; j < tmpList.length; ++j) {
                String clusterId = tmpList[j].getFcPort().getClusterId();
                if (clusterId == null || !clusterId.equals(pkey.getName())) continue;
                smes.add(tmpList[j]);
            }
        }
        if (smes.size() > 0) {
            return smes.toArray(new SMEPortBase[smes.size()]);
        }
        return null;
    }

    @Override
    public ClusterBase[] findClusters(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        ClusterImpl[] cluList = fabric.getClusters();
        if (cluList == null) {
            return null;
        }
        ClusterBase[] cList = new ClusterBase[cluList.length];
        for (int i = 0; i < cluList.length; ++i) {
            cList[i] = (ClusterBase)cluList[i].getBaseObject();
        }
        return cList;
    }

    @Override
    public EndPortBase[] findHostPorts(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        ArrayList eps = fabric.getInitiators();
        if (eps == null) {
            return null;
        }
        EndPortBase[] epList = new EndPortBase[eps.size()];
        for (int i = 0; i < eps.size(); ++i) {
            epList[i] = (EndPortBase)((EndPortImpl)eps.get(i)).getBaseObject();
        }
        return epList;
    }

    @Override
    public EndPortBase[] findZonedTargetPorts(EndPortBase hostPort, EnclosureBase targetEnclosure) throws RemoteException {
        return this._helper.findTargetPortsInSameZone(hostPort, targetEnclosure);
    }

    @Override
    public EnclosureBase findEnclosureByWwn(WwnKey key) throws RemoteException {
        EndPortImpl port = this._sanManager.findEndPortByPK(key);
        if (port == null) {
            return null;
        }
        return (EnclosureBase)port.getEnclosure().getBaseObject();
    }

    @Override
    public String findEndPortNameByWwn(WwnKey key) throws RemoteException {
        EndPortImpl port = this._sanManager.findEndPortByPK(key);
        if (port == null) {
            return null;
        }
        return port.getDeviceAlias();
    }

    @Override
    public EndPortBase findEndPortBaseByWwn(WwnKey key) throws RemoteException {
        EndPortImpl port = this._sanManager.findEndPortByPK(key);
        if (port == null) {
            return null;
        }
        return (EndPortBase)port.getBaseObject();
    }

    @Override
    public ClusterBase createCluster(FabricPK pkey, String clusterId, String name, short type, short state, short masterInetAddrType, String masterInetAddr) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        ClusterImpl cluster = null;
        ClusterPK cKey = new ClusterPK(clusterId, name, 1);
        cluster = fabric.findCluster(cKey);
        if (cluster == null) {
            cluster = fabric.createCluster(cKey, type, state, masterInetAddrType, masterInetAddr, null);
            if (cluster != null) {
                cluster.setFabric(fabric);
            }
        } else {
            cluster.setState(state);
            cluster.setMasterInetAddrType(masterInetAddrType);
            cluster.setMasterInetAddr(masterInetAddr);
        }
        return (ClusterBase)cluster.getBaseObject();
    }

    @Override
    public void setClusterId(WwnKey pkey, int ifIndex, String clusterId) throws RemoteException {
        FabricPK[] fpks = SanManager.getInstance().getFabricPKs();
        for (int i = 0; fpks != null && i < fpks.length; ++i) {
            SwitchImpl sw = this._sanManager.findSwitch(pkey, fpks[i]);
            if (sw == null) {
                return;
            }
            FcPortBase port = sw.createPort(ifIndex);
            if (port == null) continue;
            port.setClusterId(clusterId);
        }
    }

    @Override
    public void deleteCluster(FabricPK pkey, String clusterId, String name) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return;
        }
        ClusterPK cKey = new ClusterPK(clusterId, name, 1);
        ClusterImpl cl = fabric.findCluster(cKey);
        if (cl != null) {
            fabric.removeCluster(cl);
        }
    }

    @Override
    public Object[] findVsans(int fId) throws RemoteException {
        Object[] vBase = this.findVsans(new FabricPK(fId));
        if (vBase != null && vBase.length > 0) {
            Arrays.sort(vBase);
            String[] vName = new String[vBase.length];
            String[] vPK = new String[vBase.length];
            for (int k = 0; k < vBase.length; ++k) {
                vName[k] = ((VsanBase)vBase[k]).getName();
                vPK[k] = ((VsanBase)vBase[k]).getVsanPK().getVsanPKAsString();
            }
            return new Object[]{vName, vPK};
        }
        return null;
    }

    @Override
    public Object[] findZones(String vsanPk) throws RemoteException {
        VsanBase vBase;
        ZoneBase[] zones;
        VsanImpl vImpl;
        VsanPK vPk = VsanPK.getVsanPKFromString(vsanPk);
        Object[] data = null;
        if (vPk != null && (vImpl = SanManager.getInstance().findVsan(vPk)) != null && (zones = (vBase = (VsanBase)vImpl.getBaseObject()).getEnforcedZones()) != null) {
            data = new Object[zones.length];
            for (int z = 0; z < zones.length; ++z) {
                data[z] = zones[z].getName();
            }
        }
        return data;
    }

    @Override
    public ZoneBase[] getIvrZones(FabricPK pkey) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        ZoneBase[] ivrZoneBases = fabric.getIvrEnforcedZones();
        return ivrZoneBases;
    }

    @Override
    public ZoneBase[] getZonesForVsan(FabricPK pkey, String vsanPk) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pkey);
        if (fabric == null) {
            return null;
        }
        VsanPK vPk = VsanPK.getVsanPKFromString(vsanPk);
        if (vPk == null) {
            return null;
        }
        VsanImpl vsan = fabric.findVsan(vPk);
        ZoneBase[] zones = vsan.getEnforcedZones();
        return zones;
    }

    public static EndPortBase getEndPort(int type, byte[] id, VsanBase vsan, FabricBase fa) {
        return ZoneService.getEndPort(type, id, vsan, fa);
    }

    public static ArrayList getAttachedEndPorts(FabricBase fa, int type, byte[] id, VsanBase vsan) {
        return ZoneService.getAttachedEndPorts(fa, type, id, vsan);
    }

    @Override
    public String getSwitchName(Wwn wwn) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        SwitchImpl sw = sanManager.findSwitchByPK(new WwnKey(wwn));
        if (sw != null) {
            return sw.getSysName();
        }
        return SnmpWWN.toHexString(wwn.getValue());
    }
}

