/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.cat;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.server.analysis.BaseAnalysisReport;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ReportProgressTracker;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FcPingAnalysis
extends ReportAnalysis {
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    protected static ReportAnalysis repInstance;
    int completedPingReqests;

    protected FcPingAnalysis() {
    }

    public static FcPingAnalysis getInstance() {
        if (repInstance == null) {
            repInstance = new FcPingAnalysis();
            _Logger.info((Object)"Instance of Ping Analysis used");
        }
        return (FcPingAnalysis)repInstance;
    }

    public static FcPingAnalysis newInstance() {
        return new FcPingAnalysis();
    }

    @Override
    protected Logger getLogger() {
        return _Logger;
    }

    @Override
    public void generateReportAsynchronously(int fid, String vsanPKString, Object[] param, int reportType, int rptId, long fabricDbID, long vsanDbID) {
        _Logger.debug((Object)("Start Running Report Async FID:" + fid + " vsanPK:" + vsanPKString));
        this.reptId = rptId;
        this.startTime = 0L;
        if (this.isReportRunning()) {
            return;
        }
        FcPingAnalysisGenerator repGenerator = new FcPingAnalysisGenerator(fid, vsanPKString, true, param != null && param.length > 0 ? ((long[])param[0])[0] : 0L, fabricDbID, vsanDbID);
        this.initNewReport();
        new Thread(repGenerator).start();
    }

    @Override
    public ArrayList generateReportSynchronously(int fid, String vsanPKString, Object[] param, int reportType, long fabricDbID, long vsanDbID) throws Exception {
        this.startTime = 0L;
        FcPingAnalysisGenerator repGenerator = new FcPingAnalysisGenerator(fid, vsanPKString, false, param != null && param.length > 0 ? ((long[])param[0])[0] : 0L, fabricDbID, vsanDbID);
        _Logger.debug((Object)("Start Running Report Sync FID:" + fid + " vsanPK:" + vsanPKString));
        this.initNewReport();
        repGenerator.run();
        if (this.isErrorInProcessing()) {
            throw this.getErrorException();
        }
        return repGenerator.getThReport().getReportData();
    }

    @Override
    public void buildReportSynchronously(FabricPK fPk, ArrayList encPairList, Object[] params, boolean ignoreVsan, ReportProgressTracker prTracker, long fabricDbID, long vsanDbID) throws Exception {
        FabricImpl fImpl = SanManager.getInstance().findFabric(fPk);
        if (fImpl != null) {
            if (this.logUnlicensedFabric(fImpl) && this.logUnopenedFabric(fImpl)) {
                return;
            }
            ArrayList ivrregions = fImpl.getAllIvrEnforcedZoneSetRegionIds();
            ArrayList<ZoneBase> ivrZns = new ArrayList<ZoneBase>();
            for (int r = 0; r < ivrregions.size(); ++r) {
                ZoneBase[] ivrrgZns = fImpl.getIvrEnforcedZones((Integer)ivrregions.get(r));
                if (ivrrgZns == null) continue;
                for (int rg = 0; rg < ivrrgZns.length; ++rg) {
                    ivrZns.add(ivrrgZns[rg]);
                }
            }
            ZoneBase[] zb = ivrZns.size() == 0 ? null : ivrZns.toArray(new ZoneBase[ivrZns.size()]);
            this.buildFcPingObjects(zb, fImpl, encPairList, null);
        }
        super.buildReportSynchronously(fPk, encPairList, params, ignoreVsan, prTracker, fabricDbID, vsanDbID);
        int totalPingSz = 0;
        for (int i = 0; i < encPairList.size(); ++i) {
            FcPingObject pingOb = (FcPingObject)encPairList.get(i);
            for (int d = 0; d < pingOb.dstPortList.size(); ++d) {
                FcPingDstPortObject dstPrt = (FcPingDstPortObject)pingOb.dstPortList.get(d);
                totalPingSz += dstPrt.hsPairList.size();
            }
        }
        _Logger.info((Object)("FcPing Number of Host Storage pairs: " + totalPingSz + " switches:" + encPairList.size()));
    }

    private void buildFcPingObjects(ZoneBase[] zb, FabricImpl fImpl, ArrayList pingList, VsanImpl vImpl) {
        ArrayList<HSPair> encPairList = new ArrayList<HSPair>();
        if (zb != null) {
            int i;
            FabricBase fBase = fImpl.getFabricBase(null);
            if (fBase == null) {
                _Logger.debug((Object)"FcPing Analysis: Fabric fImpl is not being monitored.");
                this.warnings.add("FcPing Analysis: Fabric fImpl is not being monitored.");
                return;
            }
            for (i = 0; i < zb.length; ++i) {
                this.setPercentCompleted(25 * (i + 1) / zb.length);
                this.setStatus(vImpl == null ? "Analyzing IVR Zone:" + zb[i].getName() : "Analyzing VSAN:" + vImpl + ", Zone:" + zb[i].getName());
                Array zMembers = zb[i].getMembers();
                if (zMembers == null) continue;
                ArrayList<Object[]> hosts = new ArrayList<Object[]>();
                ArrayList<Object[]> storages = new ArrayList<Object[]>();
                for (int k = 0; k < zMembers.size(); ++k) {
                    ZoneMemberBase mem = (ZoneMemberBase)zMembers.elementAt(k);
                    ArrayList epList = ZoneService.getAllEndPortsAndSetStatus(fBase, mem, null);
                    Object encName = null;
                    Object zmWwn = null;
                    for (int eps = 0; eps < epList.size(); ++eps) {
                        VsanImpl vv;
                        EndPortBase ep = (EndPortBase)epList.get(eps);
                        if (!ep.isMemberOfVsan(vImpl == null ? mem.getIvrVsanId() : vImpl.getId())) continue;
                        SwitchImpl swImpl = SanManager.getInstance().findSwitch(ep.getSwitchPK(), fImpl.getPK());
                        VsanImpl vsanImpl = vv = vImpl != null ? vImpl : swImpl.getVsan(mem.getIvrVsanId());
                        if (vv == null) continue;
                        if (ep.isTarget()) {
                            storages.add(new Object[]{ep, vv, vImpl == null});
                            continue;
                        }
                        hosts.add(new Object[]{ep, vv, vImpl == null});
                    }
                }
                for (int h = 0; h < hosts.size(); ++h) {
                    Object[] obH = (Object[])hosts.get(h);
                    for (int st = 0; st < storages.size(); ++st) {
                        Object[] obS = (Object[])storages.get(st);
                        HSPair hsPair = new HSPair((EndPortBase)obH[0], (EndPortBase)obS[0], fImpl, (VsanImpl)obS[1], zb[i], (Boolean)obS[2]);
                        HSPair hsPairData = FcPingAnalysis.find(encPairList, hsPair);
                        if (hsPairData == null) {
                            encPairList.add(hsPair);
                            continue;
                        }
                        hsPairData.addZone(zb[i]);
                    }
                }
            }
            for (i = 0; i < encPairList.size(); ++i) {
                HSPair hsPr = (HSPair)encPairList.get(i);
                FcPingObject pingOb = FcPingAnalysis.findFcPingObject(pingList, hsPr);
                if (pingOb == null) {
                    SwitchImpl swHsSw = SanManager.getInstance().findSwitch(hsPr.hostImpl.getSwitchPK(), fImpl.getPK());
                    pingOb = new FcPingObject(swHsSw);
                    pingList.add(pingOb);
                }
                pingOb.addHSPair(hsPr);
            }
        }
    }

    @Override
    public void buildReportSynchronously(VsanPK vPk, FabricPK fPk, ArrayList encPairList, Object[] params, ReportProgressTracker prTracker, long fabricDbId, long vsanDbId) throws Exception {
        if (vPk == null) {
            return;
        }
        VsanImpl vImpl = SanManager.getInstance().findVsan(vPk);
        if (vPk != null && vImpl == null) {
            _Logger.info((Object)("FCPing Report Fabric with VSAN PK:" + vPk + " not being monitored."));
            this.warnings.add("FCPing Report Fabric with VSAN PK:" + vPk + " not being monitored.");
            return;
        }
        FabricImpl fImpl = vImpl.getFabric();
        if (fImpl == null) {
            _Logger.info((Object)("FCPing Report " + fPk != null ? "Invalid Data Fabric PK:" + fPk : "Could not find Fabric for VsanPK" + vPk));
            this.warnings.add("FCPing Report " + fPk != null ? "Invalid Data Fabric PK:" + fPk : "Could not find Fabric for VsanPK" + vPk);
            return;
        }
        if (this.logUnlicensedFabric(fImpl) && this.logUnopenedFabric(fImpl)) {
            return;
        }
        ZoneBase[] zb = vImpl.getEnforcedZones();
        this.buildFcPingObjects(zb, fImpl, encPairList, vImpl);
        int totalPingSz = 0;
        for (int i = 0; i < encPairList.size(); ++i) {
            FcPingObject pingOb = (FcPingObject)encPairList.get(i);
            for (int d = 0; d < pingOb.dstPortList.size(); ++d) {
                FcPingDstPortObject dstPrt = (FcPingDstPortObject)pingOb.dstPortList.get(d);
                totalPingSz += dstPrt.hsPairList.size();
            }
        }
        _Logger.info((Object)("FcPing Number of Host Storage pairs: " + totalPingSz + " switches:" + encPairList.size() + (vImpl != null ? "  VSAN:" + vImpl : "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList buildTextReport(ArrayList pingObjList) {
        FcPingObject hsp;
        int i;
        int totalNumberofPings = 0;
        this.completedPingReqests = 0;
        long startTime = System.currentTimeMillis();
        for (i = 0; i < pingObjList.size(); ++i) {
            hsp = (FcPingObject)pingObjList.get(i);
            totalNumberofPings += hsp.dstPortList.size();
        }
        _Logger.info((Object)("Total number of pings to be run:" + totalNumberofPings));
        for (i = 0; i < pingObjList.size(); ++i) {
            if (this.exceedsAllowedRunTime()) {
                this.warnings.add("Timeout, Report running more than " + this.getReportRunTime() + " mins.  Quitting operation.");
                _Logger.info((Object)("Timeout, Report running more than " + this.getReportRunTime() + " mins.  Quitting operation."));
                break;
            }
            if (this.isStopped()) break;
            hsp = (FcPingObject)pingObjList.get(i);
            Thread thd = new Thread(new RunPing(hsp, i + 1, pingObjList.size(), this));
            thd.start();
        }
        FcPingAnalysis i2 = this;
        synchronized (i2) {
            while (this.completedPingReqests < pingObjList.size()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        long endTime = System.currentTimeMillis();
        _Logger.info((Object)("Total ping time:" + (endTime - startTime) / 1000L + " sec"));
        ArrayList<Object[]> outData = new ArrayList<Object[]>();
        for (int i3 = 0; i3 < pingObjList.size(); ++i3) {
            FcPingObject fPingOb = (FcPingObject)pingObjList.get(i3);
            for (int k = 0; k < fPingOb.dstPortList.size(); ++k) {
                FcPingDstPortObject hsp2 = (FcPingDstPortObject)fPingOb.dstPortList.get(k);
                for (int p = 0; p < hsp2.hsPairList.size(); ++p) {
                    HSPair hspOb = (HSPair)hsp2.hsPairList.get(p);
                    Object[] data = new Object[]{(!hspOb.isIvr ? "" : "(IVR)") + hspOb.storageVsanImpl.toString(), hspOb.hostImpl.toString() + (hspOb.storageVsanImpl != null ? "" : hspOb.hostImpl.getVsansAsString()), hspOb.storageImpl.toString() + (hspOb.storageVsanImpl != null ? "" : hspOb.storageImpl.getVsansAsString()), hsp2.pingResult != null ? StringUtil.tokenize(hsp2.pingResult, "\n") : ""};
                    outData.add(data);
                }
            }
        }
        return outData;
    }

    static HSPair find(ArrayList hsPairList, HSPair hsPair) {
        for (int i = 0; i < hsPairList.size(); ++i) {
            HSPair hsp = (HSPair)hsPairList.get(i);
            if (!hsp.equals(hsPair)) continue;
            return hsp;
        }
        return null;
    }

    static FcPingObject findFcPingObject(ArrayList pingPairList, HSPair hsPair) {
        for (int i = 0; i < pingPairList.size(); ++i) {
            FcPingObject hsp = (FcPingObject)pingPairList.get(i);
            SwitchImpl swImpl = SanManager.getInstance().findSwitch(hsPair.hostImpl.getSwitchPK(), hsPair.fabricImpl.getPK());
            if (!hsp.pingSwitch.equals(swImpl)) continue;
            return hsp;
        }
        return null;
    }

    class RunPing
    implements Runnable {
        FcPingObject hsp;
        int listSz;
        int index;
        Object syncObject;

        public RunPing(FcPingObject hs, int id, int size, Object sync) {
            this.hsp = hs;
            this.index = id;
            this.listSz = size;
            this.syncObject = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block42: {
                block40: {
                    Vsh vsh;
                    block38: {
                        block39: {
                            vsh = null;
                            if (!FcPingAnalysis.this.isStopped()) break block38;
                            if (vsh == null) break block39;
                            Vsh.put(vsh);
                        }
                        FcPingAnalysis.this.setPercentCompleted(25 + 75 * (FcPingAnalysis.this.completedPingReqests + 1) / this.listSz);
                        Object object = this.syncObject;
                        synchronized (object) {
                            ++FcPingAnalysis.this.completedPingReqests;
                            try {
                                if (FcPingAnalysis.this.completedPingReqests == this.listSz) {
                                    this.syncObject.notify();
                                }
                            }
                            catch (Exception exx) {
                                _Logger.info((Object)("Notify Failed " + exx.getMessage()));
                                FcPingAnalysis.this.warnings.add("Notify Failed " + exx.getMessage());
                            }
                        }
                        return;
                    }
                    try {
                        if (this.hsp.pingSwitch != null && this.hsp.pingSwitch.getPeer() != null) {
                            if (vsh == null) {
                                vsh = Vsh.get(null, this.hsp.pingSwitch.getPeer(), false);
                            }
                            _Logger.info((Object)("Sending " + this.hsp.dstPortList.size() + " pings from switch " + this.hsp.pingSwitch));
                            for (int h = 0; h < this.hsp.dstPortList.size() && !FcPingAnalysis.this.isStopped(); ++h) {
                                if (FcPingAnalysis.this.exceedsAllowedRunTime()) {
                                    FcPingAnalysis.this.warnings.add("Timeout, Report running more than " + FcPingAnalysis.this.getReportRunTime() + " mins.  Quitting operation.");
                                    _Logger.info((Object)("Timeout, Report running more than " + FcPingAnalysis.this.getReportRunTime() + " mins.  Quitting operation."));
                                    break;
                                }
                                FcPingDstPortObject fcDstOb = (FcPingDstPortObject)this.hsp.dstPortList.get(h);
                                fcDstOb.pingResult = "Command not run";
                                if (vsh != null && fcDstOb.vsanImpl != null) {
                                    String cmd = "fcping pwwn " + SnmpString.toHexString(fcDstOb.dstPort.getPortWwn().getValue()) + " vsan " + fcDstOb.vsanImpl.getId() + "\n";
                                    StringBuffer buf = new StringBuffer();
                                    StringBuffer bufStatus = new StringBuffer();
                                    bufStatus.append("Ping:" + fcDstOb.dstPort.toString() + " from " + this.hsp.pingSwitch.toString());
                                    buf.append(bufStatus.toString());
                                    buf.append("\n   for hosts: \n");
                                    for (int p = 0; p < fcDstOb.hsPairList.size(); ++p) {
                                        HSPair hspOb = (HSPair)fcDstOb.hsPairList.get(p);
                                        buf.append(hspOb.hostImpl);
                                        if (p <= 0) continue;
                                        buf.append(", ");
                                    }
                                    FcPingAnalysis.this.setStatus(bufStatus.toString());
                                    vsh.send(cmd);
                                    String pingRes = vsh.readPrompt();
                                    int promptIndex = pingRes.lastIndexOf(vsh.getPrompt());
                                    if (promptIndex > 0) {
                                        fcDstOb.pingResult = this.hsp.pingSwitch.getPeer() + ":" + pingRes.substring(0, promptIndex);
                                    }
                                } else {
                                    fcDstOb.pingResult = this.hsp.pingSwitch.getPeer() + ":" + "Telnet fcping command failed.";
                                }
                                FcPingAnalysis.this.setPercentCompleted(25 + 75 * FcPingAnalysis.this.completedPingReqests / this.listSz + (h + 1) * 75 / (this.hsp.dstPortList.size() * this.listSz));
                            }
                        }
                        if (vsh == null) break block40;
                    }
                    catch (IOException ex) {
                        block41: {
                            try {
                                _Logger.info((Object)("IOException " + ex.getMessage()));
                                FcPingAnalysis.this.warnings.add("IOException " + ex.getMessage());
                                if (vsh == null) break block41;
                            }
                            catch (Throwable throwable) {
                                if (vsh != null) {
                                    Vsh.put(vsh);
                                }
                                FcPingAnalysis.this.setPercentCompleted(25 + 75 * (FcPingAnalysis.this.completedPingReqests + 1) / this.listSz);
                                Object object = this.syncObject;
                                synchronized (object) {
                                    ++FcPingAnalysis.this.completedPingReqests;
                                    try {
                                        if (FcPingAnalysis.this.completedPingReqests == this.listSz) {
                                            this.syncObject.notify();
                                        }
                                    }
                                    catch (Exception exx) {
                                        _Logger.info((Object)("Notify Failed " + exx.getMessage()));
                                        FcPingAnalysis.this.warnings.add("Notify Failed " + exx.getMessage());
                                    }
                                }
                                throw throwable;
                            }
                            Vsh.put(vsh);
                        }
                        FcPingAnalysis.this.setPercentCompleted(25 + 75 * (FcPingAnalysis.this.completedPingReqests + 1) / this.listSz);
                        Object object = this.syncObject;
                        synchronized (object) {
                            ++FcPingAnalysis.this.completedPingReqests;
                            try {
                                if (FcPingAnalysis.this.completedPingReqests == this.listSz) {
                                    this.syncObject.notify();
                                }
                            }
                            catch (Exception exx) {
                                _Logger.info((Object)("Notify Failed " + exx.getMessage()));
                                FcPingAnalysis.this.warnings.add("Notify Failed " + exx.getMessage());
                            }
                            break block42;
                        }
                    }
                    Vsh.put(vsh);
                }
                FcPingAnalysis.this.setPercentCompleted(25 + 75 * (FcPingAnalysis.this.completedPingReqests + 1) / this.listSz);
                Object h = this.syncObject;
                synchronized (h) {
                    ++FcPingAnalysis.this.completedPingReqests;
                    try {
                        if (FcPingAnalysis.this.completedPingReqests == this.listSz) {
                            this.syncObject.notify();
                        }
                    }
                    catch (Exception exx) {
                        _Logger.info((Object)("Notify Failed " + exx.getMessage()));
                        FcPingAnalysis.this.warnings.add("Notify Failed " + exx.getMessage());
                    }
                }
            }
        }
    }

    class FcPingDstPortObject {
        EndPortBase dstPort;
        VsanImpl vsanImpl;
        ArrayList hsPairList = new ArrayList();
        String pingResult = "";

        public FcPingDstPortObject(EndPortBase dst, VsanImpl vsanI) {
            this.dstPort = dst;
            this.vsanImpl = vsanI;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            FcPingDstPortObject z1 = (FcPingDstPortObject)o1;
            FcPingDstPortObject z2 = (FcPingDstPortObject)o2;
            return z1.dstPort.compareTo(z2.dstPort) + z1.vsanImpl.compareTo(z2.vsanImpl);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            FcPingDstPortObject z1 = (FcPingDstPortObject)obj;
            return z1.dstPort.equals(this.dstPort) && z1.vsanImpl.equals(this.vsanImpl);
        }

        public int compareTo(Object o) {
            return this.compare(this, o);
        }

        public void addHSPair(HSPair hs) {
            if (!this.hsPairList.contains(hs)) {
                if (this.dstPort == null) {
                    this.dstPort = hs.storageImpl;
                    this.vsanImpl = hs.storageVsanImpl;
                }
                this.hsPairList.add(hs);
            }
        }
    }

    class FcPingObject {
        SwitchImpl pingSwitch;
        ArrayList dstPortList;

        public FcPingObject(SwitchImpl pSw) {
            this.pingSwitch = pSw;
            this.dstPortList = new ArrayList();
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            FcPingObject z1 = (FcPingObject)o1;
            FcPingObject z2 = (FcPingObject)o2;
            return z1.pingSwitch.compareTo(z2.pingSwitch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            FcPingObject z1 = (FcPingObject)obj;
            return z1.pingSwitch.equals(this.pingSwitch);
        }

        public int compareTo(Object o) {
            return this.compare(this, o);
        }

        public void addHSPair(HSPair hs) {
            FcPingDstPortObject fcpOb = new FcPingDstPortObject(hs.storageImpl, hs.storageVsanImpl);
            int indexFcOb = this.dstPortList.indexOf(fcpOb);
            if (indexFcOb == -1) {
                this.dstPortList.add(fcpOb);
            } else {
                fcpOb = (FcPingDstPortObject)this.dstPortList.get(indexFcOb);
            }
            fcpOb.addHSPair(hs);
        }
    }

    class HSPair
    implements Comparator,
    Comparable {
        VsanImpl storageVsanImpl;
        EndPortBase hostImpl;
        EndPortBase storageImpl;
        FabricImpl fabricImpl;
        ArrayList zoneList;
        boolean isIvr;

        public HSPair(EndPortBase host, EndPortBase storage, FabricImpl fImpl, VsanImpl vImpl, ZoneBase zn, boolean ivr) {
            this.hostImpl = host;
            this.storageImpl = storage;
            this.fabricImpl = fImpl;
            this.storageVsanImpl = vImpl;
            this.isIvr = ivr;
            this.zoneList = new ArrayList();
            this.addZone(zn);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            HSPair z1 = (HSPair)o1;
            HSPair z2 = (HSPair)o2;
            int vsanImplcomp = z1.storageVsanImpl != null && z2.storageVsanImpl != null ? z1.storageVsanImpl.compareTo(z2.storageVsanImpl) : (z1.storageVsanImpl == null || z2.storageVsanImpl == null ? 0 : 1);
            return vsanImplcomp + z1.hostImpl.compareTo(z2.hostImpl) + z1.storageImpl.compareTo(z2.storageImpl);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            HSPair z1 = (HSPair)obj;
            return z1.hostImpl.equals(this.hostImpl) && z1.storageImpl.equals(this.storageImpl) && z1.storageVsanImpl.equals(this.storageVsanImpl);
        }

        public int compareTo(Object o) {
            return this.compare(this, o);
        }

        public void addZone(ZoneBase zb) {
            if (!this.zoneList.contains(zb)) {
                this.zoneList.add(zb);
            }
        }
    }

    class FcPingAnalysisGenerator
    extends ReportAnalysis.RunReportThread {
        int faId;
        String vsanPKString;
        int reportType;
        long timeout;
        long fabricDbID;
        long vsanDbID;

        public FcPingAnalysisGenerator(int fid, String vsanPKString, boolean asynchronous, long tmOut, long fabricDbID, long vsanDbID) {
            super(asynchronous);
            this.faId = fid;
            this.vsanPKString = vsanPKString;
            this.timeout = tmOut;
            this.fabricDbID = fabricDbID;
            this.vsanDbID = vsanDbID;
        }

        @Override
        protected BaseAnalysisReport doAction() throws Exception {
            if (this.timeout > 0L) {
                FcPingAnalysis.this.setMaxRunTimeInMin(this.timeout);
            }
            VsanPK[] vPK = ReportAnalysis.getVsanPK(this.vsanPKString);
            ArrayList data = FcPingAnalysis.this.buildReportSynchronously(this.vsanPKString, this.faId, null, false, this.fabricDbID, this.vsanDbID);
            BaseAnalysisReport znRpt = new BaseAnalysisReport(this.faId, this.vsanPKString, this.reportType);
            FcPingAnalysis.this.setReportData(znRpt);
            znRpt.setReportData(data);
            return znRpt;
        }
    }
}

