/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.config;

import com.cisco.dcbu.jaxws.san.wo.ConfigComparisonResultDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigFileInfoDO;
import com.cisco.dcbu.jaxws.san.wo.SftpCredentialDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameDO;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.saxman.textdiff.TextDiff;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.analysis.BaseAnalysisReport;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ServerObjectCache;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.facade.WebAnalysisImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.web.client.util.LogService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BackUpConfiguration
extends ReportAnalysis {
    static final String LOCAL_HOST = "127.0.0.1";
    static long SLEEP_TIME = 500L;
    public static final int USE_TFTP = 1;
    public static final int USE_SFTP = 3;
    public static final int USE_SCP = 4;
    public static final int USE_FTP = 2;
    public static final int ARCHIVE_CONFIG = 1;
    public static final int RUNNING_CONFIG = 2;
    public static final int STARTUP_CONFIG = 3;
    public static final String[] CONFIG_OPTIONS = new String[]{"File", "Running", "Startup"};
    public static final String VRF_MANAGEMENT = " vrf management ";
    public static final String DEFAULT_MANAGEMENT = " vrf default ";
    public static final String VRF_NO_ROUTE = "NO ROUTE";
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    public static final String UNSELECTED_ID = "-10";
    public static final String CONFIGURE_BACKUP_SERVER = "Please configure Backup Server from Admin/SFTP Credentials";

    private BackUpConfiguration() {
        String slpTmStr = System.getProperty("BACKUP_SLEEPTIME");
        if (slpTmStr == null) {
            SLEEP_TIME = 500L;
        } else {
            try {
                SLEEP_TIME = Long.parseLong(slpTmStr);
            }
            catch (Exception ex) {
                SLEEP_TIME = 500L;
            }
        }
    }

    public static BackUpConfiguration newInstance() {
        return new BackUpConfiguration();
    }

    @Override
    public void generateReportAsynchronously(int fid, String vsanPKString, Object[] param, int reportType, int rptId, long fabricDbID, long vsanDbID) {
        this.reptId = rptId;
        _Logger.info((Object)("Start Running " + ServerObjectCache.OBJECT_ID_2_NAME[reportType - 1] + " Async ID:" + fid + " vsanPK:" + vsanPKString + " Report Type:" + reportType));
        if (this.isReportRunning()) {
            return;
        }
        BackUpConfigGenerator repGenerator = new BackUpConfigGenerator(param, true, reportType);
        this.initNewReport();
        new Thread(repGenerator).start();
    }

    @Override
    public ArrayList generateReportSynchronously(int fid, String vsanPKString, Object[] param, int reportType, long fabricDbID, long vsanDbID) throws Exception {
        BackUpConfigGenerator repGenerator = new BackUpConfigGenerator(param, true, reportType);
        _Logger.info((Object)("Start Running " + ServerObjectCache.OBJECT_ID_2_NAME[reportType - 1] + " Async ID:" + fid + " Report Type:" + reportType));
        this.initNewReport();
        repGenerator.run();
        if (this.isErrorInProcessing()) {
            throw this.getErrorException();
        }
        return repGenerator.getThReport().getReportData();
    }

    WebAnalysisRif getRifFMS(String swName, String fmsIpAddress) {
        try {
            if (fmsIpAddress != null && fmsIpAddress.length() > 0) {
                boolean isLocal;
                EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
                if (rif == null) {
                    return null;
                }
                String localServer = rif.getFMServer().whereami();
                boolean bl = isLocal = fmsIpAddress.equals("localhost") || localServer.equals(fmsIpAddress);
                if (isLocal) {
                    return rif.getWebAnalysis();
                }
                return (WebAnalysisRif)rif.getRemoteService(fmsIpAddress, System.getProperty("server.port", "4447"), "WebAnalysisBean", WebAnalysisRif.class.getName());
            }
        }
        catch (Exception ex) {
            _Logger.info((Object)("Error in getting information of server managing switch " + swName));
        }
        return null;
    }

    public String[] backUpEtherSwitchGroup(long groupId, int configType, int protocol, String usrName, String pssWrd, String rootDir) throws Exception {
        String[] outStr = new String[]{"", ""};
        String fl = null;
        int swsBackedup = 0;
        String lanGroupName = NavigationUtil.getInstance().getGroupName(groupId);
        _Logger.info((Object)("-------Begin backup for LAN Group:" + lanGroupName + " id:" + groupId + "-------"));
        SwitchNameDO[] swNameDO = SwitchHandler.getInstance().getAllLanSwitchesForGroupID(groupId);
        int eligibleSws = 0;
        if (swNameDO != null && swNameDO.length > 0) {
            long startTime = System.currentTimeMillis();
            for (int s = 0; s < swNameDO.length; ++s) {
                long swDbId = swNameDO[s].swDbId;
                if (!swNameDO[s].isMds && !swNameDO[s].isLanSwitch) {
                    BackUpConfiguration.logTrace("Skipping non Nx Switch " + swNameDO[s].name);
                    continue;
                }
                if (!swNameDO[s].isLicensed) {
                    if (swNameDO[s].isCat) {
                        BackUpConfiguration.logTrace("Skipping unsupported Switch " + swNameDO[s].name);
                        continue;
                    }
                    BackUpConfiguration.logTrace("Skipping unlicensed Switch " + swNameDO[s].name);
                    continue;
                }
                if (swNameDO[s].isUcs) {
                    BackUpConfiguration.logTrace("Skipping UCS Switch " + swNameDO[s].name);
                    continue;
                }
                if (!swNameDO[s].isManageble) {
                    BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swNameDO[s].name);
                    continue;
                }
                if (!swNameDO[s].isV3) {
                    BackUpConfiguration.logTrace("Skipping non SNMPv3 Switch " + swNameDO[s].name);
                    continue;
                }
                if (swNameDO[s].isFex) {
                    BackUpConfiguration.logTrace("Skipping Fex Switch " + swNameDO[s].name);
                    continue;
                }
                Object[] swData = SwitchHandler.getInstance().getFMSManagingLanSwitch(swDbId);
                if (swData == null) {
                    _Logger.info((Object)("Skipping switch with DBID " + swDbId + " as the FMS managing the switch could not be found."));
                    continue;
                }
                String fmsIpAddress = swData[0].toString();
                String swName = swData[1].toString();
                if (swData[2] == null) {
                    _Logger.info((Object)("Skipping switch " + swName + " as it has no IP address."));
                    continue;
                }
                ++eligibleSws;
                String swIpAddress = swData[2].toString();
                _Logger.info((Object)("-------Begin backup for switch:" + swName + "-------"));
                if (fmsIpAddress == null || fmsIpAddress.trim().length() == 0) {
                    _Logger.info((Object)("Skipping switch " + swName + " as the FMS managing the switch could not be found."));
                    continue;
                }
                _Logger.info((Object)("The switch " + swName + " managed by FMS " + fmsIpAddress));
                boolean localFms = false;
                String[] localIPAdd = NetUtil.getLocalIPAddresses();
                if (localIPAdd != null) {
                    for (int l = 0; l < localIPAdd.length; ++l) {
                        if (!localIPAdd[l].equals(fmsIpAddress)) continue;
                        localFms = true;
                        break;
                    }
                }
                if (localFms) {
                    fl = this.backUpLanSwitch(swIpAddress, configType, protocol, usrName, pssWrd, rootDir, true);
                } else {
                    WebAnalysisRif wRif = this.getRifFMS(swName, fmsIpAddress);
                    fl = wRif.backUpLanSwitch(swIpAddress, configType, protocol, usrName, pssWrd, rootDir, true);
                }
                if (fl != null) {
                    ++swsBackedup;
                    File fl2 = new File(fl);
                    fl2.delete();
                    fl2 = null;
                    continue;
                }
                this.logEvent(groupId, "Failed to back up Switch:" + swIpAddress + " from LAN Group " + lanGroupName);
            }
            long endTime = System.currentTimeMillis();
            _Logger.info((Object)("Backed up Eth Switch Group " + lanGroupName + ", Switches " + swsBackedup + " backed up out of " + eligibleSws + " eligible switches, total switches " + swNameDO.length + " in " + (endTime - startTime) / 60L / 1000L + " minutes. *********************************************************"));
            this.setStatus((swsBackedup == eligibleSws ? "Ok, " : "Warning, ") + swsBackedup + " backed up out of " + eligibleSws + " eligible switches, total switches " + swNameDO.length);
            this.logEvent(groupId, "Backup LAN Group " + lanGroupName + " : " + swsBackedup + " backed up out of " + eligibleSws + " eligible switches, total switches " + swNameDO.length);
            outStr[0] = this.getStatus();
            String exceptionStr = "";
            if (this.warnings.size() > 0) {
                for (int w = 0; w < this.warnings.size(); ++w) {
                    exceptionStr = exceptionStr + this.warnings.get(w).toString() + "\n";
                }
            }
            if (exceptionStr.length() > 0) {
                this.errorInProcessing = true;
                this.errorException = new Exception(exceptionStr + (this.errorException != null ? this.errorException.getMessage() : ""));
                outStr[1] = this.errorException.getMessage();
            }
        } else {
            _Logger.info((Object)("No Ether Switches in Group:" + groupId));
        }
        return outStr;
    }

    public String[] backUpFabric(int fid, int configType, int protocol, String usrName, String pssWrd, String rootDir, boolean isLan) throws Exception {
        if (isLan) {
            return this.backUpLan(new LanPK(fid), configType, protocol, usrName, pssWrd, rootDir);
        }
        return this.backUpFabric(new FabricPK(fid), configType, protocol, usrName, pssWrd, rootDir);
    }

    public String[] backUpFabric(FabricPK pK, int configType, int protocol, String usrName, String pssWrd, String rootDir) throws Exception {
        String[] outStr = new String[]{"", ""};
        FabricImpl fImpl = SanManager.getInstance().findFabric(pK);
        File fl = null;
        int swsBackedup = 0;
        int eligibleSws = 0;
        if (fImpl != null) {
            SwitchImpl[] sws = fImpl.getSwitches();
            if (sws != null) {
                long startTime = System.currentTimeMillis();
                for (int s = 0; s < sws.length; ++s) {
                    boolean isV3;
                    _Logger.info((Object)("-------Begin backup for switch:" + sws[s] + "-------"));
                    SwitchImpl swI = sws[s];
                    if (!(swI.isMDS() || swI.isN5K() || swI.isN7K() || swI.isQuail() || ((SwitchBase)swI.getBaseObject()).isN7K())) {
                        BackUpConfiguration.logTrace("Skipping non MDS Switch " + swI);
                        continue;
                    }
                    if (!swI.isManageable()) {
                        BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                        continue;
                    }
                    swI.getFabric();
                    boolean bl = isV3 = FabricImpl.getSnmpUser(swI.getFabric().getPK()).getSecurityModel() == 3;
                    if (!swI.isManageable() || !isV3) {
                        BackUpConfiguration.logTrace("Skipping non SNMP v3 Switch " + swI);
                        continue;
                    }
                    if (swI.getLicenseDetails() == null || !swI.getLicenseDetails().isLicensed()) {
                        BackUpConfiguration.logTrace("Skipping unlicensed Switch " + swI);
                        continue;
                    }
                    ++eligibleSws;
                    fl = this.backUpSanSwitch(sws[s], configType, protocol, usrName, pssWrd, rootDir, true);
                    if (fl != null) {
                        ++swsBackedup;
                        continue;
                    }
                    this.logEvent(fImpl, "Failed to back up Switch:" + sws[s] + " from Fabric " + fImpl);
                }
                long endTime = System.currentTimeMillis();
                _Logger.info((Object)("Backed up Fabric " + fImpl + ", Switches " + swsBackedup + " out of " + sws.length + " in " + (endTime - startTime) / 60L / 1000L + " minutes. *********************************************************"));
                this.setStatus((swsBackedup == eligibleSws ? "Ok, " : "Warning, ") + swsBackedup + " out of " + eligibleSws + " eligible switches backed up. (Total switches=" + sws.length + ")");
                this.logEvent(fImpl, "Backup Fabric " + fImpl.toString() + " : " + swsBackedup + " out of " + eligibleSws + " eligible switches backed up. (Total switches=" + sws.length + ")");
                outStr[0] = this.getStatus();
            } else {
                _Logger.info((Object)("No Switches available for Fabric id:" + pK));
            }
            String exceptionStr = "";
            if (this.warnings.size() > 0) {
                for (int w = 0; w < this.warnings.size(); ++w) {
                    exceptionStr = exceptionStr + this.warnings.get(w).toString() + "\n";
                }
            }
            if (exceptionStr.length() > 0) {
                this.errorInProcessing = true;
                this.errorException = new Exception(exceptionStr + (this.errorException != null ? this.errorException.getMessage() : ""));
                outStr[1] = this.errorException.getMessage();
            }
        } else {
            _Logger.info((Object)("No Fabric available for id:" + pK));
        }
        return outStr;
    }

    public String[] backUpLan(LanPK pK, int configType, int protocol, String usrName, String pssWrd, String rootDir) throws Exception {
        String[] outStr = new String[]{"", ""};
        LanImpl laImpl = DCManager.getInstance().findLan(pK);
        File fl = null;
        int swsBackedup = 0;
        int eligibleSws = 0;
        if (laImpl != null) {
            List<EthSwitchImpl> sws = laImpl.getEthSwitches();
            if (sws != null) {
                long startTime = System.currentTimeMillis();
                for (int s = 0; s < sws.size(); ++s) {
                    boolean isV3;
                    _Logger.info((Object)("-------Begin backup for switch:" + sws.get(s) + "-------"));
                    EthSwitchImpl swI = sws.get(s);
                    EthSwitchBase swBase = (EthSwitchBase)swI.getBaseObject();
                    if (!PlatformType.isNexusSwitch(swBase.getPlatformType()) && !PlatformType.isMdsSwitch(swBase.getPlatformType()) || PlatformType.isCATSwitch(swBase.getPlatformType())) {
                        BackUpConfiguration.logTrace("Skipping non Nx Switch " + swI);
                        continue;
                    }
                    if (!swI.isManageable()) {
                        BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                        continue;
                    }
                    boolean bl = isV3 = swI.getCredential().getSecurityModel() == 3;
                    if (!swI.isManageable() || !isV3) {
                        BackUpConfiguration.logTrace("Skipping non SNMP v3 Switch " + swI);
                        continue;
                    }
                    if (swBase.getLicenseDetails() != null && swBase.isLicenseViolation()) {
                        BackUpConfiguration.logTrace("Skipping unlicensed Switch " + swI);
                        continue;
                    }
                    ++eligibleSws;
                    fl = this.backUpLanSwitch(sws.get(s), configType, protocol, usrName, pssWrd, rootDir, true);
                    if (fl != null) {
                        ++swsBackedup;
                        continue;
                    }
                    this.logEvent(laImpl, "Failed to back up Switch:" + sws.get(s) + " from Lan " + laImpl);
                }
                long endTime = System.currentTimeMillis();
                _Logger.info((Object)("Backed up LAN " + laImpl + ", Switches " + swsBackedup + " out of " + sws.size() + " in " + (endTime - startTime) / 60L / 1000L + " minutes. *********************************************************"));
                this.setStatus((swsBackedup == sws.size() ? "Ok, " : "Warning, ") + swsBackedup + " out of " + eligibleSws + " eligible switches backed up. (Total switches=" + sws.size() + ")");
                this.logEvent(laImpl, "Backup LAN " + laImpl.toString() + " : " + swsBackedup + " out of " + " out of " + eligibleSws + " eligible switches backed up. (Total switches=" + sws.size() + ")");
                outStr[0] = this.getStatus();
            } else {
                _Logger.info((Object)("No Switches available for Fabric id:" + pK));
            }
            String exceptionStr = "";
            if (this.warnings.size() > 0) {
                for (int w = 0; w < this.warnings.size(); ++w) {
                    exceptionStr = exceptionStr + this.warnings.get(w).toString() + "\n";
                }
            }
            if (exceptionStr.length() > 0) {
                this.errorInProcessing = true;
                this.errorException = new Exception(exceptionStr + (this.errorException != null ? this.errorException.getMessage() : ""));
                outStr[1] = this.errorException.getMessage();
            }
        } else {
            _Logger.info((Object)("No LAN available for id:" + pK));
        }
        return outStr;
    }

    public File backUpSwitch(String swName, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        SwitchImpl swI = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swName));
        if (swI == null) {
            BackUpConfiguration.logTrace("Switch " + swName + " not found in SAN network.");
            EthSwitchImpl swIEth = DCManager.getInstance().findEthSwitchBySwIp(InetAddress.getByName(swName));
            if (swIEth == null) {
                BackUpConfiguration.logTrace("Switch " + swName + " not found in LAN network.");
                return null;
            }
            BackUpConfiguration.logTrace("Switch " + swName + " found in LAN network.");
            return this.backUpLanSwitch(swIEth, configType, protocol, usrName, passWord, rootDir, moveToDB);
        }
        return this.backUpSanSwitch(swI, configType, protocol, usrName, passWord, rootDir, moveToDB);
    }

    public void logEvent(FabricImpl fImpl, String descr) {
        EventLoggerService eventLogger = (EventLoggerService)ServiceConfig.findService((String)"Event Logger Service");
        if (eventLogger != null) {
            LogEvent e = new LogEvent((Object)fImpl.getPK(), LogEventType.OTHER, Severity.INFO, "Backup service", descr, fImpl.getDBID());
            eventLogger.logEvent(e);
        } else {
            this.setStatus("Backup Configuration: Event Logger Service not available.");
        }
    }

    public void logEvent(LanImpl fImpl, String descr) {
        EventLoggerService eventLogger = (EventLoggerService)ServiceConfig.findService((String)"Event Logger Service");
        if (eventLogger != null) {
            LogEvent e = new LogEvent((Object)fImpl.getPK(), LogEventType.SWITCH_MANAGEABILITY, Severity.INFO, "Backup service", descr, fImpl.getDBID());
            eventLogger.logEvent(e);
        } else {
            this.setStatus("Backup Configuration: Event Logger Service not available.");
        }
    }

    public void logEvent(long lanGroupId, String descr) {
        EventLoggerService eventLogger = (EventLoggerService)ServiceConfig.findService((String)"Event Logger Service");
        if (eventLogger != null) {
            LogEvent e = new LogEvent(new FabricPK((int)lanGroupId), LogEventType.SWITCH_MANAGEABILITY, Severity.INFO, "Backup service", descr);
            eventLogger.logEvent(e);
        } else {
            this.setStatus("Backup Configuration: Event Logger Service not available.");
        }
    }

    private void moveToDB(File inFile) throws Exception {
        PersistentHelper.getHelper().storeFile(inFile, "server", "config_file");
    }

    private void moveToDBIfCheckSumChanged(File inFile, String ipAddress, String configType) throws Exception {
        if (inFile.length() == 0L) {
            throw new Exception("Cannot move file to DB:" + inFile.getAbsolutePath() + " for switch:" + ipAddress + ".\n The file is either zero size or the root directory is set incorrectly. ");
        }
        ArrayList chkSumLst = PersistentHelper.getHelper().getSwitchCheckSumsDescendingByTime(ipAddress, configType);
        if (chkSumLst != null && chkSumLst.size() > 0) {
            long checkSum = ReportUtil.getFileCheckSum(inFile, '!');
            if ((Long)chkSumLst.get(0) == checkSum) {
                BackUpConfiguration.logTrace("The last backed up config type:" + configType + " for Switch " + ipAddress + " is not changed from current configuration. (checksum:" + checkSum + ") Skipping persistance of current configuration.");
                return;
            }
        }
        this.moveToDB(inFile);
    }

    public void readFromDB(String key, File outFile) throws Exception {
        PersistentHelper.getHelper().retrieveFile(key, outFile, "server", "config_file");
    }

    public void readFromDB(Date date, File outFile) throws Exception {
        PersistentHelper.getHelper().retrieveFile(date.getTime(), outFile, "server", "config_file");
    }

    public ArrayList readDocNames(String prefix) throws Exception {
        ArrayList<ConfigFileInfoDO> modFileList = new ArrayList<ConfigFileInfoDO>();
        ArrayList fileList = PersistentHelper.getHelper().retrieveDocNames(prefix, "server", "config_file");
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                ConfigFileInfoDO flDo = (ConfigFileInfoDO)fileList.get(i);
                flDo.setConfigFilesDisplay(BackUpConfiguration.getReadableConfigFileNameFromDBName(flDo.getConfigFiles()));
                modFileList.add(flDo);
            }
        }
        return modFileList;
    }

    public int[] getBackedUpSwitches(List<SwitchNameDO> swLst) throws Exception {
        int[] backedUpSwitches = new int[]{0, 0};
        if (swLst == null || swLst.size() == 0) {
            return backedUpSwitches;
        }
        ArrayList fileList = PersistentHelper.getHelper().retrieveDocNames(null, "server", "config_file");
        HashMap<String, Integer> swMap = new HashMap<String, Integer>();
        HashMap<String, Integer> lastBackedUpSwMap = new HashMap<String, Integer>();
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                StringTokenizer token = new StringTokenizer(((ConfigFileInfoDO)fileList.get(i)).getConfigFiles(), "-");
                String newName = token.nextToken();
                if (!token.hasMoreTokens()) continue;
                try {
                    int s;
                    if (swLst == null) continue;
                    SwitchNameDO swDo = null;
                    for (s = 0; s < swLst.size(); ++s) {
                        swDo = swLst.get(s);
                        if (swDo.ipAddress != null && swDo.ipAddress.equals(newName)) break;
                    }
                    if (s == swLst.size()) continue;
                    if (swDo != null && s < swLst.size() && swDo.name != null && swDo.name.trim().length() > 0) {
                        newName = swDo.name;
                    }
                    if (swMap.get(newName) == null) {
                        swMap.put(newName, i);
                        backedUpSwitches[0] = backedUpSwitches[0] + 1;
                    }
                    if (lastBackedUpSwMap.get(newName) != null) continue;
                    String timestamp = token.nextToken() + "-" + token.nextToken();
                    Date dd = new SimpleDateFormat("yyMMdd-HHmmss").parse(timestamp);
                    GregorianCalendar calendarFile = new GregorianCalendar();
                    calendarFile.setTime(dd);
                    GregorianCalendar calendarToday = new GregorianCalendar();
                    calendarToday.setTime(new Date());
                    if (calendarToday.get(1) != calendarFile.get(1) || calendarToday.get(2) != calendarFile.get(2) || calendarToday.get(5) != calendarFile.get(5)) continue;
                    backedUpSwitches[1] = backedUpSwitches[1] + 1;
                    lastBackedUpSwMap.put(newName, i);
                    continue;
                }
                catch (Exception ex) {
                    LogService.log((Level)LogService._WARNING, (Throwable)ex);
                }
            }
        }
        return backedUpSwitches;
    }

    private static String getConfigTypeName(boolean isUCS, int configType) {
        return isUCS ? "R" : (configType == 3 ? "S" : (configType == -1 ? "TEST" : "R"));
    }

    private static String generateFileName(String ipAddress, boolean isUCS, int configType) {
        return ipAddress + "-" + new SimpleDateFormat("yyMMdd-HHmmss").format(new Date()) + "-" + BackUpConfiguration.getConfigTypeName(isUCS, configType);
    }

    private static String getReadableConfigFileNameFromDBName(String flName) {
        String newName = null;
        StringTokenizer token = new StringTokenizer(flName, "-");
        int count = -1;
        block8: while (token.hasMoreTokens()) {
            switch (++count) {
                case 0: {
                    newName = token.nextToken();
                    SwitchImpl swI = null;
                    try {
                        swI = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(newName));
                    }
                    catch (UnknownHostException exx) {
                        LogService.log((Level)LogService._WARNING, (Throwable)exx);
                    }
                    if (swI == null) continue block8;
                    newName = swI.getName();
                    continue block8;
                }
                case 1: {
                    try {
                        Date dd = new SimpleDateFormat("yyMMdd-HHmmss").parse(token.nextToken() + "-" + token.nextToken());
                        GregorianCalendar cll = new GregorianCalendar();
                        cll.setTime(dd);
                        int mnth = cll.get(2) + 1;
                        int day = cll.get(5);
                        int hr = cll.get(11);
                        int min = cll.get(12);
                        newName = newName + "  " + cll.get(1) + "-" + (mnth < 10 ? "0" : "") + mnth + "-" + (day < 10 ? "0" : "") + day + ", " + (hr < 10 ? "0" : "") + hr + ":" + (min < 10 ? "0" : "") + min;
                    }
                    catch (Exception ex) {
                        LogService.log((Level)LogService._WARNING, (Throwable)ex);
                    }
                    continue block8;
                }
            }
            newName = newName + ", " + token.nextToken();
        }
        return newName == null ? flName : newName;
    }

    private static void logTrace(StringBuffer output) {
        _Logger.info((Object)output);
    }

    private static void logTrace(String output) {
        _Logger.info((Object)output);
    }

    private boolean canContinue() {
        return !this.isStopped();
    }

    private String getLocalServerIPAddress(SwitchImpl swI) {
        String[] ipAddLst = NetUtil.getLocalIPAddresses();
        String ipAdd = "";
        ipAdd = ipAddLst != null && ipAddLst.length == 1 ? ipAddLst[0] : NetUtil.getLocalHostFromSwitch(swI.getInetAddress());
        return ipAdd;
    }

    private VshBase getVshConnection(SwitchImpl swI, StringBuffer output) {
        VshBase vsh = null;
        StringBuffer lclOutput = new StringBuffer();
        try {
            String ipAdd = NetUtil.getLocalServerHostAddress();
            SnmpPeer prr = swI.getPeer();
            if (!(swI.isMDS() || swI.isN5K() || swI.isN7K() || swI.isQuail() || ((SwitchBase)swI.getBaseObject()).isN7K())) {
                BackUpConfiguration.logTrace("Skipping non MDS Switch " + swI);
                output.append("Skipping non MDS Switch " + swI + "\n");
                return null;
            }
            if (!swI.isManageable()) {
                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                output.append("Skipping unmanageable Switch " + swI + "\n");
                return null;
            }
            if (ipAdd == null) {
                BackUpConfiguration.logTrace("Unable to get local address with respect to Switch " + swI);
                output.append("Unable to get local address with respect to Switch " + swI + "\n");
                return null;
            }
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                output.append("Unable to open connection to Switch " + swI + "\n");
            }
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.append(ex.getMessage() + "\n");
        }
        return vsh;
    }

    private VshBase getVshConnection(SnmpPeer prr, StringBuffer output) {
        VshBase vsh = null;
        try {
            String ipAdd = NetUtil.getLocalServerHostAddress();
            if (ipAdd == null) {
                BackUpConfiguration.logTrace("Unable to get local address with respect to Switch " + prr);
                output.append("Unable to get local address with respect to Switch " + prr + "\n");
                return null;
            }
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + prr);
                output.append("Unable to open connection to Switch " + prr + "\n");
            }
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.append(ex.getMessage() + "\n");
        }
        return vsh;
    }

    private void createFileOnSwitch(boolean isUCS, int configType, VshBase vsh, StringBuffer output, String fileName) throws IOException {
        String configString = "";
        configString = isUCS ? "show configuration > " + fileName + "\n" : (configType == 3 ? "copy startup-config bootflash:" + fileName + "\n" : (configType == 2 ? "copy running-config bootflash:" + fileName + "\n" : "show switchname > bootflash:" + fileName + "\n"));
        vsh.send(configString);
        vsh.expect(new String[]{vsh.getPrompt()}, output);
        BackUpConfiguration.logTrace(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File backUpSanSwitch(SwitchImpl swI, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        File backedFile;
        block85: {
            Exception localException;
            String currentPrompt;
            String fileName;
            StringBuffer output;
            VshBase vsh;
            block81: {
                block82: {
                    block78: {
                        File delBuf2222222222222222222222222222222222222222;
                        block79: {
                            block80: {
                                block75: {
                                    File delBuf2222222222222222222222222222222222222222;
                                    block76: {
                                        block77: {
                                            block72: {
                                                File delBuf2222222222222222222222222222222222222222;
                                                block73: {
                                                    block74: {
                                                        block69: {
                                                            File delBuf2222222222222222222222222222222222222222;
                                                            block70: {
                                                                block71: {
                                                                    boolean isV3;
                                                                    block66: {
                                                                        File file;
                                                                        block67: {
                                                                            block68: {
                                                                                block63: {
                                                                                    File file2;
                                                                                    block64: {
                                                                                        block65: {
                                                                                            vsh = null;
                                                                                            Object tftpSrvr = null;
                                                                                            backedFile = null;
                                                                                            output = new StringBuffer();
                                                                                            fileName = null;
                                                                                            currentPrompt = null;
                                                                                            localException = null;
                                                                                            if (swI.isMDS() || swI.isN5K() || swI.isN7K() || swI.isQuail() || ((SwitchBase)swI.getBaseObject()).isN7K()) break block63;
                                                                                            BackUpConfiguration.logTrace("Skipping non MDS Switch " + swI);
                                                                                            output.append("Skipping non MDS Switch " + swI + "\n");
                                                                                            file2 = backedFile;
                                                                                            if (vsh == null) break block64;
                                                                                            if (fileName == null || fileName == null) break block65;
                                                                                            try {
                                                                                                Thread.sleep(SLEEP_TIME);
                                                                                            }
                                                                                            catch (InterruptedException ex) {
                                                                                                // empty catch block
                                                                                            }
                                                                                            vsh.send("delete bootflash:" + fileName + "\n");
                                                                                            StringBuffer delBuf3 = new StringBuffer();
                                                                                            vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf3);
                                                                                            output.append(delBuf3);
                                                                                            if (delBuf3.indexOf("[y") != -1 || delBuf3.indexOf("(yes") != -1) {
                                                                                                vsh.send("y\n");
                                                                                                vsh.expect(new String[]{currentPrompt}, output);
                                                                                            }
                                                                                            BackUpConfiguration.logTrace(output);
                                                                                        }
                                                                                        vsh.disconnect();
                                                                                        vsh = null;
                                                                                    }
                                                                                    if (moveToDB && backedFile != null) {
                                                                                        backedFile.delete();
                                                                                    }
                                                                                    if (localException != null) {
                                                                                        backedFile = null;
                                                                                    }
                                                                                    return file2;
                                                                                }
                                                                                if (swI.isManageable()) break block66;
                                                                                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                                                                                output.append("Skipping unmanageable Switch " + swI + "\n");
                                                                                file = backedFile;
                                                                                if (vsh == null) break block67;
                                                                                if (fileName == null || fileName == null) break block68;
                                                                                try {
                                                                                    Thread.sleep(SLEEP_TIME);
                                                                                }
                                                                                catch (InterruptedException ex) {
                                                                                    // empty catch block
                                                                                }
                                                                                vsh.send("delete bootflash:" + fileName + "\n");
                                                                                StringBuffer delBuf2222222222222222222222222222222222222222 = new StringBuffer();
                                                                                vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf2222222222222222222222222222222222222222);
                                                                                output.append(delBuf2222222222222222222222222222222222222222);
                                                                                if (delBuf2222222222222222222222222222222222222222.indexOf("[y") != -1 || delBuf2222222222222222222222222222222222222222.indexOf("(yes") != -1) {
                                                                                    vsh.send("y\n");
                                                                                    vsh.expect(new String[]{currentPrompt}, output);
                                                                                }
                                                                                BackUpConfiguration.logTrace(output);
                                                                            }
                                                                            vsh.disconnect();
                                                                            vsh = null;
                                                                        }
                                                                        if (moveToDB && backedFile != null) {
                                                                            backedFile.delete();
                                                                        }
                                                                        if (localException != null) {
                                                                            backedFile = null;
                                                                        }
                                                                        return file;
                                                                    }
                                                                    swI.getFabric();
                                                                    boolean bl = isV3 = FabricImpl.getSnmpUser(swI.getFabric().getPK()).getSecurityModel() == 3;
                                                                    if (swI.isManageable() && isV3) break block69;
                                                                    BackUpConfiguration.logTrace("Skipping non SNMP v3 Switch " + swI);
                                                                    delBuf2222222222222222222222222222222222222222 = backedFile;
                                                                    if (vsh == null) break block70;
                                                                    if (fileName == null || fileName == null) break block71;
                                                                    try {
                                                                        Thread.sleep(SLEEP_TIME);
                                                                    }
                                                                    catch (InterruptedException ex) {
                                                                        // empty catch block
                                                                    }
                                                                    vsh.send("delete bootflash:" + fileName + "\n");
                                                                    StringBuffer delBuf4 = new StringBuffer();
                                                                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf4);
                                                                    output.append(delBuf4);
                                                                    if (delBuf4.indexOf("[y") != -1 || delBuf4.indexOf("(yes") != -1) {
                                                                        vsh.send("y\n");
                                                                        vsh.expect(new String[]{currentPrompt}, output);
                                                                    }
                                                                    BackUpConfiguration.logTrace(output);
                                                                }
                                                                vsh.disconnect();
                                                                vsh = null;
                                                            }
                                                            if (moveToDB && backedFile != null) {
                                                                backedFile.delete();
                                                            }
                                                            if (localException != null) {
                                                                backedFile = null;
                                                            }
                                                            return delBuf2222222222222222222222222222222222222222;
                                                        }
                                                        if (swI.getLicenseDetails() != null && swI.getLicenseDetails().isLicensed()) break block72;
                                                        BackUpConfiguration.logTrace("Skipping unlicensed Switch " + swI);
                                                        delBuf2222222222222222222222222222222222222222 = backedFile;
                                                        if (vsh == null) break block73;
                                                        if (fileName == null || fileName == null) break block74;
                                                        try {
                                                            Thread.sleep(SLEEP_TIME);
                                                        }
                                                        catch (InterruptedException ex) {
                                                            // empty catch block
                                                        }
                                                        vsh.send("delete bootflash:" + fileName + "\n");
                                                        StringBuffer delBuf5 = new StringBuffer();
                                                        vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf5);
                                                        output.append(delBuf5);
                                                        if (delBuf5.indexOf("[y") != -1 || delBuf5.indexOf("(yes") != -1) {
                                                            vsh.send("y\n");
                                                            vsh.expect(new String[]{currentPrompt}, output);
                                                        }
                                                        BackUpConfiguration.logTrace(output);
                                                    }
                                                    vsh.disconnect();
                                                    vsh = null;
                                                }
                                                if (moveToDB && backedFile != null) {
                                                    backedFile.delete();
                                                }
                                                if (localException != null) {
                                                    backedFile = null;
                                                }
                                                return delBuf2222222222222222222222222222222222222222;
                                            }
                                            if (!swI.isUCS()) break block75;
                                            delBuf2222222222222222222222222222222222222222 = this.backUpCLIUCSSwitch(swI, configType, protocol, usrName, passWord, rootDir, moveToDB);
                                            if (vsh == null) break block76;
                                            if (fileName == null || fileName == null) break block77;
                                            try {
                                                Thread.sleep(SLEEP_TIME);
                                            }
                                            catch (InterruptedException ex) {
                                                // empty catch block
                                            }
                                            vsh.send("delete bootflash:" + fileName + "\n");
                                            StringBuffer delBuf6 = new StringBuffer();
                                            vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf6);
                                            output.append(delBuf6);
                                            if (delBuf6.indexOf("[y") != -1 || delBuf6.indexOf("(yes") != -1) {
                                                vsh.send("y\n");
                                                vsh.expect(new String[]{currentPrompt}, output);
                                            }
                                            BackUpConfiguration.logTrace(output);
                                        }
                                        vsh.disconnect();
                                        vsh = null;
                                    }
                                    if (moveToDB && backedFile != null) {
                                        backedFile.delete();
                                    }
                                    if (localException != null) {
                                        backedFile = null;
                                    }
                                    return delBuf2222222222222222222222222222222222222222;
                                }
                                vsh = this.getVshConnection(swI.getPeer(), output);
                                if (vsh != null) break block78;
                                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                                delBuf2222222222222222222222222222222222222222 = backedFile;
                                if (vsh == null) break block79;
                                if (fileName == null || fileName == null) break block80;
                                try {
                                    Thread.sleep(SLEEP_TIME);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                vsh.send("delete bootflash:" + fileName + "\n");
                                StringBuffer delBuf7 = new StringBuffer();
                                vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf7);
                                output.append(delBuf7);
                                if (delBuf7.indexOf("[y") != -1 || delBuf7.indexOf("(yes") != -1) {
                                    vsh.send("y\n");
                                    vsh.expect(new String[]{currentPrompt}, output);
                                }
                                BackUpConfiguration.logTrace(output);
                            }
                            vsh.disconnect();
                            vsh = null;
                        }
                        if (moveToDB && backedFile != null) {
                            backedFile.delete();
                        }
                        if (localException != null) {
                            backedFile = null;
                        }
                        return delBuf2222222222222222222222222222222222222222;
                    }
                    currentPrompt = vsh.getPrompt();
                    fileName = BackUpConfiguration.generateFileName(swI.getIpAddress(), swI.isUCS(), configType);
                    this.createFileOnSwitch(swI.isUCS(), configType, vsh, output, fileName);
                    SwitchBase swBase = (SwitchBase)swI.getBaseObject();
                    String appendCmd = !swBase.isNuovaFamily() && (swI.isMDS() || swBase.isFCoEEnabled() && swBase.isVdc()) ? "" : VRF_MANAGEMENT;
                    StringBuffer errorInfo = new StringBuffer();
                    backedFile = vsh.backUpSwitch(swI.getIpAddress(), fileName, configType, usrName, passWord, appendCmd, protocol, rootDir, errorInfo);
                    if (errorInfo.toString().toUpperCase().indexOf(VRF_NO_ROUTE) != -1) {
                        errorInfo.setLength(0);
                        appendCmd = DEFAULT_MANAGEMENT;
                        backedFile = vsh.backUpSwitch(swI.getIpAddress(), fileName, configType, usrName, passWord, appendCmd, protocol, rootDir, errorInfo);
                    }
                    if (backedFile != null) {
                        if (backedFile.length() == 0L) {
                            throw new Exception("Cannot move file to DB:" + backedFile.getAbsolutePath() + " for switch:" + swI.getIpAddress() + ".\n The file is either zero size or the root directory is set incorrectly. ");
                        }
                        if (moveToDB) {
                            this.moveToDBIfCheckSumChanged(backedFile, swI.getIpAddress(), BackUpConfiguration.getConfigTypeName(swI.isUCS(), configType));
                        }
                    } else {
                        vsh.disconnect();
                        vsh = null;
                        vsh = this.getVshConnection(swI.getPeer(), output);
                        throw new Exception(errorInfo.toString());
                    }
                    if (vsh == null) break block81;
                    if (fileName == null || fileName == null) break block82;
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    vsh.send("delete bootflash:" + fileName + "\n");
                    StringBuffer delBuf = new StringBuffer();
                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                    output.append(delBuf);
                    if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                        vsh.send("y\n");
                        vsh.expect(new String[]{currentPrompt}, output);
                    }
                    BackUpConfiguration.logTrace(output);
                }
                vsh.disconnect();
                vsh = null;
            }
            if (moveToDB && backedFile != null) {
                backedFile.delete();
            }
            if (localException != null) {
                backedFile = null;
            }
            break block85;
            catch (Exception exx) {
                block83: {
                    block84: {
                        try {
                            BackUpConfiguration.logTrace(exx.getMessage());
                            if (exx != null && exx.getMessage().toUpperCase().indexOf("TIMED OUT") != -1) {
                                BackUpConfiguration.logTrace("Switch may not be reachable.");
                            }
                            localException = exx;
                            this.errorInProcessing = true;
                            this.errorException = exx;
                            this.warnings.add(exx.getMessage());
                            if (vsh == null) break block83;
                            if (fileName == null || fileName == null) break block84;
                        }
                        catch (Throwable throwable) {
                            if (vsh != null) {
                                if (fileName != null && fileName != null) {
                                    try {
                                        Thread.sleep(SLEEP_TIME);
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                    vsh.send("delete bootflash:" + fileName + "\n");
                                    StringBuffer delBuf = new StringBuffer();
                                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                                    output.append(delBuf);
                                    if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                                        vsh.send("y\n");
                                        vsh.expect(new String[]{currentPrompt}, output);
                                    }
                                    BackUpConfiguration.logTrace(output);
                                }
                                vsh.disconnect();
                                vsh = null;
                            }
                            if (moveToDB && backedFile != null) {
                                backedFile.delete();
                            }
                            if (localException != null) {
                                backedFile = null;
                            }
                            throw throwable;
                        }
                        try {
                            Thread.sleep(SLEEP_TIME);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        vsh.send("delete bootflash:" + fileName + "\n");
                        StringBuffer delBuf = new StringBuffer();
                        vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                        output.append(delBuf);
                        if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                            vsh.send("y\n");
                            vsh.expect(new String[]{currentPrompt}, output);
                        }
                        BackUpConfiguration.logTrace(output);
                    }
                    vsh.disconnect();
                    vsh = null;
                }
                if (moveToDB && backedFile != null) {
                    backedFile.delete();
                }
                if (localException != null) {
                    backedFile = null;
                }
            }
        }
        return backedFile;
    }

    public String backUpLanSwitch(String swIP, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        EthSwitchImpl swI = DCManager.getInstance().findEthSwitchBySwIp(InetAddress.getByName(swIP));
        File fl = this.backUpLanSwitch(swI, configType, protocol, usrName, passWord, rootDir, moveToDB);
        String flName = null;
        if (fl != null) {
            flName = fl.getAbsolutePath();
            fl.delete();
            fl = null;
        }
        return flName;
    }

    public String backUpSanSwitch(String swIP, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        SwitchImpl swI = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swIP));
        File fl = this.backUpSanSwitch(swI, configType, protocol, usrName, passWord, rootDir, moveToDB);
        String flName = null;
        if (fl != null) {
            flName = fl.getAbsolutePath();
            fl.delete();
            fl = null;
        }
        return flName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File backUpLanSwitch(EthSwitchImpl swI, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        File backedFile;
        block69: {
            String currentPrompt;
            String fileName;
            StringBuffer output;
            VshBase vsh;
            block65: {
                block66: {
                    EthSwitchBase swBase;
                    StringBuffer errorInfo;
                    block62: {
                        File delBuf222222222222222222222222222222;
                        block63: {
                            block64: {
                                block59: {
                                    File delBuf222222222222222222222222222222;
                                    block60: {
                                        block61: {
                                            block56: {
                                                File delBuf222222222222222222222222222222;
                                                block57: {
                                                    block58: {
                                                        boolean isV3;
                                                        block53: {
                                                            File file;
                                                            block54: {
                                                                block55: {
                                                                    block50: {
                                                                        File file2;
                                                                        block51: {
                                                                            block52: {
                                                                                vsh = null;
                                                                                backedFile = null;
                                                                                output = new StringBuffer();
                                                                                fileName = null;
                                                                                currentPrompt = null;
                                                                                errorInfo = new StringBuffer();
                                                                                swBase = (EthSwitchBase)swI.getBaseObject();
                                                                                if ((PlatformType.isNexusSwitch(swBase.getPlatformType()) || PlatformType.isMdsSwitch(swBase.getPlatformType())) && !PlatformType.isCATSwitch(swBase.getPlatformType())) break block50;
                                                                                BackUpConfiguration.logTrace("Skipping non Nx Switch " + swI);
                                                                                output.append("Skipping non Nx Switch " + swI + "\n");
                                                                                file2 = backedFile;
                                                                                if (vsh == null) break block51;
                                                                                if (fileName == null || fileName == null) break block52;
                                                                                try {
                                                                                    Thread.sleep(SLEEP_TIME);
                                                                                }
                                                                                catch (InterruptedException ex) {
                                                                                    // empty catch block
                                                                                }
                                                                                vsh.send("delete bootflash:" + fileName + "\n");
                                                                                StringBuffer delBuf3 = new StringBuffer();
                                                                                vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf3);
                                                                                output.append(delBuf3);
                                                                                if (delBuf3.indexOf("[y") != -1 || delBuf3.indexOf("(yes") != -1) {
                                                                                    vsh.send("y\n");
                                                                                    vsh.expect(new String[]{currentPrompt}, output);
                                                                                }
                                                                                BackUpConfiguration.logTrace(output);
                                                                            }
                                                                            vsh.disconnect();
                                                                            vsh = null;
                                                                        }
                                                                        if (moveToDB && backedFile != null) {
                                                                            backedFile.delete();
                                                                        }
                                                                        return file2;
                                                                    }
                                                                    if (swI.isManageable()) break block53;
                                                                    BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                                                                    output.append("Skipping unmanageable Switch " + swI + "\n");
                                                                    file = backedFile;
                                                                    if (vsh == null) break block54;
                                                                    if (fileName == null || fileName == null) break block55;
                                                                    try {
                                                                        Thread.sleep(SLEEP_TIME);
                                                                    }
                                                                    catch (InterruptedException ex) {
                                                                        // empty catch block
                                                                    }
                                                                    vsh.send("delete bootflash:" + fileName + "\n");
                                                                    StringBuffer delBuf222222222222222222222222222222 = new StringBuffer();
                                                                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf222222222222222222222222222222);
                                                                    output.append(delBuf222222222222222222222222222222);
                                                                    if (delBuf222222222222222222222222222222.indexOf("[y") != -1 || delBuf222222222222222222222222222222.indexOf("(yes") != -1) {
                                                                        vsh.send("y\n");
                                                                        vsh.expect(new String[]{currentPrompt}, output);
                                                                    }
                                                                    BackUpConfiguration.logTrace(output);
                                                                }
                                                                vsh.disconnect();
                                                                vsh = null;
                                                            }
                                                            if (moveToDB && backedFile != null) {
                                                                backedFile.delete();
                                                            }
                                                            return file;
                                                        }
                                                        boolean bl = isV3 = swI.getCredential().getSecurityModel() == 3;
                                                        if (swI.isManageable() && isV3) break block56;
                                                        BackUpConfiguration.logTrace("Skipping non SNMP v3 Switch " + swI);
                                                        delBuf222222222222222222222222222222 = backedFile;
                                                        if (vsh == null) break block57;
                                                        if (fileName == null || fileName == null) break block58;
                                                        try {
                                                            Thread.sleep(SLEEP_TIME);
                                                        }
                                                        catch (InterruptedException ex) {
                                                            // empty catch block
                                                        }
                                                        vsh.send("delete bootflash:" + fileName + "\n");
                                                        StringBuffer delBuf4 = new StringBuffer();
                                                        vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf4);
                                                        output.append(delBuf4);
                                                        if (delBuf4.indexOf("[y") != -1 || delBuf4.indexOf("(yes") != -1) {
                                                            vsh.send("y\n");
                                                            vsh.expect(new String[]{currentPrompt}, output);
                                                        }
                                                        BackUpConfiguration.logTrace(output);
                                                    }
                                                    vsh.disconnect();
                                                    vsh = null;
                                                }
                                                if (moveToDB && backedFile != null) {
                                                    backedFile.delete();
                                                }
                                                return delBuf222222222222222222222222222222;
                                            }
                                            if (swBase.getLicenseDetails() != null && !swBase.isLicenseViolation()) break block59;
                                            BackUpConfiguration.logTrace("Skipping unlicensed Switch " + swI);
                                            delBuf222222222222222222222222222222 = backedFile;
                                            if (vsh == null) break block60;
                                            if (fileName == null || fileName == null) break block61;
                                            try {
                                                Thread.sleep(SLEEP_TIME);
                                            }
                                            catch (InterruptedException ex) {
                                                // empty catch block
                                            }
                                            vsh.send("delete bootflash:" + fileName + "\n");
                                            StringBuffer delBuf5 = new StringBuffer();
                                            vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf5);
                                            output.append(delBuf5);
                                            if (delBuf5.indexOf("[y") != -1 || delBuf5.indexOf("(yes") != -1) {
                                                vsh.send("y\n");
                                                vsh.expect(new String[]{currentPrompt}, output);
                                            }
                                            BackUpConfiguration.logTrace(output);
                                        }
                                        vsh.disconnect();
                                        vsh = null;
                                    }
                                    if (moveToDB && backedFile != null) {
                                        backedFile.delete();
                                    }
                                    return delBuf222222222222222222222222222222;
                                }
                                vsh = this.getVshConnection(swI.getPeer(), output);
                                if (vsh != null) break block62;
                                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                                delBuf222222222222222222222222222222 = backedFile;
                                if (vsh == null) break block63;
                                if (fileName == null || fileName == null) break block64;
                                try {
                                    Thread.sleep(SLEEP_TIME);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                vsh.send("delete bootflash:" + fileName + "\n");
                                StringBuffer delBuf6 = new StringBuffer();
                                vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf6);
                                output.append(delBuf6);
                                if (delBuf6.indexOf("[y") != -1 || delBuf6.indexOf("(yes") != -1) {
                                    vsh.send("y\n");
                                    vsh.expect(new String[]{currentPrompt}, output);
                                }
                                BackUpConfiguration.logTrace(output);
                            }
                            vsh.disconnect();
                            vsh = null;
                        }
                        if (moveToDB && backedFile != null) {
                            backedFile.delete();
                        }
                        return delBuf222222222222222222222222222222;
                    }
                    currentPrompt = vsh.getPrompt();
                    fileName = BackUpConfiguration.generateFileName(swI.getIpAddress(), false, configType);
                    this.createFileOnSwitch(false, configType, vsh, output, fileName);
                    String appendCmd = !swBase.isNuovaFamily() && (swBase.isMDS() || swI.isFCoEEnabled() && swBase.isVdc()) ? "" : VRF_MANAGEMENT;
                    backedFile = vsh.backUpSwitch(swI.getIpAddress(), fileName, configType, usrName, passWord, appendCmd, protocol, rootDir, errorInfo);
                    if (errorInfo.toString().toUpperCase().indexOf(VRF_NO_ROUTE) != -1) {
                        errorInfo.setLength(0);
                        appendCmd = DEFAULT_MANAGEMENT;
                        backedFile = vsh.backUpSwitch(swI.getIpAddress(), fileName, configType, usrName, passWord, appendCmd, protocol, rootDir, errorInfo);
                    }
                    if (backedFile != null) {
                        if (backedFile.length() == 0L) {
                            throw new Exception("Cannot move file to DB:" + backedFile.getAbsolutePath() + " for switch:" + swI.getIpAddress() + ".\n The file is either zero size or the root directory is set incorrectly. ");
                        }
                        if (moveToDB) {
                            this.moveToDBIfCheckSumChanged(backedFile, swI.getIpAddress(), BackUpConfiguration.getConfigTypeName(false, configType));
                        }
                    } else {
                        vsh.disconnect();
                        vsh = null;
                        vsh = this.getVshConnection(swI.getPeer(), output);
                        throw new Exception(errorInfo.toString());
                    }
                    if (vsh == null) break block65;
                    if (fileName == null || fileName == null) break block66;
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    vsh.send("delete bootflash:" + fileName + "\n");
                    StringBuffer delBuf = new StringBuffer();
                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                    output.append(delBuf);
                    if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                        vsh.send("y\n");
                        vsh.expect(new String[]{currentPrompt}, output);
                    }
                    BackUpConfiguration.logTrace(output);
                }
                vsh.disconnect();
                vsh = null;
            }
            if (moveToDB && backedFile != null) {
                backedFile.delete();
            }
            break block69;
            catch (Exception exx) {
                block67: {
                    block68: {
                        try {
                            BackUpConfiguration.logTrace(exx.getMessage());
                            if (exx != null && exx.getMessage().toUpperCase().indexOf("TIMED OUT") != -1) {
                                BackUpConfiguration.logTrace("Switch may not be reachable.");
                            }
                            this.errorInProcessing = true;
                            this.errorException = exx;
                            this.warnings.add(exx.getMessage());
                            if (backedFile == null || backedFile.length() == 0L) {
                                backedFile = null;
                            }
                            if (vsh == null) break block67;
                            if (fileName == null || fileName == null) break block68;
                        }
                        catch (Throwable throwable) {
                            if (vsh != null) {
                                if (fileName != null && fileName != null) {
                                    try {
                                        Thread.sleep(SLEEP_TIME);
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                    vsh.send("delete bootflash:" + fileName + "\n");
                                    StringBuffer delBuf = new StringBuffer();
                                    vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                                    output.append(delBuf);
                                    if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                                        vsh.send("y\n");
                                        vsh.expect(new String[]{currentPrompt}, output);
                                    }
                                    BackUpConfiguration.logTrace(output);
                                }
                                vsh.disconnect();
                                vsh = null;
                            }
                            if (moveToDB && backedFile != null) {
                                backedFile.delete();
                            }
                            throw throwable;
                        }
                        try {
                            Thread.sleep(SLEEP_TIME);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        vsh.send("delete bootflash:" + fileName + "\n");
                        StringBuffer delBuf = new StringBuffer();
                        vsh.expect(new String[]{currentPrompt, "[y", "(yes"}, delBuf);
                        output.append(delBuf);
                        if (delBuf.indexOf("[y") != -1 || delBuf.indexOf("(yes") != -1) {
                            vsh.send("y\n");
                            vsh.expect(new String[]{currentPrompt}, output);
                        }
                        BackUpConfiguration.logTrace(output);
                    }
                    vsh.disconnect();
                    vsh = null;
                }
                if (moveToDB && backedFile != null) {
                    backedFile.delete();
                }
            }
        }
        return backedFile;
    }

    /*
     * Exception decompiling
     */
    public File backUpCLIUCSSwitch(SwitchImpl swI, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public File backUpXMLUCSSwitch(SwitchImpl swI, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 14[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList restoreConfigToLanSwitch(EthSwitchImpl swI, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        VshBase vsh = null;
        StringBuffer lclOutput = new StringBuffer();
        File fl1 = null;
        File fDir = null;
        try {
            String prepender;
            EthSwitchBase swBase = (EthSwitchBase)swI.getBaseObject();
            if (!swBase.isN7K() && !swBase.isNuovaFamily() && !swBase.isN5KVerLT503() || swBase.isCAT()) {
                BackUpConfiguration.logTrace("Skipping non MDS Switch " + swI);
                output.add("Skipping non MDS Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (!swI.isManageable()) {
                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                output.add("Skipping unmanageable Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            SnmpPeer prr = swI.getPeer();
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                output.add("Unable to open connection to Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            String currentPrompt = vsh.getPrompt();
            String string = prepender = rootDir == null ? "" : rootDir;
            if (protocol == 1) {
                prepender = TFTP.getInstance().getRoot();
            }
            String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
            fDir = this.createBackupDir(prepender + File.separator + subDir);
            String file1 = prepender + File.separator + subDir + File.separator + fileName;
            fl1 = new File(file1);
            this.readFromDB(fileName, fl1);
            String appendCmd = !swBase.isNuovaFamily() && (swBase.isMDS() || swI.isFCoEEnabled() && swBase.isVdc()) ? "" : VRF_MANAGEMENT;
            ArrayList copyOutPut = vsh.copyFileToSwitch(swI.getIpAddress(), protocol, usrName, passWord, fileName, subDir, configType, appendCmd);
            output.addAll(copyOutPut);
            vsh.send("copy  bootflash:" + fileName + (configType.equals("2") ? " running-config echo-commands " : " startup-config") + "\n");
            vsh.expect(new String[]{currentPrompt}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
            if (configType.equals("2")) {
                vsh.expect(new String[]{currentPrompt}, lclOutput);
                this.appendNextLineTokenedString(lclOutput, output);
                lclOutput.setLength(0);
            }
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            vsh.send("delete  bootflash:" + fileName + "\n");
            vsh.expect(new String[]{currentPrompt, "(yes/no", "[y"}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            if (lclOutput.indexOf("(yes/no") != -1 || lclOutput.indexOf("[y") != -1) {
                vsh.send("y\n");
                vsh.expect(new String[]{currentPrompt}, lclOutput);
            }
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.add(ex.getMessage());
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList restoreConfigToSanSwitch(SwitchImpl swI, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        VshBase vsh = null;
        StringBuffer lclOutput = new StringBuffer();
        File fl1 = null;
        File fDir = null;
        try {
            String prepender;
            if (swI.getLicenseDetails() == null || !swI.getLicenseDetails().isLicensed()) {
                BackUpConfiguration.logTrace("Skipping unlicensed Switch for Copy Configuration " + swI);
                output.add("Skipping unlicensed Switch for Copy Configuration " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (!(swI.isMDS() || swI.isN5K() || swI.isQuail() || ((SwitchBase)swI.getBaseObject()).isN7K())) {
                BackUpConfiguration.logTrace("Skipping non MDS Switch " + swI);
                output.add("Skipping non MDS Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (!swI.isManageable()) {
                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                output.add("Skipping unmanageable Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (swI.isUCS()) {
                ArrayList arrayList = this.restoreUCSCLIConfigToSwitch(swI, protocol, usrName, passWord, fileName, rootDir, configType);
                return arrayList;
            }
            SnmpPeer prr = swI.getPeer();
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                output.add("Unable to open connection to Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            String currentPrompt = vsh.getPrompt();
            String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
            String string = prepender = rootDir == null ? "" : rootDir;
            if (protocol == 1) {
                prepender = TFTP.getInstance().getRoot();
                subDir = "";
            }
            fDir = this.createBackupDir(prepender + File.separator + subDir);
            String file1 = prepender + File.separator + subDir + File.separator + fileName;
            fl1 = new File(file1);
            this.readFromDB(fileName, fl1);
            SwitchBase swBase = (SwitchBase)swI.getBaseObject();
            String appendCmd = !swBase.isN5K() && (swBase.isMDS() || swBase.isFCoEEnabled() && swBase.isVdc()) ? "" : VRF_MANAGEMENT;
            ArrayList copyOutPut = vsh.copyFileToSwitch(swI.getIpAddress(), protocol, usrName, passWord, fileName, subDir, configType, appendCmd);
            output.addAll(copyOutPut);
            vsh.send("copy  bootflash:" + fileName + (configType.equals("2") ? " running-config" + (swI.isVersionGreaterThanEqual("4.2(1)") ? " echo-commands " : "") : " startup-config") + "\n");
            vsh.expect(new String[]{currentPrompt}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
            if (swI.isVersionGreaterThanEqual("4.2(1)") && configType.equals("2")) {
                vsh.expect(new String[]{currentPrompt}, lclOutput);
                this.appendNextLineTokenedString(lclOutput, output);
                lclOutput.setLength(0);
            }
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            vsh.send("delete  bootflash:" + fileName + "\n");
            vsh.expect(new String[]{currentPrompt, "[y", "(yes/no"}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            if (lclOutput.indexOf("(yes/no") != -1 || lclOutput.indexOf("[y") != -1) {
                vsh.send("y\n");
                vsh.expect(new String[]{currentPrompt}, lclOutput);
            }
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.add(ex.getMessage());
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList restoreUCSCLIConfigToSwitch(SwitchImpl swI, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        VshBase vsh = null;
        TFTP tftpSrvr = null;
        StringBuffer lclOutput = new StringBuffer();
        File fl1 = null;
        File fDir = null;
        try {
            String ipAdd = NetUtil.getLocalServerHostAddress();
            SnmpPeer prr = swI.getPeer();
            if (!swI.isUCS()) {
                BackUpConfiguration.logTrace("Skipping non UCS Switch " + swI);
                output.add("Skipping non UCS Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (!swI.isManageable()) {
                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                output.add("Skipping unmanageable Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            if (ipAdd == null) {
                BackUpConfiguration.logTrace("Unable to get local address with respect to Switch " + swI);
                output.add("Unable to get local address with respect to Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                output.add("Unable to open connection to Switch " + swI);
                ArrayList<String> arrayList = output;
                return arrayList;
            }
            String currentPrompt = vsh.getPrompt();
            String prepender = rootDir == null ? "" : rootDir;
            String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
            fDir = this.createBackupDir(prepender + File.separator + subDir);
            String file1 = prepender + File.separator + subDir + File.separator + fileName;
            fl1 = new File(file1);
            this.readFromDB(fileName, fl1);
            switch (protocol) {
                case 3: {
                    if (!this.canContinue()) {
                        ArrayList<String> arrayList = output;
                        return arrayList;
                    }
                    lclOutput.setLength(0);
                    vsh.send("connect local-mgmt\n");
                    vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                    vsh.learn();
                    this.appendNextLineTokenedString(lclOutput, output);
                    lclOutput.setLength(0);
                    currentPrompt = vsh.getPrompt();
                    String cpStr = protocol == 4 ? "scp://" : (protocol == 3 ? "sftp://" : "ftp://");
                    String sshCmd = "copy " + cpStr + usrName + "@" + ipAdd + "/" + subDir + "/" + fileName + " workspace:" + fileName + "\n";
                    vsh.sendSSHCommand(sshCmd, currentPrompt, lclOutput);
                    if (protocol != 2 && output.indexOf("(yes/no)?") != -1) {
                        BackUpConfiguration.logTrace(lclOutput);
                        this.appendNextLineTokenedString(lclOutput, output);
                        lclOutput.setLength(0);
                        vsh.send("yes\n");
                        vsh.expect(new String[]{"password:", "Password:", currentPrompt}, lclOutput);
                    }
                    if (lclOutput.toString().toLowerCase().indexOf("password:") != -1) {
                        BackUpConfiguration.logTrace(lclOutput);
                        this.appendNextLineTokenedString(lclOutput, output);
                        lclOutput.setLength(0);
                        vsh.send(passWord + "\n");
                        vsh.expect(new String[]{"password:", "Password:", currentPrompt}, lclOutput);
                        if (lclOutput.toString().toLowerCase().indexOf("password:") != -1) {
                            BackUpConfiguration.logTrace(lclOutput);
                            this.appendNextLineTokenedString(lclOutput, output);
                            throw new Exception("Incorrect Password");
                        }
                        if (lclOutput.toString().indexOf("100%") != -1 || lclOutput.toString().toLowerCase().indexOf("copy complete") != -1 || lclOutput.toString().toLowerCase().indexOf("success") != -1) {
                            BackUpConfiguration.logTrace(lclOutput);
                            this.appendNextLineTokenedString(lclOutput, output);
                            lclOutput.setLength(0);
                            break;
                        }
                        throw new Exception("Remote copy failed. " + output + "\n Please see web logs for details.");
                    }
                    throw new Exception("Remote copy failed. " + output);
                }
                default: {
                    BackUpConfiguration.logTrace("Skipping unknown protocol UCS Switch " + swI + " protocol:" + protocol);
                    output.add("Skipping unknown protocol UCS Switch " + swI + " protocol:" + protocol);
                    ArrayList<String> arrayList = output;
                    return arrayList;
                }
            }
            if (lclOutput != null && lclOutput.toString().trim().length() > 0) {
                BackUpConfiguration.logTrace(lclOutput);
                throw new Exception(lclOutput.toString());
            }
            BackUpConfiguration.logTrace("Successful copy of file to be restored " + fileName + " to switch " + swI);
            output.add("Successful copy of file to be restored " + fileName + " to switch " + swI);
            vsh.send("run-script  workspace:" + fileName + "\n");
            vsh.expect(new String[]{currentPrompt}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
            vsh.send("delete file workspace:" + fileName + "\n");
            vsh.expect(new String[]{currentPrompt}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.add(ex.getMessage());
        }
        finally {
            if (tftpSrvr != null) {
                tftpSrvr.stopServer();
                tftpSrvr = null;
            }
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList restoreXMLUCSConfigToSwitch(SwitchImpl swI, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType) throws Exception {
        ArrayList<CharSequence> output = new ArrayList<CharSequence>();
        VshBase vsh = null;
        TFTP tftpSrvr = null;
        StringBuffer lclOutput = new StringBuffer();
        File fl1 = null;
        File fDir = null;
        try {
            String ipAdd = NetUtil.getLocalServerHostAddress();
            SnmpPeer prr = swI.getPeer();
            if (!swI.isUCS()) {
                BackUpConfiguration.logTrace("Skipping non UCS Switch " + swI);
                output.add("Skipping non UCS Switch " + swI);
                ArrayList<CharSequence> arrayList = output;
                return arrayList;
            }
            if (!swI.isManageable()) {
                BackUpConfiguration.logTrace("Skipping unmanageable Switch " + swI);
                output.add("Skipping unmanageable Switch " + swI);
                ArrayList<CharSequence> arrayList = output;
                return arrayList;
            }
            if (ipAdd == null) {
                BackUpConfiguration.logTrace("Unable to get local address with respect to Switch " + swI);
                output.add("Unable to get local address with respect to Switch " + swI);
                ArrayList<CharSequence> arrayList = output;
                return arrayList;
            }
            vsh = Vsh.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                BackUpConfiguration.logTrace("Unable to open connection to Switch " + swI);
                output.add("Unable to open connection to Switch " + swI);
                ArrayList<CharSequence> arrayList = output;
                return arrayList;
            }
            String currentPrompt = vsh.getPrompt();
            String prepender = rootDir == null ? "" : rootDir;
            String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
            fDir = this.createBackupDir(prepender + File.separator + subDir);
            String file1 = prepender + File.separator + subDir + File.separator + fileName;
            fl1 = new File(file1);
            this.readFromDB(fileName, fl1);
            switch (protocol) {
                case 3: {
                    if (!this.canContinue()) {
                        ArrayList<CharSequence> arrayList = output;
                        return arrayList;
                    }
                    vsh.send("scope system\n");
                    vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                    vsh.learn();
                    currentPrompt = vsh.getPrompt();
                    vsh.send("delete import-config " + ipAdd + "\n");
                    vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                    vsh.learn();
                    currentPrompt = vsh.getPrompt();
                    BackUpConfiguration.logTrace(lclOutput);
                    output.add(lclOutput);
                    lclOutput.setLength(0);
                    String sshCmd = "create import-config sftp://" + usrName + "@" + ipAdd + "/" + fileName + " enabled replace\n";
                    vsh.sendSSHCommand(sshCmd, currentPrompt, lclOutput);
                    if (output.toString().toLowerCase().indexOf("password:") != -1) {
                        BackUpConfiguration.logTrace(lclOutput);
                        output.add(lclOutput);
                        lclOutput.setLength(0);
                        vsh.send(passWord + "\n");
                        vsh.expect(new String[]{"password:", "Password:", currentPrompt}, lclOutput);
                        if (output.toString().toLowerCase().indexOf("password:") != -1) {
                            BackUpConfiguration.logTrace(lclOutput);
                            throw new Exception("Incorrect Password");
                        }
                        vsh.send("commit-buffer\n");
                        vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                        BackUpConfiguration.logTrace(lclOutput);
                        vsh.learn();
                        currentPrompt = vsh.getPrompt();
                        if (output.toString().toLowerCase().indexOf("error") != -1) {
                            throw new Exception("Remote copy failed. " + output + "\n Please see web logs for details.");
                        }
                        output.add(lclOutput);
                        lclOutput.setLength(0);
                        vsh.send("exit\n");
                        vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                        vsh.learn();
                        currentPrompt = vsh.getPrompt();
                        vsh.send("delete import-config " + ipAdd + "\n");
                        vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                        vsh.learn();
                        currentPrompt = vsh.getPrompt();
                        vsh.send("commit-buffer\n");
                        vsh.expect(new String[]{"#", currentPrompt}, lclOutput);
                        BackUpConfiguration.logTrace(lclOutput);
                        output.add(lclOutput);
                        lclOutput.setLength(0);
                        break;
                    }
                    BackUpConfiguration.logTrace(lclOutput);
                    throw new Exception("Remote copy failed. " + output);
                }
                default: {
                    BackUpConfiguration.logTrace("Skipping unknown protocol UCS Switch " + swI + " protocol:" + protocol);
                    output.add("Skipping unknown protocol UCS Switch " + swI + " protocol:" + protocol);
                    ArrayList<CharSequence> arrayList = output;
                    return arrayList;
                }
            }
            if (lclOutput != null && lclOutput.toString().trim().length() > 0) {
                BackUpConfiguration.logTrace(lclOutput);
                throw new Exception(lclOutput.toString());
            }
            BackUpConfiguration.logTrace("Successful copy of file to be restored " + fileName + " to switch " + swI);
            output.add("Successful copy of file to be restored " + fileName + " to switch " + swI);
            vsh.send("copy  bootflash:" + fileName + (configType.equals("2") ? " running-config" + (swI.isVersionGreaterThanEqual("4.2(1)") ? " echo-commands " : "") : " startup-config") + "\n");
            vsh.expect(new String[]{currentPrompt}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
            if (swI.isVersionGreaterThanEqual("4.2(1)") && configType.equals("2")) {
                vsh.expect(new String[]{currentPrompt}, lclOutput);
                this.appendNextLineTokenedString(lclOutput, output);
                lclOutput.setLength(0);
            }
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            vsh.send("delete  bootflash:" + fileName + "\n");
            vsh.expect(new String[]{currentPrompt, "[y", "(yes/no"}, lclOutput);
            this.appendNextLineTokenedString(lclOutput, output);
            if (lclOutput.indexOf("(yes/no") != -1 || lclOutput.indexOf("[y") != -1) {
                vsh.send("y\n");
                vsh.expect(new String[]{currentPrompt}, lclOutput);
            }
            this.appendNextLineTokenedString(lclOutput, output);
            lclOutput.setLength(0);
        }
        catch (Exception ex) {
            BackUpConfiguration.logTrace(ex.getMessage());
            if (ex instanceof IOException) {
                BackUpConfiguration.logTrace("FMS may have lost network connectivity");
            }
            output.add(ex.getMessage());
        }
        finally {
            if (tftpSrvr != null) {
                tftpSrvr.stopServer();
                tftpSrvr = null;
            }
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
        return output;
    }

    public File createBackupDir(String baseDir) {
        File fDir = new File(baseDir);
        if (!fDir.exists()) {
            fDir.mkdirs();
        }
        return fDir;
    }

    private void appendNextLineTokenedString(StringBuffer buf, ArrayList strLst) {
        String[] out = buf.toString().split("[\r\n]");
        if (out != null) {
            for (int i = 0; i < out.length; ++i) {
                if (out[i].trim().length() <= 0) continue;
                strLst.add(out[i]);
            }
        }
    }

    public ArrayList restoreConfigToSwitch(String swAddress, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType, boolean isLan) throws Exception {
        if (isLan) {
            EthSwitchImpl swI = DCManager.getInstance().findEthSwitchBySwIp(InetAddress.getByName(swAddress));
            if (swI == null) {
                throw new Exception("Failed to find switch :" + swAddress);
            }
            return this.restoreConfigToLanSwitch(swI, protocol, usrName, passWord, fileName, rootDir, configType);
        }
        SwitchImpl swI = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swAddress));
        if (swI == null) {
            throw new Exception("Failed to find switch :" + swAddress);
        }
        return this.restoreConfigToSanSwitch(swI, protocol, usrName, passWord, fileName, rootDir, configType);
    }

    public Object[] getConfigsFromDB(String ipAddress, boolean ignoreIPAddress) {
        ArrayList fileInfo = null;
        StringBuffer warnings = new StringBuffer();
        try {
            fileInfo = this.readDocNames(ignoreIPAddress ? null : (ipAddress != null ? ipAddress : UNSELECTED_ID));
            this.errorException = null;
        }
        catch (Exception ex) {
            this.errorInProcessing = true;
            this.errorException = ex;
            LogService.log((Level)LogService._SEVERE, (Throwable)ex);
        }
        return new Object[]{"", this.errorException, this.errorInProcessing, fileInfo};
    }

    public boolean deleteConfigFileFromDB(String configToView) throws Exception {
        PersistentHelper.getHelper().deleteFile(configToView);
        return true;
    }

    public String[] readConfigFile(String configToView) throws Exception {
        File fl1 = null;
        File fDir = null;
        InputStream stream1 = null;
        String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
        String prefix = ClientCache.getReportsDir() + File.separator + "backup" + File.separator + subDir + File.separator;
        String file1 = prefix + configToView;
        try {
            String line;
            if (configToView.startsWith(UNSELECTED_ID)) {
                throw new Exception("Please select configurations for viewing.");
            }
            fDir = this.createBackupDir(prefix);
            fl1 = new File(file1);
            this.readFromDB(configToView, fl1);
            stream1 = new FileInputStream(file1);
            InputStreamReader rd = new InputStreamReader(stream1);
            BufferedReader brd = new BufferedReader(rd);
            ArrayList<String> viewInfo = new ArrayList<String>();
            while ((line = brd.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String prepend = "";
                for (int p = 0; line.length() > p && line.charAt(p) == ' '; ++p) {
                    prepend = prepend + " ";
                }
                viewInfo.add(prepend + line.trim());
            }
            ArrayList newVI = new ArrayList();
            String[] stringArray = viewInfo.toArray(new String[viewInfo.size()]);
            return stringArray;
        }
        catch (Exception ex) {
            LogService.log((Level)LogService._SEVERE, (Throwable)ex);
            throw ex;
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
    }

    public StringBuffer readConfigFileAsString(String configToView) throws Exception {
        File fl1 = null;
        File fDir = null;
        InputStream stream1 = null;
        String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
        String prefix = ClientCache.getReportsDir() + File.separator + "backup" + File.separator + subDir + File.separator;
        String file1 = prefix + configToView;
        try {
            String line;
            if (configToView.startsWith(UNSELECTED_ID)) {
                throw new Exception("Please select configurations for viewing.");
            }
            fDir = this.createBackupDir(prefix);
            fl1 = new File(file1);
            this.readFromDB(configToView, fl1);
            stream1 = new FileInputStream(file1);
            InputStreamReader rd = new InputStreamReader(stream1);
            BufferedReader brd = new BufferedReader(rd);
            StringBuffer viewInfo = new StringBuffer();
            while ((line = brd.readLine()) != null) {
                String prepend = "";
                for (int p = 0; line.length() > p && line.charAt(p) == ' '; ++p) {
                    prepend = prepend + " ";
                }
                viewInfo.append(prepend + line.trim() + "\n");
            }
            StringBuffer newVI = new StringBuffer();
            for (int kk = 0; kk < 5; ++kk) {
                newVI.append(viewInfo);
            }
            StringBuffer stringBuffer = viewInfo = newVI;
            return stringBuffer;
        }
        catch (Exception ex) {
            LogService.log((Level)LogService._SEVERE, (Throwable)ex);
            throw ex;
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] compareconfigFiles(String configA, String configB) throws Exception {
        File fl1 = null;
        File fl2 = null;
        File fDir = null;
        InputStream stream1 = null;
        InputStream stream2 = null;
        try {
            String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
            String prefix = ClientCache.getReportsDir() + File.separator + "backup" + File.separator + subDir + File.separator;
            String file1 = prefix + configA;
            fDir = this.createBackupDir(prefix);
            fl1 = new File(file1);
            this.readFromDB(configA, fl1);
            stream1 = new FileInputStream(file1);
            String file2 = prefix + configB;
            fl2 = new File(file2);
            this.readFromDB(configB, fl2);
            stream2 = new FileInputStream(file2);
            Object[] objectArray = new Object[]{new TextDiff().compare(file1, file2, true)};
            return objectArray;
        }
        finally {
            if (stream1 != null) {
                stream1.close();
            }
            if (stream2 != null) {
                stream2.close();
            }
            if (fl2 != null) {
                fl2.delete();
            }
            if (fl1 != null) {
                fl1.delete();
            }
            if (fDir != null) {
                fDir.delete();
            }
            fl1 = null;
            fl2 = null;
            fDir = null;
        }
    }

    private String getHTMLClr(int state) {
        switch (state) {
            case 0: {
                return "D06000";
            }
            case 1: {
                return "007200";
            }
            case 2: {
                return "0000FF";
            }
            case 4: {
                return "FF0080";
            }
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        StringBuffer bb = new StringBuffer("aa");
        StringBuffer rr = new StringBuffer("aa");
        if (bb.hashCode() == rr.hashCode()) {
            int kju = -1;
            ++kju;
        }
        String file1 = "C:\\temp\\172.28.125.84-R-L";
        String file2 = "C:\\temp\\172.28.125.83-S-L";
        File fl1 = new File(file1);
        File fl2 = new File(file2);
        FileInputStream stream1 = new FileInputStream(file1);
        FileInputStream stream2 = new FileInputStream(file2);
        long stTm = System.currentTimeMillis();
        Object[] out = new Object[]{new TextDiff().compare(file1, file2, true)};
        long endTm = System.currentTimeMillis();
        System.out.println("Diff:" + (endTm - stTm));
        System.exit(1);
    }

    public static boolean isBackUpServerConfigured() {
        try {
            String[] data = BackUpConfiguration.getBackupServerData();
            if (data == null || data[0] == null) {
                return false;
            }
            int protocol = Integer.parseInt(data[0]);
            String usrName = data[1];
            String passWord = data[2];
            String rootDir = data[3];
            if (!(protocol != 3 && protocol != 2 && protocol != 4 || usrName != null && usrName.trim().length() != 0 && passWord != null && passWord.trim().length() != 0 && rootDir != null && rootDir.trim().length() != 0)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static int getServerTypeVal() {
        String serverType = System.getProperty(SftpCredentialDO.PROTOCOL_PROP);
        if (serverType == null || !serverType.equals(Integer.toString(3)) && !serverType.equals(Integer.toString(1))) {
            serverType = Integer.toString(3);
        }
        return Integer.parseInt(serverType);
    }

    public static String[] getBackupServerData() throws Exception {
        String homeDir = System.getProperty(SftpCredentialDO.HOMEDIR_PROP);
        String usrName = System.getProperty(SftpCredentialDO.USERNAME_PROP);
        String passwd = System.getProperty(SftpCredentialDO.PASSWORD_PROP);
        String serverType = System.getProperty(SftpCredentialDO.PROTOCOL_PROP);
        if (serverType == null || !serverType.equals(Integer.toString(3)) && !serverType.equals(Integer.toString(1))) {
            serverType = Integer.toString(3);
        }
        passwd = passwd.startsWith("#") ? JBoss_4_2Encrypter.decrypt(passwd.substring(1)) : null;
        String currentOs = System.getProperty("os.name").toUpperCase();
        String isWinOS = "true";
        if (!currentOs.contains("WINDOW")) {
            isWinOS = "false";
        }
        return new String[]{serverType, usrName, passwd, homeDir, isWinOS};
    }

    public int clearSSHHostKeys(Object[] param) {
        int hostkeycleared = 0;
        ArrayList<String> failedSws = new ArrayList<String>();
        String[] fDbIdSwDBidIsLanIP = (String[])param[17];
        if (fDbIdSwDBidIsLanIP != null) {
            for (int i = 0; i < fDbIdSwDBidIsLanIP.length && this.canContinue(); ++i) {
                String fstSw = fDbIdSwDBidIsLanIP[i];
                StringTokenizer token = new StringTokenizer(fstSw, ",");
                if (token != null) {
                    String swIp = "";
                    try {
                        long fDBIDOrSwID = Long.parseLong(token.nextToken().trim());
                        long SwDBID = Long.parseLong(token.nextToken().trim());
                        boolean isLan = Boolean.parseBoolean(token.nextToken().trim());
                        swIp = token.nextToken().trim();
                        WebAnalysisRif webImpl = WebAnalysisImpl.getRemoteWebAnalysisRif(fDBIDOrSwID, isLan);
                        boolean success = webImpl.clearSSHHosts(swIp);
                        if (success) {
                            ++hostkeycleared;
                            BackUpConfiguration.logTrace(swIp + ":" + "Cleared SSH Host Key");
                        } else {
                            BackUpConfiguration.logTrace(swIp + ":" + "*** Failed to Clear SSH Host Key");
                            failedSws.add(swIp);
                        }
                    }
                    catch (Exception ex) {
                        failedSws.add(swIp);
                        BackUpConfiguration.logTrace(swIp + ":" + "*** Failed to Clear SSH Host Key");
                        BackUpConfiguration.logTrace(swIp + ":" + ex.getMessage());
                    }
                }
                this.setStatus("Clear SSH Key tried on " + (i + 1) + " out of " + fDbIdSwDBidIsLanIP.length + " switches ");
                this.setPercentCompleted((i + 1) * 100 / fDbIdSwDBidIsLanIP.length);
            }
        }
        return hostkeycleared;
    }

    public int verifySSHServer(Object[] param) {
        int verifiedSws = 0;
        ArrayList<String> failedSws = new ArrayList<String>();
        String[] fDbIdSwDBidIsLanIP = (String[])param[17];
        if (fDbIdSwDBidIsLanIP != null) {
            for (int i = 0; i < fDbIdSwDBidIsLanIP.length && this.canContinue(); ++i) {
                String fstSw = fDbIdSwDBidIsLanIP[i];
                StringTokenizer token = new StringTokenizer(fstSw, ",");
                if (token != null) {
                    String swIp = "";
                    try {
                        long fDBIDOrSwID = Long.parseLong(token.nextToken().trim());
                        long SwDBID = Long.parseLong(token.nextToken().trim());
                        String boolStr = token.nextToken().trim();
                        boolean isLan = Boolean.parseBoolean(boolStr);
                        swIp = token.nextToken().trim();
                        WebAnalysisRif webImpl = WebAnalysisImpl.getRemoteWebAnalysisRif(fDBIDOrSwID, isLan);
                        String usrName = (String)param[6];
                        String passWord = (String)param[7];
                        String rootDir = (String)param[8];
                        int serverType = (Integer)param[5];
                        String fl2 = null;
                        fl2 = isLan ? webImpl.backUpLanSwitch(swIp, -1, serverType, usrName, passWord, rootDir, false) : webImpl.backUpSanSwitch(swIp, -1, serverType, usrName, passWord, rootDir, false);
                        if (fl2 == null) {
                            _Logger.info((Object)("\nFailed to back up file from '" + swIp + "': " + "Please see web reports logs"));
                            throw new RemoteException("\nFailed to back up file from '" + swIp + "': " + "Please see web reports logs");
                        }
                        ++verifiedSws;
                        BackUpConfiguration.logTrace(swIp + ":" + "Verification of credentials successful with Switch ");
                    }
                    catch (Exception ex) {
                        failedSws.add(swIp);
                        BackUpConfiguration.logTrace(swIp + ":" + "*** Failed Verification of credentials ");
                        BackUpConfiguration.logTrace(swIp + ":" + ex.getMessage());
                    }
                }
                this.setStatus("Verification tested on " + (i + 1) + " out of " + fDbIdSwDBidIsLanIP.length + " switches ");
                this.setPercentCompleted((i + 1) * 100 / fDbIdSwDBidIsLanIP.length);
            }
        }
        if (failedSws.size() > 0) {
            BackUpConfiguration.logTrace("Verification failed for " + failedSws + " switches.");
        }
        return verifiedSws;
    }

    public boolean clearSSHHosts(String swName) throws Exception {
        StringBuffer output = new StringBuffer();
        SnmpPeer swPeer = null;
        SwitchImpl swI = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swName));
        if (swI == null) {
            BackUpConfiguration.logTrace("Switch " + swName + " not found in SAN network.");
            EthSwitchImpl swIEth = DCManager.getInstance().findEthSwitchBySwIp(InetAddress.getByName(swName));
            if (swIEth == null) {
                BackUpConfiguration.logTrace("Switch " + swName + " not found in LAN network.");
                return false;
            }
            swPeer = swIEth.getPeer();
            BackUpConfiguration.logTrace("Switch " + swName + " found in LAN network.");
        } else {
            swPeer = swI.getPeer();
        }
        if (swPeer == null) {
            BackUpConfiguration.logTrace("Could not find SNMP Peer for Switch " + swName);
            return false;
        }
        VshBase vsh = this.getVshConnection(swPeer, output);
        if (vsh == null) {
            BackUpConfiguration.logTrace("Unable to open connection to Switch " + swName);
            return false;
        }
        vsh.clearSSHHosts();
        vsh.disconnect();
        return true;
    }

    public boolean saveModifiedConfigToDB(String configFileName, String fileContent) throws Exception {
        boolean saved = false;
        if (configFileName == null || configFileName.trim().length() == 0) {
            throw new Exception("Invalid file Name");
        }
        String rootDir = System.getProperty(SftpCredentialDO.HOMEDIR_PROP);
        String usrName = System.getProperty(SftpCredentialDO.USERNAME_PROP);
        String passwd = System.getProperty(SftpCredentialDO.PASSWORD_PROP);
        String prepender = rootDir == null ? "" : rootDir;
        String modFileName = configFileName;
        if (modFileName.trim().length() == 0) {
            throw new Exception("Invalid file Name");
        }
        BufferedWriter bwr = null;
        File backedFile = null;
        try {
            backedFile = new File(prepender + File.separator + configFileName);
            FileOutputStream fo = new FileOutputStream(backedFile);
            OutputStreamWriter wr = new OutputStreamWriter(fo);
            bwr = new BufferedWriter(wr);
            bwr.write(fileContent);
            bwr.flush();
            bwr.close();
            saved = true;
            this.moveToDB(backedFile);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bwr != null) {
                bwr.close();
            }
            if (backedFile != null) {
                backedFile.delete();
                backedFile = null;
            }
        }
        return saved;
    }

    public boolean testIfFileNameExistsInDB(String configFileName) throws Exception {
        ArrayList filesInfo;
        if (configFileName == null || configFileName.trim().length() == 0) {
            throw new Exception("Please specify file name.");
        }
        Object[] data = this.getConfigsFromDB(null, true);
        if (data != null && (filesInfo = (ArrayList)data[3]) != null) {
            for (int k = 0; k < filesInfo.size(); ++k) {
                ConfigFileInfoDO fldo = (ConfigFileInfoDO)filesInfo.get(k);
                if (fldo.getConfigFiles() == null || !fldo.getConfigFiles().equals(configFileName)) continue;
                return true;
            }
        }
        return false;
    }

    private String getTimeStrippedFileName(String configFileName) {
        StringTokenizer token = new StringTokenizer(configFileName, "-");
        String modFileName = "";
        int count = -1;
        block3: while (token.hasMoreTokens()) {
            switch (++count) {
                case 1: 
                case 2: {
                    token.nextToken();
                    continue block3;
                }
            }
            modFileName = modFileName + token.nextToken();
        }
        return modFileName;
    }

    class BackUpConfigGenerator
    extends ReportAnalysis.RunReportThread {
        Object[] param;
        int reportType;

        public BackUpConfigGenerator(Object[] prm, boolean asynchronous, int reportType) {
            super(asynchronous);
            this.param = prm;
            this.reportType = reportType;
        }

        @Override
        protected BaseAnalysisReport doAction() throws Exception {
            InputStream stream1 = null;
            InputStream stream2 = null;
            File fl1 = null;
            File fl2 = null;
            File fDir = null;
            try {
                if (this.reportType == 16) {
                    String configFileName = (String)this.param[0];
                    String[] files = BackUpConfiguration.this.readConfigFile(configFileName);
                    BaseAnalysisReport znRpt = new BaseAnalysisReport(-1, "", 16);
                    BackUpConfiguration.this.setReportData(znRpt);
                    ArrayList<String> dataLst = new ArrayList<String>();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            dataLst.add(files[i]);
                        }
                    }
                    znRpt.setReportData(dataLst);
                    BaseAnalysisReport i = znRpt;
                    return i;
                }
                if (this.reportType == 14) {
                    ArrayList<String> dataLst = new ArrayList<String>();
                    String[] swVerList = (String[])this.param[17];
                    int swtoVerify = swVerList != null ? swVerList.length : 0;
                    int verifiedSws = BackUpConfiguration.this.verifySSHServer(this.param);
                    String out = this.param != null ? (verifiedSws > 0 ? "Verified Server Credentials for " + verifiedSws + " switches out of " + swtoVerify : "Failed to Verify Server Credentials on selected switch(es)") : "No switches available to run Verification";
                    dataLst.add(out);
                    BaseAnalysisReport znRpt2 = new BaseAnalysisReport(-1, "", 14);
                    BackUpConfiguration.this.setReportData(znRpt2);
                    znRpt2.setReportData(dataLst);
                    if (verifiedSws == 0) {
                        BackUpConfiguration.this.errorInProcessing = true;
                    }
                    BaseAnalysisReport baseAnalysisReport = znRpt2;
                    return baseAnalysisReport;
                }
                if (this.reportType == 17) {
                    int hostkeycleared = BackUpConfiguration.this.clearSSHHostKeys(this.param);
                    String[] swVerList = (String[])this.param[17];
                    ArrayList<String> data = new ArrayList<String>();
                    String out = this.param != null ? "Cleared SSH Host keys for " + hostkeycleared + " switches out of " + swVerList.length : "No switches available to run Clear Hosts";
                    data.add(out);
                    BaseAnalysisReport znRpt = new BaseAnalysisReport(-1, "", 14);
                    BackUpConfiguration.this.setReportData(znRpt);
                    znRpt.setReportData(data);
                    if (hostkeycleared != swVerList.length) {
                        BackUpConfiguration.this.errorInProcessing = true;
                    }
                    BaseAnalysisReport znRpt2 = znRpt;
                    return znRpt2;
                }
                String file1 = (String)this.param[0];
                String file2 = (String)this.param[14];
                boolean isLan = (Boolean)this.param[15];
                long swDbId = (Long)this.param[16];
                int serverType = (Integer)this.param[5];
                int configType = (Integer)this.param[4];
                if (configType == 1) {
                    ArrayList<Object> dataLst = new ArrayList<Object>();
                    long stTm = System.currentTimeMillis();
                    Object[] diffData = BackUpConfiguration.this.compareconfigFiles(file1, file2);
                    long enTm = System.currentTimeMillis();
                    _Logger.info((Object)("Time Reqd for compare files:" + (enTm - stTm)));
                    ConfigComparisonResultDO outdata = new ConfigComparisonResultDO();
                    if (diffData != null) {
                        for (int i = 0; i < diffData.length; ++i) {
                            dataLst.add(diffData[i]);
                        }
                    }
                    BaseAnalysisReport znRpt = new BaseAnalysisReport(-1, "", 12);
                    BackUpConfiguration.this.setReportData(znRpt);
                    znRpt.setReportData(dataLst);
                    BaseAnalysisReport baseAnalysisReport = znRpt;
                    return baseAnalysisReport;
                }
                String[] category = (String[])this.param[1];
                boolean configTypeDiff = (Boolean)this.param[2];
                String swName = (String)this.param[3];
                if (serverType == 3 && !BackUpConfiguration.isBackUpServerConfigured()) {
                    throw new Exception(BackUpConfiguration.CONFIGURE_BACKUP_SERVER);
                }
                String[] data = BackUpConfiguration.getBackupServerData();
                int protocol = Integer.parseInt(data[0]);
                String usrName = data[1];
                String passWord = data[2];
                String rootDir = data[3];
                boolean moveToDB = (Boolean)this.param[9];
                String config1Key = (String)this.param[10];
                String prefix = (String)this.param[11];
                String command = (String)this.param[12];
                int fabricPkId = (Integer)this.param[13];
                if (prefix == null || prefix.length() == 0) {
                    String subDir = new SimpleDateFormat("yyMMdd-HHmmss").format(new Date());
                    prefix = ClientCache.getReportsDir() + File.separator + "backup" + File.separator + subDir + File.separator;
                }
                fDir = BackUpConfiguration.this.createBackupDir(prefix);
                fl1 = new File(prefix + file1);
                BackUpConfiguration.this.setStatus("Reading " + file1 + " from database ");
                BackUpConfiguration.this.readFromDB(config1Key, fl1);
                stream1 = new FileInputStream(prefix + file1);
                ArrayList dataLst = new ArrayList();
                if (command.equals("1")) {
                    BackUpConfiguration.this.setStatus("Fetching configuration from switch " + swName);
                    fl2 = BackUpConfiguration.this.backUpSwitch(swName, configType, protocol, usrName, passWord, rootDir, moveToDB);
                    if (fl2 == null) {
                        throw new RemoteException("Failed to back up file from switch " + swName + "\n" + "Please see Web Reports Logs");
                    }
                    stream2 = new FileInputStream(fl2.getAbsolutePath());
                    Object[] diffData = new Object[]{new TextDiff().compare(fl1.getAbsolutePath(), fl2.getAbsolutePath(), true)};
                    if (diffData != null) {
                        for (int i = 0; i < diffData.length; ++i) {
                            dataLst.add(diffData[i]);
                        }
                    }
                } else if (command.equals("3")) {
                    BackUpConfiguration.this.setStatus("Copying " + file1 + " configuration to switch " + swName);
                    dataLst = BackUpConfiguration.this.restoreConfigToSwitch(swName, protocol, usrName, passWord, file1, rootDir, Integer.toString(configType), isLan);
                }
                BaseAnalysisReport znRpt = new BaseAnalysisReport(-1, "", 12);
                BackUpConfiguration.this.setReportData(znRpt);
                znRpt.setReportData(dataLst);
                BaseAnalysisReport baseAnalysisReport = znRpt;
                return baseAnalysisReport;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (stream1 != null) {
                    stream1.close();
                }
                if (stream2 != null) {
                    stream2.close();
                }
                if (fl2 != null) {
                    fl2.delete();
                }
                if (fl1 != null) {
                    fl1.delete();
                }
                if (fDir != null) {
                    fDir.delete();
                }
                fl1 = null;
                fl2 = null;
                fDir = null;
            }
        }
    }
}

