/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ClusterMapping {
    static final String queryLOGICSQL = "select F_ID from LOGICSVR_FABRIC where LSVR_ID=?";
    static final String queryLOGICSQL2 = "select LSVR_ID from LOGICSVR_FABRIC where F_ID=?";
    static final String updateLOGICSQL = "update LOGICSVR_FABRIC set LSVR_ID=? where F_ID=?";
    static final String updateLOGICSQL2 = "update LOGICSVR_FABRIC set F_ID=? where LSVR_ID=? and F_ID=?";
    static final String insertLOGICSQL = "insert into LOGICSVR_FABRIC(LSVR_ID, F_ID) values(?, ?)";
    static final String deleteLOGICSQL = "delete from LOGICSVR_FABRIC where LSVR_ID=? and F_ID=?";
    static final String deleteLOGICSQL2 = "delete from LOGICSVR_FABRIC where F_ID=?";
    static final String queryPHYSICALSQL = "select LSVR_ID from PHYSICAL_LOGICSVR where IP_ADDR=?";
    static final String queryPHYSICALSQL2 = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID=?";
    static final String queryPHYSICALLOC = "select LOCATION from PHYSICAL_LOGICSVR where IP_ADDR=?";
    static final String queryPHYSICALSTATUS = "select STATUS from PHYSICAL_LOGICSVR where IP_ADDR=?";
    static final String queryNextPHYSQL = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID = (select min(LSVR_ID) from PHYSICAL_LOGICSVR where LSVR_ID > ? and status <> ?)";
    static final String queryNextSIDSQL = "select LSVR_ID from PHYSICAL_LOGICSVR where LSVR_ID = (select min(LSVR_ID) from PHYSICAL_LOGICSVR where LSVR_ID > ? and status = ?)";
    static final String queryMinLIVEPHYSQL = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID = (select min(LSVR_ID) from PHYSICAL_LOGICSVR where LSVR_ID < ? and status <> ?)";
    static final String queryMinSIDSQL = "select LSVR_ID from PHYSICAL_LOGICSVR where LSVR_ID = (select min(LSVR_ID) from PHYSICAL_LOGICSVR where LSVR_ID < ? and status = ?)";
    static final String queryPHYSICALSQL3 = "select IP_ADDR from PHYSICAL_LOGICSVR";
    static final String queryPHYSICALSQL4 = "select LSVR_ID from PHYSICAL_LOGICSVR";
    static final String queryPHYSICALSQL5 = "select IP_ADDR, status, location from PHYSICAL_LOGICSVR";
    static final String updatePHYSICALSQL = "update PHYSICAL_LOGICSVR set IP_ADDR=? where LSVR_ID=?";
    static final String updatePHYSICALSQL2 = "update PHYSICAL_LOGICSVR set LSVR_ID=? where IP_ADDR=?";
    static final String updatePHYSICALSQL3 = "update PHYSICAL_LOGICSVR set LAST_SCAN_TIME=? where LSVR_ID=?";
    static final String updatePHYSICALSQL4 = "update PHYSICAL_LOGICSVR set IP_ADDR=? where IP_ADDR=?";
    static final String updatePHYSUCALSTAT = "update PHYSICAL_LOGICSVR set status=? where IP_ADDR=?";
    static final String updatePHYSUCALSTAT2 = "update PHYSICAL_LOGICSVR set status=? where LSVR_ID=?";
    static final String updatePHYSUCALLOCATION = "update PHYSICAL_LOGICSVR set location=? where LSVR_ID=?";
    static final String insertPHYSICALSQL = "insert into PHYSICAL_LOGICSVR(IP_ADDR, LSVR_ID) values(?, ?)";
    static final String deletePHYSICALSQL = "delete from PHYSICAL_LOGICSVR where IP_ADDR=? and LSVR_ID=?";
    static final String deletePHYSICALSQL2 = "delete from PHYSICAL_LOGICSVR where LSVR_ID=?";
    static final String deletePHYSICALSQL3 = "delete from PHYSICAL_LOGICSVR where IP_ADDR=?";
    static final String queryFIDSFROMIPSQL = "select f_id from LOGICSVR_FABRIC l, PHYSICAL_LOGICSVR p where l.lsvr_id = p.lsvr_id and ip_addr=?";
    static final String queryPHYSFROMFID = "select distinct IP_ADDR from LOGICSVR_FABRIC l, PHYSICAL_LOGICSVR p where l.LSVR_ID=p.LSVR_ID and l.F_ID = ?";
    static final String queryPHYSFROMFDBID = "select distinct IP_ADDR from LOGICSVR_FABRIC l, PHYSICAL_LOGICSVR p, Fabric f where l.LSVR_ID=p.LSVR_ID and l.F_ID = f.fid and f.id=?";
    static final String queryIPsBetween = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID > ? and LSVR_ID < ? and (status = ? or status = ?)";
    static final String queryIPsGreater = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID > ? and (status = ? or status = ?)";
    static final String queryIPsLess = "select IP_ADDR from PHYSICAL_LOGICSVR where LSVR_ID < ? and (status = ? or status = ?)";
    private static ClusterMapping _instance = new ClusterMapping();
    public static Logger _Logger = LogManager.getLogger((String)"fms.ClusterMapping");

    private ClusterMapping() {
    }

    public static ClusterMapping getInstance() {
        return _instance;
    }

    public List<Integer> qFIdsFromSId(int serverId) throws SQLException {
        ArrayList<Integer> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryLOGICSQL);
            stat.setInt(1, serverId);
            rs = stat.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public List<Integer> qFIdsFromIP(InetAddress ip_addr) throws SQLException {
        ArrayList<Integer> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            if (ip_addr == null) {
                ArrayList<Integer> arrayList2 = result;
                return arrayList2;
            }
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryFIDSFROMIPSQL);
            stat.setBytes(1, ip_addr.getAddress());
            rs = stat.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            arrayList = result;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.warn((Object)ex.getMessage());
            throw ex;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public List<Integer> qSIdsFromFId(int fid) throws SQLException {
        ArrayList<Integer> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryLOGICSQL2);
            stat.setInt(1, fid);
            rs = stat.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public int qSIdFromIP(InetAddress ip_addr) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        ResultSet rs = null;
        try {
            if (ip_addr == null) {
                int n2 = result;
                return n2;
            }
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALSQL);
            stat.setBytes(1, ip_addr.getAddress());
            rs = stat.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1);
            }
            n = result;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.warn((Object)ex.getMessage());
            throw ex;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public InetAddress qIPFromSId(int lsvrId) throws SQLException, UnknownHostException {
        InetAddress inetAddress;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        InetAddress result = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALSQL2);
            stat.setInt(1, lsvrId);
            rs = stat.executeQuery();
            while (rs.next()) {
                result = InetAddress.getByAddress(rs.getBytes(1));
            }
            inetAddress = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return inetAddress;
    }

    public String getLocation(InetAddress ip_addr) throws SQLException, UnknownHostException {
        String string;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        String result = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALLOC);
            stat.setBytes(1, ip_addr.getAddress());
            rs = stat.executeQuery();
            while (rs.next()) {
                result = rs.getString(1);
            }
            string = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return string;
    }

    public int getStatus(InetAddress ip_addr) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        int result = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALSTATUS);
            stat.setBytes(1, ip_addr.getAddress());
            rs = stat.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1);
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public InetAddress qNextIPFromSId(int lsvrId, int exclude) throws SQLException, UnknownHostException {
        InetAddress inetAddress;
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        InetAddress result = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryNextPHYSQL);
            stat.setInt(1, lsvrId);
            stat.setInt(2, exclude);
            rs = stat.executeQuery();
            if (rs.next()) {
                result = InetAddress.getByAddress(rs.getBytes(1));
            } else {
                stat2 = con.prepareStatement(queryMinLIVEPHYSQL);
                stat2.setInt(1, lsvrId);
                stat2.setInt(2, exclude);
                rs2 = stat2.executeQuery();
                if (rs2.next()) {
                    result = InetAddress.getByAddress(rs2.getBytes(1));
                }
            }
            inetAddress = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(rs2);
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(rs2);
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return inetAddress;
    }

    public int qNextSIdFromSId(int lsvrId, int status) throws SQLException, UnknownHostException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        int result = -1;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryNextSIDSQL);
            stat.setInt(1, lsvrId);
            stat.setInt(2, status);
            rs = stat.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            } else {
                stat2 = con.prepareStatement(queryMinSIDSQL);
                stat2.setInt(1, lsvrId);
                stat2.setInt(2, status);
                rs2 = stat2.executeQuery();
                if (rs2.next()) {
                    result = rs2.getInt(1);
                }
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(rs2);
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(rs2);
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InetAddress> qUncompletedIPs(int sid) throws SQLException, UnknownHostException {
        ArrayList<InetAddress> arrayList;
        ArrayList<InetAddress> sids = new ArrayList<InetAddress>();
        int nextSid = -1;
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            nextSid = this.qNextSIdFromSId(sid, 0);
            if (nextSid > sid) {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(queryIPsBetween);
                stat.setInt(1, sid);
                stat.setInt(2, nextSid);
                stat.setInt(3, 1);
                stat.setInt(4, 3);
                rs = stat.executeQuery();
                if (rs.next()) {
                    sids.add(InetAddress.getByAddress(rs.getBytes(1)));
                }
            } else if (nextSid < sid) {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(queryIPsGreater);
                stat.setInt(1, sid);
                stat.setInt(2, 1);
                stat.setInt(3, 3);
                rs = stat.executeQuery();
                while (rs.next()) {
                    sids.add(InetAddress.getByAddress(rs.getBytes(1)));
                }
                if (nextSid == -1) {
                    nextSid = sid;
                }
                stat2 = con.prepareStatement(queryIPsLess);
                stat2.setInt(1, nextSid);
                stat2.setInt(2, 1);
                stat2.setInt(3, 3);
                rs2 = stat2.executeQuery();
                while (rs2.next()) {
                    sids.add(InetAddress.getByAddress(rs2.getBytes(1)));
                }
            }
            arrayList = sids;
        }
        catch (UnknownHostException e) {
            try {
                _Logger.warn((Object)e.getMessage());
                throw e;
                catch (SQLException ex) {
                    _Logger.warn((Object)ex.getMessage());
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(rs2);
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(rs2);
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return arrayList;
    }

    public int updateSIdL(int sId_new, int fid) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        int rowAffected = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updateLOGICSQL);
            stat.setInt(1, sId_new);
            stat.setInt(2, fid);
            rowAffected = stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return rowAffected;
    }

    public void updateFId(int sId, int fid_orig, int fid_new) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updateLOGICSQL2);
            stat.setInt(1, fid_new);
            stat.setInt(2, sId);
            stat.setInt(3, fid_orig);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public int updateIPAddr(int serverId, InetAddress ip_addr_new) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int rowAffected = 0;
        if (ip_addr_new == null) {
            return rowAffected;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSICALSQL);
            stat.setBytes(1, ip_addr_new.getAddress());
            stat.setInt(2, serverId);
            n = rowAffected = stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public void updateSIdP(InetAddress ip_addr, int serverId_new) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        if (ip_addr == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSICALSQL2);
            stat.setInt(1, serverId_new);
            stat.setBytes(2, ip_addr.getAddress());
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void updateScanTime(int serverId) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSICALSQL3);
            stat.setLong(1, System.currentTimeMillis());
            stat.setInt(2, serverId);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public int updateStatus(int serverId, int status) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSUCALSTAT2);
            stat.setInt(1, status);
            stat.setInt(2, serverId);
            n = result = stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public int updateStatus(InetAddress serverIP, int status) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSUCALSTAT);
            stat.setInt(1, status);
            stat.setBytes(2, serverIP.getAddress());
            result = stat.executeUpdate();
            if (result > 0) {
                result = status;
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public int updateLocation(int serverId, String location) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(updatePHYSUCALLOCATION);
            stat.setString(1, location);
            stat.setInt(2, serverId);
            n = result = stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public void persistLOGIC(int serverId, int fid) throws SQLException {
        PreparedStatement stat;
        Connection con;
        block5: {
            con = null;
            stat = null;
            if (this.updateSIdL(serverId, fid) <= 0) break block5;
            DbUtil.close(stat);
            DbUtil.close(con);
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(insertLOGICSQL);
            stat.setInt(1, serverId);
            stat.setInt(2, fid);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void insertPHYSICAL(InetAddress ip_addr, int serverId) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        if (ip_addr == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(insertPHYSICALSQL);
            stat.setBytes(1, ip_addr.getAddress());
            stat.setInt(2, serverId);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void persitPHYSICAL(InetAddress ip_addr, int serverId) throws SQLException {
        PreparedStatement stat;
        Connection con;
        block6: {
            con = null;
            stat = null;
            if (ip_addr == null) {
                return;
            }
            if (this.updateIPAddr(serverId, ip_addr) <= 0) break block6;
            DbUtil.close(stat);
            DbUtil.close(con);
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(insertPHYSICALSQL);
            stat.setBytes(1, ip_addr.getAddress());
            stat.setInt(2, serverId);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void deleteLOGIC(int serverId, int fid) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(deleteLOGICSQL);
            stat.setInt(1, serverId);
            stat.setInt(2, fid);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void purgeLOGIC(int fid, Connection con) throws SQLException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(deleteLOGICSQL2);
            stat.setInt(1, fid);
            stat.execute();
        }
        catch (SQLException ex) {
            _Logger.warn((Object)ex.getMessage());
            throw ex;
        }
        finally {
            DbUtil.close(stat);
        }
    }

    public void deletePHYSICAL(InetAddress ip_addr, int serverId) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        if (ip_addr == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(deletePHYSICALSQL);
            stat.setBytes(1, ip_addr.getAddress());
            stat.setInt(2, serverId);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void deletePHYSICAL(int serverId) throws Exception {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            List<Integer> fids = this.qFIdsFromSId(serverId);
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int fid : fids) {
                InventoryPersistentManager.getInstance();
                InventoryPersistentManager.purgeFabric(null, FabricImpl.findDbIdByFPK(fid));
            }
            stat = con.prepareStatement(deletePHYSICALSQL2);
            stat.setInt(1, serverId);
            stat.executeUpdate();
            con.commit();
        }
        catch (Exception ex) {
            try {
                if (con != null) {
                    con.rollback();
                }
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> qALlIPStrings() throws SQLException, UnknownHostException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        String ip = null;
        String localIp = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALSQL3);
            rs = stat.executeQuery();
            while (rs.next()) {
                ip = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
                if (localIp == null && NetUtil.isLocalHost(ip)) {
                    localIp = ip;
                    continue;
                }
                result.add(ip);
            }
            if (localIp != null) {
                result.add(0, localIp);
            }
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<String>> qAllInfo() throws SQLException, UnknownHostException {
        ArrayList<List<String>> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        ArrayList<String> row = null;
        ResultSet rs = null;
        String ip = null;
        String status = null;
        String location = null;
        String localIp = null;
        ArrayList<String> localrow = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSICALSQL5);
            rs = stat.executeQuery();
            while (rs.next()) {
                ip = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
                status = rs.getString(2);
                location = rs.getString(3);
                if (localIp == null && NetUtil.isLocalHost(ip)) {
                    localIp = ip;
                    localrow = new ArrayList<String>();
                    localrow.add(localIp);
                    localrow.add(status);
                    localrow.add(location);
                    continue;
                }
                row = new ArrayList<String>();
                row.add(ip);
                row.add(status);
                row.add(location);
                results.add(row);
            }
            if (localIp != null) {
                results.add(0, localrow);
            }
            arrayList = results;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public HashSet<Integer> qActiveSIDs() throws SQLException, UnknownHostException {
        HashSet<Integer> hashSet;
        Connection con = null;
        PreparedStatement stat = null;
        HashSet<Integer> result = new HashSet<Integer>();
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String query = "select LSVR_ID from PHYSICAL_LOGICSVR where status = ? or status = ?";
            stat = con.prepareStatement(query);
            stat.setInt(1, 0);
            stat.setInt(2, 3);
            rs = stat.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            hashSet = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return hashSet;
    }

    public HashMap<Integer, Boolean> qALlActiveSIDs(long scanInterval) throws SQLException, UnknownHostException {
        HashMap<Integer, Boolean> hashMap;
        Connection con = null;
        PreparedStatement stat = null;
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>();
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String query = "select LSVR_ID from PHYSICAL_LOGICSVR where LAST_SCAN_TIME + " + scanInterval + " > " + System.currentTimeMillis();
            stat = con.prepareStatement(query);
            rs = stat.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt(1), true);
            }
            hashMap = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return hashMap;
    }

    public boolean qActiveSID(long scanInterval, int sid) throws SQLException, UnknownHostException {
        boolean bl;
        Connection con = null;
        PreparedStatement stat = null;
        HashMap result = new HashMap();
        ResultSet rs = null;
        boolean rtn = false;
        try {
            con = ConnectionManager.getConnection();
            String query = "select LSVR_ID from PHYSICAL_LOGICSVR where LSVR_ID=? and LAST_SCAN_TIME + " + scanInterval + " > " + System.currentTimeMillis();
            stat = con.prepareStatement(query);
            stat.setInt(1, sid);
            rs = stat.executeQuery();
            if (rs.next()) {
                rtn = true;
            }
            bl = rtn;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    public boolean qActiveIP(long scanInterval, InetAddress ip) throws SQLException, UnknownHostException {
        boolean bl;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList result = new ArrayList();
        ResultSet rs = null;
        boolean rtn = false;
        try {
            if (ip == null) {
                boolean bl2 = rtn;
                return bl2;
            }
            con = ConnectionManager.getConnection();
            String query = "select IP_ADDR from PHYSICAL_LOGICSVR where IP_ADDR=?  and  LAST_SCAN_TIME + " + scanInterval + " > " + System.currentTimeMillis();
            stat = con.prepareStatement(query);
            stat.setBytes(1, ip.getAddress());
            rs = stat.executeQuery();
            if (rs.next()) {
                rtn = true;
            }
            bl = rtn;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.warn((Object)ex.getMessage());
            throw ex;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> qActiveIPs() throws SQLException, UnknownHostException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        String ip = null;
        String localIp = null;
        try {
            con = ConnectionManager.getConnection();
            String query = "select IP_ADDR from PHYSICAL_LOGICSVR where status = ? or status = ?";
            stat = con.prepareStatement(query);
            stat.setInt(1, 0);
            stat.setInt(2, 3);
            rs = stat.executeQuery();
            while (rs.next()) {
                ip = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
                if (localIp == null && NetUtil.isLocalHost(ip)) {
                    localIp = ip;
                    continue;
                }
                result.add(ip);
            }
            if (localIp != null) {
                result.add(0, localIp);
            }
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> qALlActiveIPs(long scanInterval) throws SQLException, UnknownHostException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        String ip = null;
        String localIp = null;
        try {
            con = ConnectionManager.getConnection();
            String query = "select IP_ADDR from PHYSICAL_LOGICSVR where LAST_SCAN_TIME + " + scanInterval + " > " + System.currentTimeMillis();
            stat = con.prepareStatement(query);
            rs = stat.executeQuery();
            while (rs.next()) {
                ip = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
                if (localIp == null && NetUtil.isLocalHost(ip)) {
                    localIp = ip;
                    continue;
                }
                result.add(ip);
            }
            if (localIp != null) {
                result.add(0, localIp);
            }
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String qIPStrfromFDBID(long fDBid) throws SQLException, UnknownHostException {
        String string;
        Connection con = null;
        PreparedStatement stat = null;
        String result = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSFROMFDBID);
            stat.setLong(1, fDBid);
            rs = stat.executeQuery();
            while (rs.next()) {
                result = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
            }
            string = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String qIPStrfromFID(long f_id) throws SQLException, UnknownHostException {
        String string;
        Connection con = null;
        PreparedStatement stat = null;
        String result = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryPHYSFROMFID);
            stat.setLong(1, f_id);
            rs = stat.executeQuery();
            while (rs.next()) {
                result = InetAddress.getByAddress(rs.getBytes(1)).getHostAddress();
            }
            string = result;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
                catch (UnknownHostException ue) {
                    _Logger.warn((Object)ue.getMessage());
                    throw ue;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return string;
    }

    public void replaceServer(InetAddress old_addr, InetAddress new_addr) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat2 = null;
        if (old_addr == null || new_addr == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(deletePHYSICALSQL3);
            stat.setBytes(1, new_addr.getAddress());
            stat.executeUpdate();
            stat2 = con.prepareStatement(updatePHYSICALSQL4);
            stat2.setBytes(1, new_addr.getAddress());
            stat2.setBytes(2, old_addr.getAddress());
            stat2.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] strArgs) {
        try {
            String configFile = ClientCache.getConfDir() + "server.properties";
            Properties properties = new Properties();
            GenUtil.loadConfiguration(configFile, properties);
            System.out.println("Server configuration file loaded: " + configFile);
            System.getProperties().putAll((Map<?, ?>)properties);
            ClusterMapping cluster = ClusterMapping.getInstance();
            if (strArgs.length == 3 && strArgs[0].equalsIgnoreCase("-p")) {
                InetAddress inetAddress = InetAddress.getByName(strArgs[1]);
                cluster.persitPHYSICAL(inetAddress, Integer.parseInt(strArgs[2]));
            } else if (strArgs.length == 3 && strArgs[0].equalsIgnoreCase("-moveserver")) {
                InetAddress old_addr = InetAddress.getByName(strArgs[1]);
                InetAddress new_addr = InetAddress.getByName(strArgs[2]);
                cluster.replaceServer(old_addr, new_addr);
            } else if (strArgs.length == 1 && strArgs[0].equalsIgnoreCase("-show")) {
                List<List<String>> rows = cluster.qAllInfo();
                for (List<String> row : rows) {
                    System.out.println("\t" + row.get(0) + ", " + cluster.qSIdFromIP(InetAddress.getByName(row.get(0))) + ", " + row.get(1) + ", " + row.get(2));
                }
            } else if (strArgs.length == 2 && strArgs[0].equalsIgnoreCase("-d")) {
                cluster.deletePHYSICAL(Integer.parseInt(strArgs[1]));
            } else {
                System.out.println("Usage: \nPLMapping(.bat|.sh) [-show|-p|-d|-moveserver] \n\t -show                         -- Show all the entries in ip address/server id mapping table\n \t -p <ip> <serverId>            -- Insert/update ip address/server id mapping \n \t -d <serverId>                 -- Delete a row for ip address/server if mapping based on server id \n \t -moveserver <oldIP> <newIP>   -- replace the exsiting server with new server, the new server need to be restarted afterwards\n ");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            System.exit(0);
        }
    }
}

