/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DBObjectIf;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistent;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.PersistentWrapperIf;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.CfsRegionImpl;
import com.cisco.dcbu.sm.server.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.server.model.ChannelMemberNpvl;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.EnclDataStoreImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.GuestNicImpl;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.StorageEnclosureImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VmDataStoreImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.sm.server.model.VmPhynicImpl;
import com.cisco.dcbu.sm.server.model.VsanDomainImpl;
import com.cisco.dcbu.sm.server.model.VsanISLImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.model.VsanNpvLinkImpl;
import com.cisco.dcbu.sm.server.model.VsanNxPortImpl;
import com.cisco.dcbu.sm.server.model.ZoneImpl;
import com.cisco.dcbu.sm.server.model.ZoneMemberImpl;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import com.cisco.dcbu.vi.model.PhyNic;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class InventoryPersistentManager {
    private static InventoryPersistentManager _Instance = null;
    static long _LastUpdateTime = 0L;
    static int _PurgeTime = 2000;
    static final String VsanEndPortCleanSQL = "delete from vsan_endport_info where vsan_endport_info.endport_id in (select vep1.endport_id from vsan_endport_info vep1, vsan v, fabric f where vep1.vsan_id = v.id and v.fabric_id = f.id and f.id=? and vep1.last_update_time < f.last_update_time) ";
    static final String VsanDomainCleanSQL = "delete from vsan_domain_info where vsan_domain_info.switch_id in (select vd1.switch_id from vsan_domain_info vd1, vsan v, fabric f where vd1.vsan_id = v.id and v.fabric_id = f.id and f.id=? and vd1.last_update_time < f.last_update_time) ";
    static final String VsanISLCleanSQL = "delete from vsan_isl_info  where vsan_isl_info.isl_id in (select vi1.isl_id from vsan_isl_info vi1, vsan v, fabric f where vi1.vsan_id = v.id and v.fabric_id = f.id and f.id=? and vi1.last_update_time < f.last_update_time) ";
    static final String VsanNpvLinkCleanSQL = "delete from vsan_npvl_info  where vsan_npvl_info.npvl_id in (select vi1.npvl_id from vsan_npvl_info vi1, vsan v, fabric f where vi1.vsan_id = v.id and v.fabric_id = f.id and f.id=? and vi1.last_update_time < f.last_update_time) ";
    static final String ISLCleanSQL = "delete from isl  where isl.id in (select isl1.id from switch_port sp, switch s, fabric f, isl isl1 where isl1.port1_id=sp.id and sp.switch_id=s.id and s.fabric_id=f.id and f.id=? AND isl1.last_update_time < f.last_update_time)";
    static final String NpvLinkCleanSQL = "delete from npv_link  where npv_link.id in (select npvLink1.id from switch s, fabric f, npv_link npvLink1 where npvLink1.core_switch_id=s.id and s.fabric_id=f.id and f.id=? AND npvLink1.last_update_time < f.last_update_time)";
    static final String ZoneMemberCleanSQL = "delete from zone_member  where zone_member.id in (select zm.id from  zone_member zm, zone z, vsan v where  zm.zone_id=z.id and  z.parent_id=v.id and v.fabric_id=? )";
    static final String ZoneMemberIVRCleanSQL = "delete from zone_member where zone_member.id in (select zm.id from zone_member zm, zone z  where zm.zone_id=z.id and   z.parent_id=? )";
    static final String ZoneCleanSQL = "delete from zone where zone.id in (select z.id from vsan v, zone z where   z.parent_id=v.id and v.fabric_id=? )";
    static final String ZoneIVRCleanSQL = "delete from zone where zone.parent_id = ? ";
    static final String FcAliasCleanSQL = "delete from fc_alias where fc_alias.id in (select fc1.id from fabric f, vsan v, fc_alias fc1 where fc1.vsan_id=v.id and v.fabric_id=f.id and f.id=? and fc1.last_update_time < f.last_update_time)";
    static final String VsanCleanSQL = "delete from vsan where vsan.id in (select v1.id from fabric f, vsan v1 where v1.fabric_id=f.id and f.id=? and v1.last_update_time < f.last_update_time )";
    static final String CfsRegionCleanSQL = "delete from cfs_region where cfs_region.id in (select r1.id from fabric f, cfs_region r1 where r1.fabric_id=f.id and f.id=? and r1.last_update_time < f.last_update_time )";
    static final String SwitchCleanSQL = "delete from switch  where switch.id in (select s1.id from fabric f, switch s1 where s1.fabric_id=f.id and f.id=? and s1.last_update_time < f.last_update_time)";
    static final String ClusterCleanSQL = "delete from base_svc_cluster where base_svc_cluster.id in (select base_svc_cluster.id from fabric f, base_svc_cluster v1 where v1.fabric_id=f.id and f.id=? and v1.last_update_time < f.last_update_time )";
    static final String VHostCleanSQL = "delete from vhost where vhost.id in (select v1.id from vcenter v, vhost v1 where v1.vcenter_id=v.id and v.id=? and v1.last_update_time < v.last_update_time)";
    static final String PhynicCleanSQL = "delete from phynic where phynic.id in (select v1.id from vcenter v, phynic v1 where v1.vcenter_id=v.id and v.id=? and v1.last_update_time < v.last_update_time )";
    static final String VirtualMachineCleanSQL = "delete from vm where vm.id in (select v1.id from vcenter v, vm v1 where v1.vcenter_id=v.id and v.id=? and v1.last_update_time < v.last_update_time )";
    static final String DataStoreCleanSQL = "delete from data_store where data_store.id in (select v1.id from vcenter v, data_store v1 where v1.vcenter_id=v.id and v.id=? and v1.last_update_time < v.last_update_time )";
    static final String VmDataStoreCleanSQL = "delete from vm_datastore_info  where vm_datastore_info.datastore_id in (select vi1.datastore_id from vm_datastore_info vi1, vm v, vcenter f where vi1.vm_id = v.id and v.vcenter_id = f.id and f.id=? and vi1.last_update_time < f.last_update_time) ";
    static final String VmPhynicCleanSQL = "delete from vm_phynic_info  where vm_phynic_info.phynic_id in (select vp.phynic_id from vm_phynic_info vp, vm v, vcenter vc where vp.vm_id = v.id and v.vcenter_id = vc.id and vc.id=? and vp.last_update_time < vc.last_update_time) ";
    static final String EncDataStoreCleanSQL = "delete from enc_datastore_info  where enc_datastore_info.datastore_id in (select ed.datastore_id from enc_datastore_info ed, data_store d, vcenter v where ed.datastore_id = d.id and d.vcenter_id = v.id and v.id=? and ed.last_update_time < v.last_update_time) ";
    static final String PurgeVSANByFabricIDSQL = "delete from vsan where fabric_id=?";
    static final String PurgeCfsRegionByFabricIDSQL = "delete from cfs_region where fabric_id=?";
    static final String PurgeLicenseByFabricIDSQL = "delete from license where switch_id in (select id from switch where fabric_id =? )";
    static final String PurgeSwitchByFabricIDSQL = "delete from switch where fabric_id=?";
    static final String PurgeEndPortByFabricIDSQL = "delete from end_port where fabric_id=?";
    static final String PurgeIvrZoneByFabricIDSQL = "delete from zone where is_ivr=true and parent_id=?";
    static final String PurgeEnfZoneByFabricIDSQL = "delete from zone where id in (select zone.id from vsan where zone.is_ivr=false and zone.parent_id=vsan.id and vsan.fabric_id=?)";
    static final String PurgeEnfZoneMemberByFabricIDSQL = "delete from zone_member where id in (select zone_member.id from zone, vsan where zone.is_ivr=false and zone_member.zone_id=zone.id and zone.parent_id=vsan.id and vsan.fabric_id=?)";
    static final String PurgeIvrZoneMemberByFabricIDSQL = "delete from zone_member where id in (select zone_member.id from zone, vsan where zone.is_ivr=true and zone_member.zone_id=zone.id and zone.parent_id=?) ";
    static final String PurgeVsanDomainInfoByFabricIDSQL = "delete from vsan_domain_info where vsan_id in (select vsan.id from vsan where vsan.fabric_id=?)";
    static final String PurgeVsanIslInfoByFabricIDSQL = "delete from vsan_isl_info where vsan_id in (select vsan.id from vsan where vsan.fabric_id=?)";
    static final String PurgeVsanNpvLinkInfoByFabricIDSQL = "delete from vsan_npvl_info where vsan_id in (select vsan.id from vsan where vsan.fabric_id=?)";
    static final String PurgeVsanEndPortInfoByFabricIDSQL = "delete from vsan_endport_info where vsan_id in (select vsan.id from vsan where vsan.fabric_id=?)";
    static final String PurgeClusterByFabricIDSQL = "delete from base_svc_cluster where fabric_id=?";
    static final String PurgeDeviceAliasByFabricIDSQL = "delete from device_alias where fabric_id=?";
    static final String PurgePortsBySwitchIDSQL = "delete from switch_port where switch_id =?";
    static final String PurgeLicensesBySwitchIDSQL = "delete from license where switch_id=?";
    static final String PurgeIslsBySwitchPortID1SQL = "delete from isl where port1_id in (select switch_port.id from switch, switch_port where switch_port.switch_id= switch.id and switch.id=?)";
    static final String PurgeNpvsBySwitchID1SQL = "delete from npv_link where core_switch_id=?";
    static final String PurgeIslsBySwitchPortID2SQL = "delete from isl where port2_id in (select switch_port.id from switch, switch_port where switch_port.switch_id= switch.id and switch.id=?)";
    static final String PurgeNpvsBySwitchID2SQL = "delete from npv_link where np_switch_id=?";
    static final String PurgeEndPortsBySwitchPortIDSQL = "delete from end_port where switch_port_id in (select switch_port.id from switch, switch_port where switch_port.switch_id= switch.id and switch.id=?)";
    static final String PurgeVsanDoaminIdsBySwitchIDSQL = "delete from vsan_domain_info where switch_id=?";
    static final String PurgeSwitchMgmtAddressBySwitchIDSQL = "delete from switch_mgmt_address where switch_id=?";
    static final String PurgeUcsBladesBySwitchIDSQL = "delete from ucs_blade where switch_id=?";
    static final String PurgeStatisticsEndPortSQL = "delete from statistics where src_id in (select statistics.src_id from end_port ep where statistics.src_id=ep.id and ep.fabric_id=?)";
    static final String PurgeStatisticsIslSQL = "delete from statistics where src_id in (select statistics.src_id from switch_port sp, switch sw where statistics.src_id=sp.id and sp.switch_id = sw.id and sw.fabric_id=?)";
    static final String PurgePmCollectionSQL = "delete from pm_collection where fabric_id=?";
    static final String PurgeUserFabricSQL = "delete from userfabric where fabric_id = ?";
    static final String PurgeSwitchPort1ByIslIDSQL = "delete from switch_port where id in (select port1_id from isl where id=?)";
    static final String PurgeSwitchPort2ByIslIDSQL = "delete from switch_port where id in (select port2_id from isl where id=?)";
    static final String PurgeVsanIslInfoByIslIDSQL = "delete from vsan_isl_info where isl_id=?";
    static final String PurgeVsanNpvlInfoByNpvlIDSQL = "delete from vsan_npvl_info where npvl_id=?";
    static final String PurgeSwitchPortByEndPortIDSQL = "delete from switch_port where id in (select switch_port_id from end_port where id=?)";
    static final String PurgeVsanEndPortInfoByEndPortIDSQL = "delete from vsan_endport_info where endport_id=?";
    static final String PurgeHbaByEnclosureIDSQL = "delete from hba where enclosure_id=?";
    static final String PurgeScsiTargetByEnclosureIDSQL = "delete from scsi_target where enclosure_id=?";
    static final String PurgeVmByVCIDSQL = "delete from vm where vcenter_id=?";
    static final String PurgeVHostByVCIDSQL = "delete from vhost where vcenter_id=?";
    static final String PurgePhynicByVCIDSQL = "delete from phynic where vcenter_id=?";
    static final String PurgeVnicByVCIDSQL = "delete from vnic where vcenter_id=?";
    static final String PurgeDataStoreByVCIDSQL = "delete from data_store where vcenter_id=?";
    static final String PurgeVmDataStoreInfoByVCIDSQL = "delete from vm_datastore_info where vm_id in (select vm.id from vm where vm.vcenter_id=?)";
    static final String PurgeVmPhynicInfoByVCIDSQL = "delete from vm_phynic_info where vm_id in (select vm.id from vm where vm.vcenter_id=?)";
    static final String PurgeEnclDataStoreInfoByVCIDSQL = "delete from enc_datastore_info where datastore_id in (select data_store.id from data_store where data_store.vcenter_id=?)";
    static final String PurgeEnclosureByVCIDSQL = "update enclosure set vhost_id = -1, is_vm_host = false where vhost_id in (select vhost.id from vhost where vhost.vcenter_id=?)";
    static final String PurgeHostMapByVCIDSQL = "delete from host_map where vhost_id in (select vhost.id from vhost where vhost.vcenter_id=?) or lanhost_id in (select lan_host.id from lan_host where lan_host.vhost_id in (select vhost.id from vhost where vhost.vcenter_id=?)) or host_id not in (select host.id from host)";
    static final String PurgeHostByVCIDSQL = "delete from host where vhost_id in (select vhost.id from vhost where vhost.vcenter_id=?)";
    static final String PurgeLanHostByVCIDSQL = "delete from lan_host where vhost_id > 0 and vhost_id in (select vhost.id from vhost where vhost.vcenter_id=?)";
    static final String QueryDeviceAliasSQLByFabricID = "select id, cfs_region_id, wwn, alias from device_Alias where fabric_id=?";
    private String _insertDeviceAliasSQL = null;
    private String _updateDeviceAliasSQL = null;
    private String _deleteDeviceAliasSQL = null;
    private String _loadDeviceAliasIdsSQL = "select id from device_alias where fabric_id=?";
    static final String QueryFcAliasSQLByVsanID = "select id, wwn, alias from fc_Alias where vsan_id=?";
    private String _insertFcAliasSQL = null;
    private String _updateFcAliasSQL = null;
    private String _deleteFcAliasSQL = null;
    private String _loadFcAliasIdsSQL = "select id from fc_alias where vsan_id=?";
    static final String QueryNpvLinksSQLByFabricID = "select id, core_switch_id, np_switch_id, f_wwn, np_wwn, oper_status_cause,speed, is_present, f_port_index, np_port_index, is_channelmember, channel_id, last_scan_time from npv_link where npv_link.id in (select npvLink1.id from switch s, fabric f, npv_link npvLink1 where npvLink1.core_switch_id=s.id and s.fabric_id=f.id and f.id=?)";
    private String _insertNpvLinkSQL = null;
    private String _updateNpvLinkSQL = null;
    private String _loadNpvLinkIdsSQL = "select npvLink1.id from switch s, fabric f, npv_link npvLink1 where npvLink1.core_switch_id=s.id and s.fabric_id=f.id and f.id=?";
    private String _deviceAliasTableName = "DEVICE_ALIAS";
    private String _fcAliasTableName = "FC_ALIAS";
    private String _npvLinkTableName = "NPV_LINK";
    private String[] _deviceAliasCols = new String[]{"ID", "FABRIC_ID", "CFS_REGION_ID", "WWN", "ALIAS", "LAST_UPDATE_TIME"};
    private String[] _fcAliasCols = new String[]{"ID", "VSAN_ID", "WWN", "ALIAS", "LAST_UPDATE_TIME"};
    private String[] _npvLinkCols = new String[]{"ID", "CORE_SWITCH_ID", "NP_SWITCH_ID", "F_PORT_INDEX", "NP_PORT_INDEX", "F_WWN", "NP_WWN", "OPER_STATUS_CAUSE", "SPEED", "IS_PRESENT", "LAST_UPDATE_TIME", "LAST_SCAN_TIME", "IS_CHANNELMEMBER", "CHANNEL_ID"};
    static Logger _Logger = LogManager.getLogger((String)"fms.db");

    private InventoryPersistentManager() {
        this._insertDeviceAliasSQL = this.getInsertSQL(this._deviceAliasTableName, this._deviceAliasCols);
        this._updateDeviceAliasSQL = this.getUpdateSQL(this._deviceAliasTableName, this._deviceAliasCols);
        this._deleteDeviceAliasSQL = this.getDeleteSQL(this._deviceAliasTableName, this._deviceAliasCols);
        this._insertFcAliasSQL = this.getInsertSQL(this._fcAliasTableName, this._fcAliasCols);
        this._updateFcAliasSQL = this.getUpdateSQL(this._fcAliasTableName, this._fcAliasCols);
        this._deleteFcAliasSQL = this.getDeleteSQL(this._fcAliasTableName, this._fcAliasCols);
        this._insertNpvLinkSQL = this.getInsertSQL(this._npvLinkTableName, this._npvLinkCols);
        this._updateNpvLinkSQL = this.getUpdateSQL(this._npvLinkTableName, this._npvLinkCols);
    }

    public static InventoryPersistentManager getInstance() {
        if (_Instance == null) {
            _Instance = new InventoryPersistentManager();
        }
        return _Instance;
    }

    public void persistDBObject(Connection con, DBObjectIf dbo) throws DBException, SQLException {
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        try {
            ps = dbo.getUpdateSql(con);
            if (ps != null) {
                ps.execute();
                int count = ps.getUpdateCount();
                if (count == 0) {
                    _Logger.log((Priority)Level.INFO, (Object)("update 0 count, insert object: " + dbo.getClass().getName()));
                    dbo.setDBID(0L);
                    ps1 = dbo.getUpdateSql(con);
                    ps1.execute();
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(ps);
            DbUtil.close(ps1);
        }
    }

    public void persistDBObject(DBObjectIf dbo) throws DBException, SQLException {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            this.persistDBObject(con, dbo);
            con.commit();
        }
        catch (SQLException sqlex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)sqlex);
            con.rollback();
            throw sqlex;
        }
        catch (DBException dbex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)dbex);
            throw dbex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void persistDBObject(FabricImpl fab, SwitchImpl[] sws) throws DBException, SQLException {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            SnmpUserImpl snmpUserImpl = new SnmpUserImpl(fab.getCredentials());
            this.persistDBObject(con, snmpUserImpl);
            fab.setUserDBID(snmpUserImpl.getDBID());
            this.persistDBObject(con, fab);
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].getWwn() == null) {
                    _Logger.debug((Object)("  skip persisting switch without wwn: " + sws[i]));
                    continue;
                }
                this.persistDBObject(con, sws[i]);
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)sqlex);
            throw sqlex;
        }
        catch (DBException dbex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persistDBObject", (Throwable)dbex);
            throw dbex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void persistSwitches(SwitchImpl[] sws) throws DBException, SQLException {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].getWwn() == null) {
                    _Logger.debug((Object)("  skip persisting switch without wwn: " + sws[i]));
                    continue;
                }
                this.persistDBObject(con, sws[i]);
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persistSwitches", (Throwable)sqlex);
            throw sqlex;
        }
        catch (DBException dbex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persistSwitches", (Throwable)dbex);
            throw dbex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void deleteDBObject(DBObjectIf dbo) throws SQLException {
        if (dbo == null || dbo.getDBID() == 0L) {
            return;
        }
        Connection con = null;
        Statement st = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = "delete from " + dbo.getDBTableName() + " where id=" + dbo.getDBID();
            st = con.createStatement();
            st.execute(sql);
        }
        catch (SQLException sqlex) {
            try {
                _Logger.log((Priority)Level.WARN, (Object)("deleteDBObject " + dbo.getDBTableName() + ":" + dbo.getDBID()), (Throwable)sqlex);
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtil.close(st);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(st);
        DbUtil.close(con);
    }

    public void persistFabrics() throws DBException, SQLException {
        this.persistEnclosures();
        FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
        if (fabrics != null) {
            for (int i = 0; i < fabrics.length; ++i) {
                this.persistFabric(fabrics[i]);
            }
        }
    }

    public void persistFabricObject(FabricImpl fImpl, Connection con, boolean updateZone) throws DBException, SQLException {
        if (updateZone) {
            List<ZoneBase> zones = fImpl.getAllIvrEnforcedZones();
            if (zones != null && zones.size() > 0) {
                ZoneImpl[] zoneImpls = new ZoneImpl[zones.size()];
                for (int i = 0; zones != null && i < zones.size(); ++i) {
                    zoneImpls[i] = new ZoneImpl(fImpl, zones.get(i));
                }
                this.persistZones(con, zoneImpls);
            }
            _Logger.debug((Object)("Persisted " + (zones == null ? 0 : zones.size()) + " IVR Zones"));
        }
        _LastUpdateTime = System.currentTimeMillis();
        fImpl.setLastUpdateTime(_LastUpdateTime);
        this.persistDBObject(con, fImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistZones(Connection con, ZoneImpl[] zones) throws SQLException {
        if (con == null || zones == null || zones.length == 0) {
            return;
        }
        int zmPersisted = 0;
        boolean ivr = zones[0].getFabric() != null;
        PreparedStatement insertZoneStat = null;
        PreparedStatement insertZoneMemberStat = null;
        try {
            insertZoneStat = con.prepareStatement(ZoneImpl.getInsertSqlStr());
            insertZoneMemberStat = con.prepareStatement(ZoneMemberImpl.getInsertSqlStr());
            for (int i = 0; i < zones.length; ++i) {
                zones[i].setDBID(Sequence.getSequence().getPK());
                zones[i].setupInsertStatement(insertZoneStat);
                insertZoneStat.addBatch();
                if (i > 100 && i % 100 == 0) {
                    insertZoneStat.executeBatch();
                }
                _Logger.trace((Object)("\tpersisting zone " + zones[i].getBaseObject().getName()));
                Array zoneMems = zones[i].getBaseObject().getMembers();
                if (zoneMems == null || zoneMems.size() == 0) continue;
                for (int j = 0; j < zoneMems.size(); ++j) {
                    ZoneMemberBase zm = (ZoneMemberBase)zoneMems.elementAt(j);
                    ZoneMemberImpl zoneMemImpl = new ZoneMemberImpl(zones[i], zm);
                    zoneMemImpl.setDBID(Sequence.getSequence().getPK());
                    zoneMemImpl.setEndPort();
                    zoneMemImpl.setFcPort();
                    zoneMemImpl.setupInsertStatement(insertZoneMemberStat);
                    insertZoneMemberStat.addBatch();
                    _Logger.trace((Object)("\tzone member" + zm.toString()));
                    ++zmPersisted;
                }
                insertZoneMemberStat.executeBatch();
            }
            insertZoneStat.executeBatch();
            _Logger.trace((Object)("Persisted " + zmPersisted + (ivr ? " IVR Zone Members " : "Zones Members ")));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertZoneStat);
            DbUtil.close(insertZoneMemberStat);
            throw throwable;
        }
        DbUtil.close(insertZoneStat);
        DbUtil.close(insertZoneMemberStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistFcAliases(Connection con, VsanImpl vsan, FcPortAlias[] fcAliases) throws DBException, SQLException {
        if (fcAliases == null || fcAliases.length == 0) {
            return;
        }
        HashSet hash = this.loadFcAliasIds(vsan, con);
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement stat = null;
        try {
            updateStat = con.prepareStatement(this._updateFcAliasSQL);
            insertStat = con.prepareStatement(this._insertFcAliasSQL);
            for (int i = 0; i < fcAliases.length; ++i) {
                int index = 1;
                long id = fcAliases[i].getDBID();
                if (hash.contains(new Long(id))) {
                    if (!fcAliases[i].isModified()) continue;
                    stat = updateStat;
                    stat.setLong(this._fcAliasCols.length, id);
                } else {
                    id = Sequence.getSequence().getPK();
                    hash.add(new Long(id));
                    fcAliases[i].setDBID(id);
                    stat = insertStat;
                    stat.setLong(index++, id);
                }
                stat.setLong(index++, vsan.getDBID());
                stat.setBytes(index++, fcAliases[i].getWwn().getValue());
                stat.setString(index++, fcAliases[i].getAlias());
                stat.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
                stat.addBatch();
                vsan.getFabric().addAlias(fcAliases[i]);
            }
            insertStat.executeBatch();
            updateStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            hash.clear();
            hash = null;
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        hash.clear();
        hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistSwitchPorts(Connection con, FcPortImpl[] switchPorts, FabricImpl fImpl) throws SQLException {
        if (con == null || switchPorts == null || switchPorts.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(FcPortImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(FcPortImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(FcPortImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < switchPorts.length; ++i) {
                if (switchPorts[i].getDBID() == 0L) {
                    switchPorts[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(switchPorts[i], checkStat);
                }
                if (switchPorts[i].getDBID() == 0L) {
                    switchPorts[i].setDBID(Sequence.getSequence().getPK());
                    switchPorts[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                } else if (switchPorts[i].getBaseObject().isModified()) {
                    switchPorts[i].setupUpdateStatement(updateStat);
                    if (updateStat.executeUpdate() < 1) {
                        switchPorts[i].setDBID(Sequence.getSequence().getPK());
                        switchPorts[i].setupInsertStatement(insertStat);
                        insertStat.addBatch();
                    }
                }
                fImpl.addSwitchPort(switchPorts[i]);
                switchPorts[i].getBaseObject().setFlushed(true);
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistDataStores(Connection con, DataStoreImpl[] dataStores, FabricImpl fImpl) throws SQLException {
        if (con == null || dataStores == null || dataStores.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(DataStoreImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(DataStoreImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(DataStoreImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < dataStores.length; ++i) {
                if (dataStores[i].getDBID() == 0L) {
                    dataStores[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(dataStores[i], checkStat);
                }
                if (dataStores[i].getDBID() == 0L) {
                    dataStores[i].setDBID(Sequence.getSequence().getPK());
                    dataStores[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                dataStores[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                dataStores[i].setDBID(Sequence.getSequence().getPK());
                dataStores[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistEnclDataStores(Connection con, EnclDataStoreImpl[] enclDataStores) throws SQLException {
        if (con == null || enclDataStores == null || enclDataStores.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(EnclDataStoreImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(EnclDataStoreImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(EnclDataStoreImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < enclDataStores.length; ++i) {
                if (enclDataStores[i].getDBID() == 0L) {
                    enclDataStores[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(enclDataStores[i], checkStat);
                }
                if (enclDataStores[i].getDBID() == 0L) {
                    enclDataStores[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                enclDataStores[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                enclDataStores[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVmDataStores(Connection con, VmDataStoreImpl[] vmDataStores) throws SQLException {
        if (con == null || vmDataStores == null || vmDataStores.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VmDataStoreImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VmDataStoreImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VmDataStoreImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vmDataStores.length; ++i) {
                if (vmDataStores[i].getDBID() == 0L) {
                    vmDataStores[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vmDataStores[i], checkStat);
                }
                if (vmDataStores[i].getDBID() == 0L) {
                    vmDataStores[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                vmDataStores[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vmDataStores[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVmPhynics(Connection con, VmPhynicImpl[] vmPhynics) throws SQLException {
        if (con == null || vmPhynics == null || vmPhynics.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VmPhynicImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VmPhynicImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VmPhynicImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vmPhynics.length; ++i) {
                if (vmPhynics[i].getDBID() == 0L) {
                    vmPhynics[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vmPhynics[i], checkStat);
                }
                if (vmPhynics[i].getDBID() == 0L) {
                    vmPhynics[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                vmPhynics[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vmPhynics[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistIsls(Connection con, IslImpl[] isls, FabricImpl fImpl) throws SQLException {
        if (con == null || isls == null || isls.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(IslImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(IslImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(IslImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < isls.length; ++i) {
                if (isls[i].getDBID() == 0L) {
                    isls[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(isls[i], checkStat);
                }
                if (isls[i].getDBID() == 0L) {
                    isls[i].setDBID(Sequence.getSequence().getPK());
                    isls[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    if (isls[i] instanceof ChannelMemberIsl) continue;
                    fImpl.addIsl(isls[i]);
                    continue;
                }
                isls[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                isls[i].setDBID(Sequence.getSequence().getPK());
                isls[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVsanIsls(Connection con, VsanISLImpl[] vsanIsls) throws SQLException {
        if (con == null || vsanIsls == null || vsanIsls.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VsanISLImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VsanISLImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VsanISLImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vsanIsls.length; ++i) {
                if (vsanIsls[i].getDBID() == 0L) {
                    vsanIsls[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vsanIsls[i], checkStat);
                }
                if (vsanIsls[i].getDBID() == 0L) {
                    vsanIsls[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                vsanIsls[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vsanIsls[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVsanNpvls(Connection con, VsanNpvLinkImpl[] vsanNpvls) throws SQLException {
        if (con == null || vsanNpvls == null || vsanNpvls.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VsanNpvLinkImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VsanNpvLinkImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VsanNpvLinkImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vsanNpvls.length; ++i) {
                if (vsanNpvls[i].getDBID() == 0L) {
                    vsanNpvls[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vsanNpvls[i], checkStat);
                }
                if (vsanNpvls[i].getDBID() == 0L) {
                    vsanNpvls[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                vsanNpvls[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vsanNpvls[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistEndPorts(Connection con, EndPortImpl[] endPorts, FabricImpl fimpl) throws SQLException {
        Map<Long, Long> existingEndportIds = fimpl.getEndPortDbIds();
        if (con == null || endPorts == null || endPorts.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        PreparedStatement deleteStat = null;
        try {
            insertStat = con.prepareStatement(EndPortImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(EndPortImpl.getUpdateSqlStr());
            deleteStat = con.prepareStatement(EndPortImpl.getDeleteSqlStr());
            checkStat = con.prepareStatement(EndPortImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < endPorts.length; ++i) {
                if (endPorts[i].getDBID() == 0L) {
                    endPorts[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(endPorts[i], checkStat);
                }
                if (endPorts[i].getDBID() == 0L) {
                    endPorts[i].setDBID(Sequence.getSequence().getPK());
                    endPorts[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    fimpl.addEndPortById(endPorts[i]);
                } else if (endPorts[i].getBaseObject().isModified()) {
                    endPorts[i].setupUpdateStatement(updateStat);
                    if (updateStat.executeUpdate() < 1) {
                        endPorts[i].setupInsertStatement(insertStat);
                        insertStat.execute();
                    }
                }
                fimpl.addEndPortById(endPorts[i]);
                existingEndportIds.remove(endPorts[i].getDBID());
            }
            Iterator<Comparable<Long>> i$ = existingEndportIds.keySet().iterator();
            while (i$.hasNext()) {
                long id = i$.next();
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            for (EndPortImpl ep : fimpl.getEndPortRemoveList()) {
                deleteStat.setLong(1, ep.getDBID());
                deleteStat.addBatch();
            }
            deleteStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            DbUtil.close(deleteStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
        DbUtil.close(deleteStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVsanEndPorts(Connection con, VsanNxPortImpl[] vEndPorts) throws SQLException {
        if (con == null || vEndPorts == null || vEndPorts.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VsanNxPortImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VsanNxPortImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VsanNxPortImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vEndPorts.length; ++i) {
                if (vEndPorts[i].getDBID() == 0L) {
                    vEndPorts[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vEndPorts[i], checkStat);
                }
                if (vEndPorts[i].getDBID() == 0L) {
                    vEndPorts[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                    continue;
                }
                vEndPorts[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vEndPorts[i].setupInsertStatement(insertStat);
                insertStat.addBatch();
            }
            insertStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * Exception decompiling
     */
    public void persistFabricCfsRegions(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void persistFabricVsans(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void persistFabricEnfZones(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        VsanImpl[] vsans = fImpl.getVsans();
        if (vsans == null) {
            return;
        }
        try {
            int zmCount = 0;
            for (int i = 0; i < vsans.length; ++i) {
                ZoneBase[] zones = vsans[i].getEnforcedZones();
                if (zones == null || zones.length == 0) continue;
                zmCount += zones.length;
                ZoneImpl[] zoneImpls = new ZoneImpl[zones.length];
                for (int j = 0; j < zones.length; ++j) {
                    zoneImpls[j] = new ZoneImpl(vsans[i], zones[j]);
                }
                this.persistZones(con, zoneImpls);
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistFabricEnfZones", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"persistFabricEnfZones", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFabricSwitches(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        int i;
        SwitchImpl[] sws = fImpl.getSwitches();
        if (sws == null) {
            return;
        }
        PreparedStatement insertSwitchStat = null;
        PreparedStatement updateSwitchStat = null;
        PreparedStatement checkSwitchByFabricIdIpStat = null;
        PreparedStatement checkSwitchByFabricIdWwnStat = null;
        try {
            insertSwitchStat = con.prepareStatement(SwitchImpl.getInsertSqlStr());
            updateSwitchStat = con.prepareStatement(SwitchImpl.getUpdateSqlStr());
            checkSwitchByFabricIdIpStat = con.prepareStatement(SwitchImpl.getCheckExistenceByFabricIdIpSqlStr());
            checkSwitchByFabricIdWwnStat = con.prepareStatement(SwitchImpl.getCheckExistenceByFabricIdWwnSqlStr());
            for (i = 0; i < sws.length; ++i) {
                if (sws[i].getDBID() == 0L) {
                    if (sws[i].getWwn() != null) {
                        sws[i].setupCheckExistenceByFabricIdWwnStatement(checkSwitchByFabricIdWwnStat);
                        this.checkPreexistRecord(sws[i], checkSwitchByFabricIdWwnStat);
                    } else if (sws[i].getInetAddress() != null) {
                        sws[i].setupCheckExistenceByFabricIdIpStatement(checkSwitchByFabricIdIpStat);
                        this.checkPreexistRecord(sws[i], checkSwitchByFabricIdIpStat);
                    }
                }
                if (sws[i].getWwn() == null) {
                    _Logger.debug((Object)("  skip persisting switch without wwn: " + sws[i]));
                    continue;
                }
                if (sws[i].getDBID() == 0L) {
                    sws[i].setDBID(Sequence.getSequence().getPK());
                    sws[i].setupInsertStatement(insertSwitchStat);
                    insertSwitchStat.execute();
                    continue;
                }
                sws[i].setupUpdateStatement(updateSwitchStat);
                int updateRes = updateSwitchStat.executeUpdate();
                if (updateRes >= 1) continue;
                sws[i].setupInsertStatement(insertSwitchStat);
                insertSwitchStat.execute();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertSwitchStat);
            DbUtil.close(updateSwitchStat);
            DbUtil.close(checkSwitchByFabricIdIpStat);
            DbUtil.close(checkSwitchByFabricIdWwnStat);
            throw throwable;
        }
        DbUtil.close(insertSwitchStat);
        DbUtil.close(updateSwitchStat);
        DbUtil.close(checkSwitchByFabricIdIpStat);
        DbUtil.close(checkSwitchByFabricIdWwnStat);
        for (i = 0; i < sws.length; ++i) {
            this.persistSwitchMgmtAddresses(con, sws[i]);
        }
        _Logger.debug((Object)("  persist " + (sws == null ? 0 : sws.length) + " Switches"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistSwitchMgmtAddresses(Connection con, SwitchImpl sw) throws SQLException {
        if (con == null || sw == null || sw.getDBID() == 0L) {
            return;
        }
        long switchId = sw.getDBID();
        PreparedStatement deletMgmtAddrStat = null;
        PreparedStatement insertMgmtAddrStat = null;
        try {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            deletMgmtAddrStat = con.prepareStatement("delete from switch_mgmt_address where switch_id= ?");
            deletMgmtAddrStat.setLong(1, switchId);
            deletMgmtAddrStat.execute();
            InetAddress[] addrs = sw.getManagementAddresses();
            if (addrs != null) {
                insertMgmtAddrStat = con.prepareStatement("insert into switch_mgmt_address (switch_id, mgmt_address, mgmt_type, last_update_time) values (?,?,?,?)");
                for (int i = 0; i < addrs.length; ++i) {
                    if (addrs[i] == null) continue;
                    insertMgmtAddrStat.setLong(1, switchId);
                    insertMgmtAddrStat.setBytes(2, addrs[i].getAddress());
                    insertMgmtAddrStat.setNull(3, 5);
                    insertMgmtAddrStat.setTimestamp(4, time);
                    insertMgmtAddrStat.addBatch();
                }
                insertMgmtAddrStat.executeBatch();
            }
            _Logger.trace((Object)("  persist " + (addrs == null ? 0 : addrs.length) + " mgmt addresses for " + sw.getIpAddress()));
        }
        catch (Throwable throwable) {
            DbUtil.close(deletMgmtAddrStat);
            DbUtil.close(insertMgmtAddrStat);
            throw throwable;
        }
        DbUtil.close(deletMgmtAddrStat);
        DbUtil.close(insertMgmtAddrStat);
    }

    public void persistSMEPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        SwitchImpl[] sws = fImpl.getSwitches();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            List<FcPortBase> smePorts;
            if (sws[i] == null || (smePorts = sws[i].findSMEPorts()) == null) continue;
            for (FcPortBase smePort : smePorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], smePort.getIfIndex(), smePort.getIfSpeed(), false, smePort.getFcConnectorType());
                spImpl.setSMEState(smePort.getSMEState());
                spImpl.setClusterId(smePort.getClusterId());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
    }

    public void persistGigaEthPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        SwitchImpl[] sws = fImpl.getSwitches();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (sws[i] == null) continue;
            WwnKey swPk = sws[i].getSwitchPK();
            List<FcPortBase> gEPorts = sws[i].findGigaEthPorts();
            if (gEPorts == null) continue;
            for (FcPortBase gEPort : gEPorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], gEPort.getIfIndex(), gEPort.getIfSpeed(), false, gEPort.getFcConnectorType());
                spImpl.setIfType(gEPort.getIfType());
                spImpl.setIfOperStatus(gEPort.getIfOPerStatus());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        _Logger.debug((Object)("  persist " + switchPorts.size() + " GigaE Ports"));
        switchPorts.clear();
    }

    public void persistOtherFcPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        SwitchImpl[] sws = fImpl.getSwitches();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (sws[i] == null) continue;
            WwnKey swPk = sws[i].getSwitchPK();
            List<FcPortBase> fcPorts = sws[i].findOtherNonENonFxNonPCnlFcPorts();
            List<FcPortBase> mgmtPorts = sws[i].findMgmtPorts();
            fcPorts.addAll(mgmtPorts);
            if (fcPorts == null) continue;
            for (FcPortBase fcPort : fcPorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], fcPort.getIfIndex(), fcPort.getIfSpeed(), false, fcPort.getFcConnectorType());
                spImpl.setIfType(fcPort.getIfType());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        _Logger.debug((Object)("  persist " + switchPorts.size() + " Other FC Ports"));
        switchPorts.clear();
    }

    public void persistNonIPSEthPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        SwitchImpl[] sws = fImpl.getSwitches();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (sws[i] == null) continue;
            WwnKey swPk = sws[i].getSwitchPK();
            List<FcPortBase> ePorts = sws[i].findNonIPSEthPorts();
            if (ePorts == null) continue;
            for (FcPortBase ePort : ePorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], ePort.getIfIndex(), ePort.getIfSpeed(), false, ePort.getFcConnectorType());
                spImpl.setIfType(ePort.getIfType());
                spImpl.setIfOperStatus(ePort.getIfOPerStatus());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        _Logger.debug((Object)("  persist " + switchPorts.size() + " GigaE and non-IPS Ethernet Ports"));
        switchPorts.clear();
    }

    public void persistNonIPSEthPortChannels(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        SwitchImpl[] sws = fImpl.getSwitches();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (sws[i] == null) continue;
            WwnKey swPk = sws[i].getSwitchPK();
            List<FcPortBase> ePorts = sws[i].findNonIPSEthPortChannels();
            if (ePorts == null) continue;
            for (FcPortBase ePort : ePorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], ePort.getIfIndex(), ePort.getIfSpeed(), false, ePort.getFcConnectorType());
                spImpl.setIfType(ePort.getIfType());
                spImpl.setIfOperStatus(ePort.getIfOPerStatus());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        _Logger.debug((Object)("  persist " + switchPorts.size() + " Ethernet Port Channels"));
        switchPorts.clear();
    }

    public void persistFcipPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        SwitchImpl[] sws = fImpl.getSwitches();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            List<FcPortBase> fcipPorts;
            if (sws[i] == null || (fcipPorts = sws[i].findFcipPorts()) == null) continue;
            WwnKey swPk = sws[i].getSwitchPK();
            for (FcPortBase fcipPort : fcipPorts) {
                FcPortImpl spImpl = this.getFcPortImpl(sws[i], fcipPort.getIfIndex(), fcipPort.getIfSpeed(), false, fcipPort.getFcConnectorType());
                spImpl.setIfType(fcipPort.getIfType());
                spImpl.setParent(fcipPort.getParent());
                switchPorts.add(spImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        _Logger.debug((Object)("  persist " + switchPorts.size() + " Fcip Ports"));
        switchPorts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistDeviceAliases(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        FcPortAlias[] deviceAliases = fImpl.getDeviceAliases();
        if (deviceAliases == null || deviceAliases.length == 0) {
            return;
        }
        HashSet hash = this.loadDeviceAliasIds(fImpl, con);
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement stat = null;
        PreparedStatement deleteStat = null;
        try {
            updateStat = con.prepareStatement(this._updateDeviceAliasSQL);
            insertStat = con.prepareStatement(this._insertDeviceAliasSQL);
            for (int i = 0; i < deviceAliases.length; ++i) {
                int index = 1;
                long id = deviceAliases[i].getDBID();
                if (hash.contains(new Long(id))) {
                    if (!deviceAliases[i].isModified()) continue;
                    stat = updateStat;
                    stat.setLong(this._deviceAliasCols.length, id);
                } else {
                    id = Sequence.getSequence().getPK();
                    hash.add(new Long(id));
                    deviceAliases[i].setDBID(id);
                    stat = insertStat;
                    stat.setLong(index++, id);
                }
                stat.setLong(index++, fImpl.getDBID());
                stat.setInt(index++, deviceAliases[i].getCfsRegionId());
                stat.setBytes(index++, deviceAliases[i].getWwn().getValue());
                stat.setString(index++, deviceAliases[i].getAlias());
                stat.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
                stat.addBatch();
                fImpl.addAlias(deviceAliases[i]);
            }
            updateStat.executeBatch();
            insertStat.executeBatch();
            deleteStat = con.prepareStatement(this._deleteDeviceAliasSQL);
            List<FcPortAlias> removeList = fImpl.getDeviceAliasRemoveList();
            for (FcPortAlias alias : removeList) {
                deleteStat.setLong(1, alias.getDBID());
                deleteStat.execute();
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(deleteStat);
            DbUtil.close(stat);
            hash.clear();
            hash = null;
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(deleteStat);
        DbUtil.close(stat);
        hash.clear();
        hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistClusters(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        ClusterImpl[] clusters = fImpl.getClusters();
        if (clusters == null || clusters.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(ClusterImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(ClusterImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(ClusterImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i].getDBID() == 0L) {
                    clusters[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(clusters[i], checkStat);
                }
                if (clusters[i].getDBID() == 0L) {
                    clusters[i].setDBID(Sequence.getSequence().getPK());
                    clusters[i].setupInsertStatement(insertStat);
                    insertStat.addBatch();
                } else if (clusters[i].getBaseObject().isModified()) {
                    clusters[i].setupUpdateStatement(updateStat);
                    if (updateStat.executeUpdate() < 1) {
                        clusters[i].setupInsertStatement(insertStat);
                        insertStat.addBatch();
                    }
                }
                clusters[i].getBaseObject().setFlushed(true);
            }
            insertStat.executeBatch();
            _Logger.debug((Object)("  persist " + (clusters == null ? 0 : clusters.length) + " CLUSTERs"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistNpvLinks(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        int i;
        NpvLinkImpl[] npvLinks = fImpl.getNpvLinks();
        ArrayList<FcPortImpl> switchPortList = new ArrayList<FcPortImpl>();
        if (npvLinks == null || npvLinks.length == 0) {
            return;
        }
        HashSet hash = this.loadNpvLinkIds(fImpl, con);
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement stat = null;
        try {
            updateStat = con.prepareStatement(this._updateNpvLinkSQL);
            insertStat = con.prepareStatement(this._insertNpvLinkSQL);
            for (i = 0; i < npvLinks.length; ++i) {
                int index = 1;
                long id = npvLinks[i].getDBID();
                if (hash.contains(new Long(id))) {
                    stat = updateStat;
                    stat.setLong(this._npvLinkCols.length, id);
                } else {
                    id = Sequence.getSequence().getPK();
                    hash.add(new Long(id));
                    npvLinks[i].setDBID(id);
                    stat = insertStat;
                    stat.setLong(index++, id);
                }
                stat.setLong(index++, npvLinks[i].getCoreSwitch().getDBID());
                stat.setLong(index++, npvLinks[i].getEdgeSwitch().getDBID());
                stat.setInt(index++, npvLinks[i].getFPortIfIndex());
                stat.setInt(index++, npvLinks[i].getNpPortIfIndex());
                stat.setBytes(index++, npvLinks[i].getFPortWwn().getValue());
                stat.setBytes(index++, npvLinks[i].getNpPortWwn().getValue());
                stat.setInt(index++, npvLinks[i].getOperStatusCause());
                stat.setLong(index++, npvLinks[i].getSpeed());
                stat.setBoolean(index++, npvLinks[i].isPresent());
                stat.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
                stat.setLong(index++, npvLinks[i].getLastScanTime());
                boolean isChannelMember = npvLinks[i] instanceof ChannelMemberNpvl;
                stat.setBoolean(index++, isChannelMember);
                stat.setLong(index++, isChannelMember ? ((ChannelMemberNpvl)npvLinks[i]).getParent().getDBID() : 0L);
                stat.addBatch();
            }
            insertStat.executeBatch();
            updateStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            hash.clear();
            hash = null;
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        hash.clear();
        hash = null;
        for (i = 0; i < npvLinks.length; ++i) {
            SwitchImpl sw1 = npvLinks[i].getCoreSwitch();
            SwitchImpl sw2 = npvLinks[i].getEdgeSwitch();
            NpvLinkBase base = (NpvLinkBase)npvLinks[i].getBaseObject();
            FcPortImpl spImpl1 = this.getFcPortImpl(sw1, npvLinks[i].getFPortIfIndex(), npvLinks[i].getSpeed(), false, base.getFcConnectorType());
            FcPortImpl spImpl2 = this.getFcPortImpl(sw2, npvLinks[i].getNpPortIfIndex(), npvLinks[i].getSpeed(), false, base.getFcConnectorType());
            switchPortList.add(spImpl1);
            switchPortList.add(spImpl2);
        }
        this.persistSwitchPorts(con, switchPortList.toArray(new FcPortImpl[switchPortList.size()]), fImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistNpvLinks(Connection con, NpvLinkImpl[] npvls, FabricImpl fImpl) throws DBException, SQLException {
        if (con == null || npvls == null || npvls.length == 0) {
            return;
        }
        HashSet hash = this.loadNpvLinkIds(fImpl, con);
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        PreparedStatement stat = null;
        try {
            updateStat = con.prepareStatement(this._updateNpvLinkSQL);
            insertStat = con.prepareStatement(this._insertNpvLinkSQL);
            checkStat = con.prepareStatement(NpvLinkImpl.getCheckExistenceByWwnSqlStr());
            for (int i = 0; i < npvls.length; ++i) {
                int index = 1;
                long id = npvls[i].getDBID();
                if (id == 0L && npvls[i].getFPortWwn() != null && npvls[i].getNpPortWwn() != null) {
                    npvls[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(npvls[i], checkStat);
                }
                if (hash.contains(new Long(id = npvls[i].getDBID()))) {
                    stat = updateStat;
                    stat.setLong(this._npvLinkCols.length, id);
                } else {
                    id = Sequence.getSequence().getPK();
                    hash.add(new Long(id));
                    npvls[i].setDBID(id);
                    stat = insertStat;
                    stat.setLong(index++, id);
                }
                stat.setLong(index++, npvls[i].getCoreSwitch().getDBID());
                stat.setLong(index++, npvls[i].getEdgeSwitch().getDBID());
                stat.setInt(index++, npvls[i].getFPortIfIndex());
                stat.setInt(index++, npvls[i].getNpPortIfIndex());
                stat.setBytes(index++, npvls[i].getFPortWwn().getValue());
                stat.setBytes(index++, npvls[i].getNpPortWwn().getValue());
                stat.setInt(index++, npvls[i].getOperStatusCause());
                stat.setLong(index++, npvls[i].getSpeed());
                stat.setBoolean(index++, npvls[i].isPresent());
                stat.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
                stat.setLong(index++, npvls[i].getLastScanTime());
                boolean isChannelMember = npvls[i] instanceof ChannelMemberNpvl;
                stat.setBoolean(index++, isChannelMember);
                stat.setLong(index++, isChannelMember ? ((ChannelMemberNpvl)npvls[i]).getParent().getDBID() : 0L);
                stat.addBatch();
            }
            insertStat.executeBatch();
            updateStat.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            DbUtil.close(stat);
            hash.clear();
            hash = null;
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
        DbUtil.close(stat);
        hash.clear();
        hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFabricVsanDomainIDs(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        VsanImpl[] vsans = fImpl.getVsans();
        int persisted = 0;
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VsanDomainImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VsanDomainImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VsanDomainImpl.getCheckExistenceSqlStr());
            for (VsanImpl vsan : vsans) {
                _Logger.trace((Object)("vsandomain   " + vsan.getId() + "/" + vsan.isUp() + " " + vsan.getDBID()));
                for (SwitchImpl sw : vsan.getAllSwitches()) {
                    VsanDomain domainPk = sw.getVsanDomain(vsan.getId());
                    if (domainPk == null) {
                        _Logger.trace((Object)(sw.getIpAddress() + " -- not found domain id in VSAN " + vsan.getId()));
                        continue;
                    }
                    _Logger.trace((Object)(sw.getIpAddress() + " -- domain id " + domainPk._domainId));
                    Wwn vwwn = domainPk == null ? null : domainPk.getVsanWwn();
                    VsanDomainImpl vImpl = new VsanDomainImpl(vsan, domainPk._domainId & 0xFF, vwwn, sw);
                    if (vImpl.getDBID() == 0L) {
                        vImpl.setupCheckExistenceStatement(checkStat);
                        this.checkPreexistRecord(vImpl, checkStat);
                    }
                    if (vImpl.getDBID() == 0L) {
                        vImpl.setupInsertStatement(insertStat);
                        insertStat.addBatch();
                    } else {
                        vImpl.setupUpdateStatement(updateStat);
                        if (updateStat.executeUpdate() < 1) {
                            vImpl.setupInsertStatement(insertStat);
                            insertStat.addBatch();
                        }
                    }
                    insertStat.executeBatch();
                    ++persisted;
                }
            }
            _Logger.debug((Object)("  persist " + persisted + " VsanDomains"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public void persistMiscObject(FabricImpl fImpl, Connection con, String sql) throws DBException, SQLException {
        this.persistMiscObject(fImpl, con, sql, false);
    }

    public void persistMiscObject(FabricImpl fImpl, Connection con, String sql, boolean useLastUpdateTime) throws DBException, SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (ps != null) {
                if (fImpl != null) {
                    ps.setLong(1, fImpl.getDBID());
                    if (useLastUpdateTime) {
                        ps.setTimestamp(2, new Timestamp(fImpl.getLastUpdateTime()));
                    }
                }
                ps.execute();
                int count = ps.getUpdateCount();
                if (count != 0) {
                    String str = sql;
                    int index = str.indexOf("delete from ");
                    if (index != -1 && (index = sql.indexOf(" ", index + 1)) != -1) {
                        str = str.substring(0, index);
                    }
                    _Logger.debug((Object)(str + ": " + count));
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)sql, (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(ps);
        }
    }

    public int countCleanObject(FabricImpl fImpl, Connection con, String sql) throws DBException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = con.prepareStatement(sql);
            if (ps != null) {
                if (fImpl != null) {
                    ps.setLong(1, fImpl.getDBID());
                }
                if ((rs = ps.executeQuery()).next()) {
                    count = rs.getInt(1);
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"countCleanObject", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(ps);
        }
        return count;
    }

    public void persistFabricMisc(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        PersistentWrapperIf helper = PersistentHelper.getHelper();
        this.persistMiscObject(fImpl, con, helper.getQueryString(VsanEndPortCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(VsanDomainCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(VsanISLCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(ISLCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(VsanNpvLinkCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(NpvLinkCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(FcAliasCleanSQL));
        this.cleanSwitchPort(fImpl, con);
        this.persistMiscObject(fImpl, con, helper.getQueryString(VsanCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(CfsRegionCleanSQL));
        this.persistMiscObject(fImpl, con, helper.getQueryString(SwitchCleanSQL));
        this.cleanCluster(fImpl, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCluster(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        ClusterImpl[] clusters = fImpl.getClusters();
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(ClusterImpl.getDeleteSqlStr());
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i].getBaseObject().isFlushed()) continue;
                deleteStat.setLong(1, clusters[i].getDBID());
                deleteStat.execute();
            }
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSwitchPort(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        Iterator<FcPortImpl> iter = fImpl.getDbFcPortIterator();
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(FcPortImpl.getDeleteSqlStr());
            while (iter.hasNext()) {
                FcPortImpl fcPort = iter.next();
                if (fcPort.getBaseObject().isFlushed()) continue;
                deleteStat.setLong(1, fcPort.getDBID());
                deleteStat.execute();
            }
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    public void persistVIMisc(VirtualCenterImpl vImpl, Connection con) throws DBException, SQLException {
        PersistentWrapperIf helper = PersistentHelper.getHelper();
        this.persistMiscObject(vImpl, con, helper.getQueryString(VHostCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(PhynicCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(VmDataStoreCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(VmPhynicCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(VirtualMachineCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(DataStoreCleanSQL));
        this.persistMiscObject(vImpl, con, helper.getQueryString(EncDataStoreCleanSQL));
    }

    public void persistMiscObject(VirtualCenterImpl vImpl, Connection con, String sql) throws DBException, SQLException {
        this.persistMiscObject(vImpl, con, sql, false);
    }

    public void persistMiscObject(VirtualCenterImpl vImpl, Connection con, String sql, boolean useLastUpdateTime) throws DBException, SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (ps != null) {
                if (vImpl != null) {
                    ps.setLong(1, vImpl.getDBID());
                    if (useLastUpdateTime) {
                        ps.setTimestamp(2, new Timestamp(vImpl.getLastUpdateTime()));
                    }
                }
                ps.execute();
                int count = ps.getUpdateCount();
                if (count != 0) {
                    String str = sql;
                    int index = str.indexOf("delete from ");
                    if (index != -1 && (index = sql.indexOf(" ", index + 1)) != -1) {
                        str = str.substring(0, index);
                    }
                    _Logger.debug((Object)(str + ": " + count));
                }
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)sql, (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistVIHostClusters(VirtualCenterImpl vc, Connection con) throws DBException, SQLException {
        if (vc == null || con == null) {
            return;
        }
        HostClusterImpl[] clusters = vc.getClusters();
        if (clusters == null || clusters.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(HostClusterImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(HostClusterImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(HostClusterImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i].getDBID() == 0L) {
                    clusters[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(clusters[i], checkStat);
                }
                if (clusters[i].getDBID() == 0L) {
                    clusters[i].setDBID(Sequence.getSequence().getPK());
                    clusters[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                clusters[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                clusters[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (clusters == null ? 0 : clusters.length) + " Enclosures"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistVIHost(FabricImpl fabric, Connection con) throws DBException, SQLException {
        EnclosureImpl[] hostEnclosures = fabric.getEnclosures(1);
        ArrayList<VHostImpl> vhostList = new ArrayList<VHostImpl>();
        if (hostEnclosures == null || hostEnclosures.length == 0) {
            return;
        }
        for (int i = 0; i < hostEnclosures.length; ++i) {
            if (hostEnclosures[i] == null || hostEnclosures[i].getVhost() == null) continue;
            vhostList.add(hostEnclosures[i].getVhost());
        }
        VHostImpl[] vhosts = vhostList.toArray(new VHostImpl[vhostList.size()]);
        if (vhosts == null || vhosts.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VHostImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VHostImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VHostImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vhosts.length; ++i) {
                if (vhosts[i].getDBID() == 0L) {
                    vhosts[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vhosts[i], checkStat);
                }
                if (vhosts[i].getDBID() == 0L) {
                    vhosts[i].setDBID(Sequence.getSequence().getPK());
                    vhosts[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                vhosts[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vhosts[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (vhosts == null ? 0 : vhosts.length) + " vHosts"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistVIHost(VirtualCenterImpl vc, Connection con) throws DBException, SQLException {
        int i;
        VHostImpl[] vhosts = vc.getHosts();
        if (vhosts == null || vhosts.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VHostImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VHostImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VHostImpl.getCheckExistenceSqlStr());
            for (i = 0; i < vhosts.length; ++i) {
                if (vhosts[i].getDBID() == 0L) {
                    vhosts[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vhosts[i], checkStat);
                }
                if (vhosts[i].getDBID() == 0L) {
                    vhosts[i].setDBID(Sequence.getSequence().getPK());
                    vhosts[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                vhosts[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vhosts[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (vhosts == null ? 0 : vhosts.length) + " vHosts"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
        for (i = 0; i < vhosts.length; ++i) {
            this.persistPhyNics(vhosts[i], con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistVNics(VmImpl vm, Connection con) throws DBException, SQLException {
        int i;
        GuestNicImpl[] vNics = vm.getVNics();
        if (vNics == null || vNics.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(GuestNicImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(GuestNicImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(GuestNicImpl.getCheckExistenceSqlStr());
            for (i = 0; i < vNics.length; ++i) {
                if (vNics[i].getDBID() == 0L) {
                    vNics[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vNics[i], checkStat);
                }
                if (vNics[i].getDBID() == 0L) {
                    vNics[i].setDBID(Sequence.getSequence().getPK());
                    vNics[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                vNics[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vNics[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (vNics == null ? 0 : vNics.length) + " vNics for " + vm));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
        for (i = 0; i < vNics.length; ++i) {
            this.persistVNicIpAddresses(vNics[i], con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistPhyNics(VHostImpl vhost, Connection con) throws DBException, SQLException {
        PhyNicImpl[] phyNics = vhost.getPhyNics();
        if (phyNics == null || phyNics.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(PhyNicImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(PhyNicImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(PhyNicImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < phyNics.length; ++i) {
                if (phyNics[i].getDBID() == 0L) {
                    phyNics[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(phyNics[i], checkStat);
                }
                if (phyNics[i].getDBID() == 0L) {
                    phyNics[i].setDBID(Sequence.getSequence().getPK());
                    phyNics[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                phyNics[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                phyNics[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (phyNics == null ? 0 : phyNics.length) + " phyNics for " + vhost));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public void persistVIVirtualMachines(VirtualCenterImpl vc, Connection con) throws DBException, SQLException {
        int i;
        VHostImpl[] hosts = vc.getHosts();
        ArrayList<VmImpl> vmList = new ArrayList<VmImpl>();
        for (int i2 = 0; hosts != null && i2 < hosts.length; ++i2) {
            List<VmImpl> vmsOnHost = hosts[i2].getVms();
            for (VmImpl vm : vmsOnHost) {
                if (vmList.contains(vm)) continue;
                vmList.add(vm);
            }
        }
        if (vmList.size() == 0) {
            return;
        }
        VmImpl[] vms = vmList.toArray(new VmImpl[vmList.size()]);
        ArrayList<VmPhynicImpl> vmPhynicList = new ArrayList<VmPhynicImpl>();
        for (i = 0; i < vms.length; ++i) {
            VHostImpl vhost = vms[i].getVhost();
            PhyNic[] pNics = vms[i].getPhyNics();
            for (int j = 0; pNics != null && j < pNics.length; ++j) {
                PhyNicImpl pnic;
                if (pNics[j] == null || (pnic = vhost.findPhynicByPK(new NameKey(pNics[j].getKey()))) == null) continue;
                VmPhynicImpl vmPhynic = new VmPhynicImpl(vms[i], pnic);
                vmPhynicList.add(vmPhynic);
            }
        }
        this.persistVirtualMachines(con, vms);
        this.persistVmPhynics(con, vmPhynicList.toArray(new VmPhynicImpl[vmPhynicList.size()]));
        _Logger.debug((Object)("persisted " + vmPhynicList.size() + " vmPhynics"));
        vmPhynicList.clear();
        for (i = 0; i < vms.length; ++i) {
            this.persistVNics(vms[i], con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistVNicIpAddresses(GuestNicImpl vnic, Connection con) throws SQLException {
        if (con == null || vnic == null || vnic.getDBID() == 0L) {
            return;
        }
        long vnicId = vnic.getDBID();
        PreparedStatement deletIpAddrStat = null;
        PreparedStatement insertIpAddrStat = null;
        try {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            deletIpAddrStat = con.prepareStatement("delete from vnic_ip_address where vnic_id= ?");
            deletIpAddrStat.setLong(1, vnicId);
            deletIpAddrStat.execute();
            String[] addrs = vnic.getIpAddress();
            if (addrs != null) {
                insertIpAddrStat = con.prepareStatement("insert into vnic_ip_address (vnic_id, ip_address, last_update_time) values (?,?,?)");
                for (int i = 0; i < addrs.length; ++i) {
                    if (addrs[i] == null) continue;
                    insertIpAddrStat.setLong(1, vnicId);
                    insertIpAddrStat.setString(2, addrs[i]);
                    insertIpAddrStat.setTimestamp(3, time);
                    insertIpAddrStat.addBatch();
                }
                insertIpAddrStat.executeBatch();
            }
            _Logger.trace((Object)("  persist " + (addrs == null ? 0 : addrs.length) + " ip addresses for " + vnic.getIpAddress()));
        }
        catch (Throwable throwable) {
            DbUtil.close(deletIpAddrStat);
            DbUtil.close(insertIpAddrStat);
            throw throwable;
        }
        DbUtil.close(deletIpAddrStat);
        DbUtil.close(insertIpAddrStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistVirtualMachines(Connection con, VmImpl[] vms) throws SQLException {
        if (con == null || vms == null || vms.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(VmImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(VmImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(VmImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < vms.length; ++i) {
                if (vms[i].getDBID() == 0L) {
                    vms[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(vms[i], checkStat);
                }
                if (vms[i].getDBID() == 0L) {
                    vms[i].setDBID(Sequence.getSequence().getPK());
                    vms[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                vms[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                vms[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (vms == null ? 0 : vms.length) + " Virtual Machines"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public void persistFabricDataStores(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        if (con == null || fImpl == null) {
            return;
        }
        DataStoreImpl[] dataStores = fImpl.getDataStores();
        if (dataStores == null) {
            return;
        }
        ArrayList<EnclDataStoreImpl> enclDataStoreList = new ArrayList<EnclDataStoreImpl>();
        for (int i = 0; i < dataStores.length; ++i) {
            List<EnclosureImpl> encls = dataStores[i].getEnclosures();
            for (EnclosureImpl encl : encls) {
                EnclDataStoreImpl enclDataStoreImpl;
                if (encl == null || enclDataStoreList.contains(enclDataStoreImpl = new EnclDataStoreImpl(encl, dataStores[i]))) continue;
                enclDataStoreList.add(enclDataStoreImpl);
            }
        }
        this.persistDataStores(con, dataStores, fImpl);
        this.persistEnclDataStores(con, enclDataStoreList.toArray(new EnclDataStoreImpl[enclDataStoreList.size()]));
        _Logger.debug((Object)("persisted " + enclDataStoreList.size() + " enclDataStores"));
        enclDataStoreList.clear();
    }

    public void persistVIDataStores(VirtualCenterImpl vc, Connection con) throws DBException, SQLException {
        if (vc == null || con == null) {
            return;
        }
        DataStoreImpl[] dataStores = vc.getDataStores();
        if (dataStores == null) {
            return;
        }
        ArrayList<VmDataStoreImpl> vmDataStoreList = new ArrayList<VmDataStoreImpl>();
        for (int i = 0; i < dataStores.length; ++i) {
            List<VmImpl> vms = dataStores[i].getVms();
            for (VmImpl vm : vms) {
                if (vm == null) continue;
                VmDataStoreImpl vmDataStoreImpl = new VmDataStoreImpl(vm, dataStores[i]);
                vmDataStoreList.add(vmDataStoreImpl);
            }
        }
        this.persistDataStores(con, dataStores, null);
        this.persistVmDataStores(con, vmDataStoreList.toArray(new VmDataStoreImpl[vmDataStoreList.size()]));
        _Logger.debug((Object)("persisted " + vmDataStoreList.size() + " vmDataStores"));
        vmDataStoreList.clear();
    }

    public void persistEnclosures() throws DBException, SQLException {
        EnclosureImpl[] ens = SanManager.getInstance().getEnclosures();
        for (int i = 0; ens != null && i < ens.length; ++i) {
            this.persistDBObject(ens[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFabricEnclosures(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        EnclosureImpl[] ens = fImpl.getEnclosures(3);
        if (ens == null || ens.length == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(EnclosureImpl.getInsertSqlStr());
            updateStat = con.prepareStatement(EnclosureImpl.getUpdateSqlStr());
            checkStat = con.prepareStatement(EnclosureImpl.getCheckExistenceSqlStr());
            for (int i = 0; i < ens.length; ++i) {
                if (ens[i].getDBID() == 0L) {
                    ens[i].setupCheckExistenceStatement(checkStat);
                    this.checkPreexistRecord(ens[i], checkStat);
                }
                if (ens[i].getDBID() == 0L) {
                    ens[i].setDBID(Sequence.getSequence().getPK());
                    ens[i].setupInsertStatement(insertStat);
                    insertStat.execute();
                    continue;
                }
                if (!ens[i].getBaseObject().isModified()) continue;
                ens[i].setupUpdateStatement(updateStat);
                if (updateStat.executeUpdate() >= 1) continue;
                ens[i].setupInsertStatement(insertStat);
                this.insertIgnoreError(insertStat);
            }
            _Logger.debug((Object)("  persist " + (ens == null ? 0 : ens.length) + " Enclosures"));
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    private void insertIgnoreError(PreparedStatement insertStat) {
        try {
            insertStat.execute();
        }
        catch (SQLException ex) {
            _Logger.debug((Object)("ignore insert exception:" + ex.getMessage()));
        }
    }

    public void persistFabricEndPorts(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        if (fImpl == null || con == null) {
            return;
        }
        EndPortImpl[] eps = fImpl.getEndPorts();
        if (eps == null || eps.length == 0) {
            return;
        }
        ArrayList<EndPortImpl> endPorts = new ArrayList<EndPortImpl>();
        ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
        ArrayList<VsanNxPortImpl> vsanEndPorts = new ArrayList<VsanNxPortImpl>();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < eps.length; ++i) {
            SwitchImpl sw;
            SwitchIntKey sk = eps[i].getSwitchIntKey();
            if (sk == null || (sw = sm.findSwitch(sk._swPK, fImpl.getPK())) == null) continue;
            FcPortImpl spImpl = this.getFcPortImpl(sw, sk._index, eps[i].getSpeed(), false, (short)1);
            if (spImpl.getSwitch() == null) {
                _Logger.warn((Object)("Switch missing: " + sk));
                continue;
            }
            spImpl.setOperStatusCause(eps[i].getOperStatusCause());
            if (eps[i].isFiconCup() && (spImpl.getIfname() == null || spImpl.getIfname().equals(Integer.toString(sk._index)))) {
                spImpl.setIfname("sup-fc0");
            }
            if (!switchPorts.contains(spImpl)) {
                switchPorts.add(spImpl);
            }
            eps[i].setHubImpl(spImpl);
            endPorts.add(eps[i]);
            VsanFcIdKey[] keys = eps[i].getVsanFcIds();
            for (int ii = 0; keys != null && ii < keys.length; ++ii) {
                VsanImpl vsanImpl = fImpl.findVsan(keys[ii]._vsanPK);
                if (vsanImpl == null) continue;
                VsanNxPortImpl veImpl = new VsanNxPortImpl(vsanImpl, keys[ii], eps[i]);
                vsanEndPorts.add(veImpl);
            }
        }
        this.persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fImpl);
        this.persistEndPorts(con, endPorts.toArray(new EndPortImpl[endPorts.size()]), fImpl);
        this.persistVsanEndPorts(con, vsanEndPorts.toArray(new VsanNxPortImpl[vsanEndPorts.size()]));
        _Logger.debug((Object)("Persisted " + endPorts.size() + " EndPorts"));
        _Logger.debug((Object)("Persisted " + vsanEndPorts.size() + " VsanEndPorts"));
        switchPorts.clear();
        endPorts.clear();
        vsanEndPorts.clear();
    }

    public FcPortImpl getFcPortImpl(SwitchImpl sw, int ifIndex, long ifSpeed, boolean isChannel, short connType) {
        SwitchIntKey siKey = new SwitchIntKey(sw.getSwitchPK(), ifIndex);
        FcPortImpl ret = sw.getFabric().findSwitchPortByKey(siKey);
        if (ret != null) {
            ret.setChannel(isChannel);
            if (((FcPortBase)ret.getBaseObject()).getIfSpeed() <= 0L) {
                ((FcPortBase)ret.getBaseObject()).setIfSpeed(ifSpeed);
            }
            ((FcPortBase)ret.getBaseObject()).setFcConnectorType(connType);
            return ret;
        }
        FcPortBase fcPort = sw.findPort(ifIndex);
        if (fcPort != null) {
            if (fcPort.getIfSpeed() <= 0L) {
                fcPort.setIfSpeed(ifSpeed);
            }
            if (connType == 1) {
                fcPort.setFcConnectorType(connType);
            }
            ret = new FcPortImpl(sw, fcPort, isChannel);
        } else {
            ret = new FcPortImpl(sw, ifIndex, ifSpeed, isChannel, connType);
        }
        return ret;
    }

    public void persistFabricIsls(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        if (con == null || fImpl == null) {
            return;
        }
        IslImpl[] isls = fImpl.getIsls();
        if (isls == null) {
            return;
        }
        ArrayList<ChannelMemberIsl> memIslList = new ArrayList<ChannelMemberIsl>();
        ArrayList<FcPortImpl> switchPortList = new ArrayList<FcPortImpl>();
        ArrayList<VsanISLImpl> vsanIslList = new ArrayList<VsanISLImpl>();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < isls.length; ++i) {
            List<ChannelMemberIsl> pcm;
            long ifSpeed = isls[i].getSpeed();
            SwitchIntKey key1 = isls[i].getSwitch1IntKey();
            SwitchIntKey key2 = isls[i].getSwitch2IntKey();
            SwitchImpl sw1 = sm.findSwitch(key1._swPK, fImpl.getPK());
            SwitchImpl sw2 = sm.findSwitch(key2._swPK, fImpl.getPK());
            if (sw1 == null || sw2 == null) continue;
            FcPortImpl spImpl1 = this.getFcPortImpl(sw1, key1._index, ifSpeed, isls[i].isPortChannel(), isls[i].getFcConnectorType());
            FcPortImpl spImpl2 = this.getFcPortImpl(sw2, key2._index, ifSpeed, isls[i].isPortChannel(), isls[i].getFcConnectorType());
            switchPortList.add(spImpl1);
            switchPortList.add(spImpl2);
            isls[i].setSwitchPortImpl(spImpl1, spImpl2);
            if (isls[i].isPortChannel() && (pcm = isls[i].getPCMemberLinks()) != null) {
                for (ChannelMemberIsl mem : pcm) {
                    long spd = isls[i].getSpeed();
                    FcPortImpl scpImpl1 = this.getFcPortImpl(mem.getSwitch1(), mem.getIfIndex1(), mem.getSpeed(), false, mem.getFcConnectorType());
                    scpImpl1.setChannelID(spImpl1.getDBID());
                    FcPortImpl scpImpl2 = this.getFcPortImpl(mem.getSwitch2(), mem.getIfIndex2(), mem.getSpeed(), false, mem.getFcConnectorType());
                    scpImpl2.setChannelID(spImpl2.getDBID());
                    switchPortList.add(scpImpl1);
                    switchPortList.add(scpImpl2);
                    mem.setSwitchPortImpl(scpImpl1, scpImpl2);
                    memIslList.add(mem);
                }
            }
            List<Short> vids = isls[i].getVsanMembership();
            Iterator<Comparable<Short>> i$ = vids.iterator();
            while (i$.hasNext()) {
                short vid = (Short)i$.next();
                VsanImpl v = isls[i].getVsan(vid);
                if (v == null) continue;
                VsanISLImpl vislImpl = new VsanISLImpl(v, isls[i]);
                vsanIslList.add(vislImpl);
            }
        }
        this.persistSwitchPorts(con, switchPortList.toArray(new FcPortImpl[switchPortList.size()]), fImpl);
        this.persistIsls(con, isls, fImpl);
        this.persistIsls(con, memIslList.toArray(new IslImpl[memIslList.size()]), fImpl);
        this.persistVsanIsls(con, vsanIslList.toArray(new VsanISLImpl[vsanIslList.size()]));
        _Logger.debug((Object)("persisted " + (isls.length + memIslList.size()) + " Isls/PortChannel Isls"));
        _Logger.debug((Object)("persisted " + (isls.length + memIslList.size() + vsanIslList.size()) + " vsanIsls"));
        switchPortList.clear();
        memIslList.clear();
        vsanIslList.clear();
    }

    public void persistFabricNpvls(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        if (con == null || fImpl == null) {
            return;
        }
        NpvLinkImpl[] npvls = fImpl.getNpvLinks();
        if (npvls == null) {
            return;
        }
        ArrayList<ChannelMemberNpvl> memNpvlList = new ArrayList<ChannelMemberNpvl>();
        ArrayList<FcPortImpl> switchPortList = new ArrayList<FcPortImpl>();
        ArrayList<VsanNpvLinkImpl> vsanNpvlList = new ArrayList<VsanNpvLinkImpl>();
        SanManager sm = SanManager.getInstance();
        for (int i = 0; i < npvls.length; ++i) {
            List<ChannelMemberNpvl> pcm;
            long ifSpeed = npvls[i].getSpeed();
            SwitchIntKey key1 = npvls[i].getSwitch1IntKey();
            SwitchIntKey key2 = npvls[i].getSwitch2IntKey();
            SwitchImpl sw1 = sm.findSwitch(key1._swPK, fImpl.getPK());
            SwitchImpl sw2 = sm.findSwitch(key2._swPK, fImpl.getPK());
            if (sw1 == null || sw2 == null) continue;
            NpvLinkBase base = (NpvLinkBase)npvls[i].getBaseObject();
            FcPortImpl spImpl1 = this.getFcPortImpl(sw1, key1._index, ifSpeed, npvls[i].isPortChannel(), base.getFcConnectorType());
            FcPortImpl spImpl2 = this.getFcPortImpl(sw2, key2._index, ifSpeed, npvls[i].isPortChannel(), base.getFcConnectorType());
            switchPortList.add(spImpl1);
            switchPortList.add(spImpl2);
            if (npvls[i].isPortChannel() && (pcm = npvls[i].getPCMemberLinks()) != null) {
                for (ChannelMemberNpvl mem : pcm) {
                    long spd = npvls[i].getSpeed();
                    FcPortImpl scpImpl1 = this.getFcPortImpl(mem.getSwitch1(), mem.getIfIndex1(), spd, false, (short)2);
                    scpImpl1.setChannelID(spImpl1.getDBID());
                    FcPortImpl scpImpl2 = this.getFcPortImpl(mem.getSwitch2(), mem.getIfIndex2(), spd, false, (short)2);
                    scpImpl2.setChannelID(spImpl2.getDBID());
                    switchPortList.add(scpImpl1);
                    switchPortList.add(scpImpl2);
                    memNpvlList.add(mem);
                }
            }
            List<Short> vids = npvls[i].getVsanMembership();
            Iterator<Comparable<Short>> i$ = vids.iterator();
            while (i$.hasNext()) {
                short vid = (Short)i$.next();
                VsanImpl v = npvls[i].getVsan(vid);
                if (v == null) continue;
                VsanNpvLinkImpl vnpvlImpl = new VsanNpvLinkImpl(v, npvls[i]);
                vsanNpvlList.add(vnpvlImpl);
            }
        }
        this.persistSwitchPorts(con, switchPortList.toArray(new FcPortImpl[switchPortList.size()]), fImpl);
        this.persistNpvLinks(con, memNpvlList.toArray(new NpvLinkImpl[memNpvlList.size()]), fImpl);
        this.persistVsanNpvls(con, vsanNpvlList.toArray(new VsanNpvLinkImpl[vsanNpvlList.size()]));
        _Logger.debug((Object)("persisted " + memNpvlList.size() + " member Port Channel npvls"));
        _Logger.debug((Object)("persisted " + (npvls.length + memNpvlList.size() + vsanNpvlList.size()) + " vsannpvls"));
        switchPortList.clear();
        memNpvlList.clear();
        vsanNpvlList.clear();
    }

    public void persistVmWare(VirtualCenterImpl vc) throws DBException, SQLException {
        String tName = Thread.currentThread().getName();
        Connection con = null;
        boolean hasLocker = false;
        try {
            hasLocker = true;
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            long startAt = _LastUpdateTime = System.currentTimeMillis();
            _Logger.info((Object)(tName + " Persisting DataCenter " + vc.getDBID() + " IP " + vc.getIpAddress().getHostAddress() + " at " + new Timestamp(_LastUpdateTime)));
            vc.setLastUpdateTime(_LastUpdateTime);
            this.persistDBObject(vc);
            this.persistVIHostClusters(vc, con);
            this.persistVIHost(vc, con);
            this.persistVIVirtualMachines(vc, con);
            this.persistVIDataStores(vc, con);
            con.commit();
            this.persistVIMisc(vc, con);
            con.commit();
            HostManager.getInstance().persistVhostHosts();
            Collection<VHostImpl> vhosts = vc.getAllHosts();
            if (vhosts != null) {
                for (VHostImpl h : vhosts) {
                    LanHostImpl.createHosts(con, h.getLanHosts());
                }
            }
            con.commit();
            long time = System.currentTimeMillis();
            long dur = (time - startAt) / 1000L;
            _Logger.info((Object)(tName + " Done persisting DataCenter " + vc.getDBID() + " IP " + vc.getIpAddress().getHostAddress() + " at " + new Timestamp(time) + ", " + dur + " sec."));
        }
        catch (DBException dbex) {
            con.rollback();
            _Logger.log((Priority)Level.WARN, (Object)(tName + "persistDataCenter"), (Throwable)dbex);
            throw dbex;
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)(tName + "persistDataCenter" + sqlex), (Throwable)sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _Logger.log((Priority)Level.WARN, (Object)(tName + "persistDataCenter getNextSQLException"), (Throwable)sqlex.getNextException());
            }
            throw sqlex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void persistFabric(FabricImpl fImpl) throws DBException, SQLException {
        boolean hasLocker;
        Connection con;
        block11: {
            String tName = Thread.currentThread().getName();
            con = null;
            hasLocker = false;
            try {
                if (fImpl.attemptFabric(2, 4, 2000L)) {
                    hasLocker = true;
                    con = ConnectionManager.getConnection();
                    con.setAutoCommit(false);
                    long startAt = _LastUpdateTime = System.currentTimeMillis();
                    _Logger.info((Object)(tName + " Persisting Fabric " + fImpl.getDBID() + " fid " + fImpl.getPK()._fid + " at " + new Timestamp(_LastUpdateTime)));
                    fImpl.setLastUpdateTime(_LastUpdateTime);
                    try {
                        SnmpUserImpl snmpUserImpl = new SnmpUserImpl(fImpl.getCredentials());
                        this.persistDBObject(con, snmpUserImpl);
                        fImpl.setUserDBID(snmpUserImpl.getDBID());
                    }
                    catch (IllegalArgumentException ex) {
                        _Logger.warn((Object)("\nSnmpUser of " + fImpl.getDBID() + " is not persisted " + ex.getMessage()));
                    }
                    PersistentWrapperIf helper = PersistentHelper.getHelper();
                    this.persistMiscObject(fImpl, con, helper.getQueryString(ZoneMemberCleanSQL));
                    this.persistMiscObject(fImpl, con, helper.getQueryString(ZoneMemberIVRCleanSQL));
                    this.persistMiscObject(fImpl, con, helper.getQueryString(ZoneCleanSQL));
                    this.persistMiscObject(fImpl, con, helper.getQueryString(ZoneIVRCleanSQL));
                    this.persistFabricEnclosures(fImpl, con);
                    this.persistFabricDataStores(fImpl, con);
                    this.persistFabricSwitches(fImpl, con);
                    this.persistFabricCfsRegions(fImpl, con);
                    this.persistFabricVsans(fImpl, con);
                    this.persistFabricVsanDomainIDs(fImpl, con);
                    this.persistFabricIsls(fImpl, con);
                    this.persistNpvLinks(fImpl, con);
                    this.persistFabricNpvls(fImpl, con);
                    this.persistFabricEndPorts(fImpl, con);
                    this.persistGigaEthPorts(fImpl, con);
                    this.persistNonIPSEthPorts(fImpl, con);
                    this.persistNonIPSEthPortChannels(fImpl, con);
                    this.persistFcipPorts(fImpl, con);
                    this.persistOtherFcPorts(fImpl, con);
                    this.persistFabricEnfZones(fImpl, con);
                    this.persistDeviceAliases(fImpl, con);
                    this.persistClusters(fImpl, con);
                    this.persistSMEPorts(fImpl, con);
                    this.persistDBObject(con, fImpl);
                    this.persistFabricMisc(fImpl, con);
                    this.persistFabricObject(fImpl, con, true);
                    con.commit();
                    HostManager.getInstance().persistEnclosureHosts(fImpl.getDBID());
                    StorageEnclosureImpl.persistStorageEnclosures(con);
                    long time = System.currentTimeMillis();
                    long dur = (time - startAt) / 1000L;
                    _Logger.info((Object)(tName + " Done persisting Fabric " + fImpl.getDBID() + " fid " + fImpl.getPK()._fid + " at " + new Timestamp(time) + ", " + dur + " sec."));
                    fImpl.postCommit();
                    SanManager.getInstance().cleanEnclosure();
                    break block11;
                }
                _Logger.warn((Object)(tName + " Skip persisting " + fImpl.getDBID() + " fid " + fImpl.getPK()._fid + ": fabric is busy "));
            }
            catch (InterruptedException iex) {
                _Logger.log((Priority)Level.WARN, (Object)(tName + "persistFabric"), (Throwable)iex);
                {
                    catch (Throwable throwable) {
                        DbUtil.close(con);
                        if (!hasLocker) throw throwable;
                        fImpl.releaseFabric(2);
                        throw throwable;
                    }
                }
                DbUtil.close(con);
                if (!hasLocker) return;
                fImpl.releaseFabric(2);
                return;
                catch (DBException dbex) {
                    con.rollback();
                    _Logger.log((Priority)Level.WARN, (Object)(tName + "persistFabric"), (Throwable)dbex);
                    throw dbex;
                    catch (SQLException sqlex) {
                        if (con != null) {
                            con.rollback();
                        }
                        _Logger.log((Priority)Level.WARN, (Object)(tName + "persistFabric" + sqlex), (Throwable)sqlex);
                        if (sqlex == null) throw sqlex;
                        if (sqlex.getNextException() == null) throw sqlex;
                        _Logger.log((Priority)Level.WARN, (Object)(tName + "persistFabric getNextSQLException"), (Throwable)sqlex.getNextException());
                        throw sqlex;
                    }
                }
            }
        }
        DbUtil.close(con);
        if (!hasLocker) return;
        fImpl.releaseFabric(2);
        return;
    }

    public ArrayList loadPersistentFabricsFromDB() throws SQLException {
        ArrayList al = FabricImpl.loadPersistentFabricsFromDB();
        if (al == null) {
            return null;
        }
        Iterator it = al.iterator();
        FabricImpl fImpl = null;
        while (it.hasNext()) {
            try {
                SwitchImpl[] sws;
                fImpl = (FabricImpl)it.next();
                if (!fImpl.isPersistent() || !fImpl.attemptFabric(1, 3, 2000L)) continue;
                this.reloadFabricElements(fImpl);
                _Logger.info((Object)("Loaded fabric elements " + fImpl));
                try {
                    InventoryPersistent.getInstance().reload(fImpl);
                    _Logger.info((Object)("Loaded Inventory for " + fImpl));
                }
                catch (Throwable t) {
                    _Logger.log((Priority)Level.WARN, (Object)("reload inventory " + fImpl.toString()), t);
                }
                for (SwitchImpl sw : sws = fImpl.getSwitches()) {
                    sw.checkCards();
                }
                fImpl.attemptFabric(3, 1, 100L);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("reloadFabric " + fImpl.toString()), (Throwable)ex);
                try {
                    SanManager.getInstance().closeFabric(fImpl);
                }
                catch (Exception smex) {
                    _Logger.log((Priority)Level.WARN, (Object)("remove bad Fabric " + fImpl.toString()), (Throwable)smex);
                }
            }
        }
        return al;
    }

    public FabricImpl reloadFabric(InetAddress ip) {
        FabricImpl fImpl = null;
        try {
            _Logger.info((Object)("Loading fabric " + ip));
            fImpl = FabricImpl.loadFromDB(ip);
            if (fImpl == null) {
                _Logger.info((Object)("Fabric " + ip + " not found in database."));
                return null;
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("reload fabric " + ip + " error: " + ex.getMessage()), (Throwable)ex);
        }
        this.reloadFabric(fImpl);
        return fImpl;
    }

    public FabricImpl reloadFabric(InetAddress ip, String inVsans, String exVsans) {
        FabricImpl fImpl = null;
        try {
            _Logger.info((Object)("Loading fabric " + ip));
            fImpl = FabricImpl.loadFromDB(ip, inVsans, exVsans);
            if (fImpl == null) {
                _Logger.info((Object)("Fabric " + ip + " not found in database."));
                return null;
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("reload fabric " + ip + " error: " + ex.getMessage()), (Throwable)ex);
        }
        this.reloadFabric(fImpl);
        return fImpl;
    }

    public void reloadFabric(FabricImpl fImpl) {
        if (fImpl == null) {
            return;
        }
        try {
            if (fImpl.attemptFabric(1, 3, 2000L) || fImpl.attemptFabric(6, 3, 2000L)) {
                this.reloadFabricElements(fImpl);
                InventoryPersistent.getInstance().reload(fImpl);
                _Logger.info((Object)("Loaded Inventory for " + fImpl));
                fImpl.releaseFabric(2);
            }
        }
        catch (Exception ex) {
            if (fImpl != null) {
                fImpl.releaseFabric(1);
            }
            _Logger.log((Priority)Level.WARN, (Object)("reload fabric " + fImpl.getPK() + " error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public FabricImpl reloadFabricElements(FabricImpl fImpl) throws SQLException, DBException {
        SwitchImpl aliasSeed;
        SwitchImpl ivrSeed;
        _Logger.debug((Object)("\treload fabric element " + fImpl.getDBID()));
        long startTime = System.currentTimeMillis();
        ArrayList sws = SwitchImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loading switches " + (sws == null ? 0 : sws.size())));
        SwitchImpl seed = fImpl.getSeed();
        if (seed == null) {
            if (fImpl.findSwitchByDbId(fImpl.getSeedDBID()) != null) {
                fImpl.setSeed(fImpl.findSwitchByDbId(fImpl.getSeedDBID()));
            } else {
                fImpl.selectSeedSwitch();
            }
        }
        if ((ivrSeed = fImpl.getIvrSeed()) == null && fImpl.findSwitchByDbId(fImpl.getIvrSeedDBID()) != null) {
            fImpl.setIvrSeed(fImpl.findSwitchByDbId(fImpl.getIvrSeedDBID()));
        }
        if ((aliasSeed = fImpl.getAliasSeed()) == null) {
            fImpl.setAliasSeed(fImpl.findSwitchByDbId(fImpl.getAliasSeedDBID()));
        }
        ArrayList vsans = VsanImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loaded vsans " + vsans.size()));
        ArrayList cfsRegions = CfsRegionImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loaded cfsRegions " + cfsRegions.size()));
        ArrayList spLists = FcPortImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loaded switch ports " + spLists.size()));
        ArrayList enclosureList = EnclosureImpl.loadFromDB(fImpl);
        if (enclosureList != null) {
            _Logger.debug((Object)("Loaded enclosures " + enclosureList.size()));
            for (int i = 0; i < enclosureList.size(); ++i) {
                InventoryPersistent.getInstance().reload((EnclosureImpl)enclosureList.get(i));
            }
        }
        ArrayList endPortList = EndPortImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loaded endports " + endPortList.size()));
        ArrayList islList = IslImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("Loaded isl " + islList.size()));
        _Logger.debug((Object)"Loading vsan isl membership");
        VsanISLImpl.loadFromDB(fImpl);
        _Logger.debug((Object)"Loading vsan domain membership");
        VsanDomainImpl.loadFromDB(fImpl);
        _Logger.debug((Object)"Loading vsan endport membership");
        VsanNxPortImpl.loadFromDB(fImpl);
        _Logger.debug((Object)"Loading npv links");
        this.loadNpvLinkFromDB(fImpl);
        fImpl.associateChannelMembers();
        _Logger.debug((Object)"Loading vsan npv_link membership");
        VsanNpvLinkImpl.loadFromDB(fImpl);
        ArrayList deviceAliases = this.loadDeviceAliasFromDB(fImpl);
        int numAliases = deviceAliases == null ? 0 : deviceAliases.size();
        _Logger.debug((Object)("Loaded device aliases " + numAliases));
        _Logger.debug((Object)"Loading ivr zone & member");
        ArrayList zal = ZoneImpl.loadFromDB(fImpl);
        _Logger.debug((Object)("\tivr " + zal.size()));
        for (int i = zal.size() - 1; i >= 0; --i) {
            ZoneMemberImpl.loadFromDB((ZoneImpl)zal.get(i));
        }
        _Logger.debug((Object)"Loading non ivr zone & member");
        for (VsanImpl vi : vsans) {
            zal = ZoneImpl.loadFromDB(vi);
            _Logger.debug((Object)("\tvsan " + vi.getDBID() + " ivr " + zal.size()));
            for (int i = zal.size() - 1; i >= 0; --i) {
                ZoneMemberImpl.loadFromDB((ZoneImpl)zal.get(i));
            }
        }
        _Logger.debug((Object)"Loading fc aliases");
        for (VsanImpl vi : vsans) {
            zal = this.loadFcAliasFromDB(vi);
            _Logger.debug((Object)("\tvsan " + vi.getDBID() + " fcAlias " + zal.size()));
        }
        _Logger.debug((Object)"Loading cluster");
        ClusterImpl.loadFromDB(fImpl);
        List<HostImpl> hostList = HostImpl.loadHostsFromDB();
        _Logger.debug((Object)("Loading hosts: " + (hostList == null ? 0 : hostList.size())));
        _Logger.debug((Object)("Done loading fabric " + fImpl + ", " + (System.currentTimeMillis() - startTime)));
        return fImpl;
    }

    public FabricImpl reloadFabric(FabricPK pkey) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricPK queryFabricPKByIpVsans(InetAddress ip, String inVsans, String exVsans) {
        FabricPK fabricPK;
        block6: {
            String sqlQuery = "select fabric.fid, fabric.name from fabric, switch where switch.ip_address=? and fabric.vsans_included=? and fabric.vsans_excluded=? and fabric.id=switch.fabric_id";
            fabricPK = null;
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(sqlQuery);
                stat.setBytes(1, ip.getAddress());
                stat.setString(2, inVsans == null ? "-1" : inVsans);
                stat.setString(3, exVsans == null ? "-1" : exVsans);
                rs = stat.executeQuery();
                if (rs.next()) {
                    fabricPK = new FabricPK((int)rs.getLong(1));
                    fabricPK.setName(rs.getString(2));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _Logger.log((Priority)Level.WARN, (Object)"queryFabricPKByIp", (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return fabricPK;
    }

    public static void purgeFabric(FabricImpl fabric) throws DBException, SQLException {
        InventoryPersistentManager.purgeFabric(fabric, 0L);
    }

    public static void purgeFabric(long fabricId) throws DBException, SQLException {
        if (fabricId <= 0L) {
            return;
        }
        InventoryPersistentManager.purgeFabric(null, fabricId);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void purgeFabric(FabricImpl fabric, long fabricId) throws DBException, SQLException {
        int fabricStatus = 0;
        if (fabric != null && (fabricStatus = fabric.getFarbicStatus()) != 6 && fabricStatus != 2) {
            _Logger.log((Priority)Level.WARN, (Object)("Can not purge fabric " + fabric + ":" + "DCNM is busy polling/discovering this fabric"));
            return;
        }
        Connection con = null;
        PreparedStatement deleteFabricStat = null;
        PreparedStatement selectSwitchStat = null;
        ResultSet rs = null;
        boolean hasLocker = false;
        if (fabric != null) {
            block21: {
                try {
                    con = ConnectionManager.getConnection();
                    con.setAutoCommit(false);
                    if (fabric.attemptFabric(fabricStatus, 4, _PurgeTime)) {
                        hasLocker = true;
                        InventoryPersistentManager.doPurgePMComponents(fabric.getDBID(), con);
                        InventoryPersistentManager.doPurgeUMComponents(fabric.getPK(), con);
                        Map<Long, Wwn> sws = SwitchImpl.findSwitchIdsByFabircId(fabric.getDBID());
                        if (sws != null) {
                            for (Long swId : sws.keySet()) {
                                InventoryPersistentManager.doPurgeSwitchComponents(swId, con);
                                InventoryPersistent.getInstance().purge(new WwnKey(sws.get(swId)), swId);
                            }
                        }
                        InventoryPersistentManager.doPurgeFabricComponents(fabric.getDBID(), con);
                        ClusterMapping.getInstance().purgeLOGIC(fabric.getPK().get_fid(), con);
                        deleteFabricStat = con.prepareStatement("delete from fabric where id=" + fabric.getDBID());
                        deleteFabricStat.execute();
                        con.commit();
                        _Logger.debug((Object)("Purge fabric: " + fabric.toString()));
                        break block21;
                    }
                    _Logger.log((Priority)Level.WARN, (Object)"Can not purge fabric: DCNM is busy polling/discovering this fabric");
                }
                catch (InterruptedException ex) {
                    _PurgeTime += 1000;
                    con.rollback();
                    _Logger.log((Priority)Level.WARN, (Object)"purgeFabric ", (Throwable)ex);
                    DbUtil.close(rs);
                    DbUtil.close(deleteFabricStat);
                    DbUtil.close(selectSwitchStat);
                    DbUtil.close(con);
                    if (!hasLocker) return;
                    fabric.releaseFabric(fabricStatus);
                    return;
                }
                catch (SQLException sqlex) {
                    if (con != null) {
                        con.rollback();
                    }
                    _Logger.log((Priority)Level.WARN, (Object)"purgeFabric ", (Throwable)sqlex);
                    throw sqlex;
                    {
                        catch (Throwable throwable) {
                            DbUtil.close(rs);
                            DbUtil.close(deleteFabricStat);
                            DbUtil.close(selectSwitchStat);
                            DbUtil.close(con);
                            if (!hasLocker) throw throwable;
                            fabric.releaseFabric(fabricStatus);
                            throw throwable;
                        }
                    }
                }
            }
            DbUtil.close(rs);
            DbUtil.close(deleteFabricStat);
            DbUtil.close(selectSwitchStat);
            DbUtil.close(con);
            if (!hasLocker) return;
            fabric.releaseFabric(fabricStatus);
            return;
        }
        try {
            String sql = "select id from switch where fabric_id=" + fabricId;
            if (con == null) {
                con = ConnectionManager.getConnection();
            }
            selectSwitchStat = con.prepareStatement(sql);
            rs = selectSwitchStat.executeQuery();
            ArrayList<Long> al = new ArrayList<Long>();
            while (rs.next()) {
                al.add(new Long(rs.getLong(1)));
            }
            for (int i = 0; i < al.size(); ++i) {
                InventoryPersistentManager.doPurgeSwitchComponents((Long)al.get(i), con);
            }
            InventoryPersistentManager.doPurgeFabricComponents(fabricId, con);
            FabricPK fpk = FabricImpl.findFPKByDbId(fabricId);
            if (fpk != null) {
                ClusterMapping.getInstance().purgeLOGIC(fpk.get_fid(), con);
            }
            deleteFabricStat = con.prepareStatement("delete from fabric where id=" + fabricId);
            deleteFabricStat.execute();
            con.commit();
            _Logger.info((Object)("Done purge fabric and associated VSANs and switches: " + fabricId));
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
                _Logger.log((Priority)Level.WARN, (Object)"purgeFabric ", (Throwable)sqlex);
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(deleteFabricStat);
                DbUtil.close(selectSwitchStat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(deleteFabricStat);
        DbUtil.close(selectSwitchStat);
        DbUtil.close(con);
        return;
    }

    private static void doPurgePMComponents(long fabricId, Connection con) throws SQLException {
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        PreparedStatement stat3 = null;
        try {
            stat1 = con.prepareStatement(PurgePmCollectionSQL);
            stat1.setLong(1, fabricId);
            stat1.execute();
            stat2 = con.prepareStatement(PurgeStatisticsEndPortSQL);
            stat2.setLong(1, fabricId);
            stat2.execute();
            stat3 = con.prepareStatement(PurgeStatisticsIslSQL);
            stat3.setLong(1, fabricId);
            stat3.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                DbUtil.close(stat3);
                throw throwable;
            }
        }
        DbUtil.close(stat1);
        DbUtil.close(stat2);
        DbUtil.close(stat3);
    }

    private static void doPurgeUMComponents(FabricPK fpk, Connection con) throws SQLException {
        PreparedStatement stat = null;
        if (fpk == null) {
            return;
        }
        try {
            stat = con.prepareStatement(PurgeUserFabricSQL);
            stat.setLong(1, fpk.get_fid());
            stat.execute();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            DbUtil.close(stat);
        }
    }

    private static void doPurgeFabricComponents(long fabricId, Connection con) throws SQLException {
        PreparedStatement purgeVsanDomainInfoStat = null;
        PreparedStatement purgeVsanIslInfoStat = null;
        PreparedStatement purgeVsanEndPortInfoStat = null;
        PreparedStatement purgeIvrZoneMemberStat = null;
        PreparedStatement purgeEndPortStat = null;
        PreparedStatement purgeIvrZoneStat = null;
        PreparedStatement purgeEnfZoneMemberStat = null;
        PreparedStatement purgeEnfZoneStat = null;
        PreparedStatement purgeVsanStat = null;
        PreparedStatement purgeCfsRegionStat = null;
        PreparedStatement purgeSwitchStat = null;
        PreparedStatement purgeClusterStat = null;
        PreparedStatement purgeDeviceAliasStat = null;
        PreparedStatement purgeLicenseStat = null;
        try {
            purgeLicenseStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeLicenseByFabricIDSQL));
            purgeLicenseStat.setLong(1, fabricId);
            purgeLicenseStat.execute();
            purgeVsanDomainInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVsanDomainInfoByFabricIDSQL));
            purgeVsanDomainInfoStat.setLong(1, fabricId);
            purgeVsanDomainInfoStat.execute();
            purgeVsanIslInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVsanIslInfoByFabricIDSQL));
            purgeVsanIslInfoStat.setLong(1, fabricId);
            purgeVsanIslInfoStat.execute();
            purgeVsanEndPortInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVsanEndPortInfoByFabricIDSQL));
            purgeVsanEndPortInfoStat.setLong(1, fabricId);
            purgeVsanEndPortInfoStat.execute();
            purgeIvrZoneMemberStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeIvrZoneMemberByFabricIDSQL));
            purgeIvrZoneMemberStat.setLong(1, fabricId);
            purgeIvrZoneMemberStat.execute();
            purgeEndPortStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeEndPortByFabricIDSQL));
            purgeEndPortStat.setLong(1, fabricId);
            purgeEndPortStat.execute();
            purgeIvrZoneStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeIvrZoneByFabricIDSQL));
            purgeIvrZoneStat.setLong(1, fabricId);
            purgeIvrZoneStat.execute();
            purgeEnfZoneMemberStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeEnfZoneMemberByFabricIDSQL));
            purgeEnfZoneMemberStat.setLong(1, fabricId);
            purgeEnfZoneMemberStat.execute();
            purgeEnfZoneStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeEnfZoneByFabricIDSQL));
            purgeEnfZoneStat.setLong(1, fabricId);
            purgeEnfZoneStat.execute();
            purgeVsanStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVSANByFabricIDSQL));
            purgeVsanStat.setLong(1, fabricId);
            purgeVsanStat.execute();
            purgeCfsRegionStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVSANByFabricIDSQL));
            purgeCfsRegionStat.setLong(1, fabricId);
            purgeCfsRegionStat.execute();
            purgeClusterStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeClusterByFabricIDSQL));
            purgeClusterStat.setLong(1, fabricId);
            purgeClusterStat.execute();
            purgeSwitchStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeSwitchByFabricIDSQL));
            purgeSwitchStat.setLong(1, fabricId);
            purgeSwitchStat.execute();
            purgeDeviceAliasStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeDeviceAliasByFabricIDSQL));
            purgeDeviceAliasStat.setLong(1, fabricId);
            purgeDeviceAliasStat.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(purgeVsanDomainInfoStat);
                DbUtil.close(purgeVsanIslInfoStat);
                DbUtil.close(purgeVsanEndPortInfoStat);
                DbUtil.close(purgeIvrZoneMemberStat);
                DbUtil.close(purgeEndPortStat);
                DbUtil.close(purgeIvrZoneStat);
                DbUtil.close(purgeEnfZoneMemberStat);
                DbUtil.close(purgeEnfZoneStat);
                DbUtil.close(purgeVsanStat);
                DbUtil.close(purgeCfsRegionStat);
                DbUtil.close(purgeSwitchStat);
                DbUtil.close(purgeClusterStat);
                DbUtil.close(purgeDeviceAliasStat);
                DbUtil.close(purgeLicenseStat);
                throw throwable;
            }
        }
        DbUtil.close(purgeVsanDomainInfoStat);
        DbUtil.close(purgeVsanIslInfoStat);
        DbUtil.close(purgeVsanEndPortInfoStat);
        DbUtil.close(purgeIvrZoneMemberStat);
        DbUtil.close(purgeEndPortStat);
        DbUtil.close(purgeIvrZoneStat);
        DbUtil.close(purgeEnfZoneMemberStat);
        DbUtil.close(purgeEnfZoneStat);
        DbUtil.close(purgeVsanStat);
        DbUtil.close(purgeCfsRegionStat);
        DbUtil.close(purgeSwitchStat);
        DbUtil.close(purgeClusterStat);
        DbUtil.close(purgeDeviceAliasStat);
        DbUtil.close(purgeLicenseStat);
    }

    public static void purgeSwitchAndComponents(SwitchImpl sw) throws DBException, SQLException {
        if (sw == null || sw.getDBID() == 0L) {
            return;
        }
        InventoryPersistentManager.purgeSwitchAndComponents(new SwitchImpl[]{sw});
    }

    public static void purgeSwitchAndComponents(SwitchImpl[] sws) throws DBException, SQLException {
        if (sws == null || sws.length == 0) {
            return;
        }
        Connection con = null;
        FabricImpl fabric = null;
        PreparedStatement stat = null;
        boolean bool = true;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            fabric = sws[0].getFabric();
            if (fabric != null) {
                bool = fabric.attemptFabric(2, 4, _PurgeTime);
            }
            if (bool) {
                for (int i = 0; i < sws.length; ++i) {
                    if (sws[i] == null || sws[i].getDBID() == 0L) continue;
                    InventoryPersistentManager.doPurgeSwitchComponents(sws[i].getDBID(), con);
                    _Logger.debug((Object)("Purged switch and associated items: " + sws[i].getName()));
                    String sql = "delete from switch where id=" + sws[i].getDBID();
                    stat = con.prepareStatement(sql);
                    stat.execute();
                }
            }
            con.commit();
        }
        catch (InterruptedException ex) {
            _PurgeTime += 1000;
            con.rollback();
            _Logger.log((Priority)Level.WARN, (Object)"purgeSwitchComponents ", (Throwable)ex);
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeSwitchComponents ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
            if (fabric != null && bool) {
                fabric.releaseFabric(2);
            }
        }
    }

    private static void doPurgeSwitchComponents(long switchId, Connection con) throws DBException, SQLException {
        PreparedStatement purgeIslStat1 = null;
        PreparedStatement purgeIslStat2 = null;
        PreparedStatement purgeNpvStat1 = null;
        PreparedStatement purgeNpvStat2 = null;
        PreparedStatement purgeVsanDoaminIdStat = null;
        PreparedStatement purgeEndPortStat1 = null;
        PreparedStatement purgeEndPortStat2 = null;
        PreparedStatement purgeSwitchMgmtAddrStat = null;
        PreparedStatement purgeUcsBladeStat = null;
        try {
            purgeIslStat1 = con.prepareStatement(PurgeIslsBySwitchPortID1SQL);
            purgeIslStat1.setLong(1, switchId);
            purgeIslStat1.execute();
            purgeIslStat2 = con.prepareStatement(PurgeIslsBySwitchPortID2SQL);
            purgeIslStat2.setLong(1, switchId);
            purgeIslStat2.execute();
            purgeNpvStat1 = con.prepareStatement(PurgeNpvsBySwitchID1SQL);
            purgeNpvStat1.setLong(1, switchId);
            purgeNpvStat1.execute();
            purgeNpvStat2 = con.prepareStatement(PurgeNpvsBySwitchID2SQL);
            purgeNpvStat2.setLong(1, switchId);
            purgeNpvStat2.execute();
            purgeVsanDoaminIdStat = con.prepareStatement(PurgeVsanDoaminIdsBySwitchIDSQL);
            purgeVsanDoaminIdStat.setLong(1, switchId);
            purgeVsanDoaminIdStat.execute();
            purgeEndPortStat1 = con.prepareStatement(PurgeEndPortsBySwitchPortIDSQL);
            purgeEndPortStat1.setLong(1, switchId);
            purgeEndPortStat1.execute();
            purgeEndPortStat2 = con.prepareStatement(PurgePortsBySwitchIDSQL);
            purgeEndPortStat2.setLong(1, switchId);
            purgeEndPortStat2.execute();
            purgeSwitchMgmtAddrStat = con.prepareStatement(PurgeSwitchMgmtAddressBySwitchIDSQL);
            purgeSwitchMgmtAddrStat.setLong(1, switchId);
            purgeSwitchMgmtAddrStat.execute();
            purgeUcsBladeStat = con.prepareStatement(PurgeUcsBladesBySwitchIDSQL);
            purgeUcsBladeStat.setLong(1, switchId);
            purgeUcsBladeStat.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(purgeIslStat1);
                DbUtil.close(purgeIslStat2);
                DbUtil.close(purgeNpvStat1);
                DbUtil.close(purgeNpvStat2);
                DbUtil.close(purgeVsanDoaminIdStat);
                DbUtil.close(purgeEndPortStat1);
                DbUtil.close(purgeEndPortStat2);
                DbUtil.close(purgeSwitchMgmtAddrStat);
                DbUtil.close(purgeUcsBladeStat);
                throw throwable;
            }
        }
        DbUtil.close(purgeIslStat1);
        DbUtil.close(purgeIslStat2);
        DbUtil.close(purgeNpvStat1);
        DbUtil.close(purgeNpvStat2);
        DbUtil.close(purgeVsanDoaminIdStat);
        DbUtil.close(purgeEndPortStat1);
        DbUtil.close(purgeEndPortStat2);
        DbUtil.close(purgeSwitchMgmtAddrStat);
        DbUtil.close(purgeUcsBladeStat);
    }

    public void purgeIsl(IslImpl isl) throws DBException, SQLException {
        if (isl == null || isl.getDBID() == 0L) {
            return;
        }
        this.purgeIsls(new IslImpl[]{isl});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeIsls(IslImpl[] isls) throws DBException, SQLException {
        if (isls == null || isls.length == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < isls.length; ++i) {
                block12: {
                    try {
                        if (isls[i] != null && isls[i].getDBID() != 0L) break block12;
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(stat);
                        throw throwable;
                    }
                    DbUtil.close(stat);
                    continue;
                }
                this.doPurgeIslComponents(isls[i], con);
                if (isls[i].isPortChannel()) {
                    stat = con.prepareStatement("delete from isl where channel_id=" + isls[i].getDBID());
                    stat.execute();
                    _Logger.debug((Object)("Purged port-channel members for isl : " + isls[i].toString()));
                }
                stat = con.prepareStatement("delete from isl where id=" + isls[i].getDBID());
                stat.execute();
                _Logger.debug((Object)("Purged isl and associated items: " + isls[i].toString()));
                DbUtil.close(stat);
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeIsl ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    private void doPurgeIslComponents(IslImpl isl, Connection con) throws SQLException {
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        PreparedStatement stat3 = null;
        try {
            long islId = isl.getDBID();
            stat1 = con.prepareStatement(PurgeSwitchPort1ByIslIDSQL);
            stat1.setLong(1, islId);
            stat1.execute();
            stat2 = con.prepareStatement(PurgeSwitchPort2ByIslIDSQL);
            stat2.setLong(1, islId);
            stat2.execute();
            stat3 = con.prepareStatement(PurgeVsanIslInfoByIslIDSQL);
            stat3.setLong(1, islId);
            stat3.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                DbUtil.close(stat3);
                throw throwable;
            }
        }
        DbUtil.close(stat1);
        DbUtil.close(stat2);
        DbUtil.close(stat3);
    }

    public void purgeNpvLink(NpvLinkImpl npvl) throws DBException, SQLException {
        if (npvl == null || npvl.getDBID() == 0L) {
            return;
        }
        this.purgeNpvLinks(new NpvLinkImpl[]{npvl});
    }

    public void purgeNpvLinks(NpvLinkImpl[] npvls) throws DBException, SQLException {
        if (npvls == null || npvls.length == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < npvls.length; ++i) {
                if (npvls[i] == null || npvls[i].getDBID() == 0L) continue;
                this.doPurgeNpvlComponents(npvls[i], con);
                stat = con.prepareStatement("delete from npv_link where id=" + npvls[i].getDBID());
                stat.execute();
                _Logger.debug((Object)("Purged npvl and associated items: " + npvls[i].toString()));
                stat.close();
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeNpvl ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    private void doPurgeNpvlComponents(NpvLinkImpl npvl, Connection con) throws SQLException {
        PreparedStatement stat1 = null;
        try {
            long npvlId = npvl.getDBID();
            stat1 = con.prepareStatement(PurgeVsanNpvlInfoByNpvlIDSQL);
            stat1.setLong(1, npvlId);
            stat1.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat1);
                throw throwable;
            }
        }
        DbUtil.close(stat1);
    }

    public void purgeEndPort(EndPortImpl ep) throws DBException, SQLException {
        if (ep == null || ep.getDBID() == 0L) {
            return;
        }
        this.purgeEndPorts(new EndPortImpl[]{ep});
    }

    public void purgeEndPorts(EndPortImpl[] eps) throws DBException, SQLException {
        if (eps == null || eps.length == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < eps.length; ++i) {
                if (eps[i] == null || eps[i].getDBID() == 0L) continue;
                this.doPurgeEndPortComponents(eps[i], con);
                stat = con.prepareStatement("delete from end_port where id= ?");
                stat.setLong(1, eps[i].getDBID());
                stat.execute();
                stat.close();
                _Logger.debug((Object)("Purged end port and associated items: " + eps[i].toString()));
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeEndPort ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public void purgeSwitchPort(FcPortImpl port) throws DBException, SQLException {
        if (port == null || port.getDBID() == 0L) {
            return;
        }
        this.purgeSwitchPorts(new FcPortImpl[]{port});
    }

    public void purgeSwitchPorts(FcPortImpl[] ports) throws DBException, SQLException {
        if (ports == null || ports.length == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (FcPortImpl port : ports) {
                if (port.getDBID() == 0L) continue;
                stat = con.prepareStatement("delete from switch_port where id= ?");
                stat.setLong(1, port.getDBID());
                stat.execute();
                stat.close();
                if (!_Logger.isDebugEnabled()) continue;
                _Logger.debug((Object)("Purged switch port: " + port));
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeSwitchPorts ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public void purgeDupEndPorts(EndPortImpl[] eps) throws DBException, SQLException {
        if (eps == null || eps.length == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < eps.length; ++i) {
                if (eps[i] == null || eps[i].getDBID() == 0L) continue;
                this.doPurgeVsanEndPorts(eps[i], con);
                stat = con.prepareStatement("delete from end_port where id=" + eps[i].getDBID());
                stat.execute();
                stat.close();
                _Logger.debug((Object)("Purged end port and associated items: " + eps[i].toString()));
            }
            con.commit();
        }
        catch (SQLException sqlex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"purgeEndPort ", (Throwable)sqlex);
            throw sqlex;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    private void doPurgeEndPortComponents(EndPortImpl ep, Connection con) throws SQLException {
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        try {
            long epId = ep.getDBID();
            stat1 = con.prepareStatement(PurgeSwitchPortByEndPortIDSQL);
            stat1.setLong(1, epId);
            stat1.execute();
            stat2 = con.prepareStatement(PurgeVsanEndPortInfoByEndPortIDSQL);
            stat2.setLong(1, epId);
            stat2.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                throw throwable;
            }
        }
        DbUtil.close(stat1);
        DbUtil.close(stat2);
    }

    private void doPurgeVsanEndPorts(EndPortImpl ep, Connection con) throws SQLException {
        PreparedStatement stat = null;
        try {
            long epId = ep.getDBID();
            stat = con.prepareStatement(PurgeVsanEndPortInfoByEndPortIDSQL);
            stat.setLong(1, epId);
            stat.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(stat);
    }

    public void purgeEnclosure(EnclosureImpl enclosure) throws DBException, SQLException {
        if (enclosure == null || enclosure.getDBID() == 0L) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            this.doPurgeEnclosureComponents(enclosure, con);
            stat = con.prepareStatement("delete from enclosure where id=" + enclosure.getDBID());
            stat.execute();
            con.commit();
            _Logger.debug((Object)("Purged enclosure and associated items: " + enclosure.toString()));
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
                _Logger.log((Priority)Level.WARN, (Object)"purgeEndclosure ", (Throwable)sqlex);
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private void doPurgeEnclosureComponents(EnclosureImpl enclosure, Connection con) throws SQLException {
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        try {
            long ecId = enclosure.getDBID();
            stat1 = con.prepareStatement(PurgeHbaByEnclosureIDSQL);
            stat1.setLong(1, ecId);
            stat1.execute();
            stat2 = con.prepareStatement(PurgeScsiTargetByEnclosureIDSQL);
            stat2.setLong(1, ecId);
            stat2.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                throw throwable;
            }
        }
        DbUtil.close(stat1);
        DbUtil.close(stat2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPreexistRecord(DBObjectIf obj, PreparedStatement stat) throws SQLException {
        if (obj == null || stat == null) {
            return;
        }
        ResultSet rs = null;
        try {
            rs = stat.executeQuery();
            if (rs.next()) {
                if (obj instanceof VsanDomainImpl || obj instanceof VsanISLImpl || obj instanceof VsanNxPortImpl || obj instanceof EnclDataStoreImpl || obj instanceof VmDataStoreImpl || obj instanceof VmPhynicImpl) {
                    obj.setDBID(1L);
                } else {
                    obj.setDBID(rs.getLong(1));
                }
            } else {
                obj.setDBID(0L);
            }
        }
        finally {
            DbUtil.close(rs);
        }
    }

    private String getInsertSQL(String table, String[] cols) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("insert into ").append(table).append(" (");
        for (i = 0; i < cols.length - 1; ++i) {
            buf.append(cols[i]).append(", ");
        }
        buf.append(cols[cols.length - 1]).append(") values ( ");
        for (i = 0; i < cols.length - 1; ++i) {
            buf.append("?, ");
        }
        buf.append("?) ");
        return buf.toString();
    }

    private String getUpdateSQL(String table, String[] cols) {
        StringBuffer buf = new StringBuffer();
        buf.append("update ").append(table).append(" set ");
        for (int i = 1; i < cols.length - 1; ++i) {
            buf.append(cols[i]).append("=?, ");
        }
        buf.append(cols[cols.length - 1]).append("=? ");
        buf.append("where ").append(cols[0]).append(" =? ");
        return buf.toString();
    }

    private String getDeleteSQL(String table, String[] cols) {
        StringBuffer buf = new StringBuffer();
        buf.append("delete from ").append(table);
        buf.append(" where ").append(cols[0]).append(" =? ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet loadDeviceAliasIds(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        HashSet<Long> hash = new HashSet<Long>();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(this._loadDeviceAliasIdsSQL);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                hash.add(new Long(rs.getLong(1)));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(stat);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList loadDeviceAliasFromDB(FabricImpl fImpl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QueryDeviceAliasSQLByFabricID);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            arrayList = this.loadDeviceAliasDBRecord(rs, fImpl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public ArrayList loadDeviceAliasDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        ArrayList<FcPortAlias> al = new ArrayList<FcPortAlias>();
        while (rs.next()) {
            FcPortAlias da;
            Wwn wwn = null;
            try {
                wwn = new Wwn(rs.getBytes(3));
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((da = fImpl.createDeviceAlias(wwn, rs.getString(4), rs.getLong(1), rs.getInt(2))) == null) continue;
            da.setDBID(rs.getLong(1));
            al.add(da);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet loadNpvLinkIds(FabricImpl fImpl, Connection con) throws DBException, SQLException {
        HashSet<Long> hash = new HashSet<Long>();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(this._loadNpvLinkIdsSQL);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                hash.add(new Long(rs.getLong(1)));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(stat);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList loadNpvLinkFromDB(FabricImpl fImpl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QueryNpvLinksSQLByFabricID);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            arrayList = this.loadNpvLinkDBRecord(rs, fImpl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public ArrayList loadNpvLinkDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        ArrayList<NpvLinkImpl> al = new ArrayList<NpvLinkImpl>();
        while (rs.next()) {
            SwitchImpl flogiSw = fImpl.findSwitchByDbId(rs.getLong(2));
            SwitchImpl npvSw = fImpl.findSwitchByDbId(rs.getLong(3));
            if (npvSw == null || flogiSw == null) continue;
            if (!rs.getBoolean(11)) {
                byte[] bfwwn = rs.getBytes(4);
                byte[] bnpwwn = rs.getBytes(5);
                int fpIfindex = rs.getInt(9);
                int npIfindex = rs.getInt(10);
                if (fpIfindex != -1 && npIfindex != -1) {
                    NpvLinkImpl npvl = fImpl.createNpvLink(flogiSw, npvSw, fpIfindex, npIfindex, bfwwn, bnpwwn);
                    npvl.setOperStatusCause(rs.getInt(6));
                    npvl.setSpeed(rs.getLong(7));
                    npvl.setPresent(rs.getBoolean(8));
                    npvl.setLastScanTime(rs.getLong(13));
                    npvl.setDBID(rs.getLong(1));
                    al.add(npvl);
                    fImpl.addNpvl(npvl);
                    continue;
                }
                _Logger.warn((Object)("Inventory load -- skip the NP link cannot resolve the ifindex:" + flogiSw.getSwitchPK() + "/" + SnmpString.toHexString(bfwwn) + " <-> " + npvSw.getSwitchPK() + "/" + SnmpString.toHexString(bnpwwn)));
                continue;
            }
            int[] ifs = new int[]{rs.getInt(9), rs.getInt(10)};
            fImpl.addChannelMember(rs.getLong(12), ifs);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet loadFcAliasIds(VsanImpl vsan, Connection con) throws DBException, SQLException {
        HashSet<Long> hash = new HashSet<Long>();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(this._loadFcAliasIdsSQL);
            stat.setLong(1, vsan.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                hash.add(new Long(rs.getLong(1)));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(stat);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList loadFcAliasFromDB(VsanImpl vImpl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QueryFcAliasSQLByVsanID);
            stat.setLong(1, vImpl.getDBID());
            rs = stat.executeQuery();
            arrayList = this.loadFcAliasDBRecord(rs, vImpl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public ArrayList loadFcAliasDBRecord(ResultSet rs, VsanImpl vImpl) throws SQLException {
        ArrayList<FcPortAlias> al = new ArrayList<FcPortAlias>();
        while (rs.next()) {
            Wwn wwn = null;
            try {
                wwn = new Wwn(rs.getBytes(2));
            }
            catch (Exception ex) {
                // empty catch block
            }
            FcPortAlias da = vImpl.createFcAlias(wwn, rs.getString(3));
            da.setDBID(rs.getLong(1));
            al.add(da);
        }
        return al;
    }

    public ArrayList loadPersistentVirtualCentersFromDB() throws SQLException {
        ArrayList al = VirtualCenterImpl.loadPersistentVirtualCentersFromDB();
        if (al == null) {
            return null;
        }
        return al;
    }

    public void purgeVirtualCenter(long dbId) throws DBException, SQLException {
        if (dbId == 0L) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            InventoryPersistentManager.doPurgeVCenterComponents(dbId, con);
            stat = con.prepareStatement("delete from vcenter where id=" + dbId);
            stat.execute();
            con.commit();
            _Logger.debug((Object)("Purged vc and associated items. VCenter dbId : " + dbId));
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
                _Logger.log((Priority)Level.WARN, (Object)"purgeEndclosure ", (Throwable)sqlex);
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void purgeVirtualCenter(VirtualCenterImpl vc) throws DBException, SQLException {
        if (vc == null || vc.getDBID() == 0L) {
            return;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            InventoryPersistentManager.doPurgeVCenterComponents(vc.getDBID(), con);
            stat = con.prepareStatement("delete from vcenter where id=" + vc.getDBID());
            stat.execute();
            con.commit();
            _Logger.debug((Object)("Purged vc and associated items: " + vc.toString()));
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
                _Logger.log((Priority)Level.WARN, (Object)"purgeEndclosure ", (Throwable)sqlex);
                throw sqlex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private static void doPurgeVCenterComponents(long vcId, Connection con) throws SQLException {
        PreparedStatement purgeVmStat = null;
        PreparedStatement purgeVHostStat = null;
        PreparedStatement purgePhynicStat = null;
        PreparedStatement purgeVnicStat = null;
        Object purgeClusterStat = null;
        PreparedStatement purgeDatastoreStat = null;
        PreparedStatement purgeVmDataStoreInfoStat = null;
        PreparedStatement purgeVmPhynicInfoStat = null;
        PreparedStatement purgeEnclDataStoreInfoStat = null;
        PreparedStatement updateEnclosureStat = null;
        PreparedStatement purgeHostStat = null;
        PreparedStatement purgeHostMapStat = null;
        PreparedStatement purgeLanHostStat = null;
        try {
            purgeVmDataStoreInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVmDataStoreInfoByVCIDSQL));
            purgeVmDataStoreInfoStat.setLong(1, vcId);
            purgeVmDataStoreInfoStat.execute();
            purgeEnclDataStoreInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeEnclDataStoreInfoByVCIDSQL));
            purgeEnclDataStoreInfoStat.setLong(1, vcId);
            purgeEnclDataStoreInfoStat.execute();
            purgeDatastoreStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeDataStoreByVCIDSQL));
            purgeDatastoreStat.setLong(1, vcId);
            purgeDatastoreStat.execute();
            purgeVmPhynicInfoStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVmPhynicInfoByVCIDSQL));
            purgeVmPhynicInfoStat.setLong(1, vcId);
            purgeVmPhynicInfoStat.execute();
            purgeVmStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVmByVCIDSQL));
            purgeVmStat.setLong(1, vcId);
            purgeVmStat.execute();
            updateEnclosureStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeEnclosureByVCIDSQL));
            updateEnclosureStat.setLong(1, vcId);
            updateEnclosureStat.execute();
            purgePhynicStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgePhynicByVCIDSQL));
            purgePhynicStat.setLong(1, vcId);
            purgePhynicStat.execute();
            purgeVnicStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVnicByVCIDSQL));
            purgeVnicStat.setLong(1, vcId);
            purgeVnicStat.execute();
            purgeHostStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeHostByVCIDSQL));
            purgeHostStat.setLong(1, vcId);
            purgeHostStat.execute();
            purgeHostMapStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeHostMapByVCIDSQL));
            purgeHostMapStat.setLong(1, vcId);
            purgeHostMapStat.setLong(2, vcId);
            purgeHostMapStat.execute();
            purgeLanHostStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeLanHostByVCIDSQL));
            purgeLanHostStat.setLong(1, vcId);
            purgeLanHostStat.execute();
            purgeVHostStat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(PurgeVHostByVCIDSQL));
            purgeVHostStat.setLong(1, vcId);
            purgeVHostStat.execute();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(purgeVmDataStoreInfoStat);
                DbUtil.close(purgeVmPhynicInfoStat);
                DbUtil.close(purgeEnclDataStoreInfoStat);
                DbUtil.close(purgeDatastoreStat);
                DbUtil.close(purgeVmStat);
                DbUtil.close(purgeVHostStat);
                DbUtil.close(purgeVnicStat);
                DbUtil.close(purgePhynicStat);
                DbUtil.close(updateEnclosureStat);
                DbUtil.close(purgeHostStat);
                DbUtil.close(purgeHostMapStat);
                DbUtil.close(purgeLanHostStat);
                throw throwable;
            }
        }
        DbUtil.close(purgeVmDataStoreInfoStat);
        DbUtil.close(purgeVmPhynicInfoStat);
        DbUtil.close(purgeEnclDataStoreInfoStat);
        DbUtil.close(purgeDatastoreStat);
        DbUtil.close(purgeVmStat);
        DbUtil.close(purgeVHostStat);
        DbUtil.close(purgeVnicStat);
        DbUtil.close(purgePhynicStat);
        DbUtil.close(updateEnclosureStat);
        DbUtil.close(purgeHostStat);
        DbUtil.close(purgeHostMapStat);
        DbUtil.close(purgeLanHostStat);
    }
}

