/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.jaxws.san.wo.ConfigFileInfoDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.sm.common.model.FileWrapper;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.PersistentWrapperIf;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.CLOB;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class OracleWrapper
extends TimerTask
implements PersistentWrapperIf {
    Field _stmtField = null;
    Field _connField = null;
    Field _resField = null;
    public static Logger _Logger = LogManager.getLogger((String)"FM.db");
    Timer _timer;
    private static long DAY_IN_MILLI = 86400000L;
    private static long HOUR_IN_MILLI = 3600000L;

    private void init() {
        this._timer = new Timer();
        DAY_IN_MILLI = Long.getLong("db.cleanInterval", 86400000L);
        this._timer.schedule((TimerTask)this, HOUR_IN_MILLI, DAY_IN_MILLI);
    }

    OracleWrapper() {
        try {
            Class<?> classObj = Class.forName("org.apache.commons.dbcp.DelegatingPreparedStatement");
            this._stmtField = classObj.getDeclaredField("_stmt");
            this._stmtField.setAccessible(true);
            classObj = Class.forName("org.apache.commons.dbcp.cpdsadapter.ConnectionImpl");
            this._connField = classObj.getDeclaredField("connection");
            this._connField.setAccessible(true);
            classObj = Class.forName("org.apache.commons.dbcp.DelegatingResultSet");
            this._resField = classObj.getDeclaredField("_res");
            this._resField.setAccessible(true);
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setStatementCacheSize(Connection conn, int size) throws SQLException {
        OracleConnection oconn = (OracleConnection)this.getConnField(conn);
        if (oconn != null) {
            oconn.setStatementCacheSize(size);
        }
    }

    @Override
    public void run() {
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
        }
        catch (SQLException ex) {
            return;
        }
        try {
            stat = con.prepareStatement("delete from config_file where last_update_time < ?");
            long days = Long.getLong("configFile.Days2Keep", 90L);
            long elapse = days * 24L * 3600L * 1000L;
            stat.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
            int deletedRow = stat.executeUpdate();
            PersistentHelper._Logger.debug((Object)("purge config file: " + deletedRow));
            stat.close();
            stat = con.prepareStatement("delete from events where last_seen < ?");
            days = Long.getLong("events.Days2Keep", 90L);
            elapse = days * 24L * 3600L * 1000L;
            stat.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
            deletedRow = stat.executeUpdate();
            PersistentHelper._Logger.debug((Object)("purge events: " + deletedRow));
            stat.close();
            stat = con.prepareStatement("delete from accounting where last_seen < ?");
            stat.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
            deletedRow = stat.executeUpdate();
            PersistentHelper._Logger.debug((Object)("purge accounting: " + deletedRow));
            stat.close();
            stat = con.prepareStatement("delete from zone where last_update_time < ?");
            days = 3L;
            elapse = days * 24L * 3600L * 1000L;
            stat.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
            deletedRow = stat.executeUpdate();
            PersistentHelper._Logger.debug((Object)("purge zombie zone: " + deletedRow));
            stat.close();
            stat = con.prepareStatement("delete from zone_member where last_update_time < ?");
            days = 3L;
            elapse = days * 24L * 3600L * 1000L;
            stat.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
            deletedRow = stat.executeUpdate();
            PersistentHelper._Logger.debug((Object)("purge zombie zone_memeber: " + deletedRow));
            long rptElapse = 7776000000L;
            ReportUtil.cleanOldReports(this.getCurrentServerIP(), rptElapse, new File(ClientCache.getReportsDir()));
            this.cleanCapacityData();
        }
        catch (SQLException ex) {
            PersistentHelper._Logger.debug((Object)(" purge config file failed:" + ex.getMessage()));
            return;
        }
        catch (Exception ex) {
            PersistentHelper._Logger.debug((Object)(" purge config file failed:" + ex.getMessage()));
            return;
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanCapacityData() {
        boolean ret;
        block7: {
            ret = false;
            ResultSet rs = null;
            PreparedStatement stmt = null;
            Connection conn = null;
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.prepareStatement("select max(id) from capacity_time where update_date < ?");
                long days = Long.getLong("capacity.Days2Keep", 365L);
                long elapse = days * 24L * 3600L * 1000L;
                stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis() - elapse));
                rs = stmt.executeQuery();
                long timeId = -1L;
                while (rs.next()) {
                    timeId = rs.getLong(1);
                }
                if (timeId >= 1L) {
                    DbUtil.close(stmt);
                    stmt = conn.prepareStatement("delete from capacity_data where time_id < ?");
                    stmt.setLong(1, timeId);
                    int deletedRow = stmt.executeUpdate();
                    PersistentHelper._Logger.info((Object)("purge capacity_data: " + deletedRow + " rows; timeId is: " + timeId));
                    stmt.close();
                    stmt = conn.prepareStatement("delete from capacity_data_smis where time_id < ?");
                    stmt.setLong(1, timeId);
                    deletedRow = stmt.executeUpdate();
                    PersistentHelper._Logger.info((Object)("purge capacity_data_smis: " + deletedRow + " rows; timeId is: " + timeId));
                    stmt.close();
                    stmt = conn.prepareStatement("delete from capacity_data_smis_lun where time_id < ?");
                    stmt.setLong(1, timeId);
                    deletedRow = stmt.executeUpdate();
                    PersistentHelper._Logger.info((Object)("purge capacity_data_smis_lun: " + deletedRow + " rows; timeId is: " + timeId));
                    stmt.close();
                    stmt = conn.prepareStatement("delete from capacity_time where id < ?");
                    stmt.setLong(1, timeId);
                    deletedRow = stmt.executeUpdate();
                    PersistentHelper._Logger.info((Object)("purge capacity_time: " + deletedRow + " rows; timeId is: " + timeId));
                    ret = true;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                PersistentHelper._Logger.warn((Object)(" clean up capacity data failed:" + ex.getMessage()));
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        return ret;
    }

    public String getCurrentServerIP() throws Exception {
        int id = ClusterSequence.getSequence().getServerId();
        InetAddress adr = ClusterMapping.getInstance().qIPFromSId(id);
        return adr.getHostAddress();
    }

    private Connection getConnField(Object obj) {
        try {
            if (this._connField != null) {
                return (Connection)this._connField.get(obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private PreparedStatement getStmtField(Object obj) {
        try {
            return (PreparedStatement)this._stmtField.get(obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ResultSet getResField(Object obj) {
        try {
            return (ResultSet)this._resField.get(obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean getBooleanFromStringField(ResultSet rs, String colName) throws SQLException {
        return rs.getString(colName).equals("1");
    }

    @Override
    public String getQueryString(String in) {
        String ret = in.replaceAll("true", "1");
        ret = ret.replaceAll("false", "0");
        ret = ret.replaceAll("FALSE", "0");
        ret = ret.replaceAll("TRUE", "1");
        ret = ret.replaceAll("CONVERT", "TO_CHAR");
        ret = ret.replaceAll(".VARCHAR", "");
        ret = ret.replaceAll("encode", "rawtohex");
        ret = ret.replaceAll("ENCODE", "RAWTOHEX");
        ret = ret.replaceAll(",'hex'", "");
        ret = ret.replaceAll(", 'hex'", "");
        return ret;
    }

    @Override
    public Boolean isOracleDB() {
        return true;
    }

    @Override
    public Boolean isPostgresDB() {
        return false;
    }

    @Override
    public int[] getIntArray(ResultSet rs, int pos) throws SQLException {
        byte[] values = rs.getBytes(pos);
        if (values == null) {
            return null;
        }
        int[] ret = new int[values.length / 4];
        for (int i = 0; i < ret.length; ++i) {
            byte temp1 = values[i * 4];
            byte temp2 = values[i * 4 + 1];
            byte temp3 = values[i * 4];
            byte temp4 = values[i * 4 + 1];
            ret[i] = temp1 << 24 | temp2 << 16 | temp3 << 8 | temp4;
        }
        return ret;
    }

    @Override
    public long[] getLongArray(ResultSet rs, int pos) throws SQLException {
        byte[] values = rs.getBytes(pos);
        if (values == null) {
            return null;
        }
        long[] ret = new long[values.length / 8];
        for (int i = 0; i < ret.length; ++i) {
            long temp1 = values[i * 8];
            long temp2 = values[i * 8 + 1];
            long temp3 = values[i * 8 + 2];
            long temp4 = values[i * 8 + 3];
            long temp5 = values[i * 8 + 4];
            long temp6 = values[i * 8 + 5];
            long temp7 = values[i * 8 + 6];
            long temp8 = values[i * 8 + 7];
            ret[i] = temp1 << 56 | temp2 << 48 | temp3 << 40 | temp4 << 32 | temp5 << 24 | temp6 << 16 | temp7 << 8 | temp8;
        }
        return ret;
    }

    @Override
    public void setLongArray(PreparedStatement stat, long[] values, int pos) throws SQLException {
        if (values == null || values.length == 0) {
            stat.setNull(pos, -2);
            return;
        }
        byte[] setValues = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            setValues[i * 8] = (byte)(values[i] >> 56 & 0xFFL);
            setValues[i * 8 + 1] = (byte)(values[i] >> 48 & 0xFFL);
            setValues[i * 8 + 2] = (byte)(values[i] >> 40 & 0xFFL);
            setValues[i * 8 + 3] = (byte)(values[i] >> 32 & 0xFFL);
            setValues[i * 8 + 4] = (byte)(values[i] >> 24 & 0xFFL);
            setValues[i * 8 + 5] = (byte)(values[i] >> 16 & 0xFFL);
            setValues[i * 8 + 6] = (byte)(values[i] >> 8 & 0xFFL);
            setValues[i * 8 + 7] = (byte)(values[i] & 0xFFL);
        }
        stat.setBytes(pos, setValues);
    }

    @Override
    public void setIntArray(PreparedStatement stat, int[] values, int pos) throws SQLException {
        if (values == null || values.length == 0) {
            stat.setNull(pos, -2);
            return;
        }
        byte[] setValues = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            setValues[i * 4] = (byte)(values[i] >> 24 & 0xFF);
            setValues[i * 4 + 1] = (byte)(values[i] >> 16 & 0xFF);
            setValues[i * 4 + 2] = (byte)(values[i] >> 8 & 0xFF);
            setValues[i * 4 + 3] = (byte)(values[i] & 0xFF);
        }
        stat.setBytes(pos, setValues);
    }

    @Override
    public void setBinaryDouble(PreparedStatement stat, double value, int pos) throws SQLException {
        BINARY_DOUBLE biD = new BINARY_DOUBLE(value);
        OraclePreparedStatement opstmt = (OraclePreparedStatement)this.getStmtField(stat);
        if (opstmt == null) {
            throw new SQLException("PersistentHelper.setBinaryDouble : opstmt is null");
        }
        opstmt.setBinaryDouble(pos, biD);
    }

    @Override
    public double getDouble(ResultSet rs, int pos) throws SQLException {
        Double value = (Double)rs.getObject(pos);
        return value;
    }

    @Override
    public double getPmDouble(ResultSet rs, int pos) throws SQLException {
        Double value = (Double)rs.getObject(pos);
        if (value == null) {
            return Double.NaN;
        }
        double dValue = value;
        return dValue < 0.0 ? Double.NaN : dValue;
    }

    @Override
    public String getNanVL(String columnName) {
        return " nanvl(" + columnName + ", 0) ";
    }

    @Override
    public void tableAnalyze() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long retrieveFile(long date, File destination, String userName, String tableName) throws Exception {
        long checkSum;
        ResultSet rs;
        Statement st;
        Connection conn;
        block12: {
            long timeStamp;
            block11: {
                conn = null;
                st = null;
                rs = null;
                checkSum = 0L;
                try {
                    conn = ConnectionManager.getConnection();
                    st = conn.createStatement();
                    String sql1 = "SELECT document_name, last_update_time from " + tableName;
                    rs = st.executeQuery(sql1);
                    long prevTmStamp = date;
                    String docName = null;
                    while (rs.next()) {
                        timeStamp = rs.getTimestamp(2).getTime();
                        if (docName == null) {
                            docName = rs.getString(1);
                            prevTmStamp = timeStamp;
                            continue;
                        }
                        if (timeStamp > date) {
                            if (timeStamp - date >= date - prevTmStamp) break;
                            docName = rs.getString(1);
                            prevTmStamp = timeStamp;
                            break;
                        }
                        prevTmStamp = timeStamp;
                        docName = rs.getString(1);
                    }
                    if (docName == null) {
                        timeStamp = -1L;
                        DbUtil.close(rs);
                        break block11;
                    }
                    String sql = "SELECT content, checksum  FROM " + tableName + "  WHERE document_name = '" + docName + "' and user_name = '" + userName + "'";
                    rs = st.executeQuery(sql);
                    while (rs.next()) {
                        String str = rs.getString(1);
                        FileOutputStream fos = new FileOutputStream(destination);
                        fos.write(str.getBytes());
                        fos.close();
                        checkSum = rs.getLong(2);
                    }
                    _Logger.info((Object)("Document: " + docName + " retrieved successfully."));
                    DbUtil.close(rs);
                    break block12;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    return checkSum;
                }
            }
            DbUtil.close(st);
            DbUtil.close(conn);
            return timeStamp;
        }
        DbUtil.close(st);
        DbUtil.close(conn);
        return checkSum;
        finally {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    @Override
    public long retrieveFile(String fileName, File destination, String userName) throws Exception {
        return this.retrieveFile(fileName, destination, userName, "xmlDocs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long retrieveFile(String fileName, File destination, String userName, String tableName) throws Exception {
        long checkSum;
        block6: {
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            checkSum = 0L;
            try {
                conn = ConnectionManager.getConnection();
                st = conn.createStatement();
                String sql = "SELECT content, checksum  FROM " + tableName + "  WHERE document_name = '" + fileName + "' and user_name = '" + userName + "'";
                _Logger.debug((Object)("retrieveFile() path: " + destination.getPath()));
                _Logger.debug((Object)("retrieveFile()  sql: " + sql));
                rs = st.executeQuery(sql);
                while (rs.next()) {
                    String str = rs.getString(1);
                    FileOutputStream fos = new FileOutputStream(destination);
                    fos.write(str.getBytes());
                    fos.close();
                    checkSum = rs.getLong(2);
                }
                _Logger.info((Object)("Document: " + fileName + " retrieved successfully."));
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(st);
                DbUtil.close(conn);
            }
            DbUtil.close(st);
            DbUtil.close(conn);
        }
        return checkSum;
    }

    @Override
    public ArrayList retrieveDocNames(String prefix, String userName, String tableName) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ConfigFileInfoDO> filelistInfo = new ArrayList<ConfigFileInfoDO>();
        try {
            conn = ConnectionManager.getConnection();
            String sql = SQLLoader.getSqlStmt("PersistantAction.GET_CONFIG_FILE");
            stmt = conn.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                ConfigFileInfoDO flDo = new ConfigFileInfoDO();
                String ipAddress = "";
                String keyName = rs.getString(1);
                int ipLimit = keyName.indexOf(45);
                if (ipLimit != -1) {
                    ipAddress = keyName.substring(0, ipLimit);
                }
                long checksum = rs.getLong(2);
                long timeStamp = rs.getTimestamp(3).getTime();
                long filesize = rs.getLong(4);
                if (prefix != null && !ipAddress.startsWith(prefix)) continue;
                flDo.setSwitchIpAddress(ipAddress);
                flDo.setConfigFiles(keyName);
                flDo.setConfigFileCheckSum(checksum);
                flDo.setConfigTimeStamp(timeStamp);
                flDo.setConfigFileFileSize(DefaultSnmpNumberRenderer.formatLong(filesize, DefaultSnmpNumberRenderer.NUM_FORMAT_0_PREC));
                filelistInfo.add(flDo);
            }
            _Logger.info((Object)("Document Names: " + (prefix != null ? prefix : "all names") + " retrieved successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(conn);
        Collections.sort(filelistInfo);
        return filelistInfo;
    }

    @Override
    public void deleteFile(String fileName) throws Exception {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();
            String sqlText = "DELETE FROM CONFIG_FILE WHERE document_name = ?";
            stmt = conn.prepareStatement(sqlText);
            stmt.setString(1, fileName);
            stmt.execute();
            conn.commit();
            _Logger.info((Object)("Document: " + fileName + " delete from database successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(String fileName, String userName, String tablename, boolean silent) throws Exception {
        block6: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            Connection conn = null;
            try {
                conn = ConnectionManager.getConnection();
                String sqlText = "DELETE FROM " + tablename + " WHERE document_name = '" + fileName + "' and user_name = '" + userName + "'";
                _Logger.debug((Object)("deleteFile() sql: " + sqlText));
                stmt = conn.prepareStatement(sqlText);
                stmt.execute();
                conn.commit();
                _Logger.info((Object)("Document: " + fileName + " delete from database successfully."));
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                if (!silent) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    throw new Exception(ex);
                }
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public ArrayList getSwitchCheckSumsDescendingByTime(String ipAddress, String configType) throws Exception {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        ArrayList<Long> chkSums = new ArrayList<Long>();
        try {
            conn = ConnectionManager.getConnection();
            String sqlLastSwitchBackup = "select checksum from config_file where document_name LIKE ?  ORDER BY last_update_time DESC";
            stmt = conn.prepareStatement(sqlLastSwitchBackup);
            stmt.setString(1, ipAddress + "%" + configType);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                chkSums.add(rs.getLong(1));
            }
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(conn);
        return chkSums;
    }

    @Override
    public void storeFile(File file, String userName) throws Exception {
        this.storeFile(file, userName, "xmlDocs");
    }

    @Override
    public void storeFile(File file, String userName, String tablename) throws Exception {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            int bytesRead;
            conn = ConnectionManager.getConnection();
            FileInputStream fis = new FileInputStream(file);
            long checkSum = ReportUtil.getFileCheckSum(file, '!');
            String sqlText = "INSERT INTO " + tablename + " (document_name, user_name, content, checksum, last_update_time, filesize) " + "   VALUES('" + file.getName() + "','" + userName + "', EMPTY_CLOB(),?,?, ?)";
            _Logger.debug((Object)("storeFile() path: " + file.getPath()));
            _Logger.debug((Object)("storeFile()  sql: " + sqlText));
            stmt = conn.prepareStatement(sqlText);
            stmt.setLong(1, checkSum);
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stmt.setLong(3, file.length());
            _Logger.info((Object)("PersistentHelper:" + sqlText + "\n"));
            stmt.execute();
            sqlText = " SELECT content  FROM  " + tablename + " WHERE  document_name = '" + file.getName() + "'  " + " FOR UPDATE";
            stmt.clearBatch();
            stmt.clearParameters();
            stmt.close();
            stmt = conn.prepareStatement(sqlText);
            _Logger.info((Object)("PersistentHelper:" + sqlText + "\n"));
            rs = stmt.executeQuery(sqlText);
            rs.next();
            CLOB docContent = ((OracleResultSet)this.getResField(rs)).getCLOB("content");
            int bufferSize = docContent.getBufferSize();
            byte[] buffer = new byte[bufferSize];
            OutputStream clobOs = docContent.setAsciiStream(1L);
            while ((bytesRead = fis.read(buffer)) != -1) {
                clobOs.write(buffer, 0, bytesRead);
            }
            fis.close();
            clobOs.close();
            conn.commit();
            _Logger.info((Object)("Document: " + file.getName() + " inserted into database successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(conn);
    }

    @Override
    public void storeBackupServerData(int serverType, String userName, String password, String rootDir) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDbForAllReportsInDir(File reportDir, String base, Map dataMap, String serverIpAdd) {
        block10: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                FileWrapper wrp;
                ArrayList<FileWrapper> lclRpts = ReportUtil.getLocalReports(reportDir, base, dataMap, serverIpAdd, true);
                HashMap<String, FileWrapper> flMap = new HashMap<String, FileWrapper>();
                for (int i = 0; i < lclRpts.size(); ++i) {
                    wrp = lclRpts.get(i);
                    flMap.put(wrp.getFile().getAbsolutePath(), wrp);
                }
                conn = ConnectionManager.getConnection();
                ps = conn.prepareStatement("select * from reports_properties where server=?");
                ps.setString(1, serverIpAdd);
                rs = ps.executeQuery();
                String insQuery = "insert into reports_properties (writable,LAST_UPDATE_TIME, server,name) VALUES (?, ?, ?, ?)";
                wrp = null;
                String reportName = "";
                while (rs.next()) {
                    reportName = rs.getString(2);
                    wrp = (FileWrapper)flMap.get(reportName);
                    if (wrp == null) {
                        this.deleteReportFileWriteFlag(serverIpAdd, reportName);
                        continue;
                    }
                    flMap.remove(reportName);
                }
                DbUtil.close(ps);
                for (Map.Entry obEntry : flMap.entrySet()) {
                    wrp = (FileWrapper)obEntry.getValue();
                    insQuery = "insert into reports_properties (writable,LAST_UPDATE_TIME, server,name) VALUES (?, ?, ?, ?)";
                    ps = conn.prepareStatement(insQuery);
                    if (wrp != null) {
                        reportName = wrp.getFile().getAbsolutePath();
                        ps.setInt(1, wrp.isReadOnly() ? 1 : 2);
                        ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                        ps.setString(3, serverIpAdd);
                        ps.setString(4, reportName);
                    }
                    ps.executeUpdate();
                    _Logger.info((Object)("Add Report_properties: " + reportName + " on server " + new SnmpIpAddress(serverIpAdd).toString() + " as " + (!wrp.isReadOnly() ? "writable" : "readonly")));
                    DbUtil.close(ps);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(ps);
                DbUtil.close(conn);
            }
            DbUtil.close(ps);
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setReportFileWriteFlag(String ipAddress, String fileName, boolean writable) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("select * from reports_properties where server=? AND name=?");
            ps.setString(1, ipAddress);
            ps.setString(2, fileName);
            rs = ps.executeQuery();
            String insQuery = "insert into reports_properties (writable,LAST_UPDATE_TIME, server,name) VALUES (?, ?, ?, ?)";
            if (rs.next()) {
                insQuery = "update reports_properties  set writable=?, LAST_UPDATE_TIME=? where server=? AND name=?";
            }
            DbUtil.close(ps);
            ps = conn.prepareStatement(insQuery);
            ps.setInt(1, writable ? 2 : 1);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, ipAddress);
            ps.setString(4, fileName);
            ps.executeUpdate();
            _Logger.info((Object)("Update Report: " + fileName + " on server " + new SnmpIpAddress(ipAddress).toString() + " as " + (writable ? "writable" : "readonly")));
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            Boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(ps);
            DbUtil.close(conn);
        }
        DbUtil.close(ps);
        DbUtil.close(conn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean getReportsFileWriteFlag(String serverIp, String fileName) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block8: {
            Boolean bl;
            block7: {
                conn = null;
                ps = null;
                rs = null;
                try {
                    conn = ConnectionManager.getConnection();
                    ps = conn.prepareStatement("select * from reports_properties where server=? AND name=?");
                    ps.setString(1, serverIp);
                    ps.setString(2, fileName);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        Boolean writable;
                        bl = writable = Boolean.valueOf(rs.getInt(3) == 2);
                        DbUtil.close(rs);
                        break block7;
                    }
                    _Logger.info((Object)("Get Reports File write Flag for server " + serverIp + " obtained."));
                    DbUtil.close(rs);
                    break block8;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    return null;
                }
            }
            DbUtil.close(ps);
            DbUtil.close(conn);
            return bl;
        }
        DbUtil.close(ps);
        DbUtil.close(conn);
        return null;
        finally {
            DbUtil.close(rs);
            DbUtil.close(ps);
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteReportFileWriteFlag(String ipAddress, String fileName) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("delete from  reports_properties  where server=? AND name=?");
            ps.setString(1, ipAddress);
            ps.setString(2, fileName);
            int delRow = ps.executeUpdate();
            _Logger.info((Object)("Deleted Report flag : " + fileName + " on server " + new SnmpIpAddress(ipAddress).toString() + " Deleted rows:" + delRow));
        }
        catch (Exception ex) {
            Boolean bl;
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                bl = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(ps);
            DbUtil.close(conn);
            return bl;
        }
        DbUtil.close(ps);
        DbUtil.close(conn);
        return true;
    }

    @Override
    public String getInvISLIdxQuery() {
        return "  \tSELECT ISL.ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'||S2.SYS_NAME || ':' || SP2.IF_NAME, S1.WWN, S2.WWN, NULL,S1.IP_ADDRESS,S2.IP_ADDRESS, FABRIC.FID, NULL, NULL    \tFROM ISL, SWITCH_PORT SP1,SWITCH S1, SWITCH_PORT SP2, SWITCH S2, FABRIC \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND \t( SP2.SWITCH_ID = S2.ID) AND ( ISL.IS_CHANNELMEMBER=0) AND S1.FABRIC_ID = FABRIC.ID  UNION   \tSELECT ISL.ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'|| S2.SYS_NAME || ':' || SP2.IF_NAME , NULL, NULL, NULL,S1.IP_ADDRESS,S2.IP_ADDRESS, LAN.lan_id, NULL, NULL    \tFROM ETHISL ISL, ETHSWITCH_PORT SP1,ETHSWITCH S1, ETHSWITCH_PORT SP2, ETHSWITCH S2, LANSWITCH_MAP LSM, LAN \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND \t( SP2.SWITCH_ID = S2.ID) AND (( LSM.ID = S1.ID) AND (LSM.lan_id = LAN.ID)) ";
    }

    @Override
    public String getPerfIslIdxQuery() {
        return "\tSELECT  STAT.SRC_ID,STAT.DEST_ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'||S2.SYS_NAME || ':' || SP2.IF_NAME, S1.WWN, S2.WWN,\tNULL,S1.IP_ADDRESS,S2.IP_ADDRESS, FABRIC.FID \tFROM STATISTICS STAT,ISL, SWITCH_PORT SP1,SWITCH S1, SWITCH_PORT SP2, SWITCH S2,FABRIC \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND ( SP2.SWITCH_ID = S2.ID) AND \t( STAT.TYPE=1) AND ( ISL.IS_CHANNELMEMBER=0) AND (FABRIC.ID = S1.FABRIC_ID) AND \t( (STAT.SRC_ID=ISL.PORT1_ID AND STAT.DEST_ID=ISL.PORT2_ID ) OR (STAT.SRC_ID=ISL.PORT2_ID AND STAT.DEST_ID=ISL.PORT1_ID ))  UNION \tSELECT  STAT.SRC_ID,STAT.DEST_ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'||S2.SYS_NAME || ':' || SP2.IF_NAME, null, null, \tNULL,S1.IP_ADDRESS,S2.IP_ADDRESS, LAN.lan_id \tFROM STATISTICS STAT,ETHISL ISL, ETHSWITCH_PORT SP1,ETHSWITCH S1, ETHSWITCH_PORT SP2, ETHSWITCH S2, LANSWITCH_MAP LSM, LAN \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND ( SP2.SWITCH_ID = S2.ID) AND \t( STAT.TYPE=10) AND (( LSM.ID = S1.ID) AND (LSM.lan_id = LAN.ID)) AND \t( (STAT.SRC_ID=ISL.PORT1_ID AND STAT.DEST_ID=ISL.PORT2_ID ) OR (STAT.SRC_ID=ISL.PORT2_ID AND STAT.DEST_ID=ISL.PORT1_ID )) ";
    }

    @Override
    public String getIvrZoneSqlQuery() {
        return "SELECT  FABRIC.NAME, ZONE.PARENT_ID, ZONE.IS_IVR, ZONE.ZONE_INDEX, ZONE.NAME, ZONE.READ_ONLY, ZONE_MEMBER.TYPE,ZONE_MEMBER.MEMBER_ID, ZONE_MEMBER.LUN_ID, ZONE_MEMBER.IVR_VSAN_ID,FABRIC.IVR_ENF_ZONESET_NAME,ZONE_MEMBER.ID FROM ZONE, ZONE_MEMBER, FABRIC WHERE (ZONE_MEMBER.ZONE_ID = ZONE.ID) AND ( ZONE.IS_IVR=1) AND ( ZONE.PARENT_ID = FABRIC.ID)";
    }

    @Override
    public String getZoneSqlQuery() {
        return "SELECT   FABRIC.NAME, VSAN.VSAN_ID,ZONE.PARENT_ID, ZONE.IS_IVR, ZONE.ZONE_INDEX, ZONE.NAME, ZONE.READ_ONLY, ZONE_MEMBER.TYPE,ZONE_MEMBER.MEMBER_ID, ZONE_MEMBER.LUN_ID, ZONE_MEMBER.IVR_VSAN_ID,ENF_ZONESET_NAME,ZONE_MEMBER.ID FROM VSAN,ZONE,ZONE_MEMBER, FABRIC WHERE (ZONE.ID = ZONE_MEMBER.ZONE_ID) AND ( ZONE.PARENT_ID = VSAN.ID) AND (ZONE.IS_IVR=0) AND (VSAN.FABRIC_ID = FABRIC.ID) AND(FABRIC.ID=VSAN.FABRIC_ID)";
    }

    @Override
    public PreparedStatement getPreparedStmt(Connection conn, String sql, int resultSetType, int resultSetCon) throws Exception {
        return conn.prepareStatement(sql, resultSetType, resultSetCon == 1007 ? 1008 : resultSetCon);
    }
}

