/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Sequence {
    static final String querySQL = "select id, value from sequence where id=?";
    static final String updateSQL = "update sequence set value=? where id=?";
    static final String insertSQL = "insert into sequence(value, id) values(?, ?)";
    private static Sequence _instance;
    protected static final int _Id = 1;
    protected long _value = 1L;
    protected long _curValue = 1L;
    protected static final int _SanId = 2;
    protected long _sanIdValue = 1L;
    protected static final int _FabricId = 3;
    protected long _fabricIdValue = 1L;
    protected static final int Increment = 100;
    protected Connection con;
    static Logger _Logger;

    protected Sequence() {
    }

    public int getID() {
        return 1;
    }

    public long getValue() {
        return this._value;
    }

    public synchronized long getPK() throws SQLException {
        if (this._curValue >= this._value) {
            try {
                this.refreshFromDB(1);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return this._curValue++;
    }

    public synchronized long getPK(Connection con) throws SQLException {
        this.con = con;
        if (this._curValue >= this._value) {
            try {
                this.refreshFromDB(1);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return this._curValue++;
    }

    public synchronized long getEventPK(Connection conn) throws SQLException {
        if (this._curValue >= this._value) {
            try {
                this.refreshFromDB(1, conn);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return this._curValue++;
    }

    public synchronized long getSanPK() throws SQLException {
        try {
            this.refreshFromDB(2);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return this._sanIdValue;
    }

    public synchronized long getFabricPK() throws SQLException {
        try {
            this.refreshFromDB(3);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return this._fabricIdValue;
    }

    public long getLanPK() throws SQLException {
        return this.getFabricPK();
    }

    protected void setValue(long newValue) {
        this._value = newValue;
    }

    public static Sequence getSequence() {
        return ClusterSequence.getSequence();
    }

    public static Sequence getSequence(Connection con) {
        return ClusterSequence.getSequence(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getSimpleSequence() {
        if (_instance != null) {
            return _instance;
        }
        Class<Sequence> clazz = Sequence.class;
        synchronized (Sequence.class) {
            if (_instance == null) {
                _instance = new Sequence();
                try {
                    _instance.refreshFromDB(1);
                }
                catch (SQLException ex) {
                    System.err.println("Sequence init error: " + ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    protected long queryDB(Connection con, int id) throws SQLException {
        long l;
        PreparedStatement stat = null;
        ResultSet rs = null;
        long result_value = 0L;
        try {
            stat = con.prepareStatement(querySQL);
            stat.setInt(1, this.getModifiedId(id));
            rs = stat.executeQuery();
            if (rs.next()) {
                result_value = rs.getLong(2);
            }
            rs.close();
            rs = null;
            stat.close();
            stat = null;
            l = result_value;
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"Sequence.queryDB", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        return l;
    }

    protected void updateDB(Connection con, boolean insert, int id, long value) throws SQLException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(insert ? insertSQL : updateSQL);
            stat.setLong(1, value);
            stat.setInt(2, this.getModifiedId(id));
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshFromDB(int id) throws SQLException {
        Connection con = null;
        try {
            if (con == null || con.isClosed()) {
                con = ConnectionManager.getConnection();
            }
            this.refreshFromDB(id, con);
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            _Logger.error((Object)"Sequence refreshFrmomDB:", (Throwable)ex);
            throw ex;
        }
        catch (Throwable exce) {
            con.rollback();
            _Logger.error((Object)"Sequence refreshFrmomDB:", exce);
        }
        finally {
            DbUtil.close(con);
        }
    }

    protected void refreshFromDB(int id, Connection con) throws SQLException {
        boolean insert = true;
        long value = this.queryDB(con, id);
        if (value != 0L) {
            insert = false;
            switch (id) {
                case 1: {
                    this._curValue = value;
                    value = this._value = this._curValue + 100L;
                    break;
                }
                case 2: {
                    this._sanIdValue = ++value;
                    break;
                }
                case 3: {
                    this._fabricIdValue = ++value;
                }
            }
        } else {
            switch (id) {
                case 1: {
                    if (this._value == 1L) {
                        this._value = value = 100L;
                        break;
                    }
                    value = this._value;
                    break;
                }
                case 2: {
                    value = this._sanIdValue;
                    break;
                }
                case 3: {
                    value = this._fabricIdValue;
                }
            }
        }
        this.updateDB(con, insert, id, value);
    }

    protected int getModifiedId(int id) {
        return id;
    }

    public int getServerId() {
        return 0;
    }

    static {
        _Logger = LogManager.getLogger((String)"fms.db");
    }
}

