/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db.entity;

import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.sm.server.db.entity.FMEntityManager;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;

public class EntityHelper {
    private static boolean isStandalone = Boolean.getBoolean("fm.standalone");
    @PersistenceUnit(unitName="fm")
    static EntityManagerFactory factory;
    private static EntityManager em;

    public static EntityManager createEntityManager() {
        try {
            if (isStandalone) {
                Properties props = new Properties();
                String dialect = "org.hibernate.dialect." + (EntityHelper.isPostgres() ? "PostgreSQLDialect" : "Oracle9Dialect");
                props.put("hibernate.dialect", dialect);
                props.put("hibernate.connection.driver_class", EntityHelper.getDriver());
                props.put("hibernate.connection.username", EntityHelper.getUser());
                props.put("hibernate.connection.password", EntityHelper.getPassword());
                props.put("hibernate.connection.url", EntityHelper.getURL());
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"fm", (Map)props);
                em = factory.createEntityManager();
            } else {
                InitialContext ctx = new InitialContext();
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"fm");
                em = factory.createEntityManager();
            }
        }
        catch (Exception e) {
            System.err.println("Unable to get persistence context: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return new FMEntityManager(em);
    }

    protected static boolean isPostgres() {
        String dburl = EntityHelper.getURL();
        if (dburl == null) {
            throw new RuntimeException("Unable to obtain DB URL.");
        }
        return dburl.toLowerCase().contains("postgres".toLowerCase());
    }

    protected static String getDriver() {
        return System.getProperties().getProperty("db.driver");
    }

    protected static String getURL() {
        return System.getProperties().getProperty("db.url");
    }

    protected static String getUser() {
        return System.getProperties().getProperty("db.user");
    }

    protected static String getPassword() {
        String dbPass = System.getProperties().getProperty("db.password");
        if (dbPass != null && (dbPass = dbPass.trim()).startsWith("#")) {
            try {
                dbPass = JBoss_4_2Encrypter.decrypt(dbPass.substring(1));
            }
            catch (Exception ex) {
                System.err.println("Unable to decrypt password: " + dbPass.substring(1));
            }
        }
        return dbPass;
    }
}

