/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.sshexec.CliAdapterFactory;
import com.cisco.dcbu.lib.sshexec.IEthPortAdapter;
import com.cisco.dcbu.lib.sshexec.IVpcAdapter;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.BaseModelConstants;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.discovery.CdpSnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.ioa.comm.SwitchCommFactory;
import com.cisco.dcbu.sm.server.ioa.comm.Vsh;
import com.cisco.dcbu.sm.server.ioa.exception.IOAException;
import com.cisco.dcbu.sm.server.ioa.exception.IOASwitchCommunicationException;
import com.cisco.dcbu.sm.server.model.CdpLink;
import com.cisco.dcbu.sm.server.model.CdpNode;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthNodeIf;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.FexIslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.ServiceUtil;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import com.cisco.dcbu.sm.server.model.VlanImpl;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.NotSupportedException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CdpDiscvHelper {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);
    public static final char Char_Space = ' ';
    public static final char Char_Comma = ',';
    public static final char Char_SemiColon = ';';
    public static final char Char_Dot = '.';
    public static final char Char_Colon = ':';
    public static final char Char_LB = '(';
    public static final char Char_RB = ')';
    public static final String FexLink_fexid = "fex-";
    public static final String FexLink_linkport = " port ";
    public static final String FexLink_coreport = " to core port ";
    public static final String FexLink_cable = " cable";
    public static final String Token_version = "version";
    private static final Pattern FWSM_VER_REG_PATTERN = Pattern.compile(".*Firewall\\sVersion\\s+(\\S+)\\s+.*Compiled.*fwsmbld\\s+(\\S+)\\sup\\s+.*Hardware:\\s+(\\S+),.*Serial Number:\\s+(\\S+)\\s+.*", 32);
    private static final Pattern FWSM_CTXT_VER_REG_PATTERN = Pattern.compile(".*Firewall\\sVersion\\s+(\\S+)\\s+.*Compiled.*fwsmbld\\s+(\\S+)\\sup\\s+.*Hardware:\\s+(\\S+)\\s+.*", 32);

    public static int getVendorOidFromSysOid(int[] sysObjectID) {
        if (sysObjectID.length >= 7) {
            return sysObjectID[6];
        }
        return -1;
    }

    public static boolean validateReadCredential(InetAddress seedIp, SnmpUser user, SnmpSession session) {
        boolean ret = false;
        try {
            Map genSysMap;
            SnmpPeer peer = ServiceUtil.createSnmpPeer(seedIp, user, session, SnmpSession._PreferTcp);
            if (peer != null && (genSysMap = CdpSnmpAdapter.getGenSysInfo(peer)) != null) {
                ret = genSysMap.get(CdpSnmpAdapter.GenSys_MibCmds[0]) != null;
            }
            peer.close();
            peer = null;
        }
        catch (Exception ex) {
            _Tracer.log(Level.INFO, seedIp + " does not have read access for the crendentail");
        }
        return ret;
    }

    public static CdpNode validateCdpSeed(InetAddress seedIp, SnmpUserOpt user, SnmpSession session) throws Exception {
        SnmpPeer peer = ServiceUtil.createSnmpPeer(seedIp, user, session, SnmpSession._PreferTcp);
        if (peer != null) {
            SnmpPeer.addServerPeer(peer);
            CdpNode node = null;
            try {
                node = CdpDiscvHelper.validateCdpSeed(peer);
                return node;
            }
            catch (Exception e) {
                SnmpPeer.removeServerPeer(peer, true);
                throw e;
            }
        }
        return null;
    }

    public static CdpNode validateCdpSeed(SnmpPeer peer) throws Exception {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append("Validate cdp seed switch:").append(peer).append(" failed \n");
        try {
            Map genSysMap = CdpSnmpAdapter.getGenSysInfo(peer);
            if (genSysMap.size() == 0) {
                throw new SnmpException("Invalid return from querying GenSysInfo");
            }
            int[] sysObjectID = (int[])genSysMap.get(CdpSnmpAdapter.GenSys_MibCmds[0]);
            if (sysObjectID == null || sysObjectID.length < 7) {
                throw new SnmpException("Invalid sysObjectOid:" + Arrays.toString(sysObjectID));
            }
            int vendorOid = CdpDiscvHelper.getVendorOidFromSysOid(sysObjectID);
            String vendorStr = BaseModelConstants.getVendorFromSysOid(vendorOid);
            if (vendorOid != 9) {
                throw new SnmpException("Invalid cdp vendor: " + vendorStr + " vendor oid =" + vendorOid + " is not from Cisco.");
            }
            CdpNode node = new CdpNode(peer);
            if (!CdpDiscvHelper.checkChassis(node)) {
                msgBuf.append("Cannot discover from a seed without chassis info");
                throw new Exception(msgBuf.toString());
            }
            if (FRUConstants.isVdcCapableVersion(node.getPlatformType(), node.getVersion())) {
                CdpDiscvHelper.checkVdc(node);
            }
            CdpDiscvHelper.discoverCdpNode(node);
            if (!node.isCdpEnabled()) {
                msgBuf.append("Cdp is not running on the device.");
                throw new Exception(msgBuf.toString());
            }
            boolean supportedType = LanImpl.isAllowedCdpDevice(node.getPlatformType());
            if (!supportedType) {
                msgBuf.append("Invalid Cisco device type for CDP discovery:" + node.getModelName() + "," + node.getPlatform());
                throw new Exception(msgBuf.toString());
            }
            return node;
        }
        catch (SnmpException e) {
            msgBuf.append("Cannot verify seed from SNMP:").append(e.getMessage());
            _Tracer.log(Level.WARN, CdpDiscvHelper.prefix(peer.getAddress(), "validateCdpSeed") + msgBuf.toString(), e);
            throw new Exception(msgBuf.toString(), e);
        }
    }

    public static String sendReceive(String msgOut, String switchIP, String user, String passwd) throws IOAException {
        String clusterName = "";
        String msgIn = null;
        boolean isEncrypted = false;
        Vsh _vsh = null;
        msgOut = msgOut + "\n";
        _Tracer.log(Level.DEBUG, "Obtaining a session for user " + user + " cluster " + clusterName + " to switch " + switchIP);
        try {
            SwitchCommFactory commFactory = SwitchCommFactory.getInstance();
            _vsh = commFactory.getFwsmSession(clusterName, switchIP, user, passwd, isEncrypted);
        }
        catch (IOASwitchCommunicationException swe) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw swe;
        }
        catch (IOAException se) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw se;
        }
        if (_vsh != null) {
            try {
                _vsh.send(msgOut);
                msgIn = _vsh.readPrompt();
                _vsh.disconnect();
            }
            catch (IOException ioe) {
                if (_vsh != null) {
                    _vsh.disconnect();
                }
                throw new IOASwitchCommunicationException(ioe.getMessage());
            }
        } else {
            _Tracer.log(Level.WARN, "No Session could be obtained for user " + user + " cluster " + clusterName + " to switch " + switchIP);
            throw new IOASwitchCommunicationException("No Session can be initialized for switch: " + switchIP + "for user: " + user);
        }
        return msgIn;
    }

    public static boolean validateCdpMaxHopNode(CdpNode probeNode) {
        if (probeNode == null || probeNode.getSeed() == null || probeNode.getInetAddress() == null) {
            throw new IllegalArgumentException("Invalid arguments: " + probeNode);
        }
        CdpSeedImpl seed = probeNode.getSeed();
        int currHop = probeNode.getCurrentHop();
        InetAddress nodeIp = probeNode.getInetAddress();
        if (seed == null || nodeIp == null) {
            throw new IllegalArgumentException("Probe node has invalid arguments: " + seed + " ," + nodeIp);
        }
        if (currHop == seed.getBase().getMaxHop()) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, CdpDiscvHelper.prefix(nodeIp, "validateCdpMaxHopNode") + "cdp probe node reaches to max hop(" + seed.getBase().getMaxHop() + "), currHop: " + currHop);
            }
            return true;
        }
        return false;
    }

    public static boolean validateCdpProbeNode(CdpNode probeNode) {
        if (probeNode == null || probeNode.getSeed() == null || probeNode.getInetAddress() == null) {
            throw new IllegalArgumentException("Invalid arguments: " + probeNode);
        }
        return CdpDiscvHelper.validateCdpProbeNode(probeNode.getSeed(), probeNode.getInetAddress(), probeNode.getCurrentHop(), probeNode.getPlatform());
    }

    public static boolean validateCdpProbeNode(CdpSeedImpl seed, InetAddress nodeIp, int currHop, String platform) {
        if (seed == null || nodeIp == null) {
            throw new IllegalArgumentException("Probe node has invalid arguments: " + seed + " ," + nodeIp);
        }
        if (!IpUtil.isValidMgmtAddress(nodeIp)) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, CdpDiscvHelper.prefix(nodeIp, "validateCdpProbeNode") + "cdp probe node has invalid ip:" + nodeIp);
            }
            return false;
        }
        if (currHop >= seed.getBase().getMaxHop()) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, CdpDiscvHelper.prefix(nodeIp, "validateCdpProbeNode") + "cdp probe node reaches to max hop(" + seed.getBase().getMaxHop() + "), currHop: " + currHop);
            }
            return false;
        }
        return true;
    }

    public static boolean validateSwitchNode(EthNodeIf node) {
        if (node == null) {
            return false;
        }
        if (!CdpDiscvHelper.validatePlatform(node.getPlatformType())) {
            return false;
        }
        return IpUtil.isValidMgmtAddress(node.getInetAddress());
    }

    public static boolean validatePlatform(String platform) {
        PlatformType type = PlatformType.getTypeByDeviceKey(platform);
        return LanImpl.isAllowedCdpDevice(type);
    }

    public static boolean validatePlatform(PlatformType type) {
        return LanImpl.isAllowedCdpDevice(type);
    }

    public static boolean checkCdpChanged(EthSwitchImpl node) {
        return true;
    }

    public static boolean discoverCdpConns(CdpNode probeNode, HashSet<CdpNode> retNeighbors, HashSet<CdpLink> retLinks) throws Exception {
        if (probeNode == null || probeNode.getSeed() == null || retNeighbors == null || retLinks == null) {
            throw new IllegalArgumentException("Invalid arguments: " + probeNode + "," + retNeighbors + "," + retLinks);
        }
        List<Map> cache = CdpSnmpAdapter.getCdpCachedConns(probeNode.getPeer());
        if (cache.size() == 0) {
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(probeNode, "discoverCdpConns");
        }
        HashMap<InetAddress, CdpNode> nodesByIp = new HashMap<InetAddress, CdpNode>();
        probeNode.getSeed().getLan().getWorker().incWalkedEntry(cache.size());
        for (Map m : cache) {
            int l_ifindex = (Integer)m.get(CdpSnmpAdapter.CdpCacheIndex_MibCmds[0]);
            int r_devIndex = (Integer)m.get(CdpSnmpAdapter.CdpCacheIndex_MibCmds[1]);
            InetAddress r_mgmtAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[8]);
            String r_deviceId = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[1]);
            r_deviceId = LanImpl.CdpTrimDomain ? GenUtil.trimDomain(r_deviceId) : r_deviceId;
            String r_platform = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[2]);
            String r_version = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[3]);
            Bits r_capability = (Bits)m.get(CdpSnmpAdapter.CdpCache_MibCmds[5]);
            byte[] r_vtpMgmtDomain = (byte[])m.get(CdpSnmpAdapter.CdpCache_MibCmds[7]);
            String r_ifname = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[4]);
            short nativeVlan = m.get(CdpSnmpAdapter.CdpCache_MibCmds[6]) == null ? (short)0 : (Short)m.get(CdpSnmpAdapter.CdpCache_MibCmds[6]);
            String r_sysName = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[10]);
            if (r_sysName == null && r_deviceId != null) {
                r_sysName = GenUtil.getSysName(r_deviceId);
            }
            r_sysName = LanImpl.CdpTrimDomain ? GenUtil.trimDomain(r_sysName) : r_sysName;
            int[] r_sysOID = (int[])m.get(CdpSnmpAdapter.CdpCache_MibCmds[11]);
            String r_sysLoc = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[12]);
            if (r_mgmtAddr == null) {
                r_mgmtAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[9]);
            }
            InetAddress cacheAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[0]);
            if (r_mgmtAddr == null || r_mgmtAddr instanceof Inet6Address && cacheAddr != null && cacheAddr instanceof Inet4Address) {
                r_mgmtAddr = cacheAddr;
            }
            if (r_mgmtAddr == null && r_sysName != null && r_sysName.length() > 1 && !r_sysName.equalsIgnoreCase("switch")) {
                try {
                    InetAddress[] rAddrs = InetAddress.getAllByName(r_sysName);
                    Arrays.sort(rAddrs, NetUtil._InetAddrComparator);
                    for (InetAddress addr : rAddrs) {
                        if (!IpUtil.isValidMgmtAddress(addr)) continue;
                        r_mgmtAddr = addr;
                        break;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (r_mgmtAddr == null) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.DEBUG, "Ignore the cdp entry without r_mgmtAddr:" + m);
                continue;
            }
            if (IpUtil.isAllZeros(r_mgmtAddr) && r_deviceId.equalsIgnoreCase("switch")) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.DEBUG, "Ignore the cdp entry without valid node info" + m);
                continue;
            }
            CdpNode rnode = (CdpNode)nodesByIp.get(r_mgmtAddr);
            if (rnode == null) {
                rnode = new CdpNode(r_mgmtAddr, probeNode.getCurrentHop() + 1, r_deviceId, r_platform, r_version, r_capability, r_vtpMgmtDomain);
                retNeighbors.add(rnode);
                nodesByIp.put(r_mgmtAddr, rnode);
                if (r_sysName != null && r_sysName.length() > 0) {
                    rnode.setSysName(r_sysName);
                }
                if (r_sysLoc != null && r_sysLoc.length() > 0 && rnode.getSysLocation() == null) {
                    rnode.setSysLocation(r_sysLoc);
                }
                if (r_sysOID != null && r_sysOID.length > 0 && rnode.getSysObjectID() == null) {
                    rnode.setSysObjectID(r_sysOID);
                }
                if (r_version != null && r_version.length() > 0) {
                    String tv;
                    int vPos;
                    if (rnode.getSysDescr() == null) {
                        rnode.setSysDescr(r_version);
                    }
                    if (rnode.getVersion() == null && (vPos = (tv = r_version.toLowerCase()).indexOf(Token_version)) > 0) {
                        int offset;
                        vPos += Token_version.length() + 1;
                        while (vPos < r_version.length() && !Character.isDigit(r_version.charAt(vPos))) {
                            ++vPos;
                        }
                        for (offset = vPos; offset < r_version.length(); ++offset) {
                            char vchar = r_version.charAt(offset);
                            if (vchar != ' ' && vchar != ',' && vchar != ';' && vchar != ':') continue;
                            --offset;
                            break;
                        }
                        if (offset > vPos) {
                            String newVersion = r_version.substring(vPos, offset);
                            String oldVersion = rnode.getVersion();
                            if (oldVersion == null) {
                                rnode.setVersion(newVersion);
                            }
                        }
                    }
                }
                if (rnode.getSysName() == null && r_mgmtAddr != null) {
                    rnode.setSysName(r_mgmtAddr.getHostAddress());
                }
            }
            if (probeNode.getSeed() != null) {
                rnode.setSeed(probeNode.getSeed());
            }
            retLinks.add(new CdpLink(probeNode, l_ifindex, rnode, r_ifname, nativeVlan));
            probeNode.addLinkPort(l_ifindex);
        }
        for (Map m : cache) {
            m.clear();
        }
        cache.clear();
        nodesByIp.clear();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(probeNode, "discoverCdpConns", retLinks);
        }
        return true;
    }

    public static boolean discoverCdpPorts(CdpNode cdpNode) throws Exception {
        if (cdpNode == null) {
            throw new IllegalArgumentException("Invalid arguments: " + cdpNode);
        }
        List<Integer> ifindexes = CdpSnmpAdapter.getCdpIfindexes(cdpNode.getPeer());
        if (ifindexes.size() == 0) {
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(cdpNode, "discoverCdpPorts");
        }
        for (int ifindex : ifindexes) {
            cdpNode.addLinkPort(ifindex);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.TRACE, cdpNode.getIpAddress() + " discoverCdpPorts() --" + cdpNode.getLinkPorts());
        }
        return true;
    }

    public static boolean checkSwitchConns(EthSwitchImpl ethSw, Set<EthSwitchImpl> changedIpSws, HashSet<CdpLink> retLinks) throws Exception {
        if (ethSw == null) {
            return false;
        }
        LanImpl lan = DCManager.getInstance().getLan();
        Set<EthIslImpl> oldIsls = lan.findEthIslsBySwPK(ethSw.getSwitchPK());
        HashMap nodesByIp = new HashMap();
        CdpSeedImpl seed = lan.findCdpSeedFromNodePK(ethSw.getPK());
        List<Map> cache = CdpSnmpAdapter.getCdpCachedConns(ethSw.getPeer());
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(ethSw, "checkSwitchConns");
        }
        ethSw.syncLastScanTime();
        for (Map m : cache) {
            int r_ifindex;
            String tv;
            int vPos;
            EthSwitchImpl r_sw = null;
            int l_ifindex = (Integer)m.get(CdpSnmpAdapter.CdpCacheIndex_MibCmds[0]);
            EthPortImpl locPort = DCManager.getInstance().createEthPort(ethSw, l_ifindex);
            int r_devIndex = (Integer)m.get(CdpSnmpAdapter.CdpCacheIndex_MibCmds[1]);
            String r_deviceId = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[1]);
            r_deviceId = LanImpl.CdpTrimDomain ? GenUtil.trimDomain(r_deviceId) : r_deviceId;
            String r_platform = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[2]);
            String r_version = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[3]);
            String r_ifname = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[4]);
            short nativeVlan = (Short)m.get(CdpSnmpAdapter.CdpCache_MibCmds[6]);
            String r_sysName = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[10]);
            if (r_sysName == null && r_deviceId != null) {
                r_sysName = GenUtil.getSysName(r_deviceId);
            }
            r_sysName = LanImpl.CdpTrimDomain ? GenUtil.trimDomain(r_sysName) : r_sysName;
            int[] r_sysOID = (int[])m.get(CdpSnmpAdapter.CdpCache_MibCmds[11]);
            String r_sysLoc = (String)m.get(CdpSnmpAdapter.CdpCache_MibCmds[12]);
            InetAddress r_mgmtAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[8]);
            if (r_mgmtAddr == null) {
                r_mgmtAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[9]);
            }
            InetAddress cacheAddr = (InetAddress)m.get(CdpSnmpAdapter.CdpCache_MibCmds[0]);
            if (r_mgmtAddr == null || r_mgmtAddr instanceof Inet6Address && cacheAddr != null && cacheAddr instanceof Inet4Address) {
                r_mgmtAddr = cacheAddr;
            }
            if (r_mgmtAddr == null && r_sysName != null && r_sysName.length() > 1 && !r_sysName.equalsIgnoreCase("switch")) {
                try {
                    InetAddress[] rAddrs = InetAddress.getAllByName(r_sysName);
                    Arrays.sort(rAddrs, NetUtil._InetAddrComparator);
                    for (InetAddress addr : rAddrs) {
                        if (!IpUtil.isValidMgmtAddress(addr)) continue;
                        r_mgmtAddr = addr;
                        break;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (r_mgmtAddr == null) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.TRACE, "checkSwitchConns ignores the cdp entry without r_mgmtAddr:" + m);
                continue;
            }
            if (IpUtil.isAllZeros(r_mgmtAddr) && r_deviceId.equalsIgnoreCase("switch")) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.DEBUG, "Ignore the cdp entry without valid node info" + m);
                continue;
            }
            String r_trimedVersion = null;
            if (r_version != null && (vPos = (tv = r_version.toLowerCase()).indexOf(Token_version)) > 0) {
                char vchar;
                int offset;
                vPos += Token_version.length() + 1;
                while (vPos < r_version.length() && !Character.isDigit(r_version.charAt(vPos))) {
                    ++vPos;
                }
                for (offset = vPos; offset < r_version.length() && (vchar = r_version.charAt(offset)) != ' ' && vchar != ',' && vchar != ';' && vchar != ':'; ++offset) {
                }
                if (offset > vPos) {
                    r_trimedVersion = r_version.substring(vPos, offset);
                }
            }
            PlatformType r_platfType = null;
            if (r_platform != null) {
                r_platfType = PlatformType.getTypeByDeviceKey(r_platform);
            }
            String snStr = null;
            if (r_deviceId != null) {
                snStr = GenUtil.getCiscoSerialNumber(r_deviceId);
            }
            boolean isVdcCapable = FRUConstants.isVdcCapableVersion(r_platfType, r_trimedVersion);
            if (r_sysName != null && (r_sw = lan.findEthSwitchBySysName(r_sysName)) != null && snStr != null && r_sw.getChassisKey() != null && r_sw.getChassisKey().isRealSN() && GenUtil.isCiscoSerialNumber(snStr) && !snStr.equals(r_sw.getChassisKey()._serialNum)) {
                r_sw = null;
            }
            if (r_sw == null && snStr != null && !isVdcCapable) {
                r_sw = lan.findEthSwitchByPK(new SerialNumKey(snStr));
            }
            if (r_sw == null && r_mgmtAddr != null) {
                try {
                    r_sw = lan.findEthSwitchByIp(r_mgmtAddr);
                    if (r_sw != null && r_sw.getChassisKey() != null && snStr != null && r_sw.getChassisKey().isRealSN() && GenUtil.isCiscoSerialNumber(snStr) && !snStr.equals(r_sw.getChassisKey()._serialNum)) {
                        r_sw = null;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (r_sw == null) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.TRACE, "checkSwitchConns ignores the cdp entry without found switch:" + m);
                continue;
            }
            r_sw.syncLastScanTime();
            r_sw.setPresent(true);
            if (r_deviceId != null) {
                r_sw.setDeviceId(r_deviceId);
            }
            if (r_platform != null && r_platform.trim().length() > 0) {
                if (r_sw.getPlatformType() == null || r_sw.getPlatformType() == PlatformType.UNKNOWN) {
                    r_sw.setPlatform(r_platform);
                }
                if (r_sw.getModelName() == null && r_sw.getBase().getModelType() != -1) {
                    r_sw.setModelName(GenUtil.trimCisco(r_platform));
                }
            }
            if (r_trimedVersion != null && r_sw.getVersion() == null) {
                r_sw.setVersion(r_trimedVersion);
            }
            if (r_sysName != null && r_sysName.length() > 0) {
                r_sw.setSysName(r_sysName);
            }
            if (r_sysLoc != null) {
                r_sw.setSysLocation(r_sysLoc);
            }
            if (r_sysOID != null && r_sw.getBase().getSysObjectId() == null) {
                r_sw.setSysObjectID(r_sysOID);
            }
            if (!r_sw.getBase().containsMgmtAddr(r_mgmtAddr)) {
                InetAddress[] newAddrs = null;
                InetAddress[] oldAddrs = r_sw.getManagementAddresses();
                if (oldAddrs != null && oldAddrs.length > 0) {
                    newAddrs = new InetAddress[oldAddrs.length + 1];
                    System.arraycopy(oldAddrs, 0, newAddrs, 0, oldAddrs.length);
                } else {
                    newAddrs = new InetAddress[1];
                }
                newAddrs[newAddrs.length - 1] = r_mgmtAddr;
                if (Boolean.parseBoolean(System.getProperty("fabric.managementIpOverwrite")) || r_sw.getManagementAddresses() == null || r_sw.getManagementAddresses() != null && r_sw.getManagementAddresses().length == 0) {
                    r_sw.setManagementAddresses(newAddrs, true);
                }
                lan.checkAndUpdateCacheByMgmtAddrs(r_sw, oldAddrs, newAddrs);
            }
            if (r_sw.getBase().getSysName() == null && r_mgmtAddr != null) {
                r_sw.getBase().setSysName(r_mgmtAddr.getHostAddress());
            }
            if (r_ifname.startsWith("control") || (r_ifindex = r_sw.ifNameToIndex(r_ifname)) <= 0) continue;
            EthIslImpl ethIsl = lan.findEthIsl(ethSw.getSwitchPK(), r_sw.getSwitchPK(), l_ifindex, r_ifindex);
            if (ethIsl == null) {
                ethIsl = lan.findEthIsl(r_sw.getSwitchPK(), ethSw.getSwitchPK(), r_ifindex, l_ifindex);
            }
            if (ethIsl != null) {
                if (ethIsl.getPort1().getBase().getNativeVlan() == -1) {
                    ethIsl.getPort1().setNativeVlan(nativeVlan);
                }
                if (ethIsl.getPort2().getBase().getNativeVlan() == -1) {
                    ethIsl.getPort2().setNativeVlan(nativeVlan);
                }
                ethIsl.setPresent(true);
                ethIsl.syncLastScanTime();
                oldIsls.remove(ethIsl);
                retLinks.add(new CdpLink(new CdpNode(ethSw), l_ifindex, new CdpNode(r_sw), r_ifname, nativeVlan));
            } else {
                retLinks.add(new CdpLink(new CdpNode(ethSw), l_ifindex, new CdpNode(r_sw), r_ifname, nativeVlan));
                if (ethSw.findEthPort(l_ifindex) == null) {
                    EthPortImpl ethPort = DCManager.getInstance().createEthPort(ethSw, l_ifindex);
                    ethSw.addEthPort(ethPort);
                }
            }
            if (!ethSw.getBase().isCAT() || ethSw.getBase().haveIfMapping(l_ifindex)) continue;
            ethSw.setDiscFlag(16);
        }
        for (EthIslImpl isl : oldIsls) {
            if (isl.isPortChannel() || isl instanceof FexIslImpl) continue;
            EthSwitchImpl sw1 = isl.getSwitch1();
            EthSwitchImpl sw2 = isl.getSwitch2();
            int ifindex1 = isl.getIfIndex1();
            int ifindex2 = isl.getIfIndex2();
            if (sw1 == null || sw2 == null) {
                lan.removeEthIsl(isl, true);
                continue;
            }
            if (sw1.getBase().isCAT() && IfIndexUtil.isFmIfIndex(ifindex1) && sw1.getBase().haveIfMapping(isl.getIfIndex1Name())) {
                lan.removeEthIsl(isl, true);
                continue;
            }
            if (sw2.getBase().isCAT() && IfIndexUtil.isFmIfIndex(ifindex2) && sw2.getBase().haveIfMapping(isl.getIfIndex2Name())) {
                lan.removeEthIsl(isl, true);
                continue;
            }
            isl.setPresent(false);
        }
        return true;
    }

    public static boolean discoverCdpNode(EthNodeIf node) throws Exception {
        String deviceId;
        if (node == null) {
            throw new IllegalArgumentException("Invalid arguments: " + node);
        }
        Map cdpAttrs = CdpSnmpAdapter.getCdpNodes(node.getPeer());
        Boolean cdpEnabled = (Boolean)cdpAttrs.get(CdpSnmpAdapter.CdpGlobal_MibCmds[0]);
        if (cdpEnabled != null) {
            node.setCdpEnabled(cdpEnabled);
        }
        if ((deviceId = (String)cdpAttrs.get(CdpSnmpAdapter.CdpGlobal_MibCmds[1])) != null) {
            node.setGlobalDeviceId(deviceId);
            return true;
        }
        return false;
    }

    public static boolean discoverFwsm(CdpNode node) throws Exception {
        try {
            if (node == null || node.getSeed() == null) {
                throw new IllegalArgumentException("Invalid arguments: " + node);
            }
            CdpSeedBase taskBase = node.getSeed().getBase();
            if (taskBase == null) {
                node.setReachable(false);
                node.setUnReachableCause("nonAuthen");
                return false;
            }
            String username = taskBase.getSnmpUserOpt() == null ? null : taskBase.getSnmpUserOpt().getUsername();
            String passwd = taskBase.getSnmpUserOpt() == null ? null : taskBase.getSnmpUserOpt().getPassword();
            String response = CdpDiscvHelper.sendReceive("show version", node.getIpAddress(), username, passwd);
            if (!CdpDiscvHelper.isFwsmPlatformType(response)) {
                throw new Exception("switch " + node.getIpAddress() + " is not a Firewall Service Module");
            }
            node.setVendor("Cisco");
            node.setPlatform(PlatformType.FWSM);
            node.setReachable(true);
            node.setSysName(node.getIpAddress());
        }
        catch (Exception e) {
            node.setReachable(false);
            node.setUnReachableCause("nonAuthen");
            return false;
        }
        return true;
    }

    public static boolean discoverSysInfo(EthNodeIf node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("invalid etherent node:" + node);
        }
        Map sysMap = CdpSnmpAdapter.getGenSysInfo(node.getPeer());
        int[] sysOid = (int[])sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[0]);
        node.setSysObjectID(sysOid);
        node.setSysDescr((String)sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[1]));
        node.setSysUpTime((Long)sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[2]));
        node.setSysContact((String)sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[3]));
        node.setSysName((String)sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[4]));
        node.setSysLocation((String)sysMap.get(CdpSnmpAdapter.GenSys_MibCmds[5]));
        int vendorOid = CdpDiscvHelper.getVendorOidFromSysOid(sysOid);
        String vendorId = BaseModelConstants.getVendorFromSysOid(vendorOid);
        node.setVendor(vendorId);
        return true;
    }

    public static boolean discoverSwitchInfo(EthNodeIf node) throws Exception {
        boolean doneCheck;
        if (node == null) {
            throw new IllegalArgumentException("invalid etherent node:" + node);
        }
        if (node instanceof EthSwitchImpl) {
            EthSwitchImpl ethSw = (EthSwitchImpl)node;
            Map swMap = CdpSnmpAdapter.getSwitchInfo(node.getPeer());
            if (swMap.size() >= 0) {
                Boolean telnet = (Boolean)swMap.get("cseSysTelnetServiceActivation");
                Boolean ssh = (Boolean)swMap.get("cssServiceActivation");
                if (telnet != null) {
                    ethSw.setTelnetEnabled(telnet);
                } else {
                    ethSw.setTelnetEnabled(true);
                }
                if (ssh != null) {
                    ethSw.setSSHEnabled(ssh);
                } else {
                    ethSw.setSSHEnabled(true);
                }
            } else {
                ethSw.setTelnetEnabled(true);
                ethSw.setSSHEnabled(true);
            }
            if (PlatformType.isTypeOf(node.getPlatformType(), PlatformType.CAT)) {
                CdpDiscvHelper.discoverCatUsage(ethSw);
            } else {
                CdpDiscvHelper.discoverNxUsage(ethSw);
            }
        }
        if ((doneCheck = CdpDiscvHelper.checkChassis(node)) && !PlatformType.isTypeOf(node.getPlatformType(), PlatformType.CAT)) {
            doneCheck = CdpDiscvHelper.checkNexusActiveSup(node);
        }
        if (doneCheck && node.getPlatformType() == PlatformType.N7K) {
            doneCheck = CdpDiscvHelper.checkVdc(node);
        }
        return doneCheck;
    }

    public static boolean checkVdc(EthNodeIf node) throws Exception {
        if (node instanceof CdpNode) {
            return CdpDiscvHelper.checkVdc((CdpNode)node);
        }
        if (node instanceof EthSwitchImpl) {
            return CdpDiscvHelper.checkVdc((EthSwitchImpl)node);
        }
        return false;
    }

    public static boolean checkVdc(CdpNode node) throws Exception {
        HashMap<Integer, HashMap<String, Object>> map;
        if (node == null) {
            throw new IllegalArgumentException("Invalid Cdp Node:" + node);
        }
        if (_Tracer.isDebuggable()) {
            _Tracer.debug(node + " checkVdc for CdpNode ");
        }
        if ((map = CdpSnmpAdapter.getVdcInfo(node.getPeer())) == null || map.size() == 0) {
            if (_Tracer.isDebuggable()) {
                _Tracer.debug(node + " checkVdc returns empty Vdc map");
            }
            node.setVdc(false);
            return false;
        }
        for (Map.Entry<Integer, HashMap<String, Object>> ent : map.entrySet()) {
            int vdcId = ent.getKey();
            HashMap<String, Object> vdcMap = ent.getValue();
            String vdcName = (String)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[0]);
            int vdcState = (Integer)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[1]);
            int fcoeCap = (Integer)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[2]);
            MacAddress vdcMac = (MacAddress)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[3]);
            MacAddress parentMac = (MacAddress)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[4]);
            CdpNode cnode = node;
            cnode.setVdc(true);
            VdcPK vdcKey = new VdcPK(node.getChassisKey(), vdcMac, vdcId);
            vdcKey.setName(vdcName);
            cnode.setVdcKey(vdcKey);
            cnode.setVdcFCoECapability((short)fcoeCap);
            cnode.setParentVdcMac(parentMac);
        }
        return true;
    }

    public static void validateFwsm(String switchIp, String username, String password) throws Exception {
        String response = CdpDiscvHelper.sendReceive("show version", switchIp, username, password);
        if (!CdpDiscvHelper.isFwsmPlatformType(response)) {
            throw new Exception("switch " + switchIp + " is not a Firewall Service Module");
        }
    }

    public static boolean checkVdc(EthSwitchImpl ethsw) throws Exception {
        HashMap<Integer, HashMap<String, Object>> map;
        if (ethsw == null) {
            throw new IllegalArgumentException("Invalid ethernet switch:" + ethsw);
        }
        if (_Tracer.isDebuggable()) {
            _Tracer.debug(ethsw + " checkVdc for Ethsw");
        }
        if ((map = CdpSnmpAdapter.getVdcInfo(ethsw.getPeer())) == null || map.size() == 0) {
            return false;
        }
        int vdcId = -1;
        String vdcName = null;
        int vdcState = -1;
        int fcoeCap = -1;
        MacAddress vdcMac = null;
        MacAddress parentMac = null;
        for (Map.Entry<Integer, HashMap<String, Object>> ent : map.entrySet()) {
            vdcId = ent.getKey();
            HashMap<String, Object> vdcMap = ent.getValue();
            vdcName = (String)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[0]);
            vdcState = (Integer)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[1]);
            fcoeCap = (Integer)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[2]);
            vdcMac = (MacAddress)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[3]);
            parentMac = (MacAddress)vdcMap.get(CdpSnmpAdapter.Vdc_MibCmds[4]);
        }
        if (ethsw.isVdc()) {
            VdcImpl vdc = (VdcImpl)ethsw;
            VdcPK vdcPK = vdc.getBase().getVdcPK();
            if (vdcPK._id != vdcId || !vdcPK._macAddr.equals(vdcMac)) {
                DCManager.getInstance().removeEthSwitch(ethsw.getLan(), ethsw.getPK(), true);
                return true;
            }
            vdc.setVdcFCoECapability((short)fcoeCap);
            vdc.setParentMacAddress(parentMac);
            vdc.getBase().getVdcPK().setName(vdcName);
            return true;
        }
        _Tracer.warn(ethsw + " converted to VDC because N7K became vdc capable");
        LanImpl lan = ethsw.getLan();
        InetAddress swIp = ethsw.getInetAddress();
        CdpSeedImpl seed = lan.findCdpSeedFromNodePK(ethsw.getPK());
        if (seed == null) {
            _Tracer.warn(" couldn't find seed for ethsw " + ethsw);
            return false;
        }
        DCManager.getInstance().removeEthSwitch(lan, ethsw.getPK(), false);
        VdcPK vdcKey = new VdcPK(ethsw.getBase().getChassisKey(), vdcMac, vdcId);
        vdcKey.setName(vdcName);
        VdcImpl vdc = (VdcImpl)DCManager.getInstance().createEthSwitch(lan, vdcKey, ethsw.getBase().getSysName(), swIp);
        vdc.setParentMacAddress(parentMac);
        vdc.setVdcFCoECapability((short)fcoeCap);
        int discFlags = ethsw.getDiscFlags();
        vdc.setDiscFlags(discFlags);
        vdc.setReachable(true);
        vdc.setManageable(true, null);
        vdc.setDeepDisc(ethsw.isDeepDisc());
        lan.addEthSwitch(vdc, true);
        seed.addEthSwitch(vdc);
        ethsw = vdc;
        CdpDiscvHelper.discoverSysInfo(vdc);
        _Tracer.warn(ethsw + " done converted ethsw to VDC");
        return true;
    }

    public static boolean discoverFeatures(EthNodeIf node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("invalid etherent node:" + node);
        }
        if (node.getPlatformType() == PlatformType.CAT) {
            return false;
        }
        Map<Integer, Integer> resultFeatures = CdpSnmpAdapter.getFeatureStatus(node.getPeer(), null);
        Integer value = resultFeatures.get(AbstractSwitchBase.Feature.FCOE.mibIndex());
        int fcoeStatus = value != null ? value : -1;
        value = resultFeatures.get(AbstractSwitchBase.Feature.FEX.mibIndex());
        int fexStatus = value != null ? value : -1;
        int[] checkFeatureSets = new int[]{AbstractSwitchBase.FeatureSet.FCOE.mibIndex(), AbstractSwitchBase.FeatureSet.L2MP.mibIndex(), AbstractSwitchBase.FeatureSet.FEX.mibIndex()};
        Map<Integer, Integer> resultFeatureSets = CdpSnmpAdapter.getFeatureSetStatus(node.getPeer(), checkFeatureSets);
        int fcoeSetStatus = resultFeatureSets.get(AbstractSwitchBase.FeatureSet.FCOE.mibIndex());
        int l2mpSetStatus = resultFeatureSets.get(AbstractSwitchBase.FeatureSet.L2MP.mibIndex());
        int fexSetStatus = resultFeatureSets.get(AbstractSwitchBase.FeatureSet.FEX.mibIndex());
        boolean fcoeEnabled = fcoeStatus == AbstractSwitchBase.FeatureStatus.enabled.value() || fcoeSetStatus == AbstractSwitchBase.FeatureStatus.enabled.value();
        node.setFCoEEnabled(fcoeEnabled);
        if (fcoeSetStatus != -1) {
            node.setFCoEFeatureSetStatus(fcoeSetStatus);
        } else {
            node.setFCoEFeatureSetStatus(AbstractSwitchBase.FeatureStatus.uninstalled.value());
        }
        boolean l2mpEnabled = l2mpSetStatus == AbstractSwitchBase.FeatureStatus.enabled.value();
        boolean fexEnabled = fexStatus == AbstractSwitchBase.FeatureStatus.enabled.value() || fexSetStatus == AbstractSwitchBase.FeatureStatus.enabled.value();
        node.setFexEnabled(fexEnabled);
        if (fexSetStatus != -1) {
            node.setFexFeatureSetStatus(fexSetStatus);
        } else {
            node.setFexFeatureSetStatus(AbstractSwitchBase.FeatureStatus.uninstalled.value());
        }
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.TRACE, node.getIpAddress() + " swFeatures=fcoe-" + fcoeEnabled + ", fex-" + fexEnabled);
        }
        boolean[] flags = new boolean[AbstractSwitchBase.NUM_FEATURES];
        for (int i = 0; i < flags.length; ++i) {
            Integer fStatus = resultFeatures.get(i + 1);
            flags[i] = fStatus == null ? false : fStatus.intValue() == AbstractSwitchBase.FeatureStatus.enabled.value();
        }
        if (fcoeEnabled) {
            flags[AbstractSwitchBase.Feature.FCOE.flag()] = true;
        }
        if (fexEnabled) {
            flags[AbstractSwitchBase.Feature.FEX.flag()] = true;
        }
        flags[AbstractSwitchBase.Feature.L2MP.flag()] = l2mpEnabled;
        node.setFeatureFlags(flags);
        return true;
    }

    public static boolean discoverFexAndLink(EthSwitchImpl sw) throws Exception {
        int[] vendorType;
        FexImpl fex;
        int fexId;
        Map<HwInventoryType, List<Map>> map;
        if (sw == null || sw.getPeer() == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(sw.getPeer(), "discoverFexAndLink");
        }
        if (!((sw.isFexEnabled() || sw.isN5K() || sw.isN6K()) && sw.isFexCapableVersion() || !_Tracer.isDebuggable())) {
            _Tracer.debug(sw.getIpAddress() + " skip discoverFexAndLink for incapable switch");
        }
        SwitchVersion swRev = new SwitchVersion(sw.getVersion());
        Map<Integer, String> chassisMap = CdpSnmpAdapter.getFexChassisIndex(sw.getPeer(), sw.getPlatformType(), swRev);
        if (chassisMap == null) {
            return false;
        }
        LanImpl lan = sw.getLan();
        HashSet<FexIslImpl> oldFexLinks = new HashSet<FexIslImpl>(lan.findFexLinksBySwPK(sw.getSwitchPK()));
        HashSet<FexImpl> oldFexList = new HashSet<FexImpl>(sw.getFexes());
        ArrayList fexList = new ArrayList();
        ArrayList<Integer> chassisList = new ArrayList<Integer>();
        ArrayList<Integer> moduleList = new ArrayList<Integer>();
        ArrayList<Integer> linkList = new ArrayList<Integer>();
        if (chassisMap == null) {
            for (FexIslImpl ethIsl : oldFexLinks) {
                ethIsl.setPresent(false);
            }
            for (FexImpl fex2 : oldFexList) {
                fex2.setPresent(false);
            }
            return false;
        }
        for (Map.Entry<Integer, String> ent : chassisMap.entrySet()) {
            int fexId2 = ent.getKey();
            String serialNum = ent.getValue();
            if (!GenUtil.isCiscoSerialNumber(serialNum)) {
                _Tracer.debug(sw + " got invalid fex chassis entity:" + ent);
                continue;
            }
            SerialNumKey fexPK = new SerialNumKey(serialNum);
            if (fexId2 <= 0) {
                _Tracer.debug(sw + " got invalid fex chassis entity:" + ent);
                continue;
            }
            FexImpl fex3 = sw.getLan().findFexByPK(fexPK);
            if (fex3 == null) {
                fex3 = DCManager.getInstance().createFex(sw.getLan(), fexPK, fexId2);
                fex3.setSysName(sw.getName() + "-fex-" + fexId2);
                fex3.setDeviceId(fex3.getBase().getSysName());
                fex3.setGlobalDeviceId(fex3.getBase().getSysName());
                fex3.setName(fex3.getBase().getSysName());
                lan.addFex(fex3);
                sw.addFex(fex3);
            } else {
                lan.addFex(fex3);
                int oldFexId = fex3.getBase().getFexId();
                if (!sw.containsFex(fex3) || fexId2 != oldFexId || !fex3.isPresent()) {
                    fex3.setFexId(fexId2);
                    fex3.setSysName(sw.getName() + "-fex-" + fexId2);
                    fex3.setDeviceId(fex3.getBase().getSysName());
                    fex3.setGlobalDeviceId(fex3.getBase().getSysName());
                    fex3.setName(fex3.getBase().getSysName());
                    if (!sw.containsFex(fex3)) {
                        sw.addFex(fex3);
                    } else {
                        sw.updateFexId(oldFexId, fex3);
                    }
                    fex3.setPresent(true);
                }
                oldFexList.remove(fex3);
            }
            fex3.syncLastScanTime();
            int phyIndex = NexusEntityMibHelper.getFexChassisPhyIndex(fexId2);
            chassisList.add(phyIndex);
            phyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.MODULE.value(), fexId2);
            moduleList.add(phyIndex);
        }
        if (chassisList.size() > 0) {
            int[] chIndexes = new int[chassisList.size()];
            for (int i = 0; i < chassisList.size(); ++i) {
                chIndexes[i] = (Integer)chassisList.get(i);
            }
            map = CdpSnmpAdapter.getFexEntityInfoByIndex(sw.getPeer(), chIndexes);
            List<Map> moduleEntList = map.get((Object)HwInventoryType.CHASSIS);
            for (Map entMap : moduleEntList) {
                int phyIndex = (Integer)entMap.get("entPhysicalIndex");
                fexId = NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex);
                fex = sw.findFexById(fexId);
                if (fex == null) {
                    _Tracer.warn(sw.getIpAddress() + " cannot find fex:" + entMap);
                    continue;
                }
                int classType = (Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[0]);
                if (classType != HwInventoryType.CHASSIS.value()) {
                    _Tracer.warn(sw.getIpAddress() + " get invalid fex chassis entity map:" + entMap);
                    continue;
                }
                String serialNo = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[7]);
                if (!fex.getFexPK()._serialNum.equals(serialNo)) {
                    _Tracer.warn(sw.getIpAddress() + " get invalid fex chassis entity map:" + entMap);
                    continue;
                }
                vendorType = (int[])entMap.get(CdpSnmpAdapter.EntTable_MibCmds[2]);
                if (vendorType == null || vendorType.length <= 0) continue;
                fex.setSysObjectID(vendorType);
            }
        }
        if (moduleList.size() > 0) {
            int[] mIndexes = new int[chassisList.size()];
            for (int i = 0; i < moduleList.size(); ++i) {
                mIndexes[i] = (Integer)moduleList.get(i);
            }
            map = CdpSnmpAdapter.getFexEntityInfoByIndex(sw.getPeer(), mIndexes);
            List<Map> moduleEntList = map.get((Object)HwInventoryType.MODULE);
            for (Map entMap : moduleEntList) {
                int phyIndex = (Integer)entMap.get("entPhysicalIndex");
                fexId = NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex);
                fex = sw.findFexById(fexId);
                String modelName = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[9]);
                String version = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[6]);
                fex.setModelName(modelName);
                fex.setVersion(version);
                vendorType = (int[])entMap.get(CdpSnmpAdapter.EntTable_MibCmds[2]);
                if (vendorType != null && vendorType.length > 0) {
                    fex.updateNumPorts(vendorType);
                    int vendorOid = CdpDiscvHelper.getVendorOidFromSysOid(vendorType);
                    String vendorId = BaseModelConstants.getVendorFromSysOid(vendorOid);
                    fex.setVendor(vendorId);
                }
                int linkStart = NexusEntityMibHelper.getFexLinkEdgePhyIndex(swRev, fexId);
                int linkEnd = NexusEntityMibHelper.getFexLinkEdgeMaxPhyIndex(swRev, fexId, fex.getBase().getNumUplEthPort());
                for (int i = linkStart; i <= linkEnd; ++i) {
                    linkList.add(i);
                }
            }
        }
        if (linkList.size() > 0) {
            int[] phyIndexes = new int[linkList.size()];
            for (int i = 0; i < linkList.size(); ++i) {
                phyIndexes[i] = (Integer)linkList.get(i);
            }
            Map<Integer, String> linkMap = CdpSnmpAdapter.getFexIsls(sw.getPeer(), phyIndexes);
            if (linkMap == null) {
                return false;
            }
            for (Map.Entry<Integer, String> ent : linkMap.entrySet()) {
                FexImpl fex4;
                int swPortIfindex;
                int idx2;
                int phyIndex = ent.getKey();
                int fexId3 = NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex);
                int fexPortId = NexusEntityMibHelper.getFexPortByPhyIndex(phyIndex);
                String linkDesc = ent.getValue().toLowerCase();
                String swPortStr = null;
                int idx1 = linkDesc.indexOf(FexLink_coreport);
                if (idx1 >= 0 && (idx2 = linkDesc.indexOf(FexLink_cable)) > (idx1 += FexLink_coreport.length())) {
                    swPortStr = linkDesc.substring(idx1, idx2).trim();
                }
                if (swPortStr == null || (swPortIfindex = sw.getBase().nameToIfIndex(swPortStr)) == -1 || (fex4 = sw.findFexById(fexId3)) == null) continue;
                int fexPortIfindex = fex4.getBase().uplIfNameToIfIndex(fexPortId);
                EthIslImpl ethIsl = lan.findEthIsl(sw.getSwitchPK(), fex4.getFexPK(), swPortIfindex, fexPortIfindex);
                if (ethIsl != null) {
                    ethIsl.setPresent(true);
                    lan.addEthIsl(ethIsl);
                    oldFexLinks.remove(ethIsl);
                } else {
                    EthPortImpl fexPort;
                    EthPortImpl swPort = lan.findEthPort(sw.getPK(), swPortIfindex);
                    if (swPort == null) {
                        swPort = DCManager.getInstance().createEthPort(sw, swPortIfindex);
                        sw.addEthPort(swPort);
                    }
                    if ((fexPort = lan.findEthPort(fex4.getPK(), fexPortIfindex)) == null) {
                        fexPort = DCManager.getInstance().createEthPort(fex4, fexPortIfindex);
                        fex4.addEthPort(fexPort);
                    }
                    ethIsl = DCManager.getInstance().createFexIsl(lan, sw, fex4, swPort, fexPort);
                    lan.addEthIsl(ethIsl);
                }
                ethIsl.syncLastScanTime();
            }
        }
        for (FexIslImpl ethIsl : oldFexLinks) {
            ethIsl.setPresent(false);
        }
        for (FexImpl fex5 : oldFexList) {
            fex5.setPresent(false);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(sw.getPeer(), "discoverFexAndLink", sw.getFexes());
        }
        return true;
    }

    public static boolean discoverSatEthPorts(EthSwitchImpl sw, boolean upOnly) throws SnmpException {
        if (sw == null || sw.getPeer() == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(sw.getPeer(), "discoverFexEthPorts");
        }
        if (!sw.isFexEnabled() || !sw.isFexCapableVersion() || sw.getBase().getNumOfFex() < 1) {
            if (_Tracer.isDebuggable()) {
                _Tracer.debug(sw.getIpAddress() + " skip discoverFexEthPorts for no fex found");
            }
            return false;
        }
        List<EthPortImpl> oldPorts = sw.getEthPorts();
        HashMap<Integer, EthPortImpl> oldSatPortMap = new HashMap<Integer, EthPortImpl>(oldPorts.size());
        for (EthPortImpl port : oldPorts) {
            if (!IfIndexUtil.isSatEthIfIndex(port.getIfIndex())) continue;
            oldSatPortMap.put(port.getIfIndex(), port);
        }
        ArrayList<Integer> satIfindexList = new ArrayList<Integer>();
        List<FexImpl> fexList = sw.getFexes();
        for (FexImpl fex : fexList) {
            int ifindexStart = IfIndexUtil.nameToIfIndexFex(fex.getFexId(), 1, 1);
            int ifindexEnd = IfIndexUtil.nameToIfIndexFex(fex.getFexId(), 1, fex.getBase().getNumSatEthPort());
            for (int i = ifindexStart; i <= ifindexEnd; ++i) {
                satIfindexList.add(i);
            }
        }
        if (satIfindexList.size() < 1) {
            if (_Tracer.isDebuggable()) {
                _Tracer.debug(sw.getIpAddress() + " skip discoverFexEthPorts for no sat port found");
            }
            Iterator<FexImpl> i$ = oldSatPortMap.keySet().iterator();
            while (i$.hasNext()) {
                int ifindex = (Integer)((Object)i$.next());
                sw.removeEthPort(ifindex, true);
            }
            return false;
        }
        Collections.sort(satIfindexList);
        int[] satIfindexes = new int[satIfindexList.size()];
        for (int i = 0; i < satIfindexes.length; ++i) {
            satIfindexes[i] = (Integer)satIfindexList.get(i);
        }
        Map<Integer, Object> statusMap = CdpSnmpAdapter.getEthIfValue(sw.getPeer(), satIfindexes, 6);
        if (statusMap == null || statusMap.size() == 0) {
            if (_Tracer.isDebuggable()) {
                _Tracer.debug(sw.getIpAddress() + " skip discoverFexEthPorts for no sat port found");
            }
            Iterator i$ = oldSatPortMap.keySet().iterator();
            while (i$.hasNext()) {
                int ifindex = (Integer)i$.next();
                sw.removeEthPort(ifindex, true);
            }
            return false;
        }
        for (Map.Entry<Integer, Object> ent : statusMap.entrySet()) {
            int ifindex = ent.getKey();
            int status = (Integer)ent.getValue();
            if (upOnly && status != 1) continue;
            EthPortImpl ethport = (EthPortImpl)oldSatPortMap.get(ifindex);
            if (ethport != null) {
                ethport.setIfOperMode(status);
                oldSatPortMap.remove(ifindex);
                continue;
            }
            ethport = DCManager.getInstance().createEthPort(sw, ifindex);
            ethport.setIfOperMode(status);
            sw.addEthPort(ethport);
        }
        Iterator<Map.Entry<Integer, Object>> i$ = oldSatPortMap.keySet().iterator();
        while (i$.hasNext()) {
            int ifindex = (Integer)((Object)i$.next());
            sw.removeEthPort(ifindex, true);
        }
        return true;
    }

    public static boolean discoverEthPortIfname(EthSwitchImpl sw) throws Exception {
        if (sw == null || !sw.getBase().isCAT()) {
            throw new IllegalArgumentException("invalid etherent node:" + sw);
        }
        int[] ifindexes = sw.getIfindexes();
        if (ifindexes == null || ifindexes.length == 0) {
            return false;
        }
        Map<Integer, Object> ifMap = CdpSnmpAdapter.getEthIfValue(sw.getPeer(), ifindexes, 0);
        if (ifMap == null || ifMap.size() == 0) {
            return false;
        }
        HashMap<String, String> mappingTable = new HashMap<String, String>(ifMap.size() * 2);
        for (Map.Entry<Integer, Object> ent : ifMap.entrySet()) {
            int ifindex = ent.getKey();
            String ifdesc = (String)ent.getValue();
            if (ifdesc == null) continue;
            ifdesc = IfIndexUtil.formatIfName(ifdesc, sw.getBase().isCAT());
            mappingTable.put(String.valueOf(ifindex), ifdesc);
            mappingTable.put(ifdesc, String.valueOf(ifindex));
            EthPortImpl ethport = sw.findEthPort(ifindex);
            if (ethport == null) continue;
            ethport.setIfname(ifdesc);
            ethport.setIfDescr(ifdesc);
        }
        sw.updateCatIfMappingTable(mappingTable);
        return false;
    }

    public static int[] discoverIfIndexes(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid etherent node:" + ethSw);
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(CdpSnmpAdapter._EthIfOperStatusOid);
        SnmpPDU rspPdu = SnmpFetch.getBulk(ethSw.getPeer(), vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        ArrayList<Integer> ifIndexes = new ArrayList<Integer>();
        for (SnmpVarBind vb : rspVbl) {
            short operStatus = (short)((SnmpInt)vb.getVar()).getValue();
            int ifIndex = vb.getOid().getIndexFromEnd(0);
            int iftype = IfIndexUtil.getType(ifIndex);
            ifIndexes.add(new Integer(ifIndex));
        }
        int[] results = new int[ifIndexes.size()];
        for (int i = 0; i < ifIndexes.size(); ++i) {
            results[i] = (Integer)ifIndexes.get(i);
        }
        return results;
    }

    public static boolean discoverEthPortInfo(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid etherent node:" + ethSw);
        }
        return CdpDiscvHelper.discoverEthPortInfo(ethSw, ethSw.getIfindexes());
    }

    public static boolean discoverEthPortInfo(EthSwitchImpl sw, int[] ifindexes) throws Exception {
        if (sw == null) {
            throw new IllegalArgumentException("invalid etherent node:" + sw);
        }
        if (ifindexes == null || ifindexes.length == 0) {
            return true;
        }
        boolean hasSharedIf = sw.isVdc();
        Map<Integer, Map> ifMap = CdpSnmpAdapter.getEthPortInfo(sw.getPeer(), ifindexes, hasSharedIf);
        if (ifMap == null) {
            return false;
        }
        HashMap<String, String> ifMapping = new HashMap<String, String>();
        for (Map.Entry<Integer, Map> ifEntry : ifMap.entrySet()) {
            int ifindex = ifEntry.getKey();
            Map ifAttrs = ifEntry.getValue();
            String ifdescr = (String)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[0]);
            EthPortImpl port = DCManager.getInstance().createEthPort(sw, ifindex);
            if (port == null) continue;
            if (ifdescr != null && ifdescr.equalsIgnoreCase("n/a")) {
                ifdescr = null;
            }
            if (ifdescr != null) {
                ifdescr = IfIndexUtil.formatIfName(ifdescr, sw.getBase().isCAT());
                if (sw.getBase().isMDS() && FRUConstants.isIPStorageCapablePlatform(sw.getBase().getModelType())) {
                    ifdescr = IfIndexUtil.convertIfName4IPStorage(ifdescr);
                }
            }
            port.setIfDescr(ifdescr);
            port.setIfAlias((String)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[8]));
            port.setIfType((Integer)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[1]));
            port.setIfMtu((Integer)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[2]));
            long speed = (Long)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[3]);
            if (speed == 0xFFFFFFFFL) {
                speed = (Long)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[7]) * 1000000L;
            }
            port.setIfSpeed(speed);
            port.setIfOperMode((Integer)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[6]));
            port.setIfPhysicalAddress((MacAddress)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[4]));
            int operStatusCause = (Integer)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[9]);
            port.setOperStatusCause((short)operStatusCause);
            int ifAdminStatus = (Integer)ifAttrs.get(CdpSnmpAdapter.EthIf_MibCmds[5]);
            port.setIfAdminStatus((short)ifAdminStatus);
            if (ifdescr != null) {
                port.setIfname(ifdescr);
            }
            if (IfIndexUtil.getType(ifindex) != 9) {
                ifMapping.put(String.valueOf(ifindex), ifdescr);
                ifMapping.put(ifdescr, String.valueOf(ifindex));
            }
            if (hasSharedIf) {
                port.setSharedMode((Integer)ifAttrs.get("cieIfSharedConfig"));
            } else {
                port.setSharedMode(2);
            }
            port.syncLastScanTime();
            sw.addEthPort(port);
        }
        if (ifMapping.size() > 0) {
            sw.updateCatIfMappingTable(ifMapping);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.TRACE, sw.getIpAddress() + " discoverEthPortInfo() -- " + sw.getAllPorts());
        }
        return true;
    }

    public static boolean discoverEthPortInfoByNetConf(EthSwitchImpl sw) {
        if (PlatformType.isNexusSwitch(sw.getPlatformType())) {
            if (sw.getCredential().getSecurityModel() != 3) {
                _Tracer.log(Level.WARN, "Not SNMP V3.  Returning without show interface brief discovery !!!!");
                return false;
            }
            IEthPortAdapter ethPortAdapter = null;
            try {
                if (sw.getPeer() != null) {
                    ethPortAdapter = CliAdapterFactory.getEthPortAdapter((EthSwitchImpl)sw);
                    if (ethPortAdapter == null) {
                        _Tracer.log(Level.WARN, "Unable to get EthPort adapter for ethSw: " + sw.getIpAddress());
                        return false;
                    }
                } else {
                    _Tracer.log(Level.WARN, "Unable to get Peer from the ethSW: " + sw.getIpAddress());
                    return false;
                }
                ethPortAdapter.updateEthPortImplByShowIntfBriefXml();
            }
            catch (Exception e) {
                if (e instanceof NotSupportedException) {
                    _Tracer.log(Level.WARN, "'" + sw.getIpAddress() + "'" + e.getMessage());
                } else {
                    _Tracer.log(Level.WARN, "discoverEthPortInfoByNetConf() caught exception for the switch '" + sw.getIpAddress() + "'", e);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean discoverEthPortVlans(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid etherent node:" + ethSw);
        }
        return CdpDiscvHelper.discoverEthPortVlans(ethSw, ethSw.getIfindexes());
    }

    public static boolean discoverEthPortVlans(EthSwitchImpl ethSw, int[] ifindexes) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid etherent node:" + ethSw);
        }
        if (ifindexes == null || ifindexes.length == 0) {
            return true;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(ethSw, "discoverEthPortVlans");
        }
        LanImpl lan = ethSw.getLan();
        HashSet<Short> oldSwVlanIds = new HashSet<Short>(ethSw.getBase().getVlans());
        Map<Integer, Map<String, Object>> vlanMap = CdpSnmpAdapter.getEthPortAccessVlans(ethSw.getPeer(), ifindexes);
        if (vlanMap != null && vlanMap.size() > 0) {
            ArrayList<Integer> trunkIfindexes = new ArrayList<Integer>();
            for (Map.Entry<Integer, Map<String, Object>> ent : vlanMap.entrySet()) {
                EthPortImpl ethPort = ethSw.findEthPort(ent.getKey());
                if (ethPort == null) continue;
                Map<String, Object> vlanAttrs = ent.getValue();
                Integer v = null;
                v = (Integer)vlanAttrs.get(CdpSnmpAdapter.PortAccessVlan_MibCmds[0]);
                if (v != null) {
                    ethPort.setVlanType(v);
                    if (v == 3) {
                        ethPort.setTrunkMode((byte)1);
                        trunkIfindexes.add(ethPort.getIfIndex());
                    } else {
                        ethPort.setTrunkMode((byte)2);
                        ethPort.setVlans(new ArrayList<Short>());
                    }
                }
                if ((v = (Integer)vlanAttrs.get(CdpSnmpAdapter.PortAccessVlan_MibCmds[1])) != null) {
                    ethPort.setVlanStatus(v);
                }
                if ((v = (Integer)vlanAttrs.get(CdpSnmpAdapter.PortAccessVlan_MibCmds[2])) == null) continue;
                ethPort.setAccessVlan((short)v.intValue());
                short accessVlan = ethPort.getBase().getAccessVlan();
                if (accessVlan <= 0 || ethPort.getBase().getVlanType() == 3) continue;
                ethSw.addVlan(accessVlan);
                oldSwVlanIds.remove(accessVlan);
                ArrayList<Short> activeVlans = new ArrayList<Short>(1);
                activeVlans.add(accessVlan);
                ethPort.setVlans(activeVlans);
            }
        }
        if (ethSw.isFCoECapableVersion() && (vlanMap = CdpSnmpAdapter.getEthPortTrunkVlans(ethSw.getPeer(), ifindexes)) != null && vlanMap.size() > 0) {
            for (Map.Entry entry : vlanMap.entrySet()) {
                EthPortImpl ethPort = ethSw.findEthPort((Integer)entry.getKey());
                if (ethPort == null) continue;
                Map vlanAttrs = (Map)entry.getValue();
                Integer v = null;
                v = (Integer)vlanAttrs.get(CdpSnmpAdapter.PortTrunkVlan_MibCmds[0]);
                if (v != null) {
                    byte trunk = (byte)v.intValue();
                    ethPort.setTrunkMode(trunk);
                }
                if ((v = (Integer)vlanAttrs.get(CdpSnmpAdapter.PortTrunkVlan_MibCmds[1])) != null) {
                    ethPort.setNativeVlan((short)v.intValue());
                }
                if (!ethPort.getBase().isTrunked()) continue;
                List activeVlans = (List)vlanAttrs.get(CdpSnmpAdapter.PortTrunkVlan_MibCmds[2]);
                ArrayList<Short> vidList = new ArrayList<Short>();
                if (activeVlans != null) {
                    Iterator i$ = activeVlans.iterator();
                    while (i$.hasNext()) {
                        short vid = (Short)i$.next();
                        if (vid <= 0) continue;
                        VlanImpl vlan = lan.findVlanById(vid);
                        if (vlan == null) {
                            vlan = DCManager.getInstance().createVlan(lan, vid);
                        }
                        ethSw.addVlan(vid);
                        oldSwVlanIds.remove(vid);
                        vidList.add(vid);
                    }
                }
                ethPort.setVlans(vidList);
            }
        }
        Iterator<Object> i$ = oldSwVlanIds.iterator();
        while (i$.hasNext()) {
            short s = i$.next();
            ethSw.removeVlan(s);
        }
        if (_Tracer.isTraceable()) {
            ArrayList<EthPortImpl> ethports = ethSw.getAllPorts();
            for (EthPortImpl port : ethports) {
                _Tracer.log(Level.TRACE, ethSw + "--discoverPortVlans:" + port.getBase().print(true, true));
            }
            _Tracer.traceFuncEnd(ethSw, "discoverPortVlans", ethSw.getBase().getVlanIdsAsString());
        }
        return true;
    }

    public static boolean discoverLicenses(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        Map<String, Map<String, Object>> licMap = CdpSnmpAdapter.getNexusLicenses(ethSw.getPeer());
        InventoryManager im = InventoryManager.getInstance();
        Set<String> preLicNames = im.findLicenseNames(ethSw.getSwitchPK());
        for (String licName : licMap.keySet()) {
            Map<String, Object> lic = licMap.get(licName);
            byte[] licFlag = (byte[])lic.get(CdpSnmpAdapter.License_MibCmds[0]);
            int curUsage = (Integer)lic.get(CdpSnmpAdapter.License_MibCmds[1]);
            int maxUsage = (Integer)lic.get(CdpSnmpAdapter.License_MibCmds[2]);
            int misUsage = (Integer)lic.get(CdpSnmpAdapter.License_MibCmds[3]);
            byte[] expDate = (byte[])lic.get(CdpSnmpAdapter.License_MibCmds[4]);
            int gracePeriod = (Integer)lic.get(CdpSnmpAdapter.License_MibCmds[5]);
            int gracePeriodLeft = (Integer)lic.get(CdpSnmpAdapter.License_MibCmds[6]);
            LicenseInfo licInfo = im.createLicense(ethSw.getSwitchPK(), licName, licFlag[0], curUsage, maxUsage, misUsage, expDate, gracePeriod);
            preLicNames.remove(licName);
        }
        Iterator it = preLicNames.iterator();
        while (it.hasNext()) {
            im.deleteLicense(ethSw.getSwitchPK(), (String)it.next());
        }
        return true;
    }

    public static int discoverNumLicense(EthSwitchImpl ethSw) throws Exception {
        return CdpSnmpAdapter.getNexusNumOfLicenses(ethSw.getPeer());
    }

    public static boolean discoverEthPorts(EthSwitchImpl ethSw) throws Exception {
        return CdpDiscvHelper.discoverEthPorts(ethSw, true, new int[]{6, 53, 224});
    }

    public static boolean discoverEthPorts(EthSwitchImpl ethSw, boolean upOnly, int[] portTypes) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        List<Integer> list = CdpSnmpAdapter.getEthIfIndexes(ethSw.getPeer(), true, new int[]{6, 53, 224});
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(ethSw, "discoverEthPorts");
        }
        int[] ifindexes = null;
        if (list != null && list.size() > 0) {
            ifindexes = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ifindexes[i] = list.get(i);
            }
        } else {
            ifindexes = ethSw.getIfindexes();
        }
        ethSw.setNumEthPorts(ifindexes == null ? 0 : ifindexes.length);
        if (list != null) {
            list.clear();
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(ethSw, "discoverEthPorts", ethSw.getAllPorts());
        }
        return CdpDiscvHelper.discoverEthPortInfo(ethSw, ifindexes);
    }

    public static boolean discoverEthChannelPorts(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        if (ethSw.getBase().isCAT()) {
            return CdpDiscvHelper.discoverCatEthChannelPorts(ethSw);
        }
        return CdpDiscvHelper.discoverNxEthChannelPorts(ethSw);
    }

    public static boolean discoverCatEthChannelPorts(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null || !ethSw.getBase().isCAT()) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        LanImpl lan = DCManager.getInstance().getLan();
        Map<Integer, Map> port2channelMap = CdpSnmpAdapter.getCatEthChannelInfo(ethSw.getPeer(), ethSw.getIfindexes());
        if (port2channelMap == null) {
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(ethSw, "discoverCatEthChannelPorts");
        }
        List<EthPortImpl> oldChannelPorts = ethSw.getChannelEthPorts();
        HashSet<Integer> oldChannelIndexes = new HashSet<Integer>();
        HashMap<Integer, HashSet<Integer>> oldChannelChildren = new HashMap<Integer, HashSet<Integer>>();
        for (EthPortImpl channelPort : oldChannelPorts) {
            oldChannelIndexes.add(channelPort.getIfIndex());
            oldChannelChildren.put(channelPort.getIfIndex(), new HashSet<Integer>(channelPort.getBase().getChildren()));
        }
        HashSet<SwitchIntKeyIf> newRemoteChannel = new HashSet<SwitchIntKeyIf>();
        for (Map.Entry<Integer, Map> entry : port2channelMap.entrySet()) {
            EthPortImpl rChannelPort;
            EthSwitchImpl remoteSw;
            InetAddress remoteSwIp;
            Integer locChannelIfindex;
            int locChildIfindex = entry.getKey();
            Map pcMap = entry.getValue();
            if (pcMap == null || (locChannelIfindex = (Integer)pcMap.get(CdpSnmpAdapter.CatEthChannelMap_MibCmds[0])) == null) continue;
            ethSw.addChildPort(locChannelIfindex, locChildIfindex);
            oldChannelIndexes.remove(locChannelIfindex);
            HashSet oldChildren = (HashSet)oldChannelChildren.get(locChannelIfindex);
            if (oldChildren != null) {
                oldChildren.remove(locChildIfindex);
            }
            Integer remoteChannelIndex = (Integer)pcMap.get(CdpSnmpAdapter.CatEthChannel_MibCmds[3]);
            Integer remoteChildIndex = (Integer)pcMap.get(CdpSnmpAdapter.CatEthChannel_MibCmds[2]);
            if (remoteChannelIndex == null || remoteChannelIndex < 1 || remoteChildIndex == null || remoteChildIndex < 1 || (remoteSwIp = (InetAddress)pcMap.get(CdpSnmpAdapter.CatEthChannel_MibCmds[1])) == null || (remoteSw = lan.findEthSwitchByIp(remoteSwIp)) == null || remoteSw.isManageable() || (rChannelPort = remoteSw.findEthPort(remoteChannelIndex)) != null && !rChannelPort.getBase().isChannel()) continue;
            if (rChannelPort != null && !newRemoteChannel.contains(rChannelPort.getSwitchPortPK())) {
                for (int remoteChildIfindex : rChannelPort.getBase().getChildren()) {
                    remoteSw.removeChildPort(remoteChannelIndex, remoteChildIfindex);
                }
            }
            remoteSw.addChildPort(remoteChannelIndex, remoteChildIndex);
            rChannelPort = remoteSw.findEthPort(remoteChannelIndex);
            if (rChannelPort == null) continue;
            newRemoteChannel.add(rChannelPort.getSwitchPortPK());
        }
        for (Map.Entry entry : oldChannelChildren.entrySet()) {
            int channelIndex = entry.getKey();
            Iterator i$ = ((HashSet)((Object)entry.getValue())).iterator();
            while (i$.hasNext()) {
                int childIndex = (Integer)i$.next();
                ethSw.removeChildPort(channelIndex, childIndex);
            }
        }
        for (Integer n : oldChannelIndexes) {
            ethSw.removeEthPort(n, true);
        }
        for (Map map : port2channelMap.values()) {
            map.clear();
        }
        port2channelMap.clear();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(ethSw, "discoverCatEthChannelPorts", ethSw.getAllPorts());
        }
        return true;
    }

    public static boolean discoverNxEthChannelPorts(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null || ethSw.getBase().isCAT()) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        LanImpl lan = DCManager.getInstance().getLan();
        Map<Integer, int[]> port2channelMap = CdpSnmpAdapter.getNxEthChannelMap(ethSw.getPeer());
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(ethSw, "discoverNxEthChannelPorts");
        }
        List<EthPortImpl> oldChannelPorts = ethSw.getChannelEthPorts();
        HashSet<Integer> oldChannelIndexes = new HashSet<Integer>();
        HashMap<Integer, HashSet<Integer>> oldChannelChildren = new HashMap<Integer, HashSet<Integer>>();
        for (EthPortImpl ethPortImpl : oldChannelPorts) {
            oldChannelIndexes.add(ethPortImpl.getIfIndex());
            oldChannelChildren.put(ethPortImpl.getIfIndex(), new HashSet<Integer>(ethPortImpl.getBase().getChildren()));
        }
        if (port2channelMap == null) {
            return false;
        }
        for (Map.Entry entry : port2channelMap.entrySet()) {
            int locChannelIfindex = (Integer)entry.getKey();
            int[] childports = (int[])entry.getValue();
            oldChannelIndexes.remove(locChannelIfindex);
            for (int locChildIfindex : childports) {
                ethSw.addChildPort(locChannelIfindex, locChildIfindex);
                HashSet oldChildren = (HashSet)oldChannelChildren.get(locChannelIfindex);
                if (oldChildren == null) continue;
                oldChildren.remove(locChildIfindex);
            }
        }
        for (Map.Entry entry : oldChannelChildren.entrySet()) {
            int channelIndex = (Integer)entry.getKey();
            Iterator i$ = ((HashSet)entry.getValue()).iterator();
            while (i$.hasNext()) {
                int childIndex = (Integer)i$.next();
                ethSw.removeChildPort(channelIndex, childIndex);
            }
        }
        for (Integer n : oldChannelIndexes) {
            ethSw.removeEthPort(n, true);
        }
        port2channelMap.clear();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(ethSw, "discoverNxEthChannelPorts", ethSw.getAllPorts());
        }
        return true;
    }

    public static boolean isNodeReachable(EthNodeIf node) {
        if (node == null || !node.hasPeer()) {
            return false;
        }
        if (!CdpSnmpAdapter.isPeerReachable(node.getPeer())) {
            _Tracer.log(Level.DEBUG, node + " is not reachable");
            return false;
        }
        return true;
    }

    public static void discoverCatUsage(EthSwitchImpl sw) throws Exception {
        if (sw == null || !sw.hasPeer() || !PlatformType.isTypeOf(sw.getPlatformType(), PlatformType.CAT)) {
            throw new IllegalArgumentException("invalid ethernet node:" + sw);
        }
        Map<String, Long> usageMap = CdpSnmpAdapter.getCatUsage(sw.getPeer());
        if (usageMap.size() == 0) {
            return;
        }
        Long cpu = usageMap.get(CdpSnmpAdapter.CatUsage_MibCmds[0]);
        if (cpu != null) {
            sw.setSysCpuUsage(cpu.intValue());
        }
        Long usedMem = usageMap.get(CdpSnmpAdapter.CatUsage_MibCmds[1]);
        Long freeMem = usageMap.get(CdpSnmpAdapter.CatUsage_MibCmds[2]);
        if (usedMem != null && freeMem != null) {
            sw.setSysMemoryUsage((int)(usedMem * 100L / (usedMem + freeMem)));
        }
    }

    public static void discoverNxUsage(EthSwitchImpl sw) throws Exception {
        Long mem;
        if (sw == null || !sw.hasPeer() || PlatformType.isTypeOf(sw.getPlatformType(), PlatformType.CAT)) {
            throw new IllegalArgumentException("invalid ethernet node:" + sw);
        }
        Map<String, Long> usageMap = CdpSnmpAdapter.getNxUsage(sw.getPeer());
        if (usageMap.size() == 0) {
            return;
        }
        Long cpu = usageMap.get(CdpSnmpAdapter.NxUsage_MibCmds[0]);
        if (cpu != null) {
            sw.setSysCpuUsage(cpu.intValue());
        }
        if ((mem = usageMap.get(CdpSnmpAdapter.NxUsage_MibCmds[1])) != null) {
            sw.setSysMemoryUsage(mem.intValue());
        }
    }

    public static boolean checkChassis(EthNodeIf node) throws Exception {
        String modelName;
        if (node == null) {
            throw new IllegalArgumentException("invalid etherent node:" + node);
        }
        SnmpPeer peer = node.getPeer();
        Map chassisMap = CdpSnmpAdapter.getChassisInfo(peer, node.getPlatformType());
        if (chassisMap.size() == 0) {
            return false;
        }
        String serialNumStr = (String)chassisMap.get(CdpSnmpAdapter.EntTable_MibCmds[7]);
        if (serialNumStr != null && serialNumStr.trim().length() > 0) {
            node.setSerialNumber(serialNumStr);
        }
        if ((modelName = (String)chassisMap.get(CdpSnmpAdapter.EntTable_MibCmds[9])) != null && modelName.trim().length() > 0) {
            node.setModelName(FRUConstants.getModelName(modelName));
            if (node.getPlatformType() == null || node.getPlatformType() == PlatformType.UNKNOWN) {
                node.setPlatform(modelName);
            }
        }
        return true;
    }

    public static int discoverNexusActiveSupIndex(EthNodeIf node) throws SnmpException {
        Integer activeSupIndex;
        if (node == null) {
            throw new IllegalArgumentException("invalid etherent node:" + node);
        }
        Map<String, Integer> reduMap = CdpSnmpAdapter.getRedundancyInfo(node.getPeer());
        if (reduMap != null && (activeSupIndex = reduMap.get(CdpSnmpAdapter.CiscoRF_MibCmds[0])) != null) {
            return activeSupIndex;
        }
        return -1;
    }

    public static boolean checkNexusActiveSup(EthNodeIf node) throws SnmpException {
        int activeSupIndex = CdpDiscvHelper.discoverNexusActiveSupIndex(node);
        if (activeSupIndex < 0) {
            return false;
        }
        String version = CdpSnmpAdapter.getNxVersion(node.getPeer(), activeSupIndex);
        if (version == null) {
            return false;
        }
        node.setVersion(version);
        return true;
    }

    public static boolean checkHwChanged(EthSwitchImpl sw) throws Exception {
        if (sw == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        SnmpPeer peer = sw.getPeer();
        Map<String, Long> entChgMap = CdpSnmpAdapter.getEntityLastChange(peer);
        boolean changed = false;
        try {
            long entLastChgTime = entChgMap.get(CdpSnmpAdapter.EntLastChange_MibCmds[0]);
            int activeSupPhyIndex = (int)entChgMap.get(CdpSnmpAdapter.EntLastChange_MibCmds[1]).longValue();
            if (entLastChgTime != sw._entLastChangeTime) {
                sw._entLastChangeTime = entLastChgTime;
                changed = true;
            }
            if (activeSupPhyIndex != sw.getBase().getActiveSupPhysicalIndex()) {
                sw.setActiveSupPhyIndex(activeSupPhyIndex);
                changed = true;
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.WARN, sw + " cannot check entity last change", e);
        }
        return changed;
    }

    public static boolean discoverHwEntities(EthSwitchImpl sw) throws Exception {
        PKIf swPK;
        if (sw == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        InventoryManager im = InventoryManager.getInstance();
        Map<HwInventoryType, List<Map>> hwMap = CdpSnmpAdapter.getAllEntityInfo(sw.getPeer(), sw.getPlatformType());
        if (hwMap == null || hwMap.size() == 0) {
            return false;
        }
        int activeSupUnitId = -1;
        int standbySupUnitId = -1;
        int activeRFState = -1;
        int standbyRFState = -1;
        try {
            Map<String, Integer> rdMap = CdpSnmpAdapter.getRedundancyInfo(sw.getPeer());
            if (rdMap != null && rdMap.size() > 0) {
                activeSupUnitId = rdMap.get(CdpSnmpAdapter.CiscoRF_MibCmds[0]);
                standbySupUnitId = rdMap.get(CdpSnmpAdapter.CiscoRF_MibCmds[2]);
                activeRFState = rdMap.get(CdpSnmpAdapter.CiscoRF_MibCmds[1]);
                standbyRFState = rdMap.get(CdpSnmpAdapter.CiscoRF_MibCmds[3]);
                sw.setActiveSupState(activeRFState);
                sw.setStandbySupState(standbyRFState);
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, sw + " cannot get switch redundancy information", e);
        }
        List<Map> entList = hwMap.get((Object)HwInventoryType.CHASSIS);
        HwInventoryComponent chassis = null;
        if (entList != null && entList.size() > 0) {
            Map entMap;
            Iterator<Map> i$ = entList.iterator();
            while (i$.hasNext() && (chassis = CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.CHASSIS, null, entMap = i$.next(), true, true, false)) == null) {
            }
        }
        boolean hasModuleChange = false;
        Set<Integer> oldCards = im.findCardSlotIds(sw.getPK());
        entList = hwMap.get((Object)HwInventoryType.MODULE);
        if (entList != null && entList.size() > 0) {
            for (Map entMap : entList) {
                Card card = (Card)CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.MODULE, null, entMap, true, true, false);
                if (card == null) continue;
                if (!oldCards.remove(card.getSlotId())) {
                    hasModuleChange = true;
                }
                if (!card.isSupervisor()) continue;
                int cardSupUnitId = -1;
                cardSupUnitId = PlatformType.isTypeOf(sw.getPlatformType(), PlatformType.CAT) ? card.getSlotId() : card.getPhysicalIndex();
                if (card.getSoftwareRevision() != null && (activeSupUnitId == -1 || activeSupUnitId == cardSupUnitId)) {
                    card.setActive(true);
                    sw.setActiveSupPhyIndex(card.getPhysicalIndex());
                    sw.setActiveSupSlot(card.getSlotId());
                    sw.setModuleIndexOffset(card.getPhysicalIndex() - card.getSlotId());
                    sw.setVersion(card.getSoftwareRevision());
                    continue;
                }
                sw.setStandbySupPhyIndex(card.getPhysicalIndex());
                sw.setStandbySupSlot(card.getSlotId());
            }
        }
        Set<Integer> oldPowers = im.findPowerSupplySlotIds(sw.getPK());
        entList = hwMap.get((Object)HwInventoryType.POWERSUPPLY);
        if (entList != null && entList.size() > 0) {
            for (Map entMap : entList) {
                PowerSupply ps = (PowerSupply)CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.POWERSUPPLY, null, entMap, true, true, false);
                if (ps == null) continue;
                oldPowers.remove(ps.getSlotId());
            }
        }
        Set<Integer> oldFans = im.findFanSlotIds(sw.getPK());
        entList = hwMap.get((Object)HwInventoryType.FAN);
        if (entList != null && entList.size() > 0) {
            for (Map entMap : entList) {
                HwInventoryComponent fan = CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.FAN, null, entMap, true, true, false);
                if (fan == null) continue;
                oldFans.remove(fan.getSlotId());
            }
        }
        if (sw.isVdc()) {
            swPK = (VdcPK)sw.getSwitchPK();
            for (int slotId : oldCards) {
                im.deleteCard(swPK, slotId);
                hasModuleChange = true;
            }
            for (int slotId : oldFans) {
                im.deleteFan(swPK, slotId);
            }
            for (int slotId : oldPowers) {
                im.deletePowerSupply(swPK, slotId);
            }
        } else {
            swPK = (SerialNumKey)sw.getSwitchPK();
            for (int slotId : oldCards) {
                im.deleteCard(swPK, slotId);
                hasModuleChange = true;
            }
            for (int slotId : oldFans) {
                im.deleteFan(swPK, slotId);
            }
            for (int slotId : oldPowers) {
                im.deletePowerSupply(swPK, slotId);
            }
        }
        if (hasModuleChange) {
            sw.checkFCoECard();
        }
        return true;
    }

    public static boolean updateHwEntityStatus(EthSwitchImpl sw) throws Exception {
        if (sw == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        InventoryManager im = InventoryManager.getInstance();
        HashMap<Integer, HwInventoryComponent> entIdxMap = new HashMap<Integer, HwInventoryComponent>();
        HwInventoryType[] hwTypes = new HwInventoryType[]{HwInventoryType.MODULE, HwInventoryType.POWERSUPPLY, HwInventoryType.FAN, HwInventoryType.CHASSIS};
        HashMap<HwInventoryType, List<Integer>> indexMap = new HashMap<HwInventoryType, List<Integer>>();
        for (int tidx = 0; tidx < hwTypes.length; ++tidx) {
            List<HwInventoryComponent> hwComps = null;
            HwInventoryType type = hwTypes[tidx];
            indexMap.put(type, new ArrayList());
            if (type == HwInventoryType.MODULE) {
                hwComps = im.findCards(sw.getSwitchPK());
            } else if (type == HwInventoryType.POWERSUPPLY) {
                hwComps = im.findPowerSupplies(sw.getPK());
            } else if (type == HwInventoryType.FAN) {
                hwComps = im.findFans(sw.getPK());
            } else if (type == HwInventoryType.CHASSIS && sw.isFexEnabled()) {
                hwComps = im.findFexChassises(sw.getPK());
            }
            if (hwComps == null || hwComps.size() <= 0) continue;
            for (int i = 0; i < hwComps.size(); ++i) {
                HwInventoryComponent comp = hwComps.get(i);
                entIdxMap.put(comp.getPhysicalIndex(), comp);
                ((List)indexMap.get((Object)type)).add(comp.getPhysicalIndex());
            }
        }
        SnmpPeer peer = sw.getPeer();
        Map<HwInventoryType, List<Map>> hwMap = CdpSnmpAdapter.getEntityDetailedInfo(peer, indexMap);
        if (hwMap == null || hwMap.size() == 0) {
            return false;
        }
        for (HwInventoryType type : hwTypes) {
            List<Map> entList = hwMap.get((Object)type);
            if (entList == null || entList.size() <= 0) continue;
            for (Map entMap : entList) {
                int phyIndex = (Integer)entMap.get("entPhysicalIndex");
                HwInventoryComponent comp = (HwInventoryComponent)entIdxMap.get(phyIndex);
                if (comp == null || comp.getHardwareType() != type) {
                    _Tracer.log(Level.INFO, sw.getIpAddress() + " updateHwEntityStatus() skip invalid entity:" + (Object)((Object)type) + "=" + entMap);
                }
                CdpDiscvHelper.parseHwComponent(sw, type, comp, entMap, true, false, false);
            }
        }
        return true;
    }

    public static boolean checkFexChange(EthSwitchImpl sw) {
        Map<Integer, HwInventoryComponent> fexChassisMap = InventoryManager.getInstance().findFexChassisInMap(sw.getPK());
        List<FexImpl> fexList = sw.getFexes();
        for (FexImpl fex : fexList) {
            HwInventoryComponent fexChassis = fexChassisMap.get(NexusEntityMibHelper.getFexChassisPhyIndex(fex.getBase().getFexId()));
            if (fexChassis == null) {
                return true;
            }
            if (!fex.getFexPK()._serialNum.equalsIgnoreCase(fexChassis.getSerialNumber())) {
                return true;
            }
            if (fexChassis == null || fex.isPresent()) continue;
            return true;
        }
        return false;
    }

    public static boolean discoverFexHwEntities(EthSwitchImpl sw) throws SnmpException {
        if (sw == null) {
            throw new IllegalArgumentException("Invalid Ethernet switch:" + sw);
        }
        if (sw.getPeer() == null) {
            return false;
        }
        if (!(sw.isFexEnabled() && sw.isFexCapableVersion() && sw.getBase().getNumOfFex() >= 1 || !_Tracer.isDebuggable())) {
            _Tracer.debug(sw.getIpAddress() + " skip fex hw discovery for no fex found");
        }
        InventoryManager im = InventoryManager.getInstance();
        List<FexImpl> fexList = sw.getFexes();
        Map<Integer, HwInventoryComponent> oldChassisMap = im.findFexChassisInMap(sw.getSwitchPK());
        Map<Integer, Card> oldCardMap = im.findFexCardInMap(sw.getSwitchPK());
        Map<Integer, HwInventoryComponent> oldFanMap = im.findFexFanInMap(sw.getSwitchPK());
        Map<Integer, PowerSupply> oldPowerMap = im.findFexPowerInMap(sw.getSwitchPK());
        int[] fexIds = new int[fexList.size()];
        for (int i = 0; i < fexList.size(); ++i) {
            fexIds[i] = fexList.get(i).getBase().getFexId();
        }
        Map<HwInventoryType, List<Integer>> indexMap = CdpSnmpAdapter.getFexEntityIndexMap(sw.getPeer(), fexIds, new HwInventoryType[]{HwInventoryType.CHASSIS, HwInventoryType.MODULE, HwInventoryType.POWERSUPPLY, HwInventoryType.FAN}, sw.getPlatformType(), sw.getSwVersion());
        if (indexMap == null || indexMap.size() == 0) {
            for (int phyIndex : oldChassisMap.keySet()) {
                im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldCardMap.keySet()) {
                im.deleteFexCard(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldFanMap.keySet()) {
                im.deleteFexFan(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldPowerMap.keySet()) {
                im.deleteFexPower(sw.getSwitchPK(), phyIndex);
            }
            return false;
        }
        Map<HwInventoryType, List<Map>> hwMap = CdpSnmpAdapter.getEntityFullInfo(sw.getPeer(), indexMap);
        if (hwMap == null || hwMap.size() == 0) {
            for (int phyIndex : oldChassisMap.keySet()) {
                im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldCardMap.keySet()) {
                im.deleteFexCard(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldFanMap.keySet()) {
                im.deleteFexFan(sw.getSwitchPK(), phyIndex);
            }
            for (int phyIndex : oldPowerMap.keySet()) {
                im.deleteFexPower(sw.getSwitchPK(), phyIndex);
            }
            return false;
        }
        List<Map> entList = hwMap.get((Object)HwInventoryType.CHASSIS);
        HwInventoryComponent chassis = null;
        if (entList != null && entList.size() > 0) {
            for (Map entMap : entList) {
                chassis = CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.CHASSIS, null, entMap, true, true, true);
                if (chassis == null) continue;
                oldChassisMap.remove(chassis.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.MODULE)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                Card card = (Card)CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.MODULE, null, entMap, true, true, true);
                if (card == null) continue;
                oldCardMap.remove(card.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.POWERSUPPLY)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                PowerSupply ps = (PowerSupply)CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.POWERSUPPLY, null, entMap, true, true, true);
                if (ps == null) continue;
                oldPowerMap.remove(ps.getPhysicalIndex());
            }
        }
        if ((entList = hwMap.get((Object)HwInventoryType.FAN)) != null && entList.size() > 0) {
            for (Map entMap : entList) {
                HwInventoryComponent fan = CdpDiscvHelper.parseHwComponent(sw, HwInventoryType.FAN, null, entMap, true, true, true);
                if (fan == null) continue;
                oldFanMap.remove(fan.getPhysicalIndex());
            }
        }
        Iterator<Object> i$ = oldChassisMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexChassis(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldCardMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexCard(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldFanMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexFan(sw.getSwitchPK(), phyIndex);
        }
        i$ = oldPowerMap.keySet().iterator();
        while (i$.hasNext()) {
            int phyIndex = (Integer)i$.next();
            im.deleteFexPower(sw.getSwitchPK(), phyIndex);
        }
        return true;
    }

    private static HwInventoryComponent parseHwComponent(EthSwitchImpl sw, HwInventoryType entType, HwInventoryComponent hwComp, Map entMap, boolean detailed, boolean hasCommon, boolean isFex) {
        if (entMap == null || entMap.size() < 1) {
            return null;
        }
        InventoryManager im = InventoryManager.getInstance();
        PlatformType swType = sw.getBase().getPlatformType();
        boolean isNxOS = PlatformType.isMdsSwitch(swType) || PlatformType.isNexusSwitch(swType) && swType != PlatformType.UCS6K;
        boolean isIOS = PlatformType.isTypeOf(swType, PlatformType.CAT);
        try {
            int phyIndex = (Integer)entMap.get("entPhysicalIndex");
            String name = null;
            String hwVer = null;
            String fwVer = null;
            String swVer = null;
            String serialNo = null;
            String mfg = null;
            String model = null;
            String assetId = null;
            int[] vendorType = null;
            int relPos = -1;
            int classType = -1;
            int containedPos = -1;
            if (hasCommon) {
                name = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[3]);
                hwVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[4]);
                fwVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[5]);
                swVer = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[6]);
                serialNo = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[7]);
                mfg = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[8]);
                model = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[9]);
                assetId = (String)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[10]);
                vendorType = (int[])entMap.get(CdpSnmpAdapter.EntTable_MibCmds[2]);
                containedPos = (Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[11]);
                relPos = (Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[1]);
                if (relPos < 0) {
                    relPos = 0;
                }
                if ((classType = ((Integer)entMap.get(CdpSnmpAdapter.EntTable_MibCmds[0])).intValue()) != entType.value()) {
                    throw new Exception("HW class type does not match");
                }
            }
            if (entType == HwInventoryType.MODULE) {
                Card card = (Card)hwComp;
                if (detailed) {
                    int adminStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[0]);
                    int operStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[1]);
                    String statusDescr = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[1] + "_strValue");
                    if (statusDescr == null || statusDescr.length() == 0) {
                        statusDescr = "n/a";
                    }
                    String resetReason = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[2]);
                    long chgTime = (Long)entMap.get(CdpSnmpAdapter.Module_MibCmds[3]);
                    int powerAdminStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[4]);
                    int powerOperStatus = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[5]);
                    int current = (Integer)entMap.get(CdpSnmpAdapter.Module_MibCmds[6]);
                    String descr = (String)entMap.get(CdpSnmpAdapter.Module_MibCmds[7]);
                    int slotId = -1;
                    if (isNxOS) {
                        slotId = relPos;
                    } else if (isIOS) {
                        slotId = containedPos - relPos;
                    }
                    if (slotId == -1 || slotId > 24 && swType == PlatformType.N7K || slotId > 20 && swType != PlatformType.N7K && swType != PlatformType.N9K && swType != PlatformType.N1KV) {
                        return null;
                    }
                    if (card == null && hasCommon) {
                        card = isFex ? im.createFexCard(sw.getSwitchPK(), phyIndex, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current) : (sw.isVdc() ? im.createCard((VdcPK)sw.getSwitchPK(), slotId, phyIndex, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current) : im.createCard((SerialNumKey)sw.getSwitchPK(), slotId, phyIndex, vendorType, name, hwVer, fwVer, swVer, serialNo, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current));
                    } else if (sw.isVdc()) {
                        im.updateCardStatus((VdcPK)sw.getSwitchPK(), phyIndex, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                    } else {
                        im.updateCardStatus((SerialNumKey)sw.getSwitchPK(), phyIndex, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                    }
                    if (descr != null) {
                        card.setPhysicalDescr(descr);
                    }
                    if (sw.getDBID() == 0L && card.getDBID() != 0L) {
                        card.updateSwitch();
                    }
                }
                return card;
            }
            if (entType == HwInventoryType.POWERSUPPLY) {
                PowerSupply ps = (PowerSupply)hwComp;
                if (detailed) {
                    String operStatus = (String)entMap.get(CdpSnmpAdapter.Power_MibCmds[0]);
                    String powerUnit = (String)entMap.get(CdpSnmpAdapter.Power_MibCmds[4]);
                    int rdMode = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[1]);
                    int availCur = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[2]);
                    int drawnCur = (Integer)entMap.get(CdpSnmpAdapter.Power_MibCmds[3]);
                    if (ps == null && hasCommon) {
                        ps = isFex ? im.createFexPower(sw.getSwitchPK(), relPos, phyIndex, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus, rdMode, drawnCur, availCur, powerUnit) : (sw.isVdc() ? im.createPowerSupply((VdcPK)sw.getSwitchPK(), relPos, phyIndex, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus, rdMode, drawnCur, availCur, powerUnit) : im.createPowerSupply((SerialNumKey)sw.getSwitchPK(), relPos, phyIndex, name, vendorType, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus, rdMode, drawnCur, availCur, powerUnit));
                    } else {
                        im.updatePowerSupplyStatus(sw.getSwitchPK(), phyIndex, operStatus, rdMode, drawnCur, availCur, powerUnit);
                    }
                }
                if (sw.getDBID() == 0L && ps.getDBID() != 0L) {
                    ps.updateSwitch();
                }
                return ps;
            }
            if (entType == HwInventoryType.FAN) {
                HwInventoryComponent fan = hwComp;
                if (detailed) {
                    String operStatus = (String)entMap.get(CdpSnmpAdapter.Fan_MibCmds[0]);
                    if (fan == null && hasCommon) {
                        fan = isFex ? im.createFexFan(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus) : (sw.isVdc() ? im.createFan((VdcPK)sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus) : im.createFan((SerialNumKey)sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, operStatus));
                    } else {
                        im.updateStatus(sw.getSwitchPK(), phyIndex, operStatus);
                    }
                }
                if (sw.getDBID() == 0L && fan.getDBID() != 0L) {
                    fan.updateSwitch();
                }
                return fan;
            }
            if (entType == HwInventoryType.CHASSIS) {
                HwInventoryComponent chassis = hwComp;
                if (detailed) {
                    String secSerialNum = (String)entMap.get("ceEntPhysicalSecondSerialNum");
                    if (secSerialNum == null || secSerialNum.length() == 0) {
                        secSerialNum = "n/a";
                    }
                    if (chassis == null && hasCommon) {
                        chassis = isFex ? im.createFexChassis(sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", secSerialNum) : (sw.isVdc() ? im.createChassis((VdcPK)sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", secSerialNum) : im.createChassis((SerialNumKey)sw.getSwitchPK(), phyIndex, name, vendorType, relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", secSerialNum));
                    }
                }
                if (sw.getDBID() == 0L && chassis.getDBID() != 0L) {
                    chassis.updateSwitch();
                }
                return chassis;
            }
            HwInventoryComponent hw = hwComp;
            if (hwComp == null && hasCommon) {
                hw = sw.isVdc() ? im.createHwComponent((VdcPK)sw.getSwitchPK(), phyIndex, name, vendorType, entType.value(), relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", "n/a") : im.createHwComponent((SerialNumKey)sw.getSwitchPK(), phyIndex, name, vendorType, entType.value(), relPos, hwVer, fwVer, swVer, serialNo, mfg, model, assetId, "n/a", "n/a");
            }
            if (sw.getDBID() == 0L && hw.getDBID() != 0L) {
                hw.updateSwitch();
            }
            return hw;
        }
        catch (Exception e) {
            _Tracer.log(Level.WARN, "Got error from create hw entity for " + entMap, e);
            return null;
        }
    }

    public static boolean isSupCard(String cardPhyName) {
        if (cardPhyName == null) {
            return false;
        }
        String descr = cardPhyName.toLowerCase();
        return descr.indexOf("supervior") >= 0 || descr.indexOf("supervisor") >= 0;
    }

    public static boolean isFwsmPlatformType(String response) {
        String productId = null;
        Matcher matcher = FWSM_VER_REG_PATTERN.matcher(response);
        if (matcher.matches()) {
            productId = matcher.group(3).trim();
        } else {
            matcher = FWSM_CTXT_VER_REG_PATTERN.matcher(response);
            if (matcher.matches()) {
                productId = matcher.group(3).trim();
            }
        }
        return productId != null && productId.contains("WS-SVC-FWM-1");
    }

    public static boolean discoverVirtualEthChannelPorts(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("invalid ethernet node:" + ethSw);
        }
        return CdpDiscvHelper.discoverVirtualNxEthChannelPorts(ethSw);
    }

    public static boolean discoverVirtualNxEthChannelPorts(EthSwitchImpl ethSw) {
        if (PlatformType.isNexusSwitch(ethSw.getPlatformType())) {
            if (ethSw.getCredential().getSecurityModel() != 3) {
                _Tracer.log(Level.WARN, "Not SNMP V3.  Returning without vPc discovery !!!!");
                return false;
            }
            IVpcAdapter vpcAdapter = null;
            try {
                if (ethSw.getPeer() != null) {
                    vpcAdapter = CliAdapterFactory.getVpcAdapter((EthSwitchImpl)ethSw);
                    if (vpcAdapter != null) {
                        vpcAdapter.discoverVirtualPortChannels();
                    } else {
                        _Tracer.log(Level.WARN, "Unable to get vPC adapter for ethSw: " + ethSw.getIpAddress());
                    }
                } else {
                    _Tracer.log(Level.WARN, "Unable to get Peer from the ethSW: " + ethSw.getIpAddress());
                }
            }
            catch (Exception e) {
                if (e instanceof NotSupportedException) {
                    _Tracer.log(Level.WARN, "'" + ethSw.getIpAddress() + "'" + e.getMessage());
                }
                _Tracer.log(Level.WARN, "discoverVirtualNxEthChannelPorts() caught exception for the switch '" + ethSw.getIpAddress() + "'", e);
            }
        }
        return true;
    }

    public static void discoverAndPersistPorts(String switchIp, boolean isLan) {
        _Tracer.log(Level.INFO, "Inside persistPortInformation() -> switchIp: " + switchIp + " isLan: " + isLan);
        if (isLan) {
            CdpDiscvHelper.discoverAndPersistEthPorts(switchIp);
        } else {
            CdpDiscvHelper.discoverAndPersistFCPorts(switchIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverAndPersistEthPorts(String switchIp) {
        Connection con = null;
        try {
            LanImpl lan = DCManager.getInstance().getLan();
            if (lan != null) {
                EthSwitchImpl ethSwitchImpl = lan.findEthSwitchByIp(InetAddress.getByName(switchIp));
                if (ethSwitchImpl != null) {
                    long startTime = System.currentTimeMillis();
                    CdpDiscvHelper.discoverEthPortInfo(ethSwitchImpl);
                    long endTime = System.currentTimeMillis();
                    _Tracer.log(Level.INFO, switchIp + "-->discoverEthPortInfo() took " + (endTime - startTime) + " ms");
                    startTime = System.currentTimeMillis();
                    con = ConnectionManager.getConnection();
                    if (con != null) {
                        LanPersistentManager.getInstance().persistEthPorts(lan, ethSwitchImpl, con);
                        endTime = System.currentTimeMillis();
                        _Tracer.log(Level.INFO, switchIp + "-->persistEthPorts() took " + (endTime - startTime) + " ms");
                    } else {
                        _Tracer.log(Level.WARN, "discoverAndPersistEthPorts() -> Unable to get Connection for the switchIp: " + switchIp);
                    }
                } else {
                    _Tracer.log(Level.WARN, "discoverAndPersistEthPorts() -> Unable to get ethSwithImple for the switchIp: " + switchIp);
                }
            }
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, " discoverAndPersistEthPorts caught exception", ex);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverAndPersistFCPorts(String switchIp) {
        Connection con = null;
        try {
            SwitchImpl switchImpl = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(switchIp));
            if (switchImpl != null) {
                long startTime = System.currentTimeMillis();
                SnmpAdapter.discoverFcPorts(switchImpl);
                long endTime = System.currentTimeMillis();
                _Tracer.log(Level.INFO, switchIp + "-->discoverFcPports() took " + (endTime - startTime) + " ms");
                startTime = System.currentTimeMillis();
                FabricImpl fabricImpl = SanManager.getInstance().findFabric(InetAddress.getByName(switchIp));
                if (fabricImpl != null) {
                    ArrayList<FcPortImpl> switchPorts = new ArrayList<FcPortImpl>();
                    List<FcPortBase> fcPorts = switchImpl.getAllPorts();
                    for (FcPortBase fcPortBase : fcPorts) {
                        FcPortImpl spImpl = InventoryPersistentManager.getInstance().getFcPortImpl(switchImpl, fcPortBase.getIfIndex(), fcPortBase.getIfSpeed(), false, fcPortBase.getFcConnectorType());
                        spImpl.setIfType(fcPortBase.getIfType());
                        switchPorts.add(spImpl);
                    }
                    con = ConnectionManager.getConnection();
                    if (con != null) {
                        InventoryPersistentManager.getInstance().persistSwitchPorts(con, switchPorts.toArray(new FcPortImpl[switchPorts.size()]), fabricImpl);
                        endTime = System.currentTimeMillis();
                        _Tracer.log(Level.INFO, switchIp + "-->persistSwitchPorts() took " + (endTime - startTime) + " ms");
                    } else {
                        _Tracer.log(Level.WARN, "discoverAndPersistEthPorts() -> Unable to get Connection for the switchIp: " + switchIp);
                    }
                } else {
                    _Tracer.log(Level.WARN, "discoverAndPersistFCPorts() -> Unable to get FabricImple for the switchIp: " + switchIp);
                }
            } else {
                _Tracer.log(Level.WARN, "discoverAndPersistFCPorts() -> Unable to get switchImpl for the switchIp: " + switchIp);
            }
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, " discoverAndPersistFCPorts caught exception", ex);
        }
        finally {
            DbUtil.close(con);
        }
    }

    public static void removeNonExistEthPorts(EthSwitchImpl sw, int[] oldIfIndexes, int[] newIfIndexes) throws Exception {
        int i;
        if (sw == null) {
            return;
        }
        ArrayList<Integer> oldList = new ArrayList<Integer>(oldIfIndexes.length);
        for (i = 0; i < oldIfIndexes.length; ++i) {
            oldList.add(new Integer(oldIfIndexes[i]));
        }
        for (i = 0; i < newIfIndexes.length; ++i) {
            for (int j = 0; j < oldIfIndexes.length; ++j) {
                if (newIfIndexes[i] != oldIfIndexes[j]) continue;
                oldList.remove(new Integer(oldIfIndexes[j]));
            }
        }
        for (Integer oldIndex : oldList) {
            sw.removeEthPort(oldIndex, false);
        }
    }

    public static String prefix(InetAddress ip, String method) {
        if (ip != null) {
            return ip.getHostAddress() + "--" + method + ": ";
        }
        return "Unknown IP--" + method + ": ";
    }
}

