/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.CliUtil;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.UcsClusterBase;
import com.cisco.dcbu.sm.common.model.UcsNetworkElementBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.discovery.BladeMgmtIfResponseHandler;
import com.cisco.dcbu.sm.server.discovery.BladeResponseHandler;
import com.cisco.dcbu.sm.server.discovery.BladesResponseHandler;
import com.cisco.dcbu.sm.server.discovery.ProfileResponseHandler;
import com.cisco.dcbu.sm.server.discovery.RawResponseHandler;
import com.cisco.dcbu.sm.server.discovery.ReceiptResponseHandler;
import com.cisco.dcbu.sm.server.discovery.UcsUtil;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.UcsBladeImpl;
import com.cisco.dcbu.sm.server.model.UcsBladeMgmtIfImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HttpPeer {
    public static final ReceiptResponseHandler loginResponseHandler = new ReceiptResponseHandler();
    public static final ReceiptResponseHandler logoutResponseHandler = new ReceiptResponseHandler();
    public static final ProfileResponseHandler profileResponseHandler = new ProfileResponseHandler();
    public static final BladeResponseHandler bladeResponseHandler = new BladeResponseHandler();
    public static final BladesResponseHandler bladesResponseHandler = new BladesResponseHandler();
    public static final BladeMgmtIfResponseHandler bladeMgmtIfResponseHandler = new BladeMgmtIfResponseHandler();
    public static final RawResponseHandler rawResponseHandler = new RawResponseHandler();
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    HttpPost post;
    HttpClient httpclient;
    HttpsURLConnection urlConnection;
    String cookie = null;
    String httpsCookie = null;
    String hostname = null;

    public HttpPeer(String hostname, String username, String passwd, HttpClient httpclient) throws Exception {
        this.post = new HttpPost("http://" + hostname + "/nuova");
        this.httpclient = httpclient;
        this.cookie = HttpPeer.getCookie(username, passwd, this.post, httpclient);
    }

    public HttpPeer(String hostname, String username, String passwd) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        this.hostname = hostname;
        this.httpsCookie = this.getCookie(hostname, username, passwd);
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getHttpsCookie() {
        return this.httpsCookie;
    }

    public HttpsURLConnection getHttpsURLConnection() {
        return this.urlConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfile(String wwn) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"fcpoolAddr\" inHierarchical=\"true\" cookie=\"" + this.cookie + "\"><inFilter>" + "<eq class=\"fcpoolAddr\" property=\"id\" value=\"" + wwn + "\"/></inFilter></configResolveClass>";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        ProfileResponseHandler profileResponseHandler = HttpPeer.profileResponseHandler;
        synchronized (profileResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.profileResponseHandler);
            while (HttpPeer.profileResponseHandler.getDn() == null) {
                HttpPeer.profileResponseHandler.wait(1000L);
            }
        }
        return HttpPeer.profileResponseHandler.getDn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfile(String hostname, String wwn) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"fcpoolAddr\" inHierarchical=\"true\" cookie=\"" + this.httpsCookie + "\"><inFilter>" + "<eq class=\"fcpoolAddr\" property=\"id\" value=\"" + wwn + "\"/></inFilter></configResolveClass>";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            int index = strbuf.indexOf("assignedToDn=");
            String dn = null;
            if (index > -1) {
                dn = strbuf.substring(index + 14);
                dn = dn.substring(0, dn.indexOf("\""));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(" Service Profile DN: " + dn));
                }
            }
            input.close();
            String string = dn;
            return string;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getProfile failed " + hostname), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UcsBladeImpl> getBlades() throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"computeBlade\" inHierarchical=\"false\" cookie=\"" + this.cookie + "\" />";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        BladesResponseHandler bladesResponseHandler = HttpPeer.bladesResponseHandler;
        synchronized (bladesResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.bladesResponseHandler);
            while (HttpPeer.bladesResponseHandler.getBlades() == null) {
                HttpPeer.bladesResponseHandler.wait(1000L);
            }
        }
        return HttpPeer.bladesResponseHandler.getBlades();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UcsBladeImpl> getBlades(String hostname) throws IOException, ClientProtocolException, InterruptedException {
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            String inputStr = null;
            inputStr = "<configResolveClass classId=\"computeBlade\" inHierarchical=\"false\" cookie=\"" + this.httpsCookie + "\" />";
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(" Server Blade response: " + strbuf));
            }
            input.close();
            input = null;
            List<UcsBladeImpl> list = HttpPeer.getUcsBlades(strbuf.toString());
            return list;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getBlade failed " + hostname), (Throwable)ex);
            List<UcsBladeImpl> list = null;
            return list;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UcsBladeMgmtIfImpl> getBladeMgmtIfs(String dn) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"mgmtIf\" inHierarchical=\"false\" cookie=\"" + this.cookie + "\">" + "<inFilter><wcard class=\"mgmtIf\" property=\"dn\" value=\"" + dn + "/mgmt/*\" /></inFilter></configResolveClass>";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        BladeMgmtIfResponseHandler bladeMgmtIfResponseHandler = HttpPeer.bladeMgmtIfResponseHandler;
        synchronized (bladeMgmtIfResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.bladeMgmtIfResponseHandler);
            while (HttpPeer.bladeMgmtIfResponseHandler.getBladeMgmtIfs() == null) {
                HttpPeer.bladeMgmtIfResponseHandler.wait(1000L);
            }
        }
        return HttpPeer.bladeMgmtIfResponseHandler.getBladeMgmtIfs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UcsBladeMgmtIfImpl> getBladeMgmtIfs(String hostname, String dn) throws IOException, ClientProtocolException, InterruptedException {
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            String inputStr = null;
            inputStr = "<configResolveClass classId=\"mgmtIf\" inHierarchical=\"false\" cookie=\"" + this.httpsCookie + "\">" + "<inFilter><wcard class=\"mgmtIf\" property=\"dn\" value=\"" + dn + "/mgmt/*\" /></inFilter></configResolveClass>";
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(" Server Blade response: " + strbuf));
            }
            input.close();
            input = null;
            List<UcsBladeMgmtIfImpl> list = HttpPeer.getUcsBladeMgmtIfs(strbuf.toString());
            return list;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getBlade failed " + hostname), (Throwable)ex);
            List<UcsBladeMgmtIfImpl> list = null;
            return list;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBlade(String hostname, String wwn) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"computeBlade\" inHierarchical=\"false\" cookie=\"" + this.httpsCookie + "\"><inFilter>" + "<eq class=\"computeBlade\" property=\"assignedToDn\" value=\"" + wwn + "\"/></inFilter></configResolveClass>";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(" Server Balde response: " + strbuf));
            }
            int index = strbuf.indexOf(" dn=");
            String dn = null;
            if (index > -1) {
                dn = strbuf.substring(index + 5);
                dn = dn.substring(0, dn.indexOf("\""));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(" Service Profile DN: " + dn));
                }
            }
            input.close();
            String string = dn;
            return string;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getBlade failed " + hostname), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBlade(String wwn) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"computeBlade\" inHierarchical=\"false\" cookie=\"" + this.cookie + "\"><inFilter>" + "<eq class=\"computeBlade\" property=\"assignedToDn\" value=\"" + wwn + "\"/></inFilter></configResolveClass>";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        BladeResponseHandler bladeResponseHandler = HttpPeer.bladeResponseHandler;
        synchronized (bladeResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.bladeResponseHandler);
            while (HttpPeer.bladeResponseHandler.getDn() == null) {
                HttpPeer.bladeResponseHandler.wait(1000L);
            }
        }
        return HttpPeer.bladeResponseHandler.getDn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCookie(String username, String passwd, HttpPost post, HttpClient httpclient) throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<aaaLogin cookie=\"null\" inName=\"" + username + "\" " + "  inPassword=\"" + passwd + "\" />";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        post.setEntity((HttpEntity)input);
        ReceiptResponseHandler receiptResponseHandler = loginResponseHandler;
        synchronized (receiptResponseHandler) {
            httpclient.execute((HttpUriRequest)post, (ResponseHandler)loginResponseHandler);
            while (loginResponseHandler.getCookie() == null) {
                loginResponseHandler.wait(1000L);
            }
        }
        return loginResponseHandler.getCookie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCookie(String hostname, String username, String passwd) throws IOException, ClientProtocolException, InterruptedException {
        String query = "<aaaLogin cookie=\"null\" inName=\"" + username + "\" " + "  inPassword=\"" + passwd + "\" />";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(query);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)(" ReceiptResponse: " + strbuf));
            }
            int index = strbuf.indexOf("outCookie=");
            String cookie = null;
            if (index > -1) {
                cookie = strbuf.substring(index + 11);
                cookie = cookie.substring(0, cookie.indexOf("\""));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(" Cookie is: " + cookie));
                }
            }
            if ((index = strbuf.indexOf("errorDescr=")) > -1) {
                String error = strbuf.substring(index + 11);
                error = error.substring(0, error.indexOf(">"));
                throw new Exception(error);
            }
            input.close();
            String string = cookie;
            return string;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getHttpsCookie failed " + hostname + ". " + ex.getMessage()));
            String string = null;
            return string;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut() throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<aaaLogout cookie=\"" + this.cookie + "\" inCookie=\"" + this.cookie + "\"/>";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
            InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
            this.post.setEntity((HttpEntity)input);
            ReceiptResponseHandler receiptResponseHandler = logoutResponseHandler;
            synchronized (receiptResponseHandler) {
                this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)logoutResponseHandler);
                while (logoutResponseHandler.getCookie() == null) {
                    logoutResponseHandler.wait(1000L);
                }
            }
        }
        catch (Exception ex) {
            _Logger.debug((Object)("HttpPeer logOut failed " + inputStr), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOutHttps() throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<aaaLogout cookie=\"" + this.httpsCookie + "\" inCookie=\"" + this.httpsCookie + "\"/>";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + this.hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)(" ReceiptResponse: " + strbuf));
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer logOutHttps failed " + this.hostname), (Throwable)ex);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    HttpClient getHttpClient() {
        return this.httpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverUCSBlades(AbstractModelObjectImpl sw) {
        if (sw == null) {
            return;
        }
        PlatformType platformType = null;
        String ipAddr = null;
        long swId = 0L;
        SnmpPeer peer = null;
        String primaryIp = null;
        if (sw instanceof SwitchImpl) {
            platformType = ((SwitchImpl)sw).getBase().getPlatformType();
            ipAddr = ((SwitchImpl)sw).getBase().getIpAddress();
            primaryIp = ((SwitchImpl)sw).getBase().getPrimaryIp();
            swId = ((SwitchImpl)sw).getDBID();
            peer = ((SwitchImpl)sw).getPeer();
        } else if (sw instanceof EthSwitchImpl) {
            platformType = ((EthSwitchImpl)sw).getBase().getPlatformType();
            ipAddr = ((EthSwitchImpl)sw).getBase().getIpAddress();
            primaryIp = ((EthSwitchImpl)sw).getBase().getPrimaryIp();
            swId = ((EthSwitchImpl)sw).getDBID();
            peer = ((EthSwitchImpl)sw).getPeer();
        }
        if (platformType == null || platformType != PlatformType.UCS6K || peer == null || !peer.isV3() || swId == 0L) {
            return;
        }
        String username = peer.getUserName();
        String passwd = peer.getAuthPassword();
        if (username == null || username.trim().equals("") || passwd == null || passwd.trim().equals("")) {
            return;
        }
        if (primaryIp == null) {
            List<UcsBladeImpl> blades = null;
            ArrayList<UcsBladeMgmtIfImpl> bladeMgmtIfs = new ArrayList<UcsBladeMgmtIfImpl>();
            HttpPeer hp = null;
            try {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                int timeoutConnection = 5000;
                int timeoutSocket = 5000;
                HttpParams httpParams = httpclient.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutConnection);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutSocket);
                try {
                    hp = new HttpPeer(ipAddr, username, passwd, (HttpClient)httpclient);
                }
                catch (Exception ex) {
                    _Logger.debug((Object)("HttpPeer http creation failed " + ipAddr), (Throwable)ex);
                    try {
                        hp = new HttpPeer(ipAddr, username, passwd);
                    }
                    catch (Exception ex1) {
                        _Logger.info((Object)("HttpPeer https creation failed " + ipAddr), (Throwable)ex1);
                        if (hp != null && hp.httpsCookie != null) {
                            try {
                                hp.logOutHttps();
                            }
                            catch (Exception e) {
                                _Logger.debug((Object)"discoverUCSBlades failed to logout https session. ", (Throwable)e);
                            }
                        }
                        if (hp != null && hp.cookie != null) {
                            try {
                                hp.logOut();
                            }
                            catch (Exception e) {
                                _Logger.debug((Object)"discoverUCSBlades failed to logout http session. ", (Throwable)e);
                            }
                        }
                        return;
                    }
                }
                if (hp.getHttpsCookie() != null) {
                    blades = hp.getBlades(ipAddr);
                } else if (hp.getCookie() != null) {
                    blades = hp.getBlades();
                }
                if (blades != null && !blades.isEmpty()) {
                    for (UcsBladeImpl b : blades) {
                        b.getBase().setSwitchId(swId);
                    }
                }
                long updateTime = System.currentTimeMillis();
                Connection con = null;
                try {
                    con = ConnectionManager.getConnection();
                    con.setAutoCommit(false);
                    UcsBladeImpl.persistUcsBlades(con, blades);
                    List<UcsBladeMgmtIfImpl> temp = null;
                    if (blades != null) {
                        for (UcsBladeImpl b : blades) {
                            if (hp.getHttpsCookie() != null) {
                                temp = hp.getBladeMgmtIfs(ipAddr, b.getBase().getDn());
                            } else if (hp.getCookie() != null) {
                                temp = hp.getBladeMgmtIfs(b.getBase().getDn());
                            }
                            if (temp == null) continue;
                            for (UcsBladeMgmtIfImpl m : temp) {
                                m.getBase().setSwitchId(swId);
                                m.getBase().setBladeId(b.getDBID());
                            }
                            bladeMgmtIfs.addAll(temp);
                        }
                    }
                    if (bladeMgmtIfs != null && !bladeMgmtIfs.isEmpty()) {
                        UcsBladeMgmtIfImpl.persist(con, bladeMgmtIfs);
                    }
                    UcsBladeImpl.deleteOldUcsBlades(con, swId, updateTime);
                    UcsBladeMgmtIfImpl.deleteOldObjects(con, swId, updateTime);
                    con.commit();
                }
                catch (SQLException e) {
                    if (con != null) {
                        con.rollback();
                    }
                    _Logger.warn((Object)("persist UCS compute blade failed " + ipAddr), (Throwable)e);
                }
                catch (DBException e) {
                    _Logger.warn((Object)("persist UCS compute blade failed " + ipAddr), (Throwable)e);
                }
                finally {
                    DbUtil.close(con);
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("query UCS compute blade failed " + ipAddr), (Throwable)e);
            }
            finally {
                if (hp != null && hp.httpsCookie != null) {
                    try {
                        hp.logOutHttps();
                    }
                    catch (Exception e) {
                        _Logger.debug((Object)"discoverUCSBlades failed to logout https session. ", (Throwable)e);
                    }
                }
                if (hp != null && hp.cookie != null) {
                    try {
                        hp.logOut();
                    }
                    catch (Exception e) {
                        _Logger.debug((Object)"discoverUCSBlades failed to logout http session. ", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverUCSProfile(FabricImpl fabric, SnmpUserOpt userOpt) {
        DefaultHttpClient httpclient = null;
        try {
            if (fabric == null) {
                return;
            }
            if (!userOpt.isV3()) {
                return;
            }
            String username = userOpt.getUsername();
            String passwd = userOpt.getPassword();
            if (username == null || username.trim().equals("") || passwd == null || passwd.trim().equals("")) {
                return;
            }
            FabricPK fpk = fabric.getPK();
            EndPortImpl[] endPorts = SanManager.getInstance().findEndPorts(fpk);
            ArrayList<Wwn> wwnList = new ArrayList<Wwn>();
            httpclient = new DefaultHttpClient();
            int timeoutConnection = 5000;
            int timeoutSocket = 5000;
            HttpParams httpParams = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutConnection);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutSocket);
            for (int i = 0; endPorts != null && i < endPorts.length; ++i) {
                EnclosureImpl encl = endPorts[i].getEnclosure();
                Wwn wwn = endPorts[i].getPortWwn();
                SwitchImpl sw = endPorts[i].getSwitch();
                if (sw == null || sw.getBase().getPlatformType() != PlatformType.UCS6K) continue;
                String ipAddr = sw.getIpAddress();
                HttpPeer hp = null;
                String wwns = null;
                try {
                    hp = new HttpPeer(ipAddr, username, passwd, (HttpClient)httpclient);
                }
                catch (Exception ex) {
                    _Logger.debug((Object)("HttpPeer http creation failed " + ipAddr), (Throwable)ex);
                    try {
                        hp = new HttpPeer(ipAddr, username, passwd);
                    }
                    catch (Exception ex1) {
                        _Logger.info((Object)("HttpPeer https creation failed " + ipAddr), (Throwable)ex1);
                        if (httpclient != null) {
                            httpclient.getConnectionManager().shutdown();
                        }
                        return;
                    }
                }
                try {
                    int index;
                    wwns = WwnDictionary.get(wwn.getValue(), false, false);
                    String pprofile = null;
                    if (hp.httpsCookie != null) {
                        pprofile = hp.getProfile(ipAddr, wwns);
                    } else if (hp.cookie != null) {
                        pprofile = hp.getProfile(wwns);
                    }
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)("service profile is " + pprofile + " for " + wwns));
                    }
                    endPorts[i].setServiceProfile(pprofile);
                    Wwn nwwn = endPorts[i].getNodeWwn();
                    if (nwwn == null || wwnList.contains(nwwn)) continue;
                    wwnList.add(nwwn);
                    wwns = WwnDictionary.get(nwwn.getValue(), false, false);
                    String nprofile = null;
                    if (hp.httpsCookie != null) {
                        nprofile = hp.getProfile(ipAddr, wwns);
                    } else if (hp.cookie != null) {
                        nprofile = hp.getProfile(wwns);
                    }
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)("service profile is " + nprofile + " for " + wwns));
                    }
                    int n = index = nprofile == null ? -1 : nprofile.lastIndexOf("/");
                    if (index <= 0) continue;
                    String sprofile = nprofile.substring(0, index);
                    encl.setServiceProfile(sprofile);
                    String blade = null;
                    if (hp.httpsCookie != null) {
                        blade = hp.getBlade(ipAddr, sprofile);
                    } else if (hp.cookie != null) {
                        blade = hp.getBlade(sprofile);
                    }
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)("blade server is " + blade + " for " + encl.getName()));
                    }
                    encl.setServerBlade(blade);
                    continue;
                }
                catch (Exception e) {
                    _Logger.warn((Object)("query UCS service profile " + wwns + " failed " + e.getMessage()));
                    continue;
                }
                finally {
                    if (hp.httpsCookie != null) {
                        hp.logOutHttps();
                    }
                    if (hp.cookie != null) {
                        hp.logOut();
                    }
                }
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("query UCS service profile failed " + fabric.getFabricName()), (Throwable)ex);
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
    }

    public static void discoverUCSProfileByHttps(String hostname, String username, String passwd) {
        try {
            URL url = new URL("https://" + hostname + "/nuova");
            System.out.println("url is " + url);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            String query = "<aaaLogin cookie=\"null\" inName=\"" + username + "\" " + "  inPassword=\"" + passwd + "\" />";
            output.writeBytes(query);
            System.out.println("Resp Code:" + connection.getResponseCode());
            System.out.println("Resp Message:" + connection.getResponseMessage());
            DataInputStream input = new DataInputStream(connection.getInputStream());
            int c = input.read();
            while (c != -1) {
                System.out.print((char)c);
                c = input.read();
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<UcsBladeImpl> getUcsBlades(String in) {
        ArrayList<UcsBladeImpl> results = new ArrayList<UcsBladeImpl>();
        try {
            List<String> computeBlades = CliUtil.getRecords(in, "computeBlade");
            if (computeBlades != null && !computeBlades.isEmpty()) {
                for (String blade : computeBlades) {
                    String temp;
                    String adminPower = null;
                    String adminState = null;
                    String assignedToDn = null;
                    String association = null;
                    String availability = null;
                    long availableMemory = 0L;
                    int chassisId = 0;
                    String descr = null;
                    String dn = null;
                    String lowVoltageMem = null;
                    String managingInst = null;
                    int memorySpeed = 0;
                    String model = null;
                    String name = null;
                    int numOfAdaptors = 0;
                    int numOfCores = 0;
                    int numOfCoresEnabled = 0;
                    int numOfCpus = 0;
                    int numOfEthHostIfs = 0;
                    int numOfFcHostIfs = 0;
                    int numOfThreads = 0;
                    String operPower = null;
                    String operQualifier = null;
                    String operState = null;
                    String operability = null;
                    String originalUuid = null;
                    String presence = null;
                    int revision = 0;
                    String serial = null;
                    String serverId = null;
                    int slotId = 0;
                    long totalMemory = 0L;
                    String uuid = null;
                    String vendor = null;
                    if (blade.indexOf("adminPower") > 0) {
                        adminPower = CliUtil.getXmlParamValue(blade, "adminPower");
                    }
                    if (blade.indexOf("adminState") > 0) {
                        adminState = CliUtil.getXmlParamValue(blade, "adminState");
                    }
                    if (blade.indexOf("assignedToDn") > 0) {
                        assignedToDn = CliUtil.getXmlParamValue(blade, "assignedToDn");
                    }
                    if (blade.indexOf("association") > 0) {
                        association = CliUtil.getXmlParamValue(blade, "association");
                    }
                    if (blade.indexOf("availability") > 0) {
                        availability = CliUtil.getXmlParamValue(blade, "availability");
                    }
                    if (blade.indexOf("availableMemory") > 0 && (temp = CliUtil.getXmlParamValue(blade, "availableMemory")) != null && !temp.trim().equals("")) {
                        try {
                            availableMemory = Long.parseLong(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get available memory: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("chassisId") > 0 && (temp = CliUtil.getXmlParamValue(blade, "chassisId")) != null && !temp.trim().equals("")) {
                        try {
                            chassisId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get chassis ID: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("descr") > 0) {
                        descr = CliUtil.getXmlParamValue(blade, "descr");
                    }
                    if (blade.indexOf("dn") > 0) {
                        dn = CliUtil.getXmlParamValue(blade, "dn");
                    }
                    if (blade.indexOf("lowVoltageMemory") > 0) {
                        lowVoltageMem = CliUtil.getXmlParamValue(blade, "lowVoltageMemory");
                    }
                    if (blade.indexOf("managingInst") > 0) {
                        managingInst = CliUtil.getXmlParamValue(blade, "managingInst");
                    }
                    if (blade.indexOf("memorySpeed") > 0 && (temp = CliUtil.getXmlParamValue(blade, "memorySpeed")) != null && !temp.trim().equals("")) {
                        try {
                            memorySpeed = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get memory speed: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("model") > 0) {
                        model = CliUtil.getXmlParamValue(blade, "model");
                    }
                    if (blade.indexOf("name") > 0) {
                        name = CliUtil.getXmlParamValue(blade, "name");
                    }
                    if (blade.indexOf("numOfAdaptors") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfAdaptors")) != null && !temp.trim().equals("")) {
                        try {
                            numOfAdaptors = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of adaptors: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfCores") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfCores")) != null && !temp.trim().equals("")) {
                        try {
                            numOfCores = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of cores: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfCoresEnabled") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfCoresEnabled")) != null && !temp.trim().equals("")) {
                        try {
                            numOfCoresEnabled = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of cores enabled: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfCpus") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfCpus")) != null && !temp.trim().equals("")) {
                        try {
                            numOfCpus = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of CPUs: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfEthHostIfs") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfEthHostIfs")) != null && !temp.trim().equals("")) {
                        try {
                            numOfEthHostIfs = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of ethernet host interfaces: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfFcHostIfs") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfFcHostIfs")) != null && !temp.trim().equals("")) {
                        try {
                            numOfFcHostIfs = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of FC host interfaces: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("numOfThreads") > 0 && (temp = CliUtil.getXmlParamValue(blade, "numOfThreads")) != null && !temp.trim().equals("")) {
                        try {
                            numOfThreads = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get number of threads: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("operPower") > 0) {
                        operPower = CliUtil.getXmlParamValue(blade, "operPower");
                    }
                    if (blade.indexOf("operQualifier") > 0) {
                        operQualifier = CliUtil.getXmlParamValue(blade, "operQualifier");
                    }
                    if (blade.indexOf("operState") > 0) {
                        operState = CliUtil.getXmlParamValue(blade, "operState");
                    }
                    if (blade.indexOf("operability") > 0) {
                        operability = CliUtil.getXmlParamValue(blade, "operability");
                    }
                    if (blade.indexOf("originalUuid") > 0) {
                        originalUuid = CliUtil.getXmlParamValue(blade, "originalUuid");
                    }
                    if (blade.indexOf("presence") > 0) {
                        presence = CliUtil.getXmlParamValue(blade, "presence");
                    }
                    if (blade.indexOf("revision") > 0 && (temp = CliUtil.getXmlParamValue(blade, "revision")) != null && !temp.trim().equals("")) {
                        try {
                            revision = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get revision: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("serial") > 0) {
                        serial = CliUtil.getXmlParamValue(blade, "serial");
                    }
                    if (blade.indexOf("serverId") > 0) {
                        serverId = CliUtil.getXmlParamValue(blade, "serverId");
                    }
                    if (blade.indexOf("slotId") > 0 && (temp = CliUtil.getXmlParamValue(blade, "slotId")) != null && !temp.trim().equals("")) {
                        try {
                            slotId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get slot ID: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("totalMemory") > 0 && (temp = CliUtil.getXmlParamValue(blade, "totalMemory")) != null && !temp.trim().equals("")) {
                        try {
                            totalMemory = Long.parseLong(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get total memory: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (blade.indexOf("uuid") > 0) {
                        uuid = CliUtil.getXmlParamValue(blade, "uuid");
                    }
                    if (blade.indexOf("vendor") > 0) {
                        vendor = CliUtil.getXmlParamValue(blade, "vendor");
                    }
                    if (dn == null || dn.trim().equals("")) continue;
                    UcsBladeImpl computeBlade = new UcsBladeImpl(0L, adminPower, adminState, assignedToDn, association, availability, availableMemory, chassisId, descr, dn, lowVoltageMem, managingInst, memorySpeed, model, name, numOfAdaptors, numOfCores, numOfCoresEnabled, numOfCpus, numOfEthHostIfs, numOfFcHostIfs, numOfThreads, operPower, operQualifier, operState, operability, originalUuid, presence, revision, serial, serverId, slotId, totalMemory, uuid, vendor);
                    results.add(computeBlade);
                }
            }
            if (results.isEmpty() && in.indexOf("errorCode") > 0) {
                _Logger.warn((Object)("getUcsBlades() failed: " + in));
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("getUcsBlades() failed: " + e.getMessage()));
        }
        return results;
    }

    public static List<UcsBladeMgmtIfImpl> getUcsBladeMgmtIfs(String in) {
        ArrayList<UcsBladeMgmtIfImpl> results = new ArrayList<UcsBladeMgmtIfImpl>();
        try {
            List<String> mgmtIfs = CliUtil.getRecords(in, "mgmtIf");
            if (mgmtIfs != null && !mgmtIfs.isEmpty()) {
                for (String mgmtIf : mgmtIfs) {
                    String temp;
                    String access = null;
                    String adminState = null;
                    String discovery = null;
                    String dn = null;
                    String epDn = null;
                    String extBroadcast = null;
                    String extGw = null;
                    String extIp = null;
                    String extMask = null;
                    int ifId = 0;
                    String ifRole = null;
                    String ifType = null;
                    String ip = null;
                    String locale = null;
                    String mac = null;
                    String mask = null;
                    String name = null;
                    String peerChassisId = null;
                    String peerDn = null;
                    int peerPortId = 0;
                    int peerSlotId = 0;
                    int portId = 0;
                    int slotId = 0;
                    String stateQual = null;
                    String subject = null;
                    String transport = null;
                    String type = null;
                    int vnet = 0;
                    if (mgmtIf.indexOf("access") > 0) {
                        access = CliUtil.getXmlParamValue(mgmtIf, "access");
                    }
                    if (mgmtIf.indexOf("adminState") > 0) {
                        adminState = CliUtil.getXmlParamValue(mgmtIf, "adminState");
                    }
                    if (mgmtIf.indexOf("discovery") > 0) {
                        discovery = CliUtil.getXmlParamValue(mgmtIf, "discovery");
                    }
                    if (mgmtIf.indexOf("dn") > 0) {
                        dn = CliUtil.getXmlParamValue(mgmtIf, "dn");
                    }
                    if (mgmtIf.indexOf("epDn") > 0) {
                        epDn = CliUtil.getXmlParamValue(mgmtIf, "epDn");
                    }
                    if (mgmtIf.indexOf("extBroadcast") > 0) {
                        extBroadcast = CliUtil.getXmlParamValue(mgmtIf, "extBroadcast");
                    }
                    if (mgmtIf.indexOf("extGw") > 0) {
                        extGw = CliUtil.getXmlParamValue(mgmtIf, "extGw");
                    }
                    if (mgmtIf.indexOf("extIp") > 0) {
                        extIp = CliUtil.getXmlParamValue(mgmtIf, "extIp");
                    }
                    if (mgmtIf.indexOf("extMask") > 0) {
                        extMask = CliUtil.getXmlParamValue(mgmtIf, "extMask");
                    }
                    if (mgmtIf.indexOf("id") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "id")) != null && !temp.trim().equals("")) {
                        try {
                            ifId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get id: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (mgmtIf.indexOf("ifRole") > 0) {
                        ifRole = CliUtil.getXmlParamValue(mgmtIf, "ifRole");
                    }
                    if (mgmtIf.indexOf("ifType") > 0) {
                        ifType = CliUtil.getXmlParamValue(mgmtIf, "ifType");
                    }
                    if (mgmtIf.indexOf("ip") > 0) {
                        ip = CliUtil.getXmlParamValue(mgmtIf, "ip");
                    }
                    if (mgmtIf.indexOf("locale") > 0) {
                        locale = CliUtil.getXmlParamValue(mgmtIf, "locale");
                    }
                    if (mgmtIf.indexOf("mac") > 0) {
                        mac = CliUtil.getXmlParamValue(mgmtIf, "mac");
                    }
                    if (mgmtIf.indexOf("mask") > 0) {
                        mask = CliUtil.getXmlParamValue(mgmtIf, "mask");
                    }
                    if (mgmtIf.indexOf("peerChassisId") > 0) {
                        peerChassisId = CliUtil.getXmlParamValue(mgmtIf, "peerChassisId");
                    }
                    if (mgmtIf.indexOf("peerDn") > 0) {
                        peerDn = CliUtil.getXmlParamValue(mgmtIf, "peerDn");
                    }
                    if (mgmtIf.indexOf("peerPortId") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "peerPortId")) != null && !temp.trim().equals("")) {
                        try {
                            peerPortId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get peer port id: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (mgmtIf.indexOf("peerSlotId") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "peerSlotId")) != null && !temp.trim().equals("")) {
                        try {
                            peerSlotId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get peer slot id: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (mgmtIf.indexOf("portId") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "portId")) != null && !temp.trim().equals("")) {
                        try {
                            portId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get port id: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (mgmtIf.indexOf("slotId") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "slotId")) != null && !temp.trim().equals("")) {
                        try {
                            slotId = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get slot id: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (mgmtIf.indexOf("stateQual") > 0) {
                        stateQual = CliUtil.getXmlParamValue(mgmtIf, "stateQual");
                    }
                    if (mgmtIf.indexOf("subject") > 0) {
                        subject = CliUtil.getXmlParamValue(mgmtIf, "subject");
                    }
                    if (mgmtIf.indexOf("transport") > 0) {
                        transport = CliUtil.getXmlParamValue(mgmtIf, "transport");
                    }
                    if (mgmtIf.indexOf("type") > 0) {
                        type = CliUtil.getXmlParamValue(mgmtIf, "type");
                    }
                    if (mgmtIf.indexOf("vnet") > 0 && (temp = CliUtil.getXmlParamValue(mgmtIf, "vnet")) != null && !temp.trim().equals("")) {
                        try {
                            vnet = Integer.parseInt(temp);
                        }
                        catch (NumberFormatException nfe) {
                            _Logger.warn((Object)("getUcsBlades() failed to get vnet: " + temp + ". " + nfe.getMessage()));
                        }
                    }
                    if (dn == null || dn.trim().equals("")) continue;
                    UcsBladeMgmtIfImpl obj = new UcsBladeMgmtIfImpl(access, adminState, discovery, dn, epDn, extBroadcast, extGw, extIp, extMask, ifId, ifRole, ifType, ip, locale, mac, mask, name, peerChassisId, peerDn, peerPortId, peerSlotId, portId, slotId, stateQual, subject, transport, type, vnet);
                    results.add(obj);
                }
            }
            if (results.isEmpty() && in.indexOf("errorCode") > 0) {
                _Logger.warn((Object)("getUcsBladeMgmtIfs() failed: " + in));
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("getUcsBladeMgmtIfs() failed: " + e.getMessage()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UcsClusterBase getTopSystem() throws Exception, IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"topSystem\" inHierarchical=\"false\" cookie=\"" + this.cookie + "\" />";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        RawResponseHandler rawResponseHandler = HttpPeer.rawResponseHandler;
        synchronized (rawResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.rawResponseHandler);
            while (HttpPeer.rawResponseHandler.getResponse() == null) {
                HttpPeer.rawResponseHandler.wait(1000L);
            }
        }
        String in = HttpPeer.rawResponseHandler.getResponse();
        return UcsUtil.getUcsCluster(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UcsNetworkElementBase> getNetworkElements() throws Exception, IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<configResolveClass classId=\"networkElement\" inHierarchical=\"false\" cookie=\"" + this.cookie + "\" />";
        ByteArrayInputStream stream = new ByteArrayInputStream(inputStr.getBytes());
        InputStreamEntity input = new InputStreamEntity((InputStream)stream, (long)inputStr.length());
        this.post.setEntity((HttpEntity)input);
        RawResponseHandler rawResponseHandler = HttpPeer.rawResponseHandler;
        synchronized (rawResponseHandler) {
            this.httpclient.execute((HttpUriRequest)this.post, (ResponseHandler)HttpPeer.rawResponseHandler);
            while (HttpPeer.rawResponseHandler.getResponse() == null) {
                HttpPeer.rawResponseHandler.wait(1000L);
            }
        }
        String in = HttpPeer.rawResponseHandler.getResponse();
        return UcsUtil.getNetworkElements(in);
    }
}

