/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.sm.common.model.UcsClusterBase;
import com.cisco.dcbu.sm.common.model.UcsNetworkElementBase;
import com.cisco.dcbu.sm.server.discovery.UcsUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HttpsPeer {
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    HttpsURLConnection urlConnection;
    String httpsCookie = null;
    String hostname = null;

    public HttpsPeer(String hostname, String username, String passwd) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        this.hostname = hostname;
        this.httpsCookie = this.getCookie(hostname, username, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCookie(String hostname, String username, String passwd) throws IOException, ClientProtocolException, InterruptedException {
        String query = "<aaaLogin cookie=\"null\" inName=\"" + username + "\" " + "  inPassword=\"" + passwd + "\" />";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(query);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)(" ReceiptResponse: " + strbuf));
            }
            int index = strbuf.indexOf("outCookie=");
            String cookie = null;
            if (index > -1) {
                cookie = strbuf.substring(index + 11);
                cookie = cookie.substring(0, cookie.indexOf("\""));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(" Cookie is: " + cookie));
                }
            }
            if ((index = strbuf.indexOf("errorDescr=")) > -1) {
                String error = strbuf.substring(index + 11);
                error = error.substring(0, error.indexOf(">"));
                throw new Exception(error);
            }
            input.close();
            String string = cookie;
            return string;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer getHttpsCookie failed " + hostname + ". " + ex.getMessage()));
            String string = null;
            return string;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut() throws IOException, ClientProtocolException, InterruptedException {
        String inputStr = "<aaaLogout cookie=\"" + this.httpsCookie + "\" inCookie=\"" + this.httpsCookie + "\"/>";
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            int length;
            URL url = new URL("https://" + this.hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)(" ReceiptResponse: " + strbuf));
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpPeer logOutHttps failed " + this.hostname), (Throwable)ex);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UcsClusterBase getTopSystem() throws IOException, ClientProtocolException, InterruptedException {
        FilterInputStream input = null;
        FilterOutputStream output = null;
        UcsClusterBase result = null;
        try {
            int length;
            String inputStr = null;
            inputStr = "<configResolveClass classId=\"topSystem\" inHierarchical=\"false\" cookie=\"" + this.httpsCookie + "\" />";
            URL url = new URL("https://" + this.hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("isClusterMode response: " + strbuf));
            }
            input.close();
            input = null;
            UcsClusterBase ucsClusterBase = result = UcsUtil.getUcsCluster(strbuf.toString());
            return ucsClusterBase;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpsPeer isClusterMode failed " + this.hostname), (Throwable)ex);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
        return result;
    }

    public List<UcsNetworkElementBase> getNetworkElements() throws Exception, IOException, ClientProtocolException, InterruptedException {
        FilterInputStream input = null;
        FilterOutputStream output = null;
        List<UcsNetworkElementBase> results = null;
        try {
            int length;
            String inputStr = null;
            inputStr = "<configResolveClass classId=\"networkElement\" inHierarchical=\"false\" cookie=\"" + this.httpsCookie + "\" />";
            URL url = new URL("https://" + this.hostname + "/nuova");
            this.urlConnection = (HttpsURLConnection)url.openConnection();
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.urlConnection.setRequestMethod("POST");
            HttpsURLConnection.setFollowRedirects(true);
            this.urlConnection.setAllowUserInteraction(true);
            this.urlConnection.setConnectTimeout(5000);
            this.urlConnection.setReadTimeout(5000);
            output = new DataOutputStream(this.urlConnection.getOutputStream());
            ((DataOutputStream)output).writeBytes(inputStr);
            output.close();
            input = new DataInputStream(this.urlConnection.getInputStream());
            byte[] buf = new byte[128];
            StringBuffer strbuf = new StringBuffer();
            while ((length = ((DataInputStream)input).read(buf)) > 0) {
                String tmpStr = new String(buf, 0, length);
                strbuf.append(tmpStr);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)(" Server Blade response: " + strbuf));
            }
            input.close();
            input = null;
            if (strbuf.length() > 0) {
                results = UcsUtil.getNetworkElements(strbuf.toString());
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("HttpsPeer getNetworkElements failed " + this.hostname), (Throwable)ex);
            throw ex;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
            if (this.urlConnection != null) {
                this.urlConnection.disconnect();
            }
        }
        return results;
    }
}

