/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.type.SwitchIfWwnKey;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.IpAddrIntKey;
import com.cisco.dcbu.sm.server.discovery.PortChannel;
import com.cisco.dcbu.sm.server.discovery.SwitchWwnKey;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FcLinkIf;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class PortChannelWorker
implements SnmpCallbackIf {
    static final int[] _PCMbrListOid = MibNode.get("portChannelMemberList").getOid();
    static final int[] _PCAutoCreateOid = MibNode.get("portChannelExtAutoCreated").getOid();
    static final int[] _FcIfElpNbrPortName = MibNode.get("fcIfElpNbrPortName").getOid();
    static final int[] _FcIfElpNbrNodeName = MibNode.get("fcIfElpNbrNodeName").getOid();
    static final int[] _FcIfWwn = MibNode.get("fcIfWwn").getOid();
    static Logger _Log = LogManager.getLogger((String)"fms.disc");
    private final AtomicInteger _numOutstanding1 = new AtomicInteger(0);
    private final AtomicInteger _numOutstanding2 = new AtomicInteger(0);
    private Map<IpAddrIntKey, PortChannel> _fcLinkByIpAddrIfIndex;
    private Map<IpAddrIntKey, PortChannel> _fcLinkByIpAddrPc;
    private Map<SwitchWwnKey, SwitchWwnKey> _ifIndexBySwitchWwn;
    private Map<Wwn, SwitchImpl> _switchByWwn;

    PortChannelWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean discover(Map<Short, VsanImpl> vsanById) throws DiscoveryException {
        this._switchByWwn = new HashMap<Wwn, SwitchImpl>();
        HashSet<AbstractModelObjectImpl> fcLinks = new HashSet<AbstractModelObjectImpl>();
        for (VsanImpl vsan : vsanById.values()) {
            fcLinks.addAll(vsan.getIsls());
            fcLinks.addAll(vsan.getNpvLinks());
            vsan.resetDiscFlag(128);
            for (SwitchImpl sw : vsan.getAllSwitches()) {
                this._switchByWwn.put(sw.getWwn(), sw);
            }
        }
        if (fcLinks.size() == 0) {
            return false;
        }
        this._fcLinkByIpAddrPc = Collections.synchronizedMap(new HashMap());
        this._ifIndexBySwitchWwn = Collections.synchronizedMap(new HashMap());
        IdentityHashMap<SnmpPeer, VarBindList> vblByPeer = new IdentityHashMap<SnmpPeer, VarBindList>();
        for (FcLinkIf fcLinkIf : fcLinks) {
            if (!fcLinkIf.isPortChannel() || !fcLinkIf.isPresent()) continue;
            SnmpPeer peer = null;
            int pcIndex = 0;
            try {
                peer = fcLinkIf.getSwitch1().createPeer();
                if (fcLinkIf.getSwitch1().isManageable()) {
                    pcIndex = (fcLinkIf.getIfIndex1() & 0xFF) + 1;
                }
            }
            catch (SnmpException snmpException) {
                // empty catch block
            }
            if (peer == null || pcIndex == 0) {
                try {
                    peer = fcLinkIf.getSwitch2().createPeer();
                    if (fcLinkIf.getSwitch2().isManageable()) {
                        pcIndex = (fcLinkIf.getIfIndex2() & 0xFF) + 1;
                    }
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
            }
            if (peer == null || pcIndex == 0) continue;
            this.addVbl(fcLinkIf, peer, pcIndex, vblByPeer);
        }
        if (vblByPeer.size() == 0) {
            return false;
        }
        boolean timeout = false;
        this._fcLinkByIpAddrIfIndex = Collections.synchronizedMap(new HashMap());
        this._numOutstanding1.set(0);
        AtomicInteger atomicInteger = this._numOutstanding1;
        synchronized (atomicInteger) {
            for (Map.Entry ent : vblByPeer.entrySet()) {
                SnmpPeer snmpPeer = (SnmpPeer)ent.getKey();
                VarBindList varBindList = (VarBindList)ent.getValue();
                this._numOutstanding1.incrementAndGet();
                try {
                    new SnmpFetch().get(snmpPeer, varBindList, this);
                }
                catch (Exception ex) {
                    _Log.log((Priority)Level.WARN, (Object)(snmpPeer.getAddress().getHostAddress() + " port channel member discovery error."), (Throwable)ex);
                    this._numOutstanding1.decrementAndGet();
                }
            }
        }
        try {
            AtomicInteger atomicInteger2 = this._numOutstanding1;
            synchronized (atomicInteger2) {
                this._numOutstanding1.wait(120000L);
            }
        }
        catch (InterruptedException interruptedException) {
            _Log.log((Priority)Level.WARN, (Object)("port channel member discovery interrupted: " + StringUtil.getRangeString(vsanById.keySet())));
            return false;
        }
        if (this._numOutstanding1.get() > 0) {
            timeout = true;
            _Log.log((Priority)Level.WARN, (Object)("port channel member discovery timed out: " + this._numOutstanding1.get() + " " + StringUtil.getRangeString(vsanById.keySet())));
        }
        ArrayList<SnmpPeer> arrayList = new ArrayList<SnmpPeer>();
        for (PortChannel spc : this._fcLinkByIpAddrPc.values()) {
            if (spc._children.size() <= 0 || !spc._needsFcipLookup) continue;
            try {
                SnmpPeer snmpPeer = spc._pc.getSwitch2().createPeer();
                if (arrayList.contains(snmpPeer)) continue;
                arrayList.add(snmpPeer);
            }
            catch (SnmpException snmpException) {}
        }
        if (arrayList.size() > 0) {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(_FcIfWwn, 0x9FFFFFF)));
            this._numOutstanding2.set(0);
            AtomicInteger spc = this._numOutstanding2;
            synchronized (spc) {
                for (SnmpPeer snmpPeer : arrayList) {
                    SnmpPDU req = new SnmpPDU(-91, vbl);
                    req.setMaxRptr(32);
                    this._numOutstanding2.incrementAndGet();
                    try {
                        snmpPeer.send(req, this);
                    }
                    catch (Exception ex) {
                        _Log.log((Priority)Level.WARN, (Object)(snmpPeer.getAddress().getHostAddress() + " FCIP port channel member discovery error."), (Throwable)ex);
                        this._numOutstanding2.decrementAndGet();
                    }
                }
            }
            try {
                spc = this._numOutstanding2;
                synchronized (spc) {
                    this._numOutstanding2.wait(DiscoveryManager.MAX_WAIT);
                }
            }
            catch (InterruptedException ex) {
                _Log.log((Priority)Level.WARN, (Object)("FCIP port channel member discovery interrupted: " + StringUtil.getRangeString(vsanById.keySet())));
                return false;
            }
            if (this._numOutstanding2.get() > 0) {
                timeout = true;
                _Log.log((Priority)Level.WARN, (Object)("FCIP port channel member discovery timeout: " + StringUtil.getRangeString(vsanById.keySet())));
            }
            for (PortChannel portChannel : this._fcLinkByIpAddrPc.values()) {
                if (portChannel._children.size() <= 0 || !portChannel._needsFcipLookup) continue;
                for (int[] pair : portChannel._children) {
                    SwitchWwnKey key = new SwitchWwnKey(portChannel._pc.getSwitch2(), pair[1]);
                    SwitchWwnKey swk = this._ifIndexBySwitchWwn.get(key);
                    if (swk == null) continue;
                    pair[1] = swk._ifIndex;
                }
            }
        }
        for (PortChannel spc : this._fcLinkByIpAddrPc.values()) {
            if (spc._children.size() == 0) continue;
            spc._pc.setChildren(spc._children);
            spc._pc.setConfigChildCount(spc._configChildCount);
        }
        ArrayList<FcLinkIf> pcs = new ArrayList<FcLinkIf>();
        for (FcLinkIf fcLinkIf : fcLinks) {
            if (fcLinkIf.getChildren() == null) continue;
            pcs.add(fcLinkIf);
        }
        if (pcs.size() > 0) {
            for (FcLinkIf fcLinkIf : pcs) {
                if (fcLinkIf.getFabric() == null) continue;
                if (fcLinkIf instanceof NpvLinkImpl) {
                    fcLinks.addAll(fcLinkIf.getFabric().findNpvLinksByCoreSwitch(fcLinkIf.getSwitch1()));
                    continue;
                }
                fcLinks.addAll(fcLinkIf.getFabric().findIslsBySwitches(fcLinkIf.getSwitch1(), fcLinkIf.getSwitch2()));
            }
            fcLinks.removeAll(pcs);
            for (FcLinkIf fcLinkIf : fcLinks) {
                FcLinkIf pc = PortChannelWorker.fcLinkInChannel(pcs, fcLinkIf);
                if (pc == null) continue;
                if (fcLinkIf instanceof IslImpl) {
                    if (fcLinkIf.isPresent()) {
                        if (pc.isPresent()) {
                            _Log.warn((Object)("PortChannelWorker detected conflict: both Isl and PC are present:" + fcLinkIf + ", " + pc));
                            continue;
                        }
                        pc.getFabric().removeIsl((IslImpl)pc, false, false);
                        continue;
                    }
                    if (!pc.isPresent()) continue;
                    fcLinkIf.getFabric().removeIsl((IslImpl)fcLinkIf, false, false);
                    continue;
                }
                if (!(fcLinkIf instanceof NpvLinkImpl)) continue;
                if (pc.isPresent()) {
                    if (fcLinkIf.isPresent()) {
                        fcLinkIf.getFabric().removeNpvLink((NpvLinkImpl)fcLinkIf, false, false);
                        continue;
                    }
                    fcLinkIf.getFabric().removeNpvLink((NpvLinkImpl)fcLinkIf, true, false);
                    continue;
                }
                if (!fcLinkIf.isPresent()) continue;
                pc.getFabric().removeNpvLink((NpvLinkImpl)pc, true, false);
            }
        }
        this._fcLinkByIpAddrIfIndex.clear();
        this._fcLinkByIpAddrPc.clear();
        this._ifIndexBySwitchWwn.clear();
        return timeout;
    }

    void addVbl(FcLinkIf pc, SnmpPeer peer, int pcIndex, IdentityHashMap<SnmpPeer, VarBindList> vblByPeer) {
        IpAddrIntKey addrPcKey = new IpAddrIntKey(peer.getAddress(), pcIndex);
        PortChannel spc = new PortChannel(pc);
        this._fcLinkByIpAddrPc.put(addrPcKey, spc);
        VarBindList vbl = vblByPeer.get(peer);
        if (vbl == null) {
            vbl = new VarBindList();
            vblByPeer.put(peer, vbl);
        }
        vbl.add(new SnmpVarBind(new SnmpOID(_PCMbrListOid, pcIndex)));
        vbl.add(new SnmpVarBind(new SnmpOID(_PCAutoCreateOid, pcIndex)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        AtomicInteger atomicInteger;
        SwitchImpl sw;
        SnmpOID first = pdu.getOid(0);
        VarBindList vbl = pdu.getVariables();
        if (first.startsWith(_PCMbrListOid)) {
            this._numOutstanding1.decrementAndGet();
            if (timedOut) {
                _Log.warn((Object)(pdu.getHostAddress() + " port channel member list query timed out"));
            } else {
                VarBindList elpVbl = new VarBindList();
                for (int i = 0; i < vbl.size(); i += 2) {
                    IpAddrIntKey addrPcKey;
                    PortChannel spc;
                    SnmpVarBind vb = vbl.getVb(i);
                    SnmpVar v = vb.getVar();
                    if (v.getType() != 4) continue;
                    int[] oid = vb.getOid().getValue();
                    int pcIndex = oid[oid.length - 1];
                    int[] members = SnmpIntList.valueOf(((SnmpString)vb.getVar()).getValue());
                    if (members.length == 0 || (spc = this._fcLinkByIpAddrPc.get(addrPcKey = new IpAddrIntKey(pdu.getAddress(), pcIndex))) == null) continue;
                    spc._configChildCount = (short)members.length;
                    spc._pc.setPortChannelAutoCreated(vbl.intValue(i + 1) == 1);
                    Map<IpAddrIntKey, PortChannel> map = this._fcLinkByIpAddrIfIndex;
                    synchronized (map) {
                        for (int j = 0; j < members.length; ++j) {
                            IpAddrIntKey key = new IpAddrIntKey(pdu.getAddress(), members[j]);
                            this._fcLinkByIpAddrIfIndex.put(key, spc);
                            elpVbl.add(new SnmpVarBind(new SnmpOID(_FcIfElpNbrPortName, members[j])));
                        }
                        continue;
                    }
                }
                if (elpVbl.size() > 0 && pdu.getPeer() != null) {
                    this._numOutstanding1.incrementAndGet();
                    try {
                        new SnmpFetch().get(pdu.getPeer(), elpVbl, this);
                    }
                    catch (Exception ex) {
                        this._numOutstanding1.decrementAndGet();
                        _Log.log((Priority)Level.WARN, (Object)"sending port channel ELP query error", (Throwable)ex);
                    }
                }
            }
        } else if (first.startsWith(_FcIfElpNbrPortName)) {
            this._numOutstanding1.decrementAndGet();
            if (timedOut) {
                _Log.warn((Object)(pdu.getHostAddress() + " port channel member ifindex query timed out"));
            } else {
                sw = SanManager.getInstance().findSwitchByIP(pdu.getAddress());
                for (int i = 0; i < vbl.size(); ++i) {
                    int ifIndex2;
                    SnmpVarBind vb = vbl.getVb(i);
                    SnmpVar v = vb.getVar();
                    if (v.getType() != 4) continue;
                    int[] oid = vb.getOid().getValue();
                    int ifIndex1 = oid[oid.length - 1];
                    IpAddrIntKey key = new IpAddrIntKey(pdu.getAddress(), ifIndex1);
                    PortChannel spc = this._fcLinkByIpAddrIfIndex.get(key);
                    byte[] b = ((SnmpString)vb.getVar()).getValue();
                    if (IfIndexUtil.getType(ifIndex1) == 10) {
                        ifIndex2 = ((b[0] & 0xFFFFFF0F) << 8) + (b[1] & 0xFF);
                        SwitchWwnKey swk = this._ifIndexBySwitchWwn.get(new SwitchWwnKey(sw, ifIndex2));
                        if (swk != null) {
                            ifIndex2 = swk._ifIndex;
                        } else if (spc != null) {
                            spc._needsFcipLookup = true;
                        }
                    } else {
                        byte[] nbrSwwnb = IfIndexUtil.ifWwn2SwWwn(b);
                        Wwn nbrSwwn = new Wwn(nbrSwwnb);
                        SwitchImpl nbrSw = this._switchByWwn.get(nbrSwwn);
                        if (nbrSw != null) {
                            ifIndex2 = nbrSw.getBase().ifWwn2IfIndex(b, IfIndexIf.FwwnInfo.PcMember);
                            if (IfIndexUtil.isFmIfIndex(ifIndex2)) {
                                _Log.info((Object)(sw + "-ifindex1=" + ifIndex1 + " with nbrsw= " + nbrSw + " only get temporary ifindex2=" + ifIndex2 + " for fwwn=" + SnmpString.toHexString(b)));
                            }
                        } else {
                            ifIndex2 = IfIndexUtil.fmFwwn2IfIndex(b);
                            _Log.info((Object)(sw + "-ifindex1=" + ifIndex1 + ", cannot find nbrsw, have temporary ifindex2=" + ifIndex2 + " for fwwn=" + SnmpString.toHexString(b)));
                        }
                        if (nbrSw != null && IfIndexUtil.isFmIfIndex(ifIndex2) && spc != null) {
                            nbrSw.getFabric().addPendingLink(new SwitchIfWwnKey(nbrSw.getSwitchPK(), new Wwn(b)), spc._pc);
                        }
                    }
                    if (spc != null) {
                        spc.addPair(sw, ifIndex1, ifIndex2);
                        continue;
                    }
                    _Log.debug((Object)("PortChannelWorker.callback():spc is null for " + sw.getIpAddress() + "," + ifIndex1 + ":" + ifIndex2));
                }
            }
        } else if (first.startsWith(_FcIfWwn)) {
            this._numOutstanding2.decrementAndGet();
            if (timedOut) {
                _Log.warn((Object)(pdu.getHostAddress() + " FCIP port channel member pwwn query timed out"));
            } else {
                sw = SanManager.getInstance().findSwitchByIP(pdu.getAddress());
                if (sw != null) {
                    SnmpVarBind vb;
                    int[] oid;
                    int ifIndex;
                    for (int i = 0; i < vbl.size() && IfIndexUtil.getType(ifIndex = (oid = (vb = vbl.getVb(i)).getOid().getValue())[oid.length - 1]) == 10; ++i) {
                        byte[] b = ((SnmpString)vb.getVar()).getValue();
                        int pWwn = ((b[0] & 0xFFFFFF0F) << 8) + (b[1] & 0xFF);
                        SwitchWwnKey swk = new SwitchWwnKey(sw, pWwn);
                        swk._ifIndex = ifIndex;
                        this._ifIndexBySwitchWwn.put(swk, swk);
                    }
                }
            }
        }
        if (this._numOutstanding1.get() <= 0) {
            atomicInteger = this._numOutstanding1;
            synchronized (atomicInteger) {
                this._numOutstanding1.notifyAll();
            }
        }
        if (this._numOutstanding2 != null && this._numOutstanding2.get() <= 0) {
            atomicInteger = this._numOutstanding2;
            synchronized (atomicInteger) {
                this._numOutstanding2.notifyAll();
            }
        }
    }

    private static FcLinkIf fcLinkInChannel(List<FcLinkIf> pcs, FcLinkIf fcLink) {
        for (FcLinkIf pc : pcs) {
            if (!pc.getSwitch1IntKey().getSwitchKey().equals(fcLink.getSwitch1IntKey().getSwitchKey()) || !pc.getSwitch2IntKey().getSwitchKey().equals(fcLink.getSwitch2IntKey().getSwitchKey())) continue;
            for (int[] ifIndeces : pc.getChildren()) {
                if (fcLink.getIfIndex1() != ifIndeces[0] || fcLink.getIfIndex2() != ifIndeces[1]) continue;
                return pc;
            }
        }
        return null;
    }
}

