/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.discovery.AbstractWorker;
import com.cisco.dcbu.sm.server.discovery.DiscProc;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.SwType;
import com.cisco.dcbu.sm.server.discovery.SyncedVsans;
import com.cisco.dcbu.sm.server.discovery.UcsManager;
import com.cisco.dcbu.sm.server.discovery.WorkerCallbackIf;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SwitchWorker
extends AbstractWorker {
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    static final byte SYS_INFO = 1;
    static final byte SW_INFO = 2;
    static final byte CONNUNIT_INFO = 3;
    static final byte FE_MODULE = 4;
    static final byte MDS_FEATURE = 5;
    static final byte NEIGHBOR_SW = 6;
    static final byte VSANS = 7;
    static final byte CONNUNIT_LINK = 8;
    static final byte EDGE_LINK = 9;
    static final byte ZONE_ALIAS = 10;
    static final byte ENF_ZONESET = 11;
    static final byte ENF_ZONES = 12;
    static final byte EVENT_REG = 13;
    static final byte FC_PORT = 14;
    static final byte FICON_PORT = 15;
    static final byte VIRT_ENCL = 16;
    static final byte SYM_NODENAME = 17;
    static final byte SME = 18;
    static final byte ISL = 19;
    static final byte ENDPORT = 20;
    static final byte IOA = 21;
    static final byte CFS_REGION = 22;
    static final byte FLOGIPORT = 23;
    static final byte VFC_BIND = 24;
    static final byte FM_LICENSE = 25;
    static final byte VPN_INFO = 26;
    static final String[] _DescrTable = new String[]{"system info", "switch info", "connUnit info", "FE modules", "MDS features", "neighbor switches", "VSANs", "connUnitLink", "edgeLink", "zone alias", "enforced zoneset", "enforced zones", "event registration", "FC ports", "FICON ports", "virtual enclosure", "symbolic node name", "SME", "Isl", "EndPort", "IOA", "CFS Region", "Flogi Port", "Vfc Binding", "FM License", "vpn info"};
    static SwDiscProc[] _Procs = new SwDiscProc[]{new SwDiscProc(1, SwType.ANY, 1), new SwDiscProc(2, SwType.ANY, 2), new SwDiscProc(3, SwType.ANY, 4), new SwDiscProc(26, SwType.MDS_QUAIL, 65536), new SwDiscProc(4, SwType.QUAIL, 0), new SwDiscProc(5, SwType.MDS, 8), new SwDiscProc(6, SwType.QUAIL, 0), new SwDiscProc(7, SwType.MDS, 16), new SwDiscProc(8, SwType.QUAIL, 0), new SwDiscProc(13, SwType.MDS, 256), new SwDiscProc(14, SwType.MDS_QUAIL, 64), new SwDiscProc(24, SwType.MDS, 32768), new SwDiscProc(23, SwType.MDS, 16384), new SwDiscProc(9, SwType.QUAIL, 0), new SwDiscProc(10, SwType.QUAIL, 0), new SwDiscProc(11, SwType.QUAIL, 0), new SwDiscProc(12, SwType.QUAIL, 0), new SwDiscProc(15, SwType.MDS, 128), new SwDiscProc(16, SwType.MDS, 512), new SwDiscProc(17, SwType.MDS, 0), new SwDiscProc(18, SwType.MDS, 2048), new SwDiscProc(21, SwType.MDS, 4096), new SwDiscProc(22, SwType.MDS, 8192), new SwDiscProc(25, SwType.MDS, 0)};
    SwitchImpl _seed;
    private SyncedVsans _syncedVids;
    static int _maxWait = 75;

    SwitchWorker(SwitchImpl seed, WorkerCallbackIf observer) {
        if (seed.getInetAddress() == null) {
            throw new IllegalArgumentException(seed + " does not have a valid IP address");
        }
        this._seed = seed;
        this._observer = observer;
        this._syncedVids = null;
        _maxWait = Integer.getInteger("fabric.discovery.worker.timeout", 75);
    }

    public SwitchWorker(SwitchImpl seed, WorkerCallbackIf observer, SyncedVsans vids) {
        if (seed.getInetAddress() == null) {
            throw new IllegalArgumentException(seed + " does not have a valid IP address");
        }
        this._seed = seed;
        this._observer = observer;
        this._syncedVids = vids;
        _maxWait = Integer.getInteger("fabric.discovery.worker.timeout", 75);
    }

    @Override
    protected void exec() throws Exception {
        TraceLogger swLogger = this._seed.getLogger();
        if (swLogger != null && swLogger.isDebuggable()) {
            swLogger.log(Level.DEBUG, this._seed + " discFlags=" + this._seed.toDiscFlagString());
        }
        boolean wasManageable = this._seed.isManageable();
        if (!this._seed.isManageable() && this._seed.getDiscFlag() == 0) {
            _Logger.warn((Object)(this + " discovery skipped due to not manageable during polling"));
            return;
        }
        if (this._seed.getPeer() == null || !this._seed.isManageable()) {
            try {
                this._seed.createPeer();
            }
            catch (Exception se) {
                if (wasManageable) {
                    _Logger.warn((Object)(this + " discovery skipped :" + se.getMessage()));
                }
                return;
            }
        }
        for (SwDiscProc proc : _Procs) {
            if (this._status.get() == 1) {
                long time = _Logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                boolean execed = proc.discover(this._seed);
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(this + ": " + proc + (execed ? " done in " + (System.currentTimeMillis() - time) + " ms" : " skipped")));
                }
            } else if (this._status.get() == 2) {
                _Logger.warn((Object)(this + ": " + proc + " interrupted abruptly"));
                return;
            }
            this.sendUpdate(proc);
            if (proc._step == 13 && this._seed.isMDS() && this._seed.getDiscFlag() != 0 && !this.attempVsans()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attempVsans() {
        boolean vsanDone;
        if (this._syncedVids == null) {
            return true;
        }
        long startWaitTime = System.currentTimeMillis();
        long timeToWait = _maxWait * 1000;
        while (!this._syncedVids.isEndportDiscoveryDone(this._seed.getVsanMembership()) && timeToWait > 0L) {
            Object object = this._syncedVids.getLock();
            synchronized (object) {
                try {
                    this._syncedVids.getLock().wait(timeToWait);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            timeToWait = (long)(_maxWait * 1000) - (System.currentTimeMillis() - startWaitTime);
        }
        boolean bl = vsanDone = timeToWait > 0L;
        if (!vsanDone) {
            this._status.set(4);
            _Logger.warn((Object)(this + ": waiting VSAN discovery timed out in " + (System.currentTimeMillis() - startWaitTime) + " ms"));
        } else if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)(this + ": waited VSAN discovery " + (System.currentTimeMillis() - startWaitTime) + " ms"));
        }
        return vsanDone;
    }

    @Override
    public void stop() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " stops the switch worker"));
        }
        super.stop();
    }

    public String toString() {
        return this._seed.getIpAddress() + " -- SwitchWorker";
    }

    static class SwDiscProc
    extends DiscProc {
        SwDiscProc(byte step, SwType swtype, int flag) {
            super(step, swtype, flag);
        }

        public String toString() {
            return "discover " + _DescrTable[this._step - 1];
        }

        boolean discover(SwitchImpl sw) throws DiscoveryException {
            boolean b = false;
            if (!((this._flag == 0 || sw.isDiscFlagSet(this._flag)) && (this._swtype == SwType.ANY || sw.isMDS() && this._swtype.match(SwType.MDS) || sw.isQuail() && this._swtype.match(SwType.QUAIL)))) {
                return false;
            }
            try {
                switch (this._step) {
                    case 1: {
                        b = SnmpAdapter.discoverSysInfo(sw);
                        break;
                    }
                    case 2: {
                        b = SnmpAdapter.discoverSwitchInfo(sw);
                        UcsManager.getInstance().setIpAddresses(sw);
                        break;
                    }
                    case 3: {
                        b = SnmpAdapter.discoverConnUnitInfo(sw);
                        break;
                    }
                    case 4: {
                        b = SnmpAdapter.discoverFeModules(sw);
                        break;
                    }
                    case 5: {
                        b = SnmpAdapter.discoverMdsFeatures(sw);
                        break;
                    }
                    case 22: {
                        b = SnmpAdapter.discoverCfsRegion(sw);
                        break;
                    }
                    case 6: {
                        b = SnmpAdapter.discoverConnUnits(sw, null);
                        break;
                    }
                    case 7: {
                        b = SnmpAdapter.discoverVsans(sw);
                        break;
                    }
                    case 8: {
                        b = SnmpAdapter.discoverConnUnitLinks(sw, null);
                        break;
                    }
                    case 9: {
                        b = SnmpAdapter.discoverConnUnitSns(sw, null);
                        break;
                    }
                    case 10: {
                        b = SnmpAdapter.discoverConnUnitZoneAliases(sw, null);
                        break;
                    }
                    case 11: {
                        b = SnmpAdapter.discoverConnUnitZoneset(sw, null);
                        break;
                    }
                    case 12: {
                        b = SnmpAdapter.discoverConnUnitZones(sw, null);
                        break;
                    }
                    case 13: {
                        b = SnmpAdapter.discoverEventRegistration(sw);
                        break;
                    }
                    case 23: {
                        b = SnmpAdapter.discoverFlogiPorts(sw);
                        break;
                    }
                    case 24: {
                        b = SnmpAdapter.discoverVfcBinding(sw);
                        break;
                    }
                    case 14: {
                        b = SnmpAdapter.discoverFcPorts(sw);
                        break;
                    }
                    case 15: {
                        b = SnmpAdapter.discoverFiconPorts(sw);
                        break;
                    }
                    case 16: {
                        b = SnmpAdapter.discoverVirtualEnclosure(sw);
                        break;
                    }
                    case 17: {
                        b = SnmpAdapter.discoverSymNodeName(sw);
                        break;
                    }
                    case 18: {
                        b = SnmpAdapter.discoverSMEs(sw);
                        break;
                    }
                    case 21: {
                        b = SnmpAdapter.discoverIAS(sw);
                        break;
                    }
                    case 25: {
                        b = SnmpAdapter.discoverFMPermLicensed(sw);
                        break;
                    }
                    case 26: {
                        b = SnmpAdapter.discoverVpnInfo(sw);
                    }
                }
            }
            catch (SnmpException se) {
                _Logger.debug((Object)(this + " snmp exception:"), (Throwable)se);
                if (se.isUnmanageableError()) {
                    if (this._step == 1 || this._step == 2 && !sw.isDiscFlagSet(1)) {
                        sw.resetPeer();
                        sw.setManageable(false, se.getMessage());
                        throw new DiscoveryException(this + " error: " + se.getMessage(), se);
                    }
                    if (se.isTimeOut()) {
                        sw.setManageable(true, se.getMessage());
                    } else {
                        sw.resetPeer();
                        sw.setManageable(false, se.getMessage());
                    }
                    throw new DiscoveryException(this + " error: " + se.getMessage(), se);
                }
                _Logger.warn((Object)(sw.getIpAddress() + " -- SwitchWorker: " + this + " exception: " + se.getMessage()));
            }
            catch (Exception ex) {
                if (!sw.isPeerCreated()) {
                    sw.setManageable(false, "peer failure");
                    throw new DiscoveryException(sw.getIpAddress() + " -- SwitchWorker: " + this + " " + "peer failure");
                }
                if (ex instanceof DiscoveryException && ((DiscoveryException)ex).isCausedBySnmp()) {
                    _Logger.warn((Object)(sw.getIpAddress() + " -- SwitchWorker: " + this + " exception: " + ex.getMessage()));
                }
                _Logger.warn((Object)(sw.getIpAddress() + " -- SwitchWorker: " + this + " exception: " + ex.getMessage()), (Throwable)ex);
            }
            return b;
        }
    }
}

