/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.em;

import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTrapListenerIf;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.TrapFilter;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.server.em.AbstractReceiver;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.em.EventThread;
import com.cisco.dcbu.sm.server.em.SnmpTrapStore;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

class SnmpTrapReceiver
extends AbstractReceiver
implements SnmpTrapListenerIf {
    static int _MAX_INCOMING = 3000;
    static SnmpTrapSession _trapSession;
    static MyTrapFilter _trapFilter;
    private InetAddress _regAddr;
    int _localPort = 2162;
    int[] _srcs;
    SnmpTrapStore _store;
    long _received;
    long _dropped;
    boolean _isEnabled;

    SnmpTrapReceiver() throws Exception {
        this((EventManagerService)ServiceConfig.findService((String)"Event Manager Service"));
    }

    SnmpTrapReceiver(EventManagerService emService) throws Exception {
        super("SNMP Trap Receiver", 1);
        String value = System.getProperty("events.maxIncoming", "3000");
        _MAX_INCOMING = Integer.parseInt(value);
        this.setThrottlePoint(_MAX_INCOMING);
        this.enableThrottle(true);
        if (_trapSession == null) {
            String portStr;
            Properties props = emService.getProperties();
            String regStr = props.getProperty("trap.registaddress");
            if (regStr != null && regStr.trim().length() > 0) {
                try {
                    regStr = regStr.trim();
                    this._regAddr = NetUtil.getLocalAddressByName(regStr);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)("Invalid trap registration address " + regStr), (Throwable)ex);
                }
            }
            if (this._regAddr == null) {
                this._regAddr = NetUtil.getLocalAddr(null);
            }
            if ((portStr = props.getProperty("trap.port")) != null && portStr.trim().length() > 0) {
                try {
                    this._localPort = Integer.parseInt(portStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            _Logger.info((Object)("Opening trap session on " + this._localPort));
            _trapSession = new SnmpTrapSession(EventThread._DaGroup);
            _trapSession.enableListening(false);
            try {
                _trapSession.open(this._localPort);
            }
            catch (IOException ex) {
                _trapSession = null;
                throw ex;
            }
            _trapFilter = new MyTrapFilter();
            _trapSession.setTrapFilter(_trapFilter);
            String enabledStr = props.getProperty("trap.listen");
            this._isEnabled = Boolean.valueOf(enabledStr);
        }
    }

    public InetAddress getRegisterAddress() {
        return this._regAddr;
    }

    @Override
    void start() {
        super.start();
        _trapSession.addTrapListener(this);
        _trapSession.enableListening(this._isEnabled);
    }

    @Override
    void stop() {
        _trapSession.enableListening(false);
        super.stop();
        _trapSession.removeTrapListener(this);
        if (this._store != null) {
            this._store.shut();
            ((EventManagerService)ServiceConfig.findService((String)"Event Manager Service")).delConsumer(this._store, 1);
            this._store = null;
        }
    }

    @Override
    void loadConfig(EventManagerService emService) {
        InetAddress[] srcs = emService.getSources();
        if (srcs != null) {
            this._srcs = new int[srcs.length];
            for (int i = 0; i < srcs.length; ++i) {
                this._srcs[i] = srcs[i].hashCode();
            }
        } else {
            this._srcs = new int[0];
        }
        _trapFilter.setIpAddresses(this._srcs);
        if (emService.store(1)) {
            if (this._store == null) {
                this._store = SnmpTrapStore.getSnmpTrapStore();
                emService.addConsumer(this._store, null, 1, null);
            }
        } else if (this._store != null) {
            emService.delConsumer(this._store, 1);
            this._store = null;
        }
        super.loadConfig(emService);
        Object oids = null;
        if (this._store == null && this._consumers != null) {
            for (int i = 0; i < this._consumers.length; ++i) {
                byte[][] oids1;
                if (this._consumers[i].getExtra() == null || (oids1 = (byte[][])this._consumers[i].getExtra()) == null) continue;
                if (oids == null) {
                    oids = new byte[0][];
                }
                byte[][] oids2 = new byte[((byte[][])oids).length + oids1.length][];
                System.arraycopy(oids, 0, oids2, 0, ((byte[][])oids).length);
                System.arraycopy(oids1, 0, oids2, ((byte[][])oids).length, oids1.length);
                oids = oids2;
            }
        }
        _trapFilter.setFilteredOids((byte[][])oids);
    }

    @Override
    void loadConfig() {
        EventManagerService emService = (EventManagerService)ServiceConfig.findService((String)"Event Manager Service");
        this.loadConfig(emService);
    }

    @Override
    public void trapReceived(SnmpSession session, SnmpPDU pdu) {
        this.send(pdu);
    }

    @Override
    Object normalize(Object event) {
        SnmpPDU pdu = (SnmpPDU)event;
        SnmpTrapEntry t = new SnmpTrapEntry(pdu);
        ++this._processed;
        return t;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("Listening is on ");
        buff.append(this._localPort);
        if (this._regAddr != null) {
            buff.append(" (Registration Address ").append(NetUtil.getHostAddress(this._regAddr)).append(")");
        }
        buff.append("\n");
        if (this._store != null) {
            buff.append("Trap tracing is on, see ").append(new File(ClientCache.getTrapsDir()).getAbsolutePath()).append(" for traps stored.\n");
            if (this._store.getError() != null) {
                buff.append("Last error: ").append(this._store.getError()).append("\n");
            }
        }
        buff.append("Statistics: ").append(this._received).append(" received, ").append(this._dropped).append(" dropped, ").append(this._processed).append(" processed, ").append(this._processed != 0L ? this._totalProcTime / this._processed : 0L).append(" ms avg time\n");
        return buff.toString();
    }

    @Override
    public String toHtml() {
        StringBuffer buff = new StringBuffer("Listening is on ");
        buff.append(this._localPort);
        if (this._regAddr != null) {
            buff.append(" (Registration Address ").append(NetUtil.getHostAddress(this._regAddr)).append(")");
        }
        buff.append("<br>");
        if (this._store != null) {
            buff.append("Trap tracing is on.<br>");
            if (this._store.getError() != null) {
                buff.append("Last error: ").append(this._store.getError()).append("<br>");
            }
        }
        buff.append("Statistics: ").append(this._received).append(" received, ").append(this._dropped).append(" dropped, ").append(this._processed).append(" processed");
        return buff.toString();
    }

    public String htmlStatistics() {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        buff.append(this._received);
        buff.append(" received, ");
        buff.append(this._dropped);
        buff.append(" dropped, ");
        buff.append(this._processed);
        buff.append(" processed)");
        return buff.toString();
    }

    class MyTrapFilter
    extends TrapFilter {
        MyTrapFilter() {
            super((byte)7, new int[]{1, 3}, (byte)-89, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validate(DatagramPacket pkt) {
            boolean b;
            ++SnmpTrapReceiver.this._received;
            Object object = SnmpTrapReceiver.this._lock;
            synchronized (object) {
                b = super.validate(pkt);
                SnmpTrapReceiver.this._lock.notifyAll();
            }
            if (!b) {
                ++SnmpTrapReceiver.this._dropped;
            }
            return b;
        }
    }
}

