/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.lib.emccall.EmcCallHome;
import com.cisco.dcbu.lib.emccall.EmcConnection;
import com.cisco.dcbu.lib.emccall.EmcIdentity;
import com.cisco.dcbu.lib.emccall.EmcSwitchEvent;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public enum EmcCallHomeHandler {
    INSTANCE;

    static SimpleDateFormat _TimeFormat;
    static final int[][] _AffectCallHomeTrapOids;
    static final byte CONN_UNIT_STS_CHG = 0;
    static final byte MODULE_STATUS = 1;
    static final byte POWER_STATUS = 2;
    static final byte FRU_REMOVED = 3;
    static final byte FAN_STATUS = 4;
    static final byte LINK_DOWN = 5;
    static final byte FRU_INSERTED = 6;
    static final byte ENT_SENSOR_THR = 7;
    static final byte DELAYED_LINK_DOWN = 8;
    static final byte POWER_SUPPLY_CHANGE = 9;
    public static final String MDS_MODEL_9100_PREFIX = "91";
    public static final String MDS_MODEL_9120 = "9120";
    public static final String MDS_MODEL_9140 = "9140";
    public static final String MDS_MODEL_9124 = "9124";
    public static final String MDS_MODEL_9134 = "9134";
    static final String SYMPTOM_UNKNOWN;
    static final String SYMPTOM_SWITCH_FAILURE;
    static final String SYMPTOM_DIAGNOSTIC_FAILURE;
    static final String SYMPTOM_POWER_SUPPLY_FAILURE;
    static final String SYMPTOM_AC_SOURCE_FAILURE;
    static final String SYMPTOM_REMOVED_POWER_SUPPLY;
    static final String SYMPTOM_FAN_REMOVED;
    static final String SYMPTOM_OVER_TEMPERATURE;
    static final String SYMPTOM_FAN_FAILURE;
    static final String SYMPTOM_PORT_FAILURE;
    static final String SYMPTOM_PORT_BLADE_FAILURE;
    static final String SYMPTOM_SUP_FAILURE;
    static final String SYMPTOM_CROSS_BAR_FAILURE;
    static final String SYMPTOM_PORT_CARD_INSERTED;
    static final String SYMPTOM_SUP_CARD_INSERTED;
    static final String SYMPTOM_POWER_SUPPLY_INSERTED;
    static final String SYMPTOM_FAN_INSERTED;
    static final String SYMPTOM_TEMPERATURE_THRESHOLD_REACHED;
    static final String SYMPTOM_MODULE_INSERTED;
    static final String SYMPTOM_POWER_SUPPLY_CHANGE;
    static final String CATEGORY_UNKNOWN;
    static final String CATEGORY_SWITCH_FAILURE;
    static final String CATEGORY_DIAGNOSTIC_FAILURE;
    static final String CATEGORY_POWER_SUPPLY_FAILURE;
    static final String CATEGORY_AC_SOURCE_FAILURE;
    static final String CATEGORY_REMOVED_POWER_SUPPLY;
    static final String CATEGORY_FAN_REMOVED;
    static final String CATEGORY_OVER_TEMPERATURE;
    static final String CATEGORY_FAN_FAILURE;
    static final String CATEGORY_PORT_FAILURE;
    static final String CATEGORY_PORT_BLADE_FAILURE;
    static final String CATEGORY_SUP_FAILURE;
    static final String CATEGORY_CROSS_BAR_FAILURE;
    static final String CATEGORY_PORT_CARD_INSERTED;
    static final String CATEGORY_SUP_CARD_INSERTED;
    static final String CATEGORY_POWER_SUPPLY_INSERTED;
    static final String CATEGORY_FAN_INSERTED;
    static final String CATEGORY_TEMPERATURE_THRESHOLD_REACHED;
    static final String CATEGORY_MODULE_INSERTED;
    static final String CATEGORY_POWER_SUPPLY_CHANGE;
    static final String SEVERITY_UNKNOWN;
    static final String SEVERITY_SWITCH_FAILURE;
    static final String SEVERITY_DIAGNOSTIC_FAILURE;
    static final String SEVERITY_POWER_SUPPLY_FAILURE;
    static final String SEVERITY_AC_SOURCE_FAILURE;
    static final String SEVERITY_REMOVED_POWER_SUPPLY;
    static final String SEVERITY_FAN_REMOVED;
    static final String SEVERITY_OVER_TEMPERATURE;
    static final String SEVERITY_FAN_FAILURE;
    static final String SEVERITY_PORT_FAILURE;
    static final String SEVERITY_PORT_BLADE_FAILURE;
    static final String SEVERITY_SUP_FAILURE;
    static final String SEVERITY_CROSS_BAR_FAILURE;
    static final String SEVERITY_PORT_CARD_INSERTED;
    static final String SEVERITY_SUP_CARD_INSERTED;
    static final String SEVERITY_POWER_SUPPLY_INSERTED;
    static final String SEVERITY_FAN_INSERTED;
    static final String SEVERITY_TEMPERATURE_THRESHOLD_REACHED;
    static final String SEVERITY_MODULE_INSERTED;
    static final String SEVERITY_POWER_SUPPLY_CHANGE;
    static final String STATUS_UNKNOWN;
    static final String STATUS_SWITCH_FAILURE;
    static final String STATUS_DIAGNOSTIC_FAILURE;
    static final String STATUS_POWER_SUPPLY_FAILURE;
    static final String STATUS_AC_SOURCE_FAILURE;
    static final String STATUS_REMOVED_POWER_SUPPLY;
    static final String STATUS_FAN_REMOVED;
    static final String STATUS_OVER_TEMPERATURE;
    static final String STATUS_FAN_FAILURE;
    static final String STATUS_PORT_FAILURE;
    static final String STATUS_PORT_BLADE_FAILURE;
    static final String STATUS_SUP_FAILURE;
    static final String STATUS_CROSS_BAR_FAILURE;
    static final String STATUS_PORT_CARD_INSERTED;
    static final String STATUS_SUP_CARD_INSERTED;
    static final String STATUS_POWER_SUPPLY_INSERTED;
    static final String STATUS_FAN_INSERTED;
    static final String STATUS_TEMPERATURE_THRESHOLD_REACHED;
    static final String STATUS_MODULE_INSERTED;
    static final String STATUS_POWER_SUPPLY_CHANGE;
    static final String LIST_PORTDOWN_REASONS = "server.callhome.portDownReasons";
    static final String PROP_CALL_HOME_ENABLE = "server.callhome.enable";
    static final String PROP_LOCATION = "server.callhome.location";
    static final String PROP_FROMEMAIL = "server.callhome.fromEmail";
    static final String PROP_TOEMAIL = "server.callhome.recipientEmail";
    static final String PROP_SMTPHOST = "server.callhome.smtphost";
    static final String PROP_XMLDIR = "server.callhome.xmlDir";
    static final String PROP_TRAPDELAYED = "server.callhome.delayedtrap.enable";
    static final String PROP_PORTFAILSONLY = "server.callhome.portFailsOnly";
    private Logger _Logger = LogManager.getLogger((String)"fms.em");
    private Logger _optionalLogger = null;
    private volatile String _listOfPortDownReasons;
    private volatile boolean _callhomeEnable;
    private String _toEmail;
    private String _smtpHost;
    private String _xmlDir;
    private volatile HashSet<Integer> _portDownReasons;
    private EmcIdentity _identity;
    private EmcConnection _connection;
    private EmcSwitchEvent _switchevent;
    private InventoryManager _im;
    private String _eventData;
    private String _xmlFilePath;
    private EventLoggerService _eventLogger;
    private AtomicBoolean _inited = new AtomicBoolean();
    private Semaphore _sema = new Semaphore(1);

    private EmcCallHomeHandler() {
        this.init();
    }

    void init() {
        if (this._inited.get() || !Boolean.getBoolean(PROP_CALL_HOME_ENABLE)) {
            return;
        }
        if (this._sema.tryAcquire() && !this._inited.get()) {
            this._Logger = LogManager.getLogger((String)"fms.em");
            this._eventLogger = (EventLoggerService)ServiceConfig.findService((String)"Event Logger Service");
            this._callhomeEnable = Boolean.getBoolean(PROP_CALL_HOME_ENABLE);
            this._toEmail = System.getProperty(PROP_TOEMAIL);
            this._smtpHost = System.getProperty(PROP_SMTPHOST);
            this._xmlDir = System.getProperty(PROP_XMLDIR, "logs");
            this._im = InventoryManager.getInstance();
            this._xmlFilePath = ClientCache.getInstallLocation() + File.separator + this._xmlDir;
            this._Logger.log((Priority)Level.INFO, (Object)("EMC Call Home is running; To:" + this._toEmail + " SMTP: " + this._smtpHost));
            this._listOfPortDownReasons = System.getProperty(LIST_PORTDOWN_REASONS);
            this.initCauseMap();
            this.loadEmcConfiguration();
            this._inited.set(true);
            this._sema.release();
        }
    }

    public void reinit() {
        if (this._inited.get() && this._sema.tryAcquire()) {
            this._portDownReasons = null;
            this._inited.set(false);
            this._sema.release();
        }
        this.init();
    }

    private void initCauseMap() {
        if (this._listOfPortDownReasons != null) {
            this._portDownReasons = new HashSet();
            StringTokenizer st = new StringTokenizer(this._listOfPortDownReasons, ",");
            StringTokenizer stNums = null;
            String numStr = "";
            int from = 0;
            int to = 0;
            int num = 0;
            int i = 0;
            while (st.hasMoreElements()) {
                numStr = st.nextToken().trim();
                stNums = new StringTokenizer(numStr, "-");
                try {
                    if (stNums.countTokens() > 1) {
                        from = Integer.parseInt(stNums.nextToken().trim());
                        to = Integer.parseInt(stNums.nextToken().trim());
                        for (i = from; i <= to; ++i) {
                            this._portDownReasons.add(i);
                        }
                        continue;
                    }
                    num = Integer.parseInt(numStr);
                    this._portDownReasons.add(num);
                }
                catch (NumberFormatException ne) {
                    this._Logger.warn((Object)("Port down reason list parsing error: " + ne.getMessage()));
                }
            }
        }
    }

    public static EmcCallHomeHandler getInstance() {
        return INSTANCE;
    }

    public void trapReceived(SnmpTrapEntry trapEntry) {
        if (!this._callhomeEnable) {
            return;
        }
        InetAddress trapSrc = trapEntry.getAddr();
        SwitchImpl sw = SanManager.getInstance().findSwitchByIP(trapSrc);
        VarBindList vbl = trapEntry.getVarBindList();
        if (sw == null || trapEntry.getLength() == 0 || vbl == null) {
            this._Logger.log((Priority)Level.WARN, (Object)("EMC CH: bad trap " + trapEntry));
            return;
        }
        try {
            if (!SwitchImpl.isSwitchIsECHSupported(sw.getDBID())) {
                this._Logger.trace((Object)("EMC CH: EMC call home is not supported for switch: " + sw.getName()));
                return;
            }
        }
        catch (SQLException e) {
            this._Logger.warn((Object)"EMC CH: ", (Throwable)e);
        }
        SnmpOID trapOid = (SnmpOID)trapEntry.getVar(1);
        for (int i = 0; i < _AffectCallHomeTrapOids.length; ++i) {
            if (!trapOid.startsWith(_AffectCallHomeTrapOids[i])) continue;
            this._Logger.log((Priority)Level.DEBUG, (Object)("EMC CH: Received " + trapEntry));
            try {
                this.processTrap(sw, i, vbl);
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void processTrap(SwitchImpl sw, int trapNo, VarBindList vbl) {
        switch (trapNo) {
            case 0: {
                if (vbl.size() <= 2) break;
                this.onConnUnitStatusChange(sw, vbl.intValue(2));
                break;
            }
            case 1: {
                if (vbl.size() <= 3) break;
                this.onModuleStatusChangeTrap(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), vbl.intValue(2), vbl.enumValue(2), vbl.longValue(3));
                break;
            }
            case 2: {
                if (vbl.size() <= 3) break;
                this.onPowerStatusChangeTrap(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), vbl.intValue(2), vbl.enumValue(2), vbl.enumValue(3));
                break;
            }
            case 3: 
            case 6: {
                if (vbl.size() <= 4) break;
                this.onFRUChange(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), vbl.stringValue(3), vbl.stringValue(4), trapNo == 6);
                break;
            }
            case 4: {
                if (vbl.size() <= 2) break;
                this.onFanStatusChangeTrap(sw, vbl.getVb(2).getOid().getIndexFromEnd(0), vbl.intValue(2), vbl.enumValue(2));
                break;
            }
            case 5: {
                if (vbl.size() <= 5) break;
                int ifIndex = 0;
                int cause = 0;
                String reason = "";
                for (int i = 2; i < vbl.size(); ++i) {
                    SnmpOID oid = vbl.getVb(i).getOid();
                    if (oid.startsWith(MibNode.get("ifIndex").getOid())) {
                        ifIndex = vbl.intValue(i);
                    }
                    if (!oid.startsWith(MibNode.get("fcIfOperStatusCause").getOid())) continue;
                    cause = vbl.intValue(i);
                    reason = vbl.enumValue(i);
                }
                this.onLinkDownTrap(sw, ifIndex, cause, reason);
                break;
            }
            case 8: {
                if (vbl.size() <= 6) break;
                int ifIndex = 0;
                int cause = 0;
                String reason = "";
                for (int i = 2; i < vbl.size(); ++i) {
                    SnmpOID oid = vbl.getVb(i).getOid();
                    if (oid.startsWith(MibNode.get("ifAdminStatus").getOid())) {
                        ifIndex = vbl.getOid(i).getIndexFromEnd(0);
                    }
                    if (!oid.startsWith(MibNode.get("cieIfOperStatusCause").getOid())) continue;
                    cause = vbl.intValue(i);
                    reason = vbl.enumValue(i);
                }
                this.onDelayedLinkDownTrap(sw, ifIndex, cause, reason);
                break;
            }
            case 7: {
                if (vbl.size() <= 3) break;
                this.onEntThresholdNotice(sw, vbl.intValue(2), vbl.intValue(3));
            }
        }
    }

    private void onEntThresholdNotice(SwitchImpl sw, int threshold, int value) {
        if (value >= threshold) {
            String sev = SEVERITY_TEMPERATURE_THRESHOLD_REACHED;
            String symtomCode = SYMPTOM_TEMPERATURE_THRESHOLD_REACHED;
            String category = CATEGORY_TEMPERATURE_THRESHOLD_REACHED;
            String descr = " Temperature on switch " + sw.getName() + " = " + String.valueOf(value) + " Celsius, has reached/exceeded Threshold value of : " + String.valueOf(threshold);
            this.fillEvent(sw, sev, symtomCode, category);
            this._switchevent.setDescription(descr);
            this._switchevent.setStatus(STATUS_TEMPERATURE_THRESHOLD_REACHED);
            if (this.sendCallHome("Online", STATUS_TEMPERATURE_THRESHOLD_REACHED)) {
                this.logEvent(sw);
            }
        }
    }

    private void onConnUnitStatusChange(SwitchImpl sw, int status) {
        if (status == 5) {
            String sev = SEVERITY_SWITCH_FAILURE;
            String symtomCode = SYMPTOM_SWITCH_FAILURE;
            String category = CATEGORY_SWITCH_FAILURE;
            String descr = " Switch '" + sw.getName() + "' has Failed ";
            this.fillEvent(sw, sev, symtomCode, category);
            this._switchevent.setDescription(descr);
            this._switchevent.setStatus(STATUS_SWITCH_FAILURE);
            if (this.sendCallHome("Online", STATUS_SWITCH_FAILURE)) {
                this.logEvent(sw);
            }
        }
    }

    private void sendCallHomeonLinkDown(SwitchImpl sw, int ifIndex, int cause, String reason) {
        String sev = SEVERITY_PORT_FAILURE;
        String symtomCode = SYMPTOM_PORT_FAILURE;
        String category = CATEGORY_PORT_FAILURE;
        this.fillEvent(sw, sev, symtomCode, category);
        String descr = sw.ifIndexToName(ifIndex) + " " + reason;
        Card mycard = this._im.findCard(sw.getSwitchPK(), IfIndexUtil.getIfIndexCard(ifIndex));
        if (mycard != null) {
            this._switchevent.setSubComponent(mycard.getName());
            this._switchevent.setSubComponentID(mycard.getSerialNumber());
            descr = "Port " + sw.ifIndexToName(ifIndex) + " in '" + mycard.getName() + "' in Slot " + mycard.getSlotId() + " failed: " + reason;
        }
        this._switchevent.setStatus(STATUS_PORT_FAILURE);
        this._switchevent.setDescription(descr);
        if (this.sendCallHome("Online", STATUS_PORT_FAILURE)) {
            this.logEvent(sw);
        }
    }

    private void onDelayedLinkDownTrap(SwitchImpl sw, int ifIndex, int cause, String reason) {
        ArrayList<EndPortImpl> list;
        if (reason.indexOf(46) != -1) {
            reason = "reason not available";
        }
        this.sendCallHomeonLinkDown(sw, ifIndex, cause, reason);
        String endDevices = "";
        IslImpl isl = sw.getFabric().findIsl(sw, ifIndex);
        if (isl == null && (list = sw.getFabric().findEndPortsBySwitchIfIndex(sw, ifIndex)) != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                EndPortImpl ep = (EndPortImpl)list.get(i);
                if (!ep.isPresent()) continue;
                endDevices = endDevices + " " + ep.getName();
            }
        }
        String descr = sw.ifIndexToName(ifIndex) + " " + cause;
        Card mycard = InventoryManager.getInstance().findCard(sw.getSwitchPK(), IfIndexUtil.getIfIndexCard(ifIndex));
        if (mycard != null) {
            descr = "EMC callhome delayed linked down event: Port " + sw.ifIndexToName(ifIndex);
            descr = descr + (endDevices.length() == 0 ? "" : "(with end device:" + endDevices + ") ");
            descr = descr + " in '" + mycard.getName() + "' in Slot " + mycard.getSlotId() + " failed: " + reason;
        }
    }

    private void onLinkDownTrap(SwitchImpl sw, int ifIndex, int cause, String reason) {
        FcPortBase fcPort = sw.findPort(ifIndex);
        if (sw.isDelayLinkEnabled() && fcPort != null && (fcPort.getIfOperMode() == 2 || fcPort.getIfOperMode() == 3 || fcPort.getIfOperMode() == 6)) {
            return;
        }
        if (reason.indexOf(46) != -1) {
            reason = "reason not available";
        }
        if (this._portDownReasons != null && this._portDownReasons.contains(cause)) {
            this.sendCallHomeonLinkDown(sw, ifIndex, cause, reason);
        } else {
            this._Logger.info((Object)("linkDown trap notif for fcIfOperStatusCause code: '" + cause + "' and failed resaon: '" + reason + "' is dropped."));
        }
    }

    private void onFRUChange(SwitchImpl sw, int phyIndex, String entPhysicalDescr, String entPhysicalName, boolean isInserted) {
        HwInventoryType ht;
        String sev = SEVERITY_MODULE_INSERTED;
        String symtomCode = SYMPTOM_MODULE_INSERTED;
        String category = CATEGORY_MODULE_INSERTED;
        String devStatus = STATUS_MODULE_INSERTED;
        HwInventoryComponent c = this._im.findHardwareComponent(sw.getSwitchPK(), phyIndex);
        if (c == null) {
            ht = this.getFRUType(entPhysicalDescr.toLowerCase());
            if (ht == null) {
                ht = this.getFRUType(entPhysicalName.toLowerCase());
            }
        } else {
            ht = c.getHardwareType();
        }
        if (ht != null) {
            if (ht == HwInventoryType.POWERSUPPLY) {
                if (isInserted) {
                    sev = SEVERITY_POWER_SUPPLY_INSERTED;
                    symtomCode = SYMPTOM_POWER_SUPPLY_INSERTED;
                    category = CATEGORY_POWER_SUPPLY_INSERTED;
                    devStatus = STATUS_POWER_SUPPLY_INSERTED;
                } else {
                    sev = SEVERITY_REMOVED_POWER_SUPPLY;
                    symtomCode = SYMPTOM_REMOVED_POWER_SUPPLY;
                    category = CATEGORY_REMOVED_POWER_SUPPLY;
                    devStatus = STATUS_REMOVED_POWER_SUPPLY;
                }
            } else if (ht == HwInventoryType.FAN) {
                if (isInserted) {
                    sev = SEVERITY_FAN_INSERTED;
                    symtomCode = SYMPTOM_FAN_INSERTED;
                    category = CATEGORY_FAN_INSERTED;
                    devStatus = STATUS_FAN_INSERTED;
                } else {
                    sev = SEVERITY_FAN_REMOVED;
                    symtomCode = SYMPTOM_FAN_REMOVED;
                    category = CATEGORY_FAN_REMOVED;
                    devStatus = STATUS_FAN_REMOVED;
                }
            } else if (ht == HwInventoryType.MODULE) {
                boolean isSupervisor = false;
                if (c != null) {
                    Card d = this._im.findCard(sw.getSwitchPK(), c.getSlotId());
                    if (d != null && d.hasSup()) {
                        isSupervisor = true;
                    }
                } else if (entPhysicalDescr.toLowerCase().startsWith("supervisor")) {
                    isSupervisor = true;
                }
                if (isInserted) {
                    if (isSupervisor) {
                        sev = SEVERITY_SUP_CARD_INSERTED;
                        symtomCode = SYMPTOM_SUP_CARD_INSERTED;
                        category = CATEGORY_SUP_CARD_INSERTED;
                    } else {
                        sev = SEVERITY_MODULE_INSERTED;
                        symtomCode = SYMPTOM_MODULE_INSERTED;
                        category = CATEGORY_MODULE_INSERTED;
                        devStatus = STATUS_MODULE_INSERTED;
                    }
                }
            } else {
                this._Logger.log((Priority)Level.WARN, (Object)("EMC CH: unknown h/w: " + (Object)((Object)ht)));
            }
        }
        StringBuffer descr = new StringBuffer(entPhysicalDescr);
        descr.append(isInserted ? " inserted into " : " removed from ");
        if (ht != null && ht == HwInventoryType.MODULE) {
            int slot;
            int n = slot = c == null ? phyIndex - sw.getModuleIndexOffset() : c.getSlotId();
            if (slot > 0 && slot <= 24) {
                descr.append("slot " + slot + " on ");
            }
        }
        descr.append("switch " + sw.getName());
        this.fillEvent(sw, sev, symtomCode, category);
        if (c != null) {
            this._switchevent.setSubComponentID(c.getSerialNumber());
        }
        this._switchevent.setSubComponent(entPhysicalDescr);
        this._switchevent.setDescription(descr.toString());
        this._switchevent.setStatus(devStatus);
        if (this.sendCallHome("Online", devStatus)) {
            this.logEvent(sw);
        }
    }

    void onModuleStatusChangeTrap(SwitchImpl sw, int phyIndex, int status, String statusString, long timeStamp) {
        if (status <= 3 || status == 5 || status == 6 || status == 16 || status == 21) {
            return;
        }
        int slot = phyIndex - sw.getModuleIndexOffset();
        if (slot < 1 || slot > 24) {
            slot = phyIndex;
        }
        String sev = "";
        String symtomCode = "";
        String category = "";
        String devStatus = "";
        if (status == 4) {
            sev = SEVERITY_DIAGNOSTIC_FAILURE;
            symtomCode = SYMPTOM_DIAGNOSTIC_FAILURE;
            category = CATEGORY_DIAGNOSTIC_FAILURE;
            devStatus = STATUS_DIAGNOSTIC_FAILURE;
        } else if (status >= 7) {
            sev = SEVERITY_PORT_BLADE_FAILURE;
            symtomCode = SYMPTOM_PORT_BLADE_FAILURE;
            category = CATEGORY_PORT_BLADE_FAILURE;
            devStatus = STATUS_PORT_BLADE_FAILURE;
        }
        this.fillEvent(sw, sev, symtomCode, category);
        String descr = "Module in slot " + slot + ", status " + statusString + ", lastChangeTime: " + SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - timeStamp);
        HwInventoryComponent hic = this._im.findHardwareComponent(sw.getSwitchPK(), slot);
        if (hic != null) {
            this._switchevent.setSubComponent(hic.getName());
            this._switchevent.setSubComponentID(hic.getSerialNumber());
            descr = "Module '" + hic.getName() + "' in slot " + slot + " on Switch '" + sw.getName() + "' status changed to " + statusString + ", lastChangeTime: " + SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - timeStamp);
        }
        this._switchevent.setDescription(descr);
        this._switchevent.setStatus(devStatus);
        if (this.sendCallHome("Online", devStatus)) {
            this.logEvent(sw);
        }
    }

    void onPowerStatusChangeTrap(SwitchImpl sw, int phyIndex, int status, String statusString, String adminString) {
        if (status < 4 || status > 8) {
            return;
        }
        int slot = phyIndex - 21;
        HwInventoryComponent hic = this._im.findHardwareComponent(sw.getSwitchPK(), phyIndex);
        if (hic != null) {
            slot = hic.getSlotId();
        }
        if (slot < 1 || slot > 24) {
            slot = phyIndex;
        }
        String sev = "";
        String symtomCode = "";
        String category = "";
        String devStatus = "";
        if (status == 4) {
            sev = SEVERITY_AC_SOURCE_FAILURE;
            symtomCode = SYMPTOM_AC_SOURCE_FAILURE;
            category = CATEGORY_AC_SOURCE_FAILURE;
            devStatus = STATUS_AC_SOURCE_FAILURE;
        } else if (status == 5 || status == 6 || status == 7 || status == 8) {
            sev = SEVERITY_POWER_SUPPLY_FAILURE;
            symtomCode = SYMPTOM_POWER_SUPPLY_FAILURE;
            category = CATEGORY_POWER_SUPPLY_FAILURE;
            devStatus = STATUS_POWER_SUPPLY_FAILURE;
        }
        this.fillEvent(sw, sev, symtomCode, category);
        String descr = "Module in slot " + slot + ", powerStatus " + statusString + ", adminStatus " + adminString;
        if (hic != null) {
            this._switchevent.setSubComponent(hic.getName());
            this._switchevent.setSubComponentID(hic.getSerialNumber());
            descr = "'" + hic.getName() + "' in Slot " + slot + " on switch '" + sw.getName() + "' status changed to " + statusString + ", adminStatus " + adminString;
        }
        this._switchevent.setStatus(devStatus);
        this._switchevent.setDescription(descr);
        if (this.sendCallHome("Online", devStatus)) {
            this.logEvent(sw);
        }
    }

    void onPowerSupplyChange(SwitchImpl sw, VarBindList vbl) {
        String sev = SEVERITY_POWER_SUPPLY_CHANGE;
        String symtomCode = SYMPTOM_POWER_SUPPLY_CHANGE;
        String category = CATEGORY_POWER_SUPPLY_CHANGE;
        String devStatus = STATUS_POWER_SUPPLY_CHANGE;
        this.fillEvent(sw, sev, symtomCode, category);
        String descr = "The power supply output capacity of '" + vbl.stringValue(2) + " " + vbl.stringValue(3) + "on switch '" + sw.getName() + "' has changed to " + vbl.longValue(4) + " A";
        this._switchevent.setStatus(devStatus);
        this._switchevent.setDescription(descr);
        this.sendCallHome("Online", devStatus);
    }

    void onFanStatusChangeTrap(SwitchImpl sw, int phyIndex, int status, String statusDescr) {
        boolean isInserted = status == 2;
        int slot = phyIndex - 534;
        HwInventoryComponent hic = this._im.findHardwareComponent(sw.getSwitchPK(), phyIndex);
        if (hic != null) {
            slot = hic.getSlotId();
        }
        if (slot < 1 || slot > 3) {
            slot = phyIndex;
        }
        String sev = isInserted ? SEVERITY_FAN_INSERTED : SEVERITY_FAN_FAILURE;
        String symtomCode = isInserted ? SYMPTOM_FAN_INSERTED : SYMPTOM_FAN_FAILURE;
        String category = isInserted ? CATEGORY_FAN_INSERTED : CATEGORY_FAN_FAILURE;
        this.fillEvent(sw, sev, symtomCode, category);
        String descr = "Fan tray " + slot + ", status: " + statusDescr;
        if (hic != null) {
            this._switchevent.setSubComponent(hic.getName());
            this._switchevent.setSubComponentID(hic.getSerialNumber());
            descr = "'" + hic.getName() + "' in slot " + slot + " on switch '" + sw.getName() + "' has status " + statusDescr;
        }
        this._switchevent.setDescription(descr);
        this._switchevent.setStatus(isInserted ? STATUS_FAN_INSERTED : STATUS_FAN_FAILURE);
        if (this.sendCallHome("Online", this._switchevent.getStatus())) {
            this.logEvent(sw);
        }
    }

    private HwInventoryType getFRUType(String entPhysicalDescr) {
        if (entPhysicalDescr.startsWith("fan")) {
            return HwInventoryType.FAN;
        }
        if (entPhysicalDescr.startsWith("powersupply")) {
            return HwInventoryType.POWERSUPPLY;
        }
        if (entPhysicalDescr.startsWith("supervisor")) {
            return HwInventoryType.MODULE;
        }
        if (entPhysicalDescr.indexOf("module") != -1) {
            return HwInventoryType.MODULE;
        }
        if (entPhysicalDescr.indexOf("linecard") != -1) {
            return HwInventoryType.MODULE;
        }
        return null;
    }

    private void fillIdentity(SwitchImpl sw) {
        SwitchBase sb = (SwitchBase)sw.getBaseObject();
        String secSerialNum = "";
        String serialNum = sb.getSerialNumber();
        HwInventoryComponent chassis = this._im.findChassis(sw.getSwitchPK());
        try {
            if (chassis.getModelName().contains(MDS_MODEL_9100_PREFIX) && (chassis.getModelName().contains(MDS_MODEL_9120) || chassis.getModelName().contains(MDS_MODEL_9140) || chassis.getModelName().contains(MDS_MODEL_9124) || chassis.getModelName().contains(MDS_MODEL_9134))) {
                secSerialNum = chassis.getSecSerialNumber();
                String string = serialNum = secSerialNum == null || secSerialNum.length() == 0 || secSerialNum.equals("n/a") ? serialNum : secSerialNum;
            }
            if (serialNum == null || serialNum.length() == 0 || serialNum.equals("n/a")) {
                serialNum = "noserialnum";
            }
            this._identity = new EmcIdentity(serialNum, sb.getWwn() == null ? "" : sb.getWwn().toString(), serialNum);
            this._identity.setSiteName(System.getProperty(PROP_LOCATION));
            this._identity.setDeviceType("Cisco Switch");
            this._identity.setModel(chassis.getModelName());
            this._identity.setPlatform(sb.getSysDescr());
            this._identity.setOsVer(chassis.getSoftwareRevision());
        }
        catch (Exception e) {
            // empty catch block
        }
        this._identity.setComment("EMC CallHome message");
        this._identity.setOs(sb.getSysDescr());
    }

    private void fillConnection(SwitchImpl sw) {
        this._connection = new EmcConnection(sw.getIpAddress(), sw.getName());
    }

    private void fillEventObj(SwitchImpl sw, String sev, String symtomCode, String category) {
        this._switchevent = new EmcSwitchEvent(symtomCode, category, sev);
        HwInventoryComponent chassis = this._im.findChassis(sw.getSwitchPK());
        if (chassis != null) {
            try {
                this._switchevent.setComponent(chassis.getName());
                this._switchevent.setComponentID(chassis.getSerialNumber());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._switchevent.setFirstTime(_TimeFormat.format(new Date(System.currentTimeMillis())));
        this._switchevent.setLastTime(_TimeFormat.format(new Date(System.currentTimeMillis())));
        this._switchevent.setCount("1");
        this._switchevent.setEventData(this._eventData);
    }

    void fillEvent(SwitchImpl sw, String sev, String symtomCode, String category) {
        this.fillIdentity(sw);
        this.fillConnection(sw);
        this.fillEventObj(sw, sev, symtomCode, category);
    }

    private boolean sendCallHome(String st1, String st2) {
        this._toEmail = System.getProperty(PROP_TOEMAIL);
        if (this._toEmail == null || this._toEmail.trim().length() == 0) {
            this._Logger.log((Priority)Level.INFO, (Object)("EMC CH: No recipient address is set, email won't send out for " + this._switchevent.getDescription()));
            return false;
        }
        this._Logger.log((Priority)Level.INFO, (Object)("EMC CH: send " + this._switchevent.getDescription()));
        this._Logger.log((Priority)Level.TRACE, (Object)("EMC CH: Connection " + this._connection.toXML()));
        this._Logger.log((Priority)Level.TRACE, (Object)("EMC CH: SwitchEvent " + this._switchevent.toXML()));
        EmcCallHome message = new EmcCallHome(st1, st2, this._identity, this._connection, this._switchevent, System.getProperty(PROP_FROMEMAIL), this._toEmail, System.getProperty(PROP_SMTPHOST), this._xmlFilePath);
        message.createXMLFile();
        return message.sendMail(this._optionalLogger);
    }

    private void loadEmcConfiguration() {
        String emcfile = System.getProperty("server.callhome.path.properties", "") + File.separator + "emccallhome.properties";
        boolean callhomeEnable = Boolean.getBoolean(PROP_CALL_HOME_ENABLE);
        if (callhomeEnable) {
            Properties prop = new Properties();
            try {
                File file = new File(emcfile);
                if (!file.exists()) {
                    emcfile = ClientCache.getConfDir() + "emccallhome.properties";
                }
                GenUtil.loadConfiguration(emcfile, prop);
                System.getProperties().putAll((Map<?, ?>)prop);
                this._Logger.info((Object)("EMC callhome properties file loaded " + emcfile));
            }
            catch (IOException ex) {
                this._Logger.warn((Object)("EMC callhome properties file loading error " + ex));
            }
        }
    }

    public void setOptionalLogger(Logger log) {
        this._optionalLogger = log;
    }

    void logEvent(SwitchImpl sw) {
        String descr = "EMC Call Home Message Sent; check log for details";
        LogEvent e = new LogEvent((Object)sw.getFabric().getPK(), LogEventType.OTHER, Severity.INFO, "Trap " + sw.getName(), descr, sw.getFabric().getDBID(), sw.getDBID(), sw.getSwitchPK());
        this._eventLogger.dispatchEvent(e);
        if (SnmpTrapSession.isTrace()) {
            System.out.println("TrapHandler : " + e);
        }
    }

    public static void main(String[] strArgs) {
        EmcCallHomeHandler inst = EmcCallHomeHandler.getInstance();
    }

    static {
        _TimeFormat = new SimpleDateFormat();
        _AffectCallHomeTrapOids = new int[][]{MibNode.get("connUnitStatusChange").getOid(), MibNode.get("cefcModuleStatusChange").getOid(), MibNode.get("cefcPowerStatusChange").getOid(), MibNode.get("cefcFRURemoved").getOid(), MibNode.get("cefcFanTrayStatusChange").getOid(), MibNode.get("linkDown").getOid(), MibNode.get("cefcFRUInserted").getOid(), MibNode.get("entSensorThresholdNotification").getOid(), MibNode.get("cieDelayedLinkUpDownNotif").getOid(), MibNode.get("cefcPowerSupplyOutputChange").getOid()};
        SYMPTOM_UNKNOWN = System.getProperty("emc.callhome.SYMPTOM_UNKNOWN", "0x00000001");
        SYMPTOM_SWITCH_FAILURE = System.getProperty("emc.callhome.SYMPTOM_SWITCH_FAILURE", "0x00000003");
        SYMPTOM_DIAGNOSTIC_FAILURE = System.getProperty("emc.callhome.SYMPTOM_DIAGNOSTIC_FAILURE", "0x00000004");
        SYMPTOM_POWER_SUPPLY_FAILURE = System.getProperty("emc.callhome.SYMPTOM_POWER_SUPPLY_FAILURE", "0x00000005");
        SYMPTOM_AC_SOURCE_FAILURE = System.getProperty("emc.callhome.SYMPTOM_AC_SOURCE_FAILURE", "0x00000006");
        SYMPTOM_REMOVED_POWER_SUPPLY = System.getProperty("emc.callhome.SYMPTOM_REMOVED_POWER_SUPPLY", "0x00000007");
        SYMPTOM_FAN_REMOVED = System.getProperty("emc.callhome.SYMPTOM_FAN_REMOVED", "0x00000008");
        SYMPTOM_OVER_TEMPERATURE = System.getProperty("emc.callhome.SYMPTOM_OVER_TEMPERATURE", "0x00000009");
        SYMPTOM_FAN_FAILURE = System.getProperty("emc.callhome.SYMPTOM_FAN_FAILURE", "0x0000000A");
        SYMPTOM_PORT_FAILURE = System.getProperty("emc.callhome.SYMPTOM_PORT_FAILURE", "0x0000000B");
        SYMPTOM_PORT_BLADE_FAILURE = System.getProperty("emc.callhome.SYMPTOM_PORT_BLADE_FAILURE", "0x0000000C");
        SYMPTOM_SUP_FAILURE = System.getProperty("emc.callhome.SYMPTOM_SUP_FAILURE", "0x0000000D");
        SYMPTOM_CROSS_BAR_FAILURE = System.getProperty("emc.callhome.SYMPTOM_CROSS_BAR_FAILURE", "0x0000000E");
        SYMPTOM_PORT_CARD_INSERTED = System.getProperty("emc.callhome.SYMPTOM_PORT_CARD_INSERTED", "0x0000000F");
        SYMPTOM_SUP_CARD_INSERTED = System.getProperty("emc.callhome.SYMPTOM_SUP_CARD_INSERTED", "0x00000010");
        SYMPTOM_POWER_SUPPLY_INSERTED = System.getProperty("emc.callhome.SYMPTOM_POWER_SUPPLY_INSERTED", "0x00000011");
        SYMPTOM_FAN_INSERTED = System.getProperty("emc.callhome.SYMPTOM_FAN_INSERTED", "0x00000012");
        SYMPTOM_TEMPERATURE_THRESHOLD_REACHED = System.getProperty("emc.callhome.SYMPTOM_TEMPERATURE_THRESHOLD_REACHED", "0x00000013");
        SYMPTOM_MODULE_INSERTED = System.getProperty("emc.callhome.SYMPTOM_MODULE_INSERTED", "0x00000014");
        SYMPTOM_POWER_SUPPLY_CHANGE = System.getProperty("emc.callhome.SYMPTOM_POWER_SUPPLY_CHANGE", "0x00000014");
        CATEGORY_UNKNOWN = System.getProperty("emc.callhome.CATEGORY_UNKNOWN", "Unknown");
        CATEGORY_SWITCH_FAILURE = System.getProperty("emc.callhome.CATEGORY_SWITCH_FAILURE", "Status");
        CATEGORY_DIAGNOSTIC_FAILURE = System.getProperty("emc.callhome.CATEGORY_DIAGNOSTIC_FAILURE", "Configuration");
        CATEGORY_POWER_SUPPLY_FAILURE = System.getProperty("emc.callhome.CATEGORY_POWER_SUPPLY_FAILURE", "Configuration");
        CATEGORY_AC_SOURCE_FAILURE = System.getProperty("emc.callhome.CATEGORY_AC_SOURCE_FAILURE", "Status");
        CATEGORY_REMOVED_POWER_SUPPLY = System.getProperty("emc.callhome.CATEGORY_REMOVED_POWER_SUPPLY", "Status");
        CATEGORY_FAN_REMOVED = System.getProperty("emc.callhome.CATEGORY_FAN_REMOVED", "Configuration");
        CATEGORY_OVER_TEMPERATURE = System.getProperty("emc.callhome.CATEGORY_OVER_TEMPERATURE", "Status");
        CATEGORY_FAN_FAILURE = System.getProperty("emc.callhome.CATEGORY_FAN_FAILURE", "Status");
        CATEGORY_PORT_FAILURE = System.getProperty("emc.callhome.CATEGORY_PORT_FAILURE", "Status");
        CATEGORY_PORT_BLADE_FAILURE = System.getProperty("emc.callhome.CATEGORY_PORT_BLADE_FAILURE", "Status");
        CATEGORY_SUP_FAILURE = System.getProperty("emc.callhome.CATEGORY_SUP_FAILURE", "Status");
        CATEGORY_CROSS_BAR_FAILURE = System.getProperty("emc.callhome.CATEGORY_CROSS_BAR_FAILURE", "Status");
        CATEGORY_PORT_CARD_INSERTED = System.getProperty("emc.callhome.CATEGORY_PORT_CARD_INSERTED", "Configuration");
        CATEGORY_SUP_CARD_INSERTED = System.getProperty("emc.callhome.CATEGORY_SUP_CARD_INSERTED", "Configuration");
        CATEGORY_POWER_SUPPLY_INSERTED = System.getProperty("emc.callhome.CATEGORY_POWER_SUPPLY_INSERTED", "Configuration");
        CATEGORY_FAN_INSERTED = System.getProperty("emc.callhome.CATEGORY_FAN_INSERTED", "Configuration");
        CATEGORY_TEMPERATURE_THRESHOLD_REACHED = System.getProperty("emc.callhome.CATEGORY_TEMPERATURE_THRESHOLD_REACHED", "Status");
        CATEGORY_MODULE_INSERTED = System.getProperty("emc.callhome.CATEGORY_MODULE_INSERTED", "Configuration");
        CATEGORY_POWER_SUPPLY_CHANGE = System.getProperty("emc.callhome.CATEGORY_POWER_SUPPLY_CHANGE", "Status");
        SEVERITY_UNKNOWN = System.getProperty("emc.callhome.SEVERITY_UNKNOWN", "Unknown");
        SEVERITY_SWITCH_FAILURE = System.getProperty("emc.callhome.SEVERITY_SWITCH_FAILURE", "Critical");
        SEVERITY_DIAGNOSTIC_FAILURE = System.getProperty("emc.callhome.SEVERITY_DIAGNOSTIC_FAILURE", "Warning");
        SEVERITY_POWER_SUPPLY_FAILURE = System.getProperty("emc.callhome.SEVERITY_POWER_SUPPLY_FAILURE", "Error");
        SEVERITY_AC_SOURCE_FAILURE = System.getProperty("emc.callhome.SEVERITY_AC_SOURCE_FAILURE", "Error");
        SEVERITY_REMOVED_POWER_SUPPLY = System.getProperty("emc.callhome.SEVERITY_REMOVED_POWER_SUPPLY", "Error");
        SEVERITY_FAN_REMOVED = System.getProperty("emc.callhome.SEVERITY_FAN_REMOVED", "Error");
        SEVERITY_OVER_TEMPERATURE = System.getProperty("emc.callhome.SEVERITY_OVER_TEMPERATURE", "Warning");
        SEVERITY_FAN_FAILURE = System.getProperty("emc.callhome.SEVERITY_FAN_FAILURE", "Error");
        SEVERITY_PORT_FAILURE = System.getProperty("emc.callhome.SEVERITY_PORT_FAILURE", "Warning");
        SEVERITY_PORT_BLADE_FAILURE = System.getProperty("emc.callhome.SEVERITY_PORT_BLADE_FAILURE", "Error");
        SEVERITY_SUP_FAILURE = System.getProperty("emc.callhome.SEVERITY_SUP_FAILURE", "Error");
        SEVERITY_CROSS_BAR_FAILURE = System.getProperty("emc.callhome.SEVERITY_CROSS_BAR_FAILURE", "Emergency");
        SEVERITY_PORT_CARD_INSERTED = System.getProperty("emc.callhome.SEVERITY_PORT_CARD_INSERTED", "Info");
        SEVERITY_SUP_CARD_INSERTED = System.getProperty("emc.callhome.SEVERITY_SUP_CARD_INSERTED", "Info");
        SEVERITY_POWER_SUPPLY_INSERTED = System.getProperty("emc.callhome.SEVERITY_POWER_SUPPLY_INSERTED", "Info");
        SEVERITY_FAN_INSERTED = System.getProperty("emc.callhome.SEVERITY_FAN_INSERTED", "Info");
        SEVERITY_TEMPERATURE_THRESHOLD_REACHED = System.getProperty("emc.callhome.SEVERITY_TEMPERATURE_THRESHOLD_REACHED", "Warning");
        SEVERITY_MODULE_INSERTED = System.getProperty("emc.callhome.SEVERITY_MODULE_INSERTED", "Info");
        SEVERITY_POWER_SUPPLY_CHANGE = System.getProperty("emc.callhome.SEVERITY_POWER_SUPPLY_CHANGE", "Warning");
        STATUS_UNKNOWN = System.getProperty("emc.callhome.STATUS_UNKNOWN", "Unknown");
        STATUS_SWITCH_FAILURE = System.getProperty("emc.callhome.STATUS_SWITCH_FAILURE", "Failed");
        STATUS_DIAGNOSTIC_FAILURE = System.getProperty("emc.callhome.STATUS_DIAGNOSTIC_FAILURE", "Warning");
        STATUS_POWER_SUPPLY_FAILURE = System.getProperty("emc.callhome.STATUS_POWER_SUPPLY_FAILURE", "Warning");
        STATUS_AC_SOURCE_FAILURE = System.getProperty("emc.callhome.STATUS_AC_SOURCE_FAILURE", "Failed");
        STATUS_REMOVED_POWER_SUPPLY = System.getProperty("emc.callhome.STATUS_REMOVED_POWER_SUPPLY", "Warning");
        STATUS_FAN_REMOVED = System.getProperty("emc.callhome.STATUS_FAN_REMOVED", "Warning");
        STATUS_OVER_TEMPERATURE = System.getProperty("emc.callhome.STATUS_OVER_TEMPERATURE", "Warning");
        STATUS_FAN_FAILURE = System.getProperty("emc.callhome.STATUS_FAN_FAILURE", "Failed");
        STATUS_PORT_FAILURE = System.getProperty("emc.callhome.STATUS_PORT_FAILURE", "Failed");
        STATUS_PORT_BLADE_FAILURE = System.getProperty("emc.callhome.STATUS_PORT_BLADE_FAILURE", "Failed");
        STATUS_SUP_FAILURE = System.getProperty("emc.callhome.STATUS_SUP_FAILURE", "Failed");
        STATUS_CROSS_BAR_FAILURE = System.getProperty("emc.callhome.STATUS_CROSS_BAR_FAILURE", "Failed");
        STATUS_PORT_CARD_INSERTED = System.getProperty("emc.callhome.STATUS_PORT_CARD_INSERTED", "Warning");
        STATUS_SUP_CARD_INSERTED = System.getProperty("emc.callhome.STATUS_SUP_CARD_INSERTED", "Warning");
        STATUS_POWER_SUPPLY_INSERTED = System.getProperty("emc.callhome.STATUS_POWER_SUPPLY_INSERTED", "Warning");
        STATUS_FAN_INSERTED = System.getProperty("emc.callhome.STATUS_FAN_INSERTED", "Warning");
        STATUS_TEMPERATURE_THRESHOLD_REACHED = System.getProperty("emc.callhome.STATUS_TEMPERATURE_THRESHOLD_REACHED", "Failed");
        STATUS_MODULE_INSERTED = System.getProperty("emc.callhome.STATUS_MODULE_INSERTED", "Warning");
        STATUS_POWER_SUPPLY_CHANGE = System.getProperty("emc.callhome.STATUS_POWER_SUPPLY_CHANGE", "Warning");
    }
}

