/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.install.DCNMInfo;
import com.cisco.dcbu.jaxws.san.wo.EndPortDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameDO;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.proxy.ProxyTransportOptions;
import com.cisco.dcbu.lib.snmp.proxy.SnmpProxyService;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UserEntry;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.FMStandalone;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.LicenseFileUsage;
import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.common.dto.PossibleFCFlowTrafficDto;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FileBase;
import com.cisco.dcbu.sm.common.model.FileWrapper;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.NameValuePair;
import com.cisco.dcbu.sm.common.model.ServerReference;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ClusterProcessRif;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.server.ServerMonitor;
import com.cisco.dcbu.sm.server.bean.SessionHelper;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.facade.IscImpl;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.facade.SessionEventListenerIf;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.hostredundancy.HostRedundancyCheck;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.PmPolicyImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmMetaDataUtil;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import com.cisco.dcbu.sm.server.security.lica.FMLICPrincipal;
import com.cisco.dcbu.sm.server.security.lica.LICAuthenticator;
import com.cisco.dcbu.sm.server.security.lica.LICLoginCallbackHandler;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.xml.sax.SAXException;

public class FMServerImpl
implements FMServerRif {
    private static final long serialVersionUID = 1L;
    public static Logger _Logger = LogManager.getLogger((String)"fms.FMServerRif");
    public static String _reportDir = ClientCache.getReportsDir();
    protected static FMServerImpl _Instance;
    protected transient FMSessionManager _sessionManager = FMSessionManager.getInstance();
    private transient IscImpl _isc = null;

    public static FMServerImpl getInstance() {
        if (_Instance == null) {
            try {
                _Instance = new FMServerImpl();
            }
            catch (RemoteException re) {
                System.err.println("FMServerImpl.getInstance() error: " + re);
            }
        }
        return _Instance;
    }

    protected FMServerImpl(boolean sessionB) throws RemoteException {
    }

    private FMServerImpl() throws RemoteException {
    }

    @Override
    public void addListener(SessionEventListenerIf listener) {
        this._sessionManager.addListener(listener);
    }

    protected void notifyListeners(SessionRif session) {
        this._sessionManager.notifyListeners(session);
    }

    void checkSessionLimit() throws RemoteException {
        this._sessionManager.checkSessionLimit();
    }

    SessionRif createSession(FMUser user) throws RemoteException {
        return this.createSession(user, null);
    }

    SessionRif createSession(FMUser user, String cHost) throws RemoteException {
        try {
            String clientHost = cHost == null ? this.getClientHost() : cHost;
            return this._sessionManager.createSession(user, clientHost);
        }
        catch (Exception ex) {
            throw new RemoteException("The fabric may be loading or discovering. Please try again.");
        }
    }

    @Override
    public String checkCompatibility(String clientVersion) throws RemoteException {
        return "6.3(1)".equals(clientVersion) ? null : "6.3(1)";
    }

    @Override
    public String passphraseLogin(String passphrase, String cHost) throws RemoteException {
        if (passphrase == null) {
            throw new RemoteException("Token string cannot be empty");
        }
        LoginContext lc = null;
        try {
            String configFile = System.getProperty("java.security.auth.login.config");
            System.err.println("configFile : " + configFile);
            lc = new LoginContext("LICLogin", new LICLoginCallbackHandler(passphrase));
            lc.login();
        }
        catch (LoginException e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        Set<FMLICPrincipal> pSet = lc.getSubject().getPrincipals(FMLICPrincipal.class);
        if (pSet.isEmpty()) {
            throw new RuntimeException("No principals can be verified.");
        }
        FMUser user = null;
        FMLICPrincipal principal = pSet.iterator().next();
        if (principal != null) {
            user = principal.getUser();
            System.out.println("User: " + principal.getUser().getUserName());
        }
        if (user == null) {
            throw new RemoteException("Invalid/expired token");
        }
        try {
            String client = cHost == null ? this.getClientHost() : cHost;
            SessionRif session = this._sessionManager.createSession(user, cHost);
            return session.getLoginSessionId();
        }
        catch (Exception ex) {
            throw new RemoteException("The fabric may be loading or discovering. Please try again.");
        }
    }

    @Override
    public String getLICPassphrase(String user) throws RemoteException {
        return LICAuthenticator.getInstance().getPassphrase(user);
    }

    @Override
    public String login(String userName, String authPassword) throws RemoteException {
        return this.login(userName, authPassword, null);
    }

    @Override
    public String login(String userName, String authPassword, String cHost) throws RemoteException {
        if (userName == null || userName.length() == 0 || authPassword == null || authPassword.length() == 0) {
            throw new RemoteException("user name or password is empty");
        }
        FMUser fmUser = null;
        String client = null;
        client = cHost == null ? this.getClientHost() : cHost;
        try {
            fmUser = SecurityManager.getInstance().authenticate(userName, authPassword);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (fmUser == null) {
            SessionImpl._Logger.warn((Object)(userName + " login from " + client + " failed: "));
            throw new RemoteException(userName + " login from " + client + " failed ");
        }
        SessionRif session = this.createSession(fmUser, cHost);
        return session.getLoginSessionId();
    }

    @Override
    public String getLoginSessionId(String userName, String authPassword, String cHost) throws RemoteException {
        if (userName == null || userName.length() == 0 || authPassword == null || authPassword.length() == 0) {
            throw new RemoteException("user name or password is empty");
        }
        FMUser fmUser = null;
        String client = null;
        client = cHost == null ? this.getClientHost() : cHost;
        try {
            fmUser = SecurityManager.getInstance().authenticateUser(userName, authPassword);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (fmUser == null) {
            SessionImpl._Logger.warn((Object)(userName + " login from " + client + " failed: "));
            throw new RemoteException(userName + " login from " + client + " failed ");
        }
        SessionRif session = this.createSession(fmUser, cHost);
        return session.getLoginSessionId();
    }

    @Override
    public SessionRif standAloneLogin(String userName, String authPassword) throws RemoteException {
        if (userName == null || userName.length() == 0 || authPassword == null || authPassword.length() == 0) {
            throw new RemoteException("user name or password is empty");
        }
        FMUser fmUser = null;
        String client = null;
        client = this.getClientHost();
        try {
            fmUser = SecurityManager.getInstance().authenticate(userName, authPassword);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (fmUser == null) {
            SessionImpl._Logger.warn((Object)(userName + " login from " + client + " failed: "));
            throw new RemoteException(userName + " login from " + client + " failed ");
        }
        SessionRif session = this.createSession(fmUser);
        return session;
    }

    @Override
    public String whereami() throws RemoteException {
        return this.getClientHost();
    }

    @Override
    public String whereami(int sessionId) throws RemoteException {
        SessionRif sif = this._sessionManager.findSession(sessionId);
        if (sif == null) {
            throw new RemoteException("Can't find the sessionID");
        }
        sif.updateAccessTime();
        return this.getClientHost();
    }

    @Override
    public InetSocketAddress getProxyAddress() throws RemoteException {
        InetSocketAddress addr = null;
        try {
            SnmpProxyService proxy = (SnmpProxyService)ServiceConfig.findService((String)"SNMP Proxy");
            if (proxy != null) {
                addr = proxy.getSocketAddress();
            }
            if (addr == null && SanManager.getSnmpSession().getTransportProvider().equals("proxy")) {
                addr = ((ProxyTransportOptions)SanManager.getSnmpSession().getTransportOptions()).getProxySocketAddress();
            }
            return addr;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public IscRif getIsc(String token) throws RemoteException {
        try {
            if (NetUtil.isLocalHost(this.getClientHost())) {
                String magicKey = StringEncrypter.decryptString("DESede", token);
                Date d = new Date();
                for (int i = 0; i < 3; ++i) {
                    if (d.toString().equals(magicKey)) {
                        if (this._isc == null) {
                            this._isc = IscImpl.getInstance();
                        }
                        return this._isc;
                    }
                    d.setTime(d.getTime() - 1000L);
                }
            }
            throw new RemoteException("Permission denied.");
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<SessionRif> getSessions() {
        return this._sessionManager.getSessions();
    }

    public int getNumSessions() {
        return this._sessionManager.getNumSessions();
    }

    @Override
    public SessionRif findSession(int sessionId) throws RemoteException {
        return this._sessionManager.findSession(sessionId);
    }

    @Override
    public void killSession(int sessionId, String ssotoken) throws RemoteException {
        SessionRif s = FMSessionManager.getInstance().findSession(sessionId);
        if (s != null) {
            s.logoff();
        }
    }

    @Override
    public void removeSessionByID(int sessionId) throws RemoteException {
        SessionRif session = this._sessionManager.findSession(sessionId);
        if (session == null) {
            SessionImpl._Logger.debug((Object)("Can not find the session by session id: " + sessionId));
            return;
        }
        this._sessionManager.removeSession(session);
    }

    @Override
    public void logOffSessionByID(int sessionId) throws RemoteException {
        SessionRif session = this._sessionManager.findSession(sessionId);
        if (session == null) {
            SessionImpl._Logger.debug((Object)("Can not find the session by session id: " + sessionId));
            return;
        }
        session.logoff();
    }

    @Override
    public boolean isOpenedByOtherSession(FabricPK pkey, SessionRif session) throws RemoteException {
        return this._sessionManager.isOpenedByOtherSession(pkey, session);
    }

    public boolean isLogonUser(FMUser user) throws RemoteException {
        return this._sessionManager.isLogonUser(user);
    }

    public SessionEventListenerIf[] getListeners() {
        return this._sessionManager.getListeners();
    }

    public String getClientHost() {
        return "localhost";
    }

    @Override
    public List<String> getServerNodes() throws RemoteException {
        return ServerMonitor.getInstance().getAllServerNodes();
    }

    @Override
    public FabricPK[] getFabrics() throws RemoteException {
        try {
            List<FabricPK> pkList = GlobalFabricManager.getInstance().getAllFabricPKs();
            FabricPK[] pkArray = pkList.toArray(new FabricPK[0]);
            return pkArray;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public FabricBase getFabricByKey(FabricPK key) throws RemoteException {
        try {
            if (key == null) {
                throw new RemoteException("Invalid fabric key:" + key);
            }
            FabricImpl fab = SanManager.getInstance().findFabric(key);
            if (fab == null) {
                return null;
            }
            FabricBase base = fab.getFabricBase(new short[0]);
            return base;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<String> getActiveServerNodes() throws RemoteException {
        return ServerMonitor.getInstance().getActiveServerNodes();
    }

    @Override
    public int getServerId(InetAddress addr) throws RemoteException {
        if (addr == null) {
            throw new RemoteException("server addr doesn't exist");
        }
        try {
            return ClusterMapping.getInstance().qSIdFromIP(addr);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getServerForFabric(FabricPK fabricpk) throws RemoteException {
        String ret = null;
        if (fabricpk == null) {
            throw new RemoteException("fabric PK doesn't exist");
        }
        try {
            ret = ClusterMapping.getInstance().qIPStrfromFID(fabricpk.get_fid());
            return ret;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getServerForFabricDBID(long fabricDbId) throws RemoteException {
        String ret = null;
        try {
            ret = ClusterMapping.getInstance().qIPStrfromFDBID(fabricDbId);
            return ret;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getServerForSessionID(int sessionId) throws RemoteException {
        try {
            return FMSessionManager.getInstance().getServerIP(sessionId);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public int getCurrentServerId() throws RemoteException {
        return ClusterSequence.getSequence().getServerId();
    }

    @Override
    public String getCurrentServerIP() throws Exception {
        int id = ClusterSequence.getSequence().getServerId();
        InetAddress adr = ClusterMapping.getInstance().qIPFromSId(id);
        return adr.getHostAddress();
    }

    public InetAddress getCurrentServerInetAddr() {
        int id = ClusterSequence.getSequence().getServerId();
        InetAddress adr = null;
        try {
            adr = ClusterMapping.getInstance().qIPFromSId(id);
        }
        catch (Exception e) {
            _Logger.debug((Object)e.getMessage());
        }
        return adr;
    }

    @Override
    public String getIPForServerID(int serverId) throws Exception {
        InetAddress adr = ClusterMapping.getInstance().qIPFromSId(serverId);
        return adr.getHostAddress();
    }

    @Override
    public void moveLan(LanPK lanpk, boolean remove, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        _Logger.info((Object)("FMServerImpl moveLan(), lanpk/remove is " + lanpk + "/" + remove));
        try {
            if (remove) {
                DCManager.getInstance().unhostLan(lanpk);
            } else {
                List<CdpSeedBase> cdpSeeds = GlobalDCManager.getInstance().getCdpSeedsByLanPK(lanpk);
                if (cdpSeeds == null) {
                    return;
                }
                for (CdpSeedBase cdpSeed : cdpSeeds) {
                    DCManager.getInstance().hostTask(lanpk, cdpSeed.getTaskKey());
                }
                DCManager.getInstance().rediscoverLanforTaskMove();
                DCManager.getInstance().unhostLan(lanpk);
            }
        }
        catch (Exception e) {
            throw new RemoteException("Can not move lan: " + e.getMessage());
        }
    }

    @Override
    public void moveFabric(FabricPK fabricpk, boolean remove, String ssoToken) throws RemoteException {
        this.moveFabric(fabricpk, remove, ssoToken, false);
    }

    @Override
    public void moveFabric(FabricPK fabricpk, boolean remove, String ssoToken, boolean isSnmpUser) throws RemoteException {
        _Logger.info((Object)("FMServerImpl moveFabric(), fabricpk/remove is " + fabricpk + "/" + remove));
        if (fabricpk == null) {
            throw new RemoteException("fabric PK doesn't exist");
        }
        this.assertToken(ssoToken);
        long fabricId = -1L;
        try {
            fabricId = FabricImpl.findDbIdByFPK(fabricpk.get_fid());
            if (PMImpl.getInstance().isFabricInCollection(fabricId)) {
                _Logger.warn((Object)("FMServerImpl moveFabric(), Fabric with DB id: " + fabricId + " is in pm collection and can not be moved"));
                throw new RemoteException("The Fabric with fabric DB id: " + fabricId + " is in pm collection and can not be moved");
            }
        }
        catch (SQLException e1) {
            throw new RemoteException(e1.getMessage());
        }
        int serverId = this.getCurrentServerId();
        try {
            if (remove) {
                SanManager.getInstance().closePersistedFabric(fabricpk, true, true);
                _Logger.info((Object)("FMServerImpl moveFabric(), DONE unhosting fabric " + fabricpk + ", dbId = " + fabricId));
            } else {
                FabricImpl fabric = SanManager.getInstance().findFabric(fabricpk);
                if (fabric != null) {
                    throw new RemoteException("the fabric already exists on the server");
                }
                SnmpUser snmpUser = GlobalFabricManager.getInstance().getUserByFabricPK(fabricpk);
                InetAddress ipAddr = SwitchImpl.findSwitchAddrinDB(FabricImpl.findSeedSwitchIdByPk(fabricpk));
                if (ipAddr == null) {
                    throw new RemoteException("can not find seed switch in db for seed switch:" + ipAddr);
                }
                ClusterMapping.getInstance().persistLOGIC(serverId, fabricpk.get_fid());
                SanManager.getInstance().manageFabric(fabricpk, ipAddr, snmpUser);
                boolean pmcollect = PmMetaDataUtil.isFabricInPmCollection(fabricId);
                if (pmcollect) {
                    _Logger.info((Object)"FMServerImpl moveFabric(), restartPM ");
                    PMImpl pm = PMImpl.getInstance();
                    pm.restart();
                }
                _Logger.info((Object)("FMServerImpl moveFabric(), DONE hosting fabric " + fabricpk + ", dbId = " + fabricId));
            }
        }
        catch (Exception e) {
            throw new RemoteException("Can not move fabric: " + e.getMessage());
        }
    }

    @Override
    public void unmanageFabric(FabricPK fabricPK, String ssoToken) throws RemoteException {
        if (fabricPK == null) {
            throw new RemoteException("fabric PK doesn't exist");
        }
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(fabricPK);
            if (remoteServer == null) {
                if (PMImpl.getInstance().isRunning() && this.isFabricInPmCollection(fabricPK)) {
                    throw new RemoteException("PM is collecting stats on " + fabricPK + ", please stop PM or remove this fabric from PM collection.");
                }
                SanManager.getInstance().unmanageFabric(fabricPK);
            } else {
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.unmanageFabric(fabricPK, newSsoToken);
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getFabricStatus(FabricPK fabricPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (fabricPK == null) {
            throw new RemoteException("fabric PK doesn't exist");
        }
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(fabricPK);
            if (remoteServer == null) {
                FabricImpl fimpl = SanManager.getInstance().findFabric(fabricPK);
                if (fimpl == null) {
                    throw new RemoteException("Can not find fabric for: " + fabricPK);
                }
                return fimpl.getFarbicStatus();
            }
            String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
            return remoteServer.getFabricStatus(fabricPK, newSsoToken);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void validateCdpSeed(InetAddress seedIp, SnmpUserOpt snmpUser, int maxHop, String ipRange, String subnet, String mask, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (seedIp == null) {
            throw new RemoteException("Invalid seed ip:" + seedIp);
        }
        if (snmpUser == null) {
            throw new RemoteException("Invalid SNMP credential");
        }
        try {
            SnmpUser credential = SnmpUserOpt.convertToSnmpUser(snmpUser);
            DCManager.getInstance().validateCdpSeed(seedIp, credential);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from validateCdpSeed: " + seedIp), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean setCdpSeed(LanPK lanPK, CdpSeedBase seed, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (seed == null) {
            return false;
        }
        try {
            if (DCManager.getInstance().findLan(lanPK) == null) {
                return false;
            }
            return DCManager.getInstance().setTask(seed, false, true);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from setCdpSeed:" + seed), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public CdpSeedBase findCdpSeedBySwitchIP(InetAddress swIP, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (swIP == null) {
            return null;
        }
        try {
            CdpSeedImpl cdpImpl = DCManager.getInstance().findTaskBySwIp(swIP);
            if (cdpImpl != null) {
                return cdpImpl.getBase();
            }
            return null;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from findCdpSeedBySwitchIP:" + swIP), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean removeCdpSeed(LanPK lanPK, CdpSeedBase task, boolean purge, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (task == null) {
            return false;
        }
        try {
            if (DCManager.getInstance().findTaskByTaskKey(task.getTaskKey()) != null) {
                return DCManager.getInstance().removeTask(task, purge);
            }
            return DCManager.getInstance().purgeTaskFromDB(task.getTaskKey());
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from removeCdpSeed:" + task), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void unmanageCdpSeed(LanPK lanPK, CdpSeedBase task, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            if (DCManager.getInstance().findTaskByTaskKey(task.getTaskKey()) != null) {
                DCManager.getInstance().unmanageTask(task);
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from unmanageCdpSeed for :" + task), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void manageCdpSeed(LanPK lanPK, CdpSeedBase task, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            if (DCManager.getInstance().findTaskByTaskKey(task.getTaskKey()) != null) {
                DCManager.getInstance().manageTask(task);
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from manageLan for :" + lanPK), (Throwable)ex);
            throw new RemoteException("Cannot manage the LAN:" + lanPK);
        }
    }

    @Override
    public boolean isLanOpened(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return DCManager.getInstance().isLanOpened(lanPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from isLanOpened:" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean isLanDiscovering(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return DCManager.getInstance().isLanDiscovering(lanPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from isLanDiscovering:" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public LanPK discoverLan(InetAddress seedIp, SnmpUserOpt snmpUserOpt, int maxHop, String ipRange, String subnet, String mask, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (seedIp == null) {
            throw new RemoteException("Invalid seed ip:" + seedIp);
        }
        if (snmpUserOpt == null) {
            throw new RemoteException("Invalid SNMP credential");
        }
        try {
            String dcnmUser = SecurityManager.verifySSoToken(ssoToken).getUsername();
            CdpSeedImpl task = DCManager.getInstance().discoverLan(seedIp, maxHop, snmpUserOpt, null, 0L, dcnmUser, false);
            LanImpl lan = task.getLan();
            if (lan == null) {
                return null;
            }
            return lan.getPK();
        }
        catch (SnmpException se) {
            _Logger.warn((Object)("Caught exception from discoverLan for :" + seedIp), (Throwable)se);
            throw new RemoteException("Authentication failed from " + seedIp);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from discoverLan for :" + seedIp), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void removeLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            DCManager.getInstance().removeLan(lanPK, true, true);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from removeLan for :" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void rediscoverLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            if (DCManager.getInstance().findLan(lanPK) != null) {
                DCManager.getInstance().rediscoverLan();
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)"Caught exception from rediscoverLan", (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public int getLanStatus(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(lanPK);
            if (remoteServer == null) {
                try {
                    if (DCManager.getInstance().findLan(lanPK) != null) {
                        return DCManager.getInstance().getLanStatus();
                    }
                }
                catch (Exception ex) {
                    _Logger.warn((Object)("Caught exception from getLanStatus for :" + lanPK), (Throwable)ex);
                    throw new RemoteException(ex.getMessage());
                }
                return -1;
            }
            String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
            return remoteServer.getLanStatus(lanPK, newSsoToken);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void unmanageLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            if (DCManager.getInstance().findLan(lanPK) != null) {
                DCManager.getInstance().unmanageLan();
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from unmanageLan for :" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void manageLan(LanPK lanPK, String ssoToken) throws RemoteException {
        block8: {
            this.assertToken(ssoToken);
            FMServerRif remoteServer = null;
            try {
                remoteServer = this.getServerForPKifNotLocalServer(lanPK);
                if (remoteServer == null) {
                    try {
                        if (DCManager.getInstance().findLan(lanPK) != null) {
                            DCManager.getInstance().manageLan();
                        } else {
                            DCManager.getInstance().hostLan(lanPK);
                        }
                        break block8;
                    }
                    catch (Exception ex) {
                        _Logger.warn((Object)("Caught exception from manageLan for :" + lanPK), (Throwable)ex);
                        throw new RemoteException("Cannot manage the LAN:" + lanPK);
                    }
                }
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.manageLan(lanPK, newSsoToken);
            }
            catch (Exception ex) {
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public boolean hasHostedLan(String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return DCManager.getInstance().hasHostedLan();
        }
        catch (Exception ex) {
            _Logger.warn((Object)"Caught exception from hasHostedLan", (Throwable)ex);
            throw new RemoteException("Failed to check the server hosting any LAN");
        }
    }

    @Override
    public void unHostLanTask(TaskKey taskkey, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            DCManager.getInstance().unhostTask(taskkey);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from unhostLANTask for :" + taskkey), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void unHostLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            DCManager.getInstance().unhostLan(lanPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from unhostLAN for :" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void hostLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            DCManager.getInstance().hostLan(lanPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from hostLAN for :" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public LanBase getLan(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            LanImpl lan = DCManager.getInstance().findLan(lanPK);
            if (lan != null) {
                return DCManager.getInstance().getLanBase();
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from getLan for :" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
        return null;
    }

    @Override
    public boolean removeEthSwitches(LanPK lanPK, PKIf[] swPKs, boolean purge, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        if (swPKs == null) {
            return true;
        }
        try {
            boolean removed = false;
            for (PKIf swPK : swPKs) {
                if (!DCManager.getInstance().removeEthSwitch(swPK, purge)) continue;
                removed = true;
            }
            return removed;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from removeEthSwitches for :" + Arrays.toString(swPKs)), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean removeEthIsls(LanPK lanPK, EthIslPK[] islPKs, boolean purge, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            boolean removed = false;
            for (EthIslPK islPK : islPKs) {
                if (!DCManager.getInstance().removeEthIsl(lanPK, islPK, purge)) continue;
                removed = true;
            }
            return removed;
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from removeEthIsls for :" + Arrays.toString(islPKs)), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void purgeLanDowns(LanPK lanPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            DCManager.getInstance().purgeLanDowns(lanPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from purgeLanDowns:" + lanPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public List<EthPortBase> getEthPortsForEthSwitch(LanPK lanPK, PKIf swPK, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return DCManager.getInstance().getEthPortsBySwitch(lanPK, swPK);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from getEthPortsBySwitch:" + swPK), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean setLanName(LanPK lanPK, String lanName, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return DCManager.getInstance().setLanName(lanPK, lanName);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Caught exception from setLanName:" + lanPK + ", lanName=" + lanName), (Throwable)ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void deleteFabric(FabricPK pk, String ssoToken) throws RemoteException {
        block11: {
            if (pk == null) {
                throw new RemoteException("Invalid fabric key " + pk);
            }
            this.assertToken(ssoToken);
            FMServerRif remoteServer = null;
            try {
                remoteServer = this.getServerForPKifNotLocalServer(pk);
                if (remoteServer == null) {
                    if (this.isFabricInPmCollection(pk)) {
                        String msg = "Cannot remove " + pk + " it is used by Performance Manager, \n" + "Please remove from PM Collections. (Webclient Admin->Performance->Collections)";
                        throw new RemoteException(msg);
                    }
                    try {
                        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
                        if (fabric != null) {
                            SanManager.getInstance().purgeFabric(fabric);
                            break block11;
                        }
                        try {
                            InventoryPersistentManager.getInstance();
                            InventoryPersistentManager.purgeFabric(FabricImpl.findDbIdByFPK(pk._fid));
                            break block11;
                        }
                        catch (Exception ex) {
                            _Logger.log((Priority)Level.WARN, (Object)("purge fabric " + fabric), (Throwable)ex);
                            throw ex;
                        }
                    }
                    catch (Exception ex) {
                        throw new RemoteException(ex.getMessage(), ex);
                    }
                }
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.deleteFabric(pk, newSsoToken);
            }
            catch (Exception ex) {
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void manageFabric(FabricPK fabricPK, String ssoToken) throws RemoteException {
        block8: {
            if (fabricPK == null) {
                throw new RemoteException("fabric PK doesn't exist");
            }
            this.assertToken(ssoToken);
            FMServerRif remoteServer = null;
            try {
                remoteServer = this.getServerForPKifNotLocalServer(fabricPK);
                if (remoteServer == null) {
                    FabricImpl fabric;
                    try {
                        fabric = SanManager.getInstance().manageFabric(fabricPK);
                    }
                    catch (Exception ex) {
                        _Logger.error((Object)"manage fabric failed:", (Throwable)ex);
                        throw new RemoteException(ex.getMessage());
                    }
                    if (fabric == null) {
                        String errorStr = "manage fabric failed, can not find fabric in Cache or Database";
                        _Logger.error((Object)errorStr);
                        throw new RemoteException(errorStr);
                    }
                    break block8;
                }
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.manageFabric(fabricPK, newSsoToken);
            }
            catch (Exception ex) {
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void setFabricCredentials(FabricPK pkey, SnmpUserOpt snmpUserOpt, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(pkey);
            SnmpUser user = SessionImpl.convertSnmpUser(snmpUserOpt);
            if (remoteServer == null) {
                FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
                if (fabric == null) {
                    throw new RemoteException("fabric doesn't exist");
                }
                if (fabric.getSwitches().length == 0) {
                    fabric.setDBCredentials(user);
                } else {
                    SecurityManager.authenticate(user, fabric);
                }
                fabric.setCredentials(user, true);
            } else {
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.setFabricCredentials(pkey, snmpUserOpt, newSsoToken);
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFabricName(FabricPK pkey, String newName, String ssoToken) throws RemoteException {
        if (newName == null) {
            throw new RemoteException("Fabric name can not be blank");
        }
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(pkey);
            if (remoteServer == null) {
                FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
                if (fabric == null) {
                    throw new RemoteException("Unable to find fabric.");
                }
                if (fabric.getFabricName().equals(newName)) {
                    return;
                }
                boolean alreadyExists = SanManager.getInstance().checkIfFabricNameExists(newName);
                if (alreadyExists) throw new RemoteException("A fabric already exist with that name.");
                fabric.setFabricName(newName);
                return;
            } else {
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.setFabricName(pkey, newName, newSsoToken);
            }
            return;
        }
        catch (Exception ex) {
            if (!(ex instanceof RemoteException)) throw new RemoteException(ex.getMessage(), ex);
            throw (RemoteException)ex;
        }
    }

    @Override
    public void setPersistent(FabricPK pkey, boolean isPersistent, String ssoToken) throws RemoteException {
        block9: {
            this.assertToken(ssoToken);
            FMServerRif remoteServer = null;
            try {
                remoteServer = this.getServerForPKifNotLocalServer(pkey);
                if (remoteServer == null) {
                    FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
                    if (fabric == null) {
                        try {
                            InetAddress ipAddr = GlobalFabricManager.getInstance().getSeedSwitchAddress(pkey);
                            fabric = InventoryPersistentManager.getInstance().reloadFabric(ipAddr);
                        }
                        catch (Exception e) {
                            throw new RemoteException("can not find seed switch in db for fabric id:" + pkey.get_fid());
                        }
                        if (fabric == null) {
                            throw new RemoteException("Can not find fabric:" + pkey);
                        }
                    }
                    if (isPersistent && FMStandalone.isStandAlone()) {
                        throw new RemoteException("You can not manage fabric continuously in Stand-Alone mode");
                    }
                    SanManager.getInstance().persistFabric(fabric, isPersistent);
                    break block9;
                }
                String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
                remoteServer.setPersistent(pkey, isPersistent, newSsoToken);
            }
            catch (Exception ex) {
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    public boolean isFabricInPmCollection(FabricPK pkey) throws RemoteException {
        List<PmPolicyImpl> implList = PmCollect.getMetaData().getFabricPolicyList();
        if (implList == null) {
            return false;
        }
        for (PmPolicyImpl impl : implList) {
            try {
                FabricPK pPk = FabricImpl.findFPKByDbId(impl.getBase().getFabricId());
                if (pPk == null || !pkey.equals(pPk)) continue;
                return true;
            }
            catch (SQLException ex) {
                throw new RemoteException(ex.getMessage());
            }
        }
        return false;
    }

    @Override
    public FabricPK discoverFabric(SnmpUserOpt snmpUserOpt, String seedAddr, String ssoToken, String inVsans, String exVsans, String serverIP) throws RemoteException {
        SnmpUser snmpUser = SessionImpl.convertSnmpUser(snmpUserOpt);
        FMServerRif remoteServer = null;
        if (serverIP != null) {
            try {
                remoteServer = this.getServerForIPIfNotLocal(serverIP);
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
        if (remoteServer != null) {
            return remoteServer.discoverFabric(snmpUser, seedAddr, ssoToken, inVsans, exVsans);
        }
        return this.discoverFabric(snmpUser, seedAddr, ssoToken, inVsans, exVsans);
    }

    @Override
    public boolean isManageableforNpvSwitches() throws RemoteException {
        return Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true"));
    }

    @Override
    public void setManageableforNpvSwitches() throws RemoteException {
        if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true"))) {
            return;
        }
        SwitchImpl[] sws = SanManager.getInstance().getSwitches();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (!sws[i].isNpvEnabled()) continue;
            sws[i].setManageable(true, null);
        }
    }

    @Override
    public void setUnManageableforNpvSwitches() throws RemoteException {
        if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "false"))) {
            return;
        }
        SwitchImpl[] sws = SanManager.getInstance().getSwitches();
        for (int i = 0; sws != null && i < sws.length; ++i) {
            if (!sws[i].isNpvEnabled()) continue;
            sws[i].setManageable(false, "unmanaged no NPV discovery");
        }
    }

    @Override
    public FabricPK discoverFabric(SnmpUser snmpUser, String seedAddr, String ssoToken, String inVsans, String exVsans) throws RemoteException {
        if (snmpUser == null) {
            throw new RemoteException("Null SNMP credential");
        }
        this.assertToken(ssoToken);
        String fmUserName = SecurityManager.getSSoTokenUserName(ssoToken);
        try {
            InetAddress seedip = InetAddress.getByName(seedAddr);
            FabricImpl fabric = SanManager.getInstance().findFabric(seedip, inVsans, exVsans);
            if (fabric == null || !snmpUser.equals(fabric.getCredentials())) {
                UserEntry.authenticate(snmpUser, seedip);
            }
            if (fabric != null) {
                UserFabricImpl.addSnmpUser(fmUserName, fabric.getPK(), snmpUser);
                return fabric.getPK();
            }
            fabric = SanManager.getInstance().openFabric(seedip, snmpUser, inVsans, exVsans);
            if (fabric == null) {
                throw new RemoteException("open fabric " + seedAddr + " failed.");
            }
            UserFabricImpl.addSnmpUser(fmUserName, fabric.getPK(), snmpUser);
            return fabric.getPK();
        }
        catch (SnmpException se) {
            throw new RemoteException("Authentication failed", se);
        }
        catch (Exception ex) {
            throw new RemoteException("open fabric failed", ex);
        }
    }

    private void assertToken(String ssoToken) throws RemoteException {
        if (ssoToken == null || !SecurityManager.confirmSSOToken(ssoToken)) {
            throw new RemoteException("Invalid FM user credential");
        }
    }

    @Override
    public ArrayList<NameValuePair> getLocalTemplates(File reportDir) {
        ArrayList<NameValuePair> tmpList = new ArrayList<NameValuePair>();
        File localReportDir = new File(ClientCache.getReportsDir());
        ReportUtil.getLocalTemplates(localReportDir.exists() ? localReportDir : reportDir, tmpList);
        return tmpList;
    }

    @Override
    public FileBase[] getLocalReports(File reportDir, String base, Map dataMap) throws Exception {
        int beginIndex = reportDir.getPath().lastIndexOf("reports") + "reports".length() + 1;
        String suffix = beginIndex >= reportDir.getPath().length() ? "" : reportDir.getPath().substring(beginIndex, reportDir.getPath().length());
        ArrayList<FileWrapper> localRpts = null;
        try {
            PersistentHelper.getHelper().updateDbForAllReportsInDir(reportDir, base, dataMap, this.getCurrentServerIP());
            localRpts = ReportUtil.getLocalReports(new File(_reportDir + File.separator + suffix), base, dataMap, this.getCurrentServerIP());
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        FileBase[] fbArr = new FileBase[localRpts.size()];
        for (int i = 0; i < localRpts.size(); ++i) {
            FileBase fb = new FileBase();
            FileWrapper wrapper = (FileWrapper)localRpts.get(i);
            fb.setName(wrapper.getName());
            fb.setAbsoluteName(wrapper.getAbsoluteName());
            fb.setContext(wrapper.getContext());
            fb.setCreator(wrapper.getCreator());
            fb.setLastModified(wrapper.getLastModifiedStr());
            fb.setLink(wrapper.getLink());
            fb.setParent(wrapper.getParent());
            fb.setTemplate(wrapper.getTemplate());
            fbArr[i] = fb;
        }
        return fbArr;
    }

    @Override
    public void deleteFiles(File report, String serverAddress, boolean usePattern) {
        ReportUtil.deleteFiles(report, serverAddress, usePattern);
    }

    @Override
    public void syncWebReferences() throws Exception {
        WebReferenceManager.getInstance().updateReferences();
    }

    @Override
    public List<ServerReference> getWebReferences() throws Exception {
        return WebReferenceManager.getInstance().getReferences();
    }

    @Override
    public int getFmLicensedState(FabricPK key, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(key);
            if (remoteServer == null) {
                FabricImpl fabric = SanManager.getInstance().findFabric(key);
                if (fabric == null) {
                    throw new RemoteException("Fabric not found");
                }
                return LicenseManager.getInstance().getFmLicensedState(fabric);
            }
            String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
            return remoteServer.getFmLicensedState(key, newSsoToken);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isFMLicensed(FabricPK key, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForPKifNotLocalServer(key);
            if (remoteServer == null) {
                FabricImpl fabric = SanManager.getInstance().findFabric(key);
                if (fabric == null) {
                    throw new RemoteException("Fabric not found");
                }
                return LicenseManager.getInstance().isFmLicensed(fabric);
            }
            String newSsoToken = SessionHelper.getInstance().getSession().getSSOToken();
            return remoteServer.isFMLicensed(key, newSsoToken);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int isDmmLicensed(FabricPK key, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FabricImpl fabric = SanManager.getInstance().findFabric(key);
        if (fabric == null) {
            throw new RemoteException("Fabric not found");
        }
        try {
            return LicenseManager.getInstance().isDmmLicensed(fabric);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int cachedLicenseState(FabricPK key, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        FabricImpl fabric = SanManager.getInstance().findFabric(key);
        if (fabric == null) {
            return GlobalFabricManager.getInstance().getFabricLicenseId(key);
        }
        return fabric.getLicenseId();
    }

    @Override
    public Map<FabricPK, List<SwitchBase>> getAllUnLicenseSwitches(List<FabricPK> keys, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return LicenseManager.getInstance().getAllUnLicensedSwitches(keys);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<SwitchBase> getAllUnLicenseSwitches(FabricPK key, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return LicenseManager.getInstance().getAllUnLicensedSwitches(key);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void updateServerPropertyWOStore(String[] keys, String[] values, boolean add, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            ServerPropertyUtil.updateServerProperty(keys, values, add);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<PossibleFCFlowTrafficDto> getPossibleFlowPairsPerTraffic(FabricPK fabric, int collectionPeriod, int collectionDataType, int percent, int conversationType, String ssoToken) throws RemoteException {
        this.assertToken(ssoToken);
        try {
            return HostRedundancyCheck.getInstance().getValidFlowPairs(fabric, collectionPeriod, collectionDataType, percent, conversationType);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getLicenseDir() throws RemoteException {
        try {
            return FileLicensingHelper.getInstance().getLicenseDir();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<LicenseInfoFlex> getFileLicenseInfo() throws RemoteException {
        try {
            return FileLicensingHelper.getInstance().getLicDataFromDB();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public Map<String, LicenseFileUsage> getFileLicenseUsageInfo() throws RemoteException {
        try {
            return FileLicensingHelper.getInstance().getLicUsageDataFromDB();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<String> reloadLicenseFiles() throws RemoteException {
        try {
            int serverId;
            FMServerRif remoteServer = null;
            boolean isFederation = this.isFederation();
            if (isFederation && (serverId = ClusterSequence.getSequence().getServerId()) != 0) {
                String firstServerIp = null;
                firstServerIp = ClusterMapping.getInstance().qIPFromSId(0).getHostAddress();
                if (firstServerIp != null) {
                    remoteServer = ClusterProcessor.getInstance().getFmsByIp(firstServerIp);
                } else {
                    throw new Exception("Unable to get IP Address to first server in the federation.");
                }
            }
            if (remoteServer == null) {
                return FileLicensingHelper.getInstance().reloadLicenseFiles();
            }
            return remoteServer.reloadLicenseFiles();
        }
        catch (Exception ex) {
            _Logger.error((Object)ex);
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    private boolean isFederation() {
        boolean isFederation = false;
        try {
            List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
            isFederation = serverList != null && serverList.size() > 1;
        }
        catch (Exception ex) {
            _Logger.warn((Object)"unassignLicenseFromSwitch failed on qALlIPStrings(), default to federation false");
        }
        return isFederation;
    }

    private FMServerRif getServerForPKifNotLocalServer(FabricPK fpk) throws Exception {
        boolean isFederation = this.isFederation();
        if (!isFederation) {
            return null;
        }
        try {
            String fmServerIP = null;
            fmServerIP = ClusterProcessor.getInstance().getServerIpByPK(fpk);
            if (fmServerIP == null) {
                throw new Exception("fmServer IP is null for fabricPK:" + fpk);
            }
            int serverId = ClusterSequence.getSequence().getServerId();
            String thisServerIp = "";
            thisServerIp = ClusterMapping.getInstance().qIPFromSId(serverId).getHostAddress();
            if (!thisServerIp.equals(fmServerIP)) {
                FMServerRif remoteServer = ClusterProcessor.getInstance().getFmsByIp(fmServerIP);
                if (remoteServer == null) {
                    throw new Exception("remote server lookup in cluster failed to find server reference for server ip -" + fmServerIP + " returned null");
                }
                return remoteServer;
            }
            return null;
        }
        catch (Exception ex) {
            _Logger.warn((Object)"caught exception, ex :", (Throwable)ex);
            throw new Exception("Unable to get server to handle your request.");
        }
    }

    private FMServerRif getServerForIPIfNotLocal(String targetServerIp) throws Exception {
        boolean isFederation = this.isFederation();
        if (!isFederation) {
            return null;
        }
        try {
            FMServerRif remoteServer = null;
            if (targetServerIp == null) {
                throw new Exception("Can not find managed server for IP:" + targetServerIp);
            }
            if (!this.getActiveServerNodes().contains(targetServerIp)) {
                throw new Exception("Can not find active managed server for IP:" + targetServerIp);
            }
            int serverId = ClusterSequence.getSequence().getServerId();
            String currentServerIp = "";
            currentServerIp = ClusterMapping.getInstance().qIPFromSId(serverId).getHostAddress();
            if (!targetServerIp.equals(currentServerIp)) {
                remoteServer = ClusterProcessor.getInstance().getFmsByIp(targetServerIp);
                if (remoteServer == null) {
                    throw new Exception("remote server lookup in cluster failed to find server reference for server ip -" + targetServerIp + " returned null");
                }
                return remoteServer;
            }
            return null;
        }
        catch (Exception ex) {
            _Logger.warn((Object)"caught exception, ex :", (Throwable)ex);
            throw new Exception("Unable to get server to handle your request.");
        }
    }

    @Override
    public String getLicenseHostID() throws RemoteException {
        try {
            int serverId;
            FMServerRif remoteServer = null;
            boolean isFederation = this.isFederation();
            if (isFederation && (serverId = ClusterSequence.getSequence().getServerId()) != 0) {
                String firstServerIp = null;
                firstServerIp = ClusterMapping.getInstance().qIPFromSId(0).getHostAddress();
                if (firstServerIp != null) {
                    remoteServer = ClusterProcessor.getInstance().getFmsByIp(firstServerIp);
                } else {
                    throw new Exception("Unable to get IP Address to first server in the federation.");
                }
            }
            if (remoteServer == null) {
                String serverIP = this.getIPForServerID(0);
                return serverIP + "'s mac address " + FileLicensingHelper.getInstance().getLicenseHostID();
            }
            return remoteServer.getLicenseHostID();
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public SwitchAssignedLicenseInfo unassignLicenseFromSwitch(long swDB, int fabOrLanFid, int licenseType) throws RemoteException {
        try {
            FabricPK fpk = licenseType == 1 ? new FabricPK(fabOrLanFid) : new LanPK(fabOrLanFid);
            FMServerRif remoteServer = this.getServerForPKifNotLocalServer(fpk);
            if (remoteServer == null) {
                SwitchAssignedLicenseInfo assignedLicInfo = FileLicensingHelper.getInstance().manuallyUnassignLicenseFromSwitch(swDB, fpk, licenseType);
                if (licenseType == 2 && assignedLicInfo.isVDC()) {
                    List<SwitchAssignedLicenseInfo> allVDCsInChassis = FileLicensingHelper.getInstance().getAllLanSwitchesWithSameChassis(assignedLicInfo.getSwitchKey());
                    ArrayList<SwitchAssignedLicenseInfo> remoteVDCs = new ArrayList<SwitchAssignedLicenseInfo>();
                    try {
                        for (SwitchAssignedLicenseInfo nextLic : allVDCsInChassis) {
                            if (!nextLic.isLicensed()) continue;
                            LanPK nextFPK = new LanPK(nextLic.getFabOrLanId());
                            remoteServer = this.getServerForPKifNotLocalServer(nextFPK);
                            if (remoteServer == null) {
                                FileLicensingHelper.getInstance().manuallyUnassignLicenseFromSwitch(nextLic.getDbID(), nextFPK, licenseType);
                                continue;
                            }
                            remoteVDCs.add(nextLic);
                        }
                        if (!remoteVDCs.isEmpty()) {
                            SwitchAssignedLicenseInfo firstRemoteVDC = (SwitchAssignedLicenseInfo)remoteVDCs.get(0);
                            this.unassignLicenseFromSwitch(firstRemoteVDC.getDbID(), firstRemoteVDC.getFabOrLanId(), licenseType);
                        }
                    }
                    catch (Exception e) {
                        _Logger.error((Object)("Received error while unassigning license from multiple VDCs with the same Chassis id:" + assignedLicInfo.getSwitchKey()), (Throwable)e);
                    }
                }
                return assignedLicInfo;
            }
            return remoteServer.unassignLicenseFromSwitch(swDB, fabOrLanFid, licenseType);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setHostRedundancyCheckToDisabled(boolean disable) throws RemoteException {
    }

    @Override
    public void triggerReRunOfHostRedundancyCheck(boolean triggerOtherServers) throws RemoteException {
        boolean isFederation = this.isFederation();
        try {
            HostRedundancyCheck.getInstance().doRedundancyCheck();
            if (isFederation && triggerOtherServers) {
                List<String> servers = ServerMonitor.getInstance().getActiveServerNodes();
                for (int j = 0; j < servers.size(); ++j) {
                    FMServerRif fmServer = this.getFMServer(servers.get(j));
                    if (fmServer == null || fmServer.getCurrentServerId() == this.getCurrentServerId()) continue;
                    fmServer.triggerReRunOfHostRedundancyCheck(false);
                }
            }
        }
        catch (Exception e) {
            _Logger.error((Object)"Error running Host Redundancy check", (Throwable)e);
            int currentServerId = Sequence.getSequence().getServerId();
            String serverIP = "";
            try {
                InetAddress adr = ClusterMapping.getInstance().qIPFromSId(currentServerId);
                serverIP = adr.getHostAddress();
            }
            catch (Exception ex) {
                _Logger.error((Object)"unable to get this servers IP address:", (Throwable)ex);
            }
            StringBuilder message = new StringBuilder("Unable to run redundancy check - ");
            if (isFederation) {
                message.append("failed on Server:" + serverIP);
            }
            throw new RemoteException(message.toString(), e);
        }
    }

    private FMServerRif getFMServer(String server) {
        FMServerRif fmRif = null;
        String defaultRmiPort = System.getProperty("server.port", "9099");
        if (server == null || server.equals("")) {
            server = "localhost";
        }
        int rmiPort = Integer.parseInt(defaultRmiPort);
        try {
            EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
            String localServer = rif.getFMServer().whereami();
            if (rif != null) {
                fmRif = server.equals("localhost") || localServer.equals(server) ? rif.getFMServer() : (FMServerRif)rif.getRemoteService(server, "FMServerBean");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fmRif;
    }

    @Override
    public SwitchAssignedLicenseInfo assignAvailableLicenseToSwitch(long swDB, int fabOrLanFid, int licenseType) throws RemoteException {
        try {
            FabricPK fpk = licenseType == 1 ? new FabricPK(fabOrLanFid) : new LanPK(fabOrLanFid);
            FMServerRif remoteServer = this.getServerForPKifNotLocalServer(fpk);
            if (remoteServer == null) {
                SwitchAssignedLicenseInfo assignedLicInfo = FileLicensingHelper.getInstance().manuallyAssignAvailableLicenseToSwitch(swDB, fpk, licenseType);
                if (licenseType == 2 && assignedLicInfo.isVDC()) {
                    List<SwitchAssignedLicenseInfo> allVDCsInChassis = FileLicensingHelper.getInstance().getAllLanSwitchesWithSameChassis(assignedLicInfo.getSwitchKey());
                    ArrayList<SwitchAssignedLicenseInfo> remoteVDCs = new ArrayList<SwitchAssignedLicenseInfo>();
                    try {
                        for (SwitchAssignedLicenseInfo nextLic : allVDCsInChassis) {
                            if (nextLic.isLicensed()) continue;
                            LanPK nextFPK = new LanPK(nextLic.getFabOrLanId());
                            remoteServer = this.getServerForPKifNotLocalServer(nextFPK);
                            if (remoteServer == null) {
                                FileLicensingHelper.getInstance().manuallyAssignAvailableLicenseToSwitch(nextLic.getDbID(), nextFPK, licenseType);
                                continue;
                            }
                            remoteVDCs.add(nextLic);
                        }
                        if (!remoteVDCs.isEmpty()) {
                            SwitchAssignedLicenseInfo firstRemoteVDC = (SwitchAssignedLicenseInfo)remoteVDCs.get(0);
                            this.assignAvailableLicenseToSwitch(firstRemoteVDC.getDbID(), firstRemoteVDC.getFabOrLanId(), licenseType);
                        }
                    }
                    catch (Exception e) {
                        _Logger.error((Object)("Received error while assigning license for multiple VDCs with the same Chassis id:" + assignedLicInfo.getSwitchKey()), (Throwable)e);
                    }
                }
                return assignedLicInfo;
            }
            return remoteServer.assignAvailableLicenseToSwitch(swDB, fabOrLanFid, licenseType);
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<SwitchAssignedLicenseInfo> getLicenseInfoSwitchAssignment() throws RemoteException {
        try {
            return FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getUnlicensedSwitchCount(int productType) throws RemoteException {
        try {
            return FileLicensingHelper.getInstance().getUnlicensedSwitchCount(productType);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void saveLicenseFileToServer(String fileContent, String fileName) throws RemoteException {
        try {
            int serverId;
            FMServerRif remoteServer = null;
            boolean isFederation = this.isFederation();
            if (isFederation && (serverId = ClusterSequence.getSequence().getServerId()) != 0) {
                String firstServerIp = null;
                firstServerIp = ClusterMapping.getInstance().qIPFromSId(0).getHostAddress();
                if (firstServerIp != null) {
                    remoteServer = ClusterProcessor.getInstance().getFmsByIp(firstServerIp);
                } else {
                    throw new Exception("Unable to get IP Address to first server in the federation.");
                }
            }
            if (remoteServer == null) {
                FileLicensingHelper.getInstance().saveLicenseFileToServer(fileContent, fileName);
            } else {
                remoteServer.saveLicenseFileToServer(fileContent, fileName);
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public ClusterProcessRif getClusterProcessor() throws Exception {
        return ClusterProcessor.getInstance();
    }

    @Override
    public Map<String, List<String>> getSysLogs() throws Exception {
        File[] all;
        HashMap<String, List<String>> sysLogMap = new HashMap<String, List<String>>();
        File logDir = new File(ClientCache.getLogsDir());
        if (logDir.exists() && (all = logDir.listFiles()) != null && all.length > 0) {
            for (int i = 0; i < all.length; ++i) {
                if (!all[i].isDirectory()) continue;
                ArrayList<String> val = new ArrayList<String>(all.length);
                String[] logs = all[i].list();
                for (int j = 0; j < logs.length; ++j) {
                    val.add(logs[j]);
                }
                Collections.sort(val);
                sysLogMap.put(all[i].getName(), val);
            }
        }
        return sysLogMap;
    }

    public static void main(String[] args) {
        try {
            FMServerImpl fimpl = FMServerImpl.getInstance();
            System.out.println(FMServerImpl.getInstance().getCurrentServerIP());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getServerTimeFor(String serverIp) throws RemoteException {
        FMServerRif remoteServer = null;
        try {
            remoteServer = this.getServerForIPIfNotLocal(serverIp);
            if (remoteServer == null) {
                return this.getServerTime();
            }
            return remoteServer.getServerTime();
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public long getServerTime() {
        return System.currentTimeMillis();
    }

    @Override
    public ArrayList<SwitchBase> getFabricSwitches(FabricPK key) throws RemoteException {
        SwitchImpl[] allSw;
        ArrayList<SwitchBase> lsSw = new ArrayList<SwitchBase>();
        FabricImpl fabric = SanManager.getInstance().findFabric(key);
        if (fabric != null && (allSw = fabric.getSwitches()) != null) {
            for (int i = 0; i < allSw.length; ++i) {
                lsSw.add((SwitchBase)allSw[i].getBaseObject());
            }
        }
        return lsSw;
    }

    @Override
    public boolean isDCNMLaunchable() {
        try {
            DCNMInfo dcnm = DCNMInfo.getInstance();
            if (dcnm == null) {
                return false;
            }
            return dcnm.isLaunchable();
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            return true;
        }
    }

    @Override
    public int getDCNMWebPort() throws RemoteException {
        DCNMInfo dcnm;
        try {
            dcnm = DCNMInfo.getInstance();
            if (dcnm == null) {
                throw new RemoteException("Unable to get DCNM web port because DCNM instance is null");
            }
        }
        catch (SAXException saxEx) {
            throw new RemoteException(saxEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new RemoteException(ioEx.getMessage());
        }
        return dcnm.getWebPort();
    }

    @Override
    public boolean isDCNMUseHttps() throws RemoteException {
        DCNMInfo dcnm;
        try {
            dcnm = DCNMInfo.getInstance();
            if (dcnm == null) {
                throw new RemoteException("Unable to get DCNM web port because DCNM instance is null");
            }
        }
        catch (SAXException saxEx) {
            throw new RemoteException(saxEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new RemoteException(ioEx.getMessage());
        }
        return dcnm.isHttps();
    }

    @Override
    public void prefUpdated() throws RemoteException {
        ArrayList<PropertyWrapper> propsList = ServerPropertyUtil.readServerProperties();
        for (PropertyWrapper p : propsList) {
            System.setProperty(p.getKey(), p.getValue());
        }
    }

    @Override
    public void restart(int type) throws RemoteException {
        ServerPropertyUtil.restart(type);
    }

    @Override
    public String getNewOUIs() throws RemoteException {
        return WwnDictionary.getNewOUIs();
    }

    @Override
    public VirtualCenterBase addVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().createVirtualCenter(0, vcIP, username, passwd, discovery);
            if (vcImpl == null) {
                return null;
            }
            if (discovery) {
                DiscoveryManager.getInstance().discoverVC(vcImpl, DiscoveryType.VI_INITIAL);
            }
            return (VirtualCenterBase)vcImpl.getBaseObject();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public VirtualCenterBase removeVirtualCenter(InetAddress vcIP) throws RemoteException {
        try {
            VirtualCenterImpl vcImpl = ViManager.getInstance().removeVirtualCenter(vcIP);
            return vcImpl == null ? null : (VirtualCenterBase)vcImpl.getBaseObject();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public List<SwitchNameDO> getAllSwitches() throws RemoteException {
        try {
            return SwitchHandler.getInstance().getAllSwitches();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public EndPortDO getEndPortByDbId(long epId) throws RemoteException {
        try {
            ArrayList<EndPortDO> endPortList = EndDeviceHandler.getInstance().getEndDeviceList(epId);
            return endPortList.get(0);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void updateVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery) throws RemoteException {
        try {
            ViManager.getInstance().updateVirtualCenter(vcIP, username, passwd, discovery);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setDirtyFlagForGCache() throws RemoteException {
        DbUtil.setDirtyFlag();
    }
}

