/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.sm.common.dto.CfsStaticPeerDto;
import com.cisco.dcbu.sm.common.dto.NpvPortPairCfg;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.NPVRif;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.npv.NPVhelper;
import com.cisco.dcbu.sm.server.npv.NpvManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NPVImpl
implements NPVRif {
    static Logger _Logger = LogManager.getLogger((String)"fms.npv");
    private static final int[] notFreePortOperStatusCause = new int[]{4, 5, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 24, 25, 27, 28, 31, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 60, 61, 62, 63, 64, 65, 66, 70, 78, 79, 98, 99, 100, 101, 102, 103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 120, 121, 124, 125, 126, 127, 128, 129, 130, 131, 133, 134, 135, 136, 137, 138, 139, 140};
    private static final int[] portFailureOperStatusCause = new int[]{1, 3, 6, 7, 17, 18, 23, 26, 27, 28, 30, 36, 37, 58, 59, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 122, 123, 132};
    private static final int[] nonSpecificPortOperStatusCause = new int[]{5, 2, 9, 107};
    private static final int[] freePortOperStatusCause = new int[]{2, 8, 29};
    private static final int[] paradiseDefaults = new int[]{1, 5, 9, 13, 17, 21};
    private static final int[] chesterDefaults = new int[]{1, 5, 10, 14, 18, 20, 23, 24};
    private static final int[] inaguaDefaults = new int[]{1, 5, 10, 14, 18, 20};
    private static final int[] urosDefaults = new int[]{1, 5, 9, 13, 17, 21, 25, 29, 33, 34};

    @Override
    public Map<SwitchBase, List<FcPortBase>> findFcPortBase(List<SwitchBase> switches) throws RemoteException {
        try {
            HashMap<SwitchBase, List<FcPortBase>> resultMap = new HashMap<SwitchBase, List<FcPortBase>>();
            SanManager sanMInst = SanManager.getInstance();
            for (int i = 0; i < switches.size(); ++i) {
                SwitchBase sw = switches.get(i);
                SwitchImpl swImpl = sanMInst.findSwitch(sw.getWwn(), sw.getFabricPK());
                List<FcPortBase> externalports = this.findFcPortBase(swImpl);
                resultMap.put(sw, externalports);
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting ports for switches", e);
        }
    }

    @Override
    public List<FcPortBase> findFcPortBase(SwitchBase sw) throws RemoteException {
        try {
            SanManager sanMInst = SanManager.getInstance();
            SwitchImpl swImpl = sanMInst.findSwitch(sw.getWwn(), sw.getFabricPK());
            return this.findFcPortBase(swImpl);
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting ports for switches", e);
        }
    }

    private List<FcPortBase> findFcPortBase(SwitchImpl swImpl) throws Exception {
        List<FcPortBase> ports = swImpl.getPorts();
        ArrayList<FcPortBase> externalports = new ArrayList<FcPortBase>();
        for (int k = 0; k < ports.size(); ++k) {
            FcPortBase nextPort = ports.get(k);
            int type = IfIndexUtil.getType(nextPort.getIfIndex());
            if (nextPort.isInternalPort() || type != 1) continue;
            externalports.add(nextPort);
        }
        return externalports;
    }

    @Override
    public long enableNPVFeature(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().enableNPVFeature(switches, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while enabling NPV on Switches ", e);
        }
    }

    @Override
    public long addSwitchesToVsan(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, int vsan, VsanBase vsanBase, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().addSwitchesToVsan(switches, snmpUserOpts, vsan, vsanBase, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while adding VSAN to Switches ", e);
        }
    }

    @Override
    public long addPortsToVsan(List<SwitchBase> switches, List<List<FcPortBase>> ports, List<SnmpUserOpt> snmpUserOpts, int vsan, VsanBase vsanBase, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().addPortsToVsan(switches, snmpUserOpts, ports, vsan, vsanBase, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while adding ports to VSAN", e);
        }
    }

    @Override
    public long enableNPVCoreFeature(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().enableNPIVFeature(switches, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while enabling NPIV on Switches ", e);
        }
    }

    @Override
    public long setNPPorts(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpt, List<List<FcPortBase>> ports, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setNPPorts(npvSwitches, snmpUserOpt, ports, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting admin mode for ports", e);
        }
    }

    @Override
    public long setFPorts(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpt, List<List<FcPortBase>> ports, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setFPorts(npvSwitches, snmpUserOpt, ports, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting admin mode for ports", e);
        }
    }

    @Override
    public long setPortsToAuto(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpt, List<List<FcPortBase>> ports, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setPortsToAuto(npvSwitches, snmpUserOpt, ports, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting admin mode for ports", e);
        }
    }

    @Override
    public long setPortsToEnable(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setPortsToEnable(switches, snmpUserOpts, ports, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting admin status for ports to enabled ", e);
        }
    }

    @Override
    public long authenticateSwitch(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().authenticateSwitch(switches, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while authenticating switch", e);
        }
    }

    @Override
    public long saveRunningConfigOnSwitch(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().saveRunningConfigOnSwitch(switches, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while saving running config", e);
        }
    }

    @Override
    public List<NpvPortPairCfg> getNpvPairPortCfg(List<NpvPortPairCfg> pairs, int numberNPPorts) throws RemoteException {
        ArrayList<NpvPortPairCfg> results = new ArrayList<NpvPortPairCfg>();
        HashMap<SwitchBase, Map<SwitchBase, NpvPortPairCfg>> lookupMap = new HashMap<SwitchBase, Map<SwitchBase, NpvPortPairCfg>>();
        HashMap<SwitchBase, List<SwitchBase>> coreSwitchesPerDevice = new HashMap<SwitchBase, List<SwitchBase>>();
        HashMap<SwitchBase, List<SwitchBase>> deviceSwitchesPerCore = new HashMap<SwitchBase, List<SwitchBase>>();
        ArrayList<SwitchBase> allSwitches = new ArrayList<SwitchBase>();
        SanManager manager = SanManager.getInstance();
        for (int i = 0; i < pairs.size(); ++i) {
            NpvPortPairCfg nextPair = pairs.get(i);
            SwitchBase swD = nextPair.getDevice();
            SwitchBase swC = nextPair.getNpvCore();
            this.addNpvPairToLookupMap(lookupMap, swD, swC, nextPair);
            this.addSwitchToMap(coreSwitchesPerDevice, swD, swC);
            this.addSwitchToMap(deviceSwitchesPerCore, swC, swD);
            if (!allSwitches.contains(swD)) {
                allSwitches.add(swD);
            }
            if (allSwitches.contains(swC)) continue;
            allSwitches.add(swC);
        }
        Map<SwitchBase, List<FcPortBase>> allFreePorts = this.findFcPortBase(allSwitches);
        Map<SwitchBase, List<FcPortBase>> allExistingNPPorts = this.findFcPortBase(allSwitches);
        for (SwitchBase nextSwitch : allFreePorts.keySet()) {
            List<FcPortBase> ports = allFreePorts.get(nextSwitch);
            ArrayList<FcPortBase> usedPorts = new ArrayList<FcPortBase>();
            ArrayList<FcPortBase> unLicensedPorts = new ArrayList<FcPortBase>();
            ArrayList<FcPortBase> existingNpPorts = new ArrayList<FcPortBase>();
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("all ports for switch - " + nextSwitch + " prior to removal of used ports :" + ports));
            }
            allExistingNPPorts.put(nextSwitch, existingNpPorts);
            boolean isCore = deviceSwitchesPerCore.containsKey(nextSwitch);
            for (int p = 0; p < ports.size(); ++p) {
                FcPortBase nextPort = ports.get(p);
                int opPortMode = nextPort.getIfOperMode();
                short opStatusCause = nextPort.getOperStatusCause();
                int ifType = nextPort.getIfType();
                if (!nextPort.isPortLicensed()) {
                    unLicensedPorts.add(nextPort);
                    usedPorts.add(nextPort);
                    continue;
                }
                if (ifType != 56) {
                    usedPorts.add(nextPort);
                    continue;
                }
                if (opPortMode == 2 || opPortMode == 3) {
                    usedPorts.add(nextPort);
                    continue;
                }
                if (opPortMode == 16) {
                    existingNpPorts.add(nextPort);
                    usedPorts.add(nextPort);
                    continue;
                }
                if (opPortMode == 1) {
                    if (this.isFreePortOpStatusCause(opStatusCause)) continue;
                    usedPorts.add(nextPort);
                    continue;
                }
                if (opPortMode == 4 || opPortMode == 12) continue;
                usedPorts.add(nextPort);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("used ports AFTER JUST CHECKING PORTS for switch - " + nextSwitch + "  :" + usedPorts));
            }
            if (isCore) {
                List connectedSwitches = (List)deviceSwitchesPerCore.get(nextSwitch);
                FabricImpl fab = manager.findFabric(nextSwitch.getFabricPK());
                SwitchImpl swImpl = manager.findSwitch(nextSwitch.getWwn(), fab.getPK());
                IslImpl[] isls = fab.findIsls(swImpl);
                for (int s = 0; s < isls.length; ++s) {
                    FcPortBase nextPort;
                    FcPortImpl nextPortImpl;
                    IslImpl nextIsl = isls[s];
                    SwitchBase switch1 = (SwitchBase)nextIsl.getSwitch1().getBaseObject();
                    SwitchBase switch2 = (SwitchBase)nextIsl.getSwitch2().getBaseObject();
                    if (switch1 == null || switch2 == null) continue;
                    if (nextSwitch.equals(switch1)) {
                        if (connectedSwitches.contains(switch2) || (nextPortImpl = nextIsl.getPort1()) == null) continue;
                        nextPort = (FcPortBase)nextPortImpl.getBaseObject();
                        usedPorts.add(nextPort);
                        continue;
                    }
                    if (connectedSwitches.contains(switch1) || (nextPortImpl = nextIsl.getPort2()) == null) continue;
                    nextPort = (FcPortBase)nextPortImpl.getBaseObject();
                    usedPorts.add(nextPort);
                }
            }
            ports.removeAll(usedPorts);
            if (!_Logger.isDebugEnabled()) continue;
            _Logger.debug((Object)("used ports for switch - " + nextSwitch + "  :" + usedPorts));
        }
        for (SwitchBase deviceSw : coreSwitchesPerDevice.keySet()) {
            List coreSwitches = (List)coreSwitchesPerDevice.get(deviceSw);
            List<FcPortBase> freePortsDevice = allFreePorts.get(deviceSw);
            int totalNPPortCount = numberNPPorts * coreSwitches.size();
            if (totalNPPortCount > freePortsDevice.size()) {
                Exception error = new Exception("Not enough ports on Switch to create NP links to all cores");
                for (int c = 0; c < coreSwitches.size(); ++c) {
                    SwitchBase nextCore = (SwitchBase)coreSwitches.get(c);
                    NpvPortPairCfg pair = this.getNpvPair(lookupMap, deviceSw, nextCore);
                    pair.setException(error);
                    results.add(pair);
                }
                continue;
            }
            int[] preferredPorts = paradiseDefaults;
            boolean portsOtherThenPreferredAllowed = true;
            int switchType = deviceSw.getModelType();
            if (deviceSw.isBladeServer()) {
                if (switchType == 601) {
                    preferredPorts = inaguaDefaults;
                    portsOtherThenPreferredAllowed = false;
                } else if (switchType == 606 || switchType == 773 || switchType == 843) {
                    preferredPorts = chesterDefaults;
                    portsOtherThenPreferredAllowed = false;
                }
            } else if (switchType == 616) {
                preferredPorts = urosDefaults;
            }
            List<FcPortBase> npPorts = this.getNPPortsFromFreePorts(preferredPorts, freePortsDevice, totalNPPortCount, portsOtherThenPreferredAllowed);
            if (npPorts.size() != totalNPPortCount) {
                Exception error = new Exception("Not enough ports on Switch to create NP links to all cores");
                for (int c = 0; c < coreSwitches.size(); ++c) {
                    SwitchBase nextCore = (SwitchBase)coreSwitches.get(c);
                    NpvPortPairCfg pair = this.getNpvPair(lookupMap, deviceSw, nextCore);
                    pair.setException(error);
                    results.add(pair);
                }
                continue;
            }
            for (int c = 0; c < coreSwitches.size(); ++c) {
                NpvPortPairCfg pair;
                SwitchBase nextCore = (SwitchBase)coreSwitches.get(c);
                List<FcPortBase> freePortsCore = allFreePorts.get(nextCore);
                List<FcPortBase> corePorts = this.getCorePortsFromFreePorts(freePortsCore, numberNPPorts);
                if (corePorts == null || corePorts.size() < numberNPPorts) {
                    if (corePorts != null) {
                        freePortsCore.addAll(corePorts);
                    }
                    Exception error = new Exception("Not enough ports on Core Switch to create all F links to Device Switch");
                    pair = this.getNpvPair(lookupMap, deviceSw, nextCore);
                    pair.setException(error);
                    results.add(pair);
                    continue;
                }
                ArrayList<FcPortBase> npPortsForCore = new ArrayList<FcPortBase>();
                for (int p = 0; p < numberNPPorts; ++p) {
                    npPortsForCore.add(npPorts.remove(0));
                }
                pair = this.getNpvPair(lookupMap, deviceSw, nextCore);
                pair.setNPPorts(npPortsForCore);
                pair.setCoreFPorts(corePorts);
                pair.setExistingNPPorts(allExistingNPPorts.get(deviceSw));
                results.add(pair);
            }
        }
        return results;
    }

    @Override
    public long setFlexAttachWWNMode(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, int mode, Object channelOrQueue) throws RemoteException {
        try {
            if (mode != 1 && mode != 2) {
                throw new RemoteException("FlexAttach WWN mode provide is not valid");
            }
            return NpvManager.getInstance().setFlexAttachWWNMode(switches, snmpUserOpts, mode, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting FlexAttach WWN mode on Switches ", e);
        }
    }

    @Override
    public long setTrafficMap(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, List<TrafficMap> maps, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setTrafficMap(switches, snmpUserOpts, maps, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting FlexAttach WWN mode on Switches ", e);
        }
    }

    @Override
    public List<TrafficMap> getTrafficMap(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts) throws RemoteException {
        try {
            this.checkInput(switches, snmpUserOpts);
            return NPVhelper.getTrafficMap(switches, snmpUserOpts);
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting Traffic Engineering Map from Switches ", e);
        }
    }

    @Override
    public Map<SwitchBase, Map> getCnpvServerIfTable(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts) throws RemoteException {
        try {
            this.checkInput(switches, snmpUserOpts);
            return NPVhelper.getCnpvServerIfTable(switches, snmpUserOpts);
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting Map of External Interface used by Server Interface Map from Switches ", e);
        }
    }

    @Override
    public List<CfsStaticPeerDto> getCFSStaticPeerList(SwitchBase sw, SnmpUserOpt cred) throws RemoteException {
        try {
            if (sw == null || cred == null) {
                throw new IllegalArgumentException("Snmp Credentials must be provided for switch.");
            }
            return NPVhelper.getCFSStaticPeerList(sw, cred);
        }
        catch (Exception e) {
            throw new RemoteException("Error while getting CFS Static Peer List from Switches ", e);
        }
    }

    @Override
    public long setCFSStaticPeerList(SwitchBase sw, SnmpUserOpt cred, List<CfsStaticPeerDto> peers, Object channelOrQueue) throws RemoteException {
        try {
            return NpvManager.getInstance().setCFSStaticPeerList(sw, cred, peers, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while settomg CFS Static Peer List to Switch ", e);
        }
    }

    @Override
    public void destroyPtoPQueue(Object channelOrQueue) throws RemoteException {
        try {
            NpvManager.getInstance().destroyPtoPQueue(channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while destroying point to point queue ", e);
        }
    }

    private void checkInput(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts) throws IllegalArgumentException {
        if (snmpUserOpts == null || snmpUserOpts.size() <= 0) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for switches.");
        }
        if (switches == null || switches.size() == 0) {
            throw new IllegalArgumentException("Must provide at least one switch to perform the action upon.");
        }
        if (switches != null && switches.size() > snmpUserOpts.size()) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for all switches.");
        }
    }

    private boolean isFreePortOpStatusCause(int cause) {
        boolean match = false;
        for (int i = 0; i < freePortOperStatusCause.length; ++i) {
            if (cause != freePortOperStatusCause[i]) continue;
            match = true;
            break;
        }
        return match;
    }

    private NpvPortPairCfg getNpvPair(Map<SwitchBase, Map<SwitchBase, NpvPortPairCfg>> lookupMap, SwitchBase device, SwitchBase core) {
        NpvPortPairCfg result = null;
        Map<SwitchBase, NpvPortPairCfg> corePairMap = lookupMap.get(device);
        if (corePairMap != null) {
            result = corePairMap.get(core);
        }
        return result;
    }

    private void addNpvPairToLookupMap(Map<SwitchBase, Map<SwitchBase, NpvPortPairCfg>> lookupMap, SwitchBase device, SwitchBase core, NpvPortPairCfg pair) {
        Map<Object, Object> corePairMap = null;
        if (lookupMap.containsKey(device)) {
            corePairMap = lookupMap.get(device);
        } else {
            corePairMap = new HashMap();
            lookupMap.put(device, corePairMap);
        }
        corePairMap.put(core, pair);
    }

    private List<FcPortBase> getCorePortsFromFreePorts(List<FcPortBase> freePortsCore, int numberNPPorts) {
        ArrayList<FcPortBase> resultingPorts = new ArrayList<FcPortBase>();
        if (numberNPPorts > freePortsCore.size()) {
            return null;
        }
        while (freePortsCore.size() > 0 && resultingPorts.size() < numberNPPorts) {
            FcPortBase nextFreePort = freePortsCore.get(0);
            resultingPorts.add(nextFreePort);
            freePortsCore.remove(nextFreePort);
        }
        return resultingPorts;
    }

    private List<FcPortBase> getNPPortsFromFreePorts(int[] preferredPorts, List<FcPortBase> freePorts, int totalNPPortCount, boolean otherPortAllowed) {
        ArrayList<FcPortBase> resultingPorts = new ArrayList<FcPortBase>();
        int maxPass = 4;
        if (!otherPortAllowed) {
            maxPass = 0;
        }
        for (int pass = 0; pass <= 4; ++pass) {
            for (int i = 0; i < preferredPorts.length; ++i) {
                int nextPref = preferredPorts[i];
                nextPref += pass;
                for (int f = 0; f < freePorts.size(); ++f) {
                    FcPortBase nextFreePort = freePorts.get(f);
                    int port = IfIndexUtil.ifIndex2Port(nextFreePort.getIfIndex()) + 1;
                    if (port != nextPref) continue;
                    resultingPorts.add(nextFreePort);
                    freePorts.remove(nextFreePort);
                    break;
                }
                if (resultingPorts.size() == totalNPPortCount) break;
            }
            if (resultingPorts.size() == totalNPPortCount) break;
        }
        return resultingPorts;
    }

    private void addSwitchToMap(Map<SwitchBase, List<SwitchBase>> pairedSwitches, SwitchBase swDevice, SwitchBase swCore) {
        List<SwitchBase> connSw = pairedSwitches.get(swDevice);
        if (connSw == null) {
            connSw = new ArrayList<SwitchBase>();
            pairedSwitches.put(swDevice, connSw);
        }
        if (!connSw.contains(swCore)) {
            connSw.add(swCore);
        }
    }
}

