/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.san.wo.AliasDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneSetDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfEndDeviceDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfSwitchZoneModeDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfZnZoneMemberDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnVsancliDO;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.WebZoneDataCache;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneData;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.WebZoneRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.zone.PolicyBasedZoning;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WebZoneManagerImpl
implements WebZoneRif {
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    public static int ALIAS_FORMAT_MEMBER = 50;

    @Override
    public WebConfEndDeviceDO[] getAvailableEndPorts(int cacheKey, long fabricDBID, int vsanId, int filterType, String filtPattern, int startIndex, int recodSize) throws RemoteException {
        WebConfEndDeviceDO[] eDo = new WebConfEndDeviceDO[]{};
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        ArrayList webZnMems = new ArrayList();
        try {
            FabricPK fpk = FabricImpl.findFPKByDbId(fabricDBID);
            FabricImpl fImpl = SanManager.getInstance().findFabric(fpk);
            SwitchImpl swImpl = fImpl.findSwitch(znData.getSwitchPeer().getAddress());
            FabricBase fb = SanManager.getInstance().findFabric(fpk).getFabricBase(null);
            VsanImpl vBase = swImpl.getVsan((short)znData.getVsanId());
            List<EndPortImpl> mems = vBase.getEndPorts();
            ArrayList<WebConfEndDeviceDO> filteredDev = new ArrayList<WebConfEndDeviceDO>();
            if (mems != null) {
                for (int i = 0; i < mems.size(); ++i) {
                    EndPortImpl mm = mems.get(i);
                    EndPortBase ep = (EndPortBase)mm.getBaseObject();
                    WebConfEndDeviceDO edd = new WebConfEndDeviceDO();
                    edd = new WebConfEndDeviceDO();
                    edd.displayName = mm.getName();
                    if (filterType == 0 && filtPattern != null && filtPattern.trim().length() > 0 && !edd.displayName.matches(filtPattern)) continue;
                    edd.type = mm.isTarget() ? 2 : 1;
                    edd.fcid = EndPortBase.getFcIdAsString(ep.getFcId(vsanId));
                    edd.ifName = mm.getSwitch().getSysName() + " " + ep.getIfName();
                    edd.pWWN = mm.getPortWwn().toHexString(true);
                    filteredDev.add(edd);
                }
            }
            eDo = filteredDev.toArray(new WebConfEndDeviceDO[0]);
        }
        catch (SQLException ex) {
            _Logger.error((Object)("Failed to ger end port. " + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return eDo;
    }

    @Override
    public WebConfEndDeviceDO[] getAvailableDeviceAlias(int cacheKey, long fabricDBID, int vsanId, int filterType, String filtPattern, int startIndex, int recodSize) throws RemoteException {
        WebConfEndDeviceDO[] eDo = new WebConfEndDeviceDO[]{};
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        ArrayList webZnMems = new ArrayList();
        try {
            FabricPK fpk = FabricImpl.findFPKByDbId(fabricDBID);
            FabricImpl fImpl = SanManager.getInstance().findFabric(fpk);
            FcPortAlias[] mems = fImpl.getDeviceAliases();
            SwitchImpl swImpl = fImpl.findSwitch(znData.getSwitchPeer().getAddress());
            FabricBase fb = SanManager.getInstance().findFabric(fpk).getFabricBase(null);
            VsanImpl vBase = swImpl.getVsan((short)znData.getVsanId());
            ArrayList<WebConfEndDeviceDO> filteredDev = new ArrayList<WebConfEndDeviceDO>();
            if (mems != null) {
                for (int i = 0; i < mems.length; ++i) {
                    EndPortImpl mm = SanManager.getInstance().findEndPort(mems[i].getWwn(), fImpl.getPK());
                    if (!mm.isMemberOfVsan(vsanId)) continue;
                    EndPortBase ep = mm != null ? (EndPortBase)mm.getBaseObject() : null;
                    WebConfEndDeviceDO edd = new WebConfEndDeviceDO();
                    edd.displayName = (String)mems[i].getName();
                    if (filterType == 0 && filtPattern != null && filtPattern.trim().length() > 0 && !edd.displayName.matches(filtPattern)) continue;
                    int n = mm == null ? 2 : (edd.type = mm.isTarget() ? 2 : 1);
                    edd.fcid = mm == null ? "" : EndPortBase.getFcIdAsString(ep.getFcId(vsanId));
                    edd.ifName = mm == null ? "" : mm.getSwitch().getSysName() + " " + ep.getIfName();
                    edd.pWWN = mm == null ? "" : mm.getPortWwn().toHexString(true);
                    filteredDev.add(edd);
                }
            }
            eDo = filteredDev.toArray(new WebConfEndDeviceDO[0]);
        }
        catch (SQLException ex) {
            _Logger.error((Object)("Failed to ger end port. " + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return eDo;
    }

    @Override
    public WebConfSwitchZoneModeDO refreshZoningMode(int dbKey) throws RemoteException {
        WebConfSwitchZoneModeDO mode = new WebConfSwitchZoneModeDO();
        try {
            ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
            if (znData != null) {
                znData.refreshZoningMode();
                ZoneMode md = znData.getZoneMode();
                SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(znData.getSwitchPeer().getAddress());
                mode = new WebConfSwitchZoneModeDO();
                mode.operationMode = md.getMode();
                mode.ownerType = md.getOwnerType();
                mode.owner = md.getOwner();
                mode.vsanId = md.getVsan();
                mode.readFromPending = md.isReadFromPending();
                mode.lockingSwitch = md.getLockingSwitch() != null ? md.getLockingSwitch() : new byte[]{};
                mode.isEnhancedDAEnabled = znData.isEnhancedDeviceAliaseEnabled();
                mode.isSmartZoningEnabled = znData.getZoneCapability().isSmartZoningEnabled();
                mode.isLockedByAnotherUserOrSwitch = znData.isLockedByAnotherUserOrSwitch();
            }
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("refreshZoningMode failed:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return mode;
    }

    @Override
    public boolean isLocalActiveZonesetModified(int dbKey) throws RemoteException {
        WebConfSwitchZoneModeDO mode = new WebConfSwitchZoneModeDO();
        try {
            ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
            if (znData != null) {
                return znData.isActiveLocalModifiedActive();
            }
        }
        catch (Exception ex) {
            _Logger.info((Object)("isLocalActiveZonesetModified failed:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return false;
    }

    @Override
    public Object[] deletefcAliases(int cacheKey, String[] colName) throws RemoteException {
        if (colName == null || colName.length == 0) {
            throw new RemoteException("Please select a fcAlias.");
        }
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        AbstractZone[] az = new ZoneAlias[colName.length];
        for (int i = 0; i < colName.length; ++i) {
            az[i] = zoneData.findZoneAlias(colName[i]);
            if (az[i] != null) continue;
            throw new RemoteException("Selected element " + colName[i] + "is not available for deletion." + "Please retry after refreshing data");
        }
        return this.deleteAbstactZone(cacheKey, az);
    }

    @Override
    public ZoneDO createZone(int cacheKey, String zoneName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(zoneData.getSwitchPeer().getAddress());
            if (swImpl == null) {
                throw new SnmpException("Switch " + zoneData.getSwitchPeer() + " is not reachable.");
            }
            Zone zss = zoneData.createNewZone(null, zoneName, false, zoneData.getNextZoneId(), false, 1, false, false, swImpl.getSysUpTime());
            ZoneDO znDo = new ZoneDO();
            znDo.setIndex(zss.getZoneIndex());
            znDo.setName(zss.getZoneName());
            znDo.setZoneLastModtime(zss.getLastModifiedAsLong());
            return znDo;
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public AliasDO createFcAlias(int cacheKey, String fcAliasName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(zoneData.getSwitchPeer().getAddress());
            if (swImpl == null) {
                throw new SnmpException("Switch " + zoneData.getSwitchPeer() + " is not reachable.");
            }
            ZoneAlias zss = zoneData.createNewZoneAlias(null, fcAliasName, zoneData.getNextZoneAliasId(), swImpl.getSysUpTime());
            AliasDO znDo = new AliasDO();
            znDo.setIndex(zss.getZoneIndex());
            znDo.setName(zss.getZoneName());
            znDo.setZoneLastModtime(zss.getLastModifiedAsLong());
            return znDo;
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public Object[] getAvailableZonesToAddToZoneset(int cacheKey, String zoneSetName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            ZoneSet zs = zoneData.findZoneSet(zoneSetName);
            if (zs == null) {
                throw new SnmpException("Zoneset " + zoneSetName + " is not available");
            }
            ArrayList zsMems = zoneData.getZoneSetMembers(zs);
            return zoneData.getAvailableZones(zs, zsMems.toArray(new Zone[0]));
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean activateDeactivateZoneSet(int cacheKey, String zoneSetName, boolean activate) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(zoneData.getSwitchPeer().getAddress());
            if (swImpl == null) {
                throw new SnmpException("Switch " + zoneData.getSwitchPeer() + " is not reachable.");
            }
            SnmpPeer prr = swImpl.getPeer();
            if (prr == null) {
                throw new SnmpException("Switch " + zoneData.getSwitchPeer() + " is not reachable.");
            }
            zoneData.activateDeactivateZoneSet(prr, zoneSetName, activate);
            return true;
        }
        catch (Exception exx) {
            throw new RemoteException(exx.getMessage());
        }
    }

    @Override
    public Object[] getActivationDeactivationStatus(int cacheKey, boolean activate) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            Object[] ret = zoneData.getActivationDeactivationStatus(activate);
            if (ret != null && ret[0] != null && (Integer)ret[0] == 2) {
                if (activate) {
                    zoneData.fetchActiveZoneSet();
                } else {
                    zoneData.resetActiveZoneset();
                }
                zoneData.cacheActiveLocalZoneset(activate);
            }
            return ret;
        }
        catch (Exception exx) {
            throw new RemoteException(exx.getMessage());
        }
    }

    @Override
    public int getCommitStatus(int cacheKey) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            return zoneData.getCommitStatus();
        }
        catch (Exception exx) {
            throw new RemoteException(exx.getMessage());
        }
    }

    @Override
    public boolean commitZoneData(int cacheKey) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            zoneData.commitZones();
            return true;
        }
        catch (Exception exx) {
            throw new RemoteException(exx.getMessage());
        }
    }

    @Override
    public ZoneSetDO createZoneSet(int cacheKey, String zoneSetName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(zoneData.getSwitchPeer().getAddress());
            if (swImpl == null) {
                throw new SnmpException("Switch " + zoneData.getSwitchPeer() + " is not reachable.");
            }
            ZoneSet zss = zoneData.createNewZoneset(null, zoneSetName, zoneData.getNextZoneSetId(), swImpl.getSysUpTime());
            ZoneSetDO znDo = new ZoneSetDO();
            znDo.setIndex(zss.getZoneIndex());
            znDo.setName(zss.getZoneName());
            znDo.setZoneLastModtime(zss.getLastModifiedAsLong());
            return znDo;
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public Object[] deleteZoneSets(int cacheKey, String[] colName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        AbstractZone[] az = new ZoneSet[colName.length];
        for (int i = 0; i < colName.length; ++i) {
            az[i] = zoneData.findZoneSet(colName[i]);
            if (az[i] != null) continue;
            throw new RemoteException("Selected element " + colName[i] + "is not available for deletion." + "Please retry after refreshing data");
        }
        return this.deleteAbstactZone(cacheKey, az);
    }

    @Override
    public Object[] deleteZones(int cacheKey, String[] colName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        AbstractZone[] az = new Zone[colName.length];
        for (int i = 0; i < colName.length; ++i) {
            az[i] = zoneData.findZone(colName[i]);
            if (az[i] != null) continue;
            throw new RemoteException("Selected element " + colName[i] + "is not available for deletion." + "Please retry after refreshing data");
        }
        return this.deleteAbstactZone(cacheKey, az);
    }

    @Override
    public Object[] addZonesToZoneset(int dbKey, String[] zoneName, String zoneSetName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        ZoneSet az = zoneData.findZoneSet(zoneSetName);
        Object[] zn = new Zone[zoneName.length];
        for (int i = 0; i < zoneName.length; ++i) {
            zn[i] = zoneData.findZone(zoneName[i]);
        }
        try {
            zoneData.addMembers(zn, az, false, null);
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return new Object[]{Boolean.TRUE, "Successful addition of zones to" + az, zoneData.isActiveLocalModifiedActive(), zn};
    }

    @Override
    public Object[] addDevicesToAbstratZone(int dbKey, int[] devType, int parentType, int memType, String[] memId, String parent, long fabricDBID) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        if (memId == null) {
            throw new RemoteException("Please select members for addition.");
        }
        AbstractZone az = parentType == 2 ? zoneData.findZoneAlias(parent) : zoneData.findZone(parent);
        Object[] zn = new Object[memId.length];
        ArrayList<ZoneMember> zndomem = new ArrayList<ZoneMember>();
        for (int i = 0; i < memId.length; ++i) {
            byte[] memByteId = memType == 10 ? memId[i].getBytes() : SnmpString.fromHexString(memId[i], true);
            int index = zoneData.getNextZoneMemberId(parentType, az.getZoneIndex(), i);
            zn[i] = new ZoneMember(zoneData.getVsanId(), index, parentType, az.getZoneIndex(), memType, memByteId, null, -1, -1, devType[i]);
            zndomem.add((ZoneMember)zn[i]);
        }
        ArrayList<WebConfZnZoneMemberDO> webConfMem = this.getzoneMembersasWebZnDOList(fabricDBID, zoneData, zndomem, null);
        try {
            zoneData.addMembers(zn, az, false, null);
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return new Object[]{Boolean.TRUE, "Successful addition of zones to" + az, zoneData.isActiveLocalModifiedActive(), webConfMem.toArray(new WebConfZnZoneMemberDO[0])};
    }

    @Override
    public Object[] addMemberIdsToAbstratZone(int dbKey, int[] devType, int parentType, int[] memType, String[] memId, String parent, long fabricDBID) throws RemoteException {
        int i;
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        if (memId == null) {
            throw new RemoteException("Please select members for addition.");
        }
        AbstractZone az = parentType == 2 ? zoneData.findZoneAlias(parent) : zoneData.findZone(parent);
        Object[] zn = new Object[memId.length];
        ArrayList<ZoneMember> zndomem = new ArrayList<ZoneMember>();
        ArrayList<String> aliasMems = new ArrayList<String>();
        int j = 0;
        for (i = 0; i < memId.length; ++i) {
            byte[] memByteId = SnmpString.fromHexString(memId[i], true);
            if (memType[i] == ALIAS_FORMAT_MEMBER) {
                aliasMems.add(new String(memByteId));
                continue;
            }
            int index = zoneData.getNextZoneMemberId(parentType, az.getZoneIndex(), i);
            zn[j] = new ZoneMember(zoneData.getVsanId(), index, parentType, az.getZoneIndex(), memType[i], memByteId, null, -1, -1, devType[i]);
            zndomem.add((ZoneMember)zn[i]);
            ++j;
        }
        if (aliasMems.size() > 0) {
            for (i = 0; i < aliasMems.size(); ++i) {
                ZoneAlias zAl = zoneData.findZoneAlias(aliasMems.get(i).toString());
                if (zAl == null) continue;
                zn[j] = zAl;
            }
        }
        ArrayList<WebConfZnZoneMemberDO> webConfMem = this.getzoneMembersasWebZnDOList(fabricDBID, zoneData, zndomem, null);
        try {
            zoneData.addMembers(zn, az, false, null);
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return new Object[]{Boolean.TRUE, "Successful addition of zones to" + az, zoneData.isActiveLocalModifiedActive(), webConfMem.toArray(new WebConfZnZoneMemberDO[0])};
    }

    @Override
    public Object[] deleteZoneFromZoneset(int dbKey, String[] zoneName, String zoneSetName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        ZoneSet az = zoneData.findZoneSet(zoneSetName);
        AbstractZone[] parent = new ZoneSet[zoneName.length];
        AbstractZone[] zn = new Zone[zoneName.length];
        for (int i = 0; i < zoneName.length; ++i) {
            parent[i] = az;
            zn[i] = zoneData.findZone(zoneName[i]);
        }
        return this.deleteZoneOrAlisMember(zoneData, parent, zn);
    }

    @Override
    public Object[] deleteFCAliasFromZone(int dbKey, String[] aliasName, String zoneName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        Zone az = zoneData.findZone(zoneName);
        AbstractZone[] parent = new Zone[aliasName.length];
        AbstractZone[] zn = new ZoneAlias[aliasName.length];
        for (int i = 0; i < aliasName.length; ++i) {
            parent[i] = az;
            zn[i] = zoneData.findZoneAlias(aliasName[i]);
        }
        return this.deleteZoneOrAlisMember(zoneData, parent, zn);
    }

    @Override
    public Object[] deleteMemberFromZone(int dbKey, int[] memberIndex, String zoneName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        Zone az = zoneData.findZone(zoneName);
        AbstractZone[] parent = new Zone[memberIndex.length];
        AbstractZone[] zn = new ZoneMember[memberIndex.length];
        for (int i = 0; i < memberIndex.length; ++i) {
            parent[i] = az;
            zn[i] = zoneData.findZoneMember(memberIndex[i], 1, az.getZoneIndex());
        }
        return this.deleteZoneOrAlisMember(zoneData, parent, zn);
    }

    @Override
    public Object[] deleteMemberFromAlias(int dbKey, int[] memberIndex, String aliasName) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        ZoneAlias az = zoneData.findZoneAlias(aliasName);
        AbstractZone[] parent = new ZoneAlias[memberIndex.length];
        AbstractZone[] zn = new ZoneMember[memberIndex.length];
        for (int i = 0; i < memberIndex.length; ++i) {
            parent[i] = az;
            zn[i] = zoneData.findZoneMember(memberIndex[i], 2, az.getZoneIndex());
        }
        return this.deleteZoneOrAlisMember(zoneData, parent, zn);
    }

    private Object[] deleteAbstactZone(int cacheKey, AbstractZone[] zs) throws RemoteException {
        ZoneData zoneData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            zoneData.delete(null, zs);
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return new Object[]{Boolean.TRUE, "Successful deletion of " + zs, zoneData.isActiveLocalModifiedActive()};
    }

    private Object[] deleteZoneOrAlisMember(ZoneData zoneData, AbstractZone[] parentZn, AbstractZone[] zs) throws RemoteException {
        if (zoneData == null) {
            throw new RemoteException("Zone Data Cahce not available. Zone Discovery May have failed.");
        }
        try {
            zoneData.delete(parentZn, zs);
        }
        catch (SnmpException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return new Object[]{Boolean.TRUE, "Successful deletion of " + zs[0] + (zs.length > 0 ? "..." : ""), zoneData.isActiveLocalModifiedActive()};
    }

    @Override
    public int populateZoneData(int dbKey, String switchKey, int vsanId) throws RemoteException {
        int newKey = dbKey;
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        try {
            Object[] swData = this.getSwitchPeer(switchKey);
            VersionPeer verPr = (VersionPeer)swData[2];
            if (znData == null) {
                znData = new ZoneData();
                znData.setVsanSwitch(verPr, vsanId, null);
                WebZoneDataCache wbZnCh = new WebZoneDataCache(znData, verPr.getSwitchPeer().getAddress().getHostAddress(), vsanId);
                newKey = WebZoneDataCache.createNewCachedObjectMap(wbZnCh);
            }
            znData.populateZoneData(false);
            WebZoneDataCache.getCachedObject(dbKey).setDiscoveredZones(true);
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("populateZoneData failed:" + ex.getMessage()));
        }
        return newKey;
    }

    @Override
    public int populateZoneSetData(int dbKey, String switchKey, int vsanId) throws RemoteException {
        int newKey = dbKey;
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        try {
            Object[] swData = this.getSwitchPeer(switchKey);
            VersionPeer verPr = (VersionPeer)swData[2];
            if (znData == null) {
                znData = new ZoneData();
                znData.setVsanSwitch(verPr, vsanId, null);
                WebZoneDataCache wbZnCh = new WebZoneDataCache(znData, verPr.getSwitchPeer().getAddress().getHostAddress(), vsanId);
                newKey = WebZoneDataCache.createNewCachedObjectMap(wbZnCh);
            }
            znData.populateZoneZoneSetData(false);
            WebZoneDataCache.getCachedObject(dbKey).setDiscoveredZonesets(true);
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("populateZoneSetData failed:" + ex.getMessage()));
        }
        return newKey;
    }

    @Override
    public int populatefcAliasData(int dbKey, String switchKey, int vsanId) throws RemoteException {
        int newKey = dbKey;
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        try {
            Object[] swData = this.getSwitchPeer(switchKey);
            VersionPeer verPr = (VersionPeer)swData[2];
            if (znData == null) {
                znData = new ZoneData();
                znData.setVsanSwitch(verPr, vsanId, null);
                WebZoneDataCache wbZnCh = new WebZoneDataCache(znData, verPr.getSwitchPeer().getAddress().getHostAddress(), vsanId);
                newKey = WebZoneDataCache.createNewCachedObjectMap(wbZnCh);
            }
            znData.populatefcAliasData();
            WebZoneDataCache.getCachedObject(dbKey).setDiscoveredFCAliases(true);
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("populatefcAliasData failed:" + ex.getMessage()));
        }
        return newKey;
    }

    @Override
    public void populateZoneOrAliasMembers(int dbKey, String zn, boolean isZone) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        try {
            if (znData != null) {
                AbstractZone az;
                AbstractZone abstractZone = az = isZone ? znData.findZone(zn) : znData.findZoneAlias(zn);
                if (az != null) {
                    znData.populateZoneMemberDataForZone(false, az);
                    if (isZone) {
                        WebZoneDataCache.getCachedObject(dbKey).addMemDiscZone(zn);
                    } else {
                        WebZoneDataCache.getCachedObject(dbKey).areFcAliasMembersPopulated(zn);
                    }
                }
            }
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("populatefcAliasData failed:" + ex.getMessage()));
        }
    }

    @Override
    public int getVsan(int dbKey) {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        return znData != null ? znData.getVsanId() : -1;
    }

    @Override
    public ArrayList getZoneOrAliasMembers(int dbKey, String zn, boolean isZone) throws RemoteException {
        this.populateZoneOrAliasMembers(dbKey, zn, isZone);
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (znData != null) {
            AbstractZone az;
            boolean memsPopulated;
            boolean bl = memsPopulated = isZone ? WebZoneDataCache.getCachedObject(dbKey).areZoneMembersPopulated(zn) : WebZoneDataCache.getCachedObject(dbKey).areFcAliasMembersPopulated(zn);
            if (!memsPopulated) {
                this.populateZoneOrAliasMembers(dbKey, zn, isZone);
            }
            AbstractZone abstractZone = az = isZone ? znData.findZone(zn) : znData.findZoneAlias(zn);
            if (az != null) {
                return isZone ? znData.getZoneMembers((Zone)az) : znData.getAliasMembers((ZoneAlias)az);
            }
        }
        return null;
    }

    @Override
    public ArrayList getZoneSetZones(int dbKey, String zonesetName) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (znData == null) {
            return new ArrayList();
        }
        if (!WebZoneDataCache.getCachedObject(dbKey).isDiscoveredZones()) {
            try {
                znData.populateZoneData(false);
                WebZoneDataCache.getCachedObject(dbKey).setDiscoveredZones(true);
            }
            catch (SnmpException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        if (zonesetName.equalsIgnoreCase("All Zones")) {
            return znData.getZones();
        }
        ZoneSet zs = znData != null ? znData.findZoneSet(zonesetName) : null;
        return zs != null ? znData.getZoneSetMembers(zs) : new ArrayList();
    }

    @Override
    public ArrayList getFCAliasesOfZone(int dbKey, long fabricDBID, String zoneName) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (znData == null) {
            return new ArrayList();
        }
        if (!WebZoneDataCache.getCachedObject(dbKey).isDiscoveredFCAliases()) {
            try {
                znData.populatefcAliasData();
                WebZoneDataCache.getCachedObject(dbKey).setDiscoveredFCAliases(true);
            }
            catch (SnmpException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        if (zoneName.equalsIgnoreCase("All fcAliases")) {
            return znData.getAliases();
        }
        Zone zs = znData != null ? znData.findZone(zoneName) : null;
        return zs != null ? znData.getAliasMembersOfZone(zs) : null;
    }

    @Override
    public ArrayList getMemberOfZone(int cacheKey, long fabricDBID, String zoneName) throws RemoteException {
        boolean memsPopulated;
        Zone zs;
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        Zone zone = zs = znData != null ? znData.findZone(zoneName) : null;
        if (zs != null && !(memsPopulated = WebZoneDataCache.getCachedObject(cacheKey).areZoneMembersPopulated(zoneName))) {
            try {
                znData.populateZoneMemberDataForZone(false, zs);
                WebZoneDataCache.getCachedObject(cacheKey).addMemDiscZone(zoneName);
            }
            catch (SnmpException e) {
                _Logger.info((Object)e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
        ArrayList mems = zs != null ? ZoneData.getZoneMembersOnly(zs, znData.getZoneMembers()) : null;
        ArrayList aliasMems = zs != null ? znData.getAliasMembersOfZone(zs) : null;
        ArrayList<WebConfZnZoneMemberDO> webZnMems = mems != null ? this.getzoneMembersasWebZnDOList(fabricDBID, znData, mems, aliasMems) : null;
        return webZnMems;
    }

    private ArrayList<WebConfZnZoneMemberDO> getzoneMembersasWebZnDOList(long fabricDBID, ZoneData znData, ArrayList<ZoneMember> mems, ArrayList<ZoneAlias> aliasMems) {
        ArrayList<WebConfZnZoneMemberDO> webZnMems = new ArrayList<WebConfZnZoneMemberDO>();
        try {
            AbstractZone mm;
            int i;
            FabricPK fpk = FabricImpl.findFPKByDbId(fabricDBID);
            FabricImpl fImpl = SanManager.getInstance().findFabric(fpk);
            SwitchImpl swImpl = fImpl.findSwitch(znData.getSwitchPeer().getAddress());
            FabricBase fb = SanManager.getInstance().findFabric(fpk).getFabricBase(null);
            VsanBase vBase = (VsanBase)swImpl.getVsan((short)znData.getVsanId()).getBaseObject();
            if (mems != null) {
                for (i = 0; i < mems.size(); ++i) {
                    mm = mems.get(i);
                    byte[] id = ((ZoneMember)mm).getMemId();
                    boolean fcidFormat = ((ZoneMember)mm).getMemFormat() == 3;
                    boolean switchPortFormat = ((ZoneMember)mm).getMemFormat() == 7 || ((ZoneMember)mm).getMemFormat() == 4 || ((ZoneMember)mm).getMemFormat() == 2 || ((ZoneMember)mm).getMemFormat() == 6;
                    String disName = ZoneService.getZoneMemberName(fpk, vBase.getVsanPK(), ((ZoneMember)mm).getMemFormat(), ((ZoneMember)mm).getMemId(), ((ZoneMember)mm).getMemLunId()).toString();
                    EndPortBase ep = ZoneService.getEndPort(((ZoneMember)mm).getMemFormat(), ((ZoneMember)mm).getMemId(), vBase, fb);
                    FcPortAlias da = null;
                    if (ep == null && ((ZoneMember)mm).getMemFormat() == 10) {
                        da = fb.getDeviceAlias(new String(((ZoneMember)mm).getMemId()));
                    }
                    WebConfZnZoneMemberDO memDo = new WebConfZnZoneMemberDO();
                    memDo.devType = ((ZoneMember)mm).getDeviceType();
                    memDo.memId = SnmpString.toHexString(id);
                    if (ep != null) {
                        memDo.memFCIDSt = EndPortBase.getFcIdAsString(ep.getFcId(znData.getVsanId()));
                    } else if (fcidFormat && id != null) {
                        int fcIdNum = ((id[0] & 0xFF) << 16) + ((id[1] & 0xFF) << 8) + (id[2] & 0xFF);
                        memDo.memFCIDSt = EndPortBase.getFcIdAsString(fcIdNum);
                    }
                    if (da != null) {
                        memDo.memWWNStr = da.getWwn().toHexString(true);
                    }
                    if (ep != null) {
                        memDo.memWWNStr = ep.getPortWwn().toHexString(true);
                    } else if (((ZoneMember)mm).getMemFormat() == 1 && id != null && id.length == 8) {
                        memDo.memWWNStr = SnmpString.toHexString(id);
                    }
                    memDo.ifName = ep != null ? ep.getIfName() : (switchPortFormat ? disName : "");
                    memDo.memFormat = ((ZoneMember)mm).getMemFormat();
                    memDo.displayName = ep != null ? ep.getName() : (!switchPortFormat && !fcidFormat ? disName : "");
                    memDo.snmpIndex = ((ZoneMember)mm).getSnmpIndex();
                    webZnMems.add(memDo);
                }
            }
            if (aliasMems != null) {
                for (i = 0; i < aliasMems.size(); ++i) {
                    mm = aliasMems.get(i);
                    WebConfZnZoneMemberDO memDo = new WebConfZnZoneMemberDO();
                    memDo.memFormat = ALIAS_FORMAT_MEMBER;
                    memDo.displayName = mm.getZoneName();
                    memDo.snmpIndex = ((ZoneAlias)mm).getSnmpIndex();
                    webZnMems.add(memDo);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return webZnMems;
    }

    @Override
    public ArrayList getMemberOfFCAlias(int cacheKey, long fabricDBID, String fcAliasName) throws RemoteException {
        boolean memsPopulated;
        ZoneAlias zs;
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(cacheKey);
        ZoneAlias zoneAlias = zs = znData != null ? znData.findZoneAlias(fcAliasName) : null;
        if (zs != null && !(memsPopulated = WebZoneDataCache.getCachedObject(cacheKey).areFcAliasMembersPopulated(fcAliasName))) {
            try {
                znData.populateZoneMemberDataForZone(false, zs);
                WebZoneDataCache.getCachedObject(cacheKey).addMemberDiscFcAlias(fcAliasName);
            }
            catch (SnmpException e) {
                _Logger.info((Object)e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
        ArrayList mems = zs != null ? znData.getAliasMembers(zs) : null;
        ArrayList<WebConfZnZoneMemberDO> webZnMems = mems != null ? this.getzoneMembersasWebZnDOList(fabricDBID, znData, mems, null) : null;
        return webZnMems;
    }

    @Override
    public ArrayList getZoneSets(int dbKey) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (!WebZoneDataCache.getCachedObject(dbKey).isDiscoveredZonesets()) {
            try {
                znData.populateZoneZoneSetData(false);
                znData.fetchActiveZoneSet();
                znData.cacheActiveLocalZoneset(true);
                WebZoneDataCache.getCachedObject(dbKey).setDiscoveredZonesets(true);
            }
            catch (SnmpException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        return znData != null ? znData.getZonesets() : null;
    }

    @Override
    public ArrayList getZones(int dbKey) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (!WebZoneDataCache.getCachedObject(dbKey).isDiscoveredZones()) {
            try {
                znData.populateZoneData(false);
                WebZoneDataCache.getCachedObject(dbKey).setDiscoveredZones(true);
            }
            catch (SnmpException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        return znData != null ? znData.getZones() : null;
    }

    @Override
    public ArrayList getFcAliases(int dbKey) throws RemoteException {
        ZoneData znData = WebZoneDataCache.getCachedZoneDataObject(dbKey);
        if (znData == null) {
            return new ArrayList();
        }
        if (!WebZoneDataCache.getCachedObject(dbKey).isDiscoveredFCAliases()) {
            try {
                znData.populatefcAliasData();
                WebZoneDataCache.getCachedObject(dbKey).setDiscoveredFCAliases(true);
            }
            catch (SnmpException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        return znData != null ? znData.getAliases() : null;
    }

    @Override
    public void removeCachedObject(int dbKey) throws RemoteException {
        WebZoneDataCache.removeCachedObject(dbKey);
    }

    @Override
    public String showAllCache() throws RemoteException {
        return WebZoneDataCache.showAllCache();
    }

    @Override
    public int createEmptyCache(String switchKey, int vsanId) throws RemoteException {
        int newKey = -1;
        try {
            Object[] swData = this.getSwitchPeer(switchKey);
            VersionPeer verPr = (VersionPeer)swData[2];
            ZoneData znData = new ZoneData();
            znData.setVsanSwitch(verPr, vsanId, null);
            WebZoneDataCache wbZnCh = new WebZoneDataCache(znData, verPr.getSwitchPeer().getAddress().getHostAddress(), vsanId);
            newKey = WebZoneDataCache.createNewCachedObjectMap(wbZnCh);
        }
        catch (SnmpException ex) {
            _Logger.info((Object)("populatefcAliasData failed:" + ex.getMessage()));
        }
        return newKey;
    }

    public String getOwner(byte[] owner, int ownerType) {
        String ownerName = new String(owner);
        switch (ownerType) {
            case 3: {
                ownerName = SnmpString.toHexString(owner);
                break;
            }
            case 4: {
                ownerName = SnmpIpAddress.toString(owner);
                break;
            }
        }
        return ownerName;
    }

    @Override
    public WebZnVsancliDO updateZoneSwitchProperties(String swIpAddress, WebZnVsancliDO vDo) throws RemoteException {
        try {
            SnmpPeer peer;
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("zoneDbEnforcedEqualsLocal").getOid(), vDo.vsanIndex);
            vbl.add(MibNode.get("czseOperationMode").getOid(), vDo.vsanIndex);
            vbl.add(MibNode.get("czseSessionOwnerType").getOid(), vDo.vsanIndex);
            vbl.add(MibNode.get("czseSessionOwner").getOid(), vDo.vsanIndex);
            vbl.add(MibNode.get("zoneEnforcedZoneSetName").getOid(), vDo.vsanIndex);
            SwitchImpl swImpl = null;
            try {
                swImpl = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swIpAddress));
            }
            catch (UnknownHostException ex) {
                _Logger.error((Object)("Failed to find Switch " + swIpAddress));
            }
            SnmpPeer snmpPeer = peer = swImpl != null && swImpl.isManageable() && swImpl.getPeer() != null ? swImpl.getPeer() : null;
            if (peer != null) {
                VarBindList vbPut = SnmpFetch.get(peer, vbl).getVariables();
                SnmpVarBind sVar = vbPut.get(0);
                if (!sVar.isNull()) {
                    vDo.isActLocalEqualOnPrSw = sVar.intValue() == 1;
                }
                vDo.isEnhancedPrSw = !vbPut.get(1).isNull() && vbPut.intValue(1) == 2;
                int ownerType = vbPut.getVb(2).getVar().getType() != 5 ? vbPut.intValue(2) : -1;
                vDo.isLockedPrSw = ownerType != -1;
                vDo.owner = vDo.isLockedPrSw ? this.getOwner(vbPut.byteValue(3), ownerType) : "";
                vDo.actZnst = vbPut.getVb(4).getVar().getType() != 5 ? vbPut.stringValue(4) : "";
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        return vDo;
    }

    @Override
    public boolean isCliCmdFinished(int id, long fabricDBID) throws RemoteException {
        try {
            return PolicyBasedZoning.isCliCmdFinished(id, fabricDBID);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public int createRunCLIForZoning(WebZnVsancliDO cliData) throws RemoteException {
        try {
            return PolicyBasedZoning.createRunCLIForZoning(cliData);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public int runActivationCommitCmds(WebZnVsancliDO cliData) throws RemoteException {
        try {
            return PolicyBasedZoning.runActivationCommitCmds(cliData);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String getZoneActDeact(int id, long fabricDBID) throws RemoteException {
        try {
            return PolicyBasedZoning.getZoneActDeact(id, fabricDBID);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String getCLIResultForZoning(int id, long fabricDBID) throws RemoteException {
        try {
            return PolicyBasedZoning.getCLIResultForZoning(id, fabricDBID);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean cleanupCliRunID(int id) throws RemoteException {
        try {
            return PolicyBasedZoning.cleanupCliRunID(id);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    public static WebZoneRif getRemoteWebZoneRif(long fabricDBID) throws Exception {
        WebZoneRif encRif = null;
        EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
        String fedServer = ClusterProcessor.getInstance().getServerIpByFabricDBID(fabricDBID);
        boolean isLocal = NetUtil.isLocalHost(fedServer);
        _Logger.info((Object)("Local Server " + isLocal + ". Server for Fabric DBID:" + fabricDBID + " is" + (fedServer != null ? fedServer : "Unknown")));
        if (isLocal) {
            return rif.getWebZone();
        }
        if (fedServer != null) {
            encRif = (WebZoneRif)rif.getRemoteService(fedServer, System.getProperty("server.port", "4447"), "WebZoneBean", WebZoneRif.class.getName());
        }
        if (encRif == null) {
            _Logger.error((Object)("Unable to find the server for selected Fabric:" + fabricDBID));
            throw new Exception("Unable to find the server for selected Fabric:" + fabricDBID);
        }
        return encRif;
    }

    private Object[] getSwitchPeer(String switchKey) throws InvalidArgumentException {
        Wwn swWWN = new Wwn(switchKey);
        SwitchImpl swImpl = SanManager.getInstance().findSwitchByPK(new WwnKey(swWWN));
        if (swImpl == null) {
            throw new InvalidArgumentException("Switch not recognized WWN:" + switchKey);
        }
        if (!((SwitchBase)swImpl.getBaseObject()).isManageable()) {
            throw new InvalidArgumentException("Switch not manageble:" + swImpl);
        }
        SnmpPeer swPr = swImpl.getPeer();
        if (swPr == null) {
            throw new InvalidArgumentException("Switch not accessible " + swImpl);
        }
        VersionPeer verPeer = new VersionPeer(swPr, new SwitchVersion(swImpl.getVersion()), (IfIndexIf)((Object)swImpl.getBaseObject()), swImpl.getName(), swImpl.isManageable());
        return new Object[]{swPr, swImpl, verPeer};
    }
}

