/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.server.fc.FabricCheckTable;
import java.util.HashMap;

class FabricCheckCallHomeDestTable
extends FabricCheckTable {
    FabricCheckCallHomeDestTable() {
        this.setCreateVarBndFlag(true);
    }

    @Override
    public HashMap buildLastIndex(Array target) {
        HashMap<Integer, int[]> hm = new HashMap<Integer, int[]>();
        int MAXI = target.size();
        for (int i = 0; i < MAXI; ++i) {
            FabricCheckTable.SnmpRow row = (FabricCheckTable.SnmpRow)target.elementAt(i);
            hm.put(new Integer(row._index[0]), row._index);
        }
        return hm;
    }

    @Override
    public int[] getNewIndex(HashMap hm, FabricCheckTable.SnmpRow sRow) {
        int[] index = (int[])hm.get(new Integer(sRow._index[0]));
        if (null == index) {
            return super.getNewIndex(hm, sRow);
        }
        index[index.length - 1] = index[index.length - 1] + 1;
        return index;
    }

    @Override
    void appendSnmpRow(StringBuffer buffer, FabricCheckTable.SnmpRow sRow) {
        int MAXVR = sRow._vars.length;
        for (int vr = 0; vr < MAXVR; ++vr) {
            buffer.append(" " + sRow._vars[vr].getVar());
        }
    }

    @Override
    protected int findRow(FabricCheckTable.SnmpRow sRow, Array target) {
        FabricCheckTable.SnmpRow row = null;
        int category = sRow._index[0];
        int MAXI = target.size();
        for (int i = 0; i < MAXI; ++i) {
            row = (FabricCheckTable.SnmpRow)target.elementAt(i);
            if (category != row._index[0] || this.compareValue(sRow, row) != 0) continue;
            return i;
        }
        return -1;
    }

    final int compareValue(FabricCheckTable.SnmpRow src, FabricCheckTable.SnmpRow dest) {
        if (null == src && null == dest) {
            return 0;
        }
        if (null == src || null == dest) {
            return -1;
        }
        SnmpVarBind[] srcVrbnd = src._vars;
        SnmpVarBind[] destVrbnd = dest._vars;
        if (null != destVrbnd && null != srcVrbnd && destVrbnd.length == srcVrbnd.length) {
            int MAXI = srcVrbnd.length;
            for (int i = 0; i < MAXI; ++i) {
                SnmpString destVar;
                SnmpString srcVar = (SnmpString)srcVrbnd[i].getVar();
                if (srcVar.equals(destVar = (SnmpString)destVrbnd[i].getVar())) continue;
                return -1;
            }
        } else {
            return -1;
        }
        return 0;
    }
}

