/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.fc.CheckData;
import com.cisco.dcbu.sm.server.fc.FabricCheckTable;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

class FabricCheckPChannel
extends FabricCheckTable {
    HashMap _peerPCLst = new HashMap();
    SnmpPeer[] _peerLst;

    FabricCheckPChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd, FabricPK fpk) throws SnmpException {
        Object swImpl;
        String[] attrs = chkAttrs._attrs;
        this._data = data;
        this._attrName = category;
        this._rndr = chkAttrs._rndr;
        this._peers = peers;
        this._enums = new MibEnum[attrs.length][];
        this._peerPCLst.clear();
        FabricImpl fImpl = this.getFabricImpl(peers, fpk);
        if (fImpl != null && (swImpl = fImpl.getSwitches()) != null) {
            ArrayList<SnmpPeer> peersLst = new ArrayList<SnmpPeer>();
            for (int k = 0; k < ((SwitchImpl[])swImpl).length; ++k) {
                if (swImpl[k].getPeer() == null) continue;
                peersLst.add(swImpl[k].getPeer());
            }
            this._peerLst = peersLst.toArray(new SnmpPeer[peersLst.size()]);
        }
        if (this._peerLst == null) {
            return;
        }
        this._numReqs = this._peerLst.length;
        this.getData(attrs);
        try {
            swImpl = this._data;
            synchronized (swImpl) {
                this._data.wait(24000L);
            }
        }
        catch (Exception ex) {
            _Logger.debug((Object)"Wait broken");
        }
        this.populateDiscrepancyTable();
    }

    void getPchnlAndIslList(ArrayList pchnlLst, ArrayList isllst) {
        FabricImpl fa = SanManager.getInstance().findFabric(this._peerLst[0].getAddress());
        for (IslImpl lk : fa.getIsls()) {
            SwitchImpl swA = lk.getSwitch1();
            SwitchImpl swB = lk.getSwitch1();
            int prtTo = lk.getIfIndex2();
            if (swB.getPeer() == null || swA.getPeer() == null || prtTo == 0) continue;
            if (lk.isPortChannel()) {
                pchnlLst.add(lk);
                continue;
            }
            isllst.add(lk);
        }
    }

    protected void populateDiscrepancyTable() {
        ArrayList islList = new ArrayList();
        ArrayList pchnlLst = new ArrayList();
        this.getPchnlAndIslList(pchnlLst, islList);
        this.testPortChannels(pchnlLst);
        this.testIsls(islList);
    }

    void testPortChannels(ArrayList pchnlLst) {
        Iterator itr = this._peerPCLst.entrySet().iterator();
        while (itr.hasNext()) {
            StringBuffer info = new StringBuffer();
            Map.Entry obEntry = itr.next();
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            ArrayList arPc = (ArrayList)obEntry.getValue();
            Iterator itrPc = arPc.iterator();
            block1: while (itrPc.hasNext()) {
                PortChannel pc1 = (PortChannel)itrPc.next();
                if (pc1._memPortIndex == null || pc1._memPortIndex.length == 0) {
                    info.append(this.buildPchnlInfo(obHmKey, pc1, null, null, info.length() == 0 ? "No members " : ""));
                    itrPc.remove();
                    continue;
                }
                int MAXPCH = pchnlLst.size();
                for (int pch = 0; pch < MAXPCH; ++pch) {
                    IslImpl pchLk = (IslImpl)pchnlLst.get(pch);
                    SwitchImpl swA = pchLk.getSwitch1();
                    SwitchImpl swB = pchLk.getSwitch2();
                    if (!swA.isManageableMDS() || !swB.isManageableMDS()) continue;
                    int pchnlPrtB = pchLk.getIfIndex2();
                    int srcPrtchnlIndex = -1;
                    int dstPrtchnlIndex = -1;
                    SwitchImpl dest = null;
                    if (swA.getPeer().getAddress().equals(obHmKey.getAddress())) {
                        srcPrtchnlIndex = pchLk.getIfIndex1() - 0x4000000 + 1;
                        if (srcPrtchnlIndex != pc1._index) continue;
                        dest = swB;
                        dstPrtchnlIndex = pchnlPrtB;
                    } else {
                        if (!swB.getPeer().getAddress().equals(obHmKey.getAddress()) || (srcPrtchnlIndex = pchnlPrtB - 0x4000000 + 1) != pc1._index) continue;
                        dest = swA;
                        dstPrtchnlIndex = pchLk.getIfIndex1();
                    }
                    PortChannel pchDest = this.getPortChannel(dest.getPeer(), dstPrtchnlIndex);
                    if (pchDest == null || pchDest._memPortIndex.length != pc1._memPortIndex.length) {
                        StringBuffer info1 = new StringBuffer();
                        info1.append(this.buildPchnlInfo(obHmKey, pc1, dest.getPeer(), pchDest, "Member count differs"));
                        this.addData(obHmKey, false, this._attrName, info1.toString(), null);
                    }
                    if (null != pchDest) {
                        this.removePChnl(dest.getPeer(), pchDest);
                    }
                    itrPc.remove();
                    continue block1;
                }
            }
            if (info.length() <= 0) continue;
            this.addData(obHmKey, false, this._attrName, info.toString(), null);
        }
    }

    void testIsls(ArrayList islList) {
        for (Map.Entry obEntry : this._peerPCLst.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            ArrayList arPc = (ArrayList)obEntry.getValue();
            Iterator itrPc = arPc.iterator();
            while (itrPc.hasNext()) {
                PortChannel pc1 = (PortChannel)itrPc.next();
                StringBuffer info = this.buildPchnlInfo(obHmKey, pc1, null, null, "No members");
                if (pc1._memPortIndex == null || pc1._memPortIndex.length == 0) {
                    this.addData(obHmKey, false, this._attrName, info.toString(), null);
                    itrPc.remove();
                    continue;
                }
                int mem = 0;
                int MAXMEM = pc1._memPortIndex.length;
                if (mem >= MAXMEM) continue;
                PortChannel pchnl2 = null;
                SnmpPeer otherPeer = null;
                int MAXLNK = islList.size();
                for (int lnk = 0; lnk < MAXLNK; ++lnk) {
                    IslImpl lk = (IslImpl)islList.get(lnk);
                    SwitchImpl swA = lk.getSwitch1();
                    SwitchImpl swB = lk.getSwitch2();
                    if (swB.getPeer() == null || swA.getPeer() == null) continue;
                    int otherIndex = -1;
                    otherPeer = swB.getPeer();
                    int prtTo = lk.getIfIndex2();
                    if (0 != prtTo) {
                        otherIndex = prtTo;
                    }
                    if (swA.getPeer().getAddress().equals(obHmKey.getAddress()) && lk.getIfIndex1() != pc1._memPortIndex[mem]) continue;
                    if (swB.getPeer().getAddress().equals(obHmKey.getAddress())) {
                        if (prtTo != pc1._memPortIndex[mem]) continue;
                        otherPeer = swA.getPeer();
                        otherIndex = lk.getIfIndex1();
                    }
                    if (otherPeer == null) continue;
                    pchnl2 = this.getPortChannel(otherPeer, otherIndex);
                    break;
                }
                String msgIsl = "Member count differs";
                if (pchnl2 != null && pchnl2._memPortIndex.length != pc1._memPortIndex.length) {
                    StringBuffer info1 = new StringBuffer();
                    info1.append(this.buildPchnlInfo(obHmKey, pc1, otherPeer, pchnl2, msgIsl));
                    this.addData(obHmKey, false, this._attrName, info1.toString(), null);
                }
                if (null != pchnl2) {
                    this.removePChnl(otherPeer, pchnl2);
                }
                itrPc.remove();
            }
        }
    }

    StringBuffer buildPchnlInfo(SnmpPeer peer1, PortChannel pch1, SnmpPeer peer2, PortChannel pch2, String prefix) {
        int i;
        int MAXI;
        StringBuffer buf = new StringBuffer(prefix);
        if (null != pch1) {
            buf.append(", channel " + pch1._index);
            if (null != pch1._memPortIndex && pch1._memPortIndex.length > 0) {
                buf.append(" ports:");
                MAXI = pch1._memPortIndex.length;
                for (i = 0; i < MAXI; ++i) {
                    if (0 == i) {
                        buf.append(SanManager.getInstance().findSwitchByIP(peer1.getAddress()).ifIndexToName(pch1._memPortIndex[i]));
                        continue;
                    }
                    buf.append(", " + SanManager.getInstance().findSwitchByIP(peer1.getAddress()).ifIndexToName(pch1._memPortIndex[i]));
                }
            }
        }
        if (null != pch2) {
            buf.append(" " + peer2);
            buf.append(", channel " + pch2._index);
            if (null != pch2._memPortIndex && pch2._memPortIndex.length > 0) {
                buf.append(" ports:");
                MAXI = pch2._memPortIndex.length;
                for (i = 0; i < MAXI; ++i) {
                    if (0 == i) {
                        buf.append(SanManager.getInstance().findSwitchByIP(peer2.getAddress()).ifIndexToName(pch2._memPortIndex[i]));
                        continue;
                    }
                    buf.append(", " + SanManager.getInstance().findSwitchByIP(peer2.getAddress()).ifIndexToName(pch2._memPortIndex[i]));
                }
            }
        }
        return buf;
    }

    @Override
    void handleCallBack(SnmpPeer peer, SnmpPDU pdu) {
        VarBindList val = pdu.getVariables();
        int MAXI = val.size();
        for (int i = 0; i < MAXI; ++i) {
            SnmpString memLst;
            SnmpVarBind vbnd = val.getVb(i);
            int[] oid = vbnd.getOid().getValue();
            int[] prtLst = null;
            if (!(vbnd.getVar() instanceof SnmpNull) && null != (memLst = (SnmpString)vbnd.getVar()).getValue()) {
                prtLst = SnmpIntList.valueOf(memLst.getValue());
            }
            PortChannel pch = new PortChannel();
            pch._memPortIndex = prtLst;
            pch._index = oid[oid.length - 1];
            Object ob = this._peerPCLst.get(peer);
            if (null != ob) {
                ArrayList lst = (ArrayList)ob;
                lst.add(pch);
                this._peerPCLst.put(peer, lst);
                continue;
            }
            ArrayList<PortChannel> arLst = new ArrayList<PortChannel>();
            arLst.add(pch);
            this._peerPCLst.put(peer, arLst);
        }
    }

    protected void getData(String[] attrs) throws SnmpException {
        Array<int[]> arOid = new Array<int[]>();
        for (int i = 0; i < attrs.length; ++i) {
            MibNode node = MibNode.get(attrs[i]);
            this._enums[i] = node.getEnums();
            int[] oid = node.getOid();
            arOid.addElement(oid);
        }
        int MAXPRS = this._peerLst.length;
        for (int prs = 0; prs < MAXPRS; ++prs) {
            VarBindList request = new VarBindList();
            if (this._peerLst[prs] == null) continue;
            int MAXOID = arOid.size();
            for (int oids = 0; oids < MAXOID; ++oids) {
                int[] oid = (int[])arOid.elementAt(oids);
                request.add(new SnmpVarBind(new SnmpOID(oid)));
            }
            new SnmpFetch().getBulk(this._peerLst[prs], request, (SnmpCallbackIf)this);
        }
    }

    void removePChnl(SnmpPeer peer, PortChannel pchnlRef) {
        Object ob = this._peerPCLst.get(peer);
        if (null == ob) {
            return;
        }
        ArrayList arLst = (ArrayList)ob;
        int MAXI = arLst.size();
        for (int i = 0; i < MAXI; ++i) {
            PortChannel pchnl = (PortChannel)arLst.get(i);
            if (pchnlRef._index != pchnl._index) continue;
            arLst.remove(i);
            break;
        }
    }

    PortChannel getPortChannel(SnmpPeer peer, int ifIndex) {
        Object ob;
        boolean bPchIndex = false;
        if (IfIndexUtil.getType(ifIndex) == 4) {
            bPchIndex = true;
        }
        if (null == (ob = this._peerPCLst.get(peer))) {
            return null;
        }
        ArrayList arLst = (ArrayList)ob;
        if (bPchIndex) {
            int pcIndex = ifIndex - 0x4000000 + 1;
            int MAXI = arLst.size();
            for (int i = 0; i < MAXI; ++i) {
                PortChannel pchnl = (PortChannel)arLst.get(i);
                if (pchnl._index != pcIndex) continue;
                return pchnl;
            }
        } else {
            int MAXI = arLst.size();
            for (int i = 0; i < MAXI; ++i) {
                PortChannel pchnl = (PortChannel)arLst.get(i);
                int MAXPRT = pchnl._memPortIndex.length;
                for (int prt = 0; prt < MAXPRT; ++prt) {
                    if (pchnl._memPortIndex[prt] != ifIndex) continue;
                    return pchnl;
                }
            }
        }
        return null;
    }

    class PortChannel {
        int _index;
        int[] _memPortIndex;

        PortChannel() {
        }
    }
}

