/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.hostredundancy;

import java.io.Serializable;
import java.util.Calendar;

public class HostRedundancyError
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int SINGLE_PATH = 1;
    public static final int ZONED_TO_DOWN_STORAGE = 2;
    public static final int ZONED_TO_DOWN_HOST_HBA = 3;
    public static final int ZONED_TO_MISMATCH_VSAN_STORAGE = 4;
    public static final int STORAGE_ONLY_IN_ONE_OF_HOSTS_ZONED_PATHS = 5;
    public static final int ZONED_TO_VCENTER_MISSING_STORAGE = 6;
    public static final int NP_ZONED_TO_DOWN_STORAGE = 7;
    public static final int NP_ZONED_TO_DOWN_HOST_HBA = 8;
    public static final int NP_ZONED_TO_MISMATCH_VSAN_STORAGE = 9;
    public static final int MISMATCH_LUNS = 10;
    public static final int NON_REDUNDANT_SWITCH_LINECARD = 11;
    public static final long NON_STORAGE_ENCLOSURE_EVENT = -1L;
    public static final int WARNING = 0;
    public static final int SEVERE = 1;
    public static final String NO_ZONE_REDUNDANCY_FIX = " Add other host ports to the zoning configuration similiar to the existing zoned port";
    public static final String ZONED_TO_DOWN_STORAGE_FIX = " Bring the storage port back online, either by enabling the port or fixing any conflict.";
    public static final String ZONED_TO_DOWN_HOST_HBA_FIX = " Bring the host port back online, either by enabling the port or fixing any conflict.";
    public static final String ZONED_TO_MISMATCH_VSAN_STORAGE_FIX = " Fix the VSAN segmentation or reassign the VSAN for the storage port to be the same as the host port";
    public static final String ZONED_TO_VCENTER_MISSING_STORAGE_FIX = " Add zoning for the storage configured in VCenter into the active zone database.";
    public static final String STORAGE_ONLY_IN_ONE_OF_HOSTS_ZONED_PATHS_FIX = " Add zoning of a second port for the storage enclosure to the host ports into the active zoning database.";
    public static final String MISMATCHED_LUNS_FIX = "Changed the storage LUN masking to expose the same LUNs thru both storage ports that the host is zoned to";
    public static final String NON_REDUNDANT_SWITCH_FIX = "Move one of the host port connections to another switch or linecard.";
    public static final String UNKNOWN_FIX = null;
    public static final String NO_ZONE_REDUNDANCY_STR = " Host enclosure only has one port zoned.";
    public static final String ZONED_TO_DOWN_STORAGE_STR = " Host enclosure port zoned to down storage port.";
    public static final String ZONED_TO_DOWN_HOST_HBA_STR = " Host enclosure port down.";
    public static final String ZONED_TO_MISMATCH_VSAN_STORAGE_STR = " Host enclosure port(s) zoned to storage in different or segmented VSANs.";
    public static final String STORAGE_ONLY_IN_ONE_OF_HOSTS_ZONED_PATHS_STR = " Storage enclosure only has one zoned port to the host.";
    public static final String ZONED_TO_VCENTER_MISSING_STORAGE_STR = " Host has storage configured in VCenter but not in active zones.";
    public static final String NP_ZONED_TO_DOWN_STORAGE_STR = "Severe - Host has no path to storage: Host enclosure port zoned to down storage port.";
    public static final String NP_ZONED_TO_DOWN_HOST_HBA_STR = "Severe - Host has no path to storage: Host enclosure port down.";
    public static final String NP_ZONED_TO_MISMATCH_VSAN_STORAGE_STR = "Severe - Host has no path to storage: Host enclosure port(s) zoned to storage in different or segmented vsans.";
    public static final String MISMATCHED_LUNS_STR = "Host paths do not have the same LUNs exposed on each path";
    public static final String NON_REDUNDANT_SWITCH_STR = "Host is connected to same linecard/switch. Single point of failure";
    public static final String UNKNOWN_STR = " Other reason.";
    public static final String[] ERROR_STR_TRANSLATION = new String[]{" Other reason.", " Host enclosure only has one port zoned.", " Host enclosure port zoned to down storage port.", " Host enclosure port down.", " Host enclosure port(s) zoned to storage in different or segmented VSANs.", " Storage enclosure only has one zoned port to the host.", " Host has storage configured in VCenter but not in active zones.", "Severe - Host has no path to storage: Host enclosure port zoned to down storage port.", "Severe - Host has no path to storage: Host enclosure port down.", "Severe - Host has no path to storage: Host enclosure port(s) zoned to storage in different or segmented vsans.", "Host paths do not have the same LUNs exposed on each path", "Host is connected to same linecard/switch. Single point of failure"};
    public static final String[] FIX_STR_TRANSLATION = new String[]{UNKNOWN_FIX, " Add other host ports to the zoning configuration similiar to the existing zoned port", " Bring the storage port back online, either by enabling the port or fixing any conflict.", " Bring the host port back online, either by enabling the port or fixing any conflict.", " Fix the VSAN segmentation or reassign the VSAN for the storage port to be the same as the host port", " Add zoning of a second port for the storage enclosure to the host ports into the active zoning database.", " Add zoning for the storage configured in VCenter into the active zone database.", " Bring the storage port back online, either by enabling the port or fixing any conflict.", " Bring the host port back online, either by enabling the port or fixing any conflict.", " Fix the VSAN segmentation or reassign the VSAN for the storage port to be the same as the host port", "Changed the storage LUN masking to expose the same LUNs thru both storage ports that the host is zoned to", "Move one of the host port connections to another switch or linecard."};
    int logical_server_id;
    String server_str;
    long host_enclosure_id;
    String host_enclosure_str;
    long storage_enclosure_id = -1L;
    String storage_enclosure_str;
    String storage_str;
    int error_id;
    Calendar first_seen;
    int severity;

    public HostRedundancyError(int logicalServerId, String serverStr, long hostEnclosureId, String hostEnclosureStr, long storageEnclosureId, String storageEnclosureStr, String storageStr, int errorId, Calendar firstSeen, int severity) {
        this.logical_server_id = logicalServerId;
        this.server_str = serverStr;
        this.host_enclosure_id = hostEnclosureId;
        this.host_enclosure_str = hostEnclosureStr;
        this.storage_enclosure_id = storageEnclosureId;
        this.storage_enclosure_str = storageEnclosureStr;
        this.storage_str = storageStr;
        this.error_id = errorId;
        this.first_seen = firstSeen;
        this.severity = severity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.host_enclosure_id ^ this.host_enclosure_id >>> 32);
        result = 31 * result + this.logical_server_id;
        result = 31 * result + (int)(this.storage_enclosure_id ^ this.storage_enclosure_id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostRedundancyError other = (HostRedundancyError)obj;
        if (this.host_enclosure_id != other.host_enclosure_id) {
            return false;
        }
        if (this.logical_server_id != other.logical_server_id) {
            return false;
        }
        return this.storage_enclosure_id == other.storage_enclosure_id;
    }

    public int getLogical_server_id() {
        return this.logical_server_id;
    }

    public Long getHost_enclosure_id() {
        return this.host_enclosure_id;
    }

    public Long getStorage_enclosure_id() {
        return this.storage_enclosure_id;
    }

    public String getStorage_str() {
        return this.storage_str;
    }

    public int getError_id() {
        return this.error_id;
    }

    public Calendar getFirst_seen() {
        return this.first_seen;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getServer_str() {
        return this.server_str;
    }

    public String getHost_enclosure_str() {
        return this.host_enclosure_str;
    }

    public String getStorage_enclosure_str() {
        return this.storage_enclosure_str;
    }

    public String getErrorString() {
        return HostRedundancyError.getErrorString(this.error_id);
    }

    public String getFixString() {
        return HostRedundancyError.getFixString(this.error_id);
    }

    public static String getFixString(int id) {
        try {
            return FIX_STR_TRANSLATION[id];
        }
        catch (Exception e) {
            return "Unknown error";
        }
    }

    public static String getErrorString(int id) {
        try {
            return ERROR_STR_TRANSLATION[id];
        }
        catch (Exception e) {
            return "Unknown error";
        }
    }
}

