/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.ScheduledTask;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.InventoryChangeEvent;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.InventoryPersistent;
import com.cisco.dcbu.sm.server.inventory.EthSwitchInventoryWorker;
import com.cisco.dcbu.sm.server.inventory.InventoryEventListenerIf;
import com.cisco.dcbu.sm.server.inventory.NEInventoryNode;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorker;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorkerIf;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class InventoryManager
implements ModelEventListenerIf {
    private static InventoryManager _Instance;
    public static final int TYPE_CARD = 1;
    public static final int TYPE_FAN = 2;
    public static final int TYPE_POWER = 4;
    public static final int TYPE_SENSOR = 8;
    public static final int TYPE_PORT = 16;
    public static final int TYPE_HW = 31;
    public static final int TYPE_SW = 32;
    public static final int TYPE_LIC = 64;
    public static final int TYPE_HBA = 128;
    public static final int TYPE_LUN0 = 256;
    public static final int TYPE_SSMFEATURE = 512;
    public static final int TYPE_ALL = 65535;
    public static final int TYPE_ALL_BUT_LUN0 = 65279;
    public static final int TYPE_ALL_ETHSW = 63;
    public static final long MIN_INTERVAL = 30000L;
    private InventoryEventListenerIf[] _listeners;
    private ConcurrentHashMap<Wwn, Hba> _hbasByWwn = new ConcurrentHashMap();
    private ConcurrentHashMap<Wwn, ScsiTarget> _lun0sByWwn = new ConcurrentHashMap();
    private ConcurrentHashMap<PKIf, NEInventoryNode<? extends PKIf>> _neNodesByPK = new ConcurrentHashMap();
    private long _refreshInterval = 900000L;
    private long _lastScanTime;
    private RefreshTask _refreshTask = new RefreshTask();
    public static Logger _Logger;

    private InventoryManager() {
        SchedulerSingleton.getInstance().addTask(this._refreshTask);
    }

    public static InventoryManager getInstance() {
        if (_Instance == null) {
            _Instance = new InventoryManager();
            SanManager.getInstance();
            SanManager.addListener(_Instance);
            DCManager.getInstance().addListener(_Instance);
        }
        return _Instance;
    }

    public void addEventListener(InventoryEventListenerIf listener) {
        if (this._listeners == null) {
            this._listeners = new InventoryEventListenerIf[]{listener};
        } else {
            InventoryEventListenerIf[] na = new InventoryEventListenerIf[this._listeners.length + 1];
            System.arraycopy(this._listeners, 0, na, 0, this._listeners.length);
            na[this._listeners.length] = listener;
            this._listeners = na;
        }
    }

    void entityCreated(InventoryComponent comp) {
        this.notifyEnityChange(new InventoryChangeEvent(comp, 1));
    }

    void entityUpdated(InventoryComponent comp) {
        this.notifyEnityChange(new InventoryChangeEvent(comp, 3));
        comp.resetChangeFlag();
    }

    void entityRemoved(InventoryComponent comp) {
        this.notifyEnityChange(new InventoryChangeEvent(comp, 2));
    }

    void notifyEnityChange(InventoryChangeEvent evt) {
        if (this._listeners == null) {
            return;
        }
        for (int i = 0; i < this._listeners.length; ++i) {
            try {
                this._listeners[i].inventoryEntityChanged(evt);
                continue;
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)"notifyEntityChange:", (Throwable)ex);
            }
        }
    }

    public long getInterval() {
        return this._refreshInterval;
    }

    public void setInterval(long interval) {
        if (interval != this._refreshInterval && interval > 0L) {
            this._refreshInterval = interval < 30000L ? 30000L : interval;
            long delay = interval - System.currentTimeMillis() + this._lastScanTime;
            delay = delay > 0L ? delay : interval;
            try {
                SchedulerSingleton.getInstance().setTaskSchedule(this._refreshTask, new Schedule(delay, interval, false));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    public void poll() {
        this._refreshTask.start();
    }

    public void poll(FabricImpl fabric, int type) {
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            this.poll(sws[i].getSwitchPK(), type);
        }
    }

    public void poll(LanImpl lan, int type) {
        EthSwitchImpl[] sws = lan.getEthSwitches().toArray(new EthSwitchImpl[lan.getEthSwitches().size()]);
        for (int i = 0; i < sws.length; ++i) {
            if (sws[i].isVdc()) {
                this.poll((VdcPK)sws[i].getSwitchPK(), type);
                continue;
            }
            this.poll((SerialNumKey)sws[i].getSwitchPK(), type);
        }
    }

    public void poll(WwnKey swPK) {
        this.poll(swPK, 65279);
    }

    public void poll(SerialNumKey swPK) {
        this.poll(swPK, 63);
    }

    public void poll(VdcPK swPK) {
        this.poll(swPK, 63);
    }

    public void poll(WwnKey swPK, int type) {
        NEInventoryNode<WwnKey> node = this.createNENode(swPK);
        SwitchImpl sw = SanManager.getInstance().findSwitchByPK(swPK);
        if (node != null && sw != null && sw.isMDS()) {
            SwitchInventoryWorker w = (SwitchInventoryWorker)node.getWorker();
            if (w != null) {
                node.getWorker().setDiscFlag(type);
            }
            if (sw.getInetAddress() != null) {
                if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) && sw.isNpvEnabled()) {
                    sw.setManageable(false, "unmanaged no NPV discovery");
                    return;
                }
                this._refreshTask.startWorker(node, sw, false);
            }
        }
    }

    public void poll(SerialNumKey swPK, int type) {
        NEInventoryNode<SerialNumKey> node = this.createNENode(swPK);
        EthSwitchImpl ethSw = DCManager.getInstance().findEthSwitchBySwPK(swPK);
        if (node != null && ethSw != null && ethSw.getBase().isCisco()) {
            EthSwitchInventoryWorker worker = (EthSwitchInventoryWorker)node.getWorker();
            if (worker != null) {
                node.getWorker().setDiscFlag(type);
            }
            if (ethSw.getInetAddress() != null) {
                this._refreshTask.startWorker(node, ethSw, false);
            }
        }
    }

    public void poll(VdcPK swPK, int type) {
        NEInventoryNode<VdcPK> node = this.createNENode(swPK);
        EthSwitchImpl ethSw = DCManager.getInstance().findEthSwitchBySwPK(swPK);
        if (node != null && ethSw != null && ethSw.getBase().isCisco()) {
            EthSwitchInventoryWorker worker = (EthSwitchInventoryWorker)node.getWorker();
            if (worker != null) {
                node.getWorker().setDiscFlag(type);
            }
            if (ethSw.getInetAddress() != null) {
                this._refreshTask.startWorker(node, ethSw, false);
            }
        }
    }

    private NEInventoryNode createNENode(PKIf swPK) {
        if (swPK instanceof WwnKey) {
            return this.createNENode((WwnKey)swPK);
        }
        if (swPK instanceof SerialNumKey) {
            return this.createNENode((SerialNumKey)swPK);
        }
        if (swPK instanceof VdcPK) {
            return this.createNENode((VdcPK)swPK);
        }
        throw new IllegalArgumentException("Cannot createNENode for the switchPK:" + swPK);
    }

    private NEInventoryNode<WwnKey> createNENode(WwnKey swPK) {
        if (swPK == null) {
            return null;
        }
        NEInventoryNode<WwnKey> ne = this.findTypedNENode(swPK);
        if (ne == null) {
            ne = new NEInventoryNode<WwnKey>(swPK);
            this._neNodesByPK.put(swPK, ne);
        }
        return ne;
    }

    private NEInventoryNode<SerialNumKey> createNENode(SerialNumKey swPK) {
        if (swPK == null) {
            return null;
        }
        NEInventoryNode<SerialNumKey> ne = this.findTypedNENode(swPK);
        if (ne == null) {
            ne = new NEInventoryNode<SerialNumKey>(swPK);
            this._neNodesByPK.put(swPK, ne);
        }
        return ne;
    }

    private NEInventoryNode<VdcPK> createNENode(VdcPK swPK) {
        if (swPK == null) {
            return null;
        }
        NEInventoryNode<VdcPK> ne = this.findTypedNENode(swPK);
        if (ne == null) {
            ne = new NEInventoryNode<VdcPK>(swPK);
            this._neNodesByPK.put(swPK, ne);
        }
        return ne;
    }

    private NEInventoryNode<WwnKey> findTypedNENode(WwnKey swPK) {
        return swPK != null ? this._neNodesByPK.get(swPK) : null;
    }

    private NEInventoryNode<SerialNumKey> findTypedNENode(SerialNumKey swPK) {
        return swPK != null ? this._neNodesByPK.get(swPK) : null;
    }

    private NEInventoryNode<VdcPK> findTypedNENode(VdcPK swPK) {
        return swPK != null ? this._neNodesByPK.get(swPK) : null;
    }

    private NEInventoryNode findNENode(PKIf swPK) {
        return swPK != null ? this._neNodesByPK.get(swPK) : null;
    }

    public PKIf[] getSwitchPKs() {
        return this._neNodesByPK.keySet().toArray(new PKIf[this._neNodesByPK.size()]);
    }

    void manage(WwnKey swPK) {
        this.createNENode(swPK);
    }

    void manage(SerialNumKey swPK) {
        this.createNENode(swPK);
    }

    void manage(VdcPK swPK) {
        this.createNENode(swPK);
    }

    void unmanage(PKIf swPK) {
        NEInventoryNode<? extends PKIf> neNode;
        if (swPK != null && (neNode = this._neNodesByPK.remove(swPK)) != null && neNode.getWorker() != null) {
            neNode.getWorker().stop();
        }
    }

    public Card createCard(PKIf swPK, int slot, int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, int ioaState, int seState, int santapState) {
        Card card = this.findCard(swPK, slot);
        if (card == null) {
            if (this.createNENode(swPK) != null) {
                card = this.createNENode(swPK).createCard(slot, phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current, dmmState, ioaState, seState, santapState);
                this.entityCreated(card);
            }
        } else {
            card.update(phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current, dmmState, ioaState, seState, santapState, 0, null);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
        return card;
    }

    public Card createCard(PKIf swPK, int slot, int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        Card card = this.findCard(swPK, slot);
        if (card == null) {
            if (this.createNENode(swPK) != null) {
                card = this.createNENode(swPK).createCard(slot, phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current, 0, 0, 0, 0);
                this.entityCreated(card);
            }
        } else {
            card.update(phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
        return card;
    }

    public void deleteCard(PKIf swPK, int slotId) {
        Card card;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (card = ne.deleteCard(slotId)) != null) {
            this.entityRemoved(card);
            try {
                InventoryPersistent.getInstance().purge(card);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + card + ":"), (Throwable)ex);
            }
        }
    }

    public void updateCardStatus(PKIf swPK, int phyIndex, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        Card card = null;
        card = swPK instanceof SerialNumKey ? this.findCardByPhysicalIndex((SerialNumKey)swPK, phyIndex) : (swPK instanceof VdcPK ? this.findCardByPhysicalIndex((VdcPK)swPK, phyIndex) : this.findCardByPhysicalIndex((WwnKey)swPK, phyIndex));
        if (card != null) {
            card.update(adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public void updateCardStatus(PKIf swPK, int phyIndex, int status, String statusDescr, long chgtime) {
        Card card = null;
        card = swPK instanceof SerialNumKey ? this.findCardByPhysicalIndex((SerialNumKey)swPK, phyIndex) : (swPK instanceof VdcPK ? this.findCardByPhysicalIndex((VdcPK)swPK, phyIndex) : this.findCardByPhysicalIndex((WwnKey)swPK, phyIndex));
        if (card != null) {
            card.setStatus(status, statusDescr, chgtime);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
            if (card.needPersist()) {
                try {
                    InventoryPersistent.getInstance().persist(card);
                }
                catch (Exception ex) {
                    _Logger.warn((Object)("persisting card error: " + ex.getMessage()));
                }
            }
        }
    }

    public void updateCardDmmState(Card card, int newDmmState) {
        if (card != null) {
            card.setDmmState(newDmmState);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public void updateCardIoaState(Card card, int newIoaState) {
        if (card != null) {
            card.setIoaState(newIoaState);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public void updateCardSeState(Card card, int newSeState) {
        if (card != null) {
            card.setSeState(newSeState);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public void updateCardSantapState(Card card, int newSantapState) {
        if (card != null) {
            card.setSantapState(newSantapState);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public void updateCardEthPortNumAndPortType(Card card, int newEthPortNum, HashMap<Integer, TreeSet<Integer>> portByIfType) {
        if (card != null) {
            card.setNumEthPorts(newEthPortNum);
            card.setPortByIfType(portByIfType);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
    }

    public int getNumCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getNumCards() : 0;
    }

    public List<Card> findSSMCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findSSMCards() : Collections.emptyList();
    }

    public List<Card> findSMECapableCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findSMECapableCards() : Collections.emptyList();
    }

    public List<Card> findIOACapableCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findIOACapableCards() : Collections.emptyList();
    }

    public List<Card> findCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getCards() : Collections.emptyList();
    }

    public Set<Integer> findCardSlotIds(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getCardSlotIds() : Collections.emptySet();
    }

    public Card findCard(PKIf swPK, int slotNum) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findCard(slotNum) : null;
    }

    public Card findCardByPhysicalIndex(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findCardByPhysicalIndex(phyIndex) : null;
    }

    public boolean hasIPSCard(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.hasIPSCard() : false;
    }

    public boolean hasSMECard(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.hasSMECard() : false;
    }

    public boolean hasILC(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.hasILC() : false;
    }

    public boolean hasDualSup(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.hasDualSup() : false;
    }

    public boolean isSup(PKIf swPK, Card card) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.hasDualSup() : false;
    }

    public HwInventoryComponent createChassis(PKIf swPK, int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HwInventoryComponent chassis = this.findChassis(swPK);
        if (chassis == null) {
            if (this.createNENode(swPK) != null) {
                chassis = this.createNENode(swPK).createHwComponent(phyIndex, name, vendorType, HwInventoryType.CHASSIS.value(), relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
                this.entityCreated(chassis);
            }
        } else {
            chassis.update(phyIndex, name, vendorType, HwInventoryType.CHASSIS.value(), hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
            if (chassis.isChanged()) {
                this.entityUpdated(chassis);
            }
        }
        return chassis;
    }

    public HwInventoryComponent findChassis(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getChassis() : null;
    }

    public HwInventoryComponent createFan(PKIf swPK, int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status) {
        HwInventoryComponent fan = this.findFan(swPK, relPos);
        if (fan == null) {
            if (this.createNENode(swPK) != null) {
                fan = this.createNENode(swPK).createFan(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status);
                this.entityCreated(fan);
            }
        } else {
            fan.update(phyIndex, name, vendorType, HwInventoryType.FAN.value(), hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, "n/a");
            if (fan.isChanged()) {
                this.entityUpdated(fan);
            }
        }
        return fan;
    }

    public HwInventoryComponent findFan(PKIf swPK, int slotNum) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findFan(slotNum) : null;
    }

    public List<HwInventoryComponent> findFans(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getFans() : Collections.emptyList();
    }

    public Set<Integer> findFanSlotIds(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getFanSlotIds() : Collections.emptySet();
    }

    public HwInventoryComponent findFanByPhysicalIndex(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findFanByPhysicalIndex(phyIndex) : null;
    }

    public void deleteFan(PKIf swPK, int slotId) {
        HwInventoryComponent fan;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (fan = ne.deleteFan(slotId)) != null) {
            this.entityRemoved(fan);
            try {
                InventoryPersistent.getInstance().purge(fan);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + fan + ":"), (Throwable)ex);
            }
        }
    }

    public PowerSupply createPowerSupply(PKIf swPK, int slot, int phyIndex, String name, int[] vendorType, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String model, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        PowerSupply ps = this.findPowerSupply(swPK, slot);
        if (ps == null) {
            if (this.createNENode(swPK) != null) {
                ps = this.createNENode(swPK).createPowerSupply(phyIndex, name, vendorType, slot, hwRev, fwRev, swRev, serialNum, mfg, model, assetId, status, redundancyMode, drawnCur, availCur, units);
                this.entityCreated(ps);
            }
        } else {
            ps.update(phyIndex, name, vendorType, hwRev, fwRev, swRev, serialNum, mfg, model, assetId, status, redundancyMode, drawnCur, availCur, units);
            if (ps.isChanged()) {
                this.entityUpdated(ps);
            }
        }
        return ps;
    }

    public PowerSupply findPowerSupply(PKIf swPK, int slot) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findPowerSupply(slot) : null;
    }

    public List<PowerSupply> findPowerSupplies(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getPowerSupplies() : Collections.emptyList();
    }

    public Set<Integer> findPowerSupplySlotIds(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.getPowerSupplySlotIds() : Collections.emptySet();
    }

    public PowerSupply findPowerSupplyByPhysicalIndex(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findPowerSupplyByPhysicalIndex(phyIndex) : null;
    }

    public void deletePowerSupply(PKIf swPK, int slotId) {
        PowerSupply ps;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (ps = ne.deletePowerSupply(slotId)) != null) {
            this.entityRemoved(ps);
            try {
                InventoryPersistent.getInstance().purge(ps);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + ps + ":"), (Throwable)ex);
            }
        }
    }

    public void updatePowerSupplyStatus(PKIf swPK, int phyIndex, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        PowerSupply ps = null;
        ps = swPK instanceof SerialNumKey ? this.findPowerSupplyByPhysicalIndex((SerialNumKey)swPK, phyIndex) : (swPK instanceof VdcPK ? this.findPowerSupplyByPhysicalIndex((VdcPK)swPK, phyIndex) : this.findPowerSupplyByPhysicalIndex((WwnKey)swPK, phyIndex));
        if (ps != null) {
            ps.update(status, redundancyMode, drawnCur, availCur, units);
            if (ps.isChanged()) {
                this.entityUpdated(ps);
            }
        }
    }

    public HwInventoryComponent findHardwareComponent(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findHardwareComponent(phyIndex) : null;
    }

    public HwInventoryComponent createHwComponent(PKIf swPK, int phyIndex, String name, int[] vendorType, int hwType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HwInventoryComponent comp = this.findHardwareComponent(swPK, phyIndex);
        if (comp == null) {
            if (this.createNENode(swPK) != null) {
                comp = this.createNENode(swPK).createHwComponent(phyIndex, name, vendorType, hwType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
                this.entityCreated(comp);
            }
        } else {
            comp.update(phyIndex, name, vendorType, hwType, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
            if (comp.isChanged()) {
                this.entityUpdated(comp);
            }
        }
        return comp;
    }

    public void updateStatus(PKIf swPK, int phyIndex, String status) {
        HwInventoryComponent comp = null;
        comp = swPK instanceof SerialNumKey ? this.findHardwareComponent((SerialNumKey)swPK, phyIndex) : (swPK instanceof VdcPK ? this.findHardwareComponent((VdcPK)swPK, phyIndex) : this.findHardwareComponent((WwnKey)swPK, phyIndex));
        if (comp != null) {
            comp.update(status);
            if (comp.isChanged()) {
                this.entityUpdated(comp);
            }
        }
    }

    public boolean isDiscovering(PKIf swPK) {
        SwitchInventoryWorkerIf worker;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (worker = ne.getWorker()) != null) {
            return worker.isDiscovering();
        }
        return false;
    }

    public Hba createHba(Wwn hwwn, Wwn nwwn, String vendor, String sn, String model, String modelDescr, String hwVer, String drVer, String romVer, String fmVer) {
        if (hwwn == null) {
            return null;
        }
        Hba hba = this._hbasByWwn.get(hwwn);
        if (hba == null) {
            hba = new Hba(hwwn, nwwn, vendor, sn, model, modelDescr, hwVer, drVer, romVer, fmVer);
            this._hbasByWwn.put(hwwn, hba);
            this.entityCreated(hba);
        } else {
            hba.resetChangeFlag();
            if (hba.update(nwwn, vendor, sn, model, modelDescr, hwVer, drVer, romVer, fmVer) && hba.isChanged()) {
                this.entityUpdated(hba);
            }
        }
        return hba;
    }

    public Hba createHba(Wwn hwwn, Wwn nwwn, String info) {
        if (info == null) {
            return null;
        }
        int vendorId = WwnDictionary.getVendorId(hwwn.getValue());
        String vendor = null;
        String model = null;
        String fwVer = null;
        String drVer = null;
        try {
            if (vendorId == 201 || vendorId == 37114) {
                vendor = "Emulex";
                int pos1 = info.indexOf(" ");
                pos1 = pos1 < 0 ? 0 : pos1 + 1;
                int pos2 = info.indexOf(" ", pos1 + 1);
                model = info.substring(pos1, pos2);
                pos1 = info.indexOf("FV");
                pos2 = info.indexOf(" ", pos1 + 3);
                fwVer = info.substring(pos1 + 2, pos2);
                pos1 = info.indexOf("DV");
                pos2 = info.indexOf(" ", pos1 + 1);
                drVer = info.substring(pos1 + 2, pos2 < 0 ? info.length() : pos2);
            } else if (vendorId == 57483 || vendorId == 49373 || vendorId == 3424) {
                vendor = "Qlogic";
                int pos2 = info.indexOf(" ");
                model = info.substring(0, pos2);
                int pos1 = info.indexOf("FW:v");
                pos2 = info.indexOf(" ", pos1 + 4);
                fwVer = info.substring(pos1 + 4, pos2);
                pos1 = info.indexOf("DVR:v");
                drVer = info.substring(pos1 + 5);
            }
            if (vendor != null) {
                return this.createHba(hwwn, nwwn, vendor, null, model, null, null, drVer, null, fwVer);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return null;
    }

    public Hba[] getHbas() {
        return this._hbasByWwn.values().toArray(new Hba[this._hbasByWwn.size()]);
    }

    public Hba findHbaByWwn(Wwn hwwn) {
        return hwwn != null ? this._hbasByWwn.get(hwwn) : null;
    }

    public Hba findHbaByNodeWwn(Wwn nwwn) {
        for (Hba hba : this._hbasByWwn.values()) {
            if (!hba.getNodeWwn().equals(nwwn)) continue;
            return hba;
        }
        return null;
    }

    public void deleteHba(Wwn hwwn) {
        Hba hba;
        Hba hba2 = hba = hwwn != null ? this._hbasByWwn.remove(hwwn) : null;
        if (hba != null) {
            this.entityRemoved(hba);
            try {
                InventoryPersistent.getInstance().purge(hba);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("deleting " + hba + " error"), (Throwable)ex);
            }
        }
    }

    public void purgeHba(Wwn hwwn) {
        Hba hba;
        Hba hba2 = hba = hwwn != null ? this._hbasByWwn.remove(hwwn) : null;
        if (hba != null) {
            try {
                InventoryPersistent.getInstance().purge(hba);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purging" + hba + " error"), (Throwable)ex);
            }
        }
    }

    public ScsiTarget createScsiTarget(Wwn scsiName, int devType, String vendorId, String productId, String revLevel, byte[] otherInfo) {
        if (scsiName == null) {
            return null;
        }
        ScsiTarget lun0 = this._lun0sByWwn.get(scsiName);
        if (lun0 == null) {
            lun0 = new ScsiTarget(scsiName, devType, vendorId, productId, revLevel, otherInfo);
            this._lun0sByWwn.put(scsiName, lun0);
            this.entityCreated(lun0);
        } else {
            lun0.resetChangeFlag();
            if (lun0.update(devType, vendorId, productId, revLevel, otherInfo) && lun0.isChanged()) {
                this.entityUpdated(lun0);
            }
        }
        return lun0;
    }

    public ScsiTarget[] getScsiTargets() {
        return this._lun0sByWwn.values().toArray(new ScsiTarget[this._lun0sByWwn.size()]);
    }

    public ScsiTarget findScsiTarget(Wwn scsiName) {
        return scsiName != null ? this._lun0sByWwn.get(scsiName) : null;
    }

    public LicenseInfo createLicense(PKIf swPK, String name, byte flags, int curUsage, int maxUsage, int misUsage, byte[] dateAndTime, int gracePeriod) {
        LicenseInfo lic = this.findLicense(swPK, name);
        if (lic == null) {
            if (this.createNENode(swPK) != null) {
                lic = this.createNENode(swPK).createLicense(name, flags, curUsage, maxUsage, misUsage, dateAndTime, gracePeriod);
                this.entityCreated(lic);
                this.checkFMLicense(swPK, lic);
            }
        } else {
            this.updateLicense(swPK, flags, curUsage, maxUsage, misUsage, dateAndTime, gracePeriod, lic);
        }
        return lic;
    }

    public void updateLicense(PKIf swPK, byte flags, int curUsage, int maxUsage, int misUsage, byte[] dateAndTime, int gracePeriod, LicenseInfo lic) {
        if (lic == null) {
            return;
        }
        lic.update(flags, curUsage, maxUsage, misUsage, dateAndTime, gracePeriod);
        if (lic.isChanged()) {
            this.entityUpdated(lic);
            this.checkFMLicense(swPK, lic);
        }
    }

    void checkFMLicense(PKIf swPK, LicenseInfo fmLic) {
        if (fmLic.getName().equals("FM_SERVER_PKG")) {
            FabricImpl fabric;
            SwitchImpl sw = null;
            if (swPK instanceof WwnKey) {
                sw = SanManager.getInstance().findSwitchByPK((WwnKey)swPK);
            }
            if (sw != null && (fabric = sw.getFabric()) != null) {
                SwitchImpl licSeed = fabric.getLicenseServer();
                LicenseInfo seedFMLic = null;
                if (licSeed != null) {
                    seedFMLic = this.findLicense(licSeed.getSwitchPK(), "FM_SERVER_PKG");
                }
                if (seedFMLic == null || fmLic.isBetter(seedFMLic)) {
                    fabric.setLicenseServer(sw);
                }
            }
        }
    }

    public void deleteLicense(PKIf swPK, String licName) {
        LicenseInfo lic;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (lic = ne.deleteLicense(licName)) != null) {
            this.entityRemoved(lic);
            try {
                InventoryPersistent.getInstance().purge(lic);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + lic + ":"), (Throwable)ex);
            }
        }
    }

    public LicenseInfo findLicense(PKIf swPK, String name) {
        NEInventoryNode<? extends PKIf> ne = swPK != null ? this._neNodesByPK.get(swPK) : null;
        return ne != null ? ne.findLicense(name) : null;
    }

    public List<LicenseInfo> findLicenses(PKIf swPK) {
        NEInventoryNode<? extends PKIf> ne = swPK != null ? this._neNodesByPK.get(swPK) : null;
        return ne != null ? ne.getLicenses() : Collections.emptyList();
    }

    public Set<String> findLicenseNames(PKIf swPK) {
        NEInventoryNode<? extends PKIf> ne = swPK != null ? this._neNodesByPK.get(swPK) : null;
        return ne != null ? ne.getLicenseNames() : Collections.emptySet();
    }

    public Card createFexCard(PKIf swPK, int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        Card card = this.findCard(swPK, phyIndex);
        if (card == null) {
            if (this.createNENode(swPK) != null) {
                card = this.createNENode(swPK).createFexCard(phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
                this.entityCreated(card);
            }
        } else {
            card.update(adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
            if (card.isChanged()) {
                this.entityUpdated(card);
            }
        }
        return card;
    }

    public void deleteFexCard(PKIf swPK, int phyIndex) {
        Card card;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (card = ne.deleteFexCard(phyIndex)) != null) {
            this.entityRemoved(card);
            try {
                InventoryPersistent.getInstance().purge(card);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + card + ":"), (Throwable)ex);
            }
        }
    }

    public List<Card> findFexCards(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<Card>(ne.getFexCards().values());
    }

    public Map<Integer, Card> findFexCardInMap(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_MAP;
        }
        return ne.getFexCards();
    }

    public HwInventoryComponent createFexChassis(PKIf swPK, int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HwInventoryComponent fexChassis = this.findFexChassis(swPK, phyIndex);
        if (fexChassis == null) {
            if (this.createNENode(swPK) != null) {
                fexChassis = this.createNENode(swPK).createFexChassis(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
                this.entityCreated(fexChassis);
            }
        } else {
            fexChassis.update(phyIndex, name, vendorType, HwInventoryType.CHASSIS.value(), hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
            if (fexChassis.isChanged()) {
                this.entityUpdated(fexChassis);
            }
        }
        return fexChassis;
    }

    public HwInventoryComponent findFexChassis(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        return ne != null ? ne.findFexChassis(phyIndex) : null;
    }

    public void deleteFexChassis(PKIf swPK, int phyIndex) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return;
        }
        HwInventoryComponent fexChassis = ne.deleteFexChassis(phyIndex);
        if (fexChassis != null) {
            this.entityRemoved(fexChassis);
            try {
                InventoryPersistent.getInstance().purge(fexChassis);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + fexChassis + ":"), (Throwable)ex);
            }
        }
    }

    public List<HwInventoryComponent> findFexChassises(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<HwInventoryComponent>(ne.getFexChassises().values());
    }

    public Map<Integer, HwInventoryComponent> findFexChassisInMap(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_MAP;
        }
        return ne.getFexChassises();
    }

    public HwInventoryComponent createFexFan(PKIf swPK, int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String statusDesc) {
        HwInventoryComponent fan = this.findFan(swPK, phyIndex);
        if (fan == null) {
            if (this.createNENode(swPK) != null) {
                fan = this.createNENode(swPK).createFexFan(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, statusDesc);
                this.entityCreated(fan);
            }
        } else {
            fan.update(statusDesc);
            if (fan.isChanged()) {
                this.entityUpdated(fan);
            }
        }
        return fan;
    }

    public void deleteFexFan(PKIf swPK, int phyIndex) {
        HwInventoryComponent fan;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (fan = ne.deleteFexFan(phyIndex)) != null) {
            this.entityRemoved(fan);
            try {
                InventoryPersistent.getInstance().purge(fan);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + fan + ":"), (Throwable)ex);
            }
        }
    }

    public List<HwInventoryComponent> findFexFans(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<HwInventoryComponent>(ne.getFexFans().values());
    }

    public Map<Integer, HwInventoryComponent> findFexFanInMap(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_MAP;
        }
        return ne.getFexFans();
    }

    public PowerSupply createFexPower(PKIf swPK, int relPos, int phyIndex, String name, int[] vendorType, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        PowerSupply ps = this.findPowerSupply(swPK, phyIndex);
        if (ps == null) {
            if (this.createNENode(swPK) != null) {
                ps = this.createNENode(swPK).createFexPower(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, redundancyMode, drawnCur, availCur, units);
                this.entityCreated(ps);
            }
        } else {
            ps.update(status, redundancyMode, drawnCur, availCur, units);
            if (ps.isChanged()) {
                this.entityUpdated(ps);
            }
        }
        return ps;
    }

    public void deleteFexPower(PKIf swPK, int phyIndex) {
        PowerSupply ps;
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne != null && (ps = ne.deleteFexPower(phyIndex)) != null) {
            this.entityRemoved(ps);
            try {
                InventoryPersistent.getInstance().purge(ps);
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge" + ps + ":"), (Throwable)ex);
            }
        }
    }

    public List<PowerSupply> findFexPowers(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<PowerSupply>(ne.getFexPowers().values());
    }

    public Map<Integer, PowerSupply> findFexPowerInMap(PKIf swPK) {
        NEInventoryNode ne = this.findNENode(swPK);
        if (ne == null) {
            return Collections.EMPTY_MAP;
        }
        return ne.getFexPowers();
    }

    public List<HwInventoryComponent> findHwComponentsBySwitchPK(PKIf swPK) {
        List fanList;
        List psList;
        List cardList;
        Collection fexChassisList;
        if (swPK == null) {
            return Collections.EMPTY_LIST;
        }
        NEInventoryNode node = this.findNENode(swPK);
        ArrayList<HwInventoryComponent> hwList = new ArrayList<HwInventoryComponent>();
        HwInventoryComponent chassis = node.getChassis();
        if (chassis != null) {
            hwList.add(chassis);
        }
        if ((fexChassisList = node.getFexChassises().values()) != null) {
            hwList.addAll(fexChassisList);
        }
        if ((cardList = node.getCards()) != null) {
            hwList.addAll(cardList);
        }
        if ((psList = node.getPowerSupplies()) != null) {
            hwList.addAll(psList);
        }
        if ((fanList = node.getFans()) != null) {
            hwList.addAll(fanList);
        }
        return hwList;
    }

    public List<HwInventoryComponent<WwnKey>> findHwComponentsBySwitchPK(WwnKey swPK) {
        List<HwInventoryComponent<WwnKey>> fanList;
        List<PowerSupply<WwnKey>> psList;
        List<Card<WwnKey>> cardList;
        if (swPK == null) {
            return Collections.EMPTY_LIST;
        }
        NEInventoryNode<WwnKey> node = this.findTypedNENode(swPK);
        ArrayList<HwInventoryComponent<WwnKey>> hwList = new ArrayList<HwInventoryComponent<WwnKey>>();
        HwInventoryComponent<WwnKey> chassis = node.getChassis();
        if (chassis != null) {
            hwList.add(chassis);
        }
        if ((cardList = node.getCards()) != null) {
            hwList.addAll(cardList);
        }
        if ((psList = node.getPowerSupplies()) != null) {
            hwList.addAll(psList);
        }
        if ((fanList = node.getFans()) != null) {
            hwList.addAll(fanList);
        }
        return hwList;
    }

    public List<HwInventoryComponent<SerialNumKey>> findHwComponentsBySwitchPK(SerialNumKey swPK) {
        List<HwInventoryComponent<SerialNumKey>> fanList;
        List<PowerSupply<SerialNumKey>> psList;
        List<Card<SerialNumKey>> cardList;
        Collection<HwInventoryComponent<SerialNumKey>> fexChassisList;
        if (swPK == null) {
            return Collections.EMPTY_LIST;
        }
        NEInventoryNode<SerialNumKey> node = this.findTypedNENode(swPK);
        ArrayList<HwInventoryComponent<SerialNumKey>> hwList = new ArrayList<HwInventoryComponent<SerialNumKey>>();
        HwInventoryComponent<SerialNumKey> chassis = node.getChassis();
        if (chassis != null) {
            hwList.add(chassis);
        }
        if ((fexChassisList = node.getFexChassises().values()) != null) {
            hwList.addAll(fexChassisList);
        }
        if ((cardList = node.getCards()) != null) {
            hwList.addAll(cardList);
        }
        if ((psList = node.getPowerSupplies()) != null) {
            hwList.addAll(psList);
        }
        if ((fanList = node.getFans()) != null) {
            hwList.addAll(fanList);
        }
        return hwList;
    }

    public List<HwInventoryComponent<VdcPK>> findHwComponentsBySwitchPK(VdcPK swPK) {
        List<HwInventoryComponent<VdcPK>> fanList;
        List<PowerSupply<VdcPK>> psList;
        List<Card<VdcPK>> cardList;
        Collection<HwInventoryComponent<VdcPK>> fexChassisList;
        if (swPK == null) {
            return Collections.EMPTY_LIST;
        }
        NEInventoryNode<VdcPK> node = this.findTypedNENode(swPK);
        ArrayList<HwInventoryComponent<VdcPK>> hwList = new ArrayList<HwInventoryComponent<VdcPK>>();
        HwInventoryComponent<VdcPK> chassis = node.getChassis();
        if (chassis != null) {
            hwList.add(chassis);
        }
        if ((fexChassisList = node.getFexChassises().values()) != null) {
            hwList.addAll(fexChassisList);
        }
        if ((cardList = node.getCards()) != null) {
            hwList.addAll(cardList);
        }
        if ((psList = node.getPowerSupplies()) != null) {
            hwList.addAll(psList);
        }
        if ((fanList = node.getFans()) != null) {
            hwList.addAll(fanList);
        }
        return hwList;
    }

    public List<HwInventoryComponent> findHwComponentsBySwitchPKs(List<PKIf> swPKs) {
        if (swPKs == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HwInventoryComponent> hwList = new ArrayList<HwInventoryComponent>();
        for (PKIf swPK : swPKs) {
            List fanList;
            List psList;
            List cardList;
            Collection fexChassisList;
            NEInventoryNode node = this.findNENode(swPK);
            if (node == null) continue;
            HwInventoryComponent chassis = node.getChassis();
            if (chassis != null) {
                hwList.add(chassis);
            }
            if ((fexChassisList = node.getFexChassises().values()) != null) {
                hwList.addAll(fexChassisList);
            }
            if ((cardList = node.getCards()) != null) {
                hwList.addAll(cardList);
            }
            if ((psList = node.getPowerSupplies()) != null) {
                hwList.addAll(psList);
            }
            if ((fanList = node.getFans()) == null) continue;
            hwList.addAll(fanList);
        }
        return hwList;
    }

    public void removeEthSwInventory(PKIf swPK, long swId, boolean purge) {
        if (swPK instanceof SerialNumKey) {
            this.removeEthSwInventory((SerialNumKey)swPK, swId, purge);
        } else if (swPK instanceof VdcPK) {
            this.removeEthSwInventory((VdcPK)swPK, swId, purge);
        } else {
            _Logger.warn((Object)(this + " cannot remove ethsw inventory for invalid swPK:" + swPK));
        }
    }

    public void removeEthSwInventory(SerialNumKey swPK, long swId, boolean purge) {
        Map<Integer, HwInventoryComponent<? extends PKIf>> fexChassises;
        HwInventoryComponent<? extends PKIf> chassis;
        List<HwInventoryComponent<? extends PKIf>> fans;
        List<PowerSupply<? extends PKIf>> pss;
        List<Card<? extends PKIf>> cards;
        if (swPK == null) {
            return;
        }
        NEInventoryNode<? extends PKIf> nn = this._neNodesByPK.remove(swPK);
        if (nn == null) {
            return;
        }
        NEInventoryNode<? extends PKIf> ne = nn;
        if (nn.getWorker() != null) {
            nn.getWorker().stop();
        }
        if ((cards = ne.getCards()) != null && cards.size() > 0) {
            for (Card<? extends PKIf> card : cards) {
                ne.deleteCard(card.getSlotId());
                this.entityRemoved(card);
            }
        }
        if ((pss = ne.getPowerSupplies()) != null && pss.size() > 0) {
            for (PowerSupply<? extends PKIf> ps : pss) {
                ne.deletePowerSupply(ps.getSlotId());
                this.entityRemoved(ps);
            }
        }
        if ((fans = ne.getFans()) != null && fans.size() > 0) {
            for (HwInventoryComponent<? extends PKIf> fan : fans) {
                ne.deleteFan(fan.getSlotId());
                this.entityRemoved(fan);
            }
        }
        if ((chassis = ne.getChassis()) != null) {
            ne.deleteChassis();
            this.entityRemoved(chassis);
        }
        if ((fexChassises = ne.getFexChassises()) != null) {
            for (Map.Entry<Integer, HwInventoryComponent<? extends PKIf>> ent : fexChassises.entrySet()) {
                ne.deleteFexChassis(ent.getKey());
                this.entityRemoved(ent.getValue());
            }
        }
        if (purge) {
            try {
                InventoryPersistent.getInstance().purgeEthSwInventory(swId);
            }
            catch (Exception e) {
                _Logger.log((Priority)Level.WARN, (Object)("Failed to purge invetory of switch id: " + swId), (Throwable)e);
            }
        }
    }

    public void removeEthSwInventory(VdcPK swPK, long swId, boolean purge) {
        Map<Integer, HwInventoryComponent<? extends PKIf>> fexChassises;
        HwInventoryComponent<? extends PKIf> chassis;
        List<HwInventoryComponent<? extends PKIf>> fans;
        List<PowerSupply<? extends PKIf>> pss;
        List<Card<? extends PKIf>> cards;
        if (swPK == null) {
            return;
        }
        NEInventoryNode<? extends PKIf> nn = this._neNodesByPK.remove(swPK);
        if (nn == null) {
            return;
        }
        NEInventoryNode<? extends PKIf> ne = nn;
        if (nn.getWorker() != null) {
            nn.getWorker().stop();
        }
        if ((cards = ne.getCards()) != null && cards.size() > 0) {
            for (Card<? extends PKIf> card : cards) {
                ne.deleteCard(card.getSlotId());
                this.entityRemoved(card);
            }
        }
        if ((pss = ne.getPowerSupplies()) != null && pss.size() > 0) {
            for (PowerSupply<? extends PKIf> ps : pss) {
                ne.deletePowerSupply(ps.getSlotId());
                this.entityRemoved(ps);
            }
        }
        if ((fans = ne.getFans()) != null && fans.size() > 0) {
            for (HwInventoryComponent<? extends PKIf> fan : fans) {
                ne.deleteFan(fan.getSlotId());
                this.entityRemoved(fan);
            }
        }
        if ((chassis = ne.getChassis()) != null) {
            ne.deleteChassis();
            this.entityRemoved(chassis);
        }
        if ((fexChassises = ne.getFexChassises()) != null) {
            for (Map.Entry<Integer, HwInventoryComponent<? extends PKIf>> ent : fexChassises.entrySet()) {
                ne.deleteFexChassis(ent.getKey());
                this.entityRemoved(ent.getValue());
            }
        }
        if (purge) {
            try {
                InventoryPersistent.getInstance().purgeEthSwInventory(swId);
            }
            catch (Exception e) {
                _Logger.log((Priority)Level.WARN, (Object)("Failed to purge invetory of switch id: " + swId), (Throwable)e);
            }
        }
    }

    public String dump() {
        Iterator<InventoryComponent> it;
        StringBuilder sb = new StringBuilder();
        SanManager sm = SanManager.getInstance();
        DCManager dcm = DCManager.getInstance();
        AbstractModelObjectImpl sw = null;
        for (PKIf swPK : this._neNodesByPK.keySet()) {
            List<PowerSupply> powers;
            List<HwInventoryComponent> fans;
            List<Card> cards;
            if (swPK instanceof WwnKey) {
                sw = sm.findSwitchByPK((WwnKey)swPK);
            } else if (swPK instanceof SerialNumKey) {
                sw = dcm.findEthSwitchBySwPK((SerialNumKey)swPK);
            } else if (swPK instanceof VdcPK) {
                sw = dcm.findEthSwitchBySwPK((VdcPK)swPK);
            }
            if (sw == null) continue;
            sb.append("\n").append(sw.getName());
            HwInventoryComponent comp = swPK instanceof WwnKey ? this.findChassis((WwnKey)swPK) : (swPK instanceof SerialNumKey ? this.findChassis((SerialNumKey)swPK) : (swPK instanceof VdcPK ? this.findChassis((VdcPK)swPK) : this.findChassis((WwnKey)swPK)));
            if (comp != null) {
                sb.append("\n\tChassis:").append(GenUtil.dump(comp, "\t\t")).append("\n");
            }
            if ((cards = this.findCards(swPK)).size() != 0) {
                Collections.sort(cards);
                sb.append("\n\t").append(cards.size()).append(" cards:");
                Iterator<Card> it2 = cards.iterator();
                while (it2.hasNext()) {
                    sb.append(GenUtil.dump(it2.next(), "\t\t")).append("\n");
                }
            }
            if ((fans = this.findFans(swPK)).size() != 0) {
                sb.append("\n\t").append(fans.size()).append(" fans:");
                Iterator it3 = fans.iterator();
                while (it3.hasNext()) {
                    sb.append(GenUtil.dump(it3.next(), "\t\t")).append("\n");
                }
            }
            if ((powers = this.findPowerSupplies(swPK)).size() != 0) {
                sb.append("\n\t").append(powers.size()).append(" power supplies:");
                Iterator it4 = powers.iterator();
                while (it4.hasNext()) {
                    sb.append(GenUtil.dump(it4.next(), "\t\t")).append("\n");
                }
            }
            if (!(swPK instanceof WwnKey)) continue;
            List<LicenseInfo> lics = this.findLicenses((WwnKey)swPK);
            Collections.sort(lics);
            if (lics.size() == 0) continue;
            sb.append("\n\t").append(lics.size()).append(" licenses:");
            Iterator<LicenseInfo> it5 = lics.iterator();
            while (it5.hasNext()) {
                sb.append(GenUtil.dump(it5.next(), "\t\t")).append("\n");
            }
        }
        sb.append("\n").append(this._hbasByWwn.size()).append(" HBAs:");
        if (this._hbasByWwn.size() != 0) {
            it = this._hbasByWwn.values().iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        sb.append("\n").append(this._lun0sByWwn.size()).append(" SCSI targets:");
        if (this._lun0sByWwn.size() != 0) {
            it = this._lun0sByWwn.values().iterator();
            while (it.hasNext()) {
                sb.append(GenUtil.dump(it.next(), "\t")).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void fabricOpened(FabricImpl fabric) {
        if (fabric == null) {
            return;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        if (switches == null || switches.length == 0) {
            return;
        }
        for (int i = 0; i < switches.length; ++i) {
            WwnKey swPk = switches[i].getSwitchPK();
            if (this.isDiscovering(swPk)) continue;
            this.poll(swPk);
        }
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
        if (fabric == null) {
            return;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        if (switches == null || switches.length == 0) {
            return;
        }
        for (int i = 0; i < switches.length; ++i) {
            WwnKey swPk = switches[i].getSwitchPK();
            if (this.getNumCards(swPk) != 0 || this.isDiscovering(swPk)) continue;
            this.poll(swPk);
        }
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void membersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(FabricImpl fabric, PKIf[] pks) {
    }

    @Override
    public void membersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] pks) {
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
        if (mo instanceof SwitchImpl) {
            SwitchImpl sw = (SwitchImpl)mo;
            if (sw.getPK() != null) {
                this.manage(sw.getSwitchPK());
            }
            if (sw.getInetAddress() != null && sw.getFabric() != null && sw.getFabric().getFarbicStatus() != 3) {
                this.poll(sw.getSwitchPK());
            }
        } else if (mo instanceof VdcImpl) {
            VdcImpl sw = (VdcImpl)mo;
            if (sw.getPK() != null) {
                this.manage((VdcPK)sw.getSwitchPK());
            }
            if (sw.getInetAddress() != null && sw.getLan() != null && sw.getLan().getLanStatus() != 3) {
                this.poll((VdcPK)sw.getSwitchPK(), 31);
            }
        } else if (!(mo instanceof FexImpl) && mo instanceof EthSwitchImpl) {
            EthSwitchImpl sw = (EthSwitchImpl)mo;
            if (sw.getPK() != null) {
                this.manage((SerialNumKey)sw.getSwitchPK());
            }
            if (sw.getInetAddress() != null && sw.getLan() != null && sw.getLan().getLanStatus() != 3) {
                this.poll((SerialNumKey)sw.getSwitchPK(), 31);
            }
        }
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
        if (mo instanceof SwitchIf) {
            this.unmanage((PKIf)((SwitchIf)((Object)mo)).getSwitchPK());
        }
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
        if (lan == null) {
            return;
        }
        List<EthSwitchImpl> switches = lan.getEthSwitches();
        if (switches == null || switches.size() == 0) {
            return;
        }
        for (EthSwitchImpl ethSw : switches) {
            Object swPK = ethSw.getBase().getSwitchPK();
            if (swPK == null || this.isDiscovering((PKIf)swPK)) continue;
            if (swPK instanceof VdcPK) {
                this.poll((VdcPK)swPK);
                continue;
            }
            if (swPK instanceof SerialNumKey) {
                this.poll((SerialNumKey)swPK);
                continue;
            }
            _Logger.warn((Object)("InventoryManager got unknown swPK for lanOpened:" + swPK));
        }
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
        if (lan == null) {
            return;
        }
        List<EthSwitchImpl> switches = lan.getEthSwitches();
        if (switches == null || switches.size() == 0) {
            return;
        }
        for (EthSwitchImpl ethSw : switches) {
            Object swPK = ethSw.getBase().getSwitchPK();
            if (swPK == null || this.getNumCards((PKIf)swPK) != 0 || this.isDiscovering((PKIf)swPK)) continue;
            if (swPK instanceof VdcPK) {
                this.poll((VdcPK)swPK);
                continue;
            }
            if (swPK instanceof SerialNumKey) {
                this.poll((SerialNumKey)swPK);
                continue;
            }
            _Logger.warn((Object)("InventoryManager got unknown swPK for lanOpened:" + swPK));
        }
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    static {
        _Logger = LogManager.getLogger((String)"fms.inventory");
    }

    class RefreshTask
    extends ScheduledTask {
        private PooledThreadExecutor _pool;
        private int _pollNumber;

        RefreshTask() {
            super("InventoryPoller", new Schedule(60000L, InventoryManager.this._refreshInterval, false));
            this._pollNumber = 0;
            this._pool = new PooledThreadExecutor("Inventory Worker Pool", 1, 5, 30L);
        }

        private boolean startWorker(NEInventoryNode node, SwitchImpl sw, boolean fullDisc) {
            SwitchInventoryWorkerIf worker = null;
            worker = node.getWorker();
            if (worker == null) {
                if (sw.getInetAddress() == null) {
                    _Logger.warn((Object)(sw.getWwn() + " inventory discovery skipped due to its unknown IP"));
                    return false;
                }
                if (!sw.isMDS()) {
                    _Logger.debug((Object)(sw.getIpAddress() + " inventory discovery skipped due to non manageable Cisco device"));
                    return false;
                }
                try {
                    if (!sw.isManageable()) {
                        throw new Exception(sw + " is not manageable");
                    }
                    sw.createPeer();
                }
                catch (Exception ex) {
                    _Logger.warn((Object)(sw.getIpAddress() + " inventory discovery skipped due to : " + ex.getMessage()));
                    return false;
                }
                worker = new SwitchInventoryWorker(sw);
                node.setWorker(worker);
                _Logger.debug((Object)(worker + " created"));
            } else {
                worker = new SwitchInventoryWorker(sw);
                node.setWorker(worker);
                if (fullDisc) {
                    worker.setDiscFlag(65279);
                } else {
                    worker.setDiscFlag(32);
                }
            }
            if (this._pool.isQueued(worker)) {
                return false;
            }
            this._pool.execute(worker);
            return true;
        }

        private boolean startWorker(NEInventoryNode node, EthSwitchImpl sw, boolean fullDisc) {
            SwitchInventoryWorkerIf worker = null;
            worker = node.getWorker();
            if (worker == null) {
                if (!sw.isReachable()) {
                    _Logger.debug((Object)(sw.getName() + " inventory discovery skipped switch due to not reachabled"));
                    return false;
                }
                if (!sw.isManageable()) {
                    _Logger.debug((Object)(sw.getName() + " inventory discovery skipped switch due to not manageable"));
                    return false;
                }
                if (sw.getBase().isFex()) {
                    _Logger.debug((Object)(sw.getName() + " inventory discovery skipped fex switch object"));
                    return false;
                }
                if (sw.getInetAddress() == null) {
                    _Logger.warn((Object)(sw.getPK() + " inventory discovery skipped due to its unknown IP"));
                    return false;
                }
                if (!sw.getBase().isCisco()) {
                    _Logger.debug((Object)(sw.getIpAddress() + " inventory discovery skipped due to non Cisco device"));
                    return false;
                }
                try {
                    sw.getPeer();
                }
                catch (Exception ex) {
                    _Logger.warn((Object)(sw.getIpAddress() + " inventory discovery skipped due to : " + ex.getMessage()));
                    return false;
                }
                worker = new EthSwitchInventoryWorker(sw);
                node.setWorker(worker);
                _Logger.debug((Object)(worker + " created"));
            } else if (fullDisc) {
                worker.setDiscFlag(31);
                worker.setDiscFlag(1024);
            } else {
                worker.setDiscFlag(32);
            }
            if (this._pool.isQueued(worker)) {
                return false;
            }
            this._pool.execute(worker);
            return true;
        }

        void start() {
            this._pollNumber = 0;
            this.run();
        }

        void stop() {
            this._pool.shutdownNow();
        }

        @Override
        public void run() {
            InventoryManager.this._lastScanTime = System.currentTimeMillis();
            SanManager sm = SanManager.getInstance();
            DCManager dcm = DCManager.getInstance();
            boolean fullDisc = this._pollNumber++ % 5 == 0;
            for (NEInventoryNode node : InventoryManager.this._neNodesByPK.values()) {
                EthSwitchImpl ethSw;
                if (node._swPK instanceof WwnKey) {
                    FabricPK[] pks;
                    for (FabricPK fKey : pks = SanManager.getInstance().getFabricPKs()) {
                        SwitchImpl fcSw = sm.findSwitch((WwnKey)node._swPK, fKey);
                        if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) && fcSw != null && fcSw.isNpvEnabled()) {
                            fcSw.setManageable(false, "unmanaged no NPV discovery");
                            continue;
                        }
                        if (fcSw == null) continue;
                        if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) && fcSw.isNpvEnabled()) {
                            fcSw.setManageable(false, "unmanaged no NPV discovery");
                            continue;
                        }
                        this.startWorker(node, fcSw, fullDisc);
                    }
                    continue;
                }
                if (node._swPK instanceof SerialNumKey) {
                    ethSw = dcm.findEthSwitchBySwPK((SerialNumKey)node._swPK);
                    if (ethSw == null) continue;
                    this.startWorker(node, ethSw, fullDisc);
                    continue;
                }
                if (node._swPK instanceof VdcPK) {
                    ethSw = dcm.findEthSwitchBySwPK((VdcPK)node._swPK);
                    if (ethSw == null) continue;
                    this.startWorker(node, ethSw, fullDisc);
                    continue;
                }
                _Logger.warn((Object)("Inventory tree is out of sync: " + node._swPK));
                InventoryManager.getInstance().unmanage(node._swPK);
            }
        }
    }
}

