/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.util.SyncedBoolean;
import com.cisco.dcbu.sm.server.db.InventoryPersistent;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorkerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SwitchInventoryWorker
implements SwitchInventoryWorkerIf {
    static final int DISC_CARD = 1;
    static final int DISC_FAN = 2;
    static final int DISC_POWER = 4;
    static final int DISC_SENSOR = 8;
    static final int DISC_PORT = 16;
    static final int DISC_SW = 32;
    static final int DISC_LIC = 64;
    static final int DISC_HBA = 128;
    static final int DISC_LUN0 = 256;
    static final int DISC_SSMFEATURE = 512;
    static final int DISC_FEX = 1024;
    static final int DISC_HW = 31;
    static final int DISC_ALL = 65535;
    static final int DISC_ALL_BUT_LUN0 = 65279;
    static final int DISC_ALL_ETHSW = 63;
    private int _discFlags = 65279;
    private SwitchImpl _sw;
    private SyncedBoolean _isDiscovering = new SyncedBoolean(false);
    static Logger _Logger = LogManager.getLogger((String)"fms.inventory");

    SwitchInventoryWorker(SwitchImpl sw) {
        this._sw = sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._isDiscovering.get()) {
            return;
        }
        this._isDiscovering.set(true);
        try {
            if (this.discover()) {
                try {
                    InventoryPersistent.getInstance().persist(this._sw);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)(this + ": persisting inventory failed"), (Throwable)ex);
                }
            }
            SwitchImpl[] swList = SanManager.getInstance().findSwitches(this._sw.getSwitchPK());
            for (int i = 0; swList != null && i < swList.length; ++i) {
                if (swList[i] == this._sw) continue;
                SwitchImpl.syncSwitch(this._sw, swList[i]);
                try {
                    InventoryPersistent.getInstance().persist(swList[i]);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)(swList[i] + ": persisting inventory failed"), (Throwable)ex);
                }
            }
        }
        finally {
            this._isDiscovering.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        SyncedBoolean syncedBoolean = this._isDiscovering;
        synchronized (syncedBoolean) {
            if (this._isDiscovering.get()) {
                this._isDiscovering.set(false);
                this._isDiscovering.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDiscovering() {
        SyncedBoolean syncedBoolean = this._isDiscovering;
        synchronized (syncedBoolean) {
            return this._isDiscovering.get();
        }
    }

    public String toString() {
        return this._sw.getIpAddress() + "-SwitchInventoryWorker";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean discover() {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                try {
                                    if (SnmpAdapter.isHardwareInventoryChanged(this._sw)) {
                                        this.setDiscFlag(31);
                                    }
                                    SwitchInventoryWorker._Logger.debug((Object)(this + ": entity change checked"));
                                }
                                catch (Exception ex) {
                                    if (ex instanceof SnmpException) {
                                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": checking entity change failed: " + ex.getMessage()));
                                    } else {
                                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": checking entity change failed: " + ex.getMessage()), (Throwable)ex);
                                    }
                                    if (this._sw.isManageable()) break block25;
                                    return false;
                                }
                            }
                            if (this.isDiscFlagSet(31)) {
                                try {
                                    SnmpAdapter.discoverHardwareInventory(this._sw);
                                    this.resetDiscFlag(31);
                                    SwitchInventoryWorker._Logger.debug((Object)(this + ": hardware inventory rediscovered"));
                                }
                                catch (Exception ex) {
                                    SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering hardware inventory failed: " + ex.getMessage()), (Throwable)ex);
                                    if (this._sw.isManageable()) ** GOTO lbl36
                                    return false;
                                }
                            } else {
                                try {
                                    SnmpAdapter.updateHardwareInventoryStatus(this._sw);
                                    SwitchInventoryWorker._Logger.debug((Object)(this + ": hardware inventory status refreshed"));
                                }
                                catch (Exception ex) {
                                    if (ex instanceof SnmpException) {
                                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": refreshing hardware inventory status failed: " + ex.getMessage()));
                                    } else {
                                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": refreshing hardware inventory status failed: " + ex.getMessage()), (Throwable)ex);
                                    }
                                    if (this._sw.isManageable()) break block26;
                                    return false;
                                }
                            }
                        }
                        try {
                            SnmpAdapter.discoverSsmFeatures(this._sw);
                            this.resetDiscFlag(512);
                            SwitchInventoryWorker._Logger.debug((Object)(this + ": SSM FEATURE rediscovered"));
                        }
                        catch (Exception ex) {
                            SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering SSM FEATURE failed: " + ex.getMessage()), (Throwable)ex);
                            if (this._sw.isManageable()) break block27;
                            return false;
                        }
                    }
                    if (this.isDiscFlagSet(32)) {
                        // empty if block
                    }
                    try {
                        numLic = SnmpAdapter.discoverNumLicense(this._sw);
                        if (numLic != this._sw.getNumLicensedFeatures()) {
                            this._sw.setNumLicensedFeatures(numLic);
                        }
                        SwitchInventoryWorker._Logger.debug((Object)(this + ": number of license checked"));
                        SnmpAdapter.discoverLicenses(this._sw);
                        this.resetDiscFlag(64);
                        SwitchInventoryWorker._Logger.debug((Object)(this + ": license inventory rediscovered"));
                    }
                    catch (Exception ex) {
                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering license inventory failed: " + ex.getMessage()), (Throwable)ex);
                        if (this._sw.isManageable()) break block28;
                        return false;
                    }
                }
                if (this.isDiscFlagSet(128)) {
                    try {
                        SnmpAdapter.discoverHbas(this._sw);
                        this.resetDiscFlag(128);
                        SwitchInventoryWorker._Logger.debug((Object)(this + ": HBA rediscovered"));
                    }
                    catch (Exception ex) {
                        SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering HBA failed: " + ex.getMessage()), (Throwable)ex);
                        if (this._sw.isManageable()) break block29;
                        return false;
                    }
                }
            }
            if (this.isDiscFlagSet(256)) {
                try {
                    SnmpAdapter.discoverTargets(this._sw);
                    this.resetDiscFlag(256);
                    SwitchInventoryWorker._Logger.debug((Object)(this + ": LUN0 rediscovered"));
                }
                catch (Exception ex) {
                    SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering LUN0 failed: " + ex.getMessage()), (Throwable)ex);
                    if (this._sw.isManageable()) break block30;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void setDiscFlag(int flag) {
        this._discFlags |= flag;
    }

    @Override
    public void resetDiscFlag(int flag) {
        this._discFlags &= ~flag;
    }

    @Override
    public boolean isDiscFlagSet(int flag) {
        return (this._discFlags & flag) != 0;
    }
}

