/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.comm;

import com.cisco.dcbu.sm.server.ioa.comm.SwitchCommFactory;
import com.cisco.dcbu.sm.server.ioa.comm.Vsh;
import com.cisco.dcbu.sm.server.ioa.comm.VshWrap;
import com.cisco.dcbu.sm.server.ioa.exception.IOAException;
import com.cisco.dcbu.sm.server.ioa.exception.IOASwitchCommunicationException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IOAXmlHandler {
    private String clusterName = "IOA";
    private String switchIP = null;
    private String user = null;
    private String pwd = null;
    private boolean isEncrypted = true;
    static Logger _Logger = Logger.getLogger((String)"IOA_SRV");

    public String sendReceive(String msgOut) throws IOAException {
        return this.sendReceive(msgOut, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendReceive(String msgOut, boolean closeConnectionAfterReceived) throws IOAException {
        String msgIn = null;
        VshWrap _vshWrap = null;
        msgOut = msgOut + "\n";
        if (this.switchIP == null) {
            throw new IOASwitchCommunicationException("Switch IP address is null, connectivity failure for cluster " + this.clusterName);
        }
        _Logger.debug((Object)("Obtaining a session for user " + this.user + " cluster " + this.clusterName + (this.switchIP != null ? " to switch " + this.switchIP : "")));
        try {
            SwitchCommFactory commFactory = SwitchCommFactory.getInstance();
            _vshWrap = commFactory.getIOASshSession(this.clusterName, this.switchIP, this.user, this.pwd, this.isEncrypted);
        }
        catch (IOASwitchCommunicationException swe) {
            if (_vshWrap == null) throw swe;
            SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            throw swe;
        }
        catch (IOAException se) {
            if (_vshWrap == null) throw se;
            SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            throw se;
        }
        Vsh _vsh = null;
        if (_vshWrap != null) {
            _vsh = _vshWrap.getVsh();
            if (_vsh != null) {
                try {
                    _Logger.debug((Object)("Sending message to " + _vsh.getHost()));
                    _vsh.send(msgOut);
                    while ((msgIn = _vsh.readLine()).length() > 0 && msgIn.charAt(0) != '<') {
                    }
                    _Logger.debug((Object)("Received message from " + _vsh.getHost()));
                    if (closeConnectionAfterReceived) {
                        SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    }
                    SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    return msgIn;
                }
                catch (IOASwitchCommunicationException swe) {
                    if (_vshWrap == null) throw swe;
                    SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    throw swe;
                }
                catch (IOException ioe) {
                    if (_vshWrap == null) throw new IOASwitchCommunicationException(ioe.getMessage());
                    SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
                    throw new IOASwitchCommunicationException(ioe.getMessage());
                }
            }
            if (closeConnectionAfterReceived) {
                SwitchCommFactory.closeSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            }
            SwitchCommFactory.releaseSshSession(this.clusterName, this.switchIP, this.user, _vshWrap.getId());
            return null;
        }
        _Logger.warn((Object)("No Session could be obtained for user " + this.user + " cluster " + this.clusterName + (this.switchIP != null ? " to switch " + this.switchIP : "")));
        throw new IOASwitchCommunicationException("No Session can be initialized for switch: " + this.switchIP + "for user: " + this.user);
    }

    private IOAXmlHandler(String clusterName, String userName, String password) {
        this.user = userName;
        this.pwd = password;
    }

    public IOAXmlHandler(String clusterName, String switchIP, String userName, String password) {
        this(clusterName, userName, password);
        this.switchIP = switchIP;
    }

    public IOAXmlHandler(String clusterName, String switchIP, String userName, String password, boolean isEncrypted) {
        this(clusterName, userName, password);
        this.switchIP = switchIP;
        this.isEncrypted = isEncrypted;
    }

    public String getSwitchIP() {
        return this.switchIP;
    }
}

