/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.message;

import com.cisco.dcbu.sm.server.ioa.exception.IOAException;
import com.cisco.dcbu.sm.server.ioa.exception.IOAInvalidMessageException;
import com.cisco.dcbu.sm.server.ioa.exception.IOAMessageException;
import com.cisco.dcbu.sm.server.ioa.exception.IOAPermissionDeniedException;
import com.cisco.dcbu.sm.server.ioa.message.JAXBContextFactory;
import com.cisco.dcbu.sm.server.ioa.xml.IOAMessage;
import com.cisco.dcbu.sm.server.ioa.xml.IOAMessageHeader;
import com.cisco.dcbu.sm.server.ioa.xml.IOAOpcodeEnum;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableEnum;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableReqHeader;
import com.cisco.dcbu.sm.server.ioa.xml.ObjectFactory;
import com.cisco.dcbu.sm.server.ioa.xml.OperationEnum;
import com.cisco.dcbu.sm.server.ioa.xml.ResponseStatusEnum;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class IOAMessageBase {
    static Logger _Logger = Logger.getLogger((String)"IOA_SRV");

    protected IOAMessage parseIOAMessage(InputStream msg) {
        IOAMessage IOAMessage2 = null;
        try {
            JAXBContext jc = JAXBContextFactory.getInstance().getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement IOAElement = (JAXBElement)u.unmarshal(msg);
            IOAMessage2 = (IOAMessage)IOAElement.getValue();
        }
        catch (JAXBException je) {
            _Logger.error((Object)("Failed in JAXB unmarshal. Exception: " + je.getMessage()));
            return null;
        }
        catch (Exception e) {
            _Logger.error((Object)("Failed in JAXB unmarshal. Exception: " + e.getMessage()));
            return null;
        }
        return IOAMessage2;
    }

    protected String buildIOAMessage(IOAMessage IOAMessage2) {
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        try {
            JAXBContext jc = JAXBContextFactory.getInstance().getJAXBContext();
            JAXBElement IOA = new ObjectFactory().createIOA_Message(IOAMessage2);
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)IOA, (OutputStream)msg);
        }
        catch (JAXBException je) {
            _Logger.error((Object)("Failed in JAXB marshal. Exception: " + je.getMessage()));
        }
        return msg.toString();
    }

    protected IOAMessageHeader ioaMessageHeader(String version, OperationEnum operation) {
        IOAMessageHeader msgHeader = new IOAMessageHeader();
        msgHeader.setVersion(version);
        msgHeader.setOperation(operation);
        return msgHeader;
    }

    protected IOATableReqHeader ioaTableHeader(IOATableEnum table, IOAOpcodeEnum opcode) {
        IOATableReqHeader tableReqHeader = new IOATableReqHeader();
        tableReqHeader.setTable(table);
        tableReqHeader.setOpcode(opcode);
        return tableReqHeader;
    }

    protected IOATableReqHeader ioaTableHeader(IOATableEnum table, IOAOpcodeEnum opcode, int count) {
        IOATableReqHeader tableReqHeader = this.ioaTableHeader(table, opcode);
        tableReqHeader.setGet_Next_Count(Integer.valueOf(count));
        return tableReqHeader;
    }

    public boolean analyzeResponse(IOAMessage IOAMessage2) throws IOAException {
        if (IOAMessage2 == null) {
            throw new IOAInvalidMessageException("Invalid response received from the switch");
        }
        if (IOAMessage2.getMsg_Header().isIS_Resp()) {
            _Logger.info((Object)("Received opcode: " + IOAMessage2.getTable_Req_Header().getOpcode() + " status: " + IOAMessage2.getMsg_Header().getResponse_Status() + " description: " + IOAMessage2.getMsg_Header().getResponse_Status_Desc()));
            if (IOAMessage2.getMsg_Header().getResponse_Status() == ResponseStatusEnum.BASE___SVC___FAILURE) {
                throw new IOAMessageException(IOAMessage2.getMsg_Header().getResponse_Status_Desc());
            }
            if (IOAMessage2.getMsg_Header().getResponse_Status() == ResponseStatusEnum.BASE___SVC___ENOPERMISSIONS) {
                throw new IOAPermissionDeniedException(IOAMessage2.getMsg_Header().getResponse_Status_Desc());
            }
            return IOAMessage2.getMsg_Header().getResponse_Status() != ResponseStatusEnum.BASE___SVC___ENOMOREOBJECTS;
        }
        throw new IOAInvalidMessageException("Invalid response received from the switch");
    }
}

