/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import java.util.EnumSet;

public class LicenseCapabilities {
    public static EnumSet<Features> fmLicenseFeatures = EnumSet.of(Features.PM, new Features[]{Features.REMOTE_OPEN, Features.REMOTE_MULTI_OPEN, Features.LOCAL_MULTI_OPEN, Features.WC_NAV, Features.WC_NAV, Features.WC_SCH, Features.MULTI_SESSIONS});
    public static EnumSet<Features> fmEvalLicenseFeatures = EnumSet.of(Features.PM, new Features[]{Features.REMOTE_OPEN, Features.REMOTE_MULTI_OPEN, Features.LOCAL_MULTI_OPEN, Features.WC_NAV, Features.WC_NAV, Features.WC_SCH, Features.MULTI_SESSIONS});
    public static EnumSet<Features> dmmLicenseFeatures = EnumSet.of(Features.LOCAL_MULTI_OPEN, Features.MULTI_SESSIONS, Features.DMM);
    public static EnumSet<Features> smeLicenseFeatures = EnumSet.of(Features.LOCAL_MULTI_OPEN, Features.MULTI_SESSIONS);
    private static LicenseCapabilities _Instance = null;

    private LicenseCapabilities() {
    }

    public static LicenseCapabilities getInstance() {
        if (_Instance == null) {
            _Instance = new LicenseCapabilities();
        }
        return _Instance;
    }

    public boolean isCapable(LicenseTypes type, Features feature) {
        if (type.equals((Object)LicenseTypes.FM)) {
            return fmLicenseFeatures.contains((Object)feature);
        }
        if (type.equals((Object)LicenseTypes.FM_EVAL)) {
            return fmEvalLicenseFeatures.contains((Object)feature);
        }
        if (type.equals((Object)LicenseTypes.DMM)) {
            return dmmLicenseFeatures.contains((Object)feature);
        }
        if (type.equals((Object)LicenseTypes.SME)) {
            return smeLicenseFeatures.contains((Object)feature);
        }
        return false;
    }

    public static enum LicenseTypes {
        FM,
        FM_EVAL,
        DMM,
        SME;

    }

    public static enum Features {
        PM,
        REMOTE_OPEN,
        REMOTE_MULTI_OPEN,
        LOCAL_MULTI_OPEN,
        WC_REPORT,
        WC_NAV,
        WC_SCH,
        MULTI_SESSIONS,
        DMM;

    }
}

