/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.server.licmgr.FmHostId;
import com.cisco.dcbu.sm.server.licmgr.LicensingException;
import com.cisco.magellan.ciscoInfo;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.VendorInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LicenseValidatorFlexnet {
    private static int[] UCS6KModelTypes = new int[]{847, 899, 1062, 1063};
    private static int[] N7KModelTypes = new int[]{612, 777, 932, 1147};
    private static int[] N64ModelTypes = new int[]{1237, 1489};
    private static int[] N61ModelTypes = new int[]{1308, 1340};
    private static int[] N5KModelTypes = new int[]{719, 798, 935, 934, 936, 1008, 1084, 1038, 1175, 1410, 1409};
    private static int[] N3KModelTypes = new int[]{1060, 1105, 1106, 1107, 1163, 1239, 1390, 1238, 1417, 1388};
    private static int[] MDS9100Types = new int[]{411, 414, 514, 587, 616, 841, 1491, 601, 606, 773, 843};
    private static int[] MDS9200Types = new int[]{380, 442, 472, 651, 1326};
    private static int[] MDS9500Types = new int[]{375, 376, 377};
    private static int[] MDS9700Types = new int[]{1327};
    public static int[] N77ModelTypes = new int[]{1353, 1352, 1354};
    public static int[] N95KModelTypes = new int[]{1467};
    public static int[] N93KModelTypes = new int[]{1510, 1508, 1509};
    private static final ArrayList<String> _FEATURE_SET = new ArrayList();
    private static final ArrayList<String> _LAN_FEATURE_SET;
    public static final HashMap<String, List<Integer>> _SAN_LICENSE_TO_DEVICE_TYPE_MAP;
    public static final HashMap<String, List<Integer>> _LAN_LICENSE_TO_DEVICE_TYPE_MAP;
    public static List<Integer> sanlicenseSupportedDeviceTypes;
    public static List<Integer> lanlicenseSupportedDeviceTypes;
    static Logger _Logger;
    private static final String NODE_COUNT_KEY = "DeviceCount";
    private static final String PID_KEY = "PID";
    private static final String VENDOR_STRING_SEP = ",";
    private static final FilenameFilter licFilter;

    public static List<Integer> getALLUCS6KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(UCS6KModelTypes);
    }

    public static List<Integer> getAllN5KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(N5KModelTypes);
    }

    public static List<Integer> getAll9700Types() {
        return LicenseValidatorFlexnet.asIntegerList(MDS9700Types);
    }

    public static List<Integer> getAll9500Types() {
        return LicenseValidatorFlexnet.asIntegerList(MDS9500Types);
    }

    public static List<Integer> getAll9200Types() {
        return LicenseValidatorFlexnet.asIntegerList(MDS9200Types);
    }

    public static List<Integer> getAll9100Types() {
        return LicenseValidatorFlexnet.asIntegerList(MDS9100Types);
    }

    public static List<Integer> getAllN3KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(N3KModelTypes);
    }

    public static List<Integer> getAllN7KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(N7KModelTypes);
    }

    public static List<Integer> getAllN64Types() {
        return LicenseValidatorFlexnet.asIntegerList(N64ModelTypes);
    }

    public static List<Integer> getAllN61Types() {
        return LicenseValidatorFlexnet.asIntegerList(N61ModelTypes);
    }

    public static List<Integer> getAllN77Types() {
        return LicenseValidatorFlexnet.asIntegerList(N77ModelTypes);
    }

    public static List<Integer> getAllN95KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(N95KModelTypes);
    }

    public static List<Integer> getAllN93KTypes() {
        return LicenseValidatorFlexnet.asIntegerList(N93KModelTypes);
    }

    private static List<Integer> asIntegerList(int[] intArray) {
        ArrayList<Integer> intList = new ArrayList<Integer>(intArray.length);
        for (int i : intArray) {
            intList.add(i);
        }
        return intList;
    }

    public static List<Integer> getLicenseableSanSwitchTypes() {
        return sanlicenseSupportedDeviceTypes;
    }

    public static List<Integer> getLicenseableLanSwitchTypes() {
        return lanlicenseSupportedDeviceTypes;
    }

    public static List<Integer> getProductTypes(String featureNameStr) {
        ArrayList<Integer> productTypes = new ArrayList<Integer>();
        if (_FEATURE_SET.contains(featureNameStr)) {
            productTypes.add(1);
        }
        if (_LAN_FEATURE_SET.contains(featureNameStr)) {
            productTypes.add(2);
        }
        return productTypes;
    }

    public static boolean isLicenseForType(LicenseInfoFlex lic, int switchType, int licenseType) {
        List<Integer> typesForLic;
        String featureNameStr = lic.getFeatureName();
        String pidDeviceStr = lic.getPidDeviceStr();
        if (licenseType == 1) {
            if (!_FEATURE_SET.contains(featureNameStr)) {
                return false;
            }
            typesForLic = _SAN_LICENSE_TO_DEVICE_TYPE_MAP.get(pidDeviceStr);
        } else if (licenseType == 2) {
            if (!_LAN_FEATURE_SET.contains(featureNameStr)) {
                return false;
            }
            typesForLic = _LAN_LICENSE_TO_DEVICE_TYPE_MAP.get(pidDeviceStr);
        } else {
            return false;
        }
        if (typesForLic != null) {
            return typesForLic.contains(new Integer(switchType));
        }
        return false;
    }

    public static boolean isLicenseForPid(String pidDeviceStr, int switchType, int licenseType) {
        List<Integer> typesForLic;
        if (licenseType == 1) {
            typesForLic = _SAN_LICENSE_TO_DEVICE_TYPE_MAP.get(pidDeviceStr);
        } else if (licenseType == 2) {
            typesForLic = _LAN_LICENSE_TO_DEVICE_TYPE_MAP.get(pidDeviceStr);
        } else {
            return false;
        }
        if (typesForLic != null) {
            return typesForLic.contains(new Integer(switchType));
        }
        return false;
    }

    public static boolean isSwitchTypeLicenseable(int switchType, int licenseType) {
        if (licenseType == 1) {
            return sanlicenseSupportedDeviceTypes.contains(switchType);
        }
        if (licenseType == 2) {
            return lanlicenseSupportedDeviceTypes.contains(switchType);
        }
        return false;
    }

    public static File[] validateAndRetrieveFileFromLicDir(String licensesDir) throws Exception {
        File licDirFile = new File(licensesDir);
        if (!licDirFile.exists()) {
            throw new Exception("Licenses directory doesn't exist.");
        }
        if (licDirFile.isDirectory()) {
            File[] contents = licDirFile.listFiles(licFilter);
            if (contents == null || contents.length == 0) {
                throw new Exception("Licenses directory is empty.");
            }
            return contents;
        }
        if (licensesDir.endsWith(".lic")) {
            return new File[]{licDirFile};
        }
        throw new Exception("Invalid license directory.");
    }

    public static LicenseInfoFlex[] getDetailedLicenseInfo(File[] contents, List<String> errFileNames) {
        ArrayList<LicenseInfoFlex> validLInfos = new ArrayList<LicenseInfoFlex>();
        HashSet<String> signs = new HashSet<String>();
        for (int i = 0; i < contents.length; ++i) {
            try {
                LicenseInfoFlex[] lInfo;
                for (LicenseInfoFlex nextLInfo : lInfo = LicenseValidatorFlexnet.getLicenseInfo(contents[i].getAbsolutePath())) {
                    if (signs.contains(nextLInfo.getSignature())) continue;
                    signs.add(nextLInfo.getSignature());
                    validLInfos.add(nextLInfo);
                }
                continue;
            }
            catch (LicensingException e) {
                errFileNames.add(contents[i].getName());
                _Logger.error((Object)("Ignoring invalid license file: " + contents[i].getAbsolutePath()), (Throwable)e);
            }
        }
        LicenseInfoFlex[] lInfos = new LicenseInfoFlex[validLInfos.size()];
        validLInfos.toArray(lInfos);
        return lInfos;
    }

    private static LicenseInfoFlex[] getLicenseInfo(String licensesFilePath) throws LicensingException {
        ArrayList<LicenseInfoFlex> lInfo = new ArrayList<LicenseInfoFlex>();
        File licDirFile = new File(licensesFilePath);
        if (!licDirFile.exists()) {
            throw LicensingException.errorLicSourceNotExists(licensesFilePath);
        }
        try {
            ciscoInfo vInfo = new ciscoInfo();
            vInfo.registerVendorHostId((HostId)new FmHostId());
            LicenseSource ls = LicenseSource.createLicenseSource((String)licensesFilePath, (VendorInfo)vInfo, null);
            Object[] featureList = ls.getFeatureList();
            if (featureList == null || featureList.length == 0) {
                throw LicensingException.errorLicFeaturesRead(licensesFilePath);
            }
            if (featureList != null) {
                Arrays.sort(featureList);
                for (Object featureName : featureList) {
                    Feature[] details;
                    if (!_FEATURE_SET.contains(featureName) && !_LAN_FEATURE_SET.contains(featureName)) {
                        LicensingException.errorLic("License file not for this product", licensesFilePath);
                    }
                    if ((details = ls.getFeatureDetails((String)featureName)) == null || details.length == 0) {
                        throw LicensingException.errorLicDcnmFeaturesRead(licensesFilePath);
                    }
                    for (int i = 0; i < details.length; ++i) {
                        String vendorString = details[i].getVendorString();
                        String noticeStr = details[i].getNotice();
                        String licFileId = LicenseValidatorFlexnet.getElemValue(noticeStr, "LicFileID");
                        String licLineId = LicenseValidatorFlexnet.getElemValue(noticeStr, "LicLineID");
                        String pak = LicenseValidatorFlexnet.getElemValue(noticeStr, "PAK");
                        String sig = details[i].getSignature();
                        String expirationDateStr = details[i].getExpirationDate();
                        Calendar expDateCal = null;
                        boolean permanentLic = false;
                        if (!expirationDateStr.trim().equals("permanent")) {
                            try {
                                Calendar temp = Calendar.getInstance();
                                Date expDate = LicenseInfoFlex.dateFormat.parse(expirationDateStr);
                                temp.setTime(expDate);
                                expDateCal = temp;
                            }
                            catch (ParseException pe) {
                                throw LicensingException.errorLicSourceExpirationDateReadError(licensesFilePath);
                            }
                        } else {
                            permanentLic = true;
                        }
                        int idx = vendorString.indexOf(NODE_COUNT_KEY);
                        int idxPid = vendorString.indexOf(PID_KEY);
                        if (idx == -1 || idxPid == -1) {
                            throw LicensingException.errorLicDcnmFeaturesRead(licensesFilePath);
                        }
                        int lastIdx = vendorString.indexOf(VENDOR_STRING_SEP, idx = vendorString.indexOf("=", idx));
                        String nodeCountStr = lastIdx != -1 ? vendorString.substring(idx + 1, lastIdx).trim() : vendorString.substring(idx + 1).trim();
                        int nodesCount = Integer.parseInt(nodeCountStr);
                        idxPid = vendorString.indexOf("=", idxPid);
                        lastIdx = vendorString.indexOf(VENDOR_STRING_SEP, idxPid);
                        String pidStr = lastIdx != -1 ? vendorString.substring(idxPid + 1, lastIdx).trim() : vendorString.substring(idxPid + 1).trim();
                        String pidDeviceStr = null;
                        if (pidStr != null) {
                            ArrayList<String> keys = new ArrayList<String>();
                            if (_FEATURE_SET.contains(featureName)) {
                                keys.addAll(_SAN_LICENSE_TO_DEVICE_TYPE_MAP.keySet());
                            }
                            if (_LAN_FEATURE_SET.contains(featureName)) {
                                keys.addAll(_LAN_LICENSE_TO_DEVICE_TYPE_MAP.keySet());
                            }
                            for (String nextKey : keys) {
                                if (pidStr.indexOf(nextKey) == -1) continue;
                                pidDeviceStr = nextKey;
                                break;
                            }
                        }
                        if (nodesCount <= 0 || pidDeviceStr == null) continue;
                        LicenseInfoFlex nextLic = new LicenseInfoFlex(licDirFile.getName(), (String)featureName, pidStr, pidDeviceStr, permanentLic, nodesCount, expDateCal, sig, licFileId, licLineId, pak);
                        lInfo.add(nextLic);
                    }
                }
            }
        }
        catch (FlexlmException e) {
            e.printStackTrace();
            throw LicensingException.errorFlexlm(e.getMajor(), e.getMessage(), licensesFilePath);
        }
        return lInfo.toArray(new LicenseInfoFlex[lInfo.size()]);
    }

    private static String getElemValue(String source, String elemName) {
        int idxStart = source.indexOf("<" + elemName + ">");
        int idxEnd = source.indexOf("</" + elemName + ">");
        if (idxStart != -1 && idxEnd != -1) {
            return source.substring(idxStart + elemName.length() + 2, idxEnd);
        }
        return "";
    }

    static {
        _FEATURE_SET.add("DCNM-SAN");
        _FEATURE_SET.add("DCNM-SAN-LAN");
        _LAN_FEATURE_SET = new ArrayList();
        _LAN_FEATURE_SET.add("LAN-ENT-N7K");
        _LAN_FEATURE_SET.add("DCNM-SAN-LAN");
        _LAN_FEATURE_SET.add("DCNM-LAN");
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP = new HashMap();
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP = new HashMap();
        sanlicenseSupportedDeviceTypes = new ArrayList<Integer>();
        lanlicenseSupportedDeviceTypes = new ArrayList<Integer>();
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("M95", LicenseValidatorFlexnet.getAll9500Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("M92", LicenseValidatorFlexnet.getAll9200Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("M91", LicenseValidatorFlexnet.getAll9100Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("M97", LicenseValidatorFlexnet.getAll9700Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N7K", LicenseValidatorFlexnet.getAllN7KTypes());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N5K", LicenseValidatorFlexnet.getAllN5KTypes());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N64", LicenseValidatorFlexnet.getAllN64Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N61", LicenseValidatorFlexnet.getAllN61Types());
        _SAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N77", LicenseValidatorFlexnet.getAllN77Types());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N7K", LicenseValidatorFlexnet.getAllN7KTypes());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N3K", LicenseValidatorFlexnet.getAllN3KTypes());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N5K", LicenseValidatorFlexnet.getAllN5KTypes());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N64", LicenseValidatorFlexnet.getAllN64Types());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N61", LicenseValidatorFlexnet.getAllN61Types());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N77", LicenseValidatorFlexnet.getAllN77Types());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N95", LicenseValidatorFlexnet.getAllN95KTypes());
        _LAN_LICENSE_TO_DEVICE_TYPE_MAP.put("N93", LicenseValidatorFlexnet.getAllN93KTypes());
        Set<String> mapKey = _SAN_LICENSE_TO_DEVICE_TYPE_MAP.keySet();
        for (String nextKey : mapKey) {
            sanlicenseSupportedDeviceTypes.addAll((Collection<Integer>)_SAN_LICENSE_TO_DEVICE_TYPE_MAP.get(nextKey));
        }
        mapKey = _LAN_LICENSE_TO_DEVICE_TYPE_MAP.keySet();
        for (String nextKey : mapKey) {
            lanlicenseSupportedDeviceTypes.addAll((Collection<Integer>)_LAN_LICENSE_TO_DEVICE_TYPE_MAP.get(nextKey));
        }
        _Logger = LogManager.getLogger((String)"fms.license");
        licFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lic");
            }
        };
    }
}

