/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.ClusterInterfBase;
import com.cisco.dcbu.sm.common.model.ClusterMemberBase;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public final class ClusterImpl
extends AbstractModelObjectImpl {
    static final String QuerySQLByFabricID = "select id, cluster_id, name, cluster_type, state, master_addr_type, master_addr, switch_id, is_present from base_svc_cluster where fabric_id=?";
    static final String QuerySQLByFabricIDClusterID = "select id, fabric_id, name, cluster_type, state, master_addr_type, master_addr, switch_id, is_present from base_svc_cluster where fabric_id=? and cluster_id=?";
    static final String InsertSQL = "insert into base_svc_cluster(id, fabric_id, cluster_id, name, cluster_type, state, master_addr_type, master_addr, switch_id, is_present, last_update_time ) values(?,?,?,?,?,?,?,?,?,?,?)";
    static final String UpdateSQL = "update base_svc_cluster set fabric_id=?, cluster_id=?, name=?, cluster_type=?, state=?, master_addr_type=?, master_addr=?, switch_id=?, is_present=?, last_update_time=? where id=?";
    static final String DeleteSQL = "delete from base_svc_cluster where id=?";
    static final String TableName = "base_svc_cluster";
    public static final short CLUSTER_TYPE_SME = 1;
    public static final short CLUSTER_TYPE_IOA = 2;
    private final ClusterBase _base;
    private SwitchImpl _sw;
    private FabricImpl _fabric;
    private Hashtable<NameKey, ClusterInterfBase> _cInterfByIPIfIndex = new Hashtable();
    private Hashtable<NameKey, ClusterMemberBase> _cMemberByIP = new Hashtable();

    ClusterImpl(ClusterPK pk, short type, short state, short masterInetAddrType, String masterInetAddr, SwitchImpl sw) {
        this._base = new ClusterBase(pk, type, state, masterInetAddrType, masterInetAddr);
        this._sw = sw;
    }

    public void setFabric(FabricImpl fabric) {
        this._fabric = fabric;
        this._base.setFabricPK(fabric.getPK());
    }

    @Override
    public FabricImpl getFabric() {
        return this._fabric;
    }

    public void setFabricPK(FabricPK fabricPK) {
        if (!this._base.getFabricPK().equals(fabricPK)) {
            FabricPK old = this._base.getFabricPK();
            this._base.setFabricPK(fabricPK);
            this.propertyChanged((short)2562, old, fabricPK);
        }
    }

    public SwitchImpl getSwitch() {
        return this._sw;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public PKIf getClusterPK() {
        return this._base.getPK();
    }

    public FabricPK getFabricPK() {
        return this._base.getFabricPK();
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByFabricIDClusterID);
                stat.setLong(1, this.getFabric().getDBID());
                stat.setString(1, this.getClusterId());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                rs.close();
                stat.close();
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            stat.setLong(1, this.getDBID());
            stat.setLong(2, this._fabric.getDBID());
            stat.setString(3, this.getClusterId());
            stat.setString(4, this.getName());
            stat.setInt(5, this.getType());
            stat.setInt(6, this.getState());
            stat.setInt(7, this.getMasterInetAddrType());
            stat.setString(8, this.getMasterInetAddr());
            if (this._sw != null) {
                stat.setLong(9, this._sw.getDBID());
            } else {
                stat.setNull(9, 4);
            }
            stat.setBoolean(10, this.isPresent());
            stat.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        stat.setLong(1, this._fabric.getDBID());
        stat.setString(2, this.getClusterId());
        stat.setString(3, this.getName());
        stat.setInt(4, this.getType());
        stat.setInt(5, this.getState());
        stat.setInt(6, this.getMasterInetAddrType());
        stat.setString(7, this.getMasterInetAddr());
        if (this._sw != null) {
            stat.setLong(8, this._sw.getDBID());
        } else {
            stat.setNull(8, 4);
        }
        stat.setBoolean(9, this.isPresent());
        stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
        stat.setLong(11, this.getDBID());
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(FabricImpl fImpl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByFabricID);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            arrayList = ClusterImpl.loadDBRecord(rs, fImpl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        ArrayList<ClusterImpl> al = new ArrayList<ClusterImpl>();
        while (rs.next()) {
            String clusterId = rs.getString(2);
            String name = rs.getString(3);
            int type = rs.getInt(4);
            int state = rs.getInt(5);
            int masterAddrType = rs.getInt(6);
            String masterAddr = rs.getString(7);
            long switchId = rs.getLong(8);
            SwitchImpl sw = fImpl.findSwitchByDbId(switchId);
            ClusterImpl cl = fImpl.createCluster(new ClusterPK(clusterId, name, type), (short)type, (short)state, (short)masterAddrType, masterAddr, sw);
            cl._base.setPresent(rs.getBoolean(9));
            cl.setFabric(fImpl);
            al.add(cl);
        }
        return al;
    }

    public String getClusterId() {
        return ((ClusterPK)this._base.getPK()).getCid();
    }

    public String getName() {
        return this._base.getName();
    }

    public short getType() {
        return this._base.getType();
    }

    public short getState() {
        return this._base.getState();
    }

    public void setState(short newStatus) {
        short oldStatus = this._base.getState();
        if (!GenUtil.equals(oldStatus, newStatus)) {
            this._base.setState(newStatus);
            this.propertyChanged((short)2563, Short.valueOf(oldStatus), Short.valueOf(newStatus));
        }
    }

    public short getMasterInetAddrType() {
        return this._base.getMasterInetAddrType();
    }

    public void setMasterInetAddrType(short newMasterInetAddrType) {
        short oldMasterInetAddrType = this._base.getMasterInetAddrType();
        if (!GenUtil.equals(oldMasterInetAddrType, newMasterInetAddrType)) {
            this._base.setMasterInetAddrType(newMasterInetAddrType);
            this.propertyChanged((short)2564, Short.valueOf(oldMasterInetAddrType), Short.valueOf(newMasterInetAddrType));
        }
    }

    public String getMasterInetAddr() {
        return this._base.getMasterInetAddr();
    }

    public void setMasterInetAddr(String newMasterInetAddr) {
        String oldMasterInetAddr = this._base.getMasterInetAddr();
        if (!GenUtil.equals(oldMasterInetAddr, newMasterInetAddr)) {
            this._base.setMasterInetAddr(newMasterInetAddr);
            this.propertyChanged((short)2565, (Serializable)((Object)oldMasterInetAddr), (Serializable)((Object)newMasterInetAddr));
        }
    }

    public String getMasterIPAddr() {
        return this._base.getMasterIPAddr();
    }

    public void setMasterIPAddr(String addr) {
        this._base.setMasterIPAddr(addr);
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)2561, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByFabricIDClusterID;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._fabric != null) {
            stat.setLong(2, this._fabric.getDBID());
        } else {
            stat.setNull(2, 4);
        }
        stat.setString(3, this.getClusterId());
        stat.setString(4, this.getName());
        stat.setInt(5, this.getType());
        stat.setInt(6, this.getState());
        stat.setInt(7, this.getMasterInetAddrType());
        stat.setString(8, this.getMasterInetAddr());
        if (this._sw != null) {
            stat.setLong(9, this._sw.getDBID());
        } else {
            stat.setNull(9, 4);
        }
        stat.setBoolean(10, this.isPresent());
        stat.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._fabric != null) {
            stat.setLong(1, this._fabric.getDBID());
        } else {
            stat.setNull(1, 4);
        }
        stat.setString(2, this.getClusterId());
        stat.setString(3, this.getName());
        stat.setInt(4, this.getType());
        stat.setInt(5, this.getState());
        stat.setInt(6, this.getMasterInetAddrType());
        stat.setString(7, this.getMasterInetAddr());
        if (this._sw != null) {
            stat.setLong(8, this._sw.getDBID());
        } else {
            stat.setNull(8, 4);
        }
        stat.setBoolean(9, this.isPresent());
        stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
        stat.setLong(11, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getFabric().getDBID());
        stat.setString(2, this.getClusterId());
    }

    public ClusterInterfBase[] getClusterInterfs() {
        return this._base.getClusterInterfs();
    }

    public void setClusterInterfs(ClusterInterfBase[] cInterfs) {
        Object[] oldInterfs = this._base.getClusterInterfs();
        if (cInterfs != null) {
            Arrays.sort(cInterfs);
        }
        if (!(cInterfs != null ? Arrays.equals(oldInterfs, cInterfs) : oldInterfs == null)) {
            this._base.setClusterInterfs(cInterfs);
            this.propertyChanged((short)2566, (Serializable)oldInterfs, (Serializable)cInterfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterInterfBase createClusterInterf(String swInetAddr, int ifIndex, short status) {
        Hashtable<NameKey, ClusterInterfBase> hashtable = this._cInterfByIPIfIndex;
        synchronized (hashtable) {
            NameKey pKey = new NameKey(swInetAddr + ":" + ifIndex);
            ClusterInterfBase cInterf = this._cInterfByIPIfIndex.get(pKey);
            if (cInterf == null) {
                cInterf = new ClusterInterfBase(ifIndex, swInetAddr, status);
                this._cInterfByIPIfIndex.put(pKey, cInterf);
            }
            return cInterf;
        }
    }

    public ClusterInterfBase findClusterInterf(String swInetAddr, int ifIndex) {
        NameKey pKey = new NameKey(swInetAddr + ":" + ifIndex);
        return this._cInterfByIPIfIndex.get(pKey);
    }

    public Hashtable<NameKey, ClusterInterfBase> getClusterInterfByIPIfIndex() {
        return this._cInterfByIPIfIndex;
    }

    public ClusterMemberBase[] getClusterMembers() {
        return this._base.getClusterMembers();
    }

    public void setClusterMembers(ClusterMemberBase[] cMembers) {
        Object[] oldMembers = this._base.getClusterMembers();
        if (cMembers != null) {
            Arrays.sort(cMembers);
        }
        if (!(cMembers != null ? Arrays.equals(oldMembers, cMembers) : oldMembers == null)) {
            this._base.setClusterMembers(cMembers);
            this.propertyChanged((short)2567, (Serializable)oldMembers, (Serializable)cMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterMemberBase createClusterMember(String swInetAddr) {
        Hashtable<NameKey, ClusterInterfBase> hashtable = this._cInterfByIPIfIndex;
        synchronized (hashtable) {
            NameKey pKey = new NameKey(swInetAddr);
            ClusterMemberBase cMember = this._cMemberByIP.get(pKey);
            if (cMember == null) {
                cMember = new ClusterMemberBase(swInetAddr);
                this._cMemberByIP.put(pKey, cMember);
            }
            return cMember;
        }
    }

    public ClusterMemberBase findClusterMember(String swInetAddr) {
        NameKey pKey = new NameKey(swInetAddr);
        return this._cMemberByIP.get(pKey);
    }

    public Hashtable<NameKey, ClusterMemberBase> getClusterMemberByIP() {
        return this._cMemberByIP;
    }
}

