/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.san.wo.KeyValueDO;
import com.cisco.dcbu.jaxws.san.wo.SnmpCredentialDO;
import com.cisco.dcbu.lan.webservice.client.LanWSDelegator;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskKey;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscoveryException;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.LanObject;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.DiscStatusType;
import com.cisco.dcbu.sm.common.type.DiscTaskType;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.EthDBObjectIf;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.CdpDiscvHelper;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCMgrHelper;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.FexIslImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.PmExtraOidImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.ServiceUtil;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import com.cisco.dcbu.sm.server.model.VlanImpl;
import com.cisco.dcbu.sm.server.web.admin.PerformanceHandler;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DCManager {
    public static final boolean TEST = false;
    public static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    private static DCManager _Instance = null;
    private static String NotFoundLan_Str = "Cannot find LAN instance";
    private LanImpl _singleLan;
    private static CopyOnWriteArrayList<ModelEventListenerIf> _listeners = new CopyOnWriteArrayList();
    private SnmpSession _snmpSession;
    private DbLoadStatus _dbLoadStatus = DbLoadStatus.NOTLOADED;

    public static synchronized DCManager getInstance() {
        if (_Instance == null) {
            _Instance = new DCManager();
        }
        if (_Instance != null && _Instance.getDbLoadStatus() == DbLoadStatus.LOADFAILED) {
            _Instance.openLansFromDB();
        }
        return _Instance;
    }

    public static synchronized void close() {
        if (_Instance != null && DCManager._Instance._snmpSession != null) {
            _Instance = null;
        }
    }

    private DCManager() {
        this.initLocalLan();
        this.addListener(GlobalDCManager.getInstance());
    }

    private void initLocalLan() {
        try {
            GlobalDCManager.getInstance().updateLanManageableByServer(false, null);
        }
        catch (SQLException ex) {
            _Tracer.log(Level.WARN, ex.getMessage());
        }
    }

    public SnmpSession getSnmpSession() {
        if (this._snmpSession == null) {
            try {
                this._snmpSession = ServiceUtil.initServiceSnmp(false);
                _Tracer.log(Level.INFO, "DCManager snmp session:" + this._snmpSession.getLocalHostAddress() + ":" + this._snmpSession.getLocalPort() + ", remote port=" + this._snmpSession.getRemotePort() + ", transport=" + this._snmpSession.getTransportProvider());
            }
            catch (Exception e) {
                _Tracer.log(Level.WARN, "DCManager cannot get snmp session", e);
            }
        }
        return this._snmpSession;
    }

    private LanPK createLanPK() {
        try {
            int lanId = (int)Sequence.getSequence().getFabricPK();
            return new LanPK(lanId, "LAN-" + lanId);
        }
        catch (SQLException ex) {
            _Tracer.log(Level.WARN, "Cannot create LanPK from sequence id, choose default 1 as LanPK id");
            return new LanPK(1, "LAN=1");
        }
    }

    private synchronized LanImpl createLan() {
        if (this._singleLan == null) {
            this._singleLan = new LanImpl(this.createLanPK());
        }
        return this._singleLan;
    }

    private synchronized void deleteLan() {
        this._singleLan = null;
    }

    public synchronized LanImpl createLan(int lanId, String name) {
        if (this._singleLan != null) {
            if (this._singleLan.getPK().getId() != lanId) {
                _Tracer.log(Level.WARN, "DCNM-SAN Server has single LAN instance, cannot create another one for LAN Id :" + lanId);
            }
        } else {
            this._singleLan = new LanImpl(new LanPK(lanId, name));
        }
        return this._singleLan;
    }

    public void manageLan() throws Exception {
        this.openLan();
    }

    public void unmanageLan() throws Exception {
        this.closeLan(false, false, false);
    }

    public void removeLan(LanPK lanPK, boolean deregisterServer, boolean purgeDB) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return;
        }
        this.closeLan(true, deregisterServer, purgeDB);
    }

    protected LanImpl openLan() throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            lan = this.createLan();
        }
        if (lan.isLanOpened()) {
            _Tracer.log(Level.DEBUG, lan + " has already opened, nothing need to do");
            return lan;
        }
        DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_INITIAL);
        try {
            GlobalDCManager.getInstance().persistLanWithServer(lan.getPK(), null);
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, lan + "failed to register to the logic server map", ex);
        }
        return lan;
    }

    protected void closeLan(boolean cleanCache, boolean deregisterServer, boolean purgeDB) throws Exception {
        block12: {
            LanImpl lan;
            block11: {
                lan = this.getLan();
                if (lan == null) {
                    return;
                }
                lan.close(cleanCache);
                if (!cleanCache) break block11;
                this.deleteLan();
                if (deregisterServer || purgeDB) {
                    try {
                        GlobalDCManager.getInstance().deleteLanWithServer(lan.getPK(), null);
                    }
                    catch (Exception ex) {
                        _Tracer.log(Level.WARN, lan + "failed to de-register to the logic server map", ex);
                    }
                }
                if (purgeDB) {
                    long lanDbid = lan.getDBID();
                    try {
                        LanPersistentManager.getInstance().purgeLan(lan);
                        this.notifyDBObjectPurged(lanDbid);
                    }
                    catch (Exception e) {
                        _Tracer.log(Level.WARN, lan + " purge failed" + e.getMessage(), e);
                    }
                    int deletedRows = PmExtraOidImpl.deletePMExtraOidByFid(lan.getDBID());
                    if (deletedRows > 0) {
                        PMImpl pm = PMImpl.getInstance();
                        pm.restart();
                    }
                }
                if (lan.getCdpSeedBases() == null) break block12;
                for (CdpSeedBase cdp : lan.getCdpSeedBases()) {
                    if (cdp.getSeedIp() == null || lan.getDBID() <= 0L || IdentityManager.getInstance().getCurrentUsername() == null) continue;
                    SyslogEntry e = new SyslogEntry(IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN 'task_seed_" + cdp.getSeedIp().getHostAddress() + "' removed", Severity.INFO.getValue(), 1);
                    e.setGroupId(cdp.getGroup());
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(e);
                }
                break block12;
            }
            if (lan.getCdpSeedBases() != null) {
                for (CdpSeedBase cdp : lan.getCdpSeedBases()) {
                    if (cdp.getSeedIp() == null || lan.getDBID() <= 0L || IdentityManager.getInstance().getCurrentUsername() == null) continue;
                    ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(lan.getPK(), IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN 'task_seed_" + cdp.getSeedIp().getHostAddress() + "' unmanaged", Severity.INFO.getValue(), 1, cdp.getGroup()));
                }
            }
        }
    }

    public void unhostLan(LanPK lanPK) throws Exception {
        LanImpl lan = this.getLan();
        if (lan != null && lan.getPK().equals(lanPK)) {
            this.removeLan(lanPK, true, false);
        } else {
            try {
                GlobalDCManager.getInstance().updateLanManageableByLanPK(false, lanPK);
                String svr = GlobalDCManager.getInstance().getServerForLan(lanPK);
                if (svr != null) {
                    GlobalDCManager.getInstance().deleteLanWithServer(lanPK, InetAddress.getByName(svr));
                }
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lanPK + " failed to unhost LAN with LAN PK:" + lanPK, ex);
            }
        }
    }

    public void hostLan(LanPK lanPK) throws Exception {
        LanImpl lan = this.getLan();
        if (lan != null) {
            throw new Exception("Server has hosted one LAN, cannot host another one with LAN PK:" + lanPK);
        }
        boolean isManaged = GlobalDCManager.getInstance().getLanManagedByLanPK(lanPK);
        if (isManaged) {
            throw new Exception("Server cannot host a LAN already in managing status with LAN PK: " + lanPK);
        }
        String svrIp = GlobalDCManager.getInstance().getServerForLan(lanPK);
        if (svrIp != null) {
            InetAddress lanSvrIp = InetAddress.getByName(svrIp);
            GlobalDCManager.getInstance().deleteLanWithServer(lanPK, lanSvrIp);
        }
        GlobalDCManager.getInstance().persistLanWithServer(lanPK, null);
        this.openLansFromDB();
    }

    public boolean hasHostedLan() throws Exception {
        if (this.getLan() != null) {
            return true;
        }
        List<LanPK> lanPKs = GlobalDCManager.getInstance().getLanPKsByServer(null);
        return lanPKs != null && lanPKs.size() != 0;
    }

    public CdpSeedImpl discoverLan(InetAddress seedIp, SnmpUserOpt snmpUser, int maxHop, String dcnmUser) throws Exception {
        return this.discoverLan(seedIp, maxHop, snmpUser, null, 1L, dcnmUser, false);
    }

    public CdpSeedImpl discoverLan(InetAddress seedIp, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupId, String dcnmUser, boolean deepDisc) throws Exception {
        int ethSws;
        LanImpl lan = this.getLan();
        if (lan == null) {
            lan = this.createLan();
        }
        if (lan == null) {
            throw new Exception("Cannot discover LAN because there is no LAN available for " + seedIp);
        }
        SwitchImpl[] switches = SanManager.getInstance().getSwitches();
        int sanSws = switches == null ? 0 : switches.length;
        if (sanSws + (ethSws = this.getNumEthSwitchesNoFex()) >= SanManager._DefMaxOpenSwitches) {
            throw new Exception("Unable to add or manage these switches. This server is managing the recommended maximum of " + SanManager._DefMaxOpenSwitches + " switches");
        }
        this.validateCdpSeed(seedIp, snmpUser);
        CdpSeedImpl task = this.createTask(seedIp, maxHop, snmpUser, enablePwd, groupId, dcnmUser, deepDisc);
        task.setNeedDisc(true);
        if (snmpUser.isFwsm()) {
            task.setFwsm(true);
        }
        if (!lan.isLanOpened()) {
            this.manageLan();
        } else {
            DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_INITIAL);
        }
        if (seedIp != null && lan.getDBID() > 0L && IdentityManager.getInstance().getCurrentUsername() != null && IdentityManager.getInstance().getCurrentUsername().length() > 0) {
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(lan.getPK(), IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN 'task_seed_" + seedIp.getHostAddress() + "' discovered", Severity.INFO.getValue(), 1, groupId));
        }
        return task;
    }

    public CdpSeedImpl discoverLan(List<InetAddress> seedIPs, SnmpUserOpt snmpUser, String enablePwd, long groupId, String dcnmUser, boolean deepDisc) throws Exception {
        int ethSws;
        if (seedIPs == null || seedIPs.size() == 0) {
            throw new Exception("empty seeds");
        }
        LanImpl lan = this.getLan();
        if (lan == null) {
            lan = this.createLan();
            LanPersistentManager.getInstance().persistLanOnly(lan);
        }
        if (lan == null) {
            throw new Exception("Cannot discover LAN because there is no LAN available for " + seedIPs);
        }
        SwitchImpl[] switches = SanManager.getInstance().getSwitches();
        int sanSws = switches == null ? 0 : switches.length;
        if (sanSws + (ethSws = this.getNumEthSwitchesNoFex()) >= SanManager._DefMaxOpenSwitches) {
            throw new Exception("Unable to add or manage these switches. This server is managing the recommended maximum of " + SanManager._DefMaxOpenSwitches + " switches");
        }
        this.validateCdpSeed(seedIPs, snmpUser);
        if (snmpUser.isFwsm()) {
            deepDisc = true;
        }
        CdpSeedImpl task = this.createTask(seedIPs, snmpUser, enablePwd, groupId, dcnmUser, deepDisc);
        task.setNeedDisc(true);
        if (snmpUser.isFwsm()) {
            task.setFwsm(true);
        }
        if (!lan.isLanOpened()) {
            this.manageLan();
        } else {
            DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_INITIAL);
        }
        try {
            LanPersistentManager.getInstance().persistLanCdpSeed(task);
        }
        catch (Throwable se) {
            _Tracer.log(Level.WARN, "persist LanCdpSeed error: " + se.getMessage(), se);
        }
        for (InetAddress ip : seedIPs) {
            if (lan.getDBID() <= 0L || IdentityManager.getInstance().getCurrentUsername() == null || IdentityManager.getInstance().getCurrentUsername().length() <= 0) continue;
            ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(lan.getPK(), IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN switch '" + ip.getHostAddress() + "' discovered", Severity.INFO.getValue(), 1, groupId));
        }
        return task;
    }

    public void rediscoverLan() throws Exception {
        this.rediscoverLan(DiscoveryType.LAN_ONDEMAND);
    }

    public void rediscoverLanforTaskMove() throws Exception {
        this.rediscoverLan(DiscoveryType.LAN_ONDEMAND_SHALLOW_ONLY, true);
    }

    public void rediscoverLan(DiscoveryType discType) throws Exception {
        this.rediscoverLan(discType, false);
    }

    public void rediscoverLan(DiscoveryType discType, boolean taskMove) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return;
        }
        DiscoveryManager.getInstance().discoverLan(lan, discType);
        if (lan.getCdpSeedBases() != null) {
            for (CdpSeedBase cdp : lan.getCdpSeedBases()) {
                if (cdp.getSeedIp() == null || lan.getDBID() <= 0L || IdentityManager.getInstance().getCurrentUsername() == null || IdentityManager.getInstance().getCurrentUsername().length() <= 0) continue;
                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(lan.getPK(), IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN 'task_seed_" + cdp.getSeedIp().getHostAddress() + "' rediscovered", Severity.INFO.getValue(), 1, cdp.getGroup()));
            }
        }
    }

    public boolean setLanName(LanPK lanPK, String lanName) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return false;
        }
        lan.getPK().setName(lanName);
        return GlobalDCManager.getInstance().persistLanName(lanPK, lanName);
    }

    public boolean isLanOpened(LanPK lanPK) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return false;
        }
        return lan.isLanOpened();
    }

    public boolean isLanDiscovering(LanPK lanPK) {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return false;
        }
        return lan.isDiscovering();
    }

    public int getNumEthSwitches() {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return 0;
        }
        return lan.getNumEthSwitches();
    }

    public int getNumEthSwitchesNoFex() {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return 0;
        }
        return lan.getNumEthSwitches() - lan.getNumFexes();
    }

    public List<EthPortBase> getEthPortsBySwitch(LanPK lanPK, PKIf swPK) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            throw new Exception("Cannot find LAN instance by LanPK:" + lanPK);
        }
        EthSwitchImpl sw = lan.findEthSwitchByPK(swPK);
        if (sw == null) {
            return null;
        }
        ArrayList<EthPortImpl> ports = sw.getAllPorts();
        ArrayList<EthPortBase> basePorts = new ArrayList<EthPortBase>(ports.size());
        for (EthPortImpl ethPorts : ports) {
            basePorts.add(ethPorts.getBase());
        }
        return basePorts;
    }

    public LanBase getLanBase() throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            throw new Exception("Cannot find LAN instance");
        }
        return lan.getLanBase();
    }

    public int getLanStatus() throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            throw new Exception("Cannot find LAN instance");
        }
        return lan.getLanStatus();
    }

    public DiscStatusType getLanDiscoveryStatus() throws Exception {
        if (this.getLan() == null) {
            return DiscStatusType.NONEXIST;
        }
        if (this.getLan().getWorker() == null) {
            return DiscStatusType.UNMANAGED;
        }
        int status = this.getLan().getWorker().getStatus();
        switch (status) {
            case 0: {
                return DiscStatusType.IDLE;
            }
            case 1: {
                return DiscStatusType.DISCOVERING;
            }
            case 2: {
                return DiscStatusType.INTERRUPTED;
            }
            case 3: {
                return DiscStatusType.ABORTED;
            }
            case 4: {
                return DiscStatusType.TIMEOUT;
            }
            case 5: {
                return DiscStatusType.CDP_DONE;
            }
        }
        return DiscStatusType.NONEXIST;
    }

    public LanImpl getLan() {
        return this._singleLan;
    }

    public LanImpl findLan(LanPK lanPK) {
        LanImpl lan = this.getLan();
        if (lanPK == null || lan == null) {
            return lan;
        }
        if (lan.getPK().equals(lanPK)) {
            return lan;
        }
        return null;
    }

    public void importFcSwitches(SwitchImpl fcSeed, List<SwitchImpl> fcSws, SnmpUser credential) throws Exception {
    }

    public void validateCdpSeed(InetAddress seedIp, SnmpUserOpt snmpUser) throws Exception {
        try {
            SnmpUser credential = null;
            if (snmpUser != null && snmpUser.isFwsm()) {
                this.validateFwsm(seedIp, snmpUser);
                return;
            }
            if (snmpUser != null) {
                credential = SnmpUserOpt.convertToSnmpUser(snmpUser);
            }
            this.validateCdpSeed(seedIp, credential);
        }
        catch (Exception ex) {
            _Tracer.warn("DCManager failed to createTask from seed" + seedIp + "," + snmpUser, ex);
            throw ex;
        }
    }

    public void validateCdpSeed(InetAddress seedIp, SnmpUser credential) throws Exception {
        if (seedIp == null || !IpUtil.isValidMgmtAddress(seedIp)) {
            throw new Exception("Cannot create discovery task from invalid seed:" + seedIp);
        }
        if (credential == null) {
            throw new Exception("Cannot create discovery task from invalid credential");
        }
        EthSwitchImpl sw = this.findEthSwitchBySwIp(seedIp);
        if (sw != null && sw.isManageable()) {
            throw new Exception(seedIp.getHostAddress() + " has been discovered in LAN");
        }
        SnmpPeer peer = null;
        peer = ServiceUtil.createSnmpPeer(seedIp, credential, this.getSnmpSession(), SnmpSession._PreferTcp);
        CdpDiscvHelper.validateCdpSeed(peer);
    }

    public void validateCdpSeed(List<InetAddress> seedIPs, SnmpUserOpt snmpUser) throws Exception {
        SnmpUser credential = null;
        if (snmpUser != null && snmpUser.isFwsm()) {
            this.validateFwsm(seedIPs, snmpUser);
            return;
        }
        if (snmpUser != null) {
            credential = SnmpUserOpt.convertToSnmpUser(snmpUser);
        }
        boolean hasValid = false;
        Iterator<InetAddress> i$ = seedIPs.iterator();
        if (i$.hasNext()) {
            InetAddress seedIp = i$.next();
            try {
                this.validateCdpSeed(seedIp, credential);
                hasValid = true;
            }
            catch (Exception ex) {
                _Tracer.warn("DCManager failed to createTask from seed" + seedIp, ex);
                throw ex;
            }
        }
        if (!hasValid) {
            _Tracer.log(Level.WARN, "DCManager failed to createTask from seeds" + seedIPs + "," + snmpUser);
            throw new Exception("Cannot create dicovery task for invalid seed/credential");
        }
    }

    public void validateFwsm(List<InetAddress> seedIPs, SnmpUserOpt snmpUser) throws Exception {
        boolean hasValid = false;
        Iterator<InetAddress> i$ = seedIPs.iterator();
        if (i$.hasNext()) {
            InetAddress seedIp = i$.next();
            try {
                this.validateFwsm(seedIp, snmpUser);
                hasValid = true;
            }
            catch (Exception ex) {
                _Tracer.warn("DCManager failed to createTask from seed" + seedIp, ex);
                throw ex;
            }
        }
        if (!hasValid) {
            _Tracer.log(Level.WARN, "DCManager failed to createTask from seeds" + seedIPs + "," + snmpUser);
            throw new Exception("Cannot create dicovery task for invalid seed/credential");
        }
    }

    public void validateFwsm(InetAddress seedIp, SnmpUserOpt snmpUser) throws Exception {
        if (seedIp == null || !IpUtil.isValidMgmtAddress(seedIp)) {
            throw new Exception("Cannot create discovery task from invalid seed:" + seedIp);
        }
        if (snmpUser == null || snmpUser.getUsername() == null || snmpUser.getPassword() == null) {
            throw new Exception("Cannot create discovery task from invalid credential");
        }
        EthSwitchImpl sw = this.findEthSwitchBySwIp(seedIp);
        if (sw != null && sw.isManageable()) {
            throw new Exception(seedIp.getHostAddress() + " has been discovered in LAN");
        }
        CdpDiscvHelper.validateFwsm(seedIp.getHostAddress(), snmpUser.getUsername(), snmpUser.getPassword());
    }

    public synchronized void unhostTask(TaskKey taskKey) throws Exception {
        CdpSeedImpl cdpTask = this.findTaskByTaskKey(taskKey);
        if (cdpTask != null) {
            boolean swInPmCollection;
            long taskId;
            block18: {
                taskId = taskKey.getId();
                List<KeyValueDO> monitoredEthSws = PerformanceHandler.getInstance().getMonitoredEthSw(taskId);
                boolean bl = swInPmCollection = monitoredEthSws.size() > 0;
                if (swInPmCollection) {
                    _Tracer.log(Level.INFO, "DCManager unhostTask(), Task " + taskKey + " is in pm collection and can not be moved");
                    throw new Exception("Lan task is in pm collection and can not be moved, \nPlease remove its switches from PM Collections. (Webclient Admin->Performance->Collections)");
                }
                _Tracer.log(Level.INFO, "unhostTask,  remove CdpTask taskId = " + taskId + "   -> DCManager.removeTask....");
                LanImpl lan = this.getLan();
                int lanStatus = lan.getLanStatus();
                boolean hasLocker = false;
                try {
                    if (lanStatus == 4) {
                        throw new Exception("DCNM is busy persisting LAN " + lan);
                    }
                    if (lan.attemptLan(lanStatus, 4, 2000L)) {
                        hasLocker = true;
                        cdpTask.setManageable(false);
                        cdpTask.setNeedDisc(false);
                        List<EthSwitchImpl> ethsws = cdpTask.getDiscoveredEthSwitches();
                        for (EthSwitchImpl sw : ethsws) {
                            sw.getBase().setUnmanageableCause("Unhost");
                        }
                        LanPersistentManager.getInstance().updateCdpSeedEthSwitchWithLan(taskKey, lan.getDBID(), null);
                        break block18;
                    }
                    _Tracer.log(Level.WARN, "Lan " + lan + " is busy ");
                    throw new Exception("Lan " + lan + " is busy ");
                }
                catch (Exception ex) {
                    _Tracer.log(Level.WARN, taskKey + " failed to unhost Task with Task PK:" + taskKey, ex);
                    throw new Exception(" failed to unhost Task " + taskKey + ": " + ex.getMessage());
                }
                finally {
                    if (lan.getLanStatus() != 6 && lan.getLanStatus() != lanStatus) {
                        try {
                            lan.releaseLan(lanStatus);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            _Tracer.log(Level.INFO, "unhostTask,  removeTask done, restartPM = " + swInPmCollection);
            _Tracer.log(Level.INFO, "unhostTask,  DONE remove CdpTask taskId = " + taskId);
        } else {
            _Tracer.log(Level.INFO, "unhostTask,  cdpTask null,   -> GlobalDCManager.updateCdpSeedManageableBySeedPK....");
            try {
                _Tracer.log(Level.INFO, "unhostTask,  cdpTask null,   -> GlobalDCManager.updateCdpSeedWithLan.... to 0");
                LanImpl lan = this.getLan();
                LanPersistentManager.getInstance().updateCdpSeedEthSwitchWithLan(taskKey, lan.getDBID(), null);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, taskKey + " failed to unhost Task with Task PK:" + taskKey, ex);
            }
            _Tracer.log(Level.INFO, "unhostTask, cdpTask null,  DONE remove CdpTask");
        }
    }

    public void hostTask(TaskKey taskKey) throws Exception {
        this.hostTask(null, taskKey);
    }

    public synchronized void hostTask(LanPK oldLanPk, TaskKey taskKey) throws Exception {
        _Tracer.log(Level.INFO, "hostTask,  oldLanPK is " + oldLanPk + " taskKey = " + taskKey + " ....");
        try {
            LanImpl lan = this.getLan();
            if (lan == null) {
                _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + "   -> createLan()....");
                lan = this.createLan();
                LanPersistentManager.getInstance().persistLanOnly(lan);
                GlobalDCManager.getInstance().persistLanWithServer(lan.getPK(), null);
            }
            _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + "   -> findTaskByTaskKey()....");
            CdpSeedImpl cdpTask = this.findTaskByTaskKey(taskKey);
            if (cdpTask != null) {
                _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + " already exisits in server");
                return;
            }
            _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + " cdpTask != null  -> getMonitoredEthSw()....");
            _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + " -> updateCdpSeedWithLan()....");
            long oldLanDBId = -1L;
            if (oldLanPk != null) {
                oldLanDBId = GlobalDCManager.getInstance().getLanDBIDByLanPK(oldLanPk);
            }
            LanPersistentManager.getInstance().updateCdpSeedEthSwitchWithLan(taskKey, oldLanDBId, lan);
            cdpTask = lan.findCdpSeedBySeedPK(taskKey);
            int updatedRows = PmExtraOidImpl.updatePMExtraOidFidBySeedId(cdpTask.getDBID(), lan.getDBID());
            if (updatedRows > 0) {
                _Tracer.log(Level.INFO, "hostTask, restartPM ");
                PMImpl pm = PMImpl.getInstance();
                pm.restart();
            }
            _Tracer.log(Level.INFO, "hostTask, DONE hosting CdpTask taskId = " + taskKey.getId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        _Tracer.log(Level.INFO, "hostTask,  taskKey = " + taskKey + " DONE");
    }

    protected CdpSeedImpl createTask(InetAddress seedIp, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, String dcnmUser, boolean deepDisc) throws Exception {
        TaskKey taskKey = this.createTaskKey();
        CdpSeedImpl task = new CdpSeedImpl(taskKey, seedIp, maxHop, snmpUser, enablePwd, groupDBID, System.currentTimeMillis(), dcnmUser, deepDisc);
        this.getLan().addCdpSeed(task);
        LanPersistentManager.getInstance().persistLanCdpSeed(task);
        this.notifyModelObjectCreated(task);
        return task;
    }

    protected CdpSeedImpl createTask(List<InetAddress> seedIPs, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, String dcnmUser, boolean deepDisc) throws Exception {
        return this.createTask(seedIPs, 0, snmpUser, enablePwd, groupDBID, dcnmUser, deepDisc);
    }

    protected CdpSeedImpl createTask(List<InetAddress> seedIPs, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, String dcnmUser, boolean deepDisc) throws Exception {
        CdpSeedImpl task = this.getLan().findCdpSeedBySeedIps(seedIPs);
        if (task == null) {
            TaskKey taskKey = this.createTaskKey();
            task = new CdpSeedImpl(taskKey, seedIPs, maxHop, snmpUser, enablePwd, groupDBID, System.currentTimeMillis(), dcnmUser, deepDisc);
            this.getLan().addCdpSeed(task);
            if (Boolean.parseBoolean(System.getProperty("cdp.persistCdpNodeSwitch", "true"))) {
                this.persistCdpNodeSwitches(seedIPs, groupDBID, task, snmpUser.isFwsm());
            }
            this.notifyModelObjectCreated(task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCdpNodeSwitches(List<InetAddress> seedIPs, long groupDBID, CdpSeedImpl task, boolean isFwsm) {
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = null;
            rs = null;
            LanPersistentManager.getInstance().persistLanCdpSeed(task);
            ArrayList<EthDBObjectIf> sws = new ArrayList<EthDBObjectIf>();
            for (InetAddress ip : seedIPs) {
                EthSwitchImpl sw = new EthSwitchImpl(new SerialNumKey(DiscStatusType.DISCOVERING.toString()), ip);
                sw.getBase().setUnmanageableCause(DiscStatusType.DISCOVERING.toString());
                sws.add(sw);
            }
            if (task != null && sws.size() > 0) {
                LanPersistentManager.getInstance().persistLanEthswitchesOnly(task, sws);
                this.getLan().releaseLan(1);
                LanPersistentManager.getInstance().persistDBAssociations("ethswitch_seed", "switch_id", "seed_id", sws, task, con);
                LanPersistentManager.getInstance().persistDBAssociations("lanswitch_map", "id", "lan_id", sws, this.getLan(), con);
                if (!isFwsm) {
                    stat = con.prepareStatement("select switch_id from ethswitch_seed where seed_id=?");
                    stat.setLong(1, task.getDBID());
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        long swDBID = rs.getLong(1);
                        NavigationUtil.getInstance().addGroupMember(swDBID, DiscStatusType.DISCOVERING.toString(), 4, groupDBID);
                    }
                }
            }
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, "persist LanCdpSeed switches error: " + ex.getMessage(), ex);
        }
        finally {
            DbUtil.close(con);
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
    }

    public CdpSeedImpl createTask(CdpSeedBase taskBase) throws Exception {
        if (taskBase == null) {
            return null;
        }
        CdpSeedImpl task = this.findTaskByTaskKey(taskBase.getTaskKey());
        if (task != null) {
            task.getBase().sync(taskBase);
        } else {
            task = new CdpSeedImpl(taskBase);
            this.getLan().addCdpSeed(task);
            LanPersistentManager.getInstance().persistLanCdpSeed(task);
            this.notifyModelObjectCreated(task);
        }
        return task;
    }

    public boolean removeTask(CdpSeedImpl taskImpl, boolean purgeDB) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        if (taskImpl != null) {
            lan.removeCdpSeed(taskImpl, purgeDB);
            this.notifyCdpSeedRemoved(taskImpl);
            if (lan.getCdpSeeds().size() == 0) {
                this.removeLan(lan.getPK(), true, true);
                this.notifyLanRemoved(null, lan);
            }
            return true;
        }
        return false;
    }

    public boolean removeTask(CdpSeedBase task, boolean purgeDB) throws Exception {
        if (task == null) {
            return false;
        }
        return this.removeTask(task.getTaskKey(), purgeDB);
    }

    public boolean removeTask(TaskKey taskKey, boolean purgeDB) throws Exception {
        _Tracer.log(Level.INFO, "removeTask,  taskKey/purgeDB = " + taskKey + "/" + purgeDB + "   -> getLan()....");
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        _Tracer.log(Level.INFO, "removeTask,  find lan=" + lan + "    -> findCdpSeedBySeedPK...");
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(taskKey);
        if (taskImpl == null) {
            return false;
        }
        InetAddress seedIp = null;
        if (taskImpl.getBase() != null && taskImpl.getBase().getSeedIp() != null) {
            seedIp = taskImpl.getBase().getSeedIp();
        }
        _Tracer.log(Level.INFO, "removeTask,  find taskImpl=" + taskImpl + "    -> removeCdpSeed...");
        PmExtraOidImpl.deletePMExtraOidBySeedId(taskImpl.getDBID());
        lan.removeCdpSeed(taskImpl, purgeDB);
        _Tracer.log(Level.INFO, "removeTask,    -> notifyCdpSeedRemoved...");
        this.notifyCdpSeedRemoved(taskImpl);
        try {
            if (lan.getDBID() > 0L && IdentityManager.getInstance().getCurrentUsername() != null && IdentityManager.getInstance().getCurrentUsername().length() > 0 && seedIp != null) {
                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(taskImpl.getPK(), IdentityManager.getInstance().getClientAddress(), lan.getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), "LAN 'task_seed_" + seedIp.getHostAddress() + "' removed", Severity.INFO.getValue(), 1, taskImpl.getBase().getGroup()));
                _Tracer.log(Level.INFO, "removeTask,   DONE accounting loging");
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.WARN, "removeTask caught exception " + e);
        }
        if (lan.getCdpSeeds().size() == 0) {
            _Tracer.log(Level.INFO, "removeTask,   lan.getCdpSeeds().size()=" + lan.getCdpSeeds().size() + "  -> removeLan pk " + lan.getPK() + "/true/true");
            this.removeLan(lan.getPK(), true, true);
            _Tracer.log(Level.INFO, "removeTask,   -> notifyLanRemoved lan " + lan);
            this.notifyLanRemoved(null, lan);
        }
        _Tracer.log(Level.INFO, "removeTask   DONE");
        return true;
    }

    public void manageTask(CdpSeedBase task) throws Exception {
        if (task == null) {
            return;
        }
        this.manageTask(task.getTaskKey());
    }

    public void manageTask(TaskKey taskKey) throws Exception {
        this.manageTask(taskKey, DiscoveryType.LAN_ONDEMAND);
    }

    public void manageTasks(List<CdpSeedBase> cdpSeeds, DiscoveryType discType) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return;
        }
        for (CdpSeedBase cdpSeed : cdpSeeds) {
            CdpSeedImpl taskImpl;
            if (cdpSeed == null || (taskImpl = lan.findCdpSeedBySeedPK(cdpSeed.getTaskKey())) == null) continue;
            taskImpl.setManageable(true);
            taskImpl.setNeedDisc(true);
            GlobalDCManager.getInstance().updateCdpSeedManageableBySeedPK(true, cdpSeed.getTaskKey());
            List<EthSwitchImpl> ethsws = taskImpl.getDiscoveredEthSwitches();
            for (EthSwitchImpl sw : ethsws) {
                sw.setManageable(true, "Managed");
            }
            LanPersistentManager.getInstance().updateEthSwitchDiscoveryStatus(taskImpl.getDiscoveredEthSwitches());
        }
        if (!lan.isDiscovering()) {
            this.rediscoverLan(discType);
        }
    }

    public void manageTask(TaskKey taskKey, DiscoveryType discType) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return;
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(taskKey);
        if (taskImpl != null) {
            taskImpl.setManageable(true);
            taskImpl.setNeedDisc(true);
            GlobalDCManager.getInstance().updateCdpSeedManageableBySeedPK(true, taskKey);
            List<EthSwitchImpl> ethsws = taskImpl.getDiscoveredEthSwitches();
            for (EthSwitchImpl sw : ethsws) {
                sw.setManageable(true, "Managed");
            }
            if (discType != DiscoveryType.LAN_ONDEMAND_SHALLOW_ONLY) {
                LanPersistentManager.getInstance().updateEthSwitchDiscoveryStatus(taskImpl.getDiscoveredEthSwitches());
            }
            if (!lan.isDiscovering()) {
                this.rediscoverLan(discType);
            }
        }
    }

    public void unmanageTask(CdpSeedBase task) throws Exception {
        if (task == null) {
            return;
        }
        this.unmanageTask(task.getTaskKey());
    }

    public void unmanageTask(TaskKey taskKey) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return;
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(taskKey);
        if (taskImpl != null) {
            lan.unmanage(taskImpl);
            taskImpl.setManageable(false);
            taskImpl.setNeedDisc(false);
            GlobalDCManager.getInstance().updateCdpSeedManageableBySeedPK(false, taskKey);
            List<EthSwitchImpl> ethsws = taskImpl.getDiscoveredEthSwitches();
            for (EthSwitchImpl sw : ethsws) {
                sw.setManageable(false, "Unmanaged Manually");
                CliAdapter.closeAll();
            }
            GlobalDCManager.getInstance().updateEthSwitchManageableBySeedPK(false, "Unmanaged Manually", taskKey);
            this.notifyLanClosed(lan);
        }
    }

    public boolean purgeTaskFromDB(TaskKey taskKey) throws Exception {
        boolean removed = this.removeTask(taskKey, true);
        if (removed) {
            return true;
        }
        long seedDBID = GlobalDCManager.getInstance().queryCdpSeedDBIDsBySeedPK(taskKey);
        if (seedDBID == -1L) {
            throw new Exception("Cannot find task DBID by taskKey:" + taskKey);
        }
        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();
            LanPersistentManager.getInstance().doPurgeCdpSeedAndComponents(seedDBID, LanPersistentManager.Option.ObjectAndComp, conn);
            this.notifyDBObjectPurged(seedDBID);
            if (_Tracer.isTraceable()) {
                _Tracer.log(Level.TRACE, "DCManger->removeTaskFromDB done: " + taskKey);
            }
        }
        catch (SQLException ex) {
            if (conn != null) {
                conn.rollback();
            }
            _Tracer.log(Level.WARN, "DCManger->removeTaskFromDB failedd and rollback: " + taskKey, ex);
            throw ex;
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, "DCManger->removeTaskFromDB failedd and rollback: " + taskKey, ex);
            throw ex;
        }
        finally {
            DbUtil.close(conn);
        }
        return true;
    }

    public List<CdpSeedImpl> getTasks() throws Exception {
        LanImpl lan = this.getLan();
        if (lan != null && lan.getNumCdpSeeds() > 0) {
            return lan.getCdpSeeds();
        }
        return Collections.EMPTY_LIST;
    }

    public CdpSeedBase[] getTaskBases() throws Exception {
        LanImpl lan = this.getLan();
        if (lan != null && lan.getNumCdpSeeds() > 0) {
            List<CdpSeedBase> seeds = lan.getCdpSeedBases();
            return seeds.toArray(new CdpSeedBase[seeds.size()]);
        }
        return new CdpSeedBase[0];
    }

    public boolean setTask(CdpSeedImpl task, List<InetAddress> iplist) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        if (task == null) {
            throw new Exception("Cannot find associated task from server");
        }
        if (iplist == null || iplist.size() == 0) {
            throw new Exception("Eth switch list is empty");
        }
        ArrayList<EthDBObjectIf> ethsws = new ArrayList<EthDBObjectIf>();
        ArrayList<EthSwitchImpl> ethsws1 = new ArrayList<EthSwitchImpl>();
        for (InetAddress ipAddr : iplist) {
            EthDBObjectIf ethsw = task.findDiscoveredNodeByNodeIp(ipAddr);
            if (((EthSwitchImpl)ethsw).getBase().isMDS()) continue;
            ((EthSwitchImpl)ethsw).setDeepDisc(true);
            ethsws.add(ethsw);
            ethsws1.add((EthSwitchImpl)ethsw);
        }
        try {
            DiscoveryManager.getInstance().discoverCdpSeed(lan, task, ethsws1, DiscoveryType.LAN_DEEP_ONLY);
        }
        catch (Exception e) {
            for (EthDBObjectIf ethsw : ethsws) {
                ((EthSwitchImpl)ethsw).setDeepDisc(false);
            }
            throw e;
        }
        try {
            LanPersistentManager.getInstance().persistLanEthswitchesOnly(task, ethsws);
        }
        catch (Throwable se) {
            _Tracer.log(Level.WARN, "persist LanEthswitchesOnly error: " + se.getMessage(), se);
        }
        return true;
    }

    public boolean setCredentialTest(CdpSeedBase newTask) throws Exception {
        if (newTask == null) {
            throw new IllegalArgumentException("Cannot set empty task");
        }
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(newTask.getTaskKey());
        if (taskImpl == null) {
            throw new Exception("Cannot find associated task from server");
        }
        return taskImpl.setCredentialTest(newTask.getCredential());
    }

    public boolean setTask(CdpSeedBase newTask, boolean credentialChange, boolean needCredTest) throws Exception {
        if (newTask == null) {
            throw new IllegalArgumentException("Cannot set empty task");
        }
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(newTask.getTaskKey());
        if (taskImpl == null) {
            throw new Exception("Cannot find associated task from server");
        }
        String oldSeedIps = IpUtil.getIPListInString(taskImpl.getSeedIPs(), ",");
        String newSeedIps = IpUtil.getIPListInString(newTask.getSeedIPs(), ",");
        if (newSeedIps == null || !newSeedIps.equals(oldSeedIps)) {
            _Tracer.log(Level.WARN, this + " Cannot apply changes because seed address is changed. oldSeedIps= " + oldSeedIps + ", newSeedIps= " + newSeedIps);
            throw new Exception("Cannot apply changes because seed address is changed");
        }
        boolean modified = false;
        CdpSeedBase seedBase = taskImpl.getBase();
        if (seedBase.getMaxHop() != newTask.getMaxHop()) {
            modified = true;
        }
        if (!GenUtil.equals(seedBase.getIpRangeStr(), newTask.getIpRangeStr())) {
            modified = true;
        }
        if (!GenUtil.equals(seedBase.getSubnetStr(), newTask.getSubnetStr()) || !GenUtil.equals(seedBase.getMaskStr(), newTask.getMaskStr())) {
            modified = true;
        }
        if (modified) {
            lan.removeCdpSeed(taskImpl, true);
            seedBase.setMaxHop(newTask.getMaxHop());
            seedBase.setIpRangeStr(newTask.getIpRangeStr());
            seedBase.setMaskStr(newTask.getMaskStr());
            seedBase.setSubnetStr(newTask.getSubnetStr());
            lan.addCdpSeed(taskImpl);
        }
        boolean credChange = needCredTest ? taskImpl.setCredentialTest(newTask.getCredential()) : credentialChange;
        modified |= credChange;
        boolean enablePwdChange = taskImpl.setEnablePwd(newTask.getEnablePwd());
        modified |= enablePwdChange;
        if (credChange || enablePwdChange) {
            LanPersistentManager mgr = LanPersistentManager.getInstance();
            try {
                mgr.persistCdpSeedSnmpUser(taskImpl);
            }
            catch (Exception ex) {
                _Tracer.log(Level.ERROR, this + " persist cdp seed snmpuser failed:", ex);
                throw ex;
            }
        }
        if (modified) {
            taskImpl.setNeedDisc(true);
        }
        if (taskImpl.needDisc()) {
            DiscoveryManager.getInstance().discoverLan(lan, DiscoveryType.LAN_INITIAL);
        }
        return modified;
    }

    public void changeSwitchIp(PKIf swPK, InetAddress inetAddr) throws Exception {
        EthSwitchImpl sw = this.findEthSwitchBySwPK(swPK);
        if (sw != null) {
            InetAddress oldAddr = sw.getInetAddress();
            if (oldAddr == null || !oldAddr.toString().equals(inetAddr.toString())) {
                sw.resetPeer();
                sw.setManagementAddressInUse(inetAddr);
                sw.setManagementAddresses(new InetAddress[]{inetAddr}, true);
                sw.setManageable(true, null);
                try {
                    LanPersistentManager.getInstance().persistLanEthSwitch(sw);
                }
                catch (Exception e) {
                    _Tracer.warn("changeSwitchIp: failed to persist IP address for switch '" + sw.getName() + "'", e);
                    throw e;
                }
            }
        } else {
            throw new Exception("switch " + swPK.toString() + " cannot be found");
        }
    }

    public void changeTaskCredentials(TaskKey taskKey, String user, String pwd, String community, int authPrivacy, boolean isV3, String enablePwd, boolean forceSet) throws Exception {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return;
        }
        if (lan.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering LAN");
        }
        CdpSeedImpl task = lan.findCdpSeedBySeedPK(taskKey);
        if (task == null) {
            throw new Exception("Cannot find task with key:" + taskKey);
        }
        SnmpUserOpt userOpt = new SnmpUserOpt(user, pwd, community, authPrivacy, isV3);
        SnmpUser newUser = SnmpUserOpt.convertToSnmpUser(userOpt);
        boolean changed = false;
        if (!newUser.equals(task.getCredential())) {
            changed = true;
            if (forceSet) {
                task.setCredential(newUser);
            } else {
                SnmpPeer peer;
                SnmpUserOpt oldUserOpt;
                InetAddress seedIp = task.getBase().getSeedIp();
                if (seedIp == null) {
                    throw new Exception("No seed IP for the task:" + taskKey);
                }
                SnmpPeer oldPeer = null;
                SnmpUser oldUser = task.getCredential();
                if (oldUser != null && (oldUserOpt = SnmpUserOpt.convertToSnmpUserOpt(oldUser)) != null) {
                    oldPeer = SnmpPeer.findServerPeer(seedIp, this.getSnmpSession(), oldUserOpt.isV3() ? oldUserOpt.getUsername() : oldUserOpt.getCommunity());
                }
                if (task.getBase().getTaskType() == DiscTaskType.LAN_MAXHOP) {
                    try {
                        peer = null;
                        peer = ServiceUtil.createSnmpPeer(seedIp, newUser, this.getSnmpSession(), SnmpSession._PreferTcp);
                        CdpDiscvHelper.validateCdpSeed(peer);
                        if (peer != null) {
                            SnmpPeer.addServerPeer(peer);
                            if (oldPeer != null) {
                                SnmpPeer.removeServerPeer(oldPeer, true);
                            }
                        }
                    }
                    catch (Exception ex) {
                        _Tracer.warn("DCManager cannot validate new credential", ex);
                        throw new Exception("Invalid credential");
                    }
                    task.setCredential(newUser);
                } else if (task.getBase().getTaskType() == DiscTaskType.LAN_IPLIST) {
                    try {
                        peer = null;
                        peer = ServiceUtil.createSnmpPeer(seedIp, newUser, this.getSnmpSession(), SnmpSession._PreferTcp);
                        CdpDiscvHelper.validateCdpSeed(peer);
                        if (peer != null) {
                            SnmpPeer.addServerPeer(peer);
                            if (oldPeer != null) {
                                SnmpPeer.removeServerPeer(oldPeer, true);
                            }
                        }
                    }
                    catch (Exception ex) {
                        _Tracer.warn("DCManager cannot validate new credential", ex);
                        throw new Exception("Invalid credential");
                    }
                    task.setCredential(newUser);
                }
            }
        }
        if (!GenUtil.equals(enablePwd, task.getBase().getEnablePwd())) {
            changed = true;
            task.getBase().setEnablePwd(enablePwd);
        }
        if (changed) {
            // empty if block
        }
    }

    public CdpSeedImpl findTaskBySwIp(InetAddress swIp) {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return null;
        }
        CdpSeedImpl task = lan.findCdpSeedFromNodeIp(swIp);
        return task;
    }

    public CdpSeedImpl findTaskBySwPK(PKIf swPK) {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return null;
        }
        CdpSeedImpl task = lan.findCdpSeedFromNodePK(swPK);
        return task;
    }

    public CdpSeedImpl findTaskByTaskKey(TaskKey taskKey) {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return null;
        }
        CdpSeedImpl task = lan.findCdpSeedBySeedPK(taskKey);
        return task;
    }

    private TaskKey createTaskKey() {
        try {
            long taskId = Sequence.getSequence().getPK();
            TaskKey key = new TaskKey(taskId);
            return key;
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, "Cannot create TaskKey from sequence id, choose default 1 as TaskKey id");
            return new TaskKey(1L);
        }
    }

    public EthSwitchImpl createEthSwitch(LanImpl lan, PKIf swPK, String sysName, InetAddress swIp) {
        if (lan == null || swPK == null) {
            return null;
        }
        EthSwitchImpl sw = lan.findEthSwitchByPK(swPK);
        if (sw == null && sysName != null && (sw = lan.findEthSwitchBySysName(sysName)) != null) {
            if (swPK instanceof SerialNumKey && sw.getSwitchPK() instanceof SerialNumKey && ((SerialNumKey)swPK).isRealSN() && ((SerialNumKey)sw.getSwitchPK()).isRealSN()) {
                sw = null;
            } else if (swPK instanceof VdcPK && sw.getSwitchPK() instanceof VdcPK) {
                sw = null;
            }
        }
        if (sw == null && swIp != null && (sw = lan.findEthSwitchByIp(swIp)) != null) {
            if (swPK instanceof SerialNumKey && sw.getSwitchPK() instanceof SerialNumKey && ((SerialNumKey)swPK).isRealSN() && ((SerialNumKey)sw.getSwitchPK()).isRealSN()) {
                sw = null;
            } else if (swPK instanceof VdcPK && sw.getSwitchPK() instanceof VdcPK) {
                sw = null;
            }
        }
        if (sw != null) {
            sw.setPresent(true);
            if (swIp != null && !sw.getBase().containsMgmtAddr(swIp)) {
                InetAddress[] newAddrs = null;
                InetAddress[] oldAddrs = sw.getManagementAddresses();
                if (oldAddrs != null && oldAddrs.length > 0) {
                    newAddrs = new InetAddress[oldAddrs.length + 1];
                    System.arraycopy(oldAddrs, 0, newAddrs, 0, oldAddrs.length);
                } else {
                    newAddrs = new InetAddress[1];
                }
                newAddrs[newAddrs.length - 1] = swIp;
                sw.setManagementAddresses(newAddrs, false);
            }
        } else {
            sw = swPK instanceof VdcPK ? new VdcImpl((VdcPK)swPK, swIp) : new EthSwitchImpl((SerialNumKey)swPK, swIp);
            sw.setPresent(true);
            DCMgrHelper helper = new DCMgrHelper(sw);
            new Thread(helper).start();
        }
        return sw;
    }

    public boolean removeEthSwitch(PKIf swPK, boolean purge) throws Exception {
        if (swPK == null) {
            return false;
        }
        LanImpl lan = this.getLan();
        if (lan == null) {
            return false;
        }
        if (lan.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering LAN");
        }
        return this.removeEthSwitch(lan, swPK, purge);
    }

    public boolean removeEthSwitch(LanImpl lan, PKIf swPK, boolean purge) {
        if (lan == null || swPK == null) {
            return false;
        }
        EthSwitchImpl sw = lan.findEthSwitchByPK(swPK);
        if (sw != null) {
            return lan.removeEthSwitchAndComponents(sw, purge);
        }
        return false;
    }

    public EthSwitchImpl findEthSwitchBySwIp(InetAddress swIp) {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return null;
        }
        EthSwitchImpl sw = lan.findEthSwitchByIp(swIp);
        return sw;
    }

    public EthSwitchImpl findEthSwitchBySwPK(PKIf swPK) {
        LanImpl lan = this.getLan();
        if (lan == null) {
            return null;
        }
        EthSwitchImpl sw = lan.findEthSwitchByPK(swPK);
        return sw;
    }

    public EthIslImpl createEthIsl(LanImpl lan, EthSwitchImpl sw1, EthSwitchImpl sw2, EthPortImpl port1, EthPortImpl port2) {
        if (lan == null || sw1 == null || sw2 == null || port1 == null || port2 == null) {
            return null;
        }
        EthIslImpl ethIsl = lan.findEthIsl(sw1.getChassisKey(), sw2.getChassisKey(), port1.getIfIndex(), port2.getIfIndex());
        if (ethIsl != null) {
            return ethIsl;
        }
        ethIsl = new EthIslImpl(sw1, sw2, port1.getIfIndex(), port2.getIfIndex());
        ethIsl.setSwitchPortImpl(port1, port2);
        ethIsl.setPresent(true);
        this.notifyModelObjectCreated(ethIsl);
        return ethIsl;
    }

    public FexIslImpl createFexIsl(LanImpl lan, EthSwitchImpl sw1, FexImpl fex, EthPortImpl port1, EthPortImpl port2) {
        if (lan == null || sw1 == null || fex == null || port1 == null || port2 == null) {
            return null;
        }
        FexIslImpl fexIsl = (FexIslImpl)lan.findEthIsl(sw1.getChassisKey(), fex.getChassisKey(), port1.getIfIndex(), port2.getIfIndex());
        if (fexIsl != null) {
            return fexIsl;
        }
        fexIsl = new FexIslImpl(sw1, fex, port1.getIfIndex(), port2.getIfIndex());
        fexIsl.setSwitchPortImpl(port1, port2);
        fexIsl.setPresent(true);
        this.notifyModelObjectCreated(fexIsl);
        return fexIsl;
    }

    public boolean removeEthIsl(LanPK lanPK, EthIslPK islPK, boolean purge) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return false;
        }
        if (lan.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering LAN");
        }
        return this.removeEthIsl(lan, islPK, purge);
    }

    public boolean removeEthIsl(LanImpl lan, EthIslPK islPK, boolean purge) throws Exception {
        if (lan == null || islPK == null) {
            return false;
        }
        EthIslImpl isl = lan.findEthIsl(islPK);
        if (isl != null) {
            return lan.removeEthIsl(isl, purge);
        }
        return false;
    }

    public EthPortImpl findpcPortByChannelNum(LanImpl lan, EthSwitchImpl sw, int channelNum) {
        if (lan == null || sw == null || channelNum < 0) {
            return null;
        }
        int portChannelIfindex = sw.getBase().nameToIfIndex("eth-channel" + channelNum);
        return sw.findEthPort(portChannelIfindex);
    }

    public ArrayList<EthPortImpl> findChildrenByChannelNum(LanImpl lan, EthSwitchImpl sw, int channelNum) {
        if (lan == null || sw == null || channelNum < 0) {
            return null;
        }
        int portChannelIfindex = sw.getBase().nameToIfIndex("eth-channel" + channelNum);
        EthPortImpl pcPort = sw.findEthPort(portChannelIfindex);
        ArrayList<Integer> members = pcPort.getBase().getChildren();
        ArrayList<EthPortImpl> ports = new ArrayList<EthPortImpl>(members.size());
        for (Integer member : members) {
            EthPortImpl ethPort = sw.findEthPort(member);
            if (ethPort == null) continue;
            ports.add(ethPort);
        }
        return ports;
    }

    public Set<EthIslImpl> findEthIslsByChannelNum(LanImpl lan, EthSwitchImpl sw, int channelNum) {
        if (lan == null || sw == null || channelNum < 0) {
            return null;
        }
        int portChannelIfindex = sw.getBase().nameToIfIndex("eth-channel" + channelNum);
        Set<EthIslImpl> ethIsls = lan.findEthIslsBySwPort(sw.getSwitchPK(), portChannelIfindex);
        if (ethIsls == Collections.EMPTY_SET) {
            EthPortImpl pcPort = sw.findEthPort(portChannelIfindex);
            if (pcPort == null) {
                return ethIsls;
            }
            ArrayList<Integer> members = pcPort.getBase().getChildren();
            ethIsls = new HashSet<EthIslImpl>();
            Set<EthIslImpl> ethIslsfromChildren = null;
            for (Integer member : members) {
                ethIslsfromChildren = lan.findEthIslsBySwPort(sw.getSwitchPK(), member);
                if (ethIslsfromChildren == null || ethIslsfromChildren == Collections.EMPTY_SET) continue;
                ethIsls.addAll(ethIslsfromChildren);
            }
        }
        return ethIsls;
    }

    public EthPortImpl createEthPort(EthSwitchImpl sw, int ifindex) {
        EthPortImpl ethPort = sw.findEthPort(ifindex);
        if (ethPort != null) {
            ethPort.setPresent(true);
            return ethPort;
        }
        ethPort = new EthPortImpl(sw, ifindex);
        this.notifyModelObjectCreated(ethPort);
        return ethPort;
    }

    public VlanImpl createVlan(LanImpl lan, short vlanId) {
        if (lan == null) {
            return null;
        }
        VlanImpl vlan = lan.findVlanById(vlanId);
        if (vlan != null) {
            vlan.setPresent(true);
            return vlan;
        }
        vlan = new VlanImpl(lan, vlanId);
        lan.addVlan(vlan);
        this.notifyModelObjectCreated(vlan);
        return vlan;
    }

    public FexImpl createFex(LanImpl lan, SerialNumKey fexPK, int fexId) {
        if (lan == null || fexPK == null) {
            _Tracer.warn(lan + " cannot create fex because fexPK:" + fexPK);
            return null;
        }
        FexImpl fex = lan.findFexByPK(fexPK);
        if (fex != null) {
            fex.setPresent(true);
        } else {
            fex = new FexImpl(fexPK, fexId);
            fex.setPresent(true);
            this.notifyModelObjectCreated(fex);
        }
        return fex;
    }

    public boolean removeFex(LanPK lanPK, SerialNumKey fexPK, boolean purge) throws Exception {
        if (fexPK == null) {
            return false;
        }
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return false;
        }
        if (lan.isDiscovering()) {
            throw new Exception("DCNM is busy polling/discovering LAN");
        }
        return this.removeEthSwitch(lan, fexPK, purge);
    }

    public boolean removeFex(LanImpl lan, SerialNumKey fexPK, boolean purge) {
        if (lan == null || fexPK == null) {
            return false;
        }
        FexImpl fex = lan.findFexByPK(fexPK);
        if (fex != null) {
            return lan.removeFexAndComponents(fex, purge);
        }
        return false;
    }

    public List<PKIf> purgeLanDowns(LanPK lanPK) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return Collections.EMPTY_LIST;
        }
        return lan.purgeAllDowns();
    }

    public List<PKIf> purgeDownEthSwitches(LanPK lanPK) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return Collections.EMPTY_LIST;
        }
        return lan.purgeDownEthSwitches();
    }

    public List<EthIslPK> purgeDownEthIsls(LanPK lanPK) throws Exception {
        LanImpl lan = this.findLan(lanPK);
        if (lan == null) {
            return Collections.EMPTY_LIST;
        }
        return lan.purgeDownEthIsls();
    }

    public void addListener(ModelEventListenerIf listener) {
        _listeners.add(listener);
    }

    public void removeListener(ModelEventListenerIf listener) {
        _listeners.remove(listener);
    }

    public void notifyCdpSeedAdded(CdpSeedImpl cdpSeed) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.cdpSeedAdded(cdpSeed);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, cdpSeed + " notifyCdpSeedAdded failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyCdpSeedRemoved(CdpSeedImpl cdpSeed) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.cdpSeedRemoved(cdpSeed);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, cdpSeed + " notifyCdpSeedRemoved failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyLanOpened(LanImpl lan) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.lanOpened(lan);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyLanOpened failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyLanClosed(LanImpl lan) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.lanClosed(lan);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyLanClosed failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyLanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.lanRemoved(cdpSeed, lan);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyLanRemoved failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyLanDiscovered(LanImpl lan) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.lanDiscovered(lan);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyLanDiscovered failed:" + ex.getMessage(), ex);
            }
        }
    }

    public void notifyLanRediscovered(LanImpl lan) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.lanRediscovered(lan);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyLanRediscovered failed:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyMembersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.membersAdded(lan, mos);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyMembersAdded:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyMembersRemoved(LanImpl lan, PKIf[] pks) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.membersRemoved(lan, pks);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyMembersRemoved:", ex);
            }
        }
    }

    void notifyMembersChanged(LanImpl lan, ChangedModelObject[] mos) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.membersChanged(lan, mos);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyMembersChanged:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyMembersMoved(LanImpl lan, MovedModelObject[] mos) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.membersMoved(lan, mos);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyMembersMoved:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyMembersPurged(LanImpl lan, PKIf[] pks) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.memberPurged(lan, pks);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, lan + " notifyMembersPurged:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyModelObjectCreated(AbstractModelObjectImpl mo) {
        if (_listeners == null) {
            return;
        }
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.modelObjectCreated(mo);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, "notifyModelObjectCreated:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyModelObjectRemoved(AbstractModelObjectImpl mo) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.modelObjectRemoved(mo);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, "notifyModelObjectRemoved:" + ex.getMessage(), ex);
            }
        }
    }

    void notifyDBObjectPurged(long dbid) {
        for (ModelEventListenerIf listener : _listeners) {
            try {
                listener.dbObjectPurged(dbid);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, "notifyDBObjectPurged:" + ex.getMessage(), ex);
            }
        }
    }

    public void openLansFromDB() {
        block7: {
            LanPersistentManager mgr = LanPersistentManager.getInstance();
            this._dbLoadStatus = DbLoadStatus.LOADING;
            try {
                if (mgr.loadPersistentLanFromDB() != null) {
                    LanImpl lan = this.getLan();
                    if (lan != null) {
                        try {
                            if (lan.isPersistent()) {
                                this.openLan();
                            }
                        }
                        catch (Exception ex) {
                            _Tracer.log(Level.WARN, lan.getPK() + " open lan failed", ex);
                        }
                    }
                    this._dbLoadStatus = DbLoadStatus.LOADED;
                    break block7;
                }
                this._dbLoadStatus = DbLoadStatus.LOADFAILED;
            }
            catch (SQLException ex) {
                _Tracer.log(Level.ERROR, this + " open lan from db failed:", ex);
                this._dbLoadStatus = DbLoadStatus.LOADFAILED;
            }
        }
    }

    public DbLoadStatus getDbLoadStatus() {
        return this._dbLoadStatus;
    }

    public void openCdpSeedFromDB(LanImpl lan, TaskKey taskKey) {
        LanPersistentManager mgr = LanPersistentManager.getInstance();
        try {
            mgr.loadCdpSeedMiscFromDB(lan, taskKey);
        }
        catch (Exception ex) {
            _Tracer.log(Level.ERROR, this + " open Cdpseed from db failed:", ex);
        }
    }

    public void removeLanTask(String dcnmUser, long taskId) throws Exception {
        _Tracer.info("Inside DCManager -> removeLanTask()");
        _Tracer.info("removeLanTask() -> TaskId ==> " + taskId);
        if (this.isSnmpV3(taskId) && this.isDeepDiscovery(taskId)) {
            DiscTaskKey discTaskKey = new DiscTaskKey(taskId, "LAN Deep Discovery", com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskType.LAN_DEEP);
            LanWSDelegator.getInstance().removeDeepLAN(dcnmUser, discTaskKey);
        }
    }

    public void removeDeepLANDevices(String dcnmUser, String[] devices) throws Exception {
        _Tracer.info("Inside DCManager -> removeDeepLANDevices() -> device: " + devices[0]);
        LanWSDelegator.getInstance().removeDeepLANDevices(dcnmUser, devices);
    }

    public void changeLANCredentials(String dcnmUser, String seedKey, SnmpCredentialDO userCredential, String enablePwd) throws Exception {
        _Tracer.info("Inside DCManager -> changeLANCredentials()");
        long taskId = Long.parseLong(seedKey);
        _Tracer.info("changeLANCredentials() -> TaskId ==> " + taskId);
        _Tracer.info("changeLANCredentials() -> Username ==> " + userCredential.getUsername());
        if (this.isSnmpV3(taskId) && this.isDeepDiscovery(taskId)) {
            DiscTaskKey discTaskKey = new DiscTaskKey(taskId, "LAN Deep Discovery", com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskType.LAN_DEEP);
            LanWSDelegator.getInstance().changeDeepLANCredentials(dcnmUser, discTaskKey, userCredential, enablePwd);
        }
    }

    public void manageLanDeepDiscoveryTask(String dcnmUser, TaskKey taskKey) throws Exception {
        _Tracer.info("Inside DCManager -> manageLanDeepDiscoveryTask()");
        _Tracer.info("manageLanDeepDiscoveryTask()-> taskKey ==> " + taskKey);
        if (this.isSnmpV3(taskKey.getId()) && this.isDeepDiscovery(taskKey.getId())) {
            try {
                DiscTaskKey discTaskKey = new DiscTaskKey(taskKey.getId(), "Manage LAN Deep Discovery", com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskType.LAN_DEEP);
                LanWSDelegator.getInstance().notifyLANMemberChanged(dcnmUser, discTaskKey, null, "aneStatus", null, "managed");
            }
            catch (Exception e) {
                if (e instanceof DiscoveryException && ((DiscoveryException)((Object)e)).getCode() == 406) {
                    List<EthSwitchImpl> ethsws;
                    CdpSeedImpl taskImpl = DCManager.getInstance().findTaskByTaskKey(taskKey);
                    List<EthSwitchImpl> list = ethsws = taskImpl == null ? null : taskImpl.getDeepDiscSwitches();
                    if (ethsws != null) {
                        for (EthSwitchImpl ethsw : ethsws) {
                            ethsw.setDeepDisc(false);
                        }
                    }
                }
                throw e;
            }
        }
    }

    public void unManageLanDeepDiscoveryTask(String dcnmUser, TaskKey taskKey) throws Exception {
        _Tracer.info("Inside DCManager -> unManageLanDeepDiscoveryTask()");
        _Tracer.info("unManageLanDeepDiscoveryTask()-> taskKey ==> " + taskKey);
        if (this.isSnmpV3(taskKey.getId()) && this.isDeepDiscovery(taskKey.getId())) {
            DiscTaskKey discTaskKey = new DiscTaskKey(taskKey.getId(), "Unmanage LAN Deep Discovery", com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskType.LAN_DEEP);
            LanWSDelegator.getInstance().notifyLANMemberChanged(dcnmUser, discTaskKey, null, "aneStatus", null, "unmanaged");
        }
    }

    public void deepRediscoverForSelectedLanMembers(String dcnmUser, TaskKey taskKey, LanObject[] ethSwitches) throws Exception {
        _Tracer.info("Inside DCManager -> deepRediscoverForSelectedLanMembers()");
        _Tracer.info("deepRediscoverForSelectedLanMembers() -> taskKey ==> " + taskKey.getId());
        _Tracer.info("deepRediscoverForSelectedLanMembers() -> Switch ==> " + ethSwitches[0].getMgmtAddr());
        if (this.isSnmpV3(taskKey.getId())) {
            DiscTaskKey discTaskKey = new DiscTaskKey(taskKey.getId(), "Rediscover LAN Deep Discovery", com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskType.LAN_DEEP);
            LanWSDelegator.getInstance().deepRediscoverForSelectedLanMembers(dcnmUser, discTaskKey, ethSwitches);
        }
    }

    private boolean isSnmpV3(long taskId) {
        _Tracer.info("Inside DCManager -> isSnmpV3() -> taskId " + taskId);
        boolean snmpV3 = true;
        LanImpl lan = this.getLan();
        if (lan != null) {
            TaskKey taskKey = new TaskKey(taskId);
            CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(taskKey);
            if (taskImpl != null) {
                if (taskImpl.getCredential().getSecurityModel() != 3) {
                    _Tracer.info("isSnmpV3()-> SNMPv3: false");
                    snmpV3 = false;
                }
            } else {
                _Tracer.warn("Unable to get taskImpl.  Unable to find whether security model is SNMPv3 or SNMPv2!!!");
            }
        } else {
            _Tracer.warn("Unable to get LanImpl.  Unable to find whether security model is SNMPv3 or SNMPv2!!!");
        }
        return snmpV3;
    }

    private boolean isDeepDiscovery(long taskId) {
        _Tracer.info("Inside DCManager -> isDeepDiscovery() -> taskId " + taskId);
        LanImpl lan = this.getLan();
        if (lan != null) {
            TaskKey taskKey = new TaskKey(taskId);
            CdpSeedImpl taskImpl = lan.findCdpSeedBySeedPK(taskKey);
            if (taskImpl != null) {
                List<EthSwitchImpl> switches = taskImpl.getDiscoveredEthSwitches();
                if (switches != null && switches.size() > 0) {
                    for (EthSwitchImpl nextSw : switches) {
                        _Tracer.log(Level.INFO, "Ip Address ==> " + nextSw.getIpAddress());
                        _Tracer.log(Level.INFO, "IsDeepDisc() ==> " + nextSw.isDeepDisc());
                        if (!nextSw.isDeepDisc()) continue;
                        _Tracer.log(Level.INFO, "IsDeepDisc() ==> returning true!!!");
                        return true;
                    }
                    _Tracer.log(Level.INFO, "IsDeepDisc() ==> returning false!!!");
                    return false;
                }
                _Tracer.warn("isDeepDiscovery() -> taskImpl.getDiscoveredEthSwitches() returns empty switch list. Unable to find isDeepDiscovery true or false!!!");
            } else {
                _Tracer.warn("Unable to get taskImpl.  Unable to find isDeepDiscovery true or false!!!");
            }
        } else {
            _Tracer.warn("Unable to get LanImpl.  Unable to find isDeepDiscovery true or false!!!");
        }
        _Tracer.log(Level.WARN, "IsDeepDisc() ==> Unable to find isDeepDiscovery true or false, returning true!!!");
        return true;
    }

    public static enum DbLoadStatus {
        NOTLOADED,
        LOADING,
        LOADED,
        LOADFAILED;

    }
}

