/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.vi.model.HostSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class EnclosureImpl
extends AbstractModelObjectImpl {
    static final String QueryObsoleteSQL = "select name, id from enclosure where id not in ( select enclosure_id from end_port) ";
    static final String QuerySQL = "select id, is_virtual, ip_address, name, dm_path, enc_type, last_scan_time from enclosure";
    static final String QuerySQLByName = "select id, is_virtual, ip_address, name, dm_path, enc_type, last_scan_time from enclosure where name=?";
    static final String QuerySQLByID = "select id, is_virtual, ip_address, name, dm_path, enc_type, last_scan_time from enclosure where id=?";
    static final String QuerySQLByFabricID = "select distinct enclosure.id, enclosure.is_virtual, enclosure.ip_address, enclosure.name, enclosure.dm_path, enclosure.enc_type, enclosure.last_scan_time, enclosure.os_info, enclosure.vendor, enclosure.model, enclosure.version, enclosure.is_vm_host, enclosure.service_profile, enclosure.server_blade  from enclosure, end_port where end_port.enclosure_id=enclosure.id and end_port.fabric_id=?";
    static final String InsertSQL = "insert into enclosure(id,name,is_virtual, ip_address, dm_path, enc_type, last_scan_time, last_update_time, os_info, vendor, model, version, is_vm_host, vhost_id, service_profile, server_blade) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?)";
    static final String UpdateSQL = "update enclosure set name =?, is_virtual=?, ip_address=?, dm_path=?, enc_type=?, last_scan_time=?, last_update_time=?, os_info=?, vendor=?, model=?, version=?, is_vm_host=?,vhost_id=?, service_profile=?, server_blade=? where id=?";
    static final String TableName = "enclosure";
    private final EnclosureBase _base;
    private transient List<EndPortImpl> _endports = Collections.synchronizedList(new ArrayList(3));
    private VHostImpl _vhost;

    EnclosureImpl(String name, InetAddress ipAddress, boolean isVirtual) {
        this._base = new EnclosureBase(name, ipAddress, isVirtual);
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public NameKey getEnclosurePK() {
        return this._base.getEnclosurePK();
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FabricPK> getConnectedFabrics() {
        List<FabricPK> fpkeys;
        if (this.hasEndPorts()) {
            fpkeys = new ArrayList<FabricPK>(5);
            List<EndPortImpl> list = this._endports;
            synchronized (list) {
                for (EndPortImpl ep : this._endports) {
                    FabricPK fpk = ep.getFabricPK();
                    if (fpk == null || fpkeys.contains(fpk)) continue;
                    fpkeys.add(fpk);
                }
            }
        } else {
            fpkeys = Collections.emptyList();
        }
        return fpkeys;
    }

    public String getEnclosureName() {
        return this._base.getEnclosureName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnclosureName(String newName) {
        String oldName = this._base.getEnclosureName();
        if (this._base.setEnclosureName(newName)) {
            if (this.hasEndPorts()) {
                List<EndPortImpl> list = this._endports;
                synchronized (list) {
                    for (EndPortImpl ep : this._endports) {
                        ep.setEnclosure(this);
                    }
                }
            }
            this.propertyChanged((short)1794, (Serializable)((Object)oldName), (Serializable)((Object)newName));
        }
    }

    public String getIpAddress() {
        return this._base.getIpAddress();
    }

    public void setIpAddress(String inetAddr) {
        String oldAddr = this._base.getIpAddress();
        if (this._base.setIpAddress(inetAddr)) {
            this.propertyChanged((short)1796, (Serializable)((Object)oldAddr), (Serializable)((Object)inetAddr));
        }
    }

    public String getDMPath() {
        return this._base.getDMPath();
    }

    public void setDMPath(String dmPath) {
        String oldPath = this.getDMPath();
        if (this._base.setDMPath(dmPath)) {
            this.propertyChanged((short)1800, (Serializable)((Object)oldPath), (Serializable)((Object)dmPath));
        }
    }

    public String getClusterName() {
        return this._base.getClusterName();
    }

    public void setCluster(String clusterName) {
        this._base.setClusterName(clusterName);
    }

    public int getType() {
        return this._base.getType();
    }

    public void setType(int type) {
        Integer oldType = new Integer(this._base.getType());
        if (this._base.setType(type)) {
            this.propertyChanged((short)1795, oldType, new Integer(type));
        }
    }

    public void setVendor(String vendor) {
        if (!GenUtil.equals(this._base.getVendor(), vendor)) {
            String old = this._base.getVendor();
            this._base.setVendor(vendor);
            this.propertyChanged((short)1797, (Serializable)((Object)old), (Serializable)((Object)vendor));
        }
    }

    public void setModel(String model) {
        if (!GenUtil.equals(this._base.getModel(), model)) {
            String old = this._base.getModel();
            this._base.setModel(model);
            this.propertyChanged((short)1798, (Serializable)((Object)old), (Serializable)((Object)model));
        }
    }

    public void setVersion(String version) {
        if (!GenUtil.equals(this._base.getVersion(), version)) {
            String old = this._base.getVersion();
            this._base.setVersion(version);
            this.propertyChanged((short)1799, (Serializable)((Object)old), (Serializable)((Object)version));
        }
    }

    public boolean isStorage() {
        return this._base.isStorage();
    }

    public boolean isHost() {
        return this._base.isHost();
    }

    public boolean isVirtual() {
        return this._base.isVirtual();
    }

    public void setOSInfo(String osInfo) {
        if (!GenUtil.equals(osInfo, this._base.getOSInfo())) {
            String oldInfo = this._base.getOSInfo();
            this._base.setOSInfo(osInfo);
            this.propertyChanged((short)1801, (Serializable)((Object)oldInfo), (Serializable)((Object)osInfo));
        }
    }

    public int getNumOfEndPorts() {
        return this._base.getNumOfEndPorts();
    }

    public List getEndPortPKs() {
        return this._base.getEndPortPKs();
    }

    public boolean hasEndPort(EndPortImpl ep) {
        return this._base.hasEndPort(ep.getEndPortPK());
    }

    public void addEndPort(WwnKey epPK) {
        if (!this._base.hasEndPort(epPK)) {
            this._base.addEndPort(epPK);
            this.propertyChanged((short)1802, null, epPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndPort(EndPortImpl ep) {
        this.addEndPort(ep.getEndPortPK());
        List<EndPortImpl> list = this._endports;
        synchronized (list) {
            this._endports.remove(ep);
            this._endports.add(ep);
        }
        this.calcAndSetType(ep);
    }

    public void calcAndSetType(EndPortImpl endport) {
        int oldType = this._base.getType();
        if (this._base.getType() == 31) {
            if (endport.isInitiatorAndTarget()) {
                this.setType(0);
            } else if (endport.isIntiator()) {
                this.setType(47);
            } else if (endport.isTarget()) {
                this.setType(0);
            } else if (endport.isStorageOnlyVendor()) {
                this.setType(0);
            } else if (endport.isHostOnlyVendor()) {
                this.setType(47);
            } else {
                this.setType(47);
                FabricImpl._Logger.info((Object)(this + " set as HBA for an ambiguous endport device:" + endport.toPrint() + ", vendor:" + endport.getVendor()));
            }
            if (oldType != this._base.getType() && FabricImpl._Logger.isDebugEnabled()) {
                FabricImpl._Logger.debug((Object)(this + " set type as :" + this._base.getTypeName() + " , endport:" + endport.toPrint() + ", vendor:" + endport.getVendor()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndPort(WwnKey epPK) {
        if (this._base.removeEndPort(epPK)) {
            this.propertyChanged((short)1802, epPK, null);
            if (this.hasEndPorts()) {
                List<EndPortImpl> list = this._endports;
                synchronized (list) {
                    Iterator<EndPortImpl> it = this._endports.iterator();
                    while (it.hasNext()) {
                        EndPortImpl ep = it.next();
                        if (!ep.getPK().equals(epPK)) continue;
                        it.remove();
                        break;
                    }
                }
            }
        }
    }

    public List<EndPortImpl> getEndPorts() {
        return Collections.unmodifiableList(this._endports);
    }

    public boolean hasEndPorts() {
        return this._endports != null && this._endports.size() != 0;
    }

    void dereferenceEndPort(EndPortImpl ep) {
        this._base.removeEndPort(ep.getEndPortPK());
        this._endports.remove(ep);
    }

    public void addHba(Hba hba) {
        Hba[] oldHbas = this._base.getHbas();
        if (this._base.addHba(hba) || hba.isChanged()) {
            this.propertyChanged((short)1804, (Serializable)oldHbas, (Serializable)this._base.getHbas());
        }
        if (this.getType() == 31) {
            this.setType(47);
        }
    }

    public Hba[] getHbas() {
        return this._base.getHbas();
    }

    public void setHbas(Hba[] hbas) {
        this._base.setHbas(hbas);
    }

    public ScsiTarget getScsiTarget() {
        return this._base.getScsiTarget();
    }

    public void setScsiTarget(ScsiTarget target) {
        ScsiTarget oldTarget = this._base.getScsiTarget();
        if (!GenUtil.equals(target, oldTarget)) {
            this._base.setScsiTarget(target);
            this.propertyChanged((short)1803, oldTarget, this._base.getScsiTarget());
            if (this._base.getType() == 31) {
                this.setType(0);
            }
        }
    }

    public String getName() {
        return this._base.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDisappeared(long lastScanTime) {
        if (this.hasEndPorts()) {
            List<EndPortImpl> list = this._endports;
            synchronized (list) {
                Iterator<EndPortImpl> it = this._endports.iterator();
                while (it.hasNext()) {
                    if (it.next().hasDisappeared(lastScanTime)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReappeared(long lastScanTime) {
        if (this.hasEndPorts()) {
            List<EndPortImpl> list = this._endports;
            synchronized (list) {
                Iterator<EndPortImpl> it = this._endports.iterator();
                while (it.hasNext()) {
                    if (!it.next().hasReappeared(lastScanTime)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectedToFabric(FabricPK fabricPK) {
        if (this.hasEndPorts()) {
            List<EndPortImpl> list = this._endports;
            synchronized (list) {
                Iterator<EndPortImpl> it = this._endports.iterator();
                while (it.hasNext()) {
                    FabricPK fpk = it.next().getFabricPK();
                    if (fpk == null || !fpk.equals(fabricPK)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1793, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void propertyChanged(short propId, Serializable oldValue, Serializable newValue) {
        ArrayList<FabricImpl> fabrics = new ArrayList<FabricImpl>();
        FabricPK[] fPKs = SanManager.getInstance().getFabricPKs();
        if (fPKs == null) {
            return;
        }
        List<EndPortImpl> list = this._endports;
        synchronized (list) {
            for (WwnKey epPK : this._base.getEndPortPKs()) {
                for (int i = 0; i < fPKs.length; ++i) {
                    FabricImpl fabric;
                    EndPortImpl epImpl = SanManager.getInstance().findEndPort(epPK, fPKs[i]);
                    if (epImpl == null || (fabric = epImpl.getFabric()) == null || fabrics.contains(fabric)) continue;
                    fabrics.add(fabric);
                    fabric.modelObjectChanged(this._base.getPK(), propId, oldValue, newValue);
                }
            }
        }
    }

    public String dump(int level) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(FabricImpl.LIL[level]).append(this._base.getEnclosureName()).append(FabricImpl.LIL[level]).append("type: ").append(this._base.getTypeName()).append(FabricImpl.LIL[level]).append("IP: ").append(this._base.getIpAddress() == null ? "none" : this._base.getIpAddress()).append(FabricImpl.LIL[level]).append("path: ").append(this._base.getDMPath() == null ? "none" : this._base.getDMPath()).append(FabricImpl.LIL[level]).append("OS: ").append(this._base.getOSInfo() == null ? "none" : this._base.getOSInfo()).append(FabricImpl.LIL[level]).append("NxPort: ");
        Iterator<WwnKey> it = this._base.getEndPortPKs().iterator();
        while (it.hasNext()) {
            sb.append(FabricImpl.LIL[level + 1]).append(it.next());
        }
        if (this._base.isHost()) {
            sb.append(FabricImpl.LIL[level]).append("HBA: ");
            Hba[] hs = this._base.getHbas();
            if (hs == null) {
                sb.append("none");
            } else {
                for (Hba hba : hs) {
                    sb.append("\n").append(StringUtil.indentLines(hba.toString()));
                }
            }
        }
        if (this._base.isStorage()) {
            sb.append(FabricImpl.LIL[level]).append("SCSI target: ");
            ScsiTarget tinfo = this._base.getScsiTarget();
            if (tinfo == null) {
                sb.append("none");
            } else {
                sb.append(FabricImpl.LIL[level + 1]).append(tinfo);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLByName);
            ResultSet rs = null;
            try {
                stat.setString(1, this.getEnclosureName());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EnclosureImpl> findObsoleteEnclosures() {
        Object impl;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<EnclosureImpl> al = null;
        al = new ArrayList<EnclosureImpl>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QueryObsoleteSQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                impl = new EnclosureImpl(rs.getString(1), null, false);
                ((AbstractDBObjectImpl)impl).setDBID(rs.getLong(2));
                al.add((EnclosureImpl)impl);
            }
            impl = al;
        }
        catch (SQLException ex) {
            ArrayList<EnclosureImpl> arrayList;
            try {
                FabricImpl._Logger.error((Object)"findObsoleteEnclosures", (Throwable)ex);
                arrayList = al;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(FabricImpl fabric) throws SQLException {
        ArrayList arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByFabricID);
            stat.setLong(1, fabric.getDBID());
            rs = stat.executeQuery();
            ArrayList al = EnclosureImpl.loadDBRecord(rs);
            for (int i = al.size() - 1; i >= 0; --i) {
                fabric.addEnclosure((EnclosureImpl)al.get(i));
            }
            arrayList = al;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<EnclosureImpl> al = new ArrayList<EnclosureImpl>();
        while (rs.next()) {
            if (rs.getLong(1) == 0L) continue;
            InetAddress ipAddr = null;
            byte[] ipAddrBytes = rs.getBytes(3);
            try {
                if (ipAddrBytes != null) {
                    ipAddr = InetAddress.getByAddress(ipAddrBytes);
                }
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            EnclosureImpl encImpl = SanManager.getInstance().createEnclosure(rs.getString(4), ipAddr, rs.getBoolean(2));
            encImpl.setDBID(rs.getLong(1));
            encImpl._base.setDMPath(rs.getString(5));
            encImpl._base.setType(rs.getInt(6));
            encImpl._base.setLastScanTime(rs.getLong(7));
            encImpl._base.setOSInfo(rs.getString(8));
            encImpl._base.setVendor(rs.getString(9));
            encImpl._base.setModel(rs.getString(10));
            encImpl._base.setVersion(rs.getString(11));
            encImpl._base.setVmHost(rs.getBoolean(12));
            encImpl._base.setServiceProfile(rs.getString(13));
            encImpl._base.setServerBlade(rs.getString(14));
            al.add(encImpl);
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByName;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setString(2, this.getEnclosureName());
        stat.setBoolean(3, this._base.isVirtual());
        stat.setString(4, this._base.getIpAddress());
        stat.setString(5, this.getDMPath());
        stat.setInt(6, this._base.getType());
        stat.setLong(7, this._base.getLastScanTime());
        stat.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
        stat.setString(9, this._base.getOSInfo());
        stat.setString(10, this._base.getVendor());
        stat.setString(11, this._base.getModel());
        stat.setString(12, this._base.getVersion());
        stat.setBoolean(13, this._base.isVmHost());
        stat.setLong(14, this._vhost == null ? -1L : this._vhost.getDBID());
        stat.setString(15, this._base.getServiceProfile());
        stat.setString(16, this._base.getServerBlade());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getEnclosureName());
        stat.setBoolean(2, this._base.isVirtual());
        stat.setString(3, this._base.getIpAddress());
        stat.setString(4, this.getDMPath());
        stat.setInt(5, this._base.getType());
        stat.setLong(6, this._base.getLastScanTime());
        stat.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
        stat.setString(8, this._base.getOSInfo());
        stat.setString(9, this._base.getVendor());
        stat.setString(10, this._base.getModel());
        stat.setString(11, this._base.getVersion());
        stat.setBoolean(12, this._base.isVmHost());
        stat.setLong(13, this._vhost == null ? -1L : this._vhost.getDBID());
        stat.setString(14, this._base.getServiceProfile());
        stat.setString(15, this._base.getServerBlade());
        stat.setLong(16, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getEnclosureName());
    }

    public long getMemorySize() {
        return this._base.getMemorySize();
    }

    public void setMemorySize(long memorySize) {
        this._base.setMemorySize(memorySize);
    }

    public short getCpuCount() {
        return this._base.getCpuCount();
    }

    public void setCpuCount(short cpuCount) {
        this._base.setCpuCount(cpuCount);
    }

    public long getCpuSpeedAvg() {
        return this._base.getCpuSpeedAvg();
    }

    public void setCpuSpeedAvg(long cpuSpeedAvg) {
        this._base.setCpuSpeedAvg(cpuSpeedAvg);
    }

    public boolean isVmHost() {
        return this._base.isVmHost();
    }

    public void setVmHost(boolean isVmHost) {
        this._base.setVmHost(isVmHost);
    }

    public VHostImpl getVhost() {
        return this._vhost;
    }

    public void setVhost(VHostImpl vhost) {
        NameKey newHsPK;
        NameKey oldHsPK = this._vhost == null ? null : (NameKey)this._vhost.getPK();
        NameKey nameKey = newHsPK = vhost == null ? null : (NameKey)vhost.getPK();
        if (this._vhost == null && vhost == null) {
            return;
        }
        if (!GenUtil.equals(oldHsPK, newHsPK)) {
            this._base.setVHost(vhost == null ? null : (HostSystem)vhost.getBaseObject());
            this.propertyChanged((short)1809, this._vhost == null ? null : this._vhost.getBaseObject(), vhost == null ? null : vhost.getBaseObject());
        } else {
            HostSystem hs = this._base.getVHost();
            if (hs == null) {
                FabricImpl._Logger.info((Object)(this + " HostSystem is null"));
                return;
            }
            this.setOsType(hs, hs.getOsType(), vhost.getOsType());
            this.setVendor(hs, hs.getVendor(), vhost.getVendor());
            this.setVersion(hs, hs.getVersion(), vhost.getVersion());
            this.setModel(hs, hs.getModel(), vhost.getModel());
            this.setMemorySize(hs, hs.getMemorySize(), vhost.getMemorySize());
            this.setCpuCount(hs, hs.getCpuCount(), vhost.getCpuCount());
            this.setCpuSpeedAvg(hs, hs.getCpuSpeedAvg(), vhost.getCpuSpeedAvg());
            this.setHostName(hs, hs.getHostName(), vhost.getHostName());
            this.setHostFullName(hs, hs.getHostFullName(), vhost.getHostFullName());
            this.setVmPKs(hs, hs.getVmPKs(), vhost.getVmPKs());
            this.setIpAddresses(hs, hs.getIpAddresses(), vhost.getIpAddresses());
            this.setMacAddresses(hs, hs.getMacAddresses(), vhost.getMacAddresses());
            this.setAliases(hs, hs.getAliases(), vhost.getAliases());
            this.setMultiPath(hs, hs.getMultiPath(), vhost.getMultiPath());
            this.setClusterName(hs, hs.getClusterName(), vhost.getClusterName());
            this.setVCPK(hs, hs.getVCPK(), vhost.getVCPK());
            this.setPowerState(hs, hs.getPowerState(), vhost.getPowerState());
            this.setConnState(hs, hs.getConnState(), vhost.getConnState());
        }
        this.setNumVms();
        this._vhost = vhost;
    }

    public List<VmImpl> getVms() {
        return this._vhost == null ? null : this._vhost.getVms();
    }

    private void setOsType(HostSystem hs, String oldOsType, String newOsType) {
        if (!GenUtil.equals(oldOsType, newOsType)) {
            hs.setOsType(newOsType);
            this.propertyChanged((short)3841, (Serializable)((Object)oldOsType), (Serializable)((Object)newOsType));
        }
    }

    private void setVendor(HostSystem hs, String oldVendor, String newVendor) {
        if (!GenUtil.equals(oldVendor, newVendor)) {
            hs.setVendor(newVendor);
            this.propertyChanged((short)3842, (Serializable)((Object)oldVendor), (Serializable)((Object)newVendor));
        }
    }

    private void setVersion(HostSystem hs, String oldVersion, String newVersion) {
        if (!GenUtil.equals(oldVersion, newVersion)) {
            hs.setVersion(newVersion);
            this.propertyChanged((short)3843, (Serializable)((Object)oldVersion), (Serializable)((Object)newVersion));
        }
    }

    private void setModel(HostSystem hs, String oldModel, String newModel) {
        if (!GenUtil.equals(oldModel, newModel)) {
            hs.setVersion(newModel);
            this.propertyChanged((short)3844, (Serializable)((Object)oldModel), (Serializable)((Object)newModel));
        }
    }

    private void setMemorySize(HostSystem hs, long oldMSize, long newMSize) {
        if (oldMSize != newMSize) {
            hs.setMemorySize(newMSize);
            this.propertyChanged((short)3845, new Long(oldMSize), new Long(newMSize));
        }
    }

    private void setCpuCount(HostSystem hs, short oldCpuCount, short newCpuCount) {
        if (oldCpuCount != newCpuCount) {
            hs.setCpuCount(newCpuCount);
            this.propertyChanged((short)3846, new Short(oldCpuCount), new Short(newCpuCount));
        }
    }

    private void setCpuSpeedAvg(HostSystem hs, long oldCpuSpeedAvg, long newCpuSpeedAvg) {
        if (oldCpuSpeedAvg != newCpuSpeedAvg) {
            hs.setCpuSpeedAvg(newCpuSpeedAvg);
            this.propertyChanged((short)3847, new Long(oldCpuSpeedAvg), new Long(newCpuSpeedAvg));
        }
    }

    private void setHostName(HostSystem hs, String oldHostName, String newHostName) {
        if (!GenUtil.equals(oldHostName, newHostName)) {
            hs.setHostName(newHostName);
            this.propertyChanged((short)3848, (Serializable)((Object)oldHostName), (Serializable)((Object)newHostName));
        }
    }

    private void setHostFullName(HostSystem hs, String oldHostFullName, String newHostFullName) {
        if (!GenUtil.equals(oldHostFullName, newHostFullName)) {
            hs.setHostFullName(newHostFullName);
            this.propertyChanged((short)3849, (Serializable)((Object)oldHostFullName), (Serializable)((Object)newHostFullName));
        }
    }

    private void setVmPKs(HostSystem hs, List<NameKey> oldVmPKs, List<NameKey> newVmPKs) {
        if (!GenUtil.equals(oldVmPKs, newVmPKs)) {
            hs.setVms(newVmPKs);
            this.propertyChanged((short)3850, (Serializable)((Object)oldVmPKs), (Serializable)((Object)newVmPKs));
        }
    }

    private void setIpAddresses(HostSystem hs, ArrayList<String> oldIpAddresses, ArrayList<String> newIpAddresses) {
        if (!GenUtil.equals(oldIpAddresses, newIpAddresses)) {
            hs.setIpAddresses(newIpAddresses);
            this.propertyChanged((short)3851, oldIpAddresses, newIpAddresses);
        }
    }

    private void setMacAddresses(HostSystem hs, ArrayList<String> oldMacAddresses, ArrayList<String> newMacAddresses) {
        if (!GenUtil.equals(oldMacAddresses, newMacAddresses)) {
            hs.setMacAddresses(newMacAddresses);
            this.propertyChanged((short)3852, oldMacAddresses, newMacAddresses);
        }
    }

    private void setAliases(HostSystem hs, ArrayList<String> oldAliases, ArrayList<String> newAliases) {
        if (!GenUtil.equals(oldAliases, newAliases)) {
            hs.setAliases(newAliases);
            this.propertyChanged((short)3853, oldAliases, newAliases);
        }
    }

    private void setMultiPath(HostSystem hs, String oldMultipath, String newMultipath) {
        if (!GenUtil.equals(oldMultipath, newMultipath)) {
            hs.setMultiPath(newMultipath);
            this.propertyChanged((short)3854, (Serializable)((Object)oldMultipath), (Serializable)((Object)newMultipath));
        }
    }

    private void setClusterName(HostSystem hs, String oldCluster, String newCluster) {
        if (!GenUtil.equals(oldCluster, newCluster)) {
            hs.setClusterName(newCluster);
            this.propertyChanged((short)3855, (Serializable)((Object)oldCluster), (Serializable)((Object)newCluster));
        }
    }

    private void setVCPK(HostSystem hs, InetAddress oldVcPK, InetAddress newVcPK) {
        if (!GenUtil.equals(oldVcPK, newVcPK)) {
            hs.setVCPK(newVcPK);
            this.propertyChanged((short)3856, oldVcPK, newVcPK);
        }
    }

    private void setPowerState(HostSystem hs, int oldPowerState, int newPowerState) {
        if (oldPowerState != newPowerState) {
            hs.setPowerState(newPowerState);
            this.propertyChanged((short)3857, new Integer(oldPowerState), new Integer(newPowerState));
        }
    }

    private void setConnState(HostSystem hs, int oldConnState, int newConnState) {
        if (oldConnState != newConnState) {
            hs.setConnState(newConnState);
            this.propertyChanged((short)3858, new Integer(oldConnState), new Integer(newConnState));
        }
    }

    private void setNumVms() {
        int numVms = -1;
        HostSystem hs = this._base.getVHost();
        numVms = hs == null ? 0 : (hs.getVmPKs() == null ? 0 : hs.getVmPKs().size());
        Integer oldNumVms = new Integer(this._base.getNumVms());
        if (this._base.setNumVms(numVms)) {
            this.propertyChanged((short)1806, oldNumVms, new Integer(numVms));
        }
    }

    public String getServiceProfile() {
        return this._base.getServiceProfile();
    }

    public void setServiceProfile(String serviceProfile) {
        String oldServiceProfile = this._base.getServiceProfile();
        if (this._base.setServiceProfile(serviceProfile)) {
            this.propertyChanged((short)1807, (Serializable)((Object)oldServiceProfile), (Serializable)((Object)serviceProfile));
        }
    }

    public String getServerBlade() {
        return this._base.getServerBlade();
    }

    public void setServerBlade(String serverBlade) {
        String oldServerBlade = this._base.getServerBlade();
        if (this._base.setServerBlade(serverBlade)) {
            this.propertyChanged((short)1808, (Serializable)((Object)oldServerBlade), (Serializable)((Object)serverBlade));
        }
    }

    public int getNumVms() {
        return this._base.getNumVms();
    }
}

