/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.FexBase;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.model.VdcBase;
import com.cisco.dcbu.sm.common.type.IpKey;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.EthDBObjectIf;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthNodeIf;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ServiceUtil;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import com.cisco.dcbu.sm.server.model.VlanImpl;
import com.cisco.dcbu.sm.server.model.VpcEndPoint;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EthSwitchImpl
extends AbstractModelObjectImpl
implements SwitchIf,
EthNodeIf,
DumpIf,
EthDBObjectIf {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String TableName = "ethswitch";
    public static final String InsertSQL = "insert into ethswitch(id, license_id, ip_address, type, is_manageable, unmanageable_cause, num_ports, global_device_id, device_id, capability, vtp_mgmt_domain, vlan_list, sys_name, sys_contact, sys_location, sys_uptime, version, is_present, serial_number, last_update_time, last_scan_time, sys_description, vendor, model_name, is_vdc, vdc_id, vdc_mac, vdc_name, default_vdc_mac, vdc_state, fcoe_capable, fcoe_enabled, cpu_usage, mem_usage, is_fex, fex_id, fex_enabled, disc_status, disc_descr, lanswitch_classid, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, sign, lic_details, is_fwsm, is_deep_disc, l_report, features_string, primary_ip, secondary_ip ) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?)";
    public static final String DeleteSQL = "delete from ethswitch where id=?";
    public static final String UpdateSQL = "update ethswitch set license_id=?, ip_address=?, type=?, is_manageable=?, unmanageable_cause=?, num_ports=?, global_device_id=?, device_id=?, capability=?, vtp_mgmt_domain=?, vlan_list=?, sys_name=?, sys_contact=?, sys_location=?, sys_uptime=?, version=?, is_present=?, serial_number=?, last_update_time=?, last_scan_time=?, sys_description=?, vendor=?, model_name=?, is_vdc=?, vdc_id=?, vdc_mac=?, vdc_name=?, default_vdc_mac=?, vdc_state=?, fcoe_capable=?, fcoe_enabled=?, cpu_usage=?, mem_usage=?, is_fex=?, fex_id=?, fex_enabled=?, disc_status=?, disc_descr=?, lanswitch_classid=?, num_1g_port=?, num_2g_port=?, num_4g_port=?, num_8g_port=?, num_10g_port=?, num_16g_port=?, num_40g_port=?, num_100g_port=?, sign=?, lic_details=?, is_fwsm=?, is_deep_disc=?, l_report=?, features_string=?, primary_ip=?, secondary_ip=? where id=?";
    public static final String QuerySQL = "select id, license_id, ip_address, type, is_manageable, unmanageable_cause, num_ports, global_device_id, device_id, capability, vtp_mgmt_domain, vlan_list, sys_name, sys_contact, sys_location, sys_uptime, version, is_present, serial_number, last_update_time, last_scan_time, sys_description, vendor,  model_name, is_vdc, vdc_id, vdc_mac, vdc_name, default_vdc_mac, vdc_state, fcoe_capable, fcoe_enabled, cpu_usage, mem_usage, is_fex, fex_id, fex_enabled, disc_status, disc_descr, lanswitch_classid, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, sign, lic_details, is_fwsm, is_deep_disc, features_string, primary_ip, secondary_ip from ethswitch";
    public static final String QuerySQL_ByLanDBID = "select id, license_id, ip_address, type, is_manageable, unmanageable_cause, num_ports, global_device_id, device_id, capability, vtp_mgmt_domain, vlan_list, sys_name, sys_contact, sys_location, sys_uptime, version, is_present, serial_number, last_update_time, last_scan_time, sys_description, vendor,  model_name, is_vdc, vdc_id, vdc_mac, vdc_name, default_vdc_mac, vdc_state, fcoe_capable, fcoe_enabled, cpu_usage, mem_usage, is_fex, fex_id, fex_enabled, disc_status, disc_descr, lanswitch_classid, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, sign, lic_details, is_fwsm, is_deep_disc, features_string, primary_ip, secondary_ip from ethswitch where ethswitch.id in (select ethsw.id from lanswitch_map lsm, ethswitch ethsw where ethsw.id=lsm.id and lsm.lan_id=?)";
    public static final String QuerySQL_ByDBID = "select id, license_id, ip_address, type, is_manageable, unmanageable_cause, num_ports, global_device_id, device_id, capability, vtp_mgmt_domain, vlan_list, sys_name, sys_contact, sys_location, sys_uptime, version, is_present, serial_number, last_update_time, last_scan_time, sys_description, vendor,  model_name, is_vdc, vdc_id, vdc_mac, vdc_name, default_vdc_mac, vdc_state, fcoe_capable, fcoe_enabled, cpu_usage, mem_usage, is_fex, fex_id, fex_enabled, disc_status, disc_descr, lanswitch_classid, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, sign, lic_details, is_fwsm, is_deep_disc, features_string, primary_ip, secondary_ip from ethswitch where ethswitch.id=?";
    public static final String QuerySQL_ByDeviceIdOrIp = "select id, is_deep_disc from ethswitch where ethswitch.device_id=? or ethswitch.ip_address=?";
    public static final String QuerySQL_MgmtAddrBySwitchDBID = "select mgmt_address, mgmt_type from switch_mgmt_address where switch_id=?";
    public static final String InsertLanSQL = "insert into lanswitch_map(id, lan_id, last_update_time, last_scan_time) values(?,?,?,?) ";
    public static final String DeleteLanSQL_BySwitchDBID = "delete from lanswitch_map where id=?";
    public static final String UpdateLanSQL = "update lanswitch_map set last_update_time=?, last_scan_time=? where id=? and lan_id=? ";
    public static final String QueryLanSQL_DBIDBySwitchDBIDLanDBID = "select id from lanswitch_map where id=? and lan_id=?";
    public static final String VlanTableName = "ethswitch_vlan";
    public static final String QueryVlanSQL_DBIDBySwitchVlanDBID = "select id from ethswitch_vlan where ethswitch_id=? and vlan_id=?";
    public static final String InsertVlanSQL = "insert into ethswitch_vlan (ethswitch_id, vlan_id, last_update_time) values(?,?,?) ";
    public static final String DeleteVlanSQL_BySwitchDBID = "delete from ethswitch_vlan where ethswitch_id=?";
    public static final String UpdateVlanSQL = "update ethswitch_vlan set last_update_time=? where ethswitch_id=? and vlan_id=? ";
    public static final String QueryVlanSQL_VlanDBIDBySwitchDBID = "select vlan_id from ethswitch_vlan where ethswitch_id=?";
    public static final String EthSwitchFexTableName = "ethswitch_fex";
    public static final String QueryFexSQL_DBIDBySwitchFexDBID = "select id from switch_fex where switch_id=? and fex_id=?";
    public static final String InsertFexSQL = "insert into ethswitch_fex (switch_id, fex_id, last_update_time) values(?,?,?) ";
    public static final String DeleteFexSQL_BySwitchDBID = "delete from ethswitch_fex where switch_id=?";
    public static final String UpdateFexSQL = "update ethswitch_fex set last_update_time=? where switch_id=? and fex_id=? ";
    public static final String QueryFexSQL_FexDBIDBySwitchDBID = "select fex_id from ethswitch_fex where switch_id=?";
    public static final String QuerySQL_LanSwitchClassIdBySwitchMac = "select ne.instanceclassid from abstractnetworkelement ne  where ne.macaddress = ?";
    public static final String QuerySQL_LanSwitchClassIdBySwitchSerial = "select ne.instanceclassid from abstractnetworkelement ne, chassis c  where ne.chassis_id = c.hardware_id and c.serialnumber = ?";
    public static final String QuerySQL_LanSwitchClassIdBySwitchIpVirtual = "select ne.instanceclassid from abstractnetworkelement ne  where ne.mgmtipaddress = ? and ne.class_type = 'virtual'";
    protected EthSwitchBase _base;
    protected boolean _hasFCoECard = false;
    private boolean _assignLicenseTried = false;
    protected int _discStatus = 0;
    protected String _discDescr = null;
    protected long _lanswitchClassId = -1L;
    protected SwitchVersion _swVersion = null;
    private int _numLicFeatures;
    private transient InetAddress _clientIp = null;
    private transient String _userName = null;
    protected final transient ConcurrentHashMap<Integer, EthPortImpl> _ethPortsByIfindex = new ConcurrentHashMap();
    protected final transient ConcurrentHashMap<Integer, FexImpl> _fexsByIfindex = new ConcurrentHashMap();
    protected transient SnmpPeer _peer;
    protected SnmpUser _credential;
    protected transient int _discFlags = 0;
    protected transient boolean _reachable = true;
    protected transient boolean _continueProbe = false;
    protected transient boolean _deepDisc = false;
    public long _entLastChangeTime = -1L;
    protected long _lastUpdateTime = 0L;
    protected final transient ConcurrentHashMap<Long, EthPortImpl> _ethPortsByDBID = new ConcurrentHashMap();
    protected final transient ConcurrentHashMap<Integer, VpcEndPoint> _vpcEndPoints = new ConcurrentHashMap();
    protected transient boolean _switchBeingRemoved = false;

    protected EthSwitchImpl() {
    }

    public EthSwitchImpl(SerialNumKey swPK, InetAddress swIp) {
        this._base = new EthSwitchBase<SerialNumKey>(swPK, swIp);
    }

    protected EthSwitchImpl(VdcPK swPK, InetAddress swIp) {
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public EthSwitchBase getBase() {
        return this._base;
    }

    @Override
    public PKIf getSwitchPK() {
        return this._base.getSwitchPK();
    }

    @Override
    public IpKey getNodeKey() {
        return this._base.getNodeKey();
    }

    @Override
    public SerialNumKey getChassisKey() {
        return this._base.getChassisKey();
    }

    @Override
    public FabricImpl getFabric() {
        throw new UnsupportedOperationException("Invalid call for ethernet objects");
    }

    @Override
    public LanImpl getLan() {
        return DCManager.getInstance().getLan();
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean oldValue = this._base.isPresent();
        if (oldValue != isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1025, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isPresent()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, "EthSwitchImpl trace setPresent: old=" + oldValue + "-->new=" + isPresent + " for " + this.print(false, true), new Exception("TraceLogger"));
            }
        }
        return oldValue;
    }

    @Override
    public InetAddress[] getManagementAddresses() {
        return this._base.getManagementAddresses();
    }

    public void setManagementAddresses(InetAddress[] newAddrs, boolean createPeer) {
        InetAddress[] oldAddrs = this._base.getManagementAddresses();
        InetAddress oldAddrInUse = this.getInetAddress();
        boolean changed = false;
        if (newAddrs != null) {
            if (this.getBase().getNumOfMgmtAddrs() == newAddrs.length) {
                for (InetAddress addr : newAddrs) {
                    if (this.getBase().containsMgmtAddr(addr)) continue;
                    changed = true;
                    break;
                }
            } else {
                changed = true;
            }
        } else {
            boolean bl = changed = newAddrs != oldAddrs;
        }
        if (changed) {
            this._base.setManagementAddresses(newAddrs);
            this.propertyChanged((short)1040, (Serializable)oldAddrs, (Serializable)this._base.getManagementAddresses());
            this.getLan().checkAndUpdateCacheByMgmtAddrs(this, oldAddrs, newAddrs);
            if (!(!createPeer || oldAddrInUse != null && this.isManageable() && this._base.containsMgmtAddr(oldAddrInUse))) {
                this.createAndSetPeer();
            }
        }
    }

    @Override
    public String getIpAddress() {
        return this._base.getIpAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return this._base.getInetAddress();
    }

    protected void setManagementAddressInUse(InetAddress newAddr) {
        if (!GenUtil.equals(this._base.getInetAddress(), newAddr)) {
            InetAddress oldAddr = this._base.getInetAddress();
            this._base.setManagementAddressInUse(newAddr);
            this.propertyChanged((short)1041, oldAddr, newAddr);
        }
    }

    public boolean isManageable() {
        return this._base.isManageable();
    }

    public void setManageable(boolean isManageable, String cause) {
        if (this._base.isManageable() ^ isManageable) {
            this._base.setManageable(isManageable);
            this.propertyChanged((short)1038, Boolean.valueOf(!isManageable), Boolean.valueOf(isManageable));
        }
        if (!GenUtil.equals(this._base.getUnmanageableCause(), cause)) {
            this._base.setUnmanageableCause(cause);
            if (cause != null) {
                this.propertyChanged((short)1039, null, (Serializable)((Object)cause));
            }
        }
    }

    public String getUnmanageableCause() {
        return this._base.getUnmanageableCause();
    }

    public boolean isManageTimeOut() {
        String str = this._base.getUnmanageableCause();
        return str != null && str.equals("timeout");
    }

    @Override
    public void setSysObjectID(int[] objectId) {
        if (objectId == null || objectId.length == 0) {
            return;
        }
        byte[] objId = new byte[objectId.length];
        for (int i = 0; i < objectId.length; ++i) {
            objId[i] = (byte)objectId[i];
        }
        this._base.setSysObjectId(objId);
        this.setModelType(objectId[objectId.length - 1]);
    }

    @Override
    public void setSysName(String newSysName) {
        String oldSysName;
        if (LanImpl.CdpTrimDomain && newSysName != null) {
            newSysName = GenUtil.trimDomain(newSysName);
        }
        if (!GenUtil.equals(oldSysName = this._base.getSysName(), newSysName)) {
            this._base.setSysName(newSysName);
            this.propertyChanged((short)1027, (Serializable)((Object)oldSysName), (Serializable)((Object)newSysName));
            this.getLan().checkAndUpdateCacheBySysname(this, oldSysName, newSysName);
        }
    }

    @Override
    public void setSysDescr(String newSysDescr) {
        String oldSysDescr;
        String newStr = newSysDescr;
        if (newSysDescr != null && newSysDescr.length() >= 255) {
            newStr = newSysDescr.substring(0, 253);
        }
        if (!GenUtil.equals(oldSysDescr = this._base.getSysDescr(), newStr)) {
            this._base.setSysDescr(newStr);
            this.propertyChanged((short)1052, (Serializable)((Object)oldSysDescr), (Serializable)((Object)newStr));
        }
    }

    @Override
    public void setSysLocation(String newSysLocation) {
        String oldSysLocation = this._base.getSysLocation();
        if (!GenUtil.equals(oldSysLocation, newSysLocation)) {
            this._base.setSysLocation(newSysLocation);
            this.propertyChanged((short)1029, (Serializable)((Object)oldSysLocation), (Serializable)((Object)newSysLocation));
        }
    }

    public void setSysCpuUsage(int usage) {
        int oldValue = this._base.getSysCpuUsage();
        if (usage != oldValue) {
            this._base.setSysCpuUsage(usage);
        }
    }

    public void setSysMemoryUsage(int usage) {
        int oldValue = this._base.getSysMemoryUsage();
        if (usage != oldValue) {
            this._base.setSysMemoryUsage(usage);
        }
    }

    @Override
    public void setSysUpTime(long upTime) {
        long oldTime = this._base.getSysUpTime();
        if (upTime != 0L && upTime != oldTime) {
            this._base.setSysUpTime(upTime);
            this._base.setSwitchUpTime(upTime);
            if (Math.abs(this._base.getSysUpTime() - upTime) > (long)(this._peer != null ? this._peer.getTimeout() / 10 : 1000)) {
                long newBootTime = upTime == 0L ? 0L : System.currentTimeMillis() - upTime * 10L;
                this.setSysLastBootTime(newBootTime);
                this.setSwitchLastBootTime(newBootTime);
            }
        }
    }

    public void setSysLastBootTime(long time) {
        long oldTime = this._base.getSysLastBootTime();
        if (Math.abs(oldTime - time) > 5000L) {
            this._base.setSysLastBootTime(time);
            this.propertyChanged((short)1030, new Long(oldTime), new Long(time));
        }
    }

    public void setSwitchLastBootTime(long time) {
        long oldTime = this._base.getSwitchLastBootTime();
        if (Math.abs(oldTime - time) > 5000L) {
            this._base.setSwitchLastBootTime(time);
            this.propertyChanged((short)1069, new Long(oldTime), new Long(time));
        }
    }

    public long getSwitchUpTime() {
        return this._base.getSwitchUpTime();
    }

    @Override
    public SerialNumKey setSerialNumber(String serialNum) {
        SerialNumKey oldValue = this._base.getChassisKey();
        if (oldValue == null || !GenUtil.equals(oldValue._serialNum, serialNum)) {
            this._base.setSerialNumber(serialNum);
            this.propertyChanged((short)1032, (Serializable)((Object)oldValue._serialNum), (Serializable)((Object)this._base.getChassisKey()._serialNum));
        }
        return oldValue;
    }

    @Override
    public void setSysContact(String newSysContact) {
        String oldSysContact = this._base.getSysContact();
        if (!GenUtil.equals(oldSysContact, newSysContact)) {
            this._base.setSysContact(newSysContact);
            this.propertyChanged((short)1028, (Serializable)((Object)oldSysContact), (Serializable)((Object)newSysContact));
        }
    }

    public void setTelnetEnabled(boolean b) {
        if (b ^ this._base.isTelnetEnabled()) {
            this._base.setTelnetEnabled(b);
            this.propertyChanged((short)1055, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setSSHEnabled(boolean b) {
        if (b ^ this._base.isSSHEnabled()) {
            this._base.setSSHEnabled(b);
            this.propertyChanged((short)1057, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    @Override
    public void setCdpEnabled(boolean b) {
        if (b ^ this._base.isCdpEnabled()) {
            this._base.setCdpEnabled(b);
            this.propertyChanged((short)1058, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    @Override
    public boolean isCdpEnabled() {
        return this._base.isCdpEnabled();
    }

    @Override
    public String getName() {
        String name = this._base.getName();
        if (name != null && name.length() != 0) {
            return name;
        }
        name = this._base.getSysName();
        if (name != null && name.length() != 0) {
            return name;
        }
        if (this._peer != null) {
            return this._peer.toString();
        }
        if (this._base.getIpAddress() != null) {
            return this._base.getIpAddress();
        }
        if (this.getGlobalDeviceId() != null) {
            return this.getGlobalDeviceId();
        }
        return String.valueOf(this.getSwitchPK());
    }

    @Override
    public void setVersion(String rawVersion) {
        String newVersion = this.parseVersion(rawVersion);
        String oldVersion = this._base.getVersion();
        if (!GenUtil.equals(oldVersion, newVersion)) {
            try {
                this._swVersion = new SwitchVersion(newVersion);
                this._base.setVersion(newVersion);
                this.propertyChanged((short)1031, (Serializable)((Object)oldVersion), (Serializable)((Object)newVersion));
            }
            catch (NumberFormatException e) {
                _Tracer.log(Level.WARN, "Invalid version: " + e.getMessage());
            }
            if (PlatformType.isTypeOf(this._base.getPlatformType(), PlatformType.FCOE)) {
                this.updateFCoECapable();
            }
        }
    }

    @Override
    public String getVersion() {
        return this._base.getVersion();
    }

    public SwitchVersion getSwVersion() {
        return this._swVersion;
    }

    @Override
    public long getSysUpTime() {
        return this._base.getSysUpTime();
    }

    @Override
    public void setVendor(String vendor) {
        String old = this._base.getVendor();
        if (vendor != old) {
            this._base.setVendor(vendor);
        }
    }

    @Override
    public void setPlatform(String name) {
        this._base.setPlatformName(name);
    }

    public void setPlatformType(PlatformType type) {
        this._base.setPlatformType(type);
    }

    @Override
    public void setModelType(int newType) {
        int oldType = this._base.getModelType();
        if (oldType != newType) {
            this._base.setModelType(newType);
            this.propertyChanged((short)1035, new Integer(oldType), new Integer(newType));
        }
    }

    @Override
    public void setModelName(String newModel) {
        String oldModel = this._base.getModelName();
        if (!GenUtil.equals(oldModel, newModel)) {
            this._base.setModelName(newModel);
            this.propertyChanged((short)1036, (Serializable)((Object)oldModel), (Serializable)((Object)newModel));
        }
    }

    @Override
    public String getModelName() {
        return this._base.getModelName();
    }

    @Override
    public int getModuleIndexOffset() {
        return this._base.getModuleIndexOffset();
    }

    public void setLicenseViolation(boolean violation) {
        if (this._base.isLicenseViolation() != violation) {
            this._base.setLicenseViolation(violation);
            this.propertyChanged((short)1050, Boolean.valueOf(!violation), Boolean.valueOf(violation));
        }
    }

    public boolean isTrapRegistered() {
        return this._base.isTrapRegistered();
    }

    @Override
    public void setTrapRegistered(boolean b) {
        if (b ^ this._base.isTrapRegistered()) {
            this._base.setTrapRegistered(b);
            this.propertyChanged((short)1048, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setSyslogRegistered(boolean b) {
        if (b ^ this._base.isSyslogRegistered()) {
            this._base.setSyslogRegistered(b);
            this.propertyChanged((short)1049, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    @Override
    public void setDeviceId(String newId) {
        if (LanImpl.CdpTrimDomain && newId != null) {
            newId = GenUtil.trimDomain(newId);
        }
        String oldId = this._base.getDeviceId();
        if (newId != null && !GenUtil.equals(oldId, newId)) {
            String sysName;
            this._base.setDeviceId(newId);
            this.propertyChanged((short)1060, (Serializable)((Object)oldId), (Serializable)((Object)newId));
            if (this._base.getSysName() == null && (sysName = GenUtil.getSysName(newId)) != null) {
                this.setSysName(sysName);
            }
        }
    }

    @Override
    public String getDeviceId() {
        return this._base.getDeviceId();
    }

    @Override
    public void setGlobalDeviceId(String newId) {
        String oldId = this._base.getGlobalDeviceId();
        if (!GenUtil.equals(oldId, newId)) {
            this._base.setGlobalDeviceId(newId);
            this.propertyChanged((short)1059, (Serializable)((Object)oldId), (Serializable)((Object)newId));
        }
    }

    public String getGlobalDeviceId() {
        return this._base.getGlobalDeviceId();
    }

    @Override
    public PlatformType getPlatformType() {
        return this._base.getPlatformType();
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setLastUpdateTime(long updateTime) {
        this._lastUpdateTime = updateTime;
    }

    public boolean setActiveSupPhyIndex(int newPhyIndex) {
        int oldPhyIndex = this._base.getActiveSupPhysicalIndex();
        if (oldPhyIndex != newPhyIndex) {
            Card preActiveCard;
            this._base.setActiveSupPhysicalIndex(newPhyIndex);
            Card activeCard = InventoryManager.getInstance().findCardByPhysicalIndex(this.getSwitchPK(), newPhyIndex);
            if (activeCard != null) {
                activeCard.setActive(true);
            }
            if ((preActiveCard = InventoryManager.getInstance().findCardByPhysicalIndex(this.getSwitchPK(), oldPhyIndex)) != null) {
                preActiveCard.setActive(false);
            }
            this.propertyChanged((short)1042, new Integer(oldPhyIndex), new Integer(newPhyIndex));
            return true;
        }
        return false;
    }

    public boolean setStandbySupPhyIndex(int newPhyIndex) {
        int oldPhyIndex = this._base.getStandbySupPhysicalIndex();
        if (oldPhyIndex != newPhyIndex) {
            this._base.setStandbySupPhysicalIndex(newPhyIndex);
            return true;
        }
        return false;
    }

    public boolean setActiveSupSlot(int slot) {
        int oldSlot = this._base.getActiveSupSlot();
        if (oldSlot != slot) {
            this._base.setActiveSupSlot(slot);
            return true;
        }
        return false;
    }

    public boolean setStandbySupSlot(int slot) {
        int oldSlot = this._base.getStandbySupSlot();
        if (oldSlot != slot) {
            this._base.setStandbySupSlot(slot);
            this.propertyChanged((short)1043, new Integer(oldSlot), new Integer(slot));
            return true;
        }
        return false;
    }

    public void setModuleIndexOffset(int offset) {
        int oldOffset = this._base.getModuleIndexOffset();
        if (oldOffset != offset) {
            this._base.setModuleIndexOffset(offset);
        }
    }

    public void setConnUnitStatus(int newStatus) {
        int oldStatus = this._base.setConnUnitStatus(newStatus);
        if (oldStatus != newStatus) {
            this.propertyChanged((short)1045, new Integer(oldStatus), new Integer(newStatus));
        }
    }

    public void setActiveSupState(int newState) {
        int oldState = this._base.setActiveSupState(newState);
        if (oldState != newState) {
            // empty if block
        }
    }

    public void setStandbySupState(int newState) {
        int oldState = this._base.setStandbySupState(newState);
        if (oldState != newState) {
            this.propertyChanged((short)1044, new Integer(oldState), new Integer(newState));
        }
    }

    protected String parseVersion(String rawVersion) {
        String retVersion = rawVersion;
        if (this._base.getVendor() != null && this._base.getVendor().equals("Cisco")) {
            int pos2;
            String version;
            int pos1 = rawVersion.indexOf("Interim version");
            if (pos1 != -1) {
                pos1 += 16;
            } else {
                pos1 = rawVersion.indexOf("Version");
                if (pos1 != -1) {
                    pos1 += 8;
                }
            }
            if (pos1 != -1 && (version = rawVersion.substring(pos1, (pos2 = rawVersion.indexOf(44, pos1)) != -1 ? pos2 : rawVersion.length()).trim()) != null && version.length() != 0) {
                retVersion = version;
            }
        } else {
            int pos2;
            String version;
            int pos1 = rawVersion.indexOf("Version");
            if (pos1 != -1) {
                pos1 += 8;
            }
            if (pos1 != -1 && (version = rawVersion.substring(pos1, (pos2 = rawVersion.indexOf(44, pos1)) != -1 ? pos2 : rawVersion.length()).trim()) != null && version.length() != 0) {
                retVersion = version;
            }
        }
        if (retVersion.length() >= 254) {
            retVersion = retVersion.substring(0, 253);
        }
        return retVersion;
    }

    public boolean isFwsm() {
        return this._base.isFwsm();
    }

    public boolean isN5K() {
        return this._base.isN5K();
    }

    public boolean isN5K5() {
        String modelName = this.getModelName();
        if (modelName == null) {
            return false;
        }
        return this._base.isN5K() && (modelName.startsWith("N5K-C55") || modelName.startsWith("N5K-C56") || modelName.equals("Nexus5548") || modelName.equals("Nexus5596") || modelName.equals("Nexus 5596"));
    }

    public boolean isN3K5() {
        String modelName = this.getModelName();
        if (modelName == null) {
            return false;
        }
        return this._base.isN3K() && modelName.startsWith("N3K-C35");
    }

    public boolean isN6K() {
        return this._base.isN6K();
    }

    public void setFwsm(boolean fwsm) {
        if (fwsm) {
            this._base.setPlatformType(PlatformType.FWSM);
        }
    }

    @Override
    public boolean isReachable() {
        return this._reachable;
    }

    @Override
    public void setReachable(boolean reachable) {
        this._reachable = reachable;
    }

    public boolean isDeepDisc() {
        return this._deepDisc;
    }

    public void setDeepDisc(boolean deepDisc) {
        this._deepDisc = deepDisc;
    }

    @Override
    public void setFeatureFlags(boolean[] flags) {
        if (flags == null || flags.length != AbstractSwitchBase.NUM_FEATURES) {
            return;
        }
        boolean[] oldValue = this.getBase().getFeatureFlags();
        boolean changed = false;
        for (int i = 0; i < flags.length; ++i) {
            if (oldValue[i] == flags[i]) continue;
            changed = true;
            break;
        }
        if (changed) {
            this.getBase().setFeatureFlags(flags);
            this.propertyChanged((short)1046, (Serializable)oldValue, (Serializable)flags);
        }
    }

    public boolean isAssignedLicenseTried() {
        return this._assignLicenseTried;
    }

    public void setAssignedLicenseTried(boolean b) {
        this._assignLicenseTried = b;
    }

    public SwitchLicenseDetails getLicenseDetails() {
        return this._base.getLicenseDetails();
    }

    public void setLicenseDetails(SwitchLicenseDetails licDetails) {
        this._base.setLicenseDetails(licDetails);
    }

    public InetAddress getClientIp() {
        return this._clientIp;
    }

    public void setClientIp(InetAddress _clientIp) {
        this._clientIp = _clientIp;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String _userName) {
        this._userName = _userName;
    }

    public boolean supportPortVlans() {
        boolean support = this._base.isCAT() || this._base.isMDS() || this._base.isNuovaFamily() || (this._base.isN4K() || this._base.isN7K() || this._base.isN9K()) && this._base.isFCoECapableVersion();
        return support;
    }

    public void setVlans(ArrayList<Short> vlanIds) {
        boolean hasChange;
        if (vlanIds == null) {
            return;
        }
        boolean bl = hasChange = this._base.getNumVlans() != vlanIds.size();
        if (!hasChange) {
            for (int i = 0; i < vlanIds.size(); ++i) {
                if (this._base.containVlan(vlanIds.get(i))) continue;
                hasChange = true;
                break;
            }
        }
        if (hasChange) {
            VlanImpl vlan;
            List<Short> oldValue = this._base.getVlans();
            this._base.setVlans(vlanIds);
            this.propertyChanged((short)1061, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, this._base.print(false, true) + "--EthSwitchImpl trace setVlans:old=" + oldValue + "-->new=" + this._base.getVlans(), new Exception("TraceLogger"));
            }
            for (short vlanId : oldValue) {
                vlan = this.getLan().findVlanById(vlanId);
                if (vlan == null) continue;
                vlan.removeSwitch(this);
            }
            for (short vlanId : vlanIds) {
                vlan = this.getLan().findVlanById(vlanId);
                if (vlan == null) continue;
                vlan.addSwitch(this);
            }
        }
    }

    public void addVlan(short vlanId) {
        if (this._base.containVlan(vlanId)) {
            return;
        }
        List<Short> oldValue = this._base.getVlans();
        if (this._base.addVlan(vlanId)) {
            VlanImpl vlan;
            this.propertyChanged((short)1061, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, this._base.print(false, true) + "--EthSwitchImpl trace addVlan:" + vlanId + "--old=" + oldValue + "-->new=" + this._base.getVlans(), new Exception("TraceLogger"));
            }
            if ((vlan = this.getLan().findVlanById(vlanId)) != null) {
                vlan.addSwitch(this);
            }
        }
    }

    public void removeVlan(short vlanId) {
        if (!this._base.containVlan(vlanId)) {
            return;
        }
        List<Short> oldValue = this._base.getVlans();
        if (this._base.removeVlan(vlanId)) {
            VlanImpl vlan;
            this.propertyChanged((short)1061, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, this._base.print(false, true) + "--EthSwitchImpl trace removeVlan:" + vlanId + "--old=" + oldValue + "-->new=" + this._base.getVlans(), new Exception("TraceLogger"));
            }
            if ((vlan = this.getLan().findVlanById(vlanId)) != null) {
                vlan.removeSwitch(this);
            }
        }
    }

    public void clearVlans() {
        if (this._base.getNumVlans() == 0) {
            return;
        }
        List<Short> oldValue = this._base.getVlans();
        this._base.clearVlans();
        this.propertyChanged((short)1061, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlans()));
        for (short vlanId : oldValue) {
            VlanImpl vlan = this.getLan().findVlanById(vlanId);
            if (vlan == null) continue;
            vlan.removeSwitch(this);
        }
    }

    @Override
    public List<Short> getVlanIds() {
        return this._base.getVlans();
    }

    @Override
    public void setVtpMgmtDomain(byte[] newDomains) {
        byte[] oldDomains = this._base.getVtpMgmtDomain();
        this._base.setVtpMgmtDomain(newDomains);
        this.propertyChanged((short)1062, (Serializable)oldDomains, (Serializable)newDomains);
    }

    public void updateCatIfMapping(int ifindex, String ifname) {
        if (ifindex < 0 || ifname == null || ifname.length() == 0 || !Character.isLetter(ifname.charAt(0))) {
            return;
        }
        HashMap<String, String> oldMapping = this.getBase().getIfMappingTable();
        if (this.getBase().updateIfMapping(ifindex, ifname)) {
            this.propertyChanged((short)1063, oldMapping, this.getBase().getIfMappingTable());
        }
    }

    public void updateCatIfMappingTable(HashMap<String, String> newMapping) {
        if (newMapping == null || newMapping.size() == 0) {
            return;
        }
        HashMap<String, String> oldMapping = this.getBase().getIfMappingTable();
        if (this.getBase().updateIfMappingTable(newMapping)) {
            this.propertyChanged((short)1063, oldMapping, this.getBase().getIfMappingTable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEthPort(EthPortImpl ethPort) {
        if (ethPort == null) {
            return false;
        }
        if (!ethPort.getSwitchPK().equals(this.getSwitchPK())) {
            return false;
        }
        ConcurrentHashMap<Integer, EthPortImpl> concurrentHashMap = this._ethPortsByIfindex;
        synchronized (concurrentHashMap) {
            EthPortImpl oldValue = this._ethPortsByIfindex.get(ethPort.getIfIndex());
            this._ethPortsByIfindex.put(ethPort.getIfIndex(), ethPort);
            this.updateNumEthPorts();
            if (ethPort.getDBID() != 0L) {
                this._ethPortsByDBID.put(ethPort.getDBID(), ethPort);
            }
            if (oldValue == null || oldValue != ethPort) {
                this.getLan().modelObjectAdded(ethPort);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EthPortImpl createPort(int ifindex) {
        EthPortImpl port;
        ConcurrentHashMap<Integer, EthPortImpl> concurrentHashMap = this._ethPortsByIfindex;
        synchronized (concurrentHashMap) {
            port = this._ethPortsByIfindex.get(ifindex);
            if (port == null) {
                port = new EthPortImpl(this, ifindex);
                port.setIfname(this.ifIndexToName(ifindex));
                port.setPhysical(this._base.isIfPhysical(ifindex));
                this._ethPortsByIfindex.put(ifindex, port);
            }
        }
        return port;
    }

    public EthPortImpl removeEthPort(int ifindex, boolean purgeDB) {
        EthPortImpl ethPort = this.findEthPort(ifindex);
        if (this.removeEthPort(ethPort, purgeDB)) {
            return ethPort;
        }
        return null;
    }

    public boolean removeEthPort(EthPortImpl ethPort, boolean purgeDB) {
        boolean removed;
        if (ethPort == null) {
            return false;
        }
        if (!this.getSwitchPK().equals(ethPort.getSwitchPK())) {
            return false;
        }
        boolean bl = removed = this._ethPortsByIfindex.remove(ethPort.getIfIndex()) != null;
        if (ethPort.getDBID() != 0L) {
            this._ethPortsByDBID.remove(ethPort.getDBID());
        }
        if (removed || !this._switchBeingRemoved) {
            this.getLan().modelObjectRemoved(ethPort.getPK());
        }
        if (purgeDB) {
            try {
                LanPersistentManager.getInstance().purgeEthPort(this.getLan(), ethPort);
            }
            catch (Exception e) {
                _Tracer.log(Level.WARN, this + " purge failed on eth port:" + ethPort, e);
            }
        }
        return removed;
    }

    public void setBeingRemoved(boolean flag) {
        this._switchBeingRemoved = flag;
    }

    public ArrayList<EthPortImpl> getAllPorts() {
        ArrayList<EthPortImpl> ports = new ArrayList<EthPortImpl>(this._ethPortsByIfindex.values());
        return ports;
    }

    public EthPortImpl findEthPort(int ifindex) {
        return this._ethPortsByIfindex.get(ifindex);
    }

    public ArrayList<EthPortImpl> findEthPort(String ifName) {
        ArrayList<EthPortImpl> ports = this.getAllPorts();
        ArrayList<EthPortImpl> foundPorts = new ArrayList<EthPortImpl>();
        for (EthPortImpl port : ports) {
            if (port.getIfname() == null || !port.getIfname().equals(ifName)) continue;
            foundPorts.add(port);
        }
        return foundPorts;
    }

    public void setNumEthPorts(int ethPorts) {
        int oldValue = this._base.getNumEthPorts();
        if (oldValue != ethPorts) {
            this._base.setNumEthPorts(ethPorts);
            this.propertyChanged((short)1064, Integer.valueOf(oldValue), Integer.valueOf(this._base.getNumEthPorts()));
        }
    }

    public void updateNumEthPorts() {
        this.setNumEthPorts(this._ethPortsByIfindex.size());
    }

    public int[] getIfindexes() {
        ArrayList ifindexList = new ArrayList(this._ethPortsByIfindex.keySet());
        Collections.sort(ifindexList);
        int[] ifindexAry = new int[ifindexList.size()];
        for (int i = 0; i < ifindexAry.length; ++i) {
            ifindexAry[i] = (Integer)ifindexList.get(i);
        }
        return ifindexAry;
    }

    @Override
    public String ifIndexToName(int ifIndex) {
        return this._base.ifIndexToName(ifIndex);
    }

    public int ifNameToIndex(String ifName) {
        return this._base.nameToIfIndex(ifName);
    }

    public List<EthPortImpl> getEthPorts() {
        return new ArrayList<EthPortImpl>(this._ethPortsByIfindex.values());
    }

    public int getNum1gPort() {
        return this._base.getNum1gPorts();
    }

    public void setNum1gPorts(int num1gPorts) {
        if (this._base.getNum1gPorts() != num1gPorts) {
            Integer oldNum = new Integer(this._base.getNum1gPorts());
            this._base.setNum1gPorts(num1gPorts);
        }
    }

    public int getNum2gPort() {
        return this._base.getNum2gPorts();
    }

    public void setNum2gPorts(int num2gPorts) {
        if (this._base.getNum2gPorts() != num2gPorts) {
            Integer oldNum = new Integer(this._base.getNum2gPorts());
            this._base.setNum2gPorts(num2gPorts);
        }
    }

    public int getNum4gPort() {
        return this._base.getNum4gPorts();
    }

    public void setNum4gPorts(int num4gPorts) {
        if (this._base.getNum4gPorts() != num4gPorts) {
            Integer oldNum = new Integer(this._base.getNum4gPorts());
            this._base.setNum4gPorts(num4gPorts);
        }
    }

    public int getNum8gPort() {
        return this._base.getNum8gPorts();
    }

    public void setNum8gPorts(int num8gPorts) {
        if (this._base.getNum8gPorts() != num8gPorts) {
            Integer oldNum = new Integer(this._base.getNum8gPorts());
            this._base.setNum8gPorts(num8gPorts);
        }
    }

    public int getNum10gPort() {
        return this._base.getNum10gPorts();
    }

    public void setNum10gPorts(int num10gPorts) {
        if (this._base.getNum10gPorts() != num10gPorts) {
            Integer oldNum = new Integer(this._base.getNum10gPorts());
            this._base.setNum10gPorts(num10gPorts);
        }
    }

    public int getNum16gPort() {
        return this._base.getNum16gPorts();
    }

    public void setNum16gPorts(int num16gPorts) {
        if (this._base.getNum16gPorts() != num16gPorts) {
            Integer oldNum = new Integer(this._base.getNum16gPorts());
            this._base.setNum16gPorts(num16gPorts);
        }
    }

    public int getNum40gPort() {
        return this._base.getNum40gPorts();
    }

    public void setNum40gPorts(int num40gPorts) {
        if (this._base.getNum40gPorts() != num40gPorts) {
            Integer oldNum = new Integer(this._base.getNum40gPorts());
            this._base.setNum40gPorts(num40gPorts);
        }
    }

    public int getNum100gPort() {
        return this._base.getNum100gPorts();
    }

    public void setNum100gPorts(int num100gPorts) {
        if (this._base.getNum100gPorts() != num100gPorts) {
            Integer oldNum = new Integer(this._base.getNum100gPorts());
            this._base.setNum100gPorts(num100gPorts);
        }
    }

    public int getNumLicensedFeatures() {
        return this._numLicFeatures;
    }

    public void setNumLicensedFeatures(int num) {
        this._numLicFeatures = num;
    }

    public void addChildPort(EthPortImpl channelPort, EthPortImpl childPort) {
        EthPortImpl oldParent;
        if (channelPort == null || childPort == null) {
            _Tracer.log(Level.DEBUG, this + " cannot add child port to channel:" + channelPort + "," + childPort);
            return;
        }
        if (!channelPort.getBase().isChannel() || childPort.getBase().isChannel()) {
            _Tracer.log(Level.DEBUG, this + " cannot add child port to channel:" + channelPort + "," + childPort);
            return;
        }
        int childIfindex = childPort.getIfIndex();
        if (childPort.getBase().isChild() && (oldParent = this.findEthPort(childPort.getBase().getChannelIfindex())) != null) {
            oldParent.removeChild(childIfindex);
        }
        channelPort.addChild(childIfindex);
        childPort.setChannelIfindex(channelPort.getIfIndex());
    }

    public void addChildPort(int channelIfindex, int childIfindex) {
        EthPortImpl channelPort = this.findEthPort(channelIfindex);
        EthPortImpl childPort = this.findEthPort(childIfindex);
        if (channelPort == null) {
            channelPort = DCManager.getInstance().createEthPort(this, channelIfindex);
            this.addEthPort(channelPort);
        }
        channelPort.setChannel(true);
        if (childPort == null) {
            childPort = DCManager.getInstance().createEthPort(this, childIfindex);
            this.addEthPort(childPort);
        }
        childPort.setChannel(false);
        this.addChildPort(channelPort, childPort);
    }

    public void removeChildPort(EthPortImpl channelPort, EthPortImpl childPort) {
        if (channelPort == null || childPort == null) {
            _Tracer.log(Level.DEBUG, this + " cannot remove child port to channel:" + channelPort + "," + childPort);
            return;
        }
        if (!channelPort.getBase().isChannel() || childPort.getBase().isChannel()) {
            _Tracer.log(Level.DEBUG, this + " cannot remove child port to channel:" + channelPort + "," + childPort);
            return;
        }
        int childIfindex = childPort.getIfIndex();
        channelPort.removeChild(childIfindex);
        childPort.getBase().resetChannelIfindex();
    }

    public void removeChildPort(int channelIfindex, int childIfindex) {
        EthPortImpl channelPort = this.findEthPort(channelIfindex);
        EthPortImpl childPort = this.findEthPort(childIfindex);
        if (channelPort == null || childPort == null) {
            return;
        }
        this.removeChildPort(channelPort, childPort);
    }

    public List<Integer> getChannelIfindexes() {
        ArrayList<Integer> channels = new ArrayList<Integer>(5);
        for (EthPortImpl ethport : this._ethPortsByIfindex.values()) {
            if (!ethport.getBase().isChannel()) continue;
            channels.add(ethport.getIfIndex());
        }
        return channels;
    }

    public List<EthPortImpl> getChannelEthPorts() {
        ArrayList<EthPortImpl> channelPorts = new ArrayList<EthPortImpl>(5);
        for (EthPortImpl ethport : this._ethPortsByIfindex.values()) {
            if (!ethport.getBase().isChannel()) continue;
            channelPorts.add(ethport);
        }
        return channelPorts;
    }

    public EthPortImpl findChannelPortByChild(int childIfindex) {
        EthPortImpl childPort = this.findEthPort(childIfindex);
        if (childPort == null) {
            return null;
        }
        int parentIfindex = childPort.getBase().getChannelIfindex();
        if (parentIfindex <= 0) {
            return null;
        }
        EthPortImpl channelPort = this.findEthPort(parentIfindex);
        if (channelPort == null || !channelPort.getBase().isChannel()) {
            _Tracer.log(Level.DEBUG, this + " cannot find channel port for " + childPort + "," + channelPort);
            return null;
        }
        return channelPort;
    }

    @Override
    public boolean isVdc() {
        return this._base.isVdcObject();
    }

    @Override
    public void setVdc(boolean isVdc) {
    }

    @Override
    public void setVdcFCoECapability(short capability) {
    }

    @Override
    public boolean isFCoEEnabled() {
        return this._base.isFcoeEnabled();
    }

    @Override
    public void setFCoEEnabled(boolean enabled) {
        if (this._base.isFcoeEnabled() == enabled) {
            return;
        }
        boolean[] oldValue = this._base.getFeatureFlags();
        this._base.setFeatureFlag(AbstractSwitchBase.Feature.FCOE, enabled);
        this.propertyChanged((short)1046, (Serializable)oldValue, (Serializable)this._base.getFeatureFlags());
        this.updateFCoECapable();
    }

    @Override
    public boolean isFCoECapableVersion() {
        return this._base.isFCoECapableVersion();
    }

    @Override
    public void setFCoEFeatureSetStatus(int status) {
        AbstractSwitchBase.FeatureStatus oldValue = this._base.getFCoFeatureSetStatus();
        if (oldValue == null || oldValue.value() != status) {
            this._base.setFCoEFeatureSetStatus(status);
            this.updateFCoECapable();
        }
    }

    public void updateFCoECapable() {
        boolean oldValue = this._base.isFCoECapable();
        boolean fcoeCapable = this._base.isFcoeEnabled();
        if (!fcoeCapable && (fcoeCapable = this._base.isFCoECapableVersion())) {
            if (this._base.isN7K()) {
                fcoeCapable = this._base.isVdc() ? this._base.hasFCoEInstalled() && ((VdcBase)this._base).isFCoEAllowed() && this.hasFCoECard() : false;
            } else if (!this._base.isNuovaFamily()) {
                if (this._base.isCAT()) {
                    fcoeCapable = false;
                } else if (this._base.isMDS()) {
                    boolean bl = fcoeCapable = this._base.hasFCoEInstalled() && this.hasFCoECard();
                }
            }
        }
        if (oldValue != fcoeCapable) {
            this._base.setFCoECapable(fcoeCapable);
            this.propertyChanged((short)1066, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isFCoECapable()));
        }
    }

    public void checkFCoECard() {
        boolean oldValue = this._hasFCoECard;
        List<Card> cards = InventoryManager.getInstance().findCards(this.getPK());
        if (cards == null) {
            this._hasFCoECard = false;
        } else {
            this._hasFCoECard = false;
            int[] cardTypes = new int[FRUConstants.getNumFrontSlots(this.getBase().getModelType())];
            for (int i = 0; i < cardTypes.length; ++i) {
                cardTypes[i] = 0;
            }
            for (Card card : cards) {
                int slot = card.getSlotId();
                if (slot > 0) {
                    --slot;
                }
                if (slot >= cardTypes.length) continue;
                cardTypes[slot] = card.getType();
                if (!FRUConstants.isFCoECapableCardType(card.getType())) continue;
                this._hasFCoECard = true;
            }
            this.setCardTypes(cardTypes);
        }
        if (oldValue != this._hasFCoECard) {
            this.updateFCoECapable();
        }
    }

    public void setCardTypes(int[] cardTypes) {
        boolean changed;
        if (cardTypes == null) {
            return;
        }
        int[] oldValue = this._base.getCardTypeInSlots();
        boolean bl = changed = oldValue == null || cardTypes.length != oldValue.length;
        if (!changed) {
            for (int i = 0; i < cardTypes.length; ++i) {
                if (oldValue[i] == cardTypes[i]) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this._base.setCardTypeInSlots(cardTypes);
            this.propertyChanged((short)1037, (Serializable)oldValue, (Serializable)this._base.getCardTypeInSlots());
        }
    }

    private boolean hasFCoECard() {
        return this._hasFCoECard;
    }

    protected boolean hasManageableSeed() {
        CdpSeedImpl seed = DCManager.getInstance().findTaskBySwPK(this.getSwitchPK());
        return seed != null && seed.isManageable();
    }

    @Override
    public boolean isFexEnabled() {
        return this._base.isFeatureEnabled(AbstractSwitchBase.Feature.FEX);
    }

    @Override
    public void setFexEnabled(boolean enabled) {
        if (this.isFexEnabled() == enabled) {
            return;
        }
        boolean[] oldValue = this._base.getFeatureFlags();
        this._base.setFeatureFlag(AbstractSwitchBase.Feature.FEX, enabled);
        this.propertyChanged((short)1046, (Serializable)oldValue, (Serializable)this._base.getFeatureFlags());
    }

    @Override
    public boolean isFexCapableVersion() {
        return this._base.isFexCapableVersion();
    }

    @Override
    public void setFexFeatureSetStatus(int status) {
        AbstractSwitchBase.FeatureStatus oldValue = this._base.getFexFeatureSetStatus();
        if (oldValue == null || oldValue.value() != status) {
            this._base.setFexFeatureSetStatus(status);
        }
    }

    public boolean addFex(FexImpl fex) {
        if (fex == null || this._base.containsFex(fex.getFexPK())) {
            return false;
        }
        this._base.addFex(fex.getFexPK());
        this._fexsByIfindex.put(fex.getBase().getFexId(), fex);
        return true;
    }

    public boolean removeFex(FexImpl fex) {
        if (fex == null || this._base.containsFex(fex.getFexPK())) {
            return false;
        }
        this._base.removeFex(fex.getFexPK());
        this._fexsByIfindex.remove(fex.getBase().getFexId(), fex);
        return true;
    }

    public void setFexes(List<FexImpl> fexList) {
        boolean changed;
        if (fexList == null) {
            return;
        }
        boolean bl = changed = fexList.size() != this._base.getNumOfFex();
        if (!changed) {
            for (FexImpl fex : fexList) {
                if (this._base.containsFex(fex.getFexPK())) continue;
                changed = true;
                break;
            }
        }
        if (!changed) {
            return;
        }
        this._base.clearFexes();
        this._fexsByIfindex.clear();
        for (FexImpl fex : fexList) {
            this._base.addFex(fex.getFexPK());
            this._fexsByIfindex.put(fex.getBase().getFexId(), fex);
        }
    }

    public void clearFexes() {
        this._base.clearFexes();
        this._fexsByIfindex.clear();
    }

    public List<FexImpl> getFexes() {
        return new ArrayList<FexImpl>(this._fexsByIfindex.values());
    }

    public int getNumFex() {
        return this.getBase().getNumOfFex();
    }

    public void updateFexId(int oldId, FexImpl fex) {
        this._fexsByIfindex.remove(oldId);
        this._fexsByIfindex.put(fex.getBase().getFexId(), fex);
    }

    public FexImpl findFexById(int fexId) {
        return this._fexsByIfindex.get(fexId);
    }

    public boolean containsFex(FexImpl fex) {
        return this._fexsByIfindex.values().contains(fex);
    }

    @Override
    public void setDiscFlag(int type) {
        this._discFlags |= type;
    }

    @Override
    public void resetDiscFlag(int type) {
        this._discFlags &= ~type;
    }

    @Override
    public boolean isDiscFlagSet(int type) {
        return (this._discFlags & type) != 0;
    }

    @Override
    public void setDiscFlags(int types) {
        this._discFlags = types;
    }

    public boolean hasDiscFlags() {
        return this._discFlags > 0;
    }

    public int getDiscFlags() {
        return this._discFlags;
    }

    @Override
    public String getDiscFlagsInString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if (!this.isDiscFlagSet(1 << i)) continue;
            sb.append(DISC_FLAGS[i]).append("|");
        }
        return sb.toString();
    }

    public void cleanCache() {
        this._ethPortsByIfindex.clear();
        this._fexsByIfindex.clear();
    }

    public int getSwitchDiscStatus() {
        return this._discStatus;
    }

    public void setSwitchDiscStatus(int status) {
        this._discStatus = status;
    }

    public String getSwitchDiscDescr() {
        return this._discDescr;
    }

    public void setSwitchDiscDescr(String descr) {
        this._discDescr = descr;
    }

    public long getLanSwitchClassId() {
        return this._lanswitchClassId;
    }

    public void setLanSwitchClassId(long classId) {
        this._lanswitchClassId = classId;
    }

    public void handleDisconnection() {
    }

    public void setCredential(SnmpUser user) throws SnmpException {
        if (user == null) {
            return;
        }
        if (!GenUtil.equals(this._credential, user)) {
            this._credential = user;
            if (this._peer != null) {
                SnmpPeer.removeServerPeer(this._peer, true);
                this._peer = null;
            }
            this.createAndSetPeer();
        }
    }

    public void setCredentialNoPeer(SnmpUser user) {
        if (user == null) {
            return;
        }
        if (!GenUtil.equals(this._credential, user)) {
            this._credential = user;
        }
    }

    public SnmpUser getCredential() {
        return this._credential;
    }

    public boolean isPeerCreated() {
        return this._peer != null;
    }

    @Override
    public synchronized SnmpPeer getPeer() {
        if (this._peer == null) {
            this.asyncCreateAndSetPeer();
        }
        return this._peer;
    }

    public SnmpPeer getPeerWithoutCreate() {
        return this._peer;
    }

    public synchronized void createAndSetPeer() {
        this.asyncCreateAndSetPeer();
    }

    protected SnmpPeer asyncCreatePeer(boolean usePrefer) throws SnmpException {
        InetAddress[] addrs = this._base.getManagementAddresses();
        SnmpPeer peer = null;
        if (addrs == null || addrs.length == 0) {
            throw new SnmpException("noMgmtAddr");
        }
        InetAddress[] sortedAddrs = new InetAddress[addrs.length];
        int v4Idx = 0;
        int v6Idx = addrs.length - 1;
        for (InetAddress addr : addrs) {
            if (addr instanceof Inet4Address) {
                sortedAddrs[v4Idx++] = addr;
                continue;
            }
            sortedAddrs[v6Idx--] = addr;
        }
        CdpSeedImpl seed = DCManager.getInstance().findTaskBySwPK(this.getSwitchPK());
        if (seed == null) {
            for (InetAddress addr : sortedAddrs) {
                seed = DCManager.getInstance().findTaskBySwIp(addr);
                if (seed != null) break;
            }
        }
        if (seed != null && this._credential == null) {
            this._credential = seed.getCredential();
        }
        if (this._credential == null) {
            throw new SnmpException("noMgmtUser");
        }
        for (InetAddress addr : sortedAddrs) {
            if (!IpUtil.isValidMgmtAddress(addr)) continue;
            try {
                peer = ServiceUtil.createSnmpPeer(addr, this._credential, DCManager.getInstance().getSnmpSession(), usePrefer);
                if (seed == null) break;
                peer.setTimeout(seed.getBase().getPeerTimeout());
                peer.setRetries(seed.getBase().getPeerRetries());
                break;
            }
            catch (Exception ex) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.DEBUG, addr + " cannot create peer with " + this._credential.getSecurityName(), ex);
            }
        }
        return peer;
    }

    protected SnmpPeer asyncCreatePeer() throws SnmpException {
        InetAddress[] addrs = this._base.getManagementAddresses();
        SnmpPeer peer = null;
        if (addrs == null || addrs.length == 0) {
            throw new SnmpException("noMgmtAddr");
        }
        InetAddress[] sortedAddrs = new InetAddress[addrs.length];
        int v4Idx = 0;
        int v6Idx = addrs.length - 1;
        for (InetAddress addr : addrs) {
            if (addr instanceof Inet4Address) {
                sortedAddrs[v4Idx++] = addr;
                continue;
            }
            sortedAddrs[v6Idx--] = addr;
        }
        CdpSeedImpl seed = DCManager.getInstance().findTaskBySwPK(this.getSwitchPK());
        if (seed == null) {
            for (InetAddress addr : sortedAddrs) {
                seed = DCManager.getInstance().findTaskBySwIp(addr);
                if (seed != null) break;
            }
        }
        if (seed != null && this._credential == null) {
            this._credential = seed.getCredential();
        }
        if (this._credential == null) {
            throw new SnmpException("noMgmtUser");
        }
        for (InetAddress addr : sortedAddrs) {
            if (!IpUtil.isValidMgmtAddress(addr)) continue;
            try {
                peer = ServiceUtil.createSnmpPeer(addr, this._credential, DCManager.getInstance().getSnmpSession(), SnmpSession._PreferTcp);
                if (seed == null) break;
                peer.setTimeout(seed.getBase().getPeerTimeout());
                peer.setRetries(seed.getBase().getPeerRetries());
                break;
            }
            catch (Exception ex) {
                if (!_Tracer.isDebuggable()) continue;
                _Tracer.log(Level.DEBUG, addr + " cannot create peer with " + this._credential.getSecurityName(), ex);
            }
        }
        return peer;
    }

    protected void asyncCreateAndSetPeer() {
        SnmpPeer newPeer = null;
        Exception err = null;
        try {
            newPeer = this.asyncCreatePeer();
        }
        catch (Exception ex) {
            err = ex;
        }
        SnmpPeer oldPeer = this._peer;
        if (oldPeer != null) {
            SnmpPeer.removeServerPeer(oldPeer, true);
        }
        if (newPeer != null) {
            this._peer = newPeer;
            this.setManagementAddressInUse(this._peer.getAddress());
            SnmpPeer.addServerPeer(newPeer);
        } else {
            this._peer = null;
            this.setManagementAddressInUse(null);
            this.setManageable(false, err == null ? "nonMgmtPeer" : err.getMessage());
        }
    }

    public void resetPeer() {
        if (this._peer != null) {
            SnmpPeer.removePeer(this._peer);
            SnmpPeer.removeServerPeer(this._peer, true);
            this._peer = null;
        }
    }

    @Override
    public boolean hasPeer() {
        return this._peer != null;
    }

    protected void testVPN() {
    }

    @Override
    public String toString() {
        return this.print(false, true);
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        LanImpl lan;
        SwitchLicenseDetails licDetails;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBase().dump(inDetail, level));
        if (!this._base.isCAT()) {
            StringBuilder fcoeSb = new StringBuilder();
            fcoeSb.append("FcoeCapable: ").append(this._base.isFCoECapable()).append(", VersionCapable=").append(this.isFCoECapableVersion()).append(", FeatureSetCapable=").append((Object)this._base.getFCoFeatureSetStatus()).append(", HasFcoeCard=").append(this.hasFCoECard()).append(", FcoeVdcAllowed=").append(!this.isVdc() || ((VdcImpl)this).getBase().isFCoEAllowed()).append(this.indent(level + 1));
            int pos = sb.indexOf("SysUpTime");
            if (pos > 0) {
                sb.insert(pos, fcoeSb.toString());
            } else {
                sb.append(fcoeSb.toString());
            }
        }
        if ((licDetails = this._base.getLicenseDetails()) != null) {
            sb.append(FabricImpl.LIL[level + 1]).append(licDetails.toString());
        }
        if (inDetail) {
            int[] ifindexes;
            sb.append(this.indent(level + 1)).append("Num of Ethernet Ports: ").append(this.getBase().getNumEthPorts());
            for (int ifindex : ifindexes = this.getIfindexes()) {
                EthPortImpl port = this._ethPortsByIfindex.get(ifindex);
                if (port == null) continue;
                sb.append(port.getBase().dump(true, level + 2));
            }
        }
        if ((lan = this.getLan()) != null) {
            sb.append(this.indent(level + 1)).append("LanPK=").append(lan.getPK());
            sb.append(this.indent(level + 1)).append(this._base.getNumVlans()).append(" VLANs discovered");
            if (this._base.getNumVlans() > 0) {
                sb.append(": ").append(this._base.getVlanIdsAsString());
            }
        }
        sb.append(this.indent(level + 1)).append("Discovery Flags: ").append(SwitchImpl.toDiscFlagString(this._discFlags));
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        return this.getBase().print(inDetail, withDecor) + (inDetail ? " DiscFlags:" + SwitchImpl.toDiscFlagString(this._discFlags) : "");
    }

    @Override
    public String getPrintString(boolean inDetail, boolean withDecor) {
        return this.getBase().print(inDetail, withDecor) + (inDetail ? " DiscFlags:" + SwitchImpl.toDiscFlagString(this._discFlags) : "");
    }

    public static String toDiscFlagString(int flags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if ((flags >> i & 1) == 0) continue;
            sb.append(DISC_FLAGS[i]).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void setDBID(long dbid) {
        super.setDBID(dbid);
        this.getLan().addEthSwitchDBID(this);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block5: {
            if (this.getBase() == null) {
                return;
            }
            stat = null;
            rs = null;
            try {
                stat = this.getCheckExistanceStatement(con);
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block5;
                this.setDBID(rs.getLong(1));
                if (!rs.getBoolean(2) || this.isDeepDisc()) break block5;
                this.setDeepDisc(true);
            }
            catch (Exception ex) {
                try {
                    _Tracer.log(Level.WARN, "Ethswitch checkPreexistRecord failed", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        PreparedStatement stat = null;
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public PreparedStatement getCheckExistanceStatement(Connection con) throws SQLException {
        return con.prepareStatement(QuerySQL_ByDeviceIdOrIp);
    }

    @Override
    public PreparedStatement getInsertStatement(Connection con) throws SQLException {
        return con.prepareStatement(EthSwitchImpl.getInsertSqlStr());
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection con) throws SQLException {
        return con.prepareStatement(EthSwitchImpl.getUpdateSqlStr());
    }

    @Override
    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        String deviceId = "Unknown";
        byte[] ipBytes = new byte[]{};
        if (this.getDeviceId() != null) {
            deviceId = this.getDeviceId();
        }
        if (this.getInetAddress() != null) {
            ipBytes = this.getInetAddress().getAddress();
        }
        stat.setString(1, deviceId);
        stat.setBytes(2, ipBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadLanSwitchClassIdFomDB(Connection con) throws SQLException {
        PreparedStatement queryClassIdStat;
        block13: {
            queryClassIdStat = null;
            ResultSet rs = null;
            try {
                if (this._base.isN1KV() || this._base.isN1K1()) {
                    queryClassIdStat = con.prepareStatement(QuerySQL_LanSwitchClassIdBySwitchIpVirtual);
                    queryClassIdStat.setString(1, this._base.getIpAddress());
                } else if (this instanceof VdcImpl || this._base.isN9K() || this._base.isN7K() || this._base.isN5K() || this._base.isN6K() || this._base.isN3K() || this._base.isN1K()) {
                    VdcImpl vdc = (VdcImpl)this;
                    MacAddress vdcMac = vdc.getBase().getVdcPK()._macAddr;
                    String macAddr = vdcMac.toString();
                    queryClassIdStat = con.prepareStatement(QuerySQL_LanSwitchClassIdBySwitchMac);
                    queryClassIdStat.setString(1, macAddr);
                } else {
                    queryClassIdStat = con.prepareStatement(QuerySQL_LanSwitchClassIdBySwitchSerial);
                    queryClassIdStat.setString(1, this._base.getSerialNumber());
                }
                rs = queryClassIdStat.executeQuery();
                while (rs.next()) {
                    try {
                        this.setLanSwitchClassId(rs.getLong(1));
                        break;
                    }
                    catch (Exception ex) {
                    }
                }
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                if (rs != null) {
                    DbUtil.close(rs);
                }
                DbUtil.close(queryClassIdStat);
                catch (Throwable throwable) {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    DbUtil.close(queryClassIdStat);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
        }
        DbUtil.close(queryClassIdStat);
    }

    @Override
    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null || this.getBase() == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setNull(i++, 4);
        if (this._base.getManagementAddressInUse() != null) {
            stat.setBytes(i++, this._base.getManagementAddressInUse().getAddress());
        } else if (this._base.getInetAddress() != null) {
            stat.setBytes(i++, this._base.getInetAddress().getAddress());
        } else {
            stat.setNull(i++, -2);
        }
        stat.setInt(i++, this._base.getModelType());
        stat.setBoolean(i++, this.isManageable());
        stat.setString(i++, this.getUnmanageableCause());
        stat.setInt(i++, this._base.getNumPorts());
        stat.setString(i++, this._base.getGlobalDeviceId());
        if (this._base.getDeviceId() != null) {
            stat.setString(i++, this._base.getDeviceId());
        } else {
            stat.setString(i++, this._base.getGlobalDeviceId());
        }
        stat.setNull(i++, -2);
        stat.setBytes(i++, this._base.getVtpMgmtDomain());
        stat.setString(i++, this._base.getVlanIdsAsString());
        stat.setString(i++, this._base.getSysName());
        stat.setString(i++, this._base.getSysContact());
        stat.setString(i++, this._base.getSysLocation());
        stat.setLong(i++, this._base.getSysLastBootTime());
        stat.setString(i++, this._base.getVersion());
        stat.setBoolean(i++, this.isPresent());
        String serialNum = this._base.getSerialNumber();
        if (serialNum.indexOf("n/a") >= 0) {
            stat.setString(i++, null);
        } else {
            stat.setString(i++, serialNum);
        }
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getLastScanTime());
        stat.setString(i++, this._base.getSysDescr());
        stat.setString(i++, this._base.getVendor());
        stat.setString(i++, this._base.getModelName());
        stat.setBoolean(i++, this.isVdc());
        if (this instanceof VdcImpl) {
            VdcImpl vdc = (VdcImpl)this;
            stat.setInt(i++, vdc.getBase().getVdcPK()._id);
            stat.setString(i++, vdc.getBase().getVdcPK()._macAddr.toString());
            stat.setString(i++, vdc.getBase().getVdcPK().getName());
            stat.setBytes(i++, vdc.getBase().getParentMacAddress().getBytes());
            stat.setNull(i++, 4);
            stat.setInt(i++, vdc.getBase().getFCoECapability());
        } else {
            stat.setNull(i++, 4);
            stat.setNull(i++, 12);
            stat.setNull(i++, 12);
            stat.setNull(i++, -2);
            stat.setNull(i++, 4);
            stat.setNull(i++, 4);
        }
        stat.setBoolean(i++, this._base.isFcoeEnabled());
        stat.setInt(i++, this._base.getSysCpuUsage());
        stat.setInt(i++, this._base.getSysMemoryUsage());
        stat.setBoolean(i++, this._base.isFex());
        if (this._base.isFex()) {
            stat.setInt(i++, ((FexBase)this._base).getFexId());
        } else {
            stat.setInt(i++, -1);
        }
        stat.setBoolean(i++, this._base.isFeatureEnabled(AbstractSwitchBase.Feature.FEX));
        stat.setInt(i++, this._discStatus);
        if (this._discDescr != null) {
            stat.setString(i++, this._discDescr);
        } else {
            stat.setNull(i++, 12);
        }
        stat.setLong(i++, this._lanswitchClassId);
        stat.setInt(i++, this._base.getNum1gPorts());
        stat.setInt(i++, this._base.getNum2gPorts());
        stat.setInt(i++, this._base.getNum4gPorts());
        stat.setInt(i++, this._base.getNum8gPorts());
        stat.setInt(i++, this._base.getNum10gPorts());
        stat.setInt(i++, this._base.getNum16gPorts());
        stat.setInt(i++, this._base.getNum40gPorts());
        stat.setInt(i++, this._base.getNum100gPorts());
        String sign = null;
        String licDetails = "";
        try {
            sign = this._base.getLicenseDetails() == null ? "" : this._base.getLicenseDetails().getSign();
            licDetails = FileLicensingHelper.processLicDetailStringForDB(this._base);
        }
        catch (Exception e) {
            _Tracer.log(Level.ERROR, "Unable to encrypt switch license details for DB, switch will show as unlicensed - " + this._base, e);
        }
        stat.setString(i++, sign);
        stat.setString(i++, licDetails);
        stat.setBoolean(i++, this._base.isFwsm());
        stat.setBoolean(i++, this.isDeepDisc());
        stat.setBoolean(i++, this._base.getLicenseDetails() == null ? false : this._base.getLicenseDetails().isLicensed());
        stat.setString(i++, this._base.getFeatureFlagsDB());
        stat.setString(i++, this._base.getPrimaryIp());
        stat.setString(i++, this._base.getSecondaryIp());
    }

    @Override
    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null || this.getBase() == null) {
            return;
        }
        int i = 1;
        stat.setNull(i++, 4);
        if (this._base.getManagementAddressInUse() != null) {
            stat.setBytes(i++, this._base.getManagementAddressInUse().getAddress());
        } else if (this._base.getInetAddress() != null) {
            stat.setBytes(i++, this._base.getInetAddress().getAddress());
        } else {
            stat.setNull(i++, -2);
        }
        stat.setInt(i++, this._base.getModelType());
        stat.setBoolean(i++, this.isManageable());
        stat.setString(i++, this.getUnmanageableCause());
        stat.setInt(i++, this._base.getNumPorts());
        stat.setString(i++, this._base.getGlobalDeviceId());
        if (this._base.getDeviceId() != null) {
            stat.setString(i++, this._base.getDeviceId());
        } else {
            stat.setString(i++, this._base.getGlobalDeviceId());
        }
        stat.setNull(i++, -2);
        stat.setBytes(i++, this._base.getVtpMgmtDomain());
        stat.setString(i++, this._base.getVlanIdsAsString());
        stat.setString(i++, this._base.getSysName());
        stat.setString(i++, this._base.getSysContact());
        stat.setString(i++, this._base.getSysLocation());
        stat.setLong(i++, this._base.getSysLastBootTime());
        stat.setString(i++, this._base.getVersion());
        stat.setBoolean(i++, this.isPresent());
        String serialNum = this._base.getSerialNumber();
        if (serialNum.indexOf("n/a") >= 0) {
            stat.setString(i++, null);
        } else {
            stat.setString(i++, serialNum);
        }
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getLastScanTime());
        stat.setString(i++, this._base.getSysDescr());
        stat.setString(i++, this._base.getVendor());
        stat.setString(i++, this._base.getModelName());
        stat.setBoolean(i++, this.isVdc());
        if (this instanceof VdcImpl) {
            VdcImpl vdc = (VdcImpl)this;
            stat.setInt(i++, vdc.getBase().getVdcPK()._id);
            stat.setString(i++, vdc.getBase().getVdcPK()._macAddr.toString());
            stat.setString(i++, vdc.getBase().getVdcPK().getName());
            stat.setBytes(i++, vdc.getBase().getParentMacAddress().getBytes());
            stat.setNull(i++, 4);
            stat.setInt(i++, vdc.getBase().getFCoECapability());
        } else {
            stat.setNull(i++, 4);
            stat.setNull(i++, 12);
            stat.setNull(i++, 12);
            stat.setNull(i++, -2);
            stat.setNull(i++, 4);
            stat.setNull(i++, 4);
        }
        stat.setBoolean(i++, this._base.isFcoeEnabled());
        stat.setInt(i++, this._base.getSysCpuUsage());
        stat.setInt(i++, this._base.getSysMemoryUsage());
        stat.setBoolean(i++, this._base.isFex());
        if (this._base.isFex()) {
            stat.setInt(i++, ((FexBase)this._base).getFexId());
        } else {
            stat.setInt(i++, -1);
        }
        stat.setBoolean(i++, this._base.isFeatureEnabled(AbstractSwitchBase.Feature.FEX));
        stat.setInt(i++, this._discStatus);
        if (this._discDescr != null) {
            stat.setString(i++, this._discDescr);
        } else {
            stat.setNull(i++, 12);
        }
        stat.setLong(i++, this._lanswitchClassId);
        stat.setInt(i++, this._base.getNum1gPorts());
        stat.setInt(i++, this._base.getNum2gPorts());
        stat.setInt(i++, this._base.getNum4gPorts());
        stat.setInt(i++, this._base.getNum8gPorts());
        stat.setInt(i++, this._base.getNum10gPorts());
        stat.setInt(i++, this._base.getNum16gPorts());
        stat.setInt(i++, this._base.getNum40gPorts());
        stat.setInt(i++, this._base.getNum100gPorts());
        String sign = null;
        String licDetails = "";
        try {
            sign = this._base.getLicenseDetails() == null ? "" : this._base.getLicenseDetails().getSign();
            licDetails = FileLicensingHelper.processLicDetailStringForDB(this._base);
        }
        catch (Exception e) {
            _Tracer.log(Level.ERROR, "Unable to encrypt switch license details for DB, switch will show as unlicensed - " + this._base, e);
        }
        stat.setString(i++, sign);
        stat.setString(i++, licDetails);
        stat.setBoolean(i++, this._base.isFwsm());
        stat.setBoolean(i++, this.isDeepDisc());
        stat.setBoolean(i++, this._base.getLicenseDetails() == null ? false : this._base.getLicenseDetails().isLicensed());
        stat.setString(i++, this._base.getFeatureFlagsDB());
        stat.setString(i++, this._base.getPrimaryIp());
        stat.setString(i++, this._base.getSecondaryIp());
        stat.setLong(i++, this.getDBID());
    }

    @Override
    public void flushed() {
        this.getBase().setFlushed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(LanImpl lan) throws SQLException {
        ArrayList<EthSwitchImpl> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement queryStat = null;
        PreparedStatement queryAddrStat = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            queryStat = con.prepareStatement(QuerySQL_ByLanDBID);
            queryStat.setLong(1, lan.getDBID());
            rs1 = queryStat.executeQuery();
            ArrayList<EthSwitchImpl> list = EthSwitchImpl.loadDBRecord(rs1, lan);
            queryAddrStat = con.prepareStatement(QuerySQL_MgmtAddrBySwitchDBID);
            for (EthSwitchImpl ethSw : list) {
                ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
                queryAddrStat.setLong(1, ethSw.getDBID());
                try {
                    rs2 = queryAddrStat.executeQuery();
                    while (rs2.next()) {
                        try {
                            InetAddress ip = InetAddress.getByAddress(rs2.getBytes(1));
                            ips.add(ip);
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    if (rs2 != null) {
                        DbUtil.close(rs2);
                    }
                }
                if (ips.size() > 0) {
                    InetAddress[] addrs = new InetAddress[ips.size()];
                    for (int j = 0; j < ips.size(); ++j) {
                        addrs[j] = (InetAddress)ips.get(j);
                    }
                    ethSw.setManagementAddresses(addrs, false);
                }
                EthSwitchImpl.loadAssocVlansFromDB(ethSw);
                if (!ethSw.getBase().isFex()) {
                    EthSwitchImpl.loadAssocFexesFromDB(ethSw);
                }
                lan.addEthSwitch(ethSw, false);
            }
            arrayList = list;
        }
        catch (Exception ex) {
            ArrayList arrayList2;
            try {
                _Tracer.log(Level.WARN, lan + " load ethswitch from DB failed", ex);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs1);
                DbUtil.close(queryStat);
                DbUtil.close(queryAddrStat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs1);
            DbUtil.close(queryStat);
            DbUtil.close(queryAddrStat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs1);
        DbUtil.close(queryStat);
        DbUtil.close(queryAddrStat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<EthSwitchImpl> loadDBRecord(ResultSet rs, LanImpl lan) throws SQLException {
        ArrayList<EthSwitchImpl> list = new ArrayList<EthSwitchImpl>();
        while (rs.next()) {
            InetAddress swIp = null;
            try {
                byte[] b = rs.getBytes(3);
                if (b != null) {
                    swIp = InetAddress.getByAddress(b);
                }
            }
            catch (UnknownHostException ex) {
                _Tracer.log(Level.DEBUG, " EthSwitchImpl load ethsw ip failed", ex);
            }
            EthSwitchImpl ethSw = null;
            SerialNumKey chassisKey = null;
            String serialNum = rs.getString(19);
            String deviceId = rs.getString(9);
            if (serialNum != null && serialNum.indexOf("n/a") < 0) {
                chassisKey = new SerialNumKey(serialNum);
            } else if (swIp != null) {
                chassisKey = new SerialNumKey(swIp.getHostAddress());
            } else {
                if (deviceId == null) continue;
                chassisKey = new SerialNumKey(deviceId);
            }
            boolean isVdc = rs.getBoolean(25);
            boolean isFex = rs.getBoolean(35);
            String sysName = rs.getString(13);
            if (isVdc) {
                int vdcId = rs.getInt(26);
                String vdcMacStr = rs.getString(27);
                if (vdcMacStr == null) continue;
                MacAddress vdcMac = new MacAddress(vdcMacStr);
                String vdcName = rs.getString(28);
                MacAddress defaultVdcMac = new MacAddress(rs.getBytes(29));
                int vdcFCoeCapability = rs.getInt(31);
                VdcPK vdcKey = new VdcPK(chassisKey, vdcMac, vdcId);
                vdcKey.setName(vdcName);
                ethSw = DCManager.getInstance().createEthSwitch(lan, vdcKey, sysName, swIp);
                ((VdcImpl)ethSw).setParentMacAddress(defaultVdcMac);
                ((VdcImpl)ethSw).setVdcFCoECapability((short)vdcFCoeCapability);
            } else if (isFex) {
                int fexId = rs.getInt(36);
                ethSw = DCManager.getInstance().createFex(lan, chassisKey, fexId);
            } else {
                ethSw = DCManager.getInstance().createEthSwitch(lan, chassisKey, sysName, swIp);
            }
            if (ethSw == null) continue;
            ethSw.setDBID(rs.getLong(1));
            ethSw._base.setModelType(rs.getInt(4));
            ethSw._base.setManageable(rs.getBoolean(5));
            ethSw._base.setUnmanageableCause(rs.getString(6));
            ethSw._base.setNumEthPorts(rs.getInt(7));
            ethSw._base.setGlobalDeviceId(rs.getString(8));
            ethSw._base.setDeviceId(deviceId);
            ethSw._base.setVtpMgmtDomain(rs.getBytes(11));
            ethSw._base.setSysName(sysName);
            if (ethSw instanceof FexImpl) {
                ((FexImpl)ethSw).setName(sysName);
            }
            ethSw._base.setSysContact(rs.getString(14));
            ethSw._base.setSysLocation(rs.getString(15));
            ethSw._base.setSysLastBootTime(rs.getLong(16));
            ethSw._base.setVersion(rs.getString(17));
            ethSw._base.setPresent(rs.getBoolean(18));
            ethSw._base.setLastScanTime(rs.getLong(21));
            ethSw._base.setSysDescr(rs.getString(22));
            ethSw._base.setVendor(rs.getString(23));
            ethSw._base.setModelName(rs.getString(24));
            PlatformType platform = PlatformType.getTypeByDeviceKey(rs.getString(24));
            if (platform != PlatformType.UNKNOWN) {
                ethSw.setPlatformType(platform);
            }
            ethSw.setFCoEEnabled(rs.getBoolean(32));
            ethSw._base.setSysCpuUsage(rs.getInt(33));
            ethSw._base.setSysMemoryUsage(rs.getInt(34));
            ethSw.setFexEnabled(rs.getBoolean(37));
            ethSw.setSwitchDiscStatus(rs.getInt(38));
            ethSw.setSwitchDiscDescr(rs.getString(39));
            ethSw.setLanSwitchClassId(rs.getInt(40));
            ethSw.setNum1gPorts(rs.getInt(41));
            ethSw.setNum2gPorts(rs.getInt(42));
            ethSw.setNum4gPorts(rs.getInt(43));
            ethSw.setNum8gPorts(rs.getInt(44));
            ethSw.setNum10gPorts(rs.getInt(45));
            ethSw.setNum16gPorts(rs.getInt(46));
            ethSw.setNum40gPorts(rs.getInt(47));
            ethSw.setNum100gPorts(rs.getInt(48));
            FileLicensingHelper.handleLicenseDecodingFromDBValue(ethSw._base, rs.getString(49), rs.getString(50));
            ethSw.setFwsm(rs.getBoolean(51));
            ethSw.setDeepDisc(rs.getBoolean(52));
            ethSw._base.setFeatureFlagsDB(rs.getString(53));
            ethSw._base.setPrimaryIp(rs.getString(54));
            ethSw._base.setSecondaryIp(rs.getString(55));
            list.add(ethSw);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EthSwitchImpl querySwitchByDbId(LanImpl lan, long dbId) throws SQLException {
        ResultSet rs2;
        PreparedStatement queryAddrStat;
        ResultSet rs1;
        PreparedStatement queryStat;
        Connection con;
        block11: {
            EthSwitchImpl ethSwitchImpl;
            ArrayList<EthSwitchImpl> list;
            block12: {
                con = ConnectionManager.getConnection();
                queryStat = null;
                rs1 = null;
                queryAddrStat = null;
                rs2 = null;
                queryStat = con.prepareStatement(QuerySQL_ByDBID);
                queryStat.setLong(1, dbId);
                rs1 = queryStat.executeQuery();
                if (!rs1.next()) break block11;
                list = EthSwitchImpl.loadDBRecord(rs1, lan);
                if (list != null && list.size() != 0) break block12;
                EthSwitchImpl ethSwitchImpl2 = null;
                DbUtil.close(rs1);
                DbUtil.close(rs2);
                DbUtil.close(queryStat);
                DbUtil.close(queryAddrStat);
                DbUtil.close(con);
                return ethSwitchImpl2;
            }
            try {
                EthSwitchImpl ethSw = (EthSwitchImpl)list.get(0);
                queryAddrStat = con.prepareStatement(QuerySQL_MgmtAddrBySwitchDBID);
                queryAddrStat.setLong(1, ethSw.getDBID());
                rs2 = queryAddrStat.executeQuery();
                ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
                while (rs2.next()) {
                    try {
                        InetAddress ip1 = InetAddress.getByAddress(rs2.getBytes(1));
                        ips.add(ip1);
                    }
                    catch (Exception ex) {}
                }
                if (ips.size() > 0) {
                    InetAddress[] addrs = new InetAddress[ips.size()];
                    for (int j = 0; j < ips.size(); ++j) {
                        addrs[j] = (InetAddress)ips.get(j);
                    }
                    ethSw.setManagementAddresses(addrs, false);
                }
                EthSwitchImpl.loadAssocVlansFromDB(ethSw);
                if (!ethSw.getBase().isFex()) {
                    EthSwitchImpl.loadAssocFexesFromDB(ethSw);
                }
                lan.addEthSwitch(ethSw, false);
                ethSwitchImpl = ethSw;
            }
            catch (Exception ex) {
                try {
                    _Tracer.log(Level.WARN, lan + " querySwitchByDbId failed:" + dbId, ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs1);
                    DbUtil.close(rs2);
                    DbUtil.close(queryStat);
                    DbUtil.close(queryAddrStat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs1);
                DbUtil.close(rs2);
                DbUtil.close(queryStat);
                DbUtil.close(queryAddrStat);
                DbUtil.close(con);
            }
            DbUtil.close(rs1);
            DbUtil.close(rs2);
            DbUtil.close(queryStat);
            DbUtil.close(queryAddrStat);
            DbUtil.close(con);
            return ethSwitchImpl;
        }
        DbUtil.close(rs1);
        DbUtil.close(rs2);
        DbUtil.close(queryStat);
        DbUtil.close(queryAddrStat);
        DbUtil.close(con);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadAssocVlansFromDB(EthSwitchImpl ethSw) throws SQLException {
        Object i$;
        if (ethSw == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<Short> vlanIds = new ArrayList<Short>();
        LanImpl lan = ethSw.getLan();
        try {
            VlanImpl vlan;
            stat = con.prepareStatement(QueryVlanSQL_VlanDBIDBySwitchDBID);
            stat.setLong(1, ethSw.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                long vlanDBID = rs.getLong(1);
                vlan = lan.findVlanByDBID(vlanDBID);
                if (vlan == null) continue;
                vlanIds.add(vlan.getVlanPK()._id);
            }
            ethSw._base.setVlans(vlanIds);
            i$ = vlanIds.iterator();
            while (i$.hasNext()) {
                short vid = i$.next();
                vlan = lan.findVlanById(vid);
                if (vlan == null) continue;
                vlan.addSwitch(ethSw);
            }
            i$ = vlanIds;
        }
        catch (Exception ex) {
            ArrayList arrayList;
            try {
                _Tracer.log(Level.WARN, ethSw + " loadAssocVlansFromDB failed", ex);
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return i$;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FexImpl> loadAssocFexesFromDB(EthSwitchImpl ethSw) throws SQLException {
        ArrayList<FexImpl> fexDBID2;
        if (ethSw == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<FexImpl> fexList = new ArrayList<FexImpl>();
        LanImpl lan = ethSw.getLan();
        try {
            stat = con.prepareStatement(QueryFexSQL_FexDBIDBySwitchDBID);
            stat.setLong(1, ethSw.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                long fexDBID2 = rs.getLong(1);
                FexImpl fex = (FexImpl)lan.findEthSwitchByDBID(fexDBID2);
                if (fex == null) continue;
                fexList.add(fex);
            }
            ethSw.setFexes(fexList);
            fexDBID2 = fexList;
        }
        catch (Exception ex) {
            ArrayList<FexImpl> arrayList;
            try {
                _Tracer.log(Level.WARN, ethSw + " loadAssocFexesFromDB failed", ex);
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fexDBID2;
    }

    public void addVpcEndPoint(VpcEndPoint vpcEndPoint) {
        this._vpcEndPoints.put(vpcEndPoint.getVpcID(), vpcEndPoint);
    }

    public void removeVpcEndPoint(VpcEndPoint vpcEndPoint) {
        this._vpcEndPoints.remove(vpcEndPoint);
    }

    public ConcurrentHashMap<Integer, VpcEndPoint> getVpcEndPoints() {
        return this._vpcEndPoints;
    }

    public VpcEndPoint getVpcEndPoint(int vpcId) {
        return this._vpcEndPoints.get(vpcId);
    }
}

