/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GlobalFabricManager
implements ModelEventListenerIf {
    private static GlobalFabricManager _Instance = null;
    private static Logger _Logger = LogManager.getLogger((String)"fms.model");
    static final String SQL_Query_AllFabricPKs = "select fid, name,id from fabric";
    static final String SQL_Query_AllDisplayFabricPKs = "select f.fid, f.name, f.id, s.ip_address, u.user_name from fabric f, switch s, snmpuser u where f.seed_switch_id=s.id AND f.fmuser_id = u.id AND s.ip_address IS NOT NULL AND u.user_name IS NOT NULL";
    static final String SQL_Query_AllNonEmptyFabricPKs = "select f.fid, f.name from fabric f where f.id in (select distinct fabric_id from switch)";
    static final String SQL_Query_AllNonEmptyFabricScopeVsans = "select f.fid, f.vsans_included, f.vsans_excluded  from fabric f where f.id in (select distinct fabric_id from switch)";
    static final String SQL_Query_SnmpUserByFabricId = "select fabric.fid, snmpuser.id, snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name, snmpuser.is_logging_in, snmpuser.last_update_time from fabric, snmpuser where snmpuser.id=fabric.fmuser_id and fabric.fid=? ";
    static final String SQL_Set_FabricManangedByFabricId = "update fabric set is_manageable=? where fid=?";
    static final String SQL_Query_SWWWN_ByIPAddress = "select wwn from switch where ip_address=?";
    static final String SQL_Query_SID_ByIPAddress = "select id from switch where ip_address=?";
    static final String SQL_Init_FabricManangedByFabricId = "update fabric set is_manageable=? where fabric.fid in  (select F_ID from LOGICSVR_FABRIC where LSVR_ID=? ) ";
    static final String SQL_Query_FabricManagedByFabricId = "select is_manageable, license_id from fabric where fid=?";
    static final String SQL_Query_PooledIntervalByFabricId = "select polling_interval, on_demand_poll_freq, is_persistent from fabric where fid=?";
    static final String SQL_Query_seedip_ById = "select sw.IP_ADDRESS from switch sw, fabric f where f.seed_switch_id = sw.id and f.fid=?";
    static final String SQL_Query_duplicated_switches = "select f.fid, sw.wwn, sw.ip_address from fabric f, switch sw where sw.wwn in (select sw.wwn from switch sw group by sw.wwn having count(*) > 1) and f.id=sw.fabric_id";
    static final String SQL_Query_FabricPK_BySwPK = "SELECT sw.wwn, f.fid FROM Fabric f, Switch sw WHERE sw.fabric_id=f.id";
    static final String SQL_Query_FabricPK_BySnmpUserId = "select f.fid, f.name, f.id  from fabric f, snmpuser s where s.id=? and s.id=f.fmuser_id";
    static final String SQL_Query_Npv_Switches = "select sw.wwn from switch sw where sw.id in (select np_switch_id from npv_link)";
    static final String SQL_Query_fid_ByIp = "select f.fid, f.name  from fabric f, switch s where s.ip_address=? and f.id=s.fabric_id";
    static final String SQL_Query_fid_ByIpVsans = "select f.fid, f.name  from fabric f, switch s where s.ip_address=? and f.vsans_included=? and f.vsans_excluded=? and f.id=s.fabric_id";
    static final String SQL_Query_fnanme_ById = "select f.name  from fabric f where  f.fid=?";
    static final String SQL_Query_fnanme_ByFDBId = "select f.name  from fabric f where  f.id=?";
    static final String SQL_Query_SwitchIPAddressForSwDBID = "select sw.ip_address from switch sw where sw.id = ?";

    public static GlobalFabricManager getInstance() {
        if (_Instance == null) {
            _Instance = new GlobalFabricManager();
        }
        return _Instance;
    }

    private GlobalFabricManager() {
        SanManager.getInstance();
        SanManager.addListener(this);
        this.grabIdleFabrics();
        this.initFabricManageable();
    }

    void grabIdleFabrics() {
        List<FabricPK> list = this.getAllFabricPKs();
        try {
            for (FabricPK fpk : list) {
                int fid = fpk.get_fid();
                List<Integer> sIds = ClusterMapping.getInstance().qSIdsFromFId(fid);
                if (sIds != null && sIds.size() != 0) continue;
                ClusterMapping.getInstance().persistLOGIC(Sequence.getSequence().getServerId(), fid);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIpAddressOfSwitch(long swDBID) {
        String ipAddress;
        block6: {
            ipAddress = null;
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_SwitchIPAddressForSwDBID);
                stat.setLong(1, swDBID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    byte[] ipByte = rs.getBytes(1);
                    if (ipByte == null) continue;
                    ipAddress = SnmpIpAddress.toString(ipByte);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"GlobalFabricManager->getIpAddressOfSwitch(): caught exception", (Throwable)e);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpUser getUserByFabricPK(FabricPK fabricPK) {
        block9: {
            CommunityUser version2;
            if (fabricPK == null) {
                return null;
            }
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            SnmpUser user = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_SnmpUserByFabricId);
                stat.setInt(1, fabricPK._fid);
                rs = stat.executeQuery();
                if (rs.next()) {
                    int version2 = rs.getInt(3);
                    if (version2 == 3) {
                        String privPass = rs.getString(6);
                        user = new UsmUser(StringEncrypter.decryptString("DES", rs.getString(4)), rs.getInt(7), StringEncrypter.decryptString("DES", rs.getString(5)), rs.getInt(8), privPass == null ? privPass : StringEncrypter.decryptString("DES", privPass));
                    } else {
                        user = new CommunityUser(StringEncrypter.decryptString("DES", rs.getString(4)), version2);
                    }
                    user.setRoleName(rs.getString(10));
                }
                version2 = user;
                DbUtil.close(rs);
            }
            catch (Exception e) {
                _Logger.warn((Object)"GlobalFabricManager->getUserByFabricPK(): caught exception", (Throwable)e);
                break block9;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return version2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FabricPK> getAllFabricPKs() {
        ArrayList<FabricPK> fabricPKs = new ArrayList<FabricPK>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_AllFabricPKs);
            rs = stat.executeQuery();
            while (rs.next()) {
                FabricPK fpk = new FabricPK((int)rs.getLong(1));
                fpk.setName(rs.getString(2));
                fpk.id = rs.getLong(3);
                fabricPKs.add(fpk);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllFabricPKs(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getAllFabricPKSet() {
        HashSet<Integer> fabricIDs = new HashSet<Integer>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_AllFabricPKs);
            rs = stat.executeQuery();
            while (rs.next()) {
                fabricIDs.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllFabricPKs(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FabricPK> getAllNonEmptyFabricPKs() {
        ArrayList<FabricPK> fabricPKs = new ArrayList<FabricPK>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_AllNonEmptyFabricPKs);
            rs = stat.executeQuery();
            while (rs.next()) {
                FabricPK fpk = new FabricPK((int)rs.getLong(1));
                fpk.setName(rs.getString(2));
                fabricPKs.add(fpk);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllFabricPKs(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FabricPK> getAllDisplayFabricPKs() {
        ArrayList<FabricPK> fabricPKs = new ArrayList<FabricPK>();
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_AllDisplayFabricPKs);
            rs = stat.executeQuery();
            while (rs.next()) {
                FabricPK fpk = new FabricPK((int)rs.getLong(1));
                fpk.setName(rs.getString(2));
                fpk.id = rs.getLong(3);
                fabricPKs.add(fpk);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllDisplayFabricPKs(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<WwnKey, Set<FabricPK>> getAllDuplicatedSwitches() {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        HashMap<WwnKey, Set<FabricPK>> fabricsByswwn = new HashMap<WwnKey, Set<FabricPK>>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_duplicated_switches);
            rs = stat.executeQuery();
            while (rs.next()) {
                FabricPK fpk = new FabricPK((int)rs.getLong(1));
                Wwn wwn = null;
                try {
                    wwn = new Wwn(rs.getBytes(2));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("GlobalFabricManager->getAllDuplicatedSwitches(): fabricPK=" + fpk + " wwn=" + wwn));
                }
                if (wwn == null) continue;
                InetAddress ip = null;
                try {
                    byte[] b = rs.getBytes(3);
                    if (b != null) {
                        ip = InetAddress.getByAddress(b);
                    }
                }
                catch (UnknownHostException ex) {
                    _Logger.debug((Object)"GlobalFabricManager->getAllDuplicatedSwitches(): caught exception in switch ip", (Throwable)ex);
                }
                Set<FabricPK> fabricPKs = fabricsByswwn.get(new WwnKey(wwn));
                if (fabricPKs == null) {
                    fabricPKs = new HashSet<FabricPK>();
                }
                fabricPKs.add(fpk);
                fabricsByswwn.put(new WwnKey(wwn), fabricPKs);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllDuplicatedSwitches(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricsByswwn;
    }

    public Map<WwnKey, Set<FabricPK>> getFabricPKsBySwitchPKs(List<WwnKey> swPKs) throws SQLException {
        if (swPKs == null || swPKs.size() == 0) {
            return Collections.emptyMap();
        }
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        HashMap<Wwn, WwnKey> wwnMap = new HashMap<Wwn, WwnKey>();
        HashMap<WwnKey, Set<FabricPK>> fabricsByswwn = new HashMap<WwnKey, Set<FabricPK>>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_FabricPK_BySwPK);
            rs = stat.executeQuery();
            while (rs.next()) {
                Wwn wwn = null;
                try {
                    wwn = new Wwn(rs.getBytes(1));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (wwn == null) continue;
                WwnKey key = (WwnKey)wwnMap.get(wwn);
                if (key == null) {
                    key = new WwnKey(wwn);
                    wwnMap.put(wwn, key);
                }
                FabricPK fpk = new FabricPK((int)rs.getLong(2));
                HashSet<FabricPK> fabricPKs = (HashSet<FabricPK>)fabricsByswwn.get(key);
                if (fabricPKs == null) {
                    fabricPKs = new HashSet<FabricPK>();
                    fabricsByswwn.put(key, fabricPKs);
                }
                fabricPKs.add(fpk);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getFabricPKsBySwitchPKs(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricsByswwn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FabricPK> getFabricPKsBySnmpUserId(long snmpuserId) {
        ArrayList<FabricPK> fabricPKs;
        block6: {
            fabricPKs = new ArrayList<FabricPK>();
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_FabricPK_BySnmpUserId);
                stat.setLong(1, snmpuserId);
                rs = stat.executeQuery();
                while (rs.next()) {
                    FabricPK fpk = new FabricPK((int)rs.getLong(1));
                    fpk.setName(rs.getString(2));
                    fpk.id = rs.getLong(3);
                    fabricPKs.add(fpk);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"GlobalFabricManager->getFabricPKsBySnmpUserId(): caught exception", (Throwable)e);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return fabricPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<WwnKey> getAllNpvSwPKs() {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        HashSet<WwnKey> npvSwPKs = new HashSet<WwnKey>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_Npv_Switches);
            rs = stat.executeQuery();
            while (rs.next()) {
                WwnKey wwn = null;
                try {
                    wwn = new WwnKey(new Wwn(rs.getBytes(1)));
                    if (wwn == null) continue;
                    npvSwPKs.add(wwn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getAllNpvSwPKs(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return npvSwPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getInExVsans(FabricPK[] fpks) {
        if (fpks == null || fpks.length == 0) {
            return new String[0][0];
        }
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        String[][] results = new String[fpks.length][2];
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_AllNonEmptyFabricScopeVsans);
            rs = stat.executeQuery();
            while (rs.next()) {
                int fid = (int)rs.getLong(1);
                String inVsans = rs.getString(2);
                String exVsans = rs.getString(3);
                for (int i = 0; i < fpks.length; ++i) {
                    if (fid != fpks[i].get_fid()) continue;
                    results[i][0] = inVsans == null || inVsans.equals("-1") ? null : inVsans;
                    results[i][1] = exVsans == null || exVsans.equals("-1") ? null : exVsans;
                }
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getInExVsans(): caught exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFabricManageable(FabricPK fabricPK, boolean manageable) {
        PreparedStatement fabricUpdate;
        Connection con;
        block4: {
            con = null;
            fabricUpdate = null;
            try {
                con = ConnectionManager.getConnection();
                fabricUpdate = con.prepareStatement(SQL_Set_FabricManangedByFabricId);
                fabricUpdate.setBoolean(1, manageable);
                fabricUpdate.setLong(2, fabricPK._fid);
                fabricUpdate.execute();
                if (!manageable) break block4;
                ClusterMapping.getInstance().persistLOGIC(Sequence.getSequence().getServerId(), fabricPK.get_fid());
            }
            catch (Exception e) {
                try {
                    _Logger.warn((Object)("Cannot set fabric managed:" + fabricPK + ", isManageable=" + manageable), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(fabricUpdate);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(fabricUpdate);
                DbUtil.close(con);
            }
        }
        DbUtil.close(fabricUpdate);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFabricManageable(FabricPK fabricPK) {
        Connection con = null;
        PreparedStatement fabricUpdate = null;
        try {
            con = ConnectionManager.getConnection();
            fabricUpdate = con.prepareStatement(SQL_Set_FabricManangedByFabricId);
            fabricUpdate.setBoolean(1, true);
            fabricUpdate.setLong(2, fabricPK._fid);
            fabricUpdate.execute();
        }
        catch (Exception e) {
            try {
                _Logger.warn((Object)("Cannot set fabric managed:" + fabricPK + ", isManageable=" + true), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(fabricUpdate);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(fabricUpdate);
            DbUtil.close(con);
        }
        DbUtil.close(fabricUpdate);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFabricManageable() {
        Connection con = null;
        PreparedStatement fabricUpdate = null;
        int rowAffected = 0;
        try {
            con = ConnectionManager.getConnection();
            fabricUpdate = con.prepareStatement(SQL_Init_FabricManangedByFabricId);
            fabricUpdate.setBoolean(1, false);
            fabricUpdate.setInt(2, Sequence.getSequence().getServerId());
            rowAffected = fabricUpdate.executeUpdate();
        }
        catch (Exception e) {
            try {
                _Logger.warn((Object)"Cannot set fabric managed isManageable=false", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(fabricUpdate);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(fabricUpdate);
            DbUtil.close(con);
        }
        DbUtil.close(fabricUpdate);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFabricManageable(FabricPK fabricPK) {
        boolean manageable;
        block7: {
            if (fabricPK == null) {
                return false;
            }
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            manageable = false;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_FabricManagedByFabricId);
                stat.setInt(1, fabricPK._fid);
                rs = stat.executeQuery();
                if (rs.next()) {
                    manageable = rs.getBoolean(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception e) {
                _Logger.warn((Object)"GlobalFabricManager->getUserByFabricPK(): caught exception", (Throwable)e);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return manageable;
    }

    public boolean isFabricPersistent(FabricPK fabricPK) throws SQLException {
        boolean ret = false;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_PooledIntervalByFabricId);
            stat.setInt(1, fabricPK._fid);
            rs = stat.executeQuery();
            if (!rs.next()) {
                throw new SQLException("can not find Fabirc for:" + fabricPK);
            }
            ret = rs.getBoolean(3);
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getFabricRediscoverInterval(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public int getFabricRediscoverInterval(FabricPK fabricPK) throws SQLException {
        int ret = 0;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_PooledIntervalByFabricId);
            stat.setInt(1, fabricPK._fid);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = rs.getInt(2);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getFabricRediscoverInterval(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        if (ret == 0) {
            throw new SQLException("can not find rediscoverinterval for:" + fabricPK);
        }
        return ret;
    }

    public FabricPK findFabricPK(InetAddress inetAddr) throws SQLException {
        List<FabricPK> list = this.findFabricPKs(inetAddr);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public Wwn findSwitchWwn(InetAddress inetAddr) throws SQLException {
        Wwn ret = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_SWWWN_ByIPAddress);
            stat.setBytes(1, inetAddr.getAddress());
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = new Wwn(rs.getBytes(1));
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->findSwitchWwn(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public long findSwitchId(InetAddress inetAddr) throws SQLException {
        long ret = -1L;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_SID_ByIPAddress);
            stat.setBytes(1, inetAddr.getAddress());
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->findSwitchId(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public List<FabricPK> findFabricPKs(InetAddress inetAddr) throws SQLException {
        FabricPK fpk = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        ArrayList<FabricPK> list = new ArrayList<FabricPK>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_fid_ByIp);
            stat.setBytes(1, inetAddr.getAddress());
            rs = stat.executeQuery();
            if (rs.next()) {
                fpk = new FabricPK(rs.getInt(1));
                fpk.setName(rs.getString(2));
                list.add(fpk);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->findFabricPK(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return list;
    }

    public FabricPK findFabricPK(InetAddress inetAddr, String inVsans, String exVsans) throws SQLException {
        FabricPK ret = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_fid_ByIpVsans);
            stat.setBytes(1, inetAddr.getAddress());
            stat.setString(2, inVsans == null ? "-1" : inVsans);
            stat.setString(3, exVsans == null ? "-1" : exVsans);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = new FabricPK(rs.getInt(1));
                ret.setName(rs.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->findFabricPK(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress getSeedSwitchAddress(FabricPK fpk) throws Exception {
        InetAddress ret = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_seedip_ById);
            stat.setInt(1, fpk._fid);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = InetAddress.getByAddress(rs.getBytes(1));
            }
        }
        catch (UnknownHostException ex) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getSeedSwitchAddress(): caught exception", (Throwable)ex);
                throw ex;
                catch (SQLException e) {
                    _Logger.warn((Object)"GlobalFabricManager->getSeedSwitchAddress(): caught exception", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public String getFabricName(FabricPK fpk) throws SQLException {
        String ret = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_fnanme_ById);
            stat.setInt(1, fpk._fid);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->findFabricPK(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public String getFabricNameFromDBID(long fDbID) throws SQLException {
        String ret = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_fnanme_ByFDBId);
            stat.setLong(1, fDbID);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getFabricNameFromDBID(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return ret;
    }

    public int getFabricPollingInterval(FabricPK fabricPK) throws SQLException {
        int ret = 0;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(SQL_Query_PooledIntervalByFabricId);
            stat.setInt(1, fabricPK._fid);
            rs = stat.executeQuery();
            if (rs.next()) {
                ret = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"GlobalFabricManager->getFabricPollingInterval(): caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        if (ret == 0) {
            throw new SQLException("can not find polling interval for:" + fabricPK);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFabricLicenseId(FabricPK fabricPK) {
        int ret;
        block6: {
            ret = 0;
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(SQL_Query_FabricManagedByFabricId);
                stat.setInt(1, fabricPK._fid);
                rs = stat.executeQuery();
                if (rs.next()) {
                    ret = rs.getInt(2);
                }
                DbUtil.close(rs);
            }
            catch (Exception e) {
                _Logger.warn((Object)"GlobalFabricManager->getUserByFabricPK(): caught exception", (Throwable)e);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricOpened(FabricImpl fabric) {
        this.setFabricManageable(fabric.getPK());
    }

    @Override
    public void fabricClosed(FabricImpl fabric) {
        this.setFabricManageable(fabric.getPK(), false);
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
        this.setFabricManageable(fpk, false);
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void membersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(FabricImpl fabric, PKIf[] pks) {
    }

    @Override
    public void membersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] pks) {
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
    }

    public List<SwitchAssignedLicenseInfo> getLicenseInfoSwitchAssignment() {
        return FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
    }
}

