/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.GroupPersistent;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.SessionEventListenerIf;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GroupManager
implements ModelEventListenerIf,
SessionEventListenerIf {
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private static GroupManager _Instance;
    private ConcurrentHashMap _groupsByPK = new ConcurrentHashMap();
    private ConcurrentHashMap _groupPKsByFabricPK = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ArrayList<GroupPK>> _groupPKsByUser = new ConcurrentHashMap();

    private GroupManager() {
    }

    public static GroupManager getInstance() {
        if (_Instance == null) {
            _Instance = new GroupManager();
            SanManager.addListener(_Instance);
            FMServerImpl.getInstance().addListener(_Instance);
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroup(GroupBase group) {
        if (group == null) {
            return;
        }
        GroupPK groupPK = group.getGroupPK();
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            if (!this._groupsByPK.containsKey(groupPK)) {
                this._groupsByPK.put(groupPK, group);
                FabricPK fabricPK = groupPK.getFabricPK();
                ConcurrentHashMap concurrentHashMap2 = this._groupPKsByFabricPK;
                synchronized (concurrentHashMap2) {
                    ArrayList<GroupPK> al = (ArrayList<GroupPK>)this._groupPKsByFabricPK.get(fabricPK);
                    if (al == null) {
                        al = new ArrayList<GroupPK>();
                        this._groupPKsByFabricPK.put(fabricPK, al);
                    }
                    if (!al.contains(groupPK)) {
                        al.add(groupPK);
                    }
                }
            }
        }
    }

    public GroupBase addGroup(String userName, GroupPK groupPK, boolean persistent) throws Exception {
        if (userName == null || groupPK == null) {
            return null;
        }
        GroupPK[] groupPKs = new GroupPK[]{groupPK};
        GroupBase[] gps = this.addGroup(userName, groupPKs, persistent);
        return gps == null || gps.length == 0 ? null : gps[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] addGroup(String userName, GroupPK[] groupPKs, boolean persistent) throws Exception {
        if (groupPKs == null) {
            return null;
        }
        ArrayList<GroupBase> gps = new ArrayList<GroupBase>();
        ConcurrentHashMap<String, ArrayList<GroupPK>> concurrentHashMap = this._groupPKsByUser;
        synchronized (concurrentHashMap) {
            ArrayList<GroupPK> al = this._groupPKsByUser.get(userName);
            for (int i = 0; i < groupPKs.length; ++i) {
                GroupBase gp;
                GroupBase groupBase = gp = persistent ? this.getGroup(groupPKs[i]) : null;
                if (al == null) {
                    al = new ArrayList();
                    al.add(groupPKs[i]);
                    gps.add(gp);
                    this._groupPKsByUser.put(userName, al);
                }
                if (al.contains(groupPKs[i])) continue;
                al.add(groupPKs[i]);
                gps.add(gp);
            }
        }
        if (!persistent) {
            return null;
        }
        GroupBase[] gpbs = gps.toArray(new GroupBase[gps.size()]);
        if (gpbs != null && gpbs.length > 0) {
            GroupPersistent.getInstance().persistUserGroups(gpbs, userName);
        }
        return gpbs;
    }

    public GroupBase addGroup(GroupPK groupPK, short type, PKIf[] members) throws Exception {
        if (groupPK == null) {
            return null;
        }
        if (this._groupsByPK.containsKey(groupPK)) {
            throw new Exception("Group with the same name already exists");
        }
        FabricPK fabricPK = groupPK.getFabricPK();
        GroupPK[] oldGroupPKs = this.getGroupPKs(fabricPK);
        GroupBase group = new GroupBase(groupPK, type);
        group.setMembers(members);
        this.addGroup(group);
        GroupPK[] newGroupPKs = this.getGroupPKs(fabricPK);
        GroupPersistent.getInstance().persist(group);
        FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
        if (fabric != null) {
            ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)oldGroupPKs, (Serializable)newGroupPKs)};
            SanManager.notifyMembersChanged(fabric, mos);
        }
        return group;
    }

    public void autoConfigureNPVGroups(FabricImpl fImpl) {
        FabricPK fabPK = fImpl.getPK();
        boolean hasChanges = false;
        GroupPK[] gpks = this.getNpvGroupPKs(fabPK);
        GroupPK[] oldGroups = null;
        HashSet<GroupPK> oldGroupPKs = null;
        if (gpks != null && gpks.length > 0) {
            oldGroups = new GroupPK[gpks.length];
            System.arraycopy(gpks, 0, oldGroups, 0, gpks.length);
            oldGroupPKs = new HashSet(gpks.length);
            for (GroupPK pk : gpks) {
                oldGroupPKs.add(pk);
            }
        } else {
            oldGroups = new GroupPK[]{};
            oldGroupPKs = new HashSet<GroupPK>(0);
        }
        ArrayList<GroupPK> newGroups = new ArrayList<GroupPK>();
        SwitchImpl[] sws = fImpl.getSwitches();
        HashSet<PKIf> oldMembers = new HashSet<PKIf>();
        for (SwitchImpl sw : sws) {
            List<NpvLinkImpl> npvls;
            oldMembers.clear();
            if (sw.isNpvEnabled() || (npvls = fImpl.findNpvLinksByCoreSwitch(sw)) == null || npvls.size() == 0) continue;
            GroupPK gPK = new GroupPK(fabPK, "npv-group-" + sw.getSysName());
            GroupBase group = this.getGroup(gPK);
            if (group == null) {
                group = new GroupBase(gPK, 1);
                group.setEditable(false);
                group.addMember(sw.getPK());
                for (NpvLinkImpl npvl : npvls) {
                    if (!npvl.isPresent() || !npvl.getEdgeSwitch().isNpvEnabled()) continue;
                    group.addMember(npvl.getEdgeSwitch().getSwitchPK());
                }
                if (group.numOfMembers() <= 1) continue;
                this.addGroup(group);
                newGroups.add(gPK);
                hasChanges = true;
                continue;
            }
            oldMembers.addAll(group.getMembers());
            group.clearMemebers();
            group.addMember(sw.getPK());
            if (!oldMembers.remove(sw.getPK())) {
                hasChanges = true;
            }
            for (NpvLinkImpl npvl : npvls) {
                if (!npvl.isPresent() || !npvl.getEdgeSwitch().isNpvEnabled()) continue;
                WwnKey npvPK = npvl.getEdgeSwitch().getSwitchPK();
                group.addMember(npvPK);
                if (oldMembers.remove(npvPK)) continue;
                hasChanges = true;
            }
            if (group.numOfMembers() > 1) {
                oldGroupPKs.remove(gPK);
            }
            if (oldMembers.size() <= 0) continue;
            hasChanges = true;
        }
        for (GroupPK pk : oldGroupPKs) {
            try {
                this.removeGroup(pk);
                hasChanges = true;
            }
            catch (Exception e) {
                _Logger.warn((Object)("Cannot remove the non-existing NPV group:" + pk));
            }
        }
        try {
            GroupPersistent.getInstance().persist(fabPK);
        }
        catch (Exception e) {
            _Logger.warn((Object)("Cannot persist NPV groups from fabric:" + fabPK));
        }
        if (hasChanges) {
            ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabPK, 523, (Serializable)oldGroups, (Serializable)newGroups.toArray(new GroupPK[newGroups.size()]))};
            SanManager.notifyMembersChanged(fImpl, mos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase updateGroup(GroupPK groupPK, short type, PKIf[] members) throws Exception {
        if (groupPK == null) {
            return null;
        }
        if (this._groupsByPK.contains(groupPK)) {
            throw new Exception("Group does not exist");
        }
        boolean changed = false;
        GroupBase group = null;
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            group = (GroupBase)this._groupsByPK.get(groupPK);
            if (group != null && !group.getMembers().equals(members)) {
                group.setMembers(members);
                changed = true;
            }
        }
        if (changed) {
            GroupPersistent.getInstance().persist(group);
            FabricPK fabricPK = groupPK.getFabricPK();
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            if (fabric != null) {
                GroupPK[] groupPKs = new GroupPK[]{groupPK};
                ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)groupPKs, (Serializable)groupPKs)};
                SanManager.notifyMembersChanged(fabric, mos);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserGroup(String user, GroupPK[] groups) throws Exception {
        if (user == null) {
            return false;
        }
        if (!this._groupPKsByUser.containsKey(user)) {
            throw new Exception("User does not exist");
        }
        ArrayList<GroupPK> oldGpList = new ArrayList<GroupPK>();
        ArrayList<GroupPK> tmpGpList = this._groupPKsByUser.get(user);
        for (GroupPK tmpGp : tmpGpList) {
            oldGpList.add(tmpGp);
        }
        boolean changed = false;
        boolean added = false;
        ArrayList<GroupPK> newGpList = new ArrayList<GroupPK>();
        if (oldGpList == null && groups != null && groups.length > 0) {
            changed = true;
            added = true;
        }
        for (int i = 0; groups != null && i < groups.length; ++i) {
            newGpList.add(groups[i]);
            if (!oldGpList.contains(groups[i])) {
                changed = true;
                added = true;
                continue;
            }
            oldGpList.remove(groups[i]);
        }
        if (oldGpList != null && oldGpList.size() > 0) {
            changed = true;
        }
        if (changed) {
            ConcurrentHashMap<String, ArrayList<GroupPK>> i = this._groupPKsByUser;
            synchronized (i) {
                this._groupPKsByUser.put(user, newGpList);
            }
        }
        if (oldGpList != null && oldGpList.size() > 0) {
            GroupPK[] gps = oldGpList.toArray(new GroupPK[oldGpList.size()]);
            try {
                this.removeGroup(user, gps);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Cannot remove the non-existing user group:" + user + ":" + gps));
            }
        }
        if (added) {
            GroupBase[] gps = groups == null ? null : new GroupBase[groups.length];
            for (int i = 0; gps != null && i < groups.length; ++i) {
                gps[i] = this.getGroup(groups[i]);
            }
            if (gps != null && gps.length > 0) {
                GroupPersistent.getInstance().persistUserGroups(gps, user);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(FabricPK fabricPK) throws Exception {
        if (fabricPK == null) {
            return;
        }
        ConcurrentHashMap concurrentHashMap = this._groupPKsByFabricPK;
        synchronized (concurrentHashMap) {
            GroupPK[] al;
            ArrayList gplist = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
            GroupPK[] groupPKArray = al = gplist == null ? null : gplist.toArray(new GroupPK[gplist.size()]);
            if (al == null) {
                return;
            }
            for (GroupPK group : al) {
                this.removeGroup(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase removeGroup(GroupPK groupPK) throws Exception {
        FabricPK fabricPK;
        if (groupPK == null) {
            return null;
        }
        GroupBase group = null;
        ArrayList<String> users = new ArrayList<String>();
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            group = (GroupBase)this._groupsByPK.remove(groupPK);
            fabricPK = groupPK.getFabricPK();
            ConcurrentHashMap<String, ArrayList<GroupPK>> concurrentHashMap2 = this._groupPKsByFabricPK;
            synchronized (concurrentHashMap2) {
                ArrayList al = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
                if (al != null) {
                    al.remove(groupPK);
                    if (al.size() == 0) {
                        this._groupPKsByFabricPK.remove(fabricPK);
                    }
                }
            }
            concurrentHashMap2 = this._groupPKsByUser;
            synchronized (concurrentHashMap2) {
                for (String user : this._groupPKsByUser.keySet()) {
                    ArrayList<GroupPK> al = this._groupPKsByUser.get(user);
                    if (al == null || !al.contains(groupPK)) continue;
                    users.add(user);
                    al.remove(groupPK);
                    if (al.size() != 0) continue;
                    this._groupPKsByUser.remove(user);
                }
            }
        }
        if (group != null) {
            GroupPersistent.getInstance().purge(group);
            GroupBase[] gps = new GroupBase[]{group};
            for (String user : users) {
                GroupPersistent.getInstance().purge(user, gps);
            }
            fabricPK = groupPK.getFabricPK();
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            if (fabric != null) {
                GroupPK[] groupPKs = new GroupPK[]{groupPK};
                ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)groupPKs, (Serializable)groupPKs)};
                SanManager.notifyMembersChanged(fabric, mos);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] removeGroup(String user) throws Exception {
        if (user == null) {
            return null;
        }
        ArrayList<GroupPK> groups = null;
        ConcurrentHashMap<String, ArrayList<GroupPK>> concurrentHashMap = this._groupPKsByUser;
        synchronized (concurrentHashMap) {
            groups = this._groupPKsByUser.remove(user);
        }
        if (groups == null) {
            return null;
        }
        GroupPersistent.getInstance().purge(user);
        return groups.toArray(new GroupPK[groups.size()]);
    }

    public GroupPK[] removeGroup(String user, GroupPK[] groups) throws Exception {
        if (user == null || groups == null || groups.length == 0) {
            return null;
        }
        GroupBase[] gps = new GroupBase[groups.length];
        for (int i = 0; i < gps.length; ++i) {
            gps[i] = this.getGroup(groups[i]);
        }
        GroupPersistent.getInstance().purge(user, gps);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase getGroup(GroupPK groupPK) {
        if (groupPK == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return (GroupBase)this._groupsByPK.get(groupPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getGroupPKs() {
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return this._groupsByPK.keySet().toArray(new GroupPK[this._groupsByPK.size()]);
        }
    }

    public GroupBase[] getGroups(String user) {
        GroupPK[] gPKs = this.getGroupPKs(user);
        GroupBase[] gps = gPKs == null ? null : new GroupBase[gPKs.length];
        for (int i = 0; gps != null && i < gPKs.length; ++i) {
            gps[i] = this.getGroup(gPKs[i]);
        }
        return gps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] getGroups() {
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return this._groupsByPK.values().toArray(new GroupBase[this._groupsByPK.size()]);
        }
    }

    public List<PKIf> getAllGroupMembers(FabricPK fabricPK) {
        GroupBase[] grouplist = this.getGroups(fabricPK);
        if (grouplist == null) {
            return new ArrayList<PKIf>();
        }
        HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
        for (int i = 0; i < grouplist.length; ++i) {
            ArrayList<PKIf> memlist = grouplist[i].getMembers();
            for (PKIf pk : memlist) {
                map.put(pk, pk);
            }
        }
        ArrayList<PKIf> ret = new ArrayList<PKIf>();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            ret.add((PKIf)iter.next());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getGroupPKs(FabricPK fabricPK) {
        if (fabricPK == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this._groupPKsByFabricPK;
        synchronized (concurrentHashMap) {
            ArrayList al = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
            if (al == null || al.size() == 0) {
                return null;
            }
            GroupPK[] pks = new GroupPK[al.size()];
            pks = al.toArray(pks);
            return pks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getNpvGroupPKs(FabricPK fabricPK) {
        if (fabricPK == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this._groupPKsByFabricPK;
        synchronized (concurrentHashMap) {
            ArrayList al = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
            if (al == null || al.size() == 0) {
                return null;
            }
            ArrayList<GroupPK> nal = new ArrayList<GroupPK>();
            for (Object gpo : al) {
                GroupPK gp;
                if (gpo == null || (gp = (GroupPK)gpo).getName() == null || !gp.getName().startsWith("npv-group-")) continue;
                nal.add(gp);
            }
            GroupPK[] pks = new GroupPK[nal.size()];
            pks = nal.toArray(pks);
            return pks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getGroupPKs(String user) {
        if (user == null) {
            return null;
        }
        ConcurrentHashMap<String, ArrayList<GroupPK>> concurrentHashMap = this._groupPKsByUser;
        synchronized (concurrentHashMap) {
            ArrayList<GroupPK> al = this._groupPKsByUser.get(user);
            if (al == null || al.size() == 0) {
                return null;
            }
            GroupPK[] pks = new GroupPK[al.size()];
            pks = al.toArray(pks);
            return pks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] getGroups(FabricPK fabricPK, String user) {
        if (user == null) {
            return null;
        }
        ConcurrentHashMap<String, ArrayList<GroupPK>> concurrentHashMap = this._groupPKsByUser;
        synchronized (concurrentHashMap) {
            ArrayList<GroupPK> al = this._groupPKsByUser.get(user);
            if (al == null || al.size() == 0) {
                return null;
            }
            ArrayList<GroupBase> gps = new ArrayList<GroupBase>();
            for (GroupPK gp : al) {
                if (gp.getFabricPK() == null || !gp.getFabricPK().equals(fabricPK)) continue;
                gps.add(this.getGroup(gp));
            }
            GroupBase[] pks = new GroupBase[gps.size()];
            pks = gps.toArray(pks);
            return pks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getUnAssignedGroupPKs(String user) {
        Object v2;
        if (user == null) {
            return null;
        }
        ArrayList<GroupPK> resultList = new ArrayList<GroupPK>();
        Collection cl = this._groupPKsByFabricPK.values();
        for (Object v2 : cl) {
            ArrayList gpks = (ArrayList)v2;
            if (gpks == null) continue;
            for (GroupPK gpk : gpks) {
                GroupBase gp = this.getGroup(gpk);
                if (gp == null || gp.getType() != 1) continue;
                resultList.add(gpk);
            }
        }
        ArrayList<GroupPK> al = null;
        v2 = this._groupPKsByUser;
        synchronized (v2) {
            al = this._groupPKsByUser.get(user);
        }
        if (al != null) {
            resultList.removeAll(al);
        }
        GroupPK[] pks = new GroupPK[resultList.size()];
        pks = resultList.toArray(pks);
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] getGroups(FabricPK fabricPK) {
        GroupPK[] groupPKs = this.getGroupPKs(fabricPK);
        if (groupPKs == null || groupPKs.length == 0) {
            return null;
        }
        GroupBase[] groups = new GroupBase[groupPKs.length];
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            for (int i = 0; i < groupPKs.length; ++i) {
                groups[i] = (GroupBase)this._groupsByPK.get(groupPKs[i]);
            }
        }
        return groups;
    }

    @Override
    public void fabricOpened(FabricImpl fabric) {
        try {
            this.loadGroupsFromDB(fabric);
            _Logger.info((Object)("loaded groups for fabric: " + fabric));
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Error loading groups for fabric: " + fabric + ": " + ex.getMessage()));
        }
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void membersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(FabricImpl fabric, PKIf[] pks) {
    }

    @Override
    public void membersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] pks) {
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    @Override
    public void sessionClosed(String sessionId) {
    }

    @Override
    public void sessionOpened(String sessionId) {
        SessionId sid = new SessionId(sessionId);
        Thread otherThread = new Thread(sid);
        otherThread.start();
    }

    public void loadGroupsFromDB(FabricImpl fabric) throws Exception {
        ArrayList groups = GroupPersistent.getInstance().reload(fabric);
        if (groups != null && groups.size() > 0) {
            for (int i = 0; i < groups.size(); ++i) {
                this.addGroup((GroupBase)groups.get(i));
            }
        }
    }

    public void loadGroupsFromDB() throws Exception {
        this._groupsByPK.clear();
        this._groupPKsByFabricPK.clear();
        this._groupPKsByUser.clear();
        ArrayList groups = GroupPersistent.getInstance().reloadAllGroups();
        if (groups != null && groups.size() > 0) {
            for (int i = 0; i < groups.size(); ++i) {
                this.addGroup((GroupBase)groups.get(i));
            }
        }
        GroupPersistent.getInstance().reloadUserGroups(groups);
    }

    class SessionId
    implements Runnable {
        String _sessionId = null;

        public SessionId(String sessionId) {
            this._sessionId = sessionId;
        }

        @Override
        public void run() {
            try {
                SessionRif session = FMServerImpl.getInstance().findSession(Integer.parseInt(this._sessionId));
                FMUser fUser = session.getUser();
                GroupManager.this.loadGroupsFromDB();
                _Logger.info((Object)"loaded all groups");
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Error loading user groups : " + this._sessionId + ": " + ex));
                ex.printStackTrace();
            }
        }
    }
}

