/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.discovery.LanHostWorker;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostMapImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HostManager {
    static Logger logger = LogManager.getLogger((String)"fms.model");
    private static HostManager instance;
    public static final String QueryEndPortWwnsByEncIdSQL = "select wwn from end_port where enclosure_id=?";
    public static final String QueryEnclosureIdByNameSQL = "select id from enclosure where name=?";
    public static final String QueryEthSwitchIdSQL = "select id from ethswitch";
    public static final String DeleteEnclosureSQL = "delete from enclosure where id=?";
    public static final String DeleteEndPortSQL = "delete from end_port where enclosure_id=?";
    public static final String DeleteInvalidVhostMapSQL = "delete from host_map m where m.vhost_id > 0 and m.vhost_id not in (select id from vhost)";
    private Thread lanHostWorker;
    private List<Thread> workers = new ArrayList<Thread>();
    private long lanHostStartTime = 0L;

    public static synchronized HostManager getInstance() {
        if (instance == null) {
            instance = new HostManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Wwn> getPortWwnByEnclosureId(Connection con, long id) {
        ResultSet rs;
        PreparedStatement stat;
        ArrayList<Wwn> results;
        block5: {
            results = new ArrayList<Wwn>();
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QueryEndPortWwnsByEncIdSQL);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    Wwn wwn = new Wwn(rs.getBytes(1));
                    results.add(wwn);
                }
            }
            catch (Exception ex) {
                try {
                    logger.log((Priority)Level.ERROR, (Object)"getPortWwnByEnclosureId caught exception", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(stat);
                    DbUtil.close(rs);
                    throw throwable;
                }
                DbUtil.close(stat);
                DbUtil.close(rs);
            }
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long gettEnclosureIdByName(String name) {
        long result = -1L;
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            result = this.gettEnclosureIdByName(con, name);
        }
        catch (Exception ex) {
            logger.log((Priority)Level.ERROR, (Object)"gettEnclosureIdByName caught exception", (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long gettEnclosureIdByName(Connection con, String name) {
        ResultSet rs;
        PreparedStatement stat;
        long result;
        block5: {
            result = -1L;
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QueryEnclosureIdByNameSQL);
                stat.setString(1, name);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    result = rs.getLong(1);
                }
            }
            catch (Exception ex) {
                try {
                    logger.log((Priority)Level.ERROR, (Object)"gettEnclosureIdByName caught exception", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(stat);
                    DbUtil.close(rs);
                    throw throwable;
                }
                DbUtil.close(stat);
                DbUtil.close(rs);
            }
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostImpl getHostById(long id) {
        Connection con = null;
        HostImpl host = null;
        try {
            con = ConnectionManager.getConnection();
            host = this.getHostById(con, id);
        }
        catch (Exception ex) {
            logger.log((Priority)Level.ERROR, (Object)"getHostById caught exception", (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostImpl getHostById(Connection con, long id) {
        AbstractDBObjectImpl host;
        block7: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                stat = con.prepareStatement("select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where id=?");
                stat.setLong(1, id);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                }
                if (host != null) {
                    ((HostImpl)host).setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                logger.log((Priority)Level.ERROR, (Object)"getHostById caught exception", (Throwable)ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    public void renameHost(long id, String name) throws Exception {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            HostImpl host = this.getHostById(con, id);
            if (host == null) {
                throw new Exception("Invalid host ID");
            }
            if (host.isVhost()) {
                throw new Exception("Cannot rename virtual host");
            }
            SanManager san = SanManager.getInstance();
            if (name == null || name.length() == 0) {
                if (host.getHostMaps() != null && !host.getHostMaps().isEmpty()) {
                    for (HostMapImpl m : host.getHostMaps()) {
                        if (m.getEnclosureId() > 0L) {
                            List<Wwn> wwns = HostManager.getPortWwnByEnclosureId(con, m.getEnclosureId());
                            if (wwns == null || wwns.isEmpty()) continue;
                            for (Wwn w : wwns) {
                                EndPortImpl ep = san.findEndPort(w);
                                san.updateEndPortEnclosure(ep.getFabricPK(), ep.getEndPortPK(), null);
                            }
                            continue;
                        }
                        if (m.getLanHostId() <= 0L) continue;
                        LanHostImpl.deleteLanHost(con, m.getLanHostId());
                    }
                }
                HostImpl.deleteHost(con, host);
                return;
            }
            HostImpl hostByName = HostImpl.getHostByName(con, name);
            if (hostByName != null && hostByName.getDBID() != host.getDBID()) {
                hostByName.getHostMaps().addAll(host.getHostMaps());
                hostByName.setUserModified(true);
                HostImpl.persistHost(con, hostByName);
                HostImpl.deleteHost(con, host);
                host = hostByName;
            } else {
                host.setName(name);
                host.setUserModified(true);
                HostImpl.persistHost(con, host);
            }
            if (host.getHostMaps() != null) {
                ArrayList<HostMapImpl> hostMaps = new ArrayList<HostMapImpl>();
                ArrayList<Long> encIds = new ArrayList<Long>();
                for (HostMapImpl m : host.getHostMaps()) {
                    if (m.getLanHostId() > 0L) {
                        LanHostImpl lh = HostManager.getLanHostById(con, m.getLanHostId());
                        if (lh != null) {
                            lh.setName(name);
                            LanHostImpl.persistLanHost(con, lh);
                        }
                        hostMaps.add(m);
                        continue;
                    }
                    if (m.getEnclosureId() <= 0L) continue;
                    EndPortImpl ep = null;
                    List<Wwn> wwns = HostManager.getPortWwnByEnclosureId(con, m.getEnclosureId());
                    if (wwns != null && !wwns.isEmpty()) {
                        for (Wwn pwwn : wwns) {
                            ep = san.findEndPort(pwwn);
                            san.updateEndPortEnclosure(ep.getFabricPK(), ep.getEndPortPK(), new NameKey(name));
                            ep = san.findEndPort(pwwn);
                        }
                    }
                    HostMapImpl.deleteHostMap(con, m);
                    if (ep == null || encIds.contains(ep.getEnclosure().getDBID())) continue;
                    encIds.add(ep.getEnclosure().getDBID());
                    hostMaps.add(new HostMapImpl(host.getDBID(), ep.getEnclosure().getDBID(), 0L, 0L));
                }
                HostMapImpl.persistHostMaps(con, hostMaps);
            }
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"renameHost caught exception", (Throwable)e);
            throw e;
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanHostImpl getLanHostById(long id) {
        LanHostImpl lhost = null;
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            lhost = HostManager.getLanHostById(con, id);
        }
        catch (SQLException ex) {
            logger.log((Priority)Level.ERROR, (Object)"getLanHostById caught exception", (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
        return lhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanHostImpl getLanHostById(Connection con, long id) {
        LanHostImpl lhost;
        block6: {
            lhost = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement("select id, name, description, mac, eth_switch_id, eth_ifname, ipaddress, ethswitch_port_id, vlan, vhost_id, created_time, last_updated_time from lan_host where id=?");
                stat.setLong(1, id);
                rs = stat.executeQuery();
                List<LanHostImpl> hosts = LanHostImpl.loadLanHostDBRecord(rs);
                if (hosts != null && !hosts.isEmpty()) {
                    lhost = hosts.get(0);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                logger.log((Priority)Level.ERROR, (Object)"getLanHostById caught exception", (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return lhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupSanHosts() {
        Connection con = null;
        try {
            long startTime = System.currentTimeMillis();
            con = ConnectionManager.getConnection();
            Map<Long, HostImpl> hosts = HostImpl.getSanHosts(con);
            Set<Long> encIds = HostImpl.getSanHostIds(con);
            ArrayList<HostImpl> deleteHosts = new ArrayList<HostImpl>();
            ArrayList<HostMapImpl> deleteHostMaps = new ArrayList<HostMapImpl>();
            logger.log((Priority)Level.DEBUG, (Object)("enclosureIds in Host table: " + hosts.keySet()));
            for (Long i : hosts.keySet()) {
                if (encIds == null || encIds.contains(i)) continue;
                HostImpl h = hosts.get(i);
                if (h.getHostMaps().size() <= 1) {
                    logger.log((Priority)Level.DEBUG, (Object)("deleting host: " + h.getDBID()));
                    deleteHosts.add(h);
                    continue;
                }
                List<HostMapImpl> hostMaps = h.getHostMaps();
                if (hostMaps == null) continue;
                for (HostMapImpl m : hostMaps) {
                    if (m.getEnclosureId() != i.longValue()) continue;
                    deleteHostMaps.add(m);
                }
            }
            List<HostMapImpl> hostMaps = HostMapImpl.getSanHostMaps(con);
            if (hostMaps != null) {
                for (HostMapImpl m : hostMaps) {
                    if (HostImpl.getHostBySanHostIdFromDB(con, m.getEnclosureId()) != null) continue;
                    deleteHostMaps.add(m);
                }
            }
            if (!deleteHostMaps.isEmpty()) {
                HostMapImpl.deleteHostMaps(con, deleteHostMaps);
            }
            if (!deleteHosts.isEmpty()) {
                HostImpl.deleteHosts(con, deleteHosts);
            }
            logger.info((Object)("cleanupSanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted:" + deleteHosts.size()));
            HostImpl.cleanupHosts(con);
        }
        catch (SQLException e) {
            logger.log((Priority)Level.WARN, (Object)"cleanupSanHosts caught exception", (Throwable)e);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistEnclosureHosts(long fId) {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp current = new Timestamp(System.currentTimeMillis());
            List<HostImpl> enclosures = HostImpl.loadEnclosuresByFabricIdFromDB(con, fId);
            List<HostImpl> sanHosts = HostImpl.loadSanHostsFromDB(con);
            HashMap<Long, HostImpl> encIdMap = new HashMap<Long, HostImpl>();
            if (sanHosts != null) {
                for (HostImpl h : sanHosts) {
                    h.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, h.getDBID()));
                    encIdMap.put(h.getEnclosureId(), h);
                }
            }
            ArrayList<HostImpl> updateHosts = new ArrayList<HostImpl>();
            if (enclosures != null) {
                for (HostImpl h : enclosures) {
                    HostImpl host = (HostImpl)encIdMap.get(h.getEnclosureId());
                    if (host == null) {
                        host = new HostImpl(h.getName());
                        host.checkPreexistRecord(con);
                        host.setEnclosureId(h.getEnclosureId());
                        host.addHostMap(new HostMapImpl(0L, h.getEnclosureId(), 0L, 0L));
                        HostImpl.persistHost(con, host);
                        logger.log((Priority)Level.DEBUG, (Object)("adding enclosure: " + h));
                    }
                    if (host == null) continue;
                    boolean exist = false;
                    for (HostMapImpl m : host.getHostMaps()) {
                        if (m.getEnclosureId() != h.getEnclosureId()) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        host.addHostMap(new HostMapImpl(h.getDBID(), h.getEnclosureId(), 0L, 0L));
                    }
                    if (!host.isUserModified() && host.getName().equalsIgnoreCase(h.getName())) {
                        host.setName(h.getName());
                    }
                    if (h.getVhostId() > 0L) {
                        host.setVhostId(h.getVhostId());
                    }
                    host.setData(con);
                    updateHosts.add(host);
                    logger.log((Priority)Level.DEBUG, (Object)("updating enclosure: " + h));
                }
            }
            if (updateHosts.size() > 0) {
                HostImpl.persistHosts(con, updateHosts);
                logger.log((Priority)Level.INFO, (Object)("persistEnclosureHosts finished in " + (System.currentTimeMillis() - current.getTime()) + "ms, updated: " + updateHosts.size()));
            }
            HostImpl.deleteOldSanHosts(con);
        }
        catch (SQLException e) {
            logger.log((Priority)Level.WARN, (Object)"persistEnclosureHosts caught exception", (Throwable)e);
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void startLanHostWorker(LanImpl lan, List<EthSwitchImpl> sws) {
        if (this.lanHostWorker == null || !this.lanHostWorker.isAlive()) {
            for (Thread w : this.workers) {
                if (w == null || !w.isAlive()) continue;
                w.interrupt();
                logger.info((Object)("interrupt thread '" + w.getName() + "'"));
            }
            this.workers.clear();
            this.lanHostWorker = new Thread(null, new LanHostWorker(lan, sws), "LanHostWorker");
            this.lanHostWorker.start();
            this.lanHostStartTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lanHostStartTime > 3600000L) {
            for (Thread w : this.workers) {
                if (w == null || !w.isAlive()) continue;
                w.interrupt();
                logger.info((Object)("interrupt thread '" + w.getName() + "'"));
            }
            this.workers.clear();
            this.lanHostWorker.interrupt();
            boolean isInterrupted = this.lanHostWorker.isInterrupted();
            logger.info((Object)("startLanHostWorker: isInterrupted=" + isInterrupted));
            this.lanHostStartTime = 0L;
        }
    }

    public void stopLanHostWorker() {
        if (this.lanHostWorker != null && this.lanHostWorker.isAlive()) {
            this.lanHostWorker.interrupt();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.lanHostWorker.isAlive()) {
                this.lanHostWorker = null;
            }
        }
        if (this.workers != null) {
            for (Thread w : this.workers) {
                if (w == null || !w.isAlive()) continue;
                w.interrupt();
                logger.info((Object)("interrupt thread '" + w.getName() + "'"));
            }
            this.workers.clear();
        }
    }

    public Thread getLanHostWorker() {
        return this.lanHostWorker;
    }

    public void setLanHostWorker(Thread lanHostWorker) {
        this.lanHostWorker = lanHostWorker;
    }

    public List<Thread> getWorkers() {
        return this.workers;
    }

    public void setWorkers(List<Thread> workers) {
        this.workers = workers;
    }

    public void createLanHosts(EthSwitchImpl sw, List<LanHostImpl> hosts) {
        Thread createLanHost = new Thread(null, new CreateLanHostWorker(sw, hosts), "CreateLanHost-" + sw.getIpAddress());
        createLanHost.start();
        this.workers.add(createLanHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldVHosts() {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            this.deleteOldVHosts(con);
        }
        catch (Exception ex) {
            logger.log((Priority)Level.ERROR, (Object)"deleteOldVHosts caught exception", (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldVHosts(Connection con) {
        try {
            long startTime = System.currentTimeMillis();
            PreparedStatement stat = null;
            try {
                stat = con.prepareStatement(DeleteInvalidVhostMapSQL);
                stat.execute();
            }
            catch (SQLException ex) {
                logger.log((Priority)Level.ERROR, (Object)"deleteOldVHosts failed. ", (Throwable)ex);
            }
            finally {
                DbUtil.close(stat);
            }
            if ((SanManager.getInstance().getFabrics() == null || SanManager.getInstance().getFabrics().length == 0) && DCManager.getInstance().getNumEthSwitches() == 0) {
                HostImpl.cleanupHosts(con);
            }
            logger.info((Object)("deleteOldVHosts finished in " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        catch (Exception ex) {
            logger.log((Priority)Level.ERROR, (Object)"deleteOldVHosts caught exception", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistVhostHosts() {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            long startTime = System.currentTimeMillis();
            List<HostImpl> vhosts = HostImpl.loadVHostsFromDB(con);
            List<HostImpl> hosts = HostImpl.loadVHostHostsFromDB(con);
            HashMap<String, HostImpl> hostnameMap = new HashMap<String, HostImpl>();
            if (hosts != null) {
                for (HostImpl h : hosts) {
                    h.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, h.getDBID()));
                    hostnameMap.put(h.getName(), h);
                }
            }
            ArrayList<HostImpl> updateHosts = new ArrayList<HostImpl>();
            if (vhosts != null) {
                for (HostImpl h : vhosts) {
                    HostImpl host = (HostImpl)hostnameMap.get(h.getName());
                    if (host == null) {
                        host = new HostImpl(h.getName());
                        host.setVhostId(h.getVhostId());
                        host.addHostMap(new HostMapImpl(0L, 0L, h.getVhostId(), 0L));
                        host.checkPreexistRecord(con);
                        HostImpl.persistHost(con, host);
                        logger.log((Priority)Level.DEBUG, (Object)("adding vhost: " + h));
                    }
                    if (host == null) continue;
                    boolean exist = false;
                    for (HostMapImpl m : host.getHostMaps()) {
                        if (m.getVhostId() != h.getVhostId()) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        host.addHostMap(new HostMapImpl(h.getDBID(), 0L, h.getVhostId(), 0L));
                    }
                    host.setData(con);
                    updateHosts.add(host);
                    logger.log((Priority)Level.DEBUG, (Object)("updating vhost: " + h));
                }
            }
            if (updateHosts.size() > 0) {
                HostImpl.persistHosts(con, updateHosts);
                logger.log((Priority)Level.INFO, (Object)("persistVhostHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, updated: " + updateHosts.size()));
            }
            this.deleteOldVHosts(con);
        }
        catch (SQLException e) {
            logger.log((Priority)Level.WARN, (Object)"persistVHostHosts caught exception", (Throwable)e);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMacAddressExist(LanHostImpl h) {
        boolean result;
        block11: {
            if (h == null || h.getMac() == null) {
                return true;
            }
            result = false;
            Connection con = null;
            PreparedStatement queryStat = null;
            ResultSet rs = null;
            try {
                long count;
                con = ConnectionManager.getConnection();
                queryStat = con.prepareStatement("select count(*) from phynic p where upper(p.mac)=?");
                queryStat.setString(1, h.getMac().toUpperCase());
                rs = queryStat.executeQuery();
                if (rs != null && rs.next() && (count = rs.getLong(1)) > 0L) {
                    logger.log((Priority)Level.DEBUG, (Object)("ACS MAC address '" + h.getMac() + "' is the same as one of the VHosts"));
                    result = true;
                }
                if (!result) {
                    DbUtil.close(rs);
                    DbUtil.close(queryStat);
                    queryStat = con.prepareStatement("select count(*) from vnic v where upper(v.mac)=?");
                    queryStat.setString(1, h.getMac().toUpperCase());
                    rs = queryStat.executeQuery();
                    if (rs != null && rs.next() && (count = rs.getLong(1)) > 0L) {
                        logger.log((Priority)Level.DEBUG, (Object)("ACS MAC address '" + h.getMac() + "' is the same as one of the VHosts"));
                        result = true;
                    }
                }
                if (!result) {
                    long count2;
                    DbUtil.close(rs);
                    DbUtil.close(queryStat);
                    queryStat = con.prepareStatement("select count(*) from vhost v where upper(v.mac_address) like ?");
                    String mac = "%" + h.getMac().toUpperCase() + "%";
                    queryStat.setString(1, mac);
                    rs = queryStat.executeQuery();
                    if (rs != null && rs.next() && (count2 = rs.getLong(1)) > 0L) {
                        logger.log((Priority)Level.DEBUG, (Object)("ACS MAC address '" + h.getMac() + "' is the same as one of the VHosts"));
                        result = true;
                    }
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                logger.log((Priority)Level.WARN, (Object)"Load hosts from DB failed", (Throwable)ex);
                break block11;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                DbUtil.close(con);
            }
            DbUtil.close(queryStat);
            DbUtil.close(con);
        }
        return result;
    }

    public static String formatIPV4MacAddr(String mac) {
        if (mac == null) {
            return mac;
        }
        if (mac.trim().length() != 14) {
            return mac;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(mac, ".");
        while (tokenizer.hasMoreElements()) {
            String t;
            if (!sb.toString().isEmpty()) {
                sb.append(":");
            }
            if ((t = tokenizer.nextToken()).length() != 4) {
                return mac;
            }
            sb.append(t.substring(0, 2)).append(":").append(t.substring(2, t.length()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getEthSwitchId() {
        ResultSet rs;
        PreparedStatement queryStat;
        Connection con;
        ArrayList<Long> result;
        block5: {
            result = new ArrayList<Long>();
            con = null;
            queryStat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                queryStat = con.prepareStatement(QueryEthSwitchIdSQL);
                rs = queryStat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    result.add(rs.getLong(1));
                }
            }
            catch (Exception ex) {
                try {
                    logger.log((Priority)Level.WARN, (Object)"loadSanHostsFromDB failed", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(queryStat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        DbUtil.close(con);
        return result;
    }

    private class CreateLanHostWorker
    implements Runnable {
        private Connection con = null;
        private EthSwitchImpl sw;
        private List<LanHostImpl> lanHosts = null;

        public CreateLanHostWorker(EthSwitchImpl sw, List<LanHostImpl> hosts) {
            this.sw = sw;
            this.lanHosts = hosts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.con = ConnectionManager.getConnection();
                LanHostImpl.persistLanHosts(this.con, this.lanHosts);
                logger.log((Priority)Level.INFO, (Object)("persisted LAN hosts for switch '" + this.sw.getIpAddress() + "': " + this.lanHosts.size()));
                LanHostImpl.createHostsFromLanHosts(this.con, this.sw.getDBID());
            }
            catch (SQLException e) {
                logger.warn((Object)("createLanHosts for sw='" + this.sw.getName() + "' failed"), (Throwable)e);
            }
            finally {
                DbUtil.close(this.con);
            }
        }
    }
}

